(* ************************************************************************* *)
(* *****                                                               ***** *)
(* *****  FeynRules model file: vector_LQ                              ***** *)
(* *****  Authors: M. Baker, J. Fuentes-Martin, M. König, G. Isidori   ***** *)
(* *****                                                               ***** *)
(* ************************************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "vector_LQ";

M$Information = {Authors      -> {"M. Baker", "J. Fuentes-Martin", "M. Koenig", "G. Isidori"},
                 Version      -> "1.1",
                 Date         -> "07.04.2021",
                 Institutions -> {"U. Zurich", "Johannes Gutenberg University Mainz"},
                 Emails       -> {"baker@physik.uzh.ch", "jfuentes@uni-mainz.de", "matthias.koenig@tum.de", "isidori@physik.uzh.ch"}
              };
              
(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* v1.1: Fixed bug with vector leptoquark covariant derivative.             *)

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)

M$InteractionOrderHierarchy = { {QCD,1}, {NP,1}, {QED,2} };


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)

M$ClassesDescription = {
  (* Physical leptoquark field *)
  V[5] == {
    ClassName        -> VLQ,
    SelfConjugate    -> False,
    QuantumNumbers   -> {Q -> 2/3, LeptonNumber -> -1},
    Indices          -> {Index[Colour]},
    Mass             -> {MVLQ, 3000},
    Width            -> {WVLQ, 600},
    ParticleName     -> "VLQ",
    PDG              -> 42,
    PropagatorLabel  -> "VLQ",
    PropagatorType   -> Sine,
    PropagatorArrow  -> None,
    FullName         -> "Vector leptoquark U1"
  },
  (* Unphysical leptoquark field (needed to get the right covariant derivative) *)
  V[13] == {
    ClassName        -> U,
    Unphysical       -> True,
    SelfConjugate    -> False,
    QuantumNumbers   -> {Y -> 2/3},
    Indices          -> {Index[Colour]},
    Definitions      -> {U[mu_,cc_] -> VLQ[mu,cc]}
  }
};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
(* External Parameters *)
  gU == {
	ParameterType    -> External,
	Value            -> 3.0,
	InteractionOrder -> {NP,1}, 
	TeX              -> Subscript[g,U],
	BlockName        -> NPLQCOUP,
    OrderBlock       -> 1,
	Description      -> "Overall LQ coupling strength"
  },

  betaL33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Beta],L],33],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 2,
    Description      -> "LQ LH b tau coupling"
  },

  betaRd33 == {
    ParameterType    -> External,
    Value            -> 1.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Beta],R],33],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 3,
    Description      -> "LQ RH b tau coupling"
  },

  betaL23 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Beta],L],23],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 4,
    Description      -> "LQ LH s tau coupling"
  },

  betaL32 == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[Superscript[\[Beta],L],32],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 5,
    Description      -> "LQ LH b mu coupling"
   },

  kappaU == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Kappa],U],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 6,
    Description      -> "Non-minimal LQ coupling to gluons"
  },

  kappaUtilde == {
    ParameterType    -> External,
    Value            -> 0.0,
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[OverTilde[\[Kappa]],U],
    BlockName        -> NPLQCOUP,
    OrderBlock       -> 7,
    Description      -> "Non-minimal LQ coupling to B gauge boson"
  },

  (* Internal Parameters *)
  betaL == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {betaL[1, 2] :> 0, betaL[i_?NumericQ, 1] :> 0, betaL[2,2] -> 0},
    Value            -> {
                                                betaL[1,3] -> Conjugate[newCKM[3,1]/newCKM[3,2]]*betaL23,
                                                betaL[2,3] -> betaL23,
                         betaL[3,2] -> betaL32, betaL[3,3] -> betaL33
                        },
    InteractionOrder -> {NP,0},
    TeX              -> Subscript[\[Beta],L],
    Description      -> "LQ LH coupling matrix"
  },

  betaRd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {betaRd[1, j_?NumericQ] :> 0, betaRd[i_?NumericQ, 1] :> 0, betaRd[2,i_?NumericQ] :> 0, betaRd[i_?NumericQ,2] :> 0 },
    Value            -> {betaRd[3,3] -> betaRd33},
    InteractionOrder -> {NP,0},
    TeX -> Subscript[\[Beta],Rd],
    Description -> "LQ RH down-type coupling matrix"
  },

  (* N. B. : Inputs from UTFit NP fit 2018 *)
  newCKM == {
             ParameterType -> Internal,
             Unitary       -> True,
             Indices       -> {Index[Generation], Index[Generation]},
             Value         -> {newCKM[1,1] -> 0.97431,                         newCKM[1,2] -> 0.22514,                          newCKM[1,3] -> 0.00371  * Exp[-68.8*I*Pi/180],
                               newCKM[2,1] -> -0.22504 * Exp[0.0341*I*Pi/180], newCKM[2,2] -> 0.97353 * Exp[-0.00182*I*Pi/180], newCKM[2,3] -> 0.0397,
                               newCKM[3,1] -> 0.00837  * Exp[-23.6*I*Pi/180],  newCKM[3,2] -> -0.0390 * Exp[1.137*I*Pi/180],    newCKM[3,3] -> 0.999200},
             TeX         -> Superscript[V,CKM'],
             Description -> "CKM-Matrix with 1-3 and 2-3 mixing"
  }
};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LVLQKin := Block[{mu,nu,cc1}, - 1/2 * (DC[Ubar[mu,cc1], nu] - DC[Ubar[nu,cc1], mu]) * (DC[U[mu,cc1], nu] - DC[U[nu,cc1], mu]) ];

LVLQF :=  Block[{ff1,ff2,ff3,s1,s2,s3,cc1,mu},
                 gU/(Sqrt[2]) * VLQ[mu,cc1] *
                 (
                   betaL[ff1,ff2]  * newCKM[ff3,ff1] * uqbar[s1,ff3,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] * vl[s3,ff2] +
                   betaL[ff1,ff2]  * dqbar[s1,ff1,cc1] * Ga[mu,s1,s2] * ProjM[s2,s3] *  l[s3,ff2] +
                   betaRd[ff1,ff2] * dqbar[s1,ff1,cc1] * Ga[mu,s1,s2] * ProjP[s2,s3] *  l[s3,ff2]
                 )
          ];

LVLQG :=  Block[{cc1,cc2,aa1,mu,nu},
               - I * gs * (1 - kappaU) * Ubar[mu,cc1] * T[aa1,cc1,cc2] * U[nu,cc2] * FS[G,mu,nu,aa1] - I * 2/3 * g1 * (1 - kappaUtilde) * Ubar[mu,cc1] * U[nu,cc1] * FS[B,mu,nu]
          ];

LVLQ := LVLQKin + LVLQF + HC[LVLQF] + LVLQG;
