(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    155772,       3051]
NotebookOptionsPosition[    150020,       2882]
NotebookOutlinePosition[    150397,       2899]
CellTagsIndexPosition[    150354,       2896]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7638865422974358`*^9, 3.763886542860983*^9}, {
  3.767372147789777*^9, 3.7673721483716993`*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.518892288721245*^9, 3.518892291440427*^9}, {
  3.648272586359296*^9, 3.648272589589151*^9}, {3.744951163067635*^9, 
  3.744951164882929*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FR$Parallel", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Work/tools/FeynRules/trunk/feynrules-development\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<LQDM.fr\>\""}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.715342142509688*^9, 3.715342163031452*^9}, {
   3.715344057238492*^9, 3.715344058291609*^9}, {3.7178506900799713`*^9, 
   3.717850690973333*^9}, {3.7180002809816017`*^9, 3.718000300883692*^9}, {
   3.718000394980835*^9, 3.7180003951009827`*^9}, {3.745153113604156*^9, 
   3.745153113886346*^9}, {3.757403422964182*^9, 3.757403423697225*^9}, {
   3.758251145793989*^9, 3.7582511468706083`*^9}, 3.7582513470889874`*^9, {
   3.76335111930016*^9, 3.763351139093457*^9}, {3.7633511693483973`*^9, 
   3.763351173687544*^9}, {3.763886545633397*^9, 3.763886571907737*^9}, 
   3.767099220292862*^9, {3.767374514400957*^9, 3.767374515454331*^9}, {
   3.767375022418717*^9, 3.76737502255937*^9}, {3.7674580186709423`*^9, 
   3.767458019546134*^9}, {3.767610478088133*^9, 3.767610507175609*^9}, {
   3.767610538533186*^9, 3.76761053951677*^9}, {3.767610603703107*^9, 
   3.7676106297846937`*^9}, {3.7676900131323767`*^9, 
   3.7676900151887627`*^9}, {3.76858524470041*^9, 3.768585245204138*^9}, {
   3.77027747721585*^9, 3.7702775056436033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033447186*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.4.68\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"20 September 2018\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.4.68", " (" "20 September 2018", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.7706040334601173`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033472262*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.7706040334847107`*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033496011*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921;\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.77060403350665*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033517219*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033527692*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033538237*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033548656*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033559252*^9}],

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.7706040336714993`*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033682289*^9}],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.7706040336930323`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.1\"\>"}],
  SequenceForm["Model Version: ", "1.1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033704124*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033715035*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033725789*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.7706040337363977`*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.7706040337477083`*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033820724*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033831724*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"LQDM\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "LQDM", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7633511741608467`*^9, {3.763886551320196*^9, 3.763886593647153*^9}, {
   3.763887644836206*^9, 3.763887662963044*^9}, 3.763887696286619*^9, {
   3.763889955500156*^9, 3.763889972075794*^9}, {3.763890011302863*^9, 
   3.7638900877135344`*^9}, {3.763890125481699*^9, 3.763890151718961*^9}, {
   3.763894287554513*^9, 3.7638943042123537`*^9}, 3.763894730165145*^9, 
   3.76389977099585*^9, {3.763902743598042*^9, 3.763902761435525*^9}, 
   3.7639029494171886`*^9, 3.7639031001270113`*^9, 3.76391164442563*^9, 
   3.763911688249847*^9, 3.763914825725705*^9, {3.763914877406178*^9, 
   3.7639148942794313`*^9}, 3.763914930505686*^9, 3.763915073159586*^9, {
   3.763915545611127*^9, 3.763915559708323*^9}, 3.763915835248643*^9, 
   3.763916091693754*^9, 3.7639162886032143`*^9, 3.76391690348344*^9, 
   3.7639181801805*^9, 3.7639254506687107`*^9, 3.764090371202989*^9, 
   3.766534614464355*^9, 3.766534653711507*^9, 3.766537177752035*^9, 
   3.7665372265746107`*^9, 3.766538864784354*^9, 3.766539649745009*^9, 
   3.76654298450668*^9, 3.766547508593896*^9, 3.766550070876625*^9, 
   3.766550770097334*^9, 3.7665518436861687`*^9, 3.76655188420113*^9, 
   3.766552018376792*^9, 3.7665521944782677`*^9, 3.7665522584542*^9, 
   3.766552683736445*^9, 3.7665527638957357`*^9, 3.76655325772733*^9, 
   3.7665539419843893`*^9, 3.766554795650752*^9, 3.766554842357642*^9, 
   3.766555022858425*^9, 3.76662941284862*^9, 3.76662947902567*^9, 
   3.766629878223703*^9, 3.7666327736190968`*^9, 3.766632833335086*^9, 
   3.766632948938819*^9, {3.766659352317868*^9, 3.766659381964011*^9}, 
   3.766659448266522*^9, 3.766659587961876*^9, 3.7666598769548063`*^9, 
   3.766746436604844*^9, 3.766783552335511*^9, 3.766783642575282*^9, {
   3.766783869077875*^9, 3.7667838913274508`*^9}, 3.7667844453713083`*^9, 
   3.766784725081463*^9, 3.7667851577345963`*^9, {3.766785201760029*^9, 
   3.7667852188604*^9}, 3.766785262325293*^9, 3.766785619854826*^9, 
   3.766785932560007*^9, 3.76678626394814*^9, {3.7667866164290752`*^9, 
   3.76678663925835*^9}, 3.766786737587129*^9, 3.766786812875929*^9, 
   3.766787752690456*^9, 3.766801835710998*^9, 3.766801868769842*^9, 
   3.766802153345051*^9, 3.7668042715537777`*^9, 3.76680439238039*^9, 
   3.766804610060769*^9, 3.766827918839335*^9, {3.766827964883152*^9, 
   3.7668279793282843`*^9}, 3.7668285734626303`*^9, 3.7668288246709223`*^9, 
   3.766829064184827*^9, 3.766829263847817*^9, {3.7668293800153217`*^9, 
   3.766829406000156*^9}, 3.766829448481719*^9, 3.7668296107378693`*^9, 
   3.76682988434269*^9, 3.766913574159542*^9, 3.766913753047062*^9, 
   3.76691387517618*^9, 3.7670992236172543`*^9, 3.7670992904009113`*^9, 
   3.767323084313705*^9, 3.767337006921337*^9, 3.7673370606860113`*^9, 
   3.767337199287908*^9, 3.767345422681172*^9, 3.767345522594335*^9, 
   3.767346983515767*^9, 3.7673472683595657`*^9, 3.7673492767079887`*^9, 
   3.767349360975209*^9, 3.767361743175551*^9, 3.767372150889505*^9, 
   3.767372196771948*^9, 3.7673722398219423`*^9, 3.76737229128586*^9, 
   3.767372812769498*^9, 3.767372866602467*^9, 3.767373376617025*^9, 
   3.7673734403227053`*^9, 3.767373486204118*^9, {3.767373530819594*^9, 
   3.767373545404636*^9}, 3.767373578472762*^9, {3.767373645190494*^9, 
   3.7673736730351067`*^9}, 3.767373776332718*^9, {3.767374080186667*^9, 
   3.767374100628005*^9}, 3.767374319143882*^9, 3.767374517078828*^9, 
   3.767374876229703*^9, 3.767375014535392*^9, 3.767375047274819*^9, 
   3.767456632945177*^9, 3.767458021288014*^9, 3.767610508903472*^9, {
   3.7676105587479477`*^9, 3.7676105798159933`*^9}, 3.767610632660911*^9, 
   3.7676106857356*^9, {3.767611603547884*^9, 3.767611624430799*^9}, 
   3.767611715261098*^9, 3.7676893024718037`*^9, 3.767689338136258*^9, 
   3.7676893772801456`*^9, 3.7676894751229277`*^9, {3.7676900043272943`*^9, 
   3.767690015555711*^9}, 3.767690045601365*^9, 3.7676900759270773`*^9, 
   3.767690108994833*^9, 3.767690486158702*^9, 3.767692822265926*^9, 
   3.768585245674636*^9, {3.770277480460536*^9, 3.770277507372877*^9}, 
   3.7702778672900133`*^9, {3.770278237655734*^9, 3.770278252865838*^9}, 
   3.770280656666257*^9, 3.770280793878768*^9, 3.770281178361109*^9, 
   3.770281280579043*^9, 3.7702813623167467`*^9, {3.770281469619923*^9, 
   3.770281496838977*^9}, 3.770281550616416*^9, 3.770603941854458*^9, 
   3.770603972270968*^9, 3.770604033913389*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some tests with the model", "Section",
 CellChangeTimes->{{3.767692787921207*^9, 3.7676927912711573`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"FeynmanRules", "[", "LNP", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.770281183562145*^9, 3.770281250134548*^9}, {
   3.7702812860886707`*^9, 3.77028129711581*^9}, {3.770281365861854*^9, 
   3.770281366253326*^9}, 3.770603977056905*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.770281196156288*^9, 3.770281250438734*^9}, {
   3.770281282560678*^9, 3.770281297528943*^9}, 3.770281366595083*^9, 
   3.7706039777184277`*^9, 3.770604035367449*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.770281196156288*^9, 3.770281250438734*^9}, {
   3.770281282560678*^9, 3.770281297528943*^9}, 3.770281366595083*^9, 
   3.7706039777184277`*^9, 3.770604035376898*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.770281196156288*^9, 3.770281250438734*^9}, {
   3.770281282560678*^9, 3.770281297528943*^9}, 3.770281366595083*^9, 
   3.7706039777184277`*^9, 3.770604035752425*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.770281196156288*^9, 3.770281250438734*^9}, {
   3.770281282560678*^9, 3.770281297528943*^9}, 3.770281366595083*^9, 
   3.7706039777184277`*^9, 3.770604035800065*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[18, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.770281196156288*^9, 3.770281250438734*^9}, {
   3.770281282560678*^9, 3.770281297528943*^9}, 3.770281366595083*^9, 
   3.7706039777184277`*^9, 3.770604036256551*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["chi1", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"chi1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], "-", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], ")"}], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["chi1", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"chi0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["y", "DM"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"chi0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"chi1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["y", "DM"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "9"], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "4"]}]], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          SubscriptBox["\[Lambda]", "R"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
        RowBox[{
         SubscriptBox[
          SubscriptBox["\[Lambda]", "L"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"l", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "2"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          SubscriptBox["\[Lambda]", "L"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
        RowBox[{
         SubscriptBox[
          SubscriptBox["\[Lambda]", "R"], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"+\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"dq", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox[
       TemplateBox[{"V","CKM"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      SubscriptBox[
       SubscriptBox["\[Lambda]", "L"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubsuperscriptBox[
       RowBox[{"(", 
        TemplateBox[{"V","CKM"},
         "Superscript"], ")"}], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
      SubscriptBox[
       SubscriptBox["\[Lambda]", "L"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["chi1", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"chi1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]], "-", 
        SubsuperscriptBox["\<\"p\"\>", "3", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], ")"}], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "3"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "1"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["2", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "4"], ",", 
        SubscriptBox["\<\"m\"\>", "3"]}], 
       SubscriptBox["\<\"a\"\>", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubsuperscriptBox["g", "s", "2"], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "4"], ",", "Colour$1"}], 
          SubscriptBox["\<\"a\"\>", "1"]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{"Colour$1", ",", 
           SubscriptBox["\<\"m\"\>", "3"]}], 
          SubscriptBox["\<\"a\"\>", "2"]]}], "+", 
        RowBox[{
         SubsuperscriptBox["T", 
          RowBox[{"Colour$1", ",", 
           SubscriptBox["\<\"m\"\>", "3"]}], 
          SubscriptBox["\<\"a\"\>", "1"]], " ", 
         SubsuperscriptBox["T", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "4"], ",", "Colour$1"}], 
          SubscriptBox["\<\"a\"\>", "2"]]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["chi1", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"chi1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["s", "w"], " ", 
       TemplateBox[{SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
        "Superscript"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]]}], 
      RowBox[{"3", " ", 
       SubscriptBox["c", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"LQ", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["s", "w"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\<\"p\"\>", "1", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], "-", 
         SubsuperscriptBox["\<\"p\"\>", "2", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], ")"}], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]]}], 
      RowBox[{"3", " ", 
       SubscriptBox["c", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "2"], ",", 
          SubscriptBox["\<\"m\"\>", "3"]}]], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"9", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"LQ", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubsuperscriptBox["T", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "3"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}], 
        SubscriptBox["\<\"a\"\>", "1"]]}], 
      RowBox[{"3", " ", 
       SubscriptBox["c", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"LQ", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["LQ", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"9", " ", 
       SubsuperscriptBox["c", "w", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.770281197157687*^9, 3.770281250765769*^9}, {
   3.770281282798561*^9, 3.770281297713676*^9}, 3.7702813674569607`*^9, 
   3.770603978989484*^9, 3.7706040364012127`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Y", "[", 
   RowBox[{"CC", "[", "uRbar", "]"}], "]"}], "+", 
  RowBox[{"Y", "[", "lR", "]"}], "+", 
  RowBox[{"Y", "[", "S1bar", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Y", "[", 
   RowBox[{"CC", "[", "QLbar", "]"}], "]"}], "+", 
  RowBox[{"Y", "[", "LL", "]"}], "+", 
  RowBox[{"Y", "[", "S1bar", "]"}]}]}], "Input",
 CellChangeTimes->{{3.770278557023592*^9, 3.770278584734333*^9}, {
  3.770278644706252*^9, 3.770278652899501*^9}, {3.770278684670082*^9, 
  3.7702786852282867`*^9}, {3.77028141481102*^9, 3.770281415018985*^9}, {
  3.77060404952731*^9, 3.77060405131485*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.770278558770578*^9, 3.770278585073389*^9}, {
  3.7702786496024303`*^9, 3.770278653138729*^9}, {3.770281408804764*^9, 
  3.7702814157873507`*^9}, {3.770604046820751*^9, 3.770604051707534*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.770278558770578*^9, 3.770278585073389*^9}, {
  3.7702786496024303`*^9, 3.770278653138729*^9}, {3.770281408804764*^9, 
  3.7702814157873507`*^9}, {3.770604046820751*^9, 3.770604051719186*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckDiagonalQuadraticTerms", "[", "Lkin", "]"}]], "Input",
 CellChangeTimes->{{3.7676895540665007`*^9, 3.7676895951953173`*^9}, {
  3.770281483689279*^9, 3.770281484088126*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.767689590941761*^9, 3.7676896001860533`*^9}, 
   3.770281484647682*^9, 3.7706040543011723`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with less than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with less than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.767689590941761*^9, 3.7676896001860533`*^9}, 
   3.770281484647682*^9, 3.770604054314508*^9}],

Cell[BoxData["\<\"All quadratic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{{3.767689590941761*^9, 3.7676896001860533`*^9}, 
   3.770281484647682*^9, 3.7706040543268223`*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.767689590949719*^9, 3.767689600233039*^9}, 
   3.77028148467225*^9, 3.770604054339108*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", "Lkin", "]"}]], "Input",
 CellChangeTimes->{{3.7676896174849567`*^9, 3.767689625546659*^9}, {
  3.770281486899136*^9, 3.7702814873090076`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.767689630411195*^9, {3.770281487829796*^9, 3.770281502306775*^9}, 
   3.770604056830948*^9}],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.767689630411195*^9, {3.770281487829796*^9, 3.770281502306775*^9}, 
   3.7706040568446693`*^9}],

Cell[BoxData["\<\"All kinetic terms are correctly normalized.\"\>"], "Print",
 CellChangeTimes->{
  3.767689630411195*^9, {3.770281487829796*^9, 3.770281502306775*^9}, 
   3.770604057069339*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.770281502546666*^9, 3.770604057082695*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "Lkin", "]"}]], "Input",
 CellChangeTimes->{{3.767689518861446*^9, 3.767689528147897*^9}, {
  3.7702814625453568`*^9, 3.770281462927616*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7676895325806847`*^9, {3.770281463471353*^9, 3.77028147300107*^9}, {
   3.770281526109857*^9, 3.770281536188265*^9}, 3.770604058827077*^9}],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.7676895325806847`*^9, {3.770281463471353*^9, 3.77028147300107*^9}, {
   3.770281526109857*^9, 3.770281536188265*^9}, 3.770604058839877*^9}],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{
  3.7676895325806847`*^9, {3.770281463471353*^9, 3.77028147300107*^9}, {
   3.770281526109857*^9, 3.770281536188265*^9}, 3.7706040590574217`*^9}],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{
  3.7676895325806847`*^9, {3.770281463471353*^9, 3.77028147300107*^9}, {
   3.770281526109857*^9, 3.770281536188265*^9}, 3.7706040590700197`*^9}]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"chi0", "Mchi0", "50.`", "50.`"},
    {"chi1", "Mchi1", "500.`", "500.`"},
    {"LQ", 
     SqrtBox[
      SuperscriptBox["MLQ", "2"]], "1000.`", "1000.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.767689537349173*^9, {3.770281463698447*^9, 3.7702814732233562`*^9}, {
   3.7702815263551083`*^9, 3.770281536433114*^9}, 3.77060405908314*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interfaces", "Section",
 CellChangeTimes->{{3.770281592703973*^9, 3.770281593821774*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lagr", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandIndices", "[", 
      RowBox[{
       RowBox[{"Expand", "[", "#", "]"}], ",", 
       RowBox[{"FlavorExpand", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"SU2D", ",", "SU2W"}], "}"}]}]}], "]"}], "&"}], "/@", " ", 
    RowBox[{"{", 
     RowBox[{
     "LGauge", ",", "LFermions", ",", "LHiggs", ",", "LYukawa", ",", "LGhost",
       ",", "LNP"}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7702817955094147`*^9, 3.770281797559018*^9}, {
  3.770604086930394*^9, 3.770604087470327*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", "Lagr", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.770281601484511*^9, 3.770281612034872*^9}, {
  3.770281644815443*^9, 3.770281690988783*^9}, {3.7702817932181473`*^9, 
  3.7702817997921333`*^9}, {3.7706040936060467`*^9, 3.770604093784919*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604094300115*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.77060409437924*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604094390367*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604094961464*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  8, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 8, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604094974845*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[8, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604095668274*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604095713636*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706040957263517`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.77060409664955*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604096663446*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[13, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604097376079*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.77060409738756*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706040973987017`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706040978613462`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "38", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "38", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  38, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 38, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604097875189*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"38", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[38, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604098390544*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604098403205*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.77060409841636*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706040989184437`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "10", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  10, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 10, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706040989303303`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[10, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706040992455273`*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099258336*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099271117*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099664987*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "24", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "24", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  24, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 24, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099678258*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"24", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[24, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099968384*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099980048*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604099991226*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706041003590403`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604100372478*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[18, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604100805807*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "111"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 111],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604103529087*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706041053318663`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604105434143*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "88"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 88],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604105448324*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.933291`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.933291, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604107384862*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.041491`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.041491, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706041073983393`*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604107411662*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604107571838*^9}],

Cell[BoxData["\<\"before\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604107804756*^9}],

Cell[BoxData["\<\"true\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604107951803*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "213", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 213, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604107966161*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.770604108167741*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.7702816937101917`*^9, 3.7706041084873133`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteCHOutput", "[", "Lagr", "]"}]}], "Input",
 CellChangeTimes->{{3.770281778648336*^9, 3.7702818115936117`*^9}, 
   3.7706041034601107`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108645815*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108652768*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108662326*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/Users/fuks/Work/projects/DarkMatter/DM_flavor/frmodel/LQDM-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/Users/fuks/Work/projects/DarkMatter/DM_flavor/frmodel/LQDM-CH."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108666205*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108669549*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108674027*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108677994*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108681931*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108685207*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108728685*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604108749956*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.7706041120910387`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "116", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "116", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  116, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 116, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604112137344*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"111", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[111, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604114965185*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "111"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 111],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604117622369*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.7706041194576197`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604121240933*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.7706041212919703`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.21min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.21min!"],
  Editable->False]], "Print",
 CellChangeTimes->{3.770281813160676*^9, 3.770604121318426*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1022, 939},
WindowMargins->{{Automatic, 27}, {Automatic, 26}},
ShowSelection->True,
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 171, 3, 28, "Input"],
Cell[CellGroupData[{
Cell[741, 27, 188, 3, 64, "Section"],
Cell[CellGroupData[{
Cell[954, 34, 1645, 32, 97, "Input"],
Cell[CellGroupData[{
Cell[2624, 70, 4426, 62, 22, "Print"],
Cell[7053, 134, 4711, 69, 22, "Print"],
Cell[11767, 205, 4478, 63, 22, "Print"],
Cell[16248, 270, 4414, 62, 21, "Print"],
Cell[20665, 334, 4423, 62, 21, "Print"],
Cell[25091, 398, 4473, 63, 22, "Print"],
Cell[29567, 463, 4475, 63, 22, "Print"],
Cell[34045, 528, 4412, 62, 21, "Print"],
Cell[38460, 592, 4442, 62, 22, "Print"],
Cell[42905, 656, 4412, 62, 21, "Print"],
Cell[47320, 720, 4479, 63, 22, "Print"],
Cell[51802, 785, 4435, 62, 22, "Print"],
Cell[56240, 849, 4451, 62, 22, "Print"],
Cell[60694, 913, 4426, 62, 22, "Print"],
Cell[65123, 977, 4557, 66, 21, "Print"],
Cell[69683, 1045, 4411, 62, 21, "Print"],
Cell[74097, 1109, 4459, 63, 22, "Print"],
Cell[78559, 1174, 4413, 62, 21, "Print"],
Cell[82975, 1238, 4443, 62, 22, "Print"],
Cell[87421, 1302, 4444, 62, 22, "Print"],
Cell[91868, 1366, 4442, 62, 22, "Print"],
Cell[96313, 1430, 4603, 67, 37, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[100977, 1504, 112, 1, 64, "Section"],
Cell[CellGroupData[{
Cell[101114, 1509, 291, 5, 28, "Input"],
Cell[CellGroupData[{
Cell[101430, 1518, 494, 11, 22, "Print"],
Cell[101927, 1531, 249, 3, 22, "Print"],
Cell[102179, 1536, 282, 4, 22, "Print"],
Cell[102464, 1542, 763, 15, 22, "Print"],
Cell[103230, 1559, 364, 7, 21, "Print"]
}, Open  ]],
Cell[103609, 1569, 17150, 508, 483, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120796, 2082, 625, 14, 46, "Input"],
Cell[121424, 2098, 242, 3, 28, "Output"],
Cell[121669, 2103, 242, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121948, 2111, 202, 3, 28, "Input"],
Cell[CellGroupData[{
Cell[122175, 2118, 403, 8, 22, "Print"],
Cell[122581, 2128, 401, 8, 22, "Print"],
Cell[122985, 2138, 185, 2, 22, "Print"]
}, Open  ]],
Cell[123185, 2143, 144, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123366, 2150, 204, 3, 28, "Input"],
Cell[CellGroupData[{
Cell[123595, 2157, 402, 9, 22, "Print"],
Cell[124000, 2168, 184, 3, 22, "Print"],
Cell[124187, 2173, 194, 3, 22, "Print"]
}, Open  ]],
Cell[124396, 2179, 95, 1, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124528, 2185, 190, 3, 28, "Input"],
Cell[CellGroupData[{
Cell[124743, 2192, 449, 9, 22, "Print"],
Cell[125195, 2203, 226, 3, 22, "Print"],
Cell[125424, 2208, 222, 3, 22, "Print"],
Cell[125649, 2213, 263, 4, 22, "Print"]
}, Open  ]],
Cell[125927, 2220, 939, 24, 102, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126915, 2250, 95, 1, 64, "Section"],
Cell[127013, 2253, 595, 16, 28, "Input"],
Cell[CellGroupData[{
Cell[127633, 2273, 427, 9, 46, "Input"],
Cell[CellGroupData[{
Cell[128085, 2286, 149, 2, 22, "Print"],
Cell[128237, 2290, 371, 9, 22, "Print"],
Cell[128611, 2301, 127, 1, 22, "Print"],
Cell[128741, 2304, 160, 2, 22, "Print"],
Cell[128904, 2308, 637, 13, 22, "Print"],
Cell[129544, 2323, 240, 5, 21, "Print"],
Cell[129787, 2330, 372, 9, 22, "Print"],
Cell[130162, 2341, 129, 1, 22, "Print"],
Cell[130294, 2344, 159, 2, 22, "Print"],
Cell[130456, 2348, 641, 13, 22, "Print"],
Cell[131100, 2363, 242, 5, 21, "Print"],
Cell[131345, 2370, 371, 9, 22, "Print"],
Cell[131719, 2381, 129, 1, 22, "Print"],
Cell[131851, 2384, 162, 2, 22, "Print"],
Cell[132016, 2388, 641, 13, 22, "Print"],
Cell[132660, 2403, 242, 5, 21, "Print"],
Cell[132905, 2410, 372, 9, 22, "Print"],
Cell[133280, 2421, 126, 1, 22, "Print"],
Cell[133409, 2424, 162, 2, 22, "Print"],
Cell[133574, 2428, 643, 13, 22, "Print"],
Cell[134220, 2443, 244, 5, 21, "Print"],
Cell[134467, 2450, 372, 9, 22, "Print"],
Cell[134842, 2461, 127, 1, 22, "Print"],
Cell[134972, 2464, 160, 2, 22, "Print"],
Cell[135135, 2468, 641, 13, 22, "Print"],
Cell[135779, 2483, 242, 5, 21, "Print"],
Cell[136024, 2490, 372, 9, 22, "Print"],
Cell[136399, 2501, 127, 1, 22, "Print"],
Cell[136529, 2504, 162, 2, 22, "Print"],
Cell[136694, 2508, 641, 13, 22, "Print"],
Cell[137338, 2523, 242, 5, 21, "Print"],
Cell[137583, 2530, 473, 9, 22, "Print"],
Cell[138059, 2541, 143, 1, 21, "Print"],
Cell[138205, 2544, 408, 10, 22, "Print"],
Cell[138616, 2556, 378, 9, 21, "Print"],
Cell[138997, 2567, 340, 6, 22, "Print"],
Cell[139340, 2575, 328, 6, 22, "Print"],
Cell[139671, 2583, 124, 1, 22, "Print"],
Cell[139798, 2586, 148, 2, 22, "Print"],
Cell[139949, 2590, 106, 1, 21, "Print"],
Cell[140058, 2593, 104, 1, 21, "Print"],
Cell[140165, 2596, 498, 9, 22, "Print"],
Cell[140666, 2607, 120, 1, 22, "Print"],
Cell[140789, 2610, 107, 1, 21, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[140945, 2617, 294, 7, 46, "Input"],
Cell[CellGroupData[{
Cell[141264, 2628, 143, 1, 22, "Print"],
Cell[141410, 2631, 584, 15, 21, "Print"],
Cell[141997, 2648, 576, 15, 21, "Print"],
Cell[142576, 2665, 642, 18, 38, "Print"],
Cell[143221, 2685, 548, 15, 38, "Print"],
Cell[143772, 2702, 562, 15, 38, "Print"],
Cell[144337, 2719, 562, 15, 38, "Print"],
Cell[144902, 2736, 562, 15, 38, "Print"],
Cell[145467, 2753, 98, 1, 21, "Print"],
Cell[145568, 2756, 370, 9, 22, "Print"],
Cell[145941, 2767, 125, 1, 22, "Print"],
Cell[146069, 2770, 160, 2, 22, "Print"],
Cell[146232, 2774, 643, 13, 22, "Print"],
Cell[146878, 2789, 242, 5, 21, "Print"],
Cell[147123, 2796, 471, 9, 22, "Print"],
Cell[147597, 2807, 757, 19, 54, "Print"],
Cell[148357, 2828, 548, 15, 38, "Print"],
Cell[148908, 2845, 563, 15, 22, "Print"],
Cell[149474, 2862, 506, 15, 37, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

