(***************************************************************************************************************)
(******               This is the FeynRules mod-file for the Large Extra Dimensions                       ******)
(******                                                                                                   ******)
(******     Author: Priscila de Aquino                                                                ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

M$ModelName = "LED";

M$Information = {Authors -> {"Priscila de Aquino"}, 
             Date -> "15.06.2009",
             Institute -> {"Katholieke Universiteit Leuven & Universite Catholique Louvain - CP3"},
             Emails -> {"priscila@itf.kuleuven.be"},
             References -> {"Phys. Rev. D59: 105006 (1999), hep-ph/9811350", "Nucl. Phys. B544 (1999), hep-ph/9811291", "Eur. Phys. J. C56 (2008), hep-ph/0805.2554"},
             URLs -> "http://feynrules.phys.ucl.ac.be/view/Main/LED",
             Version -> "1.0"};

FeynmanGauge = False;


(*****************************************************************************************)
(****************************** Index definitions ****************************************)
(*****************************************************************************************)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]

IndexRange[ Index[SU2W] ] = Range[3]


IndexStyle[Colour, i]

IndexStyle[Generation, f]

IndexStyle[Gluon ,a]

IndexStyle[SU2W ,k]

(*****************************************************************************************)
(*************************************  Parameters ***************************************)
(*****************************************************************************************)

M$Parameters = {

  (* External parameters *)

  \[Alpha]EWM1== {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEWM1,
        InteractionOrder -> {QED, -2},
        Value -> 127.9,
        Description -> "Inverse of the electroweak coupling constant"},

  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        InteractionOrder -> {QED, 2},
        Value -> 1.16639 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.118,
        Description -> "Strong coupling constant at the Z pole."},


  ZM == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        Value -> 91.188,
        Description -> "Z mass"},


  ymc == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.42,
        OrderBlock -> {4},
        Description -> "Charm Yukawa mass"},

 ymb == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 4.7,
        OrderBlock -> {5},
        Description -> "Bottom Yukawa mass"},

  ymt == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 174.3,
        OrderBlock -> {6},
        Description -> "Top Yukawa mass"},

  ymtau == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau Yukawa mass"},

   GN == {
        ParameterType -> External,
        ParameterName -> GN,
        InteractionOrder -> {QCD, 2},
        Value -> 10^(-16),
        Description -> "Newton Constant"},

   (* Internal Parameters *)

  \[Alpha]EW == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]EWM1,
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Description -> "Electroweak coupling contant"},


  MW == {
        ParameterType -> Internal,
        Value -> Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]*\[Alpha]EW/Gf*MZ^2]],
        Description -> "W mass"},

  sw2 == {
        ParameterType -> Internal,
        Value -> 1-(MW/MZ)^2,
        Description -> "Squared Sin of the Weinberg angle"},

   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},

   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - sw2],
        Description -> "Cos of the Weinberg angle"},  

   sw == {
        TeX -> Subscript[s, w],
        ParameterType -> Internal,
        Value -> Sqrt[sw2],
        Description -> "Sin of the Weinberg angle"},  

   gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Value -> ee / sw,
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Value -> ee / cw,
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},

   v == {
        ParameterType -> Internal,
        Value -> 2*MW*sw/ee,
        InteractionOrder -> {QED, -1},
        Description -> "Higgs VEV"},

   \[Lambda] == {
        ParameterType -> Internal,
        Value -> MH^2/(2*v^2),
        InteractionOrder -> {QED, 2},
        ParameterName -> lam,
        Description -> "Higgs quartic coupling"},

   muH == {
        ParameterType -> Internal,
        Value -> Sqrt[v^2 \[Lambda]],
        TeX -> \[Mu],
        Description -> "Coefficient of the quadratic piece of the Higgs potential"},


   yl == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yl[1] -> 0, yl[2] -> 0, yl[3] -> Sqrt[2] ymtau / v},
        ParameterName -> {yl[1] -> ye, yl[2] -> ym, yl[3] -> ytau},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "Lepton Yukawa coupling"},

   yu == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yu[1] -> 0, yu[2] -> Sqrt[2] ymc / v, yu[3] -> Sqrt[2] ymt / v},
        ParameterName -> {yu[1] -> yu, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "U-quark Yukawa coupling"},

   yd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yd[1] -> 0, yd[2] -> 0, yd[3] -> Sqrt[2] ymb / v},
        ParameterName -> {yd[1] -> yd, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "D-quark Yukawa coupling"},

   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        OrderBlock -> {1},
        Value -> 0.488,
        Description -> "Cabibbo angle"},

  CKM == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Value -> {CKM[1,2] -> Sin[cabi],
                   CKM[1,1] -> Cos[cabi],
                   CKM[2,1] -> -Sin[cabi],
                   CKM[2,2] -> Cos[cabi]},
       Description -> "CKM-Matrix"},

   kappa == {
        TeX -> \[Kappa],
        ParameterType -> Internal,
        Value -> Sqrt[16 Pi GN]}

}

TeXFormat[mphi, Subscript[m, phi]]
TeXFormat[mpsi, Subscript[m, psi]]
TeXFormat[mG, Subscript[m, G]]

(*****************************************************************************************)
(********************************* Gauge Groups ******************************************)
(*****************************************************************************************)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> g1},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> Eps,
        CouplingConstant -> gw},

  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        SymmetricTensor -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}
}
(*****************************************************************************************)
(******************************* Particle Classes ****************************************)
(*****************************************************************************************)

M$ClassesDescription = {

(************************************ Fermions *******************************************)

	(* Leptons (neutrino): I_3 = +1/2, Q = 0 *)
  F[1] == {
        ClassName -> vl,
        ClassMembers -> {ve,vm,vt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
	PropagatorLabel -> {"v", "ve", "vm", "vt"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
  F[2] == {
        ClassName -> l,
        ClassMembers -> {e, m, tt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
	Mass -> {Ml, {ME, 0}, {MM, 0}, {MTA, 1.777}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
	PropagatorLabel -> {"l", "e", "m", "tt"},
	PropagatorType -> Straight,
        ParticleName -> {"e-", "m-", "tt-"},
        AntiParticleName -> {"e+", "m+", "tt+"},
	PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
  F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Mu, {MU, 0}, {MC, 1.42}, {MT, 174.3}},
        Width -> {0, 0, {WT, 1.50833649}},
	QuantumNumbers -> {Q -> 2/3},
	PropagatorLabel -> {"uq", "u", "c", "t"},
	PropagatorType -> Straight,
	PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
  F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Md, {MD, 0}, {MS, 0}, {MB, 4.7}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1/3},
	PropagatorLabel -> {"dq", "d", "s", "b"},
	PropagatorType -> Straight, 
	PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },

(************************************ Gauge Bosons ***************************************)

	(* Gauge bosons: Q = 0 *)
  V[1] == {
        ClassName -> A,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
        Width -> 0,
	PropagatorLabel -> "a",
	PropagatorType -> W,
	PropagatorArrow -> None,
        PDG -> 22,
        FullName -> "Photon" },

  V[2] == {
        ClassName -> Z,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZ, 91.188},
        Width -> {WZ, 2.44140351},
	PropagatorLabel -> "Z",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 23,
        FullName -> "Z" },

	(* Gauge bosons: Q = -1 *)
  V[3] == {
        ClassName -> W,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
        Width -> {WW, 2.04759951},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "W",
	PropagatorType -> Sine,
	PropagatorArrow -> Forward,
	ParticleName ->"W+",
	AntiParticleName ->"W-",
        PDG -> 24,
        FullName -> "W" },

V[4] == {
        ClassName -> G,
	SelfConjugate -> True,
	Indices -> {Index[Gluon]},
	Mass -> {mG,0},
        Width -> 0,
        PropagatorLabel -> G,
	PropagatorType -> C,
	PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "G" },

V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> cw Z[mu] + sw A[mu]},
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0,
        PDG -> {1,2,3}},

V[6] == {
        ClassName -> B,
	SelfConjugate -> True,
        Definitions -> {B[mu_] -> -sw Z[mu] + cw A[mu]},
	Indices -> {},
	Mass -> 0,
        Unphysical -> True},

(****************************** Scalar Fields *********************************************)
	
(* physical Higgs: Q = 0 *) 
  S[1] == {
        ClassName -> H,
	SelfConjugate -> True,
	Mass -> {MH, 120},
        Width -> {WH, 0.00575308848},
	PropagatorLabel -> "H",
	PropagatorType -> D,
	PropagatorArrow -> None,
        PDG -> 25,
        TeXParticleName -> "\\phi",
        TeXClassName -> "\\phi",
        FullName -> "H" },

S[2] == {
        ClassName -> phi,
	SelfConjugate -> True,
	Mass -> {MZ, 91.188},
        Width -> Wphi,
	PropagatorLabel -> "Phi",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phi0",
        PDG -> 250,
        FullName -> "Phi",
        Goldstone -> Z },

S[3] == {
        ClassName -> phi2,
	SelfConjugate -> False,
	Mass -> {MW, Internal},
        Width -> Wphi2,
	PropagatorLabel -> "Phi2",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phi+",
	AntiParticleName ->"phi-",
        PDG -> 251,
        FullName -> "Phi2",
        TeXClassName -> "\\phi^+",
        TeXParticleName -> "\\phi^+",
        TeXAntiParticleName -> "\\phi^-",
        Goldstone -> W,
        QuantumNumbers -> {Q -> 1}},

(******************************* Spin 2 particles: graviton *****************************)

T[1] == {
     ClassName -> h,
     SelfConjugate -> True,
     Symmetric -> True, 
     Mass -> {Mh, 500}}

}

(*****************************************************************************************)
(*                                                                                       *)
(*                                   The Lagrangian                                      *)
(*                                                                                       *)
(*****************************************************************************************)

(* Some shorthands (for nicer printing) *)

Format[mu, TraditionalForm] = \[Mu];
Format[nu, TraditionalForm] = \[Nu];
Format[lam, TraditionalForm] = \[Lambda];
Format[rho, TraditionalForm] = \[Rho];

psi = \[Psi];
psibar = \[Psi]bar;
phi = \[Phi];
phibar = \[Phi]bar;
phiK = \[Sigma];

(*****************************************************************************************)
(********************** Defining the cov derivatives ************************************)
(*****************************************************************************************)

covdelU[field_, mu_] := 
  Module[{j, a},   del[field, mu] - I gs G[mu, a] T[a].field 
                 - I ee/cw 4/3 B[mu]/2 ProjP.field - I ee/cw/3 B[mu]/2 ProjM.field - I ee/sw/2 ProjM.field Wi[mu,3]];

covdelD[field_, mu_] := 
  Module[{j, a}, del[field, mu] - I gs G[mu, a] T[a].field 
                 + I ee/cw 2/3 B[mu]/2 ProjP.field - I ee/cw/3 B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

covdelE[field_, mu_] := 
  Module[{j, a},  del[field, mu] 
                 + I 2 ee/cw B[mu]/2 ProjP.field - I ee/cw B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

covdelN[field_, mu_] := 
  Module[{j, a}, del[field, mu] + I ee/cw B[mu]/2 ProjM.field - I ee/sw/2 ProjM. field Wi[mu,3]];

(*****************************************************************************************)
(******************** Defining the field strenght tensors:********************************)
(*****************************************************************************************)

FG[mu_,nu_,a1_,a2_,a3_] := del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3];

FA[mu_,nu_] := del[B[nu], mu] - del[B[mu], nu];

FW[mu_,nu_,i1_,i2_,i3_] := del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + ee/sw Eps[i1, i2, i3] Wi[mu, i2] Wi[nu, i3];



(*****************************************************************************************)
(******************* Defining the energy-momentum tensor T[mu,nu] ************************)
(*****************************************************************************************)

(* Gauge bosons *)

TG[mu_,nu_]:= ( -ME[mu,nu]. (-1/4 FA[rho, sig] FA[rho,sig] - 1/4 FW[rho,sig,i1,i2,i3] FW[rho,sig, i1,i4,i5] - 1/4 FG[rho,sig,a1,a2,a3] FG[rho,sig, a1,a4,a5]) 
                -FA[mu,rho] FA[nu,rho] - FW[mu,rho,i1,i2,i3] FW[nu,rho, i1,i4,i5] - FG[mu,rho,a1,a2,a3] FG[nu,rho, a1,a2,a3]);

(* Fermions *)

TF[mu_,nu_] := (-ME[mu,nu].(I uqbar.(Ga[rho].covdelU[uq, rho]) -1/2 del[I uqbar.Ga[rho].uq, rho] 
                          + I dqbar.(Ga[rho].covdelD[dq, rho]) -1/2 del[I dqbar.Ga[rho].dq, rho] 
                          + I vlbar.(Ga[rho].covdelN[vl, rho]) -1/2 del[I vlbar.Ga[rho].vl, rho]
                          + I lbar.(Ga[rho].covdelE[l, rho]  ) -1/2 del[I lbar.Ga[rho].l, rho]
                          
                          - ee/sw/2 Sqrt[2] (CKM uqbar.Ga[rho].ProjM.dq W[rho] + HC[CKM] dqbar.Ga[rho].ProjM.uq Wbar[rho] 
                                         + vlbar.Ga[rho].ProjM.l W[rho] + lbar.Ga[rho].ProjM.vl Wbar[rho]) ) 
               + (    I/2  uqbar.Ga[mu].covdelU[uq, nu] - 1/4 I del[uqbar.Ga[nu].uq, mu] 
                    + I/2  uqbar.Ga[nu].covdelU[uq, mu] - 1/4 I del[uqbar.Ga[mu].uq, nu]                   
                    + I/2  dqbar.Ga[mu].covdelD[dq, nu] - 1/4 I del[dqbar.Ga[nu].dq, mu] 
                    + I/2  dqbar.Ga[nu].covdelD[dq, mu] - 1/4 I del[dqbar.Ga[mu].dq, nu]
                    + I/2  vlbar.Ga[mu].covdelN[vl, nu] - 1/4 I del[vlbar.Ga[nu].vl, mu] 
                    + I/2  vlbar.Ga[nu].covdelN[vl, mu] - 1/4 I del[vlbar.Ga[mu].vl, nu]                    
                    + I/2  lbar.Ga[mu].covdelE[l, nu] - 1/4 I del[lbar.Ga[nu].l, mu] 
                    + I/2  lbar.Ga[nu].covdelE[l, mu] - 1/4 I del[lbar.Ga[mu].l, nu]  )

                - ee/sw/Sqrt[2] (  CKM uqbar.Ga[mu].ProjM.dq W[nu] + HC[CKM] dqbar.Ga[mu].ProjM.uq Wbar[nu] 
                              + CKM uqbar.Ga[nu].ProjM.dq W[mu] + HC[CKM] dqbar.Ga[nu].ProjM.uq Wbar[mu]                               
                              + vlbar.Ga[mu].ProjM.l W[nu] + lbar.Ga[mu].ProjM.vl Wbar[nu] 
                              + vlbar.Ga[nu].ProjM.l W[mu] + lbar.Ga[nu].ProjM.vl Wbar[mu]));

(* Definitions for Higgs and Yukawa *)

 Phi := If[FeynmanGauge, {-I phi2, (v + H + I phi)/Sqrt[2]}, {0, (v + H)/Sqrt[2]}];
 Phibar := If[FeynmanGauge, {I phi2bar, (v + H - I phi)/Sqrt[2]} ,{0, (v + H)/Sqrt[2]}];
 
 PMVec = Table[PauliSigma[i], {i, 3}];   
 Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

 Dc[f_, mu_] := I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 (Wvec[mu].PMVec).f;
 Dcbar[f_, mu_] := -I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 f.(Wvec[mu].PMVec);
 
 Vphi[Phi_, Phibar_] := -muH^2 Phibar.Phi + \[Lambda] (Phibar.Phi)^2;


(* Higgs *)

TH[mu_, nu_] := (-ME[mu,nu].(Dcbar[Phibar, rho]).Dc[Phi, rho] - Vphi[Phi, Phibar]+ 
    (Dcbar[Phibar, mu]).Dc[Phi, nu] + (Dcbar[Phibar, nu]).Dc[Phi, mu] );

(* Yukawa *)

TYuk:= Module[{s,r,n,m,i},                                                    -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+H)/Sqrt[2]  -
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+H)/Sqrt[2]  -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+H)/Sqrt[2]];

TY[mu_,nu_] := -ME[mu,nu].(TYuk + HC[TYuk]);


(*****************************************************************************************)
(*******************************  Writing the lagrangian *********************************)
(*****************************************************************************************)

LagH := -kappa/2 (h[mu,nu].TH[mu,nu]);

LagG := -kappa/2 (h[mu,nu].TG[mu,nu]);

LagF := -kappa/2 (h[mu,nu].TF[mu,nu]);

LagY := -kappa/2 (h[mu,nu].TY[mu,nu])


(*****************************************************************************************)

