(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     92901,       2900]
NotebookOptionsPosition[     89981,       2795]
NotebookOutlinePosition[     90409,       2814]
CellTagsIndexPosition[     90366,       2811]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The Large Extra dimensions Model", "Title",
 CellChangeTimes->{{3.405054966614888*^9, 3.4050549767315893`*^9}, 
   3.4529230123333807`*^9, {3.45405649584802*^9, 3.4540564997867126`*^9}, {
   3.4540565705776033`*^9, 3.454056571055434*^9}, {3.454057181466007*^9, 
   3.454057182797702*^9}}],

Cell[CellGroupData[{

Cell["Load of the FeynRules package", "Section",
 CellChangeTimes->{{3.452856941348258*^9, 3.452856954182706*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4521543016025457`*^9, 3.452154302750087*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<address of the package>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/LED\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.453613499780509*^9, 3.453613524557995*^9}, {
   3.454050520543564*^9, 3.454050533398179*^9}, {3.454056582682654*^9, 
   3.4540565840807753`*^9}, {3.454061008970613*^9, 3.4540610300313797`*^9}, 
   3.4540621439628963`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load of the full LED model", "Section",
 CellChangeTimes->{{3.452856959806845*^9, 3.452856965627877*^9}, {
  3.454050557859632*^9, 3.454050559388439*^9}, {3.454062198742198*^9, 
  3.454062202491016*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<LED.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.402749737680746*^9, 3.4027497378335543`*^9}, 
   3.405009528824724*^9, 3.449909327040394*^9, 3.452152811321804*^9, 
   3.4529230123338823`*^9, 3.45405650276263*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645507628*^9}],

Cell[BoxData[
 FormBox["\<\"Priscila de Aquino\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645522756*^9}],

Cell[BoxData[
 FormBox["\<\"Claude Duhr\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645557837*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
   SequenceForm["Model Version: ", "1.0"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645590395*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645623332*^9}],

Cell[BoxData[
 FormBox["\<\"Phys. Rev. D59: 105006 (1999), hep-ph/9811350\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.4540616456571903`*^9}],

Cell[BoxData[
 FormBox["\<\"Nucl. Phys. B544 (1999), hep-ph/9811291\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645690363*^9}],

Cell[BoxData[
 FormBox["\<\"Eur. Phys. J. C56 (2008), hep-ph/0805.2554\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.4540616457235813`*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be/view/Main/LED\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645756584*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.45406164578946*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.4540616458229923`*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645857395*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645889122*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645922811*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"LED\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "LED", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{{3.454061149331262*^9, 3.454061153172738*^9}, 
   3.454061211313333*^9, 3.454061645963604*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The full LED lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.4540507294896593`*^9, 3.4540507310208197`*^9}, {3.4540567139322166`*^9, 
  3.454056718777896*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.454057138248085*^9, 3.454057139479412*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagG"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.454050790694797*^9, 3.454050807408856*^9}, 3.454052286514977*^9, {
   3.454057086606534*^9, 3.4540570873864717`*^9}, 3.454061218230431*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Rho]",
               TraditionalForm]],
             TraditionalForm], ")"}],
           TraditionalForm], "-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ")"}],
           TraditionalForm]}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}]}], "-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "4"]}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", 
               FormBox[
                SubscriptBox["B", "sig"],
                TraditionalForm], ")"}],
              TraditionalForm], "-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ")"}],
              TraditionalForm]}], ")"}], "2"]}], "-", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{"sig", ",", "a1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            RowBox[{
             FormBox[
              SubscriptBox["g", "s"],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["f", 
               RowBox[{"a1", ",", "a2", ",", "a3"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "a2"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{"sig", ",", "a3"}]],
              TraditionalForm]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{"sig", ",", "a1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            RowBox[{
             FormBox[
              SubscriptBox["g", "s"],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["f", 
               RowBox[{"a1", ",", "a4", ",", "a5"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "a4"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{"sig", ",", "a5"}]],
              TraditionalForm]}]}], ")"}]}], "-", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["\[Epsilon]", 
                RowBox[{"i1", ",", "i2", ",", "i3"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "i2"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i3"}]],
               TraditionalForm]}], 
             FormBox[
              SubscriptBox["s", "w"],
              TraditionalForm]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["\[Epsilon]", 
                RowBox[{"i1", ",", "i4", ",", "i5"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "i4"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i5"}]],
               TraditionalForm]}], 
             FormBox[
              SubscriptBox["s", "w"],
              TraditionalForm]]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["G", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "a1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         RowBox[{
          FormBox[
           SubscriptBox["g", "s"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["f", 
            RowBox[{"a1", ",", "a2", ",", "a3"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "a2"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Rho]",
              TraditionalForm], ",", "a3"}]],
           TraditionalForm]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["G", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "a1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         RowBox[{
          FormBox[
           SubscriptBox["g", "s"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["f", 
            RowBox[{"a1", ",", "a2", ",", "a3"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "a2"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Rho]",
              TraditionalForm], ",", "a3"}]],
           TraditionalForm]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "i1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["\[Epsilon]", 
             RowBox[{"i1", ",", "i2", ",", "i3"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "i2"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i3"}]],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "i1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["\[Epsilon]", 
             RowBox[{"i1", ",", "i4", ",", "i5"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "i4"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i5"}]],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm]]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.4540612188923187`*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagH"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910290186841*^9, 3.411910292005392*^9}, 3.454052293282386*^9, {
   3.454057094128326*^9, 3.454057094642251*^9}, 3.45406122079182*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "\[Lambda]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], "4"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        FormBox["\[Mu]",
         TraditionalForm], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], "2"]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]], "-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox[
            FormBox["e",
             TraditionalForm], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              SubscriptBox["Wi", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "1"}]],
              TraditionalForm], "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "2"}]],
               TraditionalForm]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              SubscriptBox["Wi", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "1"}]],
              TraditionalForm], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "2"}]],
               TraditionalForm]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], "2"]}], 
          RowBox[{"8", " ", 
           SuperscriptBox[
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm], "2"]}]], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["B", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["c", "w"],
               TraditionalForm]}]], "-", 
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "H", ")"}],
               TraditionalForm]}], 
             SqrtBox["2"]], "-", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "3"}]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["s", "w"],
               TraditionalForm]}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["B", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["c", "w"],
               TraditionalForm]}]], "+", 
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "H", ")"}],
               TraditionalForm]}], 
             SqrtBox["2"]], "-", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "3"}]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["s", "w"],
               TraditionalForm]}]]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Mu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Nu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Mu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Nu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.454061221137125*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagF"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910379677638*^9, 3.4119103807255*^9}, {3.454050812632284*^9, 
   3.4540508182235947`*^9}, 3.4540522991223593`*^9, {3.454057102034585*^9, 
   3.454057104921763*^9}, 3.454061223464816*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["dq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "dq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["dq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "dq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["l", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "l"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["l", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "l"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["uq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "uq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["uq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "uq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["vl", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "vl"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["vl", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "vl"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["dq", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "dq"}], ")"}],
           TraditionalForm]}], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["l", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "l"}], ")"}],
           TraditionalForm]}], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["uq", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "uq"}], ")"}],
           TraditionalForm]}], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["vl", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "vl"}], ")"}],
           TraditionalForm]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["dq", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "dq", ")"}],
              TraditionalForm], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "dq"}]}], 
              RowBox[{"6", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"+\"\>"],
                 TraditionalForm], ".", "dq"}]}], 
              RowBox[{"3", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["g", "s"],
               TraditionalForm], " ", 
              RowBox[{
               FormBox[
                SuperscriptBox["T", "a$182"],
                TraditionalForm], ".", "dq"}], " ", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "a$182"}]],
               TraditionalForm]}], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "dq"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["l", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "l", ")"}],
              TraditionalForm], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "l"}]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"+\"\>"],
                 TraditionalForm], ".", "l"}]}], 
              FormBox[
               SubscriptBox["c", "w"],
               TraditionalForm]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "l"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["uq", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "uq", ")"}],
              TraditionalForm], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "uq"}]}], 
              RowBox[{"6", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             FractionBox[
              RowBox[{"2", " ", "\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"+\"\>"],
                 TraditionalForm], ".", "uq"}]}], 
              RowBox[{"3", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["g", "s"],
               TraditionalForm], " ", 
              RowBox[{
               FormBox[
                SuperscriptBox["T", "a$181"],
                TraditionalForm], ".", "uq"}], " ", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "a$181"}]],
               TraditionalForm]}], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "uq"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["vl", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "vl", ")"}],
              TraditionalForm], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "vl"}]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "vl"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"CKM", " ", 
              RowBox[{
               FormBox[
                SuperscriptBox["uq", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "dq"}], " ", 
              FormBox[
               SubscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], "+", 
             RowBox[{
              RowBox[{
               FormBox[
                SuperscriptBox["vl", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "l"}], " ", 
              FormBox[
               SubscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], "+", 
             RowBox[{
              RowBox[{
               FormBox[
                SuperscriptBox["l", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "vl"}], " ", 
              FormBox[
               SubsuperscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm], "\[Dagger]"],
               TraditionalForm]}], "+", 
             RowBox[{
              RowBox[{
               FormBox[
                SuperscriptBox["dq", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "uq"}], " ", 
              FormBox[
               SuperscriptBox["CKM", "\[Dagger]"],
               TraditionalForm], " ", 
              FormBox[
               SubsuperscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm], "\[Dagger]"],
               TraditionalForm]}]}], ")"}]}], 
          RowBox[{
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["dq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$187"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a$187"}]],
            TraditionalForm]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["dq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$188"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a$188"}]],
            TraditionalForm]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["l", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "l"}]}], 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["l", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "l"}]}], 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["uq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$185"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a$185"}]],
            TraditionalForm]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["uq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$186"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a$186"}]],
            TraditionalForm]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["vl", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["vl", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SqrtBox["2"], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], 
       RowBox[{
        FormBox["e",
         TraditionalForm], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CKM", " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["uq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["vl", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "l"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{"CKM", " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["uq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["vl", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "l"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["l", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "vl"}], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["dq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SuperscriptBox["CKM", "\[Dagger]"],
            TraditionalForm], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["l", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "vl"}], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["dq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SuperscriptBox["CKM", "\[Dagger]"],
            TraditionalForm], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}]}], ")"}]}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.45406122390963*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LagY"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.4119104032372026`*^9, 3.411910404165523*^9}, 3.4540523167591047`*^9, {
   3.454057108491197*^9, 3.4540571095455637`*^9}, 3.454061225806781*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{"-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            RowBox[{
             FormBox[
              SubsuperscriptBox["dq", 
               RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["dq", 
               RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
              TraditionalForm]}], " ", 
            FormBox[
             SubscriptBox[
              RowBox[{"(", 
               SubscriptBox["P", "\<\"+\"\>"], ")"}], 
              RowBox[{"s$194", ",", "r$194"}]],
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["yd", "n$194"],
             TraditionalForm]}], 
           SqrtBox["2"]]}], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["dq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["dq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yd", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"s$194", ",", "n$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"r$194", ",", "n$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"r$195", ",", "n$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"s$195", ",", "n$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.454061226531508*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The MUED total Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.452857023659556*^9, 3.452857026196998*^9}, {
  3.454050603115306*^9, 3.454050604633585*^9}, {3.4540508481103973`*^9, 
  3.454050850614224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LagLED", ":=", 
   RowBox[{"LagH", "+", "LagG", "+", "LagF", "+", "LagY"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.454056821219754*^9, 3.4540568403918133`*^9}, {
  3.454057126321587*^9, 3.454057148256241*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman Rules", "Section",
 CellChangeTimes->{{3.4050095696734943`*^9, 3.4050095702696466`*^9}, {
   3.449909557093049*^9, 3.449909562576384*^9}, 3.452923012401949*^9, {
   3.45405673743528*^9, 3.4540567428169327`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.454057138248085*^9, 3.454057139479412*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LagG", ",", " ", 
   RowBox[{"FlavorExpand", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.45406138410235*^9, 3.454061389893989*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LagH", "]"}]], "Input",
 CellChangeTimes->{{3.454061456389081*^9, 3.454061463346387*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LagF", "]"}]], "Input",
 CellChangeTimes->{{3.454056857284236*^9, 3.4540568672993917`*^9}, 
   3.4540569533264227`*^9, {3.4540571289311743`*^9, 3.4540571290168457`*^9}, {
   3.454061235719533*^9, 3.45406124186089*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LagY", "]"}]], "Input",
 CellChangeTimes->{{3.454061488319646*^9, 3.454061493153029*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The MUED total Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.452857023659556*^9, 3.452857026196998*^9}, {
  3.454050603115306*^9, 3.454050604633585*^9}, {3.4540508481103973`*^9, 
  3.454050850614224*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LagLED", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.454056821219754*^9, 3.4540568403918133`*^9}, {
  3.454057126321587*^9, 3.454057148256241*^9}, {3.454061660010816*^9, 
  3.454061677201768*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{823, 679},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowSelection->True,
Magnification->1.,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 294, 4, 76, "Title"],
Cell[CellGroupData[{
Cell[909, 31, 114, 1, 67, "Section"],
Cell[1026, 34, 120, 2, 31, "Input"],
Cell[1149, 38, 747, 15, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1933, 58, 209, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[2167, 65, 262, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[2454, 73, 219, 4, 24, "Print"],
Cell[2676, 79, 194, 3, 24, "Print"],
Cell[2873, 84, 187, 3, 24, "Print"],
Cell[3063, 89, 326, 7, 24, "Print"],
Cell[3392, 98, 187, 3, 24, "Print"],
Cell[3582, 103, 226, 4, 24, "Print"],
Cell[3811, 109, 218, 4, 24, "Print"],
Cell[4032, 115, 223, 4, 24, "Print"],
Cell[4258, 121, 224, 4, 24, "Print"],
Cell[4485, 127, 224, 4, 24, "Print"],
Cell[4712, 133, 178, 3, 24, "Print"],
Cell[4893, 138, 208, 4, 24, "Print"],
Cell[5104, 144, 212, 4, 24, "Print"],
Cell[5319, 150, 209, 4, 24, "Print"],
Cell[5531, 156, 371, 8, 45, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5963, 171, 212, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[6200, 178, 154, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[6379, 184, 242, 3, 31, "Input"],
Cell[6624, 189, 15096, 478, 316, "Output"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21769, 673, 154, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[21948, 679, 239, 3, 31, "Input"],
Cell[22190, 684, 13615, 444, 346, "Output"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35854, 1134, 158, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[36037, 1140, 292, 4, 31, "Input"],
Cell[36332, 1146, 44635, 1366, 898, "Output"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81016, 2518, 155, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[81196, 2524, 246, 3, 31, "Input"],
Cell[81445, 2529, 5607, 172, 375, "Output"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87101, 2707, 216, 3, 25, "Subsubsection"],
Cell[87320, 2712, 248, 6, 31, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87617, 2724, 244, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[87886, 2731, 154, 2, 25, "Subsubsection"],
Cell[88043, 2735, 210, 4, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88290, 2744, 154, 2, 25, "Subsubsection"],
Cell[88447, 2748, 134, 2, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88618, 2755, 158, 2, 25, "Subsubsection"],
Cell[88779, 2759, 263, 4, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89079, 2768, 155, 2, 25, "Subsubsection"],
Cell[89237, 2772, 134, 2, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89408, 2779, 216, 3, 25, "Subsubsection"],
Cell[89627, 2784, 314, 6, 31, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
