(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
(*                                                                             *)
(*         This file has been automatically generated by FeynRules.            *)
(*                                                                             *)
(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)


FR$ModelInformation={
  ModelName->"InertDoublet",
  Authors -> {"Andreas Goudelis, Bjoern Herrmann, Oscal Stal"},
  Version -> "1.0",
  Date -> "04. 10. 2013",
  Institutions -> {"LAPTh-Annecy, Oscar Klein Center-Stockholm"},
  Emails -> {"andreas.goudelis@lapth.cnrs.fr"}};

FR$ClassesTranslation={};

FR$InteractionOrderPerturbativeExpansion={{HIG, 0}, {QCD, 0}, {QED, 0}};

FR$GoldstoneList={S[2], S[3]};

(*     Declared indices    *)

IndexRange[ Index[Generation] ] = Range[ 3 ]

IndexRange[ Index[Colour] ] = NoUnfold[ Range[ 3 ] ]

IndexRange[ Index[Gluon] ] = NoUnfold[ Range[ 8 ] ]

IndexRange[ Index[SU2W] ] = Range[ 3 ]

(*     Declared particles    *)

M$ClassesDescription = {
F[1] == {
    SelfConjugate -> False,
    Indices -> {Index[Generation]},
    PropagatorLabel -> "v",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Mnu },

F[2] == {
    SelfConjugate -> False,
    Indices -> {Index[Generation]},
    QuantumNumbers -> {-Q},
    PropagatorLabel -> "l",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Ml },

F[3] == {
    SelfConjugate -> False,
    Indices -> {Index[Generation], Index[Colour]},
    QuantumNumbers -> {(2*Q)/3},
    PropagatorLabel -> "uq",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Mu },

F[4] == {
    SelfConjugate -> False,
    Indices -> {Index[Generation], Index[Colour]},
    QuantumNumbers -> {-1/3*Q},
    PropagatorLabel -> "dq",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> Md },

V[1] == {
    SelfConjugate -> True,
    Indices -> {},
    PropagatorLabel -> "\\gamma",
    PropagatorType -> Sine,
    PropagatorArrow -> None,
    Mass -> 0 },

V[2] == {
    SelfConjugate -> True,
    Indices -> {},
    PropagatorLabel -> "Z",
    PropagatorType -> Sine,
    PropagatorArrow -> None,
    Mass -> MZ },

V[3] == {
    SelfConjugate -> False,
    Indices -> {},
    QuantumNumbers -> {Q},
    PropagatorLabel -> "W",
    PropagatorType -> Sine,
    PropagatorArrow -> Forward,
    Mass -> MW },

V[4] == {
    SelfConjugate -> True,
    Indices -> {Index[Gluon]},
    PropagatorLabel -> "G",
    PropagatorType -> Cycles,
    PropagatorArrow -> None,
    Mass -> 0 },

U[1] == {
    SelfConjugate -> False,
    Indices -> {},
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> uA,
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> 0 },

U[2] == {
    SelfConjugate -> False,
    Indices -> {},
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> uZ,
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MZ },

U[3] == {
    SelfConjugate -> False,
    Indices -> {},
    QuantumNumbers -> {Q, GhostNumber},
    PropagatorLabel -> uWp,
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MW },

U[4] == {
    SelfConjugate -> False,
    Indices -> {},
    QuantumNumbers -> {-Q, GhostNumber},
    PropagatorLabel -> uWm,
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MW },

U[5] == {
    SelfConjugate -> False,
    Indices -> {Index[Gluon]},
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> uG,
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> 0 },

S[1] == {
    SelfConjugate -> True,
    Indices -> {},
    PropagatorLabel -> "h",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> mh },

S[2] == {
    SelfConjugate -> True,
    PropagatorLabel -> "G0",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MZ,
    Indices -> {} },

S[3] == {
    SelfConjugate -> False,
    PropagatorLabel -> "Gch",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    QuantumNumbers -> {Q},
    Mass -> MW,
    Indices -> {} },

S[4] == {
    SelfConjugate -> True,
    Indices -> {},
    PropagatorLabel -> "H0",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MH0 },

S[5] == {
    SelfConjugate -> True,
    Indices -> {},
    PropagatorLabel -> "A0",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MA0 },

S[6] == {
    SelfConjugate -> False,
    Indices -> {},
    QuantumNumbers -> {Q},
    PropagatorLabel -> "Hch",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> Forward,
    Mass -> MHch }
}


(*        Definitions       *)


Mnu[ 1 ] := Mnue;
Mnu[ 2 ] := Mnum;
Mnu[ 3 ] := Mnut;
Ml[ 1 ] := Me;
Ml[ 2 ] := MM;
Ml[ 3 ] := MTA;
Mu[ 1, _ ] := MU;
Mu[ 1 ] := MU;
Mu[ 2, _ ] := MC;
Mu[ 2 ] := MC;
Mu[ 3, _ ] := MT;
Mu[ 3 ] := MT;
Md[ 1, _ ] := MD;
Md[ 1 ] := MD;
Md[ 2, _ ] := MS;
Md[ 2 ] := MS;
Md[ 3, _ ] := MB;
Md[ 3 ] := MB;
MZ[ ___ ] := MZ;
MW[ ___ ] := MW;
mh[ ___ ] := mh;
MH0[ ___ ] := MH0;
MA0[ ___ ] := MA0;
MHch[ ___ ] := MHch;


TheLabel[ F[1, {1}] ] := "ve";
TheLabel[ F[1, {2}] ] := "vm";
TheLabel[ F[1, {3}] ] := "vt";
TheLabel[ F[2, {1}] ] := "e";
TheLabel[ F[2, {2}] ] := "m";
TheLabel[ F[2, {3}] ] := "tau";
TheLabel[ F[3, {1, _}] ] := "u";
TheLabel[ F[3, {1}] ] := "u";
TheLabel[ F[3, {2, _}] ] := "c";
TheLabel[ F[3, {2}] ] := "c";
TheLabel[ F[3, {3, _}] ] := "t";
TheLabel[ F[3, {3}] ] := "t";
TheLabel[ F[4, {1, _}] ] := "d";
TheLabel[ F[4, {1}] ] := "d";
TheLabel[ F[4, {2, _}] ] := "s";
TheLabel[ F[4, {2}] ] := "s";
TheLabel[ F[4, {3, _}] ] := "b";
TheLabel[ F[4, {3}] ] := "b";
TheLabel[ V[4, {__}] ] := TheLabel[V[4]];
TheLabel[ U[5, {__}] ] := TheLabel[U[5]];


(*      Couplings (calculated by FeynRules)      *)

M$CouplingMatrices = {

C[ S[1] , S[1] , S[1] , S[1] ] == {{(-6*I)*lam, 0}},

C[ S[5] , S[5] , S[5] , S[5] ] == {{(-6*I)*lam2, 0}},

C[ S[5] , S[5] , S[4] , S[4] ] == {{(-2*I)*lam2, 0}},

C[ S[4] , S[4] , S[4] , S[4] ] == {{(-6*I)*lam2, 0}},

C[ S[5] , S[5] , S[6] , -S[6] ] == {{(-2*I)*lam2, 0}},

C[ S[4] , S[4] , S[6] , -S[6] ] == {{(-2*I)*lam2, 0}},

C[ S[6] , S[6] , -S[6] , -S[6] ] == {{(-4*I)*lam2, 0}},

C[ S[5] , S[5] , S[1] , S[1] ] == {{(-I)*(lam3 + lam4 - lam5), 0}},

C[ S[1] , S[1] , S[4] , S[4] ] == {{(-I)*(lam3 + lam4 + lam5), 0}},

C[ S[1] , S[1] , S[6] , -S[6] ] == {{(-I)*lam3, 0}},

C[ S[1] , S[1] , S[1] ] == {{(-6*I)*lam*v, 0}},

C[ S[5] , S[5] , S[1] ] == {{(-I)*(lam3 + lam4 - lam5)*v, 0}},

C[ S[1] , S[4] , S[4] ] == {{(-I)*(lam3 + lam4 + lam5)*v, 0}},

C[ S[1] , S[6] , -S[6] ] == {{(-I)*lam3*v, 0}},

C[ S[6] , -S[6] , V[1] , V[1] ] == {{(2*I)*EL^2, 0}},

C[ S[6] , -S[6] , V[1] ] == {{(-I)*gc16, 0}, {I*gc16, 0}},

C[ S[1] , V[4, {e1x2}] , V[4, {e2x2}] ] == {{(-I)*gc17*IndexDelta[e1x2, e2x2], 0}, {I*gc17*IndexDelta[e1x2, e2x2], 0}, {0, 0}},

C[ -U[5, {e1x1}] , U[5, {e2x1}] , V[4, {e3x2}] ] == {{gc18*SUNF[e3x2, e1x1, e2x1], 0}, {gc18*SUNF[e3x2, e1x1, e2x1], 0}, {0, 0}},

C[ V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] ] == {{-(gc19*SUNF[e1x2, e2x2, e3x2]), 0}, {gc19*SUNF[e1x2, e2x2, e3x2], 0}, {gc19*SUNF[e1x2, e2x2, e3x2], 0}, {-(gc19*SUNF[e1x2, e2x2, e3x2]), 0}, {-(gc19*SUNF[e1x2, e2x2, e3x2]), 0}, {gc19*SUNF[e1x2, e2x2, e3x2], 0}},

C[ V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] , V[4, {e4x2}] ] == {{(-I)*gc20*(SUNF[e1x2, e2x2, e3x2, e4x2] + SUNF[e1x2, e3x2, e2x2, e4x2]), 0}, {I*gc20*(SUNF[e1x2, e2x2, e3x2, e4x2] - SUNF[e1x2, e4x2, e2x2, e3x2]), 0}, {I*gc20*(SUNF[e1x2, e3x2, e2x2, e4x2] + SUNF[e1x2, e4x2, e2x2, e3x2]), 0}},

C[ S[1] , V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] ] == {{-(gc21*SUNF[e1x2, e2x2, e3x2]), 0}, {gc21*SUNF[e1x2, e2x2, e3x2], 0}, {gc21*SUNF[e1x2, e2x2, e3x2], 0}, {-(gc21*SUNF[e1x2, e2x2, e3x2]), 0}, {-(gc21*SUNF[e1x2, e2x2, e3x2]), 0}, {gc21*SUNF[e1x2, e2x2, e3x2], 0}},

C[ S[1] , V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] , V[4, {e4x2}] ] == {{(-I)*gc22*(SUNF[e1x2, e2x2, e3x2, e4x2] + SUNF[e1x2, e3x2, e2x2, e4x2]), 0}, {I*gc22*(SUNF[e1x2, e2x2, e3x2, e4x2] - SUNF[e1x2, e4x2, e2x2, e3x2]), 0}, {I*gc22*(SUNF[e1x2, e3x2, e2x2, e4x2] + SUNF[e1x2, e4x2, e2x2, e3x2]), 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] ] == {{I*gc23[e1x2]*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc23[e1x2]*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , S[1] ] == {{I*gc24[e1x2]*IndexDelta[e1x2, e2x2], 0}, {I*gc24[e1x2]*IndexDelta[e1x2, e2x2], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] ] == {{I*gc25[e1x2]*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc25[e1x2]*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[4, {e3x2}] ] == {{I*gc26*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {I*gc26*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[4, {e3x2}] ] == {{I*gc27*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {I*gc27*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}},

C[ S[5] , -S[6] , V[1] , V[3] ] == {{-1/2*EL^2/SW, 0}},

C[ S[4] , -S[6] , V[1] , V[3] ] == {{((I/2)*EL^2)/SW, 0}},

C[ S[5] , -S[6] , V[3] ] == {{-gc30, 0}, {gc30, 0}},

C[ S[4] , -S[6] , V[3] ] == {{(-I)*gc31, 0}, {I*gc31, 0}},

C[ V[1] , V[3] , -V[3] ] == {{(-I)*gc32, 0}, {I*gc32, 0}, {I*gc32, 0}, {(-I)*gc32, 0}, {(-I)*gc32, 0}, {I*gc32, 0}},

C[ S[5] , S[6] , V[1] , -V[3] ] == {{EL^2/(2*SW), 0}},

C[ S[4] , S[6] , V[1] , -V[3] ] == {{((I/2)*EL^2)/SW, 0}},

C[ S[5] , S[6] , -V[3] ] == {{-gc35, 0}, {gc35, 0}},

C[ S[4] , S[6] , -V[3] ] == {{(-I)*gc36, 0}, {I*gc36, 0}},

C[ S[5] , S[5] , V[3] , -V[3] ] == {{((I/2)*EL^2)/SW^2, 0}},

C[ S[1] , S[1] , V[3] , -V[3] ] == {{((I/2)*EL^2)/SW^2, 0}},

C[ S[4] , S[4] , V[3] , -V[3] ] == {{((I/2)*EL^2)/SW^2, 0}},

C[ S[6] , -S[6] , V[3] , -V[3] ] == {{((I/2)*EL^2)/SW^2, 0}},

C[ S[1] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {I*gc41, 0}},

C[ V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc42, 0}, {(-I)*gc42, 0}, {(2*I)*gc42, 0}},

C[ V[3] , -V[3] , V[2] ] == {{(-I)*gc43, 0}, {I*gc43, 0}, {I*gc43, 0}, {(-I)*gc43, 0}, {(-I)*gc43, 0}, {I*gc43, 0}},

C[ V[3] , V[3] , -V[3] , -V[3] ] == {{(-I)*gc44, 0}, {(-I)*gc44, 0}, {(2*I)*gc44, 0}},

C[ S[6] , -S[6] , V[1] , V[2] ] == {{(I*EL^2*(CW - SW)*(CW + SW))/(CW*SW), 0}},

C[ S[5] , S[4] , V[2] ] == {{-gc46, 0}, {gc46, 0}},

C[ S[6] , -S[6] , V[2] ] == {{(-I)*gc47, 0}, {I*gc47, 0}},

C[ S[5] , -S[6] , V[3] , V[2] ] == {{EL^2/(2*CW), 0}},

C[ S[4] , -S[6] , V[3] , V[2] ] == {{((-1/2*I)*EL^2)/CW, 0}},

C[ S[5] , S[6] , -V[3] , V[2] ] == {{-1/2*EL^2/CW, 0}},

C[ S[4] , S[6] , -V[3] , V[2] ] == {{((-1/2*I)*EL^2)/CW, 0}},

C[ V[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*gc52, 0}, {I*gc52, 0}, {I*gc52, 0}},

C[ S[5] , S[5] , V[2] , V[2] ] == {{((I/2)*EL^2*(CW^2 + SW^2)^2)/(CW^2*SW^2), 0}},

C[ S[1] , S[1] , V[2] , V[2] ] == {{((I/2)*EL^2*(CW^2 + SW^2)^2)/(CW^2*SW^2), 0}},

C[ S[4] , S[4] , V[2] , V[2] ] == {{((I/2)*EL^2*(CW^2 + SW^2)^2)/(CW^2*SW^2), 0}},

C[ S[6] , -S[6] , V[2] , V[2] ] == {{((I/2)*EL^2*(CW - SW)^2*(CW + SW)^2)/(CW^2*SW^2), 0}},

C[ S[1] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {I*gc57, 0}},

C[ V[3] , -V[3] , V[2] , V[2] ] == {{(-I)*gc58, 0}, {(-I)*gc58, 0}, {(2*I)*gc58, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[1] ] == {{I*gc59*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc59*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , V[1] ] == {{I*gc60*IndexDelta[e1x2, e2x2], 0}, {I*gc60*IndexDelta[e1x2, e2x2], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[1] ] == {{I*gc61*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc61*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[1, {e1x2}] , F[2, {e2x2}] , V[3] ] == {{I*gc62*IndexDelta[e1x2, e2x2], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[3] ] == {{I*gc63[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[1, {e2x2}] , -V[3] ] == {{I*gc64*IndexDelta[e1x2, e2x2], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -V[3] ] == {{I*gc65[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[2] ] == {{I*gc66L*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc66R*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , V[2] ] == {{I*gc67L*IndexDelta[e1x2, e2x2], 0}, {I*gc67R*IndexDelta[e1x2, e2x2], 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[2] ] == {{I*gc68L*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {I*gc68R*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}},

C[ -F[1, {e1x2}] , F[1, {e2x2}] , V[2] ] == {{I*gc69*IndexDelta[e1x2, e2x2], 0}, {0, 0}}

}

(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)

(* Parameter replacement lists (These lists were created by FeynRules) *)

(* FA Couplings *)

M$FACouplings = {
     gc16 -> -EL,
     gc17 -> GH,
     gc18 -> GS,
     gc19 -> -GS,
     gc20 -> -GS^2,
     gc21 -> -(GH*GS),
     gc22 -> -(GH*GS^2),
     gc23[e1x2_] -> -(Md[e1x2]/v),
     gc24[e1x2_] -> -(Ml[e1x2]/v),
     gc25[e1x2_] -> -(Mu[e1x2]/v),
     gc26 -> GS,
     gc27 -> GS,
     gc30 -> EL/(2*SW),
     gc31 -> -1/2*EL/SW,
     gc32 -> EL,
     gc35 -> EL/(2*SW),
     gc36 -> EL/(2*SW),
     gc41 -> (EL^2*v)/(2*SW^2),
     gc42 -> -EL^2,
     gc43 -> (CW*EL)/SW,
     gc44 -> EL^2/SW^2,
     gc46 -> -1/2*(EL*(CW^2 + SW^2))/(CW*SW),
     gc47 -> -1/2*(CW*EL)/SW + (EL*SW)/(2*CW),
     gc52 -> (CW*EL^2)/SW,
     gc57 -> (EL^2*(CW^2 + SW^2)^2*v)/(2*CW^2*SW^2),
     gc58 -> -((CW^2*EL^2)/SW^2),
     gc59 -> -1/3*EL,
     gc60 -> -EL,
     gc61 -> (2*EL)/3,
     gc62 -> EL/(Sqrt[2]*SW),
     gc63[e1x2_, e2x2_] -> (EL*CKM[e1x2, e2x2])/(Sqrt[2]*SW),
     gc64 -> EL/(Sqrt[2]*SW),
     gc65[e1x2_, e2x2_] -> (EL*Conjugate[CKM[e2x2, e1x2]])/(Sqrt[2]*SW),
     gc66L -> -1/6*(EL*(3*CW^2 + SW^2))/(CW*SW),
     gc66R -> (EL*SW)/(3*CW),
     gc67L -> -1/2*(EL*(CW^2 - SW^2))/(CW*SW),
     gc67R -> (EL*SW)/CW,
     gc68L -> (CW*EL)/(2*SW) - (EL*SW)/(6*CW),
     gc68R -> (-2*EL*SW)/(3*CW),
     gc69 -> (EL*(CW^2 + SW^2))/(2*CW*SW)};

