(*********************************************)
(*** PARTICLE CONTENT EXCEPT SCALAR SECTOR ***)
(*********************************************)

M$ClassesDescription = {

(*--------------*)
(*** FERMIONS ***)
(*--------------*)

(* Neutrinos: I_3 = +1/2, Q = 0 *)
F[1] == {
	ClassName        -> vl,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation]},
	ClassMembers     -> {ve, vm, vt},
	FlavorIndex      -> Generation,
	Mass             -> {Mnu,{Mnue, 0.},{Mnum, 0.},{Mnut, 0.}},
	Width            -> {Wnu, {Wnue, 0}, {Wnumu, 0}, {Wnut, 0}},
	ParticleName     -> {"ne", "nm", "nl"},
	AntiParticleName -> {"Ne","Nm","Nl"},
	PDG              -> {12, 14, 16}, 
	PropagatorLabel  -> {"v", "ve", "vm", "vt"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,
	FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} }, 

(* Charged leptons: I_3 = -1/2, Q = -1 *)
F[2] == {
	ClassName        -> l,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation]},
	QuantumNumbers   -> {Q ->-1},
	ClassMembers     -> {e, m, ta},
	FlavorIndex      -> Generation,
	Mass		 -> {Ml, {Me, 0.}, {MM, 0.1057}, {MTA, 1.777}},
	Width            -> {Wl, {WE, 0}, {WM, 0}, {WTA, 0}},
	ParticleName     -> {"e", "m", "l"},
	AntiParticleName -> {"E", "M", "L"},
	PDG              -> {11, 13, 15}, 
	PropagatorLabel  -> {"l", "e", "m", "tau"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,    
        FullName -> {"Electron", "Muon", "Tau"} },




(* u-type quarks: I_3 = +1/2, Q = +2/3 *)
F[3] == {
	ClassName        -> uq,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation], Index[Colour]},
	QuantumNumbers   -> {Q -> 2/3},
	ClassMembers     -> {u, c, t},
	FlavorIndex      -> Generation,
	Mass             -> {Mu, {MU, 0.}, {MC, Internal}, {MT, Internal}},
	Width            -> {Wu, {WU, 0}, {WC, 0}, {WT, 2.0}},
	ParticleName     -> {"u", "c", "t"},
	AntiParticleName -> {"U", "C", "T"},
	PDG              -> {2, 4, 6}, 
	PropagatorLabel  -> {"uq", "u", "c", "t"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,    
        FullName -> {"u-quark", "c-quark", "t-quark"}},


(* d-type quarks: I_3 = -1/2, Q = -1/3 *) 
F[4] == {
	ClassName        -> dq,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation], Index[Colour]},
	QuantumNumbers   -> {Q -> -1/3},
	ClassMembers     -> {d, s, b},
	FlavorIndex      -> Generation,
	Mass             -> {Md, {MD, 0.}, {MS, 0.1}, {MB, Internal}},
	Width            -> {Wd, {WD, 0}, {WS, 0}, {WB, 0}},
	ParticleName     -> {"d", "s", "b"},
	AntiParticleName -> {"D", "S", "B"},
	PDG              -> {1, 3, 5}, 
	PropagatorLabel  -> {"dq", "d", "s", "b"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,    
        FullName -> {"d-quark", "s-quark", "b-quark"}},


(*------------------*)
(*** GAUGE BOSONS ***)
(*------------------*)

(* Mass Eigenstates *)
V[1] == {
	ClassName       ->  A,
	SelfConjugate   ->  True,
	Indices         -> {},
	Mass            ->  0,
	Width           ->  0,
	ParticleName    ->  "a",
	PDG             ->  22,
	PropagatorLabel ->  "\\gamma",
	PropagatorType  -> Sine,
	PropagatorArrow -> None},
V[2] == {
	ClassName       ->  Z,
	SelfConjugate   ->  True,
	Indices         -> {},
	Mass            -> {MZ,Internal},
	Width           -> {WZ,2.4952},
	ParticleName    ->  "Z",
	PDG             ->  23,
	PropagatorLabel ->  "Z",
	PropagatorType  -> Sine,
	PropagatorArrow -> None},
V[3] == {
	ClassName       -> W,
	SelfConjugate   -> False,
	Indices         -> {},
	Mass            -> {MW,Internal},
	Width           -> {WW,2.085},
	QuantumNumbers  -> {Q -> 1},
	ParticleName    -> "W+",
	AntiParticleName-> "W-",
	PDG             -> 24,
	PropagatorLabel -> "W",
	PropagatorType  -> Sine,
	PropagatorArrow -> Forward},

V[4] == {
	ClassName       -> G,
	SelfConjugate   -> True,
	Indices         -> {Index[Gluon]},
	Mass            -> 0,
	Width           -> 0,
	ParticleName    ->  "g",
	PDG             -> 21,
	PropagatorLabel -> "G",
	PropagatorType  -> C,
	PropagatorArrow -> None}, 

(* Gauge Eigenstates and relation to mass eigenstates *)
V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0, 
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> CW Z[mu] + SW A[mu]}}, 

V[6] == {
        ClassName -> B,
	Unphysical -> True,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
        Definitions -> {B[mu_] -> -SW Z[mu] + CW A[mu]}}, 

(*--------------------------*)
(*** Vector boson ghosts  ***)
(*--------------------------*)

(* mass eigenstates *)
U[1] == {
	ClassName -> ghA,
	SelfConjugate -> False,
	Indices -> {},
	Ghost -> A,
	Mass -> 0,
	QuantumNumbers -> {GhostNumber -> 1},
	PropagatorLabel -> uA,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[2] == {
	ClassName -> ghZ,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MZ, Internal},
	Ghost -> Z,
	QuantumNumbers -> {GhostNumber -> 1},
	PropagatorLabel -> uZ,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[3] == {
	ClassName -> ghWp,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
	Ghost -> W,
	QuantumNumbers -> {Q-> 1, GhostNumber -> 1},
	PropagatorLabel -> uWp,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[4] == {
	ClassName -> ghWm,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
	Ghost -> Wbar,
	QuantumNumbers -> {Q-> -1, GhostNumber -> 1},
	PropagatorLabel -> uWm,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[5] == {
	ClassName -> ghG,
	SelfConjugate -> False,
	Indices -> {Index[Gluon]},
	Ghost -> G,
	Mass -> 0,
	QuantumNumbers -> {GhostNumber -> 1},
	PropagatorLabel -> uG,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

(* gauge eigenstates *)
U[6] == {
	ClassName -> ghWi,
	Unphysical -> True,
	Definitions -> {ghWi[1] -> (ghWp + ghWm)/Sqrt[2],
                        ghWi[2] -> (ghWm - ghWp)/Sqrt[2]/I,
                        ghWi[3] -> CW ghZ + SW ghA},
	SelfConjugate -> False,
	Ghost -> Wi,
	Indices -> {Index[SU2W]},
	FlavorIndex -> SU2W},

U[7] == {
	ClassName -> ghB,
	SelfConjugate -> False,
	Definitions -> {ghB -> -SW ghZ + CW ghA},
	Indices -> {},
	Ghost -> B,
	Unphysical -> True}

};


