(**********************)
(*** IDM LAGRANGIAN ***)
(**********************)

(*--------------------------------*)
(*** Gauge field strength terms ***)
(*--------------------------------*)

LGauge := -1/4*(del[B[nu],mu] - del[B[mu],nu])^2  - 
	   1/4*(del[Wi[nu,i1],mu]-del[Wi[mu,i1],nu] + ee/SW*Eps[i1,i2,i3]*Wi[mu,i2]*Wi[nu,i3]) *
	       (del[Wi[nu,i1],mu]-del[Wi[mu,i1],nu] + ee/SW*Eps[i1,i4,i5]*Wi[mu,i4]*Wi[nu,i5]) - 
	   1/4*(del[G[nu,a1],mu] - del[G[mu,a1],nu] + gs*f[a1,a2,a3]*G[mu,a2]*G[nu,a3])*
	       (del[G[nu,a1],mu] - del[G[mu,a1],nu] + gs*f[a1,a4,a5]*G[mu,a4]*G[nu,a5]);

(*-------------------------*)
(*** Gauge-fermion terms ***)
(*-------------------------*)

LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

        Lkin = I uqbar.Ga[mu].del[uq, mu] + 
	       I dqbar.Ga[mu].del[dq, mu] + 
	       I lbar.Ga[mu].del[l, mu] + 
	       I vlbar.Ga[mu].del[vl, mu];

	LQCD = gs (uqbar.Ga[mu].T[a].uq + 
	       dqbar.Ga[mu].T[a].dq)G[mu, a];

	LBright = 
	      -2 ee/CW B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
	     4/3 ee/CW B[mu]/2 uqbar.Ga[mu].ProjP.uq -         (*Y_uR=4/3*)
	     2/3 ee/CW B[mu]/2 dqbar.Ga[mu].ProjP.dq;          (*Y_dR=-2/3*)

	LBleft = 
	        -ee/CW B[mu]/2 vlbar.Ga[mu].ProjM.vl -         (*Y_LL=-1*)
	         ee/CW B[mu]/2 lbar.Ga[mu].ProjM.l  +          (*Y_LL=-1*)
	     1/3 ee/CW B[mu]/2 uqbar.Ga[mu].ProjM.uq +         (*Y_QL=1/3*)
	     1/3 ee/CW B[mu]/2 dqbar.Ga[mu].ProjM.dq ;         (*Y_QL=1/3*)
	
	LWleft = 1/2 ee/SW (
	vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+
    	
	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
	);

	Lkin + LQCD + LBright + LBleft + LWleft];

(*-----------------------*)
(*** Yukawa lagrangian ***)
(*-----------------------*)

LYuk := 
	If[FeynmanGauge, Module[{s,r,n,m,i}, 
	- yd[n] CKM[n,m] uqbar[s,n,i].ProjP[s,r].dq[r,m,i] (Gch)
	- yd[n]          dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+h+I G0)/Sqrt[2]
	 
	- yu[n]                     uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+h-I G0)/Sqrt[2]
	+ yu[n] Conjugate[CKM[m,n]] dqbar[s,n,i].ProjP[s,r].uq[r,m,i] (Gchbar)    (*+ sign from eps matrix*)	
	
	- yl[n] vlbar[s,n].ProjP[s,r].l[r,n] (Gch)
	- yl[n] lbar[s,n].ProjP[s,r].l[r,n] (v+h+I G0)/Sqrt[2]
	],

	Module[{s,r,n,m,i},
	- yd[n] dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+h)/Sqrt[2]
	- yu[n] uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+h)/Sqrt[2]
	- yl[n] lbar[s,n].ProjP[s,r].l[r,n] (v+h)/Sqrt[2]
	]

	];

LYukawa := LYuk + HC[LYuk];


(*-----------------------*)
(*** Scalar lagrangian ***)
(*-----------------------*)

(* Usual higgs doublet *)
Phi1 := If[FeynmanGauge, {Gch, (v + h + I G0)/Sqrt[2]}, {0, (v + h)/Sqrt[2]}];
Phi1bar := If[FeynmanGauge, {Gchbar, (v + h - I G0)/Sqrt[2]}, {0, (v + h)/Sqrt[2]}];
(* Inert doublet *)
Phi2 := {Hch, (H0 + I A0)/Sqrt[2]};
Phi2bar := {Hchbar, (H0 - I A0)/Sqrt[2]};

LScalar := Block[{PMVec, WVec, Dc, Dcbar, Vphi},

(* Vector of Pauli matrices *)
	PMVec = Table[PauliSigma[i], {i, 3}];
(* Vector of gauge bosons - gauge eigenstates *)
	Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

(* Covariant derivative, Y_phi1 = 1 for both scalar doublets *)
	Dc[f_, mu_] := del[f, mu] - I ee/CW B[mu]/2 f - I 1/2 ee/SW (Wvec[mu].PMVec).f;
	Dcbar[f_, mu_] :=  HC[Dc[f, mu]];

(* Covariant derivative terms *)
	Lcov :=
	HC[Dc[Phi1, mu]].Dc[Phi1, mu] +
	HC[Dc[Phi2, mu]].Dc[Phi2, mu];

(* Scalar potential *)
	Vscalar := 
	mu1^2 Phi1bar.Phi1 + mu2^2 Phi2bar.Phi2 + lam (Phi1bar.Phi1)^2 +
	lam2 (Phi2bar.Phi2)^2 + lam3 (Phi1bar.Phi1) (Phi2bar.Phi2) + 
	lam4 HC[(Phi1bar.Phi2)] (Phi1bar.Phi2) +
	lam5/2 ((Phi1bar.Phi2)^2 + HC[(Phi1bar.Phi2)^2]);

	Lcov - Vscalar];

(*----------------------*)
(*** Ghost lagrangian ***)
(*----------------------*)

(* First the ghost terms that can be derived through              *)
(* the BRST transformations of the gauge-fixing function G:       *)
(* - g * antighost * d_BRST G                                     *)

LGhost := If[FeynmanGauge, 
	Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},
		
	dBRSTG[mu_,a_] := Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - ghGbar[a].del[dBRSTG[mu,a],mu];
	
	dBRSTWi[mu_,i_] := Module[{i2, i3}, del[ghWi[i], mu] + ee/SW Eps[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ghWibar[a].del[dBRSTWi[mu,a],mu];	
 	
	dBRSTB[mu_] := del[ghB, mu];
		LGhostB := - ghBbar.del[dBRSTB[mu],mu];
	
(* Now the part involving ghosts and scalars *)
(* Calculation following Peskin-Schroeder    *)

	LGhostphi := 
	-(-(ee^2*v^2*ghBbar . ghB)/(4*CW^2) + (ee^2*v^2*ghBbar . ghWi[3])/(4*CW*SW) - 
	(ee^2*v^2*ghWibar[1] . ghWi[1])/(4*SW^2) - 
	(ee^2*v^2*ghWibar[2] . ghWi[2])/(4*SW^2) + 
	(ee^2*v^2*ghWibar[3] . ghB)/(4*CW*SW) - 
	(ee^2*v^2*ghWibar[3] . ghWi[3])/(4*SW^2) + 
	(v*((ee^2*h*ghBbar . ghB)/CW^2 + 
	(ee*((ee*(Gch + Gchbar)*ghBbar . ghWi[1])/(Sqrt[2]*CW) - 
	(I*ee*(-Gch + Gchbar)*ghBbar . ghWi[2])/(Sqrt[2]*CW) - 
	(ee*h*ghBbar . ghWi[3])/CW + 
	(ee*(Gch + Gchbar)*ghWibar[1] . ghB)/(Sqrt[2]*CW) + 
	(ee*h*ghWibar[1] . ghWi[1])/SW + (ee*G0*ghWibar[1] . ghWi[2])/SW + 
	(ee*(Gch + Gchbar)*ghWibar[1] . ghWi[3])/(Sqrt[2]*SW) - 
	(I*ee*(-Gch + Gchbar)*ghWibar[2] . ghB)/(Sqrt[2]*CW) - 
	(ee*G0*ghWibar[2] . ghWi[1])/SW + 
	(ee*h*ghWibar[2] . ghWi[2])/SW - 
	(I*ee*(-Gch + Gchbar)*ghWibar[2] . ghWi[3])/(Sqrt[2]*SW) - 
	(ee*h*ghWibar[3] . ghB)/CW - 
	(ee*(Gch + Gchbar)*ghWibar[3] . ghWi[1])/(Sqrt[2]*SW) + 
	(I*ee*(-Gch + Gchbar)*ghWibar[3] . ghWi[2])/(Sqrt[2]*SW) + 
	(ee*h*ghWibar[3] . ghWi[3])/SW))/SW))/4);


(* Total ghost Lagrangian *)
	LGhostG + LGhostWi + LGhostB + LGhostphi],

(* If in Unitary gauge, only write strong sector ghost Lagrangian, needed from CalcHEP *)
Block[{dBRSTG,LGhostG},
		
	dBRSTG[mu_,a_] := Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - ghGbar[a].del[dBRSTG[mu,a],mu];
LGhostG]
];



(*---------------------------------------*)
(* Effective couplign of Higgs to gluons *)
(*---------------------------------------*)

(* Taken from HiggsEffective.fr, by Claude Duhr *)

sert[x_] := 1+ 7/30 x + 2/21 x^2 + 26/525 x^3;

serw[xw_, xt_] := 1 + xw * 66/235 +xw^2 * 228/1645 + xw^3 * 696/8225 +
            xw^4 * 5248/90475 +xw^5 * 1280/29939+ xw^6 * 54528/1646645-
            xt * 56/705 - xt^2 * 32/987;

serp[x_] := 1 + x/3 + x^2 * 8/45 + x^3 * 4/35;

(* We just want the CP-even operator, since we only have the SM Higgs. We also neglect photons. *)

LHGF := -1/4 GH FS[G, mu, nu, b] FS[G, mu, nu, b] h;


(*------------------*)
(* Total lagrangian *)
(*------------------*)
LIDM := ExpandIndices[LGauge + LFermions + LYukawa + LScalar + LGhost + LHGF,FlavorExpand->SU2W];


























