(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     89019,       1917]
NotebookOptionsPosition[     77519,       1765]
NotebookOutlinePosition[     78004,       1782]
CellTagsIndexPosition[     77961,       1779]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\</home/andreas/Dropbox/Work/PhysSoftware/feynrules-current/\>\"", 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/InertDoublet\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.504423447270249*^9, {3.507209594206577*^9, 3.507209600067323*^9}, {
   3.514799374048591*^9, 3.514799404330376*^9}, {3.515062647798441*^9, 
   3.515062653173225*^9}, {3.515135742551162*^9, 3.515135748404658*^9}, {
   3.551191781661876*^9, 3.551191796346917*^9}, {3.589877382659015*^9, 
   3.589877391686277*^9}, {3.589878062567462*^9, 3.589878067455187*^9}, {
   3.589878109496549*^9, 3.589878111197733*^9}, {3.59055306646451*^9, 
   3.590553091624037*^9}, 3.620364186079145*^9, 3.6513843476106796`*^9, {
   3.938065707069236*^9, 3.938065717982358*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7cece50c-3e56-48c2-b3ec-e877905a436e"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.941280787207098*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"02b2b7fd-8234-4362-8500-9703188f34e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.49\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"29 September 2021\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.49", " (" "29 September 2021", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.9412807872081957`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"be224aaa-f41b-4e64-89b6-b13155c651f3"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.941280787210711*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"be22be99-d2a3-466b-aa99-ad6f42bc3b33"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.9412807872114058`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dac6a5c8-0bf2-4692-b65a-7b79bedc7ab5"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.941280787211911*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ee54660e-f0a4-4016-a1e6-619389999876"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.94128078721241*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"54eb55ac-56d5-4ec6-bab5-d12dc2d31d66"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.94128078721294*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a00cec9f-86f6-430e-b129-c027f50db049"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.941280787213443*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"71666727-f414-434f-bdf5-519edde395eb"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.941280787213892*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e051a46a-5355-45f7-8a97-57d23f4c2e37"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.9412807872143707`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d110fe37-8224-4d5b-a42b-292a72e63945"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.620364186909921*^9, 3.620387553662812*^9, 3.62062375467121*^9, 
   3.622980653378627*^9, 3.623481698992816*^9, 3.623481751825109*^9, 
   3.623482123888432*^9, 3.623482844604163*^9, 3.6242538262062397`*^9, 
   3.624686627090362*^9, 3.624686940500444*^9, 3.626641160567983*^9, 
   3.631271599452116*^9, 3.6513843199194202`*^9, 3.651384351399432*^9, {
   3.651384916455903*^9, 3.651384941557245*^9}, 3.938065720751157*^9, 
   3.938066097402618*^9, 3.93807148970428*^9, 3.938071628988179*^9, 
   3.9380718509251833`*^9, 3.938072209976357*^9, 3.93807255031347*^9, 
   3.941280061521058*^9, 3.941280140782176*^9, 3.941280315631666*^9, 
   3.941280589037959*^9, 3.941280787214814*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6046bfac-fc5b-4b1c-b40b-f236fbc79668"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LoadModel", "[", "\"\<InertDoublet.fr\>\"", "]"}], "\n"}]], "Input",\

 CellLabel->"In[4]:=",ExpressionUUID->"81623886-7667-49d4-ac9e-9a9179337cac"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791199132*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"275e5ebd-ab9a-4476-a515-b7daa49d178a"],

Cell[BoxData["\<\"Andreas Goudelis, Bjoern Herrmann, Oscal Stal\"\>"], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.94128079119973*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"24e079a8-e988-4ea9-a6fd-b17720bfd6b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791201642*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"cb65b54c-dd57-48cc-a51b-6a1e3dd41cbf"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791202072*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"7bd9cf07-1d9f-4fb5-9c25-3f95f28db283"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791202489*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"6c0f63de-32b1-450c-9cfe-b51250b6bd17"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791202857*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"96afdaee-2b38-402c-a6e7-1d7362e7e485"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791251667*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c8652dda-ba88-41b3-a10b-63591cf53499"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.9412807912716217`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"f75a9fe0-ae4c-4b27-b19d-53dd9126378e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"InertDoublet\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "InertDoublet", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.620364190288051*^9, 3.620387556920899*^9, 3.620623757409671*^9, 
   3.622980656122402*^9, 3.623481701819859*^9, 3.623481754345433*^9, 
   3.623482126460253*^9, 3.623482847367491*^9, 3.6242538294790773`*^9, 
   3.624686629851543*^9, 3.624686944539651*^9, 3.626641198905284*^9, 
   3.631271605319542*^9, {3.651384331676393*^9, 3.651384359056925*^9}, 
   3.651384944750872*^9, 3.938065728090356*^9, 3.9380661035414653`*^9, 
   3.938071494483484*^9, 3.938071633827214*^9, 3.9380718552546864`*^9, 
   3.938072214414673*^9, 3.938072554852188*^9, 3.941280071678071*^9, 
   3.941280148609954*^9, 3.94128032002876*^9, 3.941280593387932*^9, 
   3.941280791293377*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"238930e4-eacc-4aea-abe2-5bf5234efeeb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LIDM", "]"}]], "Input",
 CellChangeTimes->{{3.50729355972117*^9, 3.50729357227196*^9}, {
   3.507461994530579*^9, 3.507461995379707*^9}, {3.550996361290633*^9, 
   3.550996399258369*^9}, 3.550996440628131*^9, 3.550996576022204*^9, {
   3.550996621148571*^9, 3.550996621557486*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"7858ff5e-6dad-4cc1-9baa-c42459da9a3c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.941280792158575*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"202a6330-d2b4-4a0a-8fe4-53b856c26b01"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.941280792159358*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"b0134443-071b-4545-9b94-86a5cc510872"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.941280795451439*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"c06b9e86-338a-4fe9-b3d4-3033ce4f3f6f"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.941280795452167*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"8d318233-eed8-42d4-839a-d8bdc4e87b20"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.941280795603888*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"07bf669c-a6dd-408f-8821-62a5c127b2b2"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.941280795622575*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"673c3119-61ed-4e3f-9eea-c12601cf2bb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.9412807956231403`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"d6cba5d2-87b7-4141-859f-fdce580b5369"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.620364193402918*^9, 3.620387560124938*^9, 
  3.623481704432773*^9, 3.623481756088407*^9, 3.623482128468701*^9, 
  3.623482849010386*^9, 3.624253831602505*^9, 3.624686634048163*^9, 
  3.62468694675062*^9, 3.626641201076918*^9, 3.631271615472227*^9, 
  3.651384366356309*^9, 3.651384947266684*^9, 3.938065730989196*^9, 
  3.938066105765422*^9, 3.938071495573655*^9, 3.938071634830978*^9, 
  3.93807185620695*^9, 3.938072215425707*^9, 3.938072555847215*^9, 
  3.941280073940393*^9, 3.94128015203994*^9, 3.941280325362845*^9, 
  3.941280594456983*^9, 3.94128079562353*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"2f10a7a9-7b56-4796-9bf0-946ff6874e42"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.620364200338584*^9, 3.620387564204427*^9, 
  3.623481708635837*^9, 3.623481760107847*^9, 3.6234821326550283`*^9, 
  3.623482853209738*^9, 3.624253835685931*^9, 3.6246866382831917`*^9, 
  3.62468695094877*^9, 3.626641205137802*^9, 3.63127162260211*^9, 
  3.65138437317122*^9, 3.65138495148341*^9, 3.93806573435186*^9, 
  3.938066109247896*^9, 3.938071499091899*^9, 3.938071638349683*^9, 
  3.938071859754828*^9, 3.93807221906658*^9, 3.938072559426015*^9, 
  3.941280077371318*^9, 3.94128015546439*^9, 3.9412803288171186`*^9, 
  3.941280598299614*^9, 3.9412807956239243`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"045b7b33-600e-43f6-8f1d-604b73d56b87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteCHOutput", "[", "LIDM", "]"}]], "Input",
 CellChangeTimes->{{3.624253852697819*^9, 3.624253855246005*^9}, {
  3.6242539619622*^9, 3.624253962288993*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"fe916665-0165-4a66-9508-07fa006f0647"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.9412807964917393`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"1f6cf36d-ed49-4277-906e-c13eb8d85073"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796492446*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"a528b09c-9a29-4dbf-8cb0-8bbd440f11dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.9412807964930973`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"e2029f98-7cad-46ab-9a1b-8c2bb6f7459b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/home/andreas/Dropbox/Work/PhysSoftware/feynrules-current/Models/InertDoublet/\
InertDoublet-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/home/andreas/Dropbox/Work/PhysSoftware/feynrules-current/Models/InertDoublet/\
InertDoublet-CH."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796494125*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"78524d6b-0c24-434f-b441-3a0b000c8ce5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796494586*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"fdf09bf9-1ba3-4bee-be1c-506d2aaeecc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.9412807965235662`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"6b67edbc-d9a3-458b-9f2a-4f5dffa1cf7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.9412807965242643`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"1171ff95-9d0b-4e54-919f-87c666281aa1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796524701*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"217535f4-e711-4eed-8f17-776826329cea"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796525077*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"8f53aa6e-aff9-4057-96ff-e52630231b1b"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796544098*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"6b92c2d3-99e6-4242-892b-0ecb243c61d3"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796544692*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"6eb1746a-cdf5-4778-a8e9-e2d895532210"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 14, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796545109*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"51844b47-344f-4558-a134-482cf45704df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "4", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280796582861*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"4ea1a569-684c-42c5-a795-3cacf222278b"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280797900197*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"106d5b81-6fde-4cfd-9df8-340c2bed3e86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "68", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  68, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 68, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280797916154*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"42dff352-915a-42aa-8b95-3a7a6feda53e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"68", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[68, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280799098464*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"89b83261-6c31-4127-ae33-ce1e69113624"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "14", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "68"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 14, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 68],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280799417344*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"ba1d33df-b117-4b6a-8488-ab6952c2f951"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.9412808011272783`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"6144a009-d577-4346-91db-9e2f36613b01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280801911304*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"70c73e1a-f434-4e53-9208-3c86fd0f863d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.9412808019320307`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"9da914c2-673e-41fe-ad5a-8ae495acba7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.09min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.09min!"],
  Editable->False]], "Print",
 CellChangeTimes->{3.624253964674478*^9, 3.624686754561907*^9, 
  3.624686953939912*^9, 3.626641235035924*^9, 3.651384376624371*^9, 
  3.651384953887457*^9, 3.938071714677334*^9, 3.938071864081794*^9, 
  3.938072787623931*^9, 3.9412800963358994`*^9, 3.941280157269884*^9, 
  3.941280694602146*^9, 3.941280801933075*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"6329f981-83e0-440f-9435-77d16cf22c7e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", "LIDM", "]"}]], "Input",
 CellChangeTimes->{{3.515066451500599*^9, 3.51506645766863*^9}, {
  3.515066553825666*^9, 3.515066567557489*^9}, {3.517657052212844*^9, 
  3.5176570535784883`*^9}, {3.517657087674789*^9, 3.517657097516794*^9}, {
  3.517657162889937*^9, 3.517657189106102*^9}, {3.62036438703964*^9, 
  3.620364399043768*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"fa215c89-596b-497e-98fd-5292323c85b3"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280806302561*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"04f26b96-ea90-4bc9-be40-a2ba537adab8"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808065049047`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9847eaed-4da3-4949-81a8-58faad41d5eb"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280806506996*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3383a1e8-cd0e-4c65-be43-70bb7fcbdc44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 14, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808065075274`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2759225f-659a-408b-bfc7-ba22c1a54851"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280807863503*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2daa88f9-8367-4aa9-913f-8bf71af69c4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "69", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  69, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 69, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280807889085*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a15aafda-af10-42d4-a8fb-574f00686a12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"69", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[69, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808091940603`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c347ef6c-32b2-45b6-809a-3278ad24cdb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "14", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "69"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 14, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 69],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808095601587`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4234c6bf-04f5-4b06-b3ae-7fb6ce9ede6e"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280811014475*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"26465da9-00a2-4b42-9ce7-113632ce4724"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280811044767*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cf5211d8-a972-4f42-8002-cbdcc25425d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "58"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 58],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280811075294*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b046a86e-8594-48d4-8e8d-edf27fe9f749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.362878`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 1.362878, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808141110277`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e288877d-c149-481d-9833-a17641843b09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "76"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 76],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808141115522`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7c5a557c-2e66-4605-9802-980e539ed9b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.333146`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.333146, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280814553487*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6e6f3594-94fd-4e2a-a9cc-f1567ff772f5"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808145540648`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c3c20398-36b8-4b5a-9195-b5b453fcfb92"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280814603834*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3e1406fa-90d4-472f-9edd-91f56072a48f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "13", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 13, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.9412808146357183`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5fcf60a9-43e8-4ceb-9ee0-526eab6caed1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{21.5859375, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 113, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280815517964*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8bc313a0-4408-4eca-9a88-8f091ca49437"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280815562488*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c626ae8a-8077-4287-8ee3-5b0bf0b5023c"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.620364401915524*^9, 3.620387566772805*^9, 
  3.623481715791233*^9, 3.623481762111964*^9, 3.623482134602141*^9, 
  3.62348285490364*^9, 3.651384400242784*^9, 3.651384961807186*^9, 
  3.9380717392788477`*^9, 3.938071871996988*^9, 3.938072842119125*^9, 
  3.941280103359878*^9, 3.9412807086917353`*^9, 3.941280815655876*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"05c616dc-088a-44ce-a69b-dea086e67cc3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"LIDM", ",", " ", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.515066600238826*^9, 3.515066609565148*^9}, {
  3.5176566474542437`*^9, 3.51765665024625*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"0fb55708-7e23-4296-8ad0-75c288afc6b5"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to FeynArts - - -\"\>"], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280817338997*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"0bf06adf-0f7f-4a55-ab1a-fa4cd4bb39d9"],

Cell[BoxData["\<\"      C. Degrande C. Duhr, 2013\"\>"], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280817339631*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d2b929b2-4236-4fec-86fa-1ddd7d312947"],

Cell[BoxData["\<\"      Counterterms: B. Fuks, 2012\"\>"], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.94128081734022*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f631865f-bae1-48c4-bf9f-3ff1a9403de5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.94128081734066*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"63d504ac-e4a5-4a32-8999-d1cdd1a55132"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280817370229*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7dd7a08b-28b9-4226-9048-c3d0e7f991f3"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280817370858*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"6335ba0f-bf48-416b-ba79-b8ca52d66ac2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 14, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280817371335*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d5438dca-49e4-418e-81ff-b24fd6570ad0"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280818763912*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"ebac772a-f905-44f6-a23e-6345d77c33b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "69", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14.390625, {0.140625, 7.8046875}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  69, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 69, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280818780322*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"543ca262-ccdf-4d53-b74f-eb58f1ade7f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"69", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[69, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.94128082011362*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"42e73c1b-ce65-40c0-8dbe-76925416aa44"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 1, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820631014*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"d5198df8-39c8-4783-8288-aa6c6ebc2fab"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 2, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820667948*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"be012d30-aa2b-41a7-8e39-8303425fb0c6"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 3, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808206828547`*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"dd0cd603-e6b1-4445-b517-9d210c4ce0a0"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 4, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808206943502`*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"6b5ea106-e982-4b76-a41e-eadaaa20a10d"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 5, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820707821*^9},
 CellLabel->
  "(kernel 9)",ExpressionUUID->"20efa7ad-5f2e-4d70-8df8-c1443b86939b"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 6, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820720338*^9},
 CellLabel->
  "(kernel 10)",ExpressionUUID->"1d7d8f1f-1ba3-4685-8bd2-3f9a4fbb7553"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 7, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808207444897`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"e6583179-409b-4a00-96af-f782fe42c24d"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 8, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820757915*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"5bc18ee1-d1e4-4107-9d65-bd6b20b41d55"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 9, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808207706537`*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"21536a33-5e1b-4fe6-8c9e-cb793e20df35"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 10, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820782936*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"d1b72e39-39ef-4929-bcd8-5cdc93d57365"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 11, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820797584*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"c0d79055-1d71-4739-ad1a-7ac088a6eb56"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 12, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820812736*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"17ec40fd-a79c-491d-ae1f-03d0150f077c"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 13, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820825707*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"9f024898-4aee-46fc-9a10-7273f89968b0"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 14, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820839335*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"f6d3b039-c8bb-4f30-9e1d-fa7932f6a42f"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 15, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820855076*^9},
 CellLabel->
  "(kernel 9)",ExpressionUUID->"15081868-2331-4fcd-967c-e1725019f624"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 16, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820882436*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"a94fd8d8-358d-4391-a136-2ccaa9b39179"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 17, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820896131*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"5fb46701-5a9d-4c30-8cd8-342376f5b7cb"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Simplify\\\", \
\\\"::\\\", \\\"time\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"", None, 8, 18, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820921206*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"22338915-94a3-4715-9537-f698d935047c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Simplify\\\", \
\\\"::\\\", \\\"time\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"", None, 8, 19, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.94128082093474*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"74a02ca7-dd3d-484e-8eba-dc823cf8a2ee"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 20, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.941280820983451*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"d0067a3c-f499-442b-ade5-8f609c78af0f"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 21, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808209940577`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"30a40616-04af-4b5a-b0d3-e36a2c16dfa0"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 22, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808210051622`*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"c87929ac-3ba7-4762-8442-f2af10801131"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"0.01`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of the TimeConstraint option may improve the \
result of simplification.\"", None, 8, 23, 18524569925182972174, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9412808210160437`*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"5294c86c-dd47-41bf-95c4-53e436ce64eb"],

Cell[CellGroupData[{

Cell[BoxData["\<\"mytimecheck,after LGC\"\>"], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280821047139*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7579a131-f4d5-4a8c-a995-4a6e10ebd5f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
   "\[InvisibleSpace]", "\<\"InertDoublet_FA\"\>"}],
  SequenceForm[
  "Writing FeynArts model file into directory ", "InertDoublet_FA"],
  Editable->False]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.941280821099708*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"a718bf67-d190-409b-a242-bb20097c7e96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts generic file on \"\>", 
   "\[InvisibleSpace]", "\<\"InertDoublet_FA.gen\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Writing FeynArts generic file on ", "InertDoublet_FA.gen", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.651385015853396*^9, 3.938071752880859*^9, 
  3.938071883615692*^9, 3.9380728558741503`*^9, 3.9412807240618963`*^9, 
  3.94128082114473*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"1cdd12db-0fa0-4b95-a7b5-b687b6cad6b8"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1915.5, 1055.25},
WindowMargins->{{-2.25, Automatic}, {Automatic, -22.5}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"14.0 for Linux x86 (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8db4ac43-a367-4318-a6aa-6c755a7199c3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1048, 22, 70, "Input",ExpressionUUID->"7cece50c-3e56-48c2-b3ec-e877905a436e"],
Cell[CellGroupData[{
Cell[1640, 48, 855, 14, 23, "Print",ExpressionUUID->"02b2b7fd-8234-4362-8500-9703188f34e7"],
Cell[2498, 64, 1140, 21, 23, "Print",ExpressionUUID->"be224aaa-f41b-4e64-89b6-b13155c651f3"],
Cell[3641, 87, 907, 15, 23, "Print",ExpressionUUID->"be22be99-d2a3-466b-aa99-ad6f42bc3b33"],
Cell[4551, 104, 843, 14, 23, "Print",ExpressionUUID->"dac6a5c8-0bf2-4692-b65a-7b79bedc7ab5"],
Cell[5397, 120, 852, 14, 23, "Print",ExpressionUUID->"ee54660e-f0a4-4016-a1e6-619389999876"],
Cell[6252, 136, 903, 15, 23, "Print",ExpressionUUID->"54eb55ac-56d5-4ec6-bab5-d12dc2d31d66"],
Cell[7158, 153, 903, 15, 23, "Print",ExpressionUUID->"a00cec9f-86f6-430e-b129-c027f50db049"],
Cell[8064, 170, 841, 14, 23, "Print",ExpressionUUID->"71666727-f414-434f-bdf5-519edde395eb"],
Cell[8908, 186, 871, 14, 23, "Print",ExpressionUUID->"e051a46a-5355-45f7-8a97-57d23f4c2e37"],
Cell[9782, 202, 843, 14, 23, "Print",ExpressionUUID->"d110fe37-8224-4d5b-a42b-292a72e63945"],
Cell[10628, 218, 908, 15, 23, "Print",ExpressionUUID->"6046bfac-fc5b-4b1c-b40b-f236fbc79668"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11585, 239, 183, 4, 50, "Input",ExpressionUUID->"81623886-7667-49d4-ac9e-9a9179337cac"],
Cell[CellGroupData[{
Cell[11793, 247, 860, 14, 23, "Print",ExpressionUUID->"275e5ebd-ab9a-4476-a515-b7daa49d178a"],
Cell[12656, 263, 864, 14, 23, "Print",ExpressionUUID->"24e079a8-e988-4ea9-a6fd-b17720bfd6b5"],
Cell[13523, 279, 966, 18, 23, "Print",ExpressionUUID->"cb65b54c-dd57-48cc-a51b-6a1e3dd41cbf"],
Cell[14492, 299, 868, 15, 23, "Print",ExpressionUUID->"7bd9cf07-1d9f-4fb5-9c25-3f95f28db283"],
Cell[15363, 316, 820, 14, 23, "Print",ExpressionUUID->"6c0f63de-32b1-450c-9cfe-b51250b6bd17"],
Cell[16186, 332, 850, 14, 23, "Print",ExpressionUUID->"96afdaee-2b38-402c-a6e7-1d7362e7e485"],
Cell[17039, 348, 853, 14, 23, "Print",ExpressionUUID->"c8652dda-ba88-41b3-a10b-63591cf53499"],
Cell[17895, 364, 853, 14, 23, "Print",ExpressionUUID->"f75a9fe0-ae4c-4b27-b19d-53dd9126378e"],
Cell[18751, 380, 1028, 19, 42, "Print",ExpressionUUID->"238930e4-eacc-4aea-abe2-5bf5234efeeb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19828, 405, 408, 6, 29, "Input",ExpressionUUID->"7858ff5e-6dad-4cc1-9baa-c42459da9a3c"],
Cell[CellGroupData[{
Cell[20261, 415, 810, 13, 23, "Print",ExpressionUUID->"202a6330-d2b4-4a0a-8fe4-53b856c26b01"],
Cell[21074, 430, 806, 13, 23, "Print",ExpressionUUID->"b0134443-071b-4545-9b94-86a5cc510872"],
Cell[21883, 445, 1001, 20, 23, "Print",ExpressionUUID->"c06b9e86-338a-4fe9-b3d4-3033ce4f3f6f"],
Cell[22887, 467, 756, 12, 23, "Print",ExpressionUUID->"8d318233-eed8-42d4-839a-d8bdc4e87b20"],
Cell[23646, 481, 789, 13, 23, "Print",ExpressionUUID->"07bf669c-a6dd-408f-8821-62a5c127b2b2"],
Cell[24438, 496, 747, 12, 23, "Print",ExpressionUUID->"673c3119-61ed-4e3f-9eea-c12601cf2bb4"],
Cell[25188, 510, 871, 16, 23, "Print",ExpressionUUID->"d6cba5d2-87b7-4141-859f-fdce580b5369"],
Cell[26062, 528, 756, 12, 23, "Print",ExpressionUUID->"2f10a7a9-7b56-4796-9bf0-946ff6874e42"]
}, Open  ]],
Cell[26833, 543, 718, 11, 33, "Output",ExpressionUUID->"045b7b33-600e-43f6-8f1d-604b73d56b87"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27588, 559, 260, 4, 29, "Input",ExpressionUUID->"fe916665-0165-4a66-9508-07fa006f0647"],
Cell[CellGroupData[{
Cell[27873, 567, 505, 8, 23, "Print",ExpressionUUID->"1f6cf36d-ed49-4277-906e-c13eb8d85073"],
Cell[28381, 577, 944, 22, 23, "Print",ExpressionUUID->"a528b09c-9a29-4dbf-8cb0-8bbd440f11dd"],
Cell[29328, 601, 938, 22, 23, "Print",ExpressionUUID->"e2029f98-7cad-46ab-9a1b-8c2bb6f7459b"],
Cell[30269, 625, 1068, 27, 42, "Print",ExpressionUUID->"78524d6b-0c24-434f-b441-3a0b000c8ce5"],
Cell[31340, 654, 908, 22, 42, "Print",ExpressionUUID->"fdf09bf9-1ba3-4bee-be1c-506d2aaeecc7"],
Cell[32251, 678, 924, 22, 42, "Print",ExpressionUUID->"6b67edbc-d9a3-458b-9f2a-4f5dffa1cf7d"],
Cell[33178, 702, 924, 22, 42, "Print",ExpressionUUID->"1171ff95-9d0b-4e54-919f-87c666281aa1"],
Cell[34105, 726, 922, 22, 42, "Print",ExpressionUUID->"217535f4-e711-4eed-8f17-776826329cea"],
Cell[35030, 750, 458, 8, 23, "Print",ExpressionUUID->"8f53aa6e-aff9-4057-96ff-e52630231b1b"],
Cell[35491, 760, 730, 16, 23, "Print",ExpressionUUID->"6b92c2d3-99e6-4242-892b-0ecb243c61d3"],
Cell[36224, 778, 485, 8, 23, "Print",ExpressionUUID->"6eb1746a-cdf5-4778-a8e9-e2d895532210"],
Cell[36712, 788, 669, 13, 23, "Print",ExpressionUUID->"51844b47-344f-4558-a134-482cf45704df"],
Cell[37384, 803, 709, 14, 23, "Print",ExpressionUUID->"4ea1a569-684c-42c5-a795-3cacf222278b"],
Cell[38096, 819, 518, 9, 23, "Print",ExpressionUUID->"106d5b81-6fde-4cfd-9df8-340c2bed3e86"],
Cell[38617, 830, 1022, 21, 23, "Print",ExpressionUUID->"42dff352-915a-42aa-8b95-3a7a6feda53e"],
Cell[39642, 853, 600, 12, 23, "Print",ExpressionUUID->"89b83261-6c31-4127-ae33-ce1e69113624"],
Cell[40245, 867, 975, 19, 23, "Print",ExpressionUUID->"ba1d33df-b117-4b6a-8488-ab6952c2f951"],
Cell[41223, 888, 1117, 26, 61, "Print",ExpressionUUID->"6144a009-d577-4346-91db-9e2f36613b01"],
Cell[42343, 916, 908, 22, 42, "Print",ExpressionUUID->"70c73e1a-f434-4e53-9208-3c86fd0f863d"],
Cell[43254, 940, 923, 22, 23, "Print",ExpressionUUID->"9da914c2-673e-41fe-ad5a-8ae495acba7a"],
Cell[44180, 964, 866, 22, 42, "Print",ExpressionUUID->"6329f981-83e0-440f-9435-77d16cf22c7e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45095, 992, 450, 7, 29, "Input",ExpressionUUID->"fa215c89-596b-497e-98fd-5292323c85b3"],
Cell[CellGroupData[{
Cell[45570, 1003, 530, 9, 23, "Print",ExpressionUUID->"04f26b96-ea90-4bc9-be40-a2ba537adab8"],
Cell[46103, 1014, 755, 16, 23, "Print",ExpressionUUID->"9847eaed-4da3-4949-81a8-58faad41d5eb"],
Cell[46861, 1032, 508, 8, 23, "Print",ExpressionUUID->"3383a1e8-cd0e-4c65-be43-70bb7fcbdc44"],
Cell[47372, 1042, 694, 13, 23, "Print",ExpressionUUID->"2759225f-659a-408b-bfc7-ba22c1a54851"],
Cell[48069, 1057, 541, 9, 23, "Print",ExpressionUUID->"2daa88f9-8367-4aa9-913f-8bf71af69c4b"],
Cell[48613, 1068, 1045, 21, 23, "Print",ExpressionUUID->"a15aafda-af10-42d4-a8fb-574f00686a12"],
Cell[49661, 1091, 625, 12, 23, "Print",ExpressionUUID->"c347ef6c-32b2-45b6-809a-3278ad24cdb0"],
Cell[50289, 1105, 1000, 19, 23, "Print",ExpressionUUID->"4234c6bf-04f5-4b06-b3ae-7fb6ce9ede6e"],
Cell[51292, 1126, 522, 8, 23, "Print",ExpressionUUID->"26465da9-00a2-4b42-9ce7-113632ce4724"],
Cell[51817, 1136, 789, 17, 23, "Print",ExpressionUUID->"cf5211d8-a972-4f42-8002-cbdcc25425d5"],
Cell[52609, 1155, 762, 16, 23, "Print",ExpressionUUID->"b046a86e-8594-48d4-8e8d-edf27fe9f749"],
Cell[53374, 1173, 723, 13, 23, "Print",ExpressionUUID->"e288877d-c149-481d-9833-a17641843b09"],
Cell[54100, 1188, 764, 16, 23, "Print",ExpressionUUID->"7c5a557c-2e66-4605-9802-980e539ed9b0"],
Cell[54867, 1206, 707, 13, 23, "Print",ExpressionUUID->"6e6f3594-94fd-4e2a-a9cc-f1567ff772f5"],
Cell[55577, 1221, 507, 8, 23, "Print",ExpressionUUID->"c3c20398-36b8-4b5a-9195-b5b453fcfb92"],
Cell[56087, 1231, 529, 9, 23, "Print",ExpressionUUID->"3e1406fa-90d4-472f-9edd-91f56072a48f"],
Cell[56619, 1242, 724, 13, 23, "Print",ExpressionUUID->"5fcf60a9-43e8-4ceb-9ee0-526eab6caed1"],
Cell[57346, 1257, 903, 17, 23, "Print",ExpressionUUID->"8bc313a0-4408-4eca-9a88-8f091ca49437"],
Cell[58252, 1276, 501, 8, 23, "Print",ExpressionUUID->"c626ae8a-8077-4287-8ee3-5b0bf0b5023c"],
Cell[58756, 1286, 486, 8, 23, "Print",ExpressionUUID->"05c616dc-088a-44ce-a69b-dea086e67cc3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59291, 1300, 341, 6, 31, "Input",ExpressionUUID->"0fb55708-7e23-4296-8ad0-75c288afc6b5"],
Cell[CellGroupData[{
Cell[59657, 1310, 344, 6, 23, "Print",ExpressionUUID->"0bf06adf-0f7f-4a55-ab1a-fa4cd4bb39d9"],
Cell[60004, 1318, 331, 6, 23, "Print",ExpressionUUID->"d2b929b2-4236-4fec-86fa-1ddd7d312947"],
Cell[60338, 1326, 332, 6, 23, "Print",ExpressionUUID->"f631865f-bae1-48c4-bf9f-3ff1a9403de5"],
Cell[60673, 1334, 477, 11, 23, "Print",ExpressionUUID->"63d504ac-e4a5-4a32-8999-d1cdd1a55132"],
Cell[61153, 1347, 580, 14, 23, "Print",ExpressionUUID->"7dd7a08b-28b9-4226-9048-c3d0e7f991f3"],
Cell[61736, 1363, 327, 6, 23, "Print",ExpressionUUID->"6335ba0f-bf48-416b-ba79-b8ca52d66ac2"],
Cell[62066, 1371, 511, 11, 23, "Print",ExpressionUUID->"d5438dca-49e4-418e-81ff-b24fd6570ad0"],
Cell[62580, 1384, 360, 7, 23, "Print",ExpressionUUID->"ebac772a-f905-44f6-a23e-6345d77c33b5"],
Cell[62943, 1393, 864, 19, 23, "Print",ExpressionUUID->"543ca262-ccdf-4d53-b74f-eb58f1ade7f1"],
Cell[63810, 1414, 441, 10, 23, "Print",ExpressionUUID->"42e73c1b-ce65-40c0-8dbe-76925416aa44"]
}, Open  ]],
Cell[64266, 1427, 513, 11, 21, "Message",ExpressionUUID->"d5198df8-39c8-4783-8288-aa6c6ebc2fab"],
Cell[64782, 1440, 513, 11, 21, "Message",ExpressionUUID->"be012d30-aa2b-41a7-8e39-8303425fb0c6"],
Cell[65298, 1453, 515, 11, 21, "Message",ExpressionUUID->"dd0cd603-e6b1-4445-b517-9d210c4ce0a0"],
Cell[65816, 1466, 515, 11, 21, "Message",ExpressionUUID->"6b5ea106-e982-4b76-a41e-eadaaa20a10d"],
Cell[66334, 1479, 513, 11, 21, "Message",ExpressionUUID->"20efa7ad-5f2e-4d70-8df8-c1443b86939b"],
Cell[66850, 1492, 514, 11, 34, "Message",ExpressionUUID->"1d7d8f1f-1ba3-4685-8bd2-3f9a4fbb7553"],
Cell[67367, 1505, 515, 11, 21, "Message",ExpressionUUID->"e6583179-409b-4a00-96af-f782fe42c24d"],
Cell[67885, 1518, 513, 11, 21, "Message",ExpressionUUID->"5bc18ee1-d1e4-4107-9d65-bd6b20b41d55"],
Cell[68401, 1531, 515, 11, 21, "Message",ExpressionUUID->"21536a33-5e1b-4fe6-8c9e-cb793e20df35"],
Cell[68919, 1544, 514, 11, 21, "Message",ExpressionUUID->"d1b72e39-39ef-4929-bcd8-5cdc93d57365"],
Cell[69436, 1557, 514, 11, 21, "Message",ExpressionUUID->"c0d79055-1d71-4739-ad1a-7ac088a6eb56"],
Cell[69953, 1570, 514, 11, 21, "Message",ExpressionUUID->"17ec40fd-a79c-491d-ae1f-03d0150f077c"],
Cell[70470, 1583, 514, 11, 21, "Message",ExpressionUUID->"9f024898-4aee-46fc-9a10-7273f89968b0"],
Cell[70987, 1596, 514, 11, 21, "Message",ExpressionUUID->"f6d3b039-c8bb-4f30-9e1d-fa7932f6a42f"],
Cell[71504, 1609, 514, 11, 21, "Message",ExpressionUUID->"15081868-2331-4fcd-967c-e1725019f624"],
Cell[72021, 1622, 514, 11, 21, "Message",ExpressionUUID->"a94fd8d8-358d-4391-a136-2ccaa9b39179"],
Cell[72538, 1635, 514, 11, 21, "Message",ExpressionUUID->"5fb46701-5a9d-4c30-8cd8-342376f5b7cb"],
Cell[73055, 1648, 456, 10, 21, "Message",ExpressionUUID->"22338915-94a3-4715-9537-f698d935047c"],
Cell[73514, 1660, 455, 10, 21, "Message",ExpressionUUID->"74a02ca7-dd3d-484e-8eba-dc823cf8a2ee"],
Cell[73972, 1672, 514, 11, 21, "Message",ExpressionUUID->"d0067a3c-f499-442b-ade5-8f609c78af0f"],
Cell[74489, 1685, 516, 11, 21, "Message",ExpressionUUID->"30a40616-04af-4b5a-b0d3-e36a2c16dfa0"],
Cell[75008, 1698, 516, 11, 21, "Message",ExpressionUUID->"c87929ac-3ba7-4762-8442-f2af10801131"],
Cell[75527, 1711, 516, 11, 21, "Message",ExpressionUUID->"5294c86c-dd47-41bf-95c4-53e436ce64eb"],
Cell[CellGroupData[{
Cell[76068, 1726, 321, 6, 23, "Print",ExpressionUUID->"7579a131-f4d5-4a8c-a995-4a6e10ebd5f9"],
Cell[76392, 1734, 533, 12, 23, "Print",ExpressionUUID->"a718bf67-d190-409b-a242-bb20097c7e96"],
Cell[76928, 1748, 563, 13, 23, "Print",ExpressionUUID->"1cdd12db-0fa0-4b95-a7b5-b687b6cad6b8"]
}, Open  ]]
}, Open  ]]
}
]
*)

