                                           
                                                                                       


(**************** This is the FeynRules model-file for the Hill model **************)

M$ModelName = "HillModel";

M$Information = {Authors -> {"P. Aquino", "C. Duhr"},
                 Institutions -> {"Universite catholique de Louvain (CP3)"},
                 Emails -> {priscila@fma.if.usp.br, claude.duhr@uclouvain.be},
                 Date -> "14. 06. 2009",
                 Version  -> "1.0",
                 References -> "\"The minimal non-minimal Standard Model\", J.J. van der Bij, Phys.Lett.B636:56-59,2006, hep-ph/0603082",
                 URLs   ->   "http://feynrules.phys.ucl.ac.be/view/Main/Hillmodel"};


FeynmanGauge=False;

(******* Index definitions ********)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]

IndexRange[ Index[SU2W] ] = Range[3]


IndexStyle[Colour, i]

IndexStyle[Generation, f]

IndexStyle[Gluon ,a]


(****************  Parameters *************)

M$Parameters = {

  (* External parameters *)

  \[Alpha]EW == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Value -> 1/132.50698,
        Description -> "Electroweak coupling constant"},
  
  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        InteractionOrder -> {QED, 2},
        Value -> 1.16639 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.118,
        Description -> "Strong coupling constant"},

  ZM == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        Value -> 91.188,
        Description -> "Z mass"},

  ymc == {
        ParameterType -> External,
        BlockName -> MGYUKAWA,
        Value -> 1.42,
        OrderBlock -> {4},
        Description -> "Charm Yukawa mass"},

 ymb == {
        ParameterType -> External,
        BlockName -> MGYUKAWA,
        Value -> 4.7,
        OrderBlock -> {5},
        Description -> "Bottom Yukawa mass"},

  ymt == {
        ParameterType -> External,
        BlockName -> MGYUKAWA,
        Value -> 174.3,
        OrderBlock -> {6},
        Description -> "Top Yukawa mass"},

  ymtau == {
        ParameterType -> External,
        BlockName -> MGYUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau Yukawa mass"},

  ymm == {
        Value -> 0.105},

   (* Internal Parameters *)

  WM == {
        ParameterType -> Internal,
        Value -> Sqrt[ZM^2/2+Sqrt[ZM^4/4-Pi/Sqrt[2]*\[Alpha]EW/Gf*ZM^2]],
        Description -> "W mass"},

  sw2 == {
        ParameterType -> Internal,
        Value -> 1-(WM/ZM)^2,
        Description -> "Squared Sin of the Weinberg angle"},
  
   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},
      
   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - sw2],
        Description -> "Cos of the Weinberg angle"},  

   sw == {
        TeX -> Subscript[s, w],
        ParameterType -> Internal,
        Value -> Sqrt[sw2],
        Description -> "Sin of the Weinberg angle"},  

   gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Value -> ee / sw,
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Value -> ee / cw,
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},

   v == {
        ParameterType -> Internal,
        Value -> 2*MW*sw/ee,
        InteractionOrder -> {QED, -1}},

   \[Lambda]0 == {
        TeX -> Subscript[\[Lambda], 0],
        Value -> 0.2,
        InteractionOrder -> {QED, 2},
        ParameterName -> l0},


   yl == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> {yl[1] -> 0, yl[2] -> 0, yl[3] -> -ymtau / v},
        ParameterName -> {yl[1] -> ye, yl[2] -> ym, yl[3] -> ytau},
        InteractionOrder -> {QED, 1},
        Definitions -> {yl[1] -> 0, yl[2] ->0},
        Description -> "Lepton Yukawa coupling"},

   yu == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> {yu[1] -> 0, yu[2] -> - ymc / v, yu[3] -> -ymt / v},
        ParameterName -> {yu[1] -> yu, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yu[1] -> 0},
        Description -> "U-quark Yukawa coupling"},

   yd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> {yd[1] -> 0, yd[2] -> 0, yd[3] -> -ymb / v},
        ParameterName -> {yd[1] -> yd, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        Definitions -> {yd[1] -> 0, yd[2] -> 0},
        Description -> "D-quark Yukawa coupling"},

   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        OrderBlock -> {1},
        Value -> 0.488,
        Description -> "Cabibbo angle"},
                   
  CKM == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Definitions -> {CKM[3, 3] -> 1,
                       CKM[i_, 3] :> 0 /; i != 3,
                       CKM[3, i_] :> 0 /; i != 3},
       Value -> {CKM[1,2] -> Sin[cabi],
                   CKM[1,1] -> Cos[cabi],
                   CKM[2,1] -> -Sin[cabi],
                   CKM[2,2] -> Cos[cabi]},
       Description -> "CKM-Matrix"},

   f1 == {Value -> 500,
         TeX -> Subscript[f, 1],
         InteractionOrder -> {QED, -1}},

   \[Lambda]1 == {Value -> 0.2,
          TeX -> Subscript[\[Lambda], 1],
          InteractionOrder -> {QED, 2},
          ParameterName -> l1},

   tha == {Value -> 2.88,
          TeX -> Subscript[\[Theta], a],
          Description -> "Scalar mixing angle"},
  
   ca == {ParameterType -> Internal,
          Value -> Cos[tha],
          TeX -> Subscript[c,a],
          Description -> "Cos of the scalar mixing angle"},

   sa == {ParameterType -> Internal,
          Value -> Sin[tha],
          TeX -> Subscript[s,a],
          Description -> "Sin of the scalar mixing angle"}
}


(************** Gauge Groups ******************)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> ee},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> ep,
        CouplingConstant -> gw,
        Definitions -> {ep -> Eps}},
  
  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        DTerm -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}
}

(********* Particle Classes **********)

M$ClassesDescription = {

(*** Fermions ***)

	(* Leptons (neutrino): I_3 = +1/2, Q = 0 *)
  F[1] == {
        ClassName -> vl,
        ClassMembers -> {ve,vm,vt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
	PropagatorLabel -> {"v", "ve", "vm", "vt"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
  F[2] == {
        ClassName -> l,
        ClassMembers -> {e, m, tt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
	Mass -> {Ml, {ME, 0}, {MM, 0}, {MTA, 1.777}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
	PropagatorLabel -> {"l", "e", "m", "tt"},
	PropagatorType -> Straight,
        ParticleName -> {"e-", "m-", "tt-"},
        AntiParticleName -> {"e+", "m+", "tt+"},
	PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
  F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Mu, {MU, 0}, {MC, 0}, {MT, 174.3}},
        Width -> {0, 0, {WT, 1.50833649}},
	QuantumNumbers -> {Q -> 2/3},
	PropagatorLabel -> {"uq", "u", "c", "t"},
	PropagatorType -> Straight,
	PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
  F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Md, {MD, 0}, {MS, 0}, {MB, 4.7}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1/3},
	PropagatorLabel -> {"dq", "d", "s", "b"},
	PropagatorType -> Straight, 
	PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },

(*** Gauge bosons ***)

	(* Gauge bosons: Q = 0 *)
  V[1] == {
        ClassName -> A,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
	PropagatorLabel -> "a",
	PropagatorType -> W,
	PropagatorArrow -> None,
        PDG -> 22,
        FullName -> "Photon" },

  V[2] == {
        ClassName -> Z,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZ, 91.188},
        Width -> {WZ, 2.44140351},
	PropagatorLabel -> "Z",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 23,
        FullName -> "Z" },

	(* Gauge bosons: Q = -1 *)
  V[3] == {
        ClassName -> W,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, 80.419},
        Width -> {WW, 2.04759951},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "W",
	PropagatorType -> Sine,
	PropagatorArrow -> Forward,
	ParticleName ->"W+",
	AntiParticleName ->"W-",
        PDG -> 24,
        FullName -> "W" },

V[4] == {
        ClassName -> G,
	SelfConjugate -> True,
	Indices -> {Index[Gluon]},
	Mass -> 0,
	PropagatorLabel -> {"G"},
	PropagatorType -> C,
	PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "G" },

V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> cw Z[mu] + sw A[mu]},
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0,
        PDG -> {1,2,3}},

V[6] == {
        ClassName -> B,
	SelfConjugate -> True,
        Definitions -> {B[mu_] -> -sw Z[mu] + cw A[mu]},
	Indices -> {},
	Mass -> 0,
        Unphysical -> True},

(*** Scalars ***)


	(* physical Higgs: Q = 0 *) 

  S[1] == {
    ClassName -> h1,
    SelfConjugate -> True,
    Mass -> {Mh1, 78.5},
    Width -> {Wh1, 0.005}},

S[2] == {
   ClassName -> h2,
   SelfConjugate -> True,
   Mass -> {Mh2, 326},
   Width -> {Wh2, 0.005}},

S[3] == {
   ClassName -> H,
   SelfConjugate -> True,
   Unphysical -> True,
   Definitions -> {H -> ca h1- sa h2}},

S[4] == {
   ClassName -> h,
   SelfConjugate -> True,
   Unphysical -> True,
   Definitions -> {h -> sa h1 +ca h2}};

S[5] == {
        ClassName -> phi,
	SelfConjugate -> True,
	Mass -> {Mphi, 120},
        Width -> Wphi,
	PropagatorLabel -> "Phi",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phi0",
        PDG -> 250,
        FullName -> "Phi",
        Goldstone -> Z },

S[6] == {
        ClassName -> phi2,
	SelfConjugate -> False,
	Mass -> {Mphi2, 120},
        Width -> Wphi2,
	PropagatorLabel -> "Phi2",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phi+",
	AntiParticleName ->"phi-",
        PDG -> 251,
        FullName -> "Phi2",
        Goldstone -> W,
   QuantumNumbers -> {Q -> 1}},


(*********  Ghost Fields  ****************)(********** Ghosts **********)
	U[1] == {
       ClassName -> ghA,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> A},

	U[2] == {
       ClassName -> ghZ,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> Z},

	U[31] == {
       ClassName -> ghWp,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> W,
	   QuantumNumbers -> {Q-> 1}},

   U[32] == {
       ClassName -> ghWm,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> Wbar,
	   QuantumNumbers -> {Q-> -1}},

 	U[4] == {
       ClassName -> ghG,
       SelfConjugate -> False,
       Indices -> {Index[Gluon]},
       Ghost -> G},

	U[5] == {
        ClassName -> ghWi,
        Unphysical -> True,
        Definitions -> {ghWi[1] -> (ghWp + ghWm)/Sqrt[2],
                        ghWi[2] -> (ghWm - ghWp)/Sqrt[2]/I,
                        ghWi[3] -> cw ghZ + sw ghA},
        SelfConjugate -> False,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W},

	U[6] == {
        ClassName -> ghB,
	SelfConjugate -> False,
        Definitions -> {ghB -> -sw ghZ + cw ghA},
	Indices -> {},
        Unphysical -> True}


}

(*****************************************************************************************)

(* SM Lagrangian *)

(******************** Gauge F^2 Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LGauge = -1/4 (del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw ep[i1, i2, i3] Wi[mu, i2] Wi[nu, i3])*
 					(del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw ep[i1, i4, i5] Wi[mu, i4] Wi[nu, i5]) -
	
	1/4 (del[B[nu], mu] - del[B[mu], nu])^2 -
	
	1/4 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3])*
 		 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a4, a5] G[mu, a4] G[nu, a5]);


(********************* Fermion Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

    Lkin = I uqbar.Ga[mu].del[uq, mu] + 
    	I dqbar.Ga[mu].del[dq, mu] + 
    	I lbar.Ga[mu].del[l, mu] + 
    	I vlbar.Ga[mu].del[vl, mu];

    LQCD = gs (uqbar.Ga[mu].T[a].uq + 
    	dqbar.Ga[mu].T[a].dq)G[mu, a];

    LBright = 
     -2ee/cw B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
    	4ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjP.uq -       (*Y_uR=4/3*)
    	2ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjP.dq;        (*Y_dR=-2/3*)

    LBleft = 
     -ee/cw B[mu]/2 vlbar.Ga[mu].ProjM.vl -          (*Y_LL=-1*)
    	ee/cw B[mu]/2 lbar.Ga[mu].ProjM.l  +           (*Y_LL=-1*)
    	ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjM.uq +        (*Y_QL=1/3*)
    	ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjM.dq ;        (*Y_QL=1/3*)
	
	LWleft = ee/sw/2(
	   vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
    	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
    	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+
    	
    	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
    	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
    	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
    	);

    Lkin + LQCD + LBright + LBleft + LWleft];

(******************** Higgs Lagrangian terms****************************)
 Phi := If[FeynmanGauge, {I phi2, (v + H - I phi)/Sqrt[2]}, {0, (v + H)/Sqrt[2]}];
 Phibar := If[FeynmanGauge, {-I phi2bar, (v + H + I phi)/Sqrt[2]} ,{0, (v + H)/Sqrt[2]}];
 

    
 LHiggs := Block[{PMVec, WVec, Dc, Dcbar, Vphi},
    
    PMVec = Table[PauliSigma[i], {i, 3}];   
    Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

	(*Y_phi=1*)
    Dc[f_, mu_] := I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 (Wvec[mu].PMVec).f;
    Dcbar[f_, mu_] := -I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 f.(Wvec[mu].PMVec);

    Vphi[Phi_, Phibar_] := muH^2 Phibar.Phi + \[Lambda]0 (Phibar.Phi)^2;

    (Dcbar[Phibar, mu]).Dc[Phi, mu] - Vphi[Phi, Phibar]];
    
    (*The covariant derivative in terms of physical states is:                        *)
    (*                    ( A + (cw^2-sw^2)/2cwsw Z              1/Sqrt[2]sw W+ )     *)
    (* D phi = id phi + e (                                                     ) phi *)
    (*                    ( 1/Sqrt[2]sw W-                       -1/2cwsw Z     )     *)
    
    (*From this we can determine the mixing term.                 *)
    (*                                                            *)
    (* L_mix = - MW ( W- dphi+ + W+ dphi- )  - MZ Z dphi0         *)
    (* This term must be cancelled in the gauge fixing Lagrangian.*)



(*************** Yukawa Lagrangian***********************)
LYuk := If[FeynmanGauge,
           Module[{s,r,n,m,i},                                                    -
	      yd[n] CKM[n,m]     uqbar[s,n,i].ProjP[s,r].dq[r,m,i] (-I phi2)              -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+H +I phi)/Sqrt[2]   -
	 
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+H -I phi)/Sqrt[2]   + (*This sign from eps matrix*)	
	      yu[n] HC[CKM[n,m]] dqbar[s,n,i].ProjP[s,r].uq[r,m,i] ( I phi2bar)           -
	
	      yl[n]              vlbar[s,n].ProjP[s,r].l[r,n]      (-I phi2)              -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+H +I phi)/Sqrt[2]
           ],
	   Module[{s,r,n,m,i},                                                    -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+H)/Sqrt[2]          -
	 
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+H)/Sqrt[2]          
                                                                                          -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+H)/Sqrt[2]
           ]
         ];

LYukawa := LYuk + HC[LYuk]/.HC[v]->v;


(************Gauge Fix terms*************************)
LGaugeFix := If[FeynmanGauge, 
		Block[{GFG,GFW,GFWbar,GFZ,GFA},
 	
 			GFG[a_]  := Module[{mu}, del[G[mu,a],mu]               ];
 			
 			GFW      := Module[{mu}, del[W[mu],mu]    + MW phi2    ];
 			GFWbar   := Module[{mu}, del[Wbar[mu],mu] + MW phi2bar ];

 			GFZ      := Module[{mu}, del[Z[mu],mu]    + MZ phi     ];
 			
 			GFA      := Module[{mu}, del[A[mu],mu]                 ];
 			 	
		
		- 1/2*GFG[a]GFG[a] - GFWbar*GFW - 1/2*GFZ^2 - 1/2*GFA^2   ]

, 0];

    (* We can determine the mixing term from this.                *)
    (*                                                            *)
    (* L_mix = MW ( phi+ dW- + phi- dW+ )  + MZ phi0 dZ           *)
    (* This exactly cancels the mixing term from LHiggs.          *)


 	
(**************Ghost terms**************************)
(* Now we need the ghost terms which are of the form:             *)
(* - g * antighost * d_BRST G                                     *)
(* where d_BRST G is BRST transform of the gauge fixing function. *)

LGhost := If[FeynmanGauge, 
		Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];
 	
	dBRSTWi[mu_,i_] := sw/ee Module[{i2, i3}, del[ghWi[i], mu] + ee/sw ep[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ee/sw ghWibar[a].del[dBRSTWi[mu,a],mu];	
 	
	dBRSTB[mu_] := cw/ee del[ghB, mu];
		LGhostB := - ee/cw ghBbar.del[dBRSTB[mu],mu];
	
	(***********Next the piece from the scalar field.************)
	LGhostphi := -   ee/(2*sw*cw) MW ( I phi2    ( (cw^2-sw^2)ghWpbar.ghZ + 2sw*cw ghWpbar.ghA )  -
												  I phi2bar ( (cw^2-sw^2)ghWmbar.ghZ + 2sw*cw ghWmbar.ghA )    ) -
					     ee/(2*sw) MW ( ( (v+H) - I phi) ghWpbar.ghWp +
					 						  ( (v+H) + I phi) ghWmbar.ghWm   ) -
						I ee/(2*sw) MZ ( phi2bar ghZbar.ghWp - phi2 ghZbar.ghWm ) -
						  ee/(2*sw*cw) MZ (v+H) ghZbar.ghZ ;
		 	
		 	
	(***********Now add the pieces together.********************)
	LGhostG + LGhostWi + LGhostB + LGhostphi]

, 0];
		

(*************** Hill Lagrangian***********************)

LHill := 1/2 del[h, mu]^2 - l1 (f1 (h + v^2/2/f1) - HC[Phi].Phi)^2;
		
(*********Total SM Lagrangian*******)	 	
Lag := LGauge + LHiggs + LFermions + LYukawa  +LGhost + LGaugeFix+ LHill;		
		
