(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8377,        262]
NotebookOptionsPosition[      6871,        206]
NotebookOutlinePosition[      7248,        223]
CellTagsIndexPosition[      7205,        220]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<< address of the package >\>\"", "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.4139893927211723`*^9, 3.41398940740919*^9}}],

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.413614854684285*^9, 3.413614886275807*^9}, {
  3.413641377342329*^9, 3.413641418329218*^9}, {3.4139893541115913`*^9, 
  3.413989390530416*^9}, {3.413990047868751*^9, 3.413990048379107*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\</Users/claudeduhr/Desktop/Models/HillModel\>\"", 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.413990052915724*^9, {3.413994785831689*^9, 3.413994795442175*^9}, {
   3.413997268899212*^9, 3.413997274522232*^9}, {3.413997379408894*^9, 
   3.413997388626389*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.402980281839891*^9, 3.402980292943016*^9}}],

Cell[CellGroupData[{

Cell["The Hill Model", "Title",
 CellChangeTimes->{{3.413991375190053*^9, 3.413991375744337*^9}}],

Cell["We load in the Hill model model-file", "Text",
 CellChangeTimes->{{3.413997145809513*^9, 3.4139971520329027`*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<HillModel.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.4082630239300327`*^9, 
   3.408263024838635*^9}, {3.41364142299107*^9, 3.413641423254826*^9}, {
   3.41399005701727*^9, 3.413990057433034*^9}}],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{
  3.404470070069872*^9, {3.4139900786509438`*^9, 3.4139900814877443`*^9}}],

Cell["\<\
The lagrangian of the SM (unitary gauge) without Hill field is called by\
\>", "Text",
 CellChangeTimes->{{3.413993638153576*^9, 3.413993664221603*^9}, {
  3.413993698136901*^9, 3.413993701952524*^9}}],

Cell[BoxData["LSM"], "Input",
 CellChangeTimes->{{3.413993679092657*^9, 3.413993682489049*^9}}],

Cell["The Hill sector is obtained from", "Text",
 CellChangeTimes->{{3.413993684430851*^9, 3.413993708665267*^9}}],

Cell[BoxData["LHill"], "Input",
 CellChangeTimes->{{3.4139937214530773`*^9, 3.413993722256974*^9}}],

Cell["The combined lagrangian (LSM + LHiggs) is given by", "Text",
 CellChangeTimes->{{3.4139900837425823`*^9, 3.413990083942293*^9}, {
  3.413993824872409*^9, 3.41399383885606*^9}}],

Cell[BoxData["LSMHill"], "Input",
 CellChangeTimes->{{3.413997259058875*^9, 3.4139972603618917`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The FeynmanRules", "Section",
 CellChangeTimes->{{3.408263447850895*^9, 3.40826345141604*^9}, {
   3.408263495700914*^9, 3.408263502991802*^9}, 3.408263603149146*^9, {
   3.4082637045166683`*^9, 3.408263782374763*^9}, {3.408343859998912*^9, 
   3.408343885453188*^9}, {3.408344111407064*^9, 3.408344118000225*^9}, {
   3.4083443778471518`*^9, 3.408344386014885*^9}, {3.4083444312388277`*^9, 
   3.408344457142848*^9}, {3.413540985728195*^9, 3.4135409885675087`*^9}, {
   3.413615333845126*^9, 3.4136153362213078`*^9}, {3.413993846469713*^9, 
   3.413993862193144*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LHill"}], ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"Name", "\[Rule]", "\"\<HillModel\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.41361493661029*^9, 3.413614940450158*^9}, {
  3.41399387213347*^9, 3.413993879241851*^9}, {3.413997695796707*^9, 
  3.413997710586526*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output", "Section"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}],
    SingleLetterItalics->False], TraditionalForm]]],
 " Output"
}], "Subsection",
 CellChangeTimes->{{3.4139969586379232`*^9, 3.413996960660123*^9}, 
   3.41399719564473*^9}],

Cell[BoxData[
 RowBox[{"WriteTeXOutput", "[", 
  RowBox[{"\"\<HillModel.tex\>\"", ",", 
   RowBox[{"{", "\"\<HillModel\>\"", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.413996971354395*^9, 3.413996989150453*^9}, {
  3.413997166607196*^9, 3.413997180386189*^9}, {3.413997747701517*^9, 
  3.413997750802349*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox["Feynarts",
    SingleLetterItalics->False], TraditionalForm]]],
 " Output"
}], "Subsection",
 CellChangeTimes->{{3.4139969586379232`*^9, 3.413996960660123*^9}, {
  3.413997201905767*^9, 3.41399723651656*^9}}],

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"\"\<HillModel.mod\>\"", ",", 
   RowBox[{"{", "LSMHill", "}"}], ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.413993962504253*^9, 3.413993974554265*^9}, {
  3.4139971612624073`*^9, 3.413997162950646*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox["MadGraph",
    SingleLetterItalics->False], TraditionalForm]]],
 " Output"
}], "Subsection",
 CellChangeTimes->{{3.4139969586379232`*^9, 3.413996960660123*^9}, {
  3.4139972245304203`*^9, 3.41399724078806*^9}}],

Cell[BoxData[
 RowBox[{"WriteMGOutput", "[", "LSMHill", "]"}]], "Input",
 CellChangeTimes->{{3.403261173444701*^9, 3.4032612014289207`*^9}, 
   3.403262013545652*^9, {3.4032623810096273`*^9, 3.403262387913323*^9}, {
   3.413997172997859*^9, 3.413997173165966*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep Output", "Subsection",
 CellChangeTimes->{{3.4139969586379232`*^9, 3.413996960660123*^9}, {
  3.413997245826178*^9, 3.413997251440893*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"CH$MaxExpressionLength", "=", "100"}], ";"}]], "Input",
 CellChangeTimes->{{3.413997068148148*^9, 3.413997092118608*^9}}],

Cell[BoxData[
 RowBox[{"WriteCHOutput", "[", "LSMHill", "]"}]], "Input",
 CellChangeTimes->{{3.413997051866171*^9, 3.4139970673130302`*^9}, {
  3.4139971826857967`*^9, 3.413997182819931*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1264, 679},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 223, 5, 40, "Input"],
Cell[794, 28, 266, 4, 40, "Input"],
Cell[1063, 34, 330, 8, 40, "Input"],
Cell[1396, 44, 92, 1, 40, "Input"],
Cell[CellGroupData[{
Cell[1513, 49, 97, 1, 114, "Title"],
Cell[1613, 52, 120, 1, 39, "Text"],
Cell[1736, 55, 638, 9, 40, "Input"],
Cell[CellGroupData[{
Cell[2399, 68, 128, 2, 100, "Section"],
Cell[2530, 72, 211, 4, 39, "Text"],
Cell[2744, 78, 95, 1, 40, "Input"],
Cell[2842, 81, 114, 1, 39, "Text"],
Cell[2959, 84, 99, 1, 40, "Input"],
Cell[3061, 87, 182, 2, 39, "Text"],
Cell[3246, 91, 101, 1, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3384, 97, 574, 8, 100, "Section"],
Cell[3961, 107, 388, 8, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4386, 120, 25, 0, 100, "Section"],
Cell[CellGroupData[{
Cell[4436, 124, 347, 12, 53, "Subsection"],
Cell[4786, 138, 314, 6, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5137, 149, 263, 8, 51, "Subsection"],
Cell[5403, 159, 316, 6, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5756, 170, 265, 8, 51, "Subsection"],
Cell[6024, 180, 264, 4, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6325, 189, 153, 2, 51, "Subsection"],
Cell[6481, 193, 156, 3, 40, "Input"],
Cell[6640, 198, 191, 3, 40, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
