(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5049,        175]
NotebookOptionsPosition[      3878,        128]
NotebookOutlinePosition[      4257,        145]
CellTagsIndexPosition[      4214,        142]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<< address of the package >\>\"", "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.4137218511907463`*^9, 3.4137218698825417`*^9}}],

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.402749950375587*^9, 3.402749954107053*^9}, {
  3.4137218725793657`*^9, 3.413721877181633*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</../models/HEFT/\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4137218982042313`*^9, 3.413721899320479*^9}, {
  3.413726035758497*^9, 3.413726045113817*^9}, {3.508650264440695*^9, 
  3.508650280622868*^9}}],

Cell[CellGroupData[{

Cell["The Higgs effective couplings", "Title"],

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM.fr\>\"", ",", "\"\<HiggsEffective.fr\>\""}], "]"}]], "Input",\

 CellChangeTimes->{{3.402749970337049*^9, 3.4027499704999*^9}, {
  3.4137219286676292`*^9, 3.413721935528274*^9}, {3.508650257479691*^9, 
  3.508650258438835*^9}, {3.508650300289027*^9, 3.508650326919705*^9}, {
  3.5086503656743793`*^9, 3.5086503695428333`*^9}}],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.413722471253631*^9, 3.413722474454302*^9}}],

Cell[CellGroupData[{

Cell["Lagrangian for CP even couplings", "Subsection",
 CellChangeTimes->{{3.413722482270711*^9, 3.413722490511662*^9}}],

Cell[BoxData["LCPEven"], "Input",
 CellChangeTimes->{{3.41372235934731*^9, 3.4137223632988443`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagrangian for CP odd couplings", "Subsection",
 CellChangeTimes->{{3.413722482270711*^9, 3.4137225051268797`*^9}}],

Cell[BoxData["LCPOdd"], "Input",
 CellChangeTimes->{{3.4137223673255043`*^9, 3.413722368323818*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The FeynmanRules", "Section",
 CellChangeTimes->{{3.413722510122294*^9, 3.413722512045841*^9}}],

Cell[CellGroupData[{

Cell["CP even couplings", "Subsection",
 CellChangeTimes->{{3.4137225204324007`*^9, 3.413722523484172*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LCPEven", ",", 
   RowBox[{"Name", "\[Rule]", "\"\<CPEven\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.413722373429627*^9, 3.41372240397196*^9}, {
  3.413722528048708*^9, 3.413722537920603*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CP odd couplings", "Subsection",
 CellChangeTimes->{{3.4137225204324007`*^9, 3.413722523484172*^9}, {
  3.413722553817721*^9, 3.4137225541588573`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LCPOdd", ",", 
   RowBox[{"Name", "\[Rule]", "\"\<CPOdd\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.413722373429627*^9, 3.41372240397196*^9}, {
  3.413722528048708*^9, 3.413722560423957*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output", "Section",
 CellChangeTimes->{{3.404741379224226*^9, 3.404741384935503*^9}}],

Cell[BoxData[
 RowBox[{"WriteTeXOutput", "[", 
  RowBox[{"\"\<HiggsEffective.tex\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<CPEven\>\"", ",", " ", "\"\<CPOdd\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.402750662390603*^9, 3.402750662820114*^9}, {
  3.404741397562558*^9, 3.404741419547327*^9}, {3.4137225734450397`*^9, 
  3.4137225883603687`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1144, 677},
WindowMargins->{{28, Automatic}, {Automatic, 24}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 226, 5, 46, "Input"],
Cell[774, 27, 171, 3, 46, "Input"],
Cell[948, 32, 313, 7, 46, "Input"],
Cell[CellGroupData[{
Cell[1286, 43, 46, 0, 126, "Title"],
Cell[1335, 45, 386, 7, 46, "Input"],
Cell[CellGroupData[{
Cell[1746, 56, 99, 1, 108, "Section"],
Cell[CellGroupData[{
Cell[1870, 61, 120, 1, 56, "Subsection"],
Cell[1993, 64, 100, 1, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2130, 70, 121, 1, 56, "Subsection"],
Cell[2254, 73, 100, 1, 46, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2403, 80, 101, 1, 108, "Section"],
Cell[CellGroupData[{
Cell[2529, 85, 107, 1, 56, "Subsection"],
Cell[2639, 88, 254, 5, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2930, 98, 157, 2, 56, "Subsection"],
Cell[3090, 102, 252, 5, 46, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3391, 113, 91, 1, 108, "Section"],
Cell[3485, 116, 365, 8, 46, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
