# This file was automatically created by FeynRules $Revision: 535 $
# Mathematica version: 7.0 for Mac OS X x86 (64-bit) (November 11, 2008)
# Date: Fri 18 Mar 2011 18:40:51

# Modified by F. Demartin in order to include loop Higgs EFT
# Dec 2013


from object_library import all_lorentz, Lorentz

from function_library import complexconjugate, re, im, csc, sec, acsc, asec

###################################
# CounterTerms Lorentz structures #
###################################

R2_GG_1 = Lorentz(name = 'R2_GG_1',
               spins = [ 3, 3 ],
               structure = 'P(-1,1)*P(-1,1)*Metric(1,2)')

R2_GG_2 = Lorentz(name = 'R2_GG_2',
               spins = [ 3, 3 ],
               structure = 'P(1,1)*P(2,1)')

R2_GG_3 = Lorentz(name = 'R2_GG_3',
               spins = [ 3, 3 ],
               structure = 'Metric(1,2)')

R2_QQ_1 = Lorentz(name = 'R2_QQ_1',
               spins = [ 2, 2 ],
               structure = 'P(-1,1)*Gamma(-1,2,1)')

R2_QQ_2 = Lorentz(name = 'R2_QQ_2',
               spins = [ 2, 2 ],
               structure = 'Identity(1,2)')

GHGHG = Lorentz(name = 'GHGHG',
                 spins = [ 1, 1, 3 ],
                structure = 'P(3,2)')

#=============================================================================================
#  4-gluon R2 vertex
#=============================================================================================


R2_4G_1234 = Lorentz(name = 'R2_4G_1234',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,2)*Metric(3,4)')

R2_4G_1324 = Lorentz(name = 'R2_4G_1324',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,3)*Metric(2,4)')

R2_4G_1423 = Lorentz(name = 'R2_4G_1423',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3)')

R2RGA_VVVV10 = Lorentz(name = 'R2RGA_VVVV10',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) + Metric(1,2)*Metric(3,4)')

R2RGA_VVVV2 = Lorentz(name = 'R2RGA_VVVV2',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3)')

R2RGA_VVVV3 = Lorentz(name = 'R2RGA_VVVV3',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,3)*Metric(2,4)')

R2RGA_VVVV5 = Lorentz(name = 'R2RGA_VVVV5',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,2)*Metric(3,4)')

#=============================================================================================

R2_GGZ = Lorentz(name = 'R2_GGZ',
                 spins = [ 3, 3, 3 ],
                 structure = 'Epsilon(3,1,2,-1)*P(-1,2)-Epsilon(3,1,2,-1)*P(-1,1)') 

R2_GGVV = Lorentz(name = 'R2_GGVV',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,2)*Metric(3,4)+Metric(1,3)*Metric(2,4)+Metric(1,4)*Metric(2,3)')

R2_GGHH = Lorentz(name = 'R2_GGHH',
                 spins = [ 3, 3, 1, 1 ],
                 structure = 'Metric(1,2)')

R2_GGGVa = Lorentz(name = 'R2_GGGVa',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Epsilon(4,1,2,3)')

###################
# Base structures #
###################

UUV1 = Lorentz(name = 'UUV1',
               spins = [ -1, -1, 3 ],
               structure = 'P(3,2) + P(3,3)')

SSS1 = Lorentz(name = 'SSS1',
               spins = [ 1, 1, 1 ],
               structure = '1')

FFS1 = Lorentz(name = 'FFS1',
               spins = [ 2, 2, 1 ],
               structure = 'Identity(2,1)')

FFV1 = Lorentz(name = 'FFV1',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,1)')

FFV2 = Lorentz(name = 'FFV2',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1)')

FFV3 = Lorentz(name = 'FFV3',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) - 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV4 = Lorentz(name = 'FFV4',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV5 = Lorentz(name = 'FFV5',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 4*Gamma(3,2,-1)*ProjP(-1,1)')

VVS1 = Lorentz(name = 'VVS1',
               spins = [ 3, 3, 1 ],
               structure = 'Metric(1,2)')

VVV1 = Lorentz(name = 'VVV1',
               spins = [ 3, 3, 3 ],
               structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

VVSS1 = Lorentz(name = 'VVSS1',
                spins = [ 3, 3, 1, 1 ],
                structure = 'Metric(1,2)')

VVVV1 = Lorentz(name = 'VVVV1',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVV2 = Lorentz(name = 'VVVV2',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) - 2*Metric(1,2)*Metric(3,4)')

VVVV3 = Lorentz(name = 'VVVV3',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVV4 = Lorentz(name = 'VVVV4',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')

VVVV5 = Lorentz(name = 'VVVV5',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3) - (Metric(1,3)*Metric(2,4))/2. - (Metric(1,2)*Metric(3,4))/2.')

# == Additional lorentz structure for Fenyman goldstones

UUS1 = Lorentz(name = 'UUS1',
               spins = [ -1, -1, 1 ],
               structure = '1')

FFS8 = Lorentz(name = 'FFS8',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1)')

FFS2 = Lorentz(name = 'FFS2',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) - ProjP(2,1)')

FFS3 = Lorentz(name = 'FFS3',
               spins = [ 2, 2, 1 ],
               structure = 'ProjP(2,1)')

FFS4 = Lorentz(name = 'FFS4',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) + ProjP(2,1)')

VSS1 = Lorentz(name = 'VSS1',
               spins = [ 3, 1, 1 ],
               structure = 'P(1,2) - P(1,3)')

SSSS1 = Lorentz(name = 'SSSS1',
                spins = [ 1, 1, 1, 1 ],
                structure = '1')

# NEW

FFS5 = Lorentz(name = 'FFS5',
	       spins = [ 2, 2, 1 ],
	       structure = 'Gamma5(2,1)')



# NEW

# List of changes in coupling names in order to avoid overlap
#
# coupling name in HEFT cp-even      vs      here
#                      
#                          VVS1      ->      VVS2
#

# this is valid for boh on- and off-shell gluons, even though in Fabio's
# lecture notes is derived supposing on-shell gluons
VVS2 = Lorentz(name = 'VVS2',
               spins = [ 3, 3, 1 ],
               structure = 'P(1,2)*P(2,1) - P(-1,1)*P(-1,2)*Metric(1,2)')

VVVS1 = Lorentz(name = 'VVVS1',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

VVVVS1 = Lorentz(name = 'VVVVS1',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVVS2 = Lorentz(name = 'VVVVS2',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVVS3 = Lorentz(name = 'VVVVS3',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')


# structures for R2 and UV counterterms to gluons-Higgs EFT

# (-17p1.p1 -93p1.p2 -17p2.p2)g^munu  +14p1^mu p1^nu  +p1^mu p2^nu  +89p1^nu p2^mu  +14p2^mu p2^nu
VVS3 = Lorentz(name = 'VVS3',
               spins = [ 3, 3, 1 ],
               structure = '-17*P(-1,1)*P(-1,1)*Metric(1,2)  -  93*P(-1,1)*P(-1,2)*Metric(1,2)  -  17.*P(-1,2)*P(-1,2)*Metric(1,2)  +  14*P(1,1)*P(2,1)  +  P(1,1)*P(2,2)  +  89*P(1,2)*P(2,1)  +  14*P(1,2)*P(2,2)')

# [p(q) - p(q~)]_mu gamma^mu
FFS11 = Lorentz(name = 'FFS11',
               spins = [ 2, 2, 1 ],
               structure = 'Gamma(-1,2,1)*( P(-1,2) - P(-1,1) )')

FFVS1 = Lorentz(name = 'FFVS1',
               spins = [ 2, 2, 3, 1 ],
                structure = 'Gamma(3,2,1)')

# 21 g_m1m2 g_m3m4  - 41 g_m1m3 g_m2m4  + 21 g_m1m4 g_m2m3
VVVVS11 = Lorentz(name = 'VVVVS11',
                 spins = [ 3, 3, 3, 3, 1 ],
                  structure = '21*Metric(1,2)*Metric(3,4) - 41*Metric(1,3)*Metric(2,4) + 21*Metric(1,4)*Metric(2,3)')

# 21 g_m1m2 g_m3m4  + 21 g_m1m3 g_m2m4  - 41 g_m1m4 g_m2m3
VVVVS12 = Lorentz(name = 'VVVVS12',
                 spins = [ 3, 3, 3, 3, 1 ],
                  structure = '21*Metric(1,2)*Metric(3,4) + 21*Metric(1,3)*Metric(2,4) - 41*Metric(1,4)*Metric(2,3)')

# - 41 g_m1m2 g_m3m4  + 21 g_m1m3 g_m2m4  + 21 g_m1m4 g_m2m3
VVVVS13 = Lorentz(name = 'VVVVS13',
                 spins = [ 3, 3, 3, 3, 1 ],
                  structure = '-41*Metric(1,2)*Metric(3,4) + 21*Metric(1,3)*Metric(2,4) + 21*Metric(1,4)*Metric(2,3)')





# structures for pseudoscalar-gluons EFT

VVS10 = Lorentz(name = 'VVS10',
               spins = [ 3, 3, 1 ],
               structure = 'Epsilon(1,2,-1,-2)*P(-1,1)*P(-2,2)')

VVVS2 = Lorentz(name = 'VVVS2',
               spins = [ 3, 3, 3, 1 ],
                structure = 'Epsilon(1,2,3,-1)*P(-1,1) + Epsilon(1,2,3,-1)*P(-1,2) + Epsilon(1,2,3,-1)*P(-1,3)')




# structures for X0

VVS11 = Lorentz(name = 'VVS11',
                spins = [ 3, 3, 1 ],
                structure = 'P(1,1)*P(2,1) - P(-1,1)*P(-1,1)*Metric(1,2)')

VVS12 = Lorentz(name = 'VVS12',
                spins = [ 3, 3, 1 ],
                structure = 'P(1,2)*P(2,2) - P(-1,2)*P(-1,2)*Metric(1,2)')

VVS13 = Lorentz(name = 'VVS13',
                spins = [ 3, 3, 1 ],
                structure = 'P(1,1)*P(2,1) - P(-1,1)*P(-1,1)*Metric(1,2) + P(1,2)*P(2,2) - P(-1,2)*P(-1,2)*Metric(1,2)')



