
(***************** This is the FeynRules model file for the Higgs characterisation project ***********)
(*****************************************************************************************************)
(* It contains parts of existing FR model files:                                                     *)
(* 1) HEFT, author: C. Duhr (https://feynrules.irmp.ucl.ac.be/wiki/HiggsEffectiveTheory)             *)
(* 2) Minimal Zprime, author: L. Basso (https://feynrules.irmp.ucl.ac.be/wiki/B-L-SM)                *)
(* 3) RS, author: P. de Aquino (https://feynrules.irmp.ucl.ac.be/wiki/RSmodel)                       *)
(*                                                                                                   *)
(* Please contact Priscila de Aquino (paquino@vub.ac.be) for bugs and/or further information         *)
(*                                                                                                   *)
(* THE UFO FILE HAS BEEN MODIFIED BY HAND: COUPLINGS OF THE X2 TO THE PHOTONS MODIFIED TO            *)
(* Ka AND INTERACTIONS BETWEEN RESONANCES REMOVED.                                                   *)
(*                                                                                                   *)
(*****************************************************************************************************)
FeynmanGauge = False;

M$ModelName = "Higgs_Characterization";
M$Information = {
  Authors      -> "P. de Aquino, K. Mawatari", 
  Version      -> "2.0",
  Date         -> "15. 04. 2013"
};

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
    U11Y  == {
    Abelian          -> True,  
    CouplingConstant -> g1,
    GaugeBoson       -> X1,
    Charge           -> Y}
    };

(* The loop coefficient from the HEFT model *)

sert[x_] := 1+ 7/30 x + 2/21 x^2 + 26/525 x^3;

serw[xw_, xt_] := 1 + xw * 66/235 +xw^2 * 228/1645 + xw^3 * 696/8225 +
            xw^4 * 5248/90475 +xw^5 * 1280/29939+ xw^6 * 54528/1646645- 
            xt * 56/705 - xt^2 * 32/987;

serp[x_] := 1 + x/3 + x^2 * 8/45 + x^3 * 4/35;

(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderLimit = {
     {QNP, 99}
    };

(***** Parameter list ******)

M$Parameters = {

kq == {
	    ParameterType -> External,
	    Value -> 1,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with light quarks"},

kg == {
	    ParameterType -> External,
	    Value -> 1,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with gluons"},

ka == {
	    ParameterType -> External,
	    Value -> 1,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with photons"},
		
kv == {
	    ParameterType -> External,
	    Value -> 1,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with vector boson"},

kl == {
	    ParameterType -> External,
	    Value -> 1,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with leptons"},

ka1 == {
	    ParameterType -> External,
	    Value -> 0,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with photons"},
		
	
kg1 == {
	    ParameterType -> External,
	    Value -> 0,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with gluons"},

ka2 == {
	    ParameterType -> External,
	    Value -> 0,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with photons"},
		
kg2 == {
	    ParameterType -> External,
	    Value -> 0,
		InteractionOrder -> {QNP, 1},
	    Description -> "Coupling with gluons"},
		
		
Lambda == {
	    ParameterType -> External,
	    Value -> 1000,
	    Description -> "Spin-2 effective scale"},

ksm == {
	    ParameterType -> External,
	    Value -> 1,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Lower dimensional operator switch"},

GHaa == {TeX -> Subscript[g, Haa],
       ParameterType -> Internal,
       Value -> ee^2/4/Pi/(Pi*vev)*(47/18)*serw[(MX0/2/MW)^2, (MX0/2/MT)^2]},

GAaa == {TeX -> Subscript[g, Aaa],
       ParameterType -> Internal,
       Value -> ee^2/4/Pi/(Pi*vev)},

GHza == {TeX -> Subscript[g, Hza],
       ParameterType -> Internal,
       Value -> ee^2/4/Pi/(Pi*vev)},

GAza == {TeX -> Subscript[g, Aza],
       ParameterType -> Internal,
       Value -> ee^2/4/Pi/(Pi*vev)},

GHgg == {TeX -> Subscript[g, Hgg],
       ParameterType -> Internal,
       Value -> -gs^2/(4Pi(3Pi vev)) sert[(MX0/2/MT)^2] },

GAgg == {TeX -> Subscript[g, Agg],
       ParameterType -> Internal,
       Value -> -gs^2/4/Pi/(2*Pi*vev)*serp[(MX0/2/MT)^2]},

kHff == {TeX -> Subscript[k, Hf],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kAff == {TeX -> Subscript[k, Af],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kHaa == {TeX -> Subscript[k, Haa],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kAaa == {TeX -> Subscript[k, Aaa],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kHza == {TeX -> Subscript[k, Hza],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kAza == {TeX -> Subscript[k, Aza],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kHgg == {TeX -> Subscript[k, Hgg],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},

kAgg == {TeX -> Subscript[k, Agg],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 1},
	   
kHvv == {TeX -> Subscript[k, Hvv],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 0},

kAvv == {TeX -> Subscript[k, Avv],
       ParameterType -> External,
	   InteractionOrder -> {QNP, 1},
       Value -> 0},

afu == {
	    ParameterType -> Internal,
	    Value -> -gs/(2 cw)(1/2-4*sw2/3)},
		
bfu == {
	    ParameterType -> Internal,
	    Value -> -gs/(2 cw)(1/2)},
		
kfau == {
	    ParameterType -> External,
	    Value -> 1,
	    InteractionOrder -> {QNP, 1}},

kfbu == {
	    ParameterType -> External,
	    Value -> 1,
	    InteractionOrder -> {QNP, 1}},

afd == {
	    ParameterType -> Internal,
	    Value -> -gs/(2 cw)(-1/2+2*sw2/3)},
		
bfd == {
	    ParameterType -> Internal,
	    Value ->  -gs/(2 cw)(-1/2)},
		
kfad == {
	    ParameterType -> External,
	    Value -> 1,
	    InteractionOrder -> {QNP, 1}},

kfbd == {
	    ParameterType -> External,
	    Value -> 1,
	    InteractionOrder -> {QNP, 1}},

gwwz == {
	    ParameterType -> Internal,
	    Value -> -ee cw/sw,
	    Description -> "SM coupling"},

kv1 == {
	    ParameterType -> External,
	    Value -> 0,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Couplings of spin-1 to X"},

kv2 == {
	    ParameterType -> External,
	    Value -> 0,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Couplings of spin-1 to X"},

kv3 == {
	    ParameterType -> External,
	    Value -> 0,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Couplings of spin-1 to X"},

kv4 == {
	    ParameterType -> External,
	    Value -> 0,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Couplings of spin-1 to X"},

kv5 == {
	    ParameterType -> External,
	    Value -> 0,
	    InteractionOrder -> {QNP, 1},
	    Description -> "Couplings of spin-1 to X"},


(*tha == {Value -> 2.88,
          TeX -> Subscript[\[Theta], a],
          Description -> "Scalar mixing angle"},*)

ca == {ParameterType -> External,
          Value -> 1,
          TeX -> Subscript[c,a],
          InteractionOrder -> {QNP, 0},
          Description -> "Cos of the scalar mixing angle"},

sa == {ParameterType -> Internal,
          Value -> Sqrt[1-ca^2],
          TeX -> Subscript[s,a],
          InteractionOrder -> {QNP, 0},
          Description -> "Sin of the scalar mixing angle"}
};


(***** Particle classes list ******)

M$ClassesDescription = {
 V[7] == {
        ClassName -> X1,
        SelfConjugate -> True,
        Indices -> {},
        Mass -> {MX1, 125.0},
        Width -> {WX1, 0.07567860},
        PropagatorLabel -> "X1",
        ParticleName -> "X1",
        PropagatorType -> Sine,
        PropagatorArrow -> None,
        PDG -> 5000002,
        FullName -> "X1"},
		
(*V[8] == {
        ClassName -> X1p,
        SelfConjugate -> True,
        Indices -> {},
        Mass -> {MX1p, 125.0},
        Width -> {WX1p, 0.07567860},
        PropagatorLabel -> "X1p",
        ParticleName -> "X1p",
        PropagatorType -> Sine,
        PropagatorArrow -> None,
        PDG -> 5000003, 
        FullName -> "X1m"},*)

 S[3] == {
   ClassName -> X0x,
   SelfConjugate -> True,
   Mass -> {MX0,125},
   Width -> {WX0, 0.07567860},
   PDG -> 5000001,
   ParticleName -> "X0"},


T[1] == {
     ClassName -> X2,
     SelfConjugate -> True,
     ParticleName ->"X2",
     PDG -> 5000004,
     Symmetric -> True, 
     Mass -> {MX2, 125.0},
     Width -> {WX2,0.07567860}}	 
	 
	 };

(**************************************** Lagrangian *************************************)
(*****************************************************************************************)

(* Spin-0 ********************************************************************************)
(*****************************************************************************************)

LG0:= - 1/4 (  ca kHgg GHgg FS[G, mu, nu, b] FS[G, mu, nu, b] +
                sa kAgg GAgg FS[G, mu, nu, b] Dual[FS][G, mu, nu, b]) X0x -
        1/4 (  ca kHaa GHaa (del[A[nu], mu] - del[A[mu], nu])(del[A[nu], mu] - del[A[mu], nu]) +
                sa kAaa GAaa (del[A[nu], mu] - del[A[mu], nu])(1/2)Eps[mu,nu,rho,sig](del[A[sig], rho]-del[A[rho], sig])) X0x -
        1/4 (  ca kHza GHza (del[Z[nu], mu] - del[Z[mu], nu])(del[A[nu], mu] - del[A[mu], nu]) +
				sa kAza GAza (del[Z[nu], mu] - del[Z[mu], nu])(1/2)Eps[mu,nu,rho,sig](del[A[sig], rho]-del[A[rho], sig])) X0x -
        1/4(  ca kHvv ((del[Z[nu], mu] - del[Z[mu], nu])(del[Z[nu], mu] - del[Z[mu], nu]) +
         	     (del[Wbar[nu], mu] - del[Wbar[mu], nu])(del[W[nu], mu] - del[W[mu], nu])) +
	        sa kAvv ((del[Z[nu], mu] - del[Z[mu], nu])(1/2)Eps[mu,nu,rho,sig](del[Z[sig], rho] - del[Z[rho], sig]) +
		      (del[Wbar[nu], mu] - del[Wbar[mu], nu])(1/2)Eps[mu,nu,rho,sig](del[W[sig], rho] - del[W[rho], sig]))) X0x;


(*****************************************************************************************)

(* RS ************************************************************************************)
(*****************************************************************************************)


(********************** Gravitational Coupling ******************************************)
(********************** Defining the cov derivatives *************************************)

covdelU[field_, mu_] := 
  Module[{j, a},   del[field, mu] - I gs G[mu, a] T[a].field 
                 - I ee/cw 4/3 B[mu]/2 ProjP.field - I ee/cw/3 B[mu]/2 ProjM.field - I ee/sw/2 ProjM.field Wi[mu,3]];

covdelD[field_, mu_] := 
  Module[{j, a}, del[field, mu] - I gs G[mu, a] T[a].field 
                 + I ee/cw 2/3 B[mu]/2 ProjP.field - I ee/cw/3 B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

covdelE[field_, mu_] := 
  Module[{j, a},  del[field, mu] 
                 + I ee/cw 2 B[mu]/2 ProjP.field + I ee/cw B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

(* Version 2.0 => fixed a sign problem and a factor 2 missing in the above derivative *)

covdelN[field_, mu_] := 
  Module[{j, a}, del[field, mu] + I ee/cw B[mu]/2 ProjM.field - I ee/sw/2 ProjM.field Wi[mu,3]];

(******************** Defining the field strenght tensors:********************************)

FG[mu_,nu_,a1_,a2_,a3_] := del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3];

FA[mu_,nu_] := del[B[nu], mu] - del[B[mu], nu];

FW[mu_,nu_,i1_,i2_,i3_] := del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + ee/sw Eps[i1, i2, i3] Wi[mu, i2] Wi[nu, i3];

(******************* Defining the energy-momentum tensor T[mu,nu] ************************)

(* Gauge bosons *)

TG[mu_,nu_]:= ( - ME[mu,nu]. (-1/4 (-kv) FA[rho, sig] FA[rho,sig] - 1/4 (-kv)FW[rho,sig,i1,i2,i3] FW[rho,sig, i1,i4,i5] - 1/4 (-kg)FG[rho,sig,a1,a2,a3] FG[rho,sig, a1,a4,a5]) 
                - (-kv)FA[mu,rho] FA[nu,rho] - (-kv)FW[mu,rho,i1,i2,i3] FW[nu,rho, i1,i4,i5] - (-kg) FG[mu,rho,a1,a2,a3] FG[nu,rho, a1,a2,a3]);
(* Fermions *)

TF[mu_,nu_] := (-ME[mu,nu] ((-kq) (I uqbar.(Ga[rho].covdelU[uq, rho]) -1/2 del[I uqbar.Ga[rho].uq, rho] 
                          + I dqbar.(Ga[rho].covdelD[dq, rho]) -1/2 del[I dqbar.Ga[rho].dq, rho]) 
                          +(-kl)(+ I vlbar.(Ga[rho].covdelN[vl, rho]) -1/2 del[I vlbar.Ga[rho].vl, rho]
                          + I lbar.(Ga[rho].covdelE[l, rho]  ) -1/2 del[I lbar.Ga[rho].l, rho])
                          
                          + ee/sw/Sqrt[2] ((-kq) uqbar.Ga[rho].ProjM.CKM.dq W[rho] + (-kq) dqbar.Ga[rho].ProjM.HC[CKM].uq Wbar[rho]
                                         + (-kl) vlbar.Ga[rho].ProjM.l W[rho] + (-kq) lbar.Ga[rho].ProjM.vl Wbar[rho]) ) 
               + ( (-kq) (I/2  uqbar.Ga[mu].covdelU[uq, nu] - 1/4 I del[uqbar.Ga[nu].uq, mu] 
                    + I/2  uqbar.Ga[nu].covdelU[uq, mu] - 1/4 I del[uqbar.Ga[mu].uq, nu]                   
                    + I/2  dqbar.Ga[mu].covdelD[dq, nu] - 1/4 I del[dqbar.Ga[nu].dq, mu] 
                    + I/2  dqbar.Ga[nu].covdelD[dq, mu] - 1/4 I del[dqbar.Ga[mu].dq, nu])+
                    (-kl) (I/2  vlbar.Ga[mu].covdelN[vl, nu] - 1/4 I del[vlbar.Ga[nu].vl, mu] 
                    + I/2  vlbar.Ga[nu].covdelN[vl, mu] - 1/4 I del[vlbar.Ga[mu].vl, nu]                    
                    + I/2  lbar.Ga[mu].covdelE[l, nu] - 1/4 I del[lbar.Ga[nu].l, mu] 
                    + I/2  lbar.Ga[nu].covdelE[l, mu] - 1/4 I del[lbar.Ga[mu].l, nu])  )

                + ee/sw/2/Sqrt[2] ((-kq)(uqbar.Ga[mu].ProjM.CKM.dq W[nu] + dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[nu] 
                              + uqbar.Ga[nu].ProjM.CKM.dq W[mu] + dqbar.Ga[nu].ProjM.HC[CKM].uq Wbar[mu])
                              + (-kl)(vlbar.Ga[mu].ProjM.l W[nu] + lbar.Ga[mu].ProjM.vl Wbar[nu] 
                              + vlbar.Ga[nu].ProjM.l W[mu] + lbar.Ga[nu].ProjM.vl Wbar[mu])));

TFAxial[mu_,nu_] := (-ME[mu,nu] ((-kq)(I uqbar.(Ga[rho].Ga[5].covdelU[uq, rho]) -1/2 del[I uqbar.Ga[rho].Ga[5].uq, rho] 
                          + I dqbar.(Ga[rho].Ga[5].covdelD[dq, rho]) -1/2 del[I dqbar.Ga[rho].Ga[5].dq, rho])
                          + (-kl)( I vtbar.(Ga[rho].Ga[5].covdelN[vt, rho]) -1/2 del[I vtbar.Ga[rho].Ga[5].vt, rho]
                          + I lbar.(Ga[rho].Ga[5].covdelE[l, rho]  ) -1/2 del[I lbar.Ga[rho].Ga[5].l, rho])
                          
                          + ee/sw/Sqrt[2] (-kq uqbar.Ga[rho].Ga[5].ProjM.CKM.dq W[rho] + (-kq) dqbar.Ga[rho].Ga[5].ProjM.HC[CKM].uq Wbar[rho] 
                                         + (-kl) vtbar.Ga[rho].Ga[5].ProjM.l W[rho] + (-kl) lbar.Ga[rho].Ga[5].ProjM.vt Wbar[rho]) )
               + ((-kq)(I/2  uqbar.Ga[mu].Ga[5].covdelU[uq, nu] - 1/4 I del[uqbar.Ga[nu].Ga[5].uq, mu] 
                    + I/2  uqbar.Ga[nu].Ga[5].covdelU[uq, mu] - 1/4 I del[uqbar.Ga[mu].Ga[5].uq, nu]                   
                    + I/2  dqbar.Ga[mu].Ga[5].covdelD[dq, nu] - 1/4 I del[dqbar.Ga[nu].Ga[5].dq, mu] 
                    + I/2  dqbar.Ga[nu].Ga[5].covdelD[dq, mu] - 1/4 I del[dqbar.Ga[mu].Ga[5].dq, nu])
                    + (-kl) (I/2  vtbar.Ga[mu].Ga[5].covdelN[vt, nu] - 1/4 I del[vtbar.Ga[nu].Ga[5].vt, mu] 
                    + I/2  vtbar.Ga[nu].Ga[5].covdelN[vt, mu] - 1/4 I del[vtbar.Ga[mu].Ga[5].vt, nu]                    
                    + I/2  lbar.Ga[mu].Ga[5].covdelE[l, nu] - 1/4 I del[lbar.Ga[nu].Ga[5].l, mu]
                    + I/2  lbar.Ga[nu].Ga[5].covdelE[l, mu] - 1/4 I del[lbar.Ga[mu].Ga[5].l, nu]))

                + ee/sw/2/Sqrt[2] ((-kq) (uqbar.Ga[mu].Ga[5].ProjM.CKM.dq W[nu] + dqbar.Ga[mu].Ga[5].ProjM.HC[CKM].uq Wbar[nu] 
                              + uqbar.Ga[nu].Ga[5].ProjM.CKM.dq W[mu] + dqbar.Ga[nu].Ga[5].ProjM.HC[CKM].uq Wbar[mu])
                              +(-kl) (vtbar.Ga[mu].Ga[5].ProjM.l W[nu] + lbar.Ga[mu].Ga[5].ProjM.vt Wbar[nu]
                              + vtbar.Ga[nu].Ga[5].ProjM.l W[mu] + lbar.Ga[nu].Ga[5].ProjM.vt Wbar[mu])));


(* Definitions for Higgs and Yukawa *)
 
TH[mu_, nu_]  := Block[{ii,mu, feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  ExpandIndices[-ME[mu,nu].(DC[PhiHbar[ii],rho] DC[PhiH[ii],rho])+DC[PhiHbar[ii],mu] DC[PhiH[ii],nu]+DC[PhiHbar[ii],nu] DC[PhiH[ii],mu], FlavorExpand->{SU2D,SU2W}]/.feynmangaugerules
 ];

(* Yukawa *)

TYuk := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  yuk = ExpandIndices[
   -yd[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] PhiH[ii] -
    yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] PhiH[ii] - 
    yu[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] PhiHbar[jj] Eps[ii, jj], FlavorExpand -> SU2D];
  yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
  yuk+HC[yuk]/.feynmangaugerules
 ];

TY[mu_,nu_] := -ME[mu,nu](TYuk + HC[TYuk]);


(* Gauge fixing term is here because Madgraph takes the Feynman gauge for massless gauge boson propagators and unitary gauge for massive gauge boson propagators. *)

TGF[mu_, nu_]:= (-ME[mu,nu].( (-kg)del[del[G[sig, a1], sig], rho].G[rho, a1] + (-ka)del[del[A[sig], sig], rho].A[rho] +
				1/2 (-kg)del[G[rho, a1], rho].del[G[rho, a1], rho] + 1/2 (-ka)del[A[rho], rho].del[A[rho], rho])
      			+ ((-kg)del[del[G[rho, a1], rho], mu].G[nu, a1] + (-ka)del[del[A[rho], rho], mu].A[nu] +(-kg)
    						   del[del[G[rho, a1], rho], nu].G[mu, a1] + (-ka)del[del[A[rho], rho], nu].A[mu] ));

(*******************************  Writing the lagrangian *********************************)

LagG := 1/Lambda (X2[mu,nu] (TG[mu,nu] + TGF[mu,nu])); (*ka,kg,kv are defined with TG[mu,nu]*)
LagF := 1/Lambda(X2[mu,nu] TF[mu,nu]);
LagHY := -kq/Lambda(X2[mu,nu] TY[mu,nu]) -kv/Lambda(X2[mu,nu] TH[mu,nu]);
LagRS := LagG + LagF + LagHY;

(********** Beta implementation of the 2+ (higher dimensional) and 2- resonance ***********)

TA2m[mu_, nu_] := (-del[del[(-1/4 FA[rho, sig] FA[rho, sig]), mu], nu]);
TA2mAxial[mu_, nu_] := (-del[del[(-1/8 FA[rho, sig] Eps[rho, sig, alpha, beta] FA[alpha, beta]), mu], nu]);

TW2m[mu_, nu_] := (-del[del[(-1/4 FW[rho, sig, i1, i2, i3] FW[rho, sig, i1, i4, i5]), mu], nu]);
TW2mAxial[mu_, nu_] := (-del[del[(-1/8 FW[rho, sig, i1, i2, i3] Eps[rho, sig, alpha, beta] FW[alpha, beta, i1, i4, i5]), mu], nu]);

TG2m[mu_, nu_] := (-del[del[(-1/4 FG[rho, sig, a1, a2, a3] FG[rho, sig, a1, a4, a5]),mu],nu]);
TG2mAxial[mu_, nu_] := (-del[del[(-1/8 FG[rho, sig, a1, a2, a3] Eps[rho, sig, alpha, beta] FG[alpha, beta, a1, a4, a5]), mu], nu]);

LG2m := X2[mu,nu] (-ka2/Lambda^3 TA2mAxial[mu,nu] -kv2/Lambda^3 TW2mAxial[mu,nu] -kg2/Lambda^3 TG2mAxial[mu,nu]);
LGHD := X2[mu,nu] (-ka1/Lambda^3 TA2m[mu,nu] -kv1/Lambda^3 TW2m[mu,nu] -kg1/Lambda^3 TG2m[mu,nu]);

(*****************************************************************************************)
(* Spin-1 - vector and pseudo-vector *****************************************************)
(*****************************************************************************************)
		
(* Defining one arbitrary coupling of the spin-1 with W+ W- *)

		LBprightPsVec =
			kfbu bfu X1[mu] uqbar[s,n,i].Ga[mu,s,v].Ga[5,v,x].ProjP[x,r].uq[r,n,i] +
			kfbd bfd X1[mu] dqbar[s,n,i].Ga[mu,s,v].Ga[5,v,x].ProjP[x,r].dq[r,n,i];
	
		LBpleftPsVec =
			kfbu bfu X1[mu] uqbar[s,n,i].Ga[mu,s,v].Ga[5,v,x].ProjM[x,r].uq[r,n,i] +
			kfbd bfd X1[mu] dqbar[s,n,i].Ga[mu,s,v].Ga[5,v,x].ProjM[x,r].dq[r,n,i];

		LBprightVec =
			kfau afu X1[mu] uqbar[s,n,i].Ga[mu,s,v].ProjP[v,r].uq[r,n,i] +
			kfad afd X1[mu] dqbar[s,n,i].Ga[mu,s,v].ProjP[v,r].dq[r,n,i];
	
		LBpleftVec =
			kfau afu X1[mu] uqbar[s,n,i].Ga[mu,s,v].ProjM[v,r].uq[r,n,i] +
			kfad afd X1[mu] dqbar[s,n,i].Ga[mu,s,v].ProjM[v,r].dq[r,n,i];


LF= LBprightVec + LBpleftVec + LBprightPsVec + LBpleftPsVec;
 

LWW=( I kv1 gwwz(del[Wbar[nu], mu] - del[Wbar[mu], nu]) W[mu] X1[nu] - I kv1 gwwz Wbar[mu] X1[nu] (del[W[nu], mu] - del[W[mu], nu])
    +I kv2 gwwz Wbar[mu]W[nu]FS[X1,mu,nu]
	-kv3 Wbar[mu]W[nu](del[X1[nu],mu]+del[X1[mu],nu])
	-kv5 Eps[mu,nu,rho,sig](Wbar[mu]del[W[nu],rho]-del[Wbar[mu],rho]W[nu])X1[sig]
	+I kv4 Wbar[mu]W[nu](1/2)Eps[mu,nu,rho,sig](del[X1[sig],rho]-del[X1[rho],sig])
);
LZZ= -kv3 X1[mu]del[Z[mu],nu]Z[nu]- kv5 Eps[mu,nu,rho,sig]X1[mu]Z[nu]del[Z[sig],rho];

(* LWW and LZZ based on the reference: K.Hagiwara et al, Nucl. Phys. B282 (1987) 253-307 *)
(*****************************************************************************************)

Ltot:= LSM + LF +LagRS + LG0 + LWW + LZZ + LGHD + LG2m;

