(*****************************************************************************************************)
(*            This is the FeynRules model file for the Higgs characterisation project                *)
(*                                                                                                   *)
(* It contains parts of existing FR model files:                                                     *)
(* 1) HEFT, author: C. Duhr (https://feynrules.irmp.ucl.ac.be/wiki/HiggsEffectiveTheory)             *)
(* 2) Minimal Zprime, author: L. Basso (https://feynrules.irmp.ucl.ac.be/wiki/B-L-SM)                *)
(* 3) RS, author: P. de Aquino (https://feynrules.irmp.ucl.ac.be/wiki/RSmodel)                       *)
(*                                                                                                   *)
(* Please contact K. Mawatari (kentarou.mawatari@lpsc.in2p3.fr) for bugs and/or further information. *)
(*                                                                                                   *)
(*****************************************************************************************************)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "HC";

M$Information = {
 Authors      -> {"K. Mawatari"}, 
 Version      -> "4.1",
 Date         -> "18.04.2016",
 Institutions -> {"LPSC Grenoble"},
 Emails       -> {"kentarou.mawatari@lpsc.in2p3.fr"},
 URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/HiggsCharacterisation/",  
 References   -> {"P. Artoisenet et al., arXiv:1306.6464"}
};


(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 16.01.2013 v1.0 - release version. *) 
(* 04.04.2013 v1.1 - added the CP-odd Yukawa terms in the X0 Lagrangian. *)
(*                   modified the X2 HD lagrangian to be proportional to 1/Lambda3. *)
(* 15.04.2013 v2.0 - fixed a bug for the X2 lowest dimensional interactions with massive gauge bosons. *)
(*                   parametrisation for X0 modified. *)
(* 28.05.2013 v2.1 - fixed a bug for the X0 coupling to the massive vector bosons (SM couplings recovered). *)
(* 27.06.2013 v3.0 - major update and version for the paper [arXiv:1306.6464]. *)
(* 04.07.2013 v3.1 - fixed a bug in the gluon/photon gauge fixing term for X2. *)
(* 20.07.2013 v3.2 - put the X width = 0.00407 GeV by HXSWG. *)
(*                   introduced kqa, kqb, kla, and klb, instead of kfa and kfb. *)
(* 24.07.2013 v3.3 - added the SM X0 self-interactions and the effective g-g-X0-X0 intereaction. *)
(* 17.10.2013 v3.4 - redefined 'kHdw' as a complex. *)
(* 11.12.2013 v4.0 - based on FR2.0. *)
(*                   fixed a sign of the AVV couplings.  *)
(*                   introduced kq3 for the X2 couplings to bottom and top. *)
(* 18.04.2016 v4.1 - redefined LYukawaOdd in SM_HC.fr in terms of the Yukawa couplings. *)
(*                   corrected the neutrino energy-momentum tensor for X2. *)
(*                   added the X2-Z-A interaction. *)


FeynmanGauge = False;

(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderLimit = {
 {QNP, 2}
};

M$InteractionOrderHierarchy = {
  {QNP, 2}
};


(***** Particle classes list ******)

M$ClassesDescription = {

 S[1] == { ClassName -> X0,
      	   SelfConjugate -> True,
   	   Mass -> {MX0, 125.0},
   	   Width -> {WX0, 0.00407},
           ParticleName -> "X0",
           PDG -> 5000000,
           PropagatorLabel -> "X0",
           PropagatorType  -> D,
           PropagatorArrow -> None,
           FullName -> "X0"},

 V[5] == { ClassName -> X1,
           SelfConjugate -> True,
           Mass -> {MX1, 125.0},
           Width -> {WX1, 0.00407},
           ParticleName -> "X1",
           PDG -> 5000001,
           PropagatorLabel -> "X1",
           PropagatorType -> Sine,
           PropagatorArrow -> None,
           FullName -> "X1"},
		
 T[1] == { ClassName -> X2,
           SelfConjugate -> True,
           Symmetric -> True, 
           Mass -> {MX2, 125.0},
           Width -> {WX2,0.00407},	 
           ParticleName -> "X2",
           PDG -> 5000002,
           PropagatorLabel -> "X2",
           PropagatorArrow -> None,
           FullName -> "X2"}

};


(* The loop coefficient from the HEFT model *)

sert[x_] := 1+ 7/30 x + 2/21 x^2 + 26/525 x^3;
serw[xw_, xt_] := 1 + xw * 66/235 +xw^2 * 228/1645 + xw^3 * 696/8225 +
            xw^4 * 5248/90475 +xw^5 * 1280/29939+ xw^6 * 54528/1646645- 
            xt * 56/705 - xt^2 * 32/987;
serp[x_] := 1 + x/3 + x^2 * 8/45 + x^3 * 4/35;


(***** Parameter list ******)

M$Parameters = {

 Lambda == { ParameterType -> External,
	     Value -> 1000,
	     TeX -> \[CapitalLambda],
	     Description -> "cut-off scale"},

 ca == { ParameterType -> External,
         Value -> 1,
         TeX -> Subscript[c,a],
         Description -> "cosine of the scalar mixing between 0+ and 0-"},

 sa == { ParameterType -> Internal,
         Value -> Sqrt[1-ca^2],
         TeX -> Subscript[s,a],
         Description -> "sine of the scalar mixing between 0+ and 0-"},

 kSM == { ParameterType -> External,
	  Value -> 1,
          TeX -> Subscript[\[Kappa],SM],
	  Description -> "Hzz/Hww SM coupling parameter"},

 kHtt == { ParameterType -> External,
	   Value -> 1, 
           TeX -> Subscript[\[Kappa],Htt],
           Description -> "Htt coupling parameter"},

 kAtt == { ParameterType -> External,
           Value -> 1,
           TeX -> Subscript[\[Kappa],Att],
           Description -> "Att coupling parameter"},

 kHbb == { ParameterType -> External,
	   Value -> 1, 
           TeX -> Subscript[\[Kappa],Hbb],
           Description -> "Hbb coupling parameter"},

 kAbb == { ParameterType -> External,
           Value -> 1,
           TeX -> Subscript[\[Kappa],Abb],
           Description -> "Abb coupling parameter"},

 kHll == { ParameterType -> External,
	   Value -> 1, 
           TeX -> Subscript[\[Kappa],Hll],
           Description -> "Hll coupling parameter"},

 kAll == { ParameterType -> External,
           Value -> 1,
           TeX -> Subscript[\[Kappa],All],
           Description -> "All coupling parameter"},

 kHaa == { ParameterType -> External,
           Value -> 1,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Haa],
           Description -> "Haa coupling parameter"},

 kAaa == { ParameterType -> External,
           Value -> 1,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Aaa],
           Description -> "Aaa coupling parameter"},

 kHza == { ParameterType -> External,
           Value -> 1,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hza],
           Description -> "Hza coupling parameter"},

 kAza == { ParameterType -> External,
           Value -> 1,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Aza],
           Description -> "Aza coupling parameter"},
 
 kHgg == { ParameterType -> External,
           Value -> 1,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hgg],
           Description -> "Hgg coupling parameter"},

 kAgg == { ParameterType -> External,
           Value -> 1,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Agg],
           Description -> "Agg coupling parameter"},

 kHzz == { ParameterType -> External,
           Value -> 0,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hzz],
           Description -> "Hzz coupling parameter"},

 kAzz == { ParameterType -> External,
           Value -> 0,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Azz],
           Description -> "Azz coupling parameter"},

 kHww == { ParameterType -> External,
           Value -> 0,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hww],
           Description -> "Hww coupling parameter"},

 kAww == { ParameterType -> External,
           Value -> 0,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Aww],
           Description -> "Aww coupling parameter"},

 kHda == { ParameterType -> External,
           Value -> 0,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hda],
           Description -> "Hda coupling parameter"},

 kHdz == { ParameterType -> External,
           Value -> 0,	  
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hdz],
           Description -> "Hdz coupling parameter"},

 kHdwR == { ParameterType -> External,
       	    ComplexParameter -> False,
            Value -> 0,	  
            TeX -> Subscript[\[Kappa],HdwR],
            Description -> "Hdw coupling parameter (real part)"},
 
 kHdwI == { ParameterType -> External,
       	    ComplexParameter -> False,
            Value -> 0,	  
            TeX -> Subscript[\[Kappa],HdwI],
            Description -> "Hdw coupling parameter (imaginary part)"},

 kHdw == { ParameterType -> Internal,
      	   ComplexParameter -> True,
	   Value -> {kHdwR+I*kHdwI},
           InteractionOrder -> {QNP, 1},
           TeX -> Subscript[\[Kappa],Hdw],
           Description -> "Hdw coupling parameter"},

(*
 kHwudLR == { ParameterType -> External,
       	     ComplexParameter -> False,
             Value -> 0,	  
             TeX -> Subscript[\[Kappa],HwudLR],
             Description -> "HwudL coupling parameter (real part)"},
 
 kHwudLI == { ParameterType -> External,
       	     ComplexParameter -> False,
             Value -> 0,	  
             TeX -> Subscript[\[Kappa],HwudLI],
             Description -> "HwudL coupling parameter (imaginary part)"},

 kHwudL == { ParameterType -> Internal,
            ComplexParameter -> True,
	    Value -> {kHwudLR+I*kHwudLI},
            InteractionOrder -> {QNP, 1},
            TeX -> Subscript[\[Kappa],HwudL],
            Description -> "HwudL coupling parameter"},

 kHwudRR == { ParameterType -> External,
       	     ComplexParameter -> False,
             Value -> 0,	  
             TeX -> Subscript[\[Kappa],HwudRR],
             Description -> "HwudR coupling parameter (real part)"},
 
 kHwudRI == { ParameterType -> External,
       	     ComplexParameter -> False,
             Value -> 0,	  
             TeX -> Subscript[\[Kappa],HwudRI],
             Description -> "HwudR coupling parameter (imaginary part)"},

 kHwudR == { ParameterType -> Internal,
            ComplexParameter -> True,
	    Value -> {kHwudRR+I*kHwudRI},
            InteractionOrder -> {QNP, 1},
            TeX -> Subscript[\[Kappa],HwudR],
            Description -> "HwudR coupling parameter"},

 kHwllR == { ParameterType -> External,
       	     ComplexParameter -> False,
             Value -> 0,	  
             TeX -> Subscript[\[Kappa],HwllR],
             Description -> "Hwll coupling parameter (real part)"},
 
 kHwllI == { ParameterType -> External,
       	     ComplexParameter -> False,
             Value -> 0,	  
             TeX -> Subscript[\[Kappa],HwllI],
             Description -> "Hwll coupling parameter (imaginary part)"},

 kHwll == { ParameterType -> Internal,
            ComplexParameter -> True,
	    Value -> {kHwllR+I*kHwllI},
            InteractionOrder -> {QNP, 1},
            TeX -> Subscript[\[Kappa],Hwll],
            Description -> "Hwll coupling parameter"},
*)

 kHHgg == { ParameterType -> External,
            Value -> 1,	  
            InteractionOrder -> {QNP, 1},
            TeX -> Subscript[\[Kappa],HHgg],
            Description -> "HHgg coupling parameter"},

 kAAgg == { ParameterType -> External,
            Value -> 1,	  
            InteractionOrder -> {QNP, 1},
            TeX -> Subscript[\[Kappa],AAgg],
            Description -> "AAgg coupling parameter"},

 kqa == { ParameterType -> External,
          Value -> 1,
          InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],qqa],
          Description -> "X1-qq vector coupling parameter"},

 kqb == { ParameterType -> External,
          Value -> 1,
          InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],qqb],
          Description -> "X1-qq axial-vector coupling parameter"},

 kla == { ParameterType -> External,
          Value -> 1,
          InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],lla],
          Description -> "X1-ll vector coupling parameter"},

 klb == { ParameterType -> External,
          Value -> 1,
          InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],llb],
          Description -> "X1-ll axial-vector coupling parameter"},

 kw1 == { ParameterType -> External,
	  Value -> 1,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],w1],
	  Description -> "X1-WW coupling parameter 1"},

 kw2 == { ParameterType -> External,
	  Value -> 1,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],w2],
	  Description -> "X1-WW coupling parameter 2"},

 kw3 == { ParameterType -> External,
	  Value -> 0,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],w3],
	  Description -> "X1-WW coupling parameter 3"},

 kw4 == { ParameterType -> External,
	  Value -> 0,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],w4],
	  Description -> "X1-WW coupling parameter 4"},

 kw5 == { ParameterType -> External,
	  Value -> 0,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],w5],
	  Description -> "X1-WW coupling parameter 5"},

 kz1 == { ParameterType -> External,
	  Value -> 0,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],z1],
	  Description -> "X1-ZZ coupling parameter 1"},

 kz3 == { ParameterType -> External,
	  Value -> 1,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],z3],
	  Description -> "X1-ZZ coupling parameter 3"},

 kz5 == { ParameterType -> External,
	  Value -> 0,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],z5],
	  Description -> "X1-ZZ coupling parameter 5"},

 kq == { ParameterType -> External,
	 Value -> 1,
	 InteractionOrder -> {QNP, 1},
         TeX -> Subscript[\[Kappa],q],
	 Description -> "X2-light quark coupling parameter"},

 kq3 == { ParameterType -> External,
	  Value -> 1,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],q3],
	  Description -> "X2-3rd generation quark coupling parameter"},

 kl == { ParameterType -> External,
         Value -> 1,
	 InteractionOrder -> {QNP, 1},
         TeX -> Subscript[\[Kappa],l],
	 Description -> "X2-lepton coupling parameter"},

 kg == { ParameterType -> External,
	 Value -> 1,
	 InteractionOrder -> {QNP, 1},
         TeX -> Subscript[\[Kappa],g],
	 Description -> "X2-gluon coupling parameter"},

 ka == { ParameterType -> External,
	 Value -> 1,
	 InteractionOrder -> {QNP, 1},
         TeX -> Subscript[\[Kappa],a],
	 Description -> "X2-photon coupling parameter"},

 kz == { ParameterType -> External,
	 Value -> 1,
	 InteractionOrder -> {QNP, 1},
         TeX -> Subscript[\[Kappa],z],
	 Description -> "X2-Z coupling parameter"},

 kw == { ParameterType -> External,
	 Value -> 1,
	 InteractionOrder -> {QNP, 1},
         TeX -> Subscript[\[Kappa],w],
	 Description -> "X2-W coupling parameter"}, 	

 kza == { ParameterType -> External,
	  Value -> 0,
	  InteractionOrder -> {QNP, 1},
          TeX -> Subscript[\[Kappa],za],
	  Description -> "X2-Z-A coupling parameter"},


 gHaa == { ParameterType -> Internal,
           Value -> ee^2/(4*Pi)/(Pi*vev)*(47/18), (* *serw[(MX0/2/MW)^2, (MX0/2/MT)^2], *)
           TeX -> Subscript[g,Haa],
           Description -> "Haa coupling"},

 gAaa == { ParameterType -> Internal,
           Value -> ee^2/(4*Pi)/(Pi*vev)*(4/3),
           TeX -> Subscript[g,Aaa],
           Description -> "Aaa coupling"},

 gHza == { ParameterType -> Internal,
           Value -> Sqrt[ee^2/(4*Pi)*Gf*MZ^2/(8*Sqrt[2]*Pi)]*(94*cw^2-13)/(9*Pi*vev),
           TeX -> Subscript[g,Hza],
           Description -> "Hza coupling"},

 gAza == { ParameterType -> Internal,
           Value -> 2*Sqrt[ee^2/(4*Pi)*Gf*MZ^2/(8*Sqrt[2]*Pi)]*(8*cw^2-5)/(3*Pi*vev),
           TeX -> Subscript[g,Aza],
           Description -> "Aza coupling"},

 gHgg == { ParameterType -> Internal,
           Value -> -gs^2/(4*Pi)/(3*Pi*vev), (* *sert[(MX0/2/MT)^2], *)
           TeX -> Subscript[g,Hgg], 
           Description -> "Hgg coupling"},

 gAgg == { ParameterType -> Internal,
           Value -> gs^2/(4*Pi)/(2*Pi*vev), (* *serp[(MX0/2/MT)^2], *)
           TeX -> Subscript[g,Agg],
           Description -> "Agg coupling"},

 gHHgg == { ParameterType -> Internal,
            Value -> gs^2/(4*Pi)/(3*Pi*vev^2), 
            TeX -> Subscript[g,HHgg], 
            Description -> "HHgg coupling"},

 gAAgg == { ParameterType -> Internal,
            Value -> gs^2/(4*Pi)/(2*Pi*vev^2), 
            TeX -> Subscript[g,AAgg], 
            Description -> "AAgg coupling"},

 au == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(1/2-4/3 sw2),
	 Tex -> Subscript[a,u],
         Description -> "vector coupling for up-type quarks"},
		
 bu == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(1/2), 
	 TeX -> Subscript[b,u],
         Description -> "axial-vector coupling for up-type quarks"},

 ad == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(-1/2+2/3 sw2),
	 TeX -> Subscript[a,d],
         Description -> "vector coupling for down-type quarks"},
		
 bd == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(-1/2),
 	 TeX -> Subscript[b,d],
         Description -> "axial-vector coupling for down-type quarks"},

 an == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(1/2),
	 Tex -> Subscript[a,n],
         Description -> "vector coupling for neutrinos"},
		
 bn == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(1/2), 
	 TeX -> Subscript[b,n],
         Description -> "axial-vector coupling for neutrinos"},

 al == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(-1/2+2 sw2),
	 TeX -> Subscript[a,l],
         Description -> "vector coupling for charged leptons"},
		
 bl == { ParameterType -> Internal,
	 Value -> ee/(2 sw cw)(-1/2),
 	 TeX -> Subscript[b,l],
         Description -> "axial-vector coupling for charged leptons"},

 gwwz == { ParameterType -> Internal,
	   Value -> -ee cw/sw,
           TeX -> Subscript[g,wwz],
	   Description -> "WWZ coupling"}

};


(*****************************************************************************************)
(**************************************** Lagrangian *************************************)
(*****************************************************************************************)

(****************************************** Spin-0 ***************************************)

L0v := (-1/4 ( ca kHaa gHaa FS[A,mu,nu] FS[A,mu,nu]      + sa kAaa gAaa FS[A,mu,nu] Dual[FS][A,mu,nu] ) - 
         1/2 ( ca kHza gHza FS[Z,mu,nu] FS[A,mu,nu]      + sa kAza gAza FS[Z,mu,nu] Dual[FS][A,mu,nu] ) -   
	 1/4 ( ca kHgg gHgg FS[G,mu,nu,a] FS[G,mu,nu,a]  + sa kAgg gAgg FS[G,mu,nu,a] Dual[FS][G,mu,nu,a] ) -
         1/4/Lambda ( ca kHzz FS[Z,mu,nu] FS[Z,mu,nu]    + sa kAzz FS[Z,mu,nu] Dual[FS][Z,mu,nu] ) - 
         1/2/Lambda ( ca kHww FS[Wbar,mu,nu] FS[W,mu,nu] + sa kAww FS[Wbar,mu,nu] Dual[FS][W,mu,nu] ) -
	 1  /Lambda ( ca kHda Z[nu] del[FS[A,mu,nu],mu]  + 
                      ca kHdz Z[nu] del[FS[Z,mu,nu],mu]  +
                      ca ( kHdw Wbar[nu] del[FS[W,mu,nu],mu] + HC[kHdw Wbar[nu] del[FS[W,mu,nu],mu]] ) ) ) X0; 

(*
L0vff := -1/Lambda ca ( kHwudL CKM[i,j] uqbar[s,i,a].Ga[mu,s,t].ProjM[t,u].dq[u,j,a] +
                        kHwudR uqbar.Ga[mu].ProjP.dq + 
                        kHwll  vlbar.Ga[mu].ProjM.l     ) W[mu] X0; 
*)

L0v6 := -1/8 ( ca kHHgg gHHgg FS[G,mu,nu,a] FS[G,mu,nu,a] + 
              +sa kAAgg gAAgg FS[G,mu,nu,a] Dual[FS][G,mu,nu,a] ) X0 X0; 


(****************************************** Spin-1 ***************************************)

L1f := ( kqa au uqbar[s,n,i].Ga[mu,s,t].uq[t,n,i] +
         kqa ad dqbar[s,n,i].Ga[mu,s,t].dq[t,n,i] +
         kla an vlbar[s,n]  .Ga[mu,s,t].vl[t,n]   +
         kla al  lbar[s,n]  .Ga[mu,s,t]. l[t,n]   -
         kqb bu uqbar[s,n,i].Ga[mu,s,t].Ga[5,t,u].uq[u,n,i] -
         kqb bd dqbar[s,n,i].Ga[mu,s,t].Ga[5,t,u].dq[u,n,i] - 
         klb bn vlbar[s,n]  .Ga[mu,s,t].Ga[5,t,u].vl[u,n]   - 
         klb bl  lbar[s,n]  .Ga[mu,s,t].Ga[5,t,u]. l[u,n]    ) X1[mu];

L1w := I kw1 gwwz ( FS[Wbar,mu,nu] W[mu] - FS[W,mu,nu] Wbar[mu] ) X1[nu] +
       I kw2 gwwz Wbar[mu] W[nu] FS[X1,mu,nu] -
         kw3 Wbar[mu] W[nu] ( del[X1[nu],mu] + del[X1[mu],nu] ) +
       I kw4 Wbar[mu] W[nu] Dual[FS][X1,mu,nu] -
         kw5 Eps[mu,nu,rho,sig] ( Wbar[mu] del[W[nu],rho] - del[Wbar[mu],rho] W[nu] ) X1[sig]; 
 
L1z := - kz1 FS[Z,mu,nu] Z[mu] X1[nu] -
         kz3 X1[mu] del[Z[mu],nu] Z[nu] -
         kz5 Eps[mu,nu,rho,sig] X1[mu] Z[nu] del[Z[sig],rho];

L1 := L1f + L1w + L1z;


(****************************************** Spin-2 ***************************************)

(*** Defining the cov derivatives ***)

covdelU[field_, mu_] := 
  Module[{j, a},   del[field, mu] - I gs G[mu, a] T[a].field 
                 - I ee/cw 4/3 B[mu]/2 ProjP.field - I ee/cw/3 B[mu]/2 ProjM.field - I ee/sw/2 ProjM.field Wi[mu,3]];

covdelD[field_, mu_] := 
  Module[{j, a}, del[field, mu] - I gs G[mu, a] T[a].field 
                 + I ee/cw 2/3 B[mu]/2 ProjP.field - I ee/cw/3 B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

covdelE[field_, mu_] := 
  Module[{j, a},  del[field, mu] 
                 + I ee/cw 2 B[mu]/2 ProjP.field + I ee/cw B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

covdelN[field_, mu_] := 
  Module[{j, a}, del[field, mu] + I ee/cw B[mu]/2 ProjM.field - I ee/sw/2 ProjM.field Wi[mu,3]];


(*** Defining the energy-momentum tensor T[mu,nu] ***)

(* Fermions *)

(* TFq[mu_,nu_] := (-ME[mu,nu] (I uqbar.(Ga[rho].covdelU[uq, rho]) -1/2 del[I uqbar.Ga[rho].uq, rho] 
                          + I dqbar.(Ga[rho].covdelD[dq, rho]) -1/2 del[I dqbar.Ga[rho].dq, rho] 
                          + ee/sw/Sqrt[2] (uqbar.Ga[rho].ProjM.CKM.dq W[rho] + dqbar.Ga[rho].ProjM.HC[CKM].uq Wbar[rho]) )
               + (    I/2  uqbar.Ga[mu].covdelU[uq, nu] - 1/4 I del[uqbar.Ga[nu].uq, mu] 
                    + I/2  uqbar.Ga[nu].covdelU[uq, mu] - 1/4 I del[uqbar.Ga[mu].uq, nu]                   
                    + I/2  dqbar.Ga[mu].covdelD[dq, nu] - 1/4 I del[dqbar.Ga[nu].dq, mu] 
                    + I/2  dqbar.Ga[nu].covdelD[dq, mu] - 1/4 I del[dqbar.Ga[mu].dq, nu] )
                + ee/sw/2/Sqrt[2] (uqbar.Ga[mu].ProjM.CKM.dq W[nu] + dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[nu] 
                              + uqbar.Ga[nu].ProjM.CKM.dq W[mu] + dqbar.Ga[nu].ProjM.HC[CKM].uq Wbar[mu] )); *)

TFq[mu_,nu_] := (-ME[mu,nu] (  I ubar.(Ga[rho].covdelU[u, rho]) -1/2 del[I ubar.Ga[rho].u, rho] 
                             + I dbar.(Ga[rho].covdelD[d, rho]) -1/2 del[I dbar.Ga[rho].d, rho] 
                             + ee/sw/Sqrt[2] (  Cos[cabi] ubar.Ga[rho].ProjM.d W[rho]
                                              + Sin[cabi] ubar.Ga[rho].ProjM.s W[rho] 
                                              + Cos[cabi] dbar.Ga[rho].ProjM.u Wbar[rho]
                                              + Sin[cabi] sbar.Ga[rho].ProjM.u Wbar[rho] )           )
                 +(  I/2 ubar.Ga[mu].covdelU[u, nu] - 1/4 I del[ubar.Ga[nu].u, mu] 
                   + I/2 ubar.Ga[nu].covdelU[u, mu] - 1/4 I del[ubar.Ga[mu].u, nu]                   
                   + I/2 dbar.Ga[mu].covdelD[d, nu] - 1/4 I del[dbar.Ga[nu].d, mu] 
                   + I/2 dbar.Ga[nu].covdelD[d, mu] - 1/4 I del[dbar.Ga[mu].d, nu] )
                 +ee/sw/2/Sqrt[2] (  Cos[cabi] ubar.Ga[mu].ProjM.d W[nu] 
                                   + Cos[cabi] ubar.Ga[nu].ProjM.d W[mu]
                                   + Sin[cabi] ubar.Ga[mu].ProjM.s W[nu] 
                                   + Sin[cabi] ubar.Ga[nu].ProjM.s W[mu]
                                   + Cos[cabi] dbar.Ga[mu].ProjM.u Wbar[nu] 
                                   + Cos[cabi] dbar.Ga[nu].ProjM.u Wbar[mu] 
                                   + Sin[cabi] sbar.Ga[mu].ProjM.u Wbar[nu] 
                                   + Sin[cabi] sbar.Ga[nu].ProjM.u Wbar[mu] )                         )+
                (-ME[mu,nu] (  I cbar.(Ga[rho].covdelU[c, rho]) -1/2 del[I cbar.Ga[rho].c, rho] 
                             + I sbar.(Ga[rho].covdelD[s, rho]) -1/2 del[I sbar.Ga[rho].s, rho] 
                             + ee/sw/Sqrt[2] (  Cos[cabi] cbar.Ga[rho].ProjM.s W[rho] 
                                              - Sin[cabi] cbar.Ga[rho].ProjM.d W[rho] 
                                              + Cos[cabi] sbar.Ga[rho].ProjM.c Wbar[rho] 
                                              - Sin[cabi] dbar.Ga[rho].ProjM.c Wbar[rho] )           )
                 +(  I/2 cbar.Ga[mu].covdelU[c, nu] - 1/4 I del[cbar.Ga[nu].c, mu] 
                   + I/2 cbar.Ga[nu].covdelU[c, mu] - 1/4 I del[cbar.Ga[mu].c, nu]                   
                   + I/2 sbar.Ga[mu].covdelD[s, nu] - 1/4 I del[sbar.Ga[nu].s, mu] 
                   + I/2 sbar.Ga[nu].covdelD[s, mu] - 1/4 I del[sbar.Ga[mu].s, nu] )
                 +ee/sw/2/Sqrt[2] (  Cos[cabi] cbar.Ga[mu].ProjM.s W[nu] 
                                   + Cos[cabi] cbar.Ga[nu].ProjM.s W[mu]
                                   - Sin[cabi] cbar.Ga[mu].ProjM.d W[nu] 
                                   - Sin[cabi] cbar.Ga[nu].ProjM.d W[mu]
                                   + Cos[cabi] sbar.Ga[mu].ProjM.c Wbar[nu] 
                                   + Cos[cabi] sbar.Ga[nu].ProjM.c Wbar[mu] 
                                   - Sin[cabi] dbar.Ga[mu].ProjM.c Wbar[nu] 
                                   - Sin[cabi] dbar.Ga[nu].ProjM.c Wbar[mu] )                         );

TFq3[mu_,nu_] := (-ME[mu,nu] (  I tbar.(Ga[rho].covdelU[t, rho]) -1/2 del[I tbar.Ga[rho].t, rho] 
                              + I bbar.(Ga[rho].covdelD[b, rho]) -1/2 del[I bbar.Ga[rho].b, rho] 
                              + ee/sw/Sqrt[2] (  tbar.Ga[rho].ProjM.b W[rho] 
                                               + bbar.Ga[rho].ProjM.t Wbar[rho])           )
                 +(  I/2 tbar.Ga[mu].covdelU[t, nu] - 1/4 I del[tbar.Ga[nu].t, mu] 
                   + I/2 tbar.Ga[nu].covdelU[t, mu] - 1/4 I del[tbar.Ga[mu].t, nu]                   
                   + I/2 bbar.Ga[mu].covdelD[b, nu] - 1/4 I del[bbar.Ga[nu].b, mu] 
                   + I/2 bbar.Ga[nu].covdelD[b, mu] - 1/4 I del[bbar.Ga[mu].b, nu] )
                 +ee/sw/2/Sqrt[2] (  tbar.Ga[mu].ProjM.b W[nu] 
                                   + tbar.Ga[nu].ProjM.b W[mu]
                                   + bbar.Ga[mu].ProjM.t Wbar[nu] 
                                   + bbar.Ga[nu].ProjM.t Wbar[mu] )                         );

TFl[mu_,nu_] := (-ME[mu,nu] (  I vlbar.(Ga[rho].ProjM.covdelN[vl, rho]) -1/2 del[I vlbar.Ga[rho].ProjM.vl, rho]
                             + I  lbar.(Ga[rho].covdelE[l, rho])  -1/2 del[I lbar.Ga[rho].l, rho]
                             + ee/sw/Sqrt[2] (  vlbar.Ga[rho].ProjM.l W[rho] 
                                              + lbar.Ga[rho].ProjM.vl Wbar[rho]) )
                 +(  I/2 vlbar.Ga[mu].ProjM.covdelN[vl, nu] - 1/4 I del[vlbar.Ga[nu].ProjM.vl, mu] 
                   + I/2 vlbar.Ga[nu].ProjM.covdelN[vl, mu] - 1/4 I del[vlbar.Ga[mu].ProjM.vl, nu]                    
                   + I/2  lbar.Ga[mu].covdelE[l, nu]  - 1/4 I del[lbar.Ga[nu].l, mu] 
                   + I/2  lbar.Ga[nu].covdelE[l, mu]  - 1/4 I del[lbar.Ga[mu].l, nu]  )
                 +ee/sw/2/Sqrt[2] (  vlbar.Ga[mu].ProjM.l W[nu] 
                                   +  lbar.Ga[mu].ProjM.vl Wbar[nu] 
                                   + vlbar.Ga[nu].ProjM.l W[mu] 
                                   +  lbar.Ga[nu].ProjM.vl Wbar[mu] )                                 );

(* Yukawa *)

TYq[mu_,nu_] := -ME[mu,nu] ( - MT tbar.t - MB bbar.b ); 
TYl[mu_,nu_] := -ME[mu,nu] ( - MTA tabar.ta ); 

(* Gauge bosons *)

TGg[mu_,nu_] := -ME[mu,nu] (-1/4 FS[G,rho,sig,a] FS[G,rho,sig,a]) - FS[G,mu,rho,a] FS[G,nu,rho,a];
TGa[mu_,nu_] := -ME[mu,nu] (-1/4 FS[A,rho,sig] FS[A,rho,sig]) - FS[A,mu,rho] FS[A,nu,rho];
TGz[mu_,nu_] := -ME[mu,nu] (-1/4 FS[Z,rho,sig] FS[Z,rho,sig] + 1/2 MZ^2 Z[rho] Z[rho]) - 
                 (FS[Z,mu,rho] FS[Z,nu,rho] - MZ^2 Z[mu] Z[nu]);
TGw[mu_,nu_] := -ME[mu,nu] (-1/2 FS[Wbar,rho,sig] FS[W,rho,sig] + MW^2 Wbar[rho] W[rho]) - 
                 (FS[Wbar,mu,rho] FS[W,nu,rho] - MW^2 Wbar[mu] W[nu] + FS[Wbar,nu,rho] FS[W,mu,rho] - MW^2 Wbar[nu] W[mu]);
TGza[mu_,nu_] := -ME[mu,nu] (-1/2 FS[Z,rho,sig] FS[A,rho,sig]) - 
                 (FS[Z,mu,rho] FS[A,nu,rho] + FS[Z,nu,rho] FS[A,mu,rho]);

(* Gauge fixing term is here because Madgraph takes the Feynman gauge for massless gauge boson propagators *)
(* and unitary gauge for massive gauge boson propagators. *)

TGFg[mu_,nu_]:= -ME[mu,nu].( del[del[G[sig, a1], sig], rho].G[rho, a1] +
      		             1/2 del[G[rho, a1], rho].del[G[sig, a1], sig] ) +
      	         del[del[G[rho, a1], rho], mu].G[nu, a1] + del[del[G[rho, a1], rho], nu].G[mu, a1];

TGFa[mu_,nu_]:= -ME[mu,nu].( del[del[A[sig], sig], rho].A[rho] +
      		             1/2 del[A[rho], rho].del[A[sig], sig] ) + 
      	         del[del[A[rho], rho], mu].A[nu] + del[del[A[rho], rho], nu].A[mu];

(*** Writing the lagrangian ***)

L2f := -1/Lambda ( kq TFq[mu,nu] + kq3 (TFq3[mu,nu]+TYq[mu,nu]) + kl (TFl[mu,nu]+TYl[mu,nu]) ) X2[mu,nu];  
L2v := -1/Lambda ( kg (TGg[mu,nu]+TGFg[mu,nu]) + 
                   ka (TGa[mu,nu]+TGFa[mu,nu]) +
                   kz TGz[mu,nu] +
                   kw TGw[mu,nu] +
                   kza TGza[mu,nu]               ) X2[mu,nu]; 

L2 := L2f + L2v;

(*****************************************************************************************)

LagHC:= LSM + L0v + L1 + L2 + L0v6;
