(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9033,        270]
NotebookOptionsPosition[      7418,        212]
NotebookOutlinePosition[      7797,        229]
CellTagsIndexPosition[      7754,        226]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.509778970782555*^9, 3.509778973939178*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{"SetDirectory", "[", "\"\<< address of the package>\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.413720861194676*^9, 3.4137208893794117`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.402202361365851*^9, 3.402202371944139*^9}, {
   3.402202561319804*^9, 3.402202569273497*^9}, 3.402745522459828*^9, 
   3.402746608214861*^9, {3.402747929860508*^9, 3.402747943827011*^9}, {
   3.403533007403466*^9, 3.403533008807395*^9}, {3.404106695164184*^9, 
   3.404106695449581*^9}, {3.405053642054455*^9, 3.4050536456262903`*^9}, 
   3.4119181919913683`*^9, {3.4137208986527243`*^9, 3.4137208996123943`*^9}, {
   3.4137242759980097`*^9, 3.413724294268169*^9}, 3.508569204008209*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\" - FeynRules - \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5097790803920813`*^9, 3.509779124183002*^9}],

Cell[BoxData[
 FormBox["\<\"Authors: C. Duhr, N. Christensen, B. Fuks\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.5097790803920813`*^9, 3.509779124189536*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5097790803920813`*^9, 3.50977912419641*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5097790803920813`*^9, 3.50977912420424*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.5097790803920813`*^9, 3.509779124212921*^9}],

Cell[BoxData[
 FormBox["\<\" \"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5097790803920813`*^9, 3.509779124216967*^9}],

Cell[BoxData[
 FormBox["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.5097790803920813`*^9, 3.509779124221074*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Hidden Abelian Higgs model", "Title",
 CellChangeTimes->{{3.411915778286763*^9, 3.4119157817267313`*^9}, {
  3.413720856398858*^9, 3.413720856723679*^9}, {3.509778928631168*^9, 
  3.509778939699687*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "$FeynRulesPath", "<>", 
   "\"\</../models/Hidden_Abelian_Higgs_Model/Hidden.fr\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.403533015351287*^9, {3.40505363437746*^9, 
   3.40505363645761*^9}, {3.411912382149088*^9, 3.4119123969228477`*^9}, {
   3.50856924516405*^9, 3.5085692957646017`*^9}, {3.50977894668571*^9, 
   3.5097789504842176`*^9}, {3.5097790957627983`*^9, 3.509779118203261*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153251739*^9}],

Cell[BoxData[
 FormBox["\<\"C. Duhr\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153254369*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
   SequenceForm["Model Version: ", "1.0"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153257538*^9}],

Cell[BoxData[
 FormBox["\<\"Please cite\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153260545*^9}],

Cell[BoxData[
 FormBox["\<\"  J. D. Wells, \\\"How to Find a Hidden World at the Large \
Hadron Collider,\\\", [arXiv:0803.1243 [hep-ph]]\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153263336*^9}],

Cell[BoxData[
 FormBox["\<\"http://feynrules.phys.ucl.ac.be/view/Main/\
HiddenAbelianHiggsModel\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153268167*^9}],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153271535*^9}],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153274775*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.509779084311322*^9, 3.509779153278908*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153418405*^9}],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{3.509779084311322*^9, 3.5097791534467287`*^9}],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", 
    "\[InvisibleSpace]", "\<\"Abelian_Higgs_Model\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm["\nModel ", "Abelian_Higgs_Model", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{3.509779084311322*^9, 3.509779153546349*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.411915790793332*^9, 3.411915793199389*^9}}],

Cell[BoxData["LHAHM"], "Input",
 CellChangeTimes->{{3.4119143176932583`*^9, 3.411914319401045*^9}, {
  3.509778966781176*^9, 3.509778967770995*^9}, {3.509779355012743*^9, 
  3.509779370460802*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules", "Section",
 CellChangeTimes->{{3.411915866249317*^9, 3.4119158716988153`*^9}, 
   3.509779363849759*^9}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915928653887*^9}, {
   3.4137211614912577`*^9, 3.4137211708030777`*^9}, 3.508569350492257*^9, {
   3.509779361403779*^9, 3.509779374162471*^9}}],

Cell["Or in a flavor expanded form", "Text",
 CellChangeTimes->{{3.411915937803143*^9, 3.4119159434558887`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LHAHM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915958983838*^9}, {
   3.508569657623721*^9, 3.508569668869379*^9}, {3.5097793668671083`*^9, 
   3.509779379186967*^9}, 3.5136893169327602`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1272, 681},
WindowMargins->{{68, Automatic}, {Automatic, 23}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 118, 2, 46, "Input"],
Cell[666, 24, 233, 5, 46, "Input"],
Cell[CellGroupData[{
Cell[924, 33, 626, 10, 107, "Input"],
Cell[CellGroupData[{
Cell[1575, 47, 143, 2, 35, "Print"],
Cell[1721, 51, 172, 3, 35, "Print"],
Cell[1896, 56, 128, 2, 35, "Print"],
Cell[2027, 60, 198, 3, 35, "Print"],
Cell[2228, 65, 161, 3, 35, "Print"],
Cell[2392, 70, 129, 2, 35, "Print"],
Cell[2524, 74, 196, 3, 35, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2769, 83, 213, 3, 126, "Title"],
Cell[CellGroupData[{
Cell[3007, 90, 818, 14, 46, "Input"],
Cell[CellGroupData[{
Cell[3850, 108, 169, 3, 35, "Print"],
Cell[4022, 113, 133, 2, 35, "Print"],
Cell[4158, 117, 276, 6, 35, "Print"],
Cell[4437, 125, 137, 2, 35, "Print"],
Cell[4577, 129, 238, 4, 35, "Print"],
Cell[4818, 135, 193, 3, 35, "Print"],
Cell[5014, 140, 175, 3, 35, "Print"],
Cell[5192, 145, 126, 2, 35, "Print"],
Cell[5321, 149, 158, 3, 35, "Print"],
Cell[5482, 154, 162, 3, 35, "Print"],
Cell[5647, 159, 161, 3, 35, "Print"],
Cell[5811, 164, 358, 8, 65, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6218, 178, 99, 1, 108, "Section"],
Cell[6320, 181, 197, 3, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6554, 189, 126, 2, 108, "Section"],
Cell[6683, 193, 261, 4, 46, "Input"],
Cell[6947, 199, 112, 1, 44, "Text"],
Cell[7062, 202, 328, 6, 46, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
