# This file was automatically created by FeynRules 2.3.32
# Mathematica version: 10.4.1 for Mac OS X x86 (64-bit) (April 17, 2016)
# Date: Sat 7 Mar 2020 10:46:17



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
cabi = Parameter(name = 'cabi',
                 nature = 'external',
                 type = 'real',
                 value = 0.227736,
                 texname = '\\theta _c',
                 lhablock = 'CKMBLOCK',
                 lhacode = [ 1 ])

rhoH = Parameter(name = 'rhoH',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = '\\rho _H',
                 lhablock = 'DIM6COEFF',
                 lhacode = [ 1 ])

Lambda = Parameter(name = 'Lambda',
                   nature = 'external',
                   type = 'real',
                   value = 3000.,
                   texname = '\\lambda',
                   lhablock = 'DIM6COEFF',
                   lhacode = [ 2 ])

fW = Parameter(name = 'fW',
               nature = 'external',
               type = 'real',
               value = 1.3,
               texname = 'f_W',
               lhablock = 'DIM6COEFF',
               lhacode = [ 3 ])

fWW = Parameter(name = 'fWW',
                nature = 'external',
                type = 'real',
                value = 1.4,
                texname = 'f_{\\text{WW}}',
                lhablock = 'DIM6COEFF',
                lhacode = [ 4 ])

fB = Parameter(name = 'fB',
               nature = 'external',
               type = 'real',
               value = 1.5,
               texname = 'f_B',
               lhablock = 'DIM6COEFF',
               lhacode = [ 5 ])

fBB = Parameter(name = 'fBB',
                nature = 'external',
                type = 'real',
                value = 1.6,
                texname = 'f_{\\text{BB}}',
                lhablock = 'DIM6COEFF',
                lhacode = [ 6 ])

Q4 = Parameter(name = 'Q4',
               nature = 'external',
               type = 'real',
               value = 1.,
               texname = 'Q_4',
               lhablock = 'DIM6COEFF',
               lhacode = [ 7 ])

AMPAA = Parameter(name = 'AMPAA',
                  nature = 'external',
                  type = 'real',
                  value = 6.488649362846305,
                  texname = 'A_{\\text{aa}}',
                  lhablock = 'DIM6COEFF',
                  lhacode = [ 8 ])

AMPZA = Parameter(name = 'AMPZA',
                  nature = 'external',
                  type = 'real',
                  value = -11.650973793096698,
                  texname = 'A_{\\text{Za}}',
                  lhablock = 'DIM6COEFF',
                  lhacode = [ 9 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymb = Parameter(name = 'ymb',
                nature = 'external',
                type = 'real',
                value = 4.7,
                texname = '\\text{ymb}',
                lhablock = 'YUKAWA',
                lhacode = [ 5 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MB = Parameter(name = 'MB',
               nature = 'external',
               type = 'real',
               value = 4.7,
               texname = '\\text{MB}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

MHH = Parameter(name = 'MHH',
                nature = 'external',
                type = 'real',
                value = 500.,
                texname = '\\text{MHH}',
                lhablock = 'MASS',
                lhacode = [ 254 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00407,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

WHH = Parameter(name = 'WHH',
                nature = 'external',
                type = 'real',
                value = 0.00407,
                texname = '\\text{WHH}',
                lhablock = 'DECAY',
                lhacode = [ 254 ])

CKM1x1 = Parameter(name = 'CKM1x1',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.cos(cabi)',
                   texname = '\\text{CKM1x1}')

CKM1x2 = Parameter(name = 'CKM1x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.sin(cabi)',
                   texname = '\\text{CKM1x2}')

CKM2x1 = Parameter(name = 'CKM2x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '-cmath.sin(cabi)',
                   texname = '\\text{CKM2x1}')

CKM2x2 = Parameter(name = 'CKM2x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'cmath.cos(cabi)',
                   texname = '\\text{CKM2x2}')

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

cw2 = Parameter(name = 'cw2',
                nature = 'internal',
                type = 'real',
                value = 'MW**2/MZ**2',
                texname = '\\text{cw2}')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(2*MW*sw)/ee',
                texname = '\\text{vev}')

gHAA = Parameter(name = 'gHAA',
                 nature = 'internal',
                 type = 'real',
                 value = '-((fBB + fWW)*gw*MW*sw2)/(2.*Lambda**2)',
                 texname = 'f_{\\text{HAA}}')

gHLAA = Parameter(name = 'gHLAA',
                  nature = 'internal',
                  type = 'real',
                  value = '-(aEW*AMPAA)/(8.*cmath.pi*vev)',
                  texname = 'f_{\\text{HLAA}}')

gHLZA = Parameter(name = 'gHLZA',
                  nature = 'internal',
                  type = 'real',
                  value = '-(aEW*AMPZA)/(4.*cmath.pi*vev)',
                  texname = 'f_{\\text{HLZA}}')

gHWW = Parameter(name = 'gHWW',
                 nature = 'internal',
                 type = 'real',
                 value = 'gw*MW*Q4*rhoH',
                 texname = 'f_{\\text{HWW}}')

gHWW1 = Parameter(name = 'gHWW1',
                  nature = 'internal',
                  type = 'real',
                  value = '(fW*gw*MW)/(2.*Lambda**2)',
                  texname = 'f_{\\text{HWW1}}')

gHWW2 = Parameter(name = 'gHWW2',
                  nature = 'internal',
                  type = 'real',
                  value = '-((fWW*gw*MW)/Lambda**2)',
                  texname = 'f_{\\text{HWW2}}')

gHZA1 = Parameter(name = 'gHZA1',
                  nature = 'internal',
                  type = 'real',
                  value = '((-fB + fW)*gw*MW*sw)/(2.*cw*Lambda**2)',
                  texname = 'f_{\\text{HZA1}}')

gHZA2 = Parameter(name = 'gHZA2',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*MW*sw*(-(cw2*fWW) + fBB*sw2))/(cw*Lambda**2)',
                  texname = 'f_{\\text{HZA2}}')

gHZZ = Parameter(name = 'gHZZ',
                 nature = 'internal',
                 type = 'real',
                 value = '(gw*MW*Q4*rhoH)/(2.*cw**2)',
                 texname = 'f_{\\text{HZZ}}')

gHZZ1 = Parameter(name = 'gHZZ1',
                  nature = 'internal',
                  type = 'real',
                  value = '(gw*MW*(cw**2*fW + fB*sw**2))/(2.*cw**2*Lambda**2)',
                  texname = 'f_{\\text{HZZ1}}')

gHZZ2 = Parameter(name = 'gHZZ2',
                  nature = 'internal',
                  type = 'real',
                  value = '-(gw*MW*(cw**4*fWW + fBB*sw**4))/(2.*cw**2*Lambda**2)',
                  texname = 'f_{\\text{HZZ2}}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

yb = Parameter(name = 'yb',
               nature = 'internal',
               type = 'real',
               value = '(ymb*cmath.sqrt(2))/vev',
               texname = '\\text{yb}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/vev',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = '(ymtau*cmath.sqrt(2))/vev',
                 texname = '\\text{ytau}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*vev**2)',
                texname = '\\mu')

I1a33 = Parameter(name = 'I1a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yb',
                  texname = '\\text{I1a33}')

I2a33 = Parameter(name = 'I2a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yt',
                  texname = '\\text{I2a33}')

I3a33 = Parameter(name = 'I3a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yt',
                  texname = '\\text{I3a33}')

I4a33 = Parameter(name = 'I4a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yb',
                  texname = '\\text{I4a33}')

