(* ********************************************************************************* *)
(* FeynRules Model file for a Type I Seesaw extension of the Standard Model.	     *)
(* Contains three massive Majorana neutrinos that couples to all SM leptons through  *)
(* mixing between the active (flavor) eigenstates and mass eigenstates.		     *)
(*										     *)
(* Author: R. Ruiz [richard.ruiz@durham.ac.uk]					     *)
(*										     *)
(* The Lagrangian, based on Atre, et. al. [arXiv:0901.3589], was implemented in      *)
(* Alva, et. al. [arXiv:1411.7305]. It is an extension of default FeynRules 	     *)
(* SM model file. Please cite accordingly.					     *)
(*										     *)
(* Neutrino mass (mN) and mixing parameters (VlN) between heavy mass eigenstate and  *)
(* flavor eigenstates are taken to be independent, phenomenological parameters.      *)
(* Mixing parameters (VeN, VmuN, VtaN) are taken to be real (no CP Violation).       *)
(* This allows for maximum flexibility and model indpendence when calculating rates. *) 
(*										     *) 
(* Feynman gauge is set to false and unitary gauge is assumed for MG5 and Sherpa.    *)
(* ********************************************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "Seesaw_TypeI";

M$Information = {
  Authors      -> {"R. Ruiz"},
  Version      -> "1.1",
  Date         -> "November 20, 2015",
  Institutions -> {"IPPP / University of Durham"},
  Emails       -> {"richard.ruiz@durham.ac.uk"},
  References   -> {"Atre, et al, JHEP0905, 030 (2009) [arXiv:0901.3589]",
		   "Alva, et al, JHEP1502, 072 (2015) [arXiv:1411.7305]"
	          },
  URLs         -> {"https://feynrules.irmp.ucl.ac.be/wiki/typeIseesaw"}
};
FeynmanGauge = False;


(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)
(* v1.1: Prepare for publication of model file*)


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
	(* External Parameters *)

	VeN1 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 1, 
    	Value            -> 1.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,eN1],
    	Description      -> "Mixing between ve flavor/gauge state and N1 mass state"
	},

	VeN2 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 2, 
    	Value            -> 0.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,eN2],
    	Description      -> "Mixing between ve flavor/gauge state and N2 mass state"
	},

	VeN3 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 3, 
    	Value            -> 0.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,eN3],
    	Description      -> "Mixing between ve flavor/gauge state and N3 mass state"
	},

	VmuN1 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 4, 
    	Value            -> 0.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,muN1],
    	Description      -> "Mixing between vm flavor/gauge state and N1 mass state"
	},

	VmuN2 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 5, 
    	Value            -> 1.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,muN2],
    	Description      -> "Mixing between vm flavor/gauge state and N2 mass state"
	},

	VmuN3 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 6, 
    	Value            -> 0.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,muN3],
    	Description      -> "Mixing between vm flavor/gauge state and N3 mass state"
	},

	VtaN1 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 7, 
    	Value            -> 0.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,taN1],
    	Description      -> "Mixing between vt flavor/gauge state and N1 mass state"
	},

	VtaN2 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 8, 
    	Value            -> 0.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,taN2],
    	Description      -> "Mixing between vt flavor/gauge state and N2 mass state"
	},

	VtaN3 == {
    	ParameterType    -> External, 
	BlockName        -> NUMIXING, 
    	OrderBlock       -> 9, 
    	Value            -> 1.0,
	ComplexParameter -> False,
	TeX              -> Subscript[V,taN3],
    	Description      -> "Mixing between vt flavor/gauge state and N3 mass state"
	},

	(* Internal Parameters *)
	gN   == {
		ParameterType	 -> Internal,
		Definitions      -> {gN->ee/sw},
		InteractionOrder -> {NP,1},
		TeX		 -> Subscript[g,N]}
};

M$InteractionOrderHierarchy = {
	{QCD,1},
	{NP,1},
	{QED,2}
};

(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {
	(*Majorana Neutrino*)
	F[131] == {
		ClassName	-> N1,
		SelfConjugate	-> True,
		Mass		-> {mN1,300.},
		Width		-> {WN1,0.303},	
		PropagatorLabel	-> "N1",
		PropagatorType  -> Straight,
		PropagatorArrow -> False,
		ParticleName    -> "N1",
		PDG             -> {9900012},
		FullName        -> "N1"},

	F[132] == {
		ClassName	-> N2,
		SelfConjugate	-> True,
		Mass		-> {mN2,500.},
		Width		-> {WN2,1.50},	
		PropagatorLabel	-> "N2",
		PropagatorType  -> Straight,
		PropagatorArrow -> False,
		ParticleName    -> "N2",
		PDG             -> {9900014},
		FullName        -> "N2"},

	F[133] == {
		ClassName	-> N3,
		SelfConjugate	-> True,
		Mass		-> {mN3,1000.},
		Width		-> {WN3,12.3},	
		PropagatorLabel	-> "N3",
		PropagatorType  -> Straight,
		PropagatorArrow -> False,
		ParticleName    -> "N3",
		PDG             -> {9900016},
		FullName        -> "N3"}
};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
LNKin :=   I/2 N1bar[s1].Ga[v,s1,s2].del[N1[s2],v] - 1/2 mN1 N1bar[s1]N1[s1] \
	+  I/2 N2bar[s1].Ga[v,s1,s2].del[N2[s2],v] - 1/2 mN2 N2bar[s1]N2[s1] \
	+  I/2 N3bar[s1].Ga[v,s1,s2].del[N3[s2],v] - 1/2 mN3 N3bar[s1]N3[s1];

(* Charge Current *)
LNCCbare := - gN/Sqrt[2] *(  VeN1 * N1bar.W[m].ProjM[m].e	\
           	 	  + VmuN1 * N1bar.W[m].ProjM[m].mu	\
			  + VtaN1 * N1bar.W[m].ProjM[m].ta )	\
	    - gN/Sqrt[2] *(  VeN2 * N2bar.W[m].ProjM[m].e	\
           	 	  + VmuN2 * N2bar.W[m].ProjM[m].mu	\
			  + VtaN2 * N2bar.W[m].ProjM[m].ta )	\
	    - gN/Sqrt[2] *(  VeN3 * N3bar.W[m].ProjM[m].e	\
           	 	  + VmuN3 * N3bar.W[m].ProjM[m].mu	\
			  + VtaN3 * N3bar.W[m].ProjM[m].ta );
LNCC := LNCCbare + HC[LNCCbare];

(* Neutral Current *)
LNNCBare := - 1/2 * gN/cw *(  VeN1 * N1bar.Z[m].ProjM[m].ve	\
           	  	   + VmuN1 * N1bar.Z[m].ProjM[m].vm	\
           		   + VtaN1 * N1bar.Z[m].ProjM[m].vt )	\
	    - 1/2 * gN/cw *(  VeN2 * N2bar.Z[m].ProjM[m].ve	\
           	  	   + VmuN2 * N2bar.Z[m].ProjM[m].vm	\
           		   + VtaN2 * N2bar.Z[m].ProjM[m].vt )	\
	    - 1/2 * gN/cw *(  VeN3 * N3bar.Z[m].ProjM[m].ve	\
           	  	   + VmuN3 * N3bar.Z[m].ProjM[m].vm	\
           		   + VtaN3 * N3bar.Z[m].ProjM[m].vt );
LNNC := LNNCBare + HC[LNNCBare];

(* Yukawa Interaction *)
LNYukawabare := - gN*mN1/(2*MW) *( VeN1 * N1bar.ProjM.ve H	\
				+ VmuN1 * N1bar.ProjM.vm H	\
				+ VtaN1 * N1bar.ProjM.vt H )	\
		- gN*mN2/(2*MW) *( VeN2 * N2bar.ProjM.ve H	\
				+ VmuN2 * N2bar.ProjM.vm H	\
				+ VtaN2 * N2bar.ProjM.vt H )	\
		- gN*mN3/(2*MW) *( VeN3 * N3bar.ProjM.ve H	\
				+ VmuN3 * N3bar.ProjM.vm H	\
				+ VtaN3 * N3bar.ProjM.vt H );
LNYukawa := LNYukawabare + HC[LNYukawabare];

(* Full Lagrangian *)
LN:= LNKin + LNCC + LNNC + LNYukawa;