(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7586,        217]
NotebookOptionsPosition[      6428,        175]
NotebookOutlinePosition[      6866,        192]
CellTagsIndexPosition[      6823,        189]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["FeynRules Setup", "Title",
 CellChangeTimes->{{3.596207285657744*^9, 3.596207286276866*^9}, {
  3.596207330352247*^9, 3.59620733250506*^9}, {3.655035967648223*^9, 
  3.65503597269068*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Scripts/FeynRules/feynrules-2.0.x\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.572102427116931*^9, 3.572102456206238*^9}, {
   3.572280529035656*^9, 3.572280529468644*^9}, {3.572366766720894*^9, 
   3.572366773370627*^9}, {3.596207212826934*^9, 3.5962072447909603`*^9}, {
   3.596914045279478*^9, 3.5969140472383204`*^9}, 3.596914102616413*^9, 
   3.596915921742405*^9, {3.596915961175353*^9, 3.59691596259039*^9}, {
   3.60744636894991*^9, 3.607446377507101*^9}, {3.6364757082312813`*^9, 
   3.636475708315627*^9}, {3.655035981353272*^9, 3.655035982244761*^9}, {
   3.6550360677717857`*^9, 3.655036081259776*^9}, {3.655036117419112*^9, 
   3.655036143336364*^9}, {3.655037954145546*^9, 3.6550379644813023`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Must", " ", "load", " ", "default", " ", "SM", " ", "file", " ", "with", 
   " ", "Heavy", " ", "N", " ", 
   RowBox[{"extension", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550381551475554`*^9, 3.655038155711425*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<sm.fr\>\"", ",", "\"\<heavyN.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.6550379628078337`*^9, 3.6550379664979897`*^9}}],

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell["New Lagrangian Terms", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.572348235565138*^9, 3.572348241872657*^9}}],

Cell[BoxData[{"LNKin", "\[IndentingNewLine]", "LNCC", "\[IndentingNewLine]", \
"LNNC", "\[IndentingNewLine]", "LNYukawa"}], "Input",
 CellChangeTimes->{{3.5723482442775097`*^9, 3.572348252612296*^9}, {
  3.596212546796714*^9, 3.596212547440735*^9}, {3.655037865036394*^9, 
  3.6550378653420067`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sanity Checks for New Lagrangian Terms", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.655037883884348*^9, 3.655037906883815*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LN", "]"}]], "Input",
 CellChangeTimes->{3.607446407230465*^9}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LN", "]"}]], "Input",
 CellChangeTimes->{{3.607446409988699*^9, 3.6074464110954323`*^9}, 
   3.6550378392495413`*^9}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", "LN", "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
   3.572348320182221*^9, 3.572348326613598*^9}, {3.572358912362153*^9, 
   3.572358917148378*^9}, {3.596207478919518*^9, 3.596207486580676*^9}, {
   3.596212578276376*^9, 3.5962125890639143`*^9}, 3.607446414234477*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
New Feynman Rules for Heavy N Interactions\
\>", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}, {
  3.655037529059973*^9, 3.655037541428491*^9}, {3.6550379116719217`*^9, 
  3.655037913954034*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"QN\", \"MessageName\"]\)\!\(\*
StyleBox[\"::\", \"MessageName\"]\)\!\(\*
StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as Lepton Number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550374096249533`*^9, 3.655037447663039*^9}, 
   3.655037551040966*^9, {3.656940976048616*^9, 3.6569409786068287`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LN", "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO Output", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"QN\", \"MessageName\"]\)\!\(\*
StyleBox[\"::\", \"MessageName\"]\)\!\(\*
StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as Lepton Number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.656940935403554*^9, 3.656940952617087*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
    ",", "LN"}], "]"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1196, 628},
WindowMargins->{{192, Automatic}, {Automatic, 64}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 194, 3, 93, "Title"],
Cell[764, 27, 1239, 22, 99, "Input"],
Cell[2006, 51, 269, 6, 32, "Input"],
Cell[2278, 59, 183, 3, 32, "Input"],
Cell[2464, 64, 135, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[2624, 71, 351, 5, 81, "Section"],
Cell[2978, 78, 148, 3, 32, "Input"],
Cell[3129, 83, 300, 4, 99, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3466, 92, 174, 2, 81, "Section"],
Cell[3643, 96, 112, 2, 32, "Input"],
Cell[3758, 100, 167, 3, 32, "Input"],
Cell[3928, 105, 371, 5, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4336, 115, 234, 5, 81, "Section"],
Cell[4573, 122, 720, 15, 77, "Input"],
Cell[5296, 139, 66, 1, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5399, 145, 169, 3, 81, "Section"],
Cell[5571, 150, 644, 14, 77, "Input"],
Cell[6218, 166, 182, 5, 32, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
