(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17418,        461]
NotebookOptionsPosition[     15670,        402]
NotebookOutlinePosition[     16108,        419]
CellTagsIndexPosition[     16065,        416]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"R", ".", " ", "Ruiz"}], ";", " ", 
   RowBox[{"2016", " ", "February", " ", "22"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.665142881510211*^9, 3.665142884049021*^9}, {
  3.665142942303646*^9, 3.6651429529879627`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "LO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "UFO"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "NLO", " ", 
     RowBox[{"UFO", ":", " ", 
      RowBox[{"Set", " ", "paths"}]}]}], ",", " ", 
    RowBox[{"load", " ", "model"}], ",", " ", 
    RowBox[{
     RowBox[{"extract", " ", "on"}], "-", 
     RowBox[{"shell", " ", "renormalization", " ", "terms"}]}], ",", " ", 
    RowBox[{"write", " ", "CT", " ", "terms"}], ",", " ", 
    RowBox[{"reset", " ", "paths"}], ",", " ", 
    RowBox[{"reload", " ", "model"}], ",", " ", 
    RowBox[{"write", " ", "everything", " ", "to", " ", 
     RowBox[{"file", "."}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.6648662671878157`*^9, 3.664866418502534*^9}, {
  3.664866852892112*^9, 3.664866879416404*^9}, {3.665143767149495*^9, 
  3.665143792033722*^9}}],

Cell[CellGroupData[{

Cell["FeynRules Setup", "Title",
 CellChangeTimes->{{3.596207285657744*^9, 3.596207286276866*^9}, {
  3.596207330352247*^9, 3.59620733250506*^9}, {3.655035967648223*^9, 
  3.65503597269068*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/.../FeynRules/feynrules-2_x\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.572102427116931*^9, 3.572102456206238*^9}, {
   3.572280529035656*^9, 3.572280529468644*^9}, {3.572366766720894*^9, 
   3.572366773370627*^9}, {3.596207212826934*^9, 3.5962072447909603`*^9}, {
   3.596914045279478*^9, 3.5969140472383204`*^9}, 3.596914102616413*^9, 
   3.596915921742405*^9, {3.596915961175353*^9, 3.59691596259039*^9}, {
   3.60744636894991*^9, 3.607446377507101*^9}, {3.6364757082312813`*^9, 
   3.636475708315627*^9}, {3.655035981353272*^9, 3.655035982244761*^9}, {
   3.6550360677717857`*^9, 3.655036081259776*^9}, {3.655036117419112*^9, 
   3.655036143336364*^9}, {3.655037954145546*^9, 3.6550379644813023`*^9}, {
   3.6605209855658293`*^9, 3.6605209855964212`*^9}, {3.6605772969976788`*^9, 
   3.660577300733718*^9}, {3.6621928886588717`*^9, 3.662192889375732*^9}, {
   3.6628197402754908`*^9, 3.662819763199905*^9}, {3.665143345119231*^9, 
   3.6651433455872717`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Load", " ", "default", " ", "SM", " ", "file", " ", "v1", ".4", ".6", " ", 
   "with", " ", "Heavy", " ", "N", " ", 
   RowBox[{"extension", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550381551475554`*^9, 3.655038155711425*^9}, {
  3.6622141225281467`*^9, 3.662214139672209*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<heavyN.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6550379628078337`*^9, 3.6550379664979897`*^9}, 
   3.6605212599219637`*^9, {3.660521401196807*^9, 3.660521401690201*^9}, {
   3.6628198742702703`*^9, 3.6628198755313597`*^9}}],

Cell[CellGroupData[{

Cell["Sanity Checks for New Lagrangian Terms", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}, {
  3.655037883884348*^9, 3.655037906883815*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LN", "]"}]], "Input",
 CellChangeTimes->{3.607446407230465*^9}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LN", "]"}]], "Input",
 CellChangeTimes->{{3.607446409988699*^9, 3.6074464110954323`*^9}, 
   3.6550378392495413`*^9}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", "LN", "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
   3.572348320182221*^9, 3.572348326613598*^9}, {3.572358912362153*^9, 
   3.572358917148378*^9}, {3.596207478919518*^9, 3.596207486580676*^9}, {
   3.596212578276376*^9, 3.5962125890639143`*^9}, 3.607446414234477*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Feynman Rules for Heavy N Interactions", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}, {
  3.655037529059973*^9, 3.655037541428491*^9}, {3.6550379116719217`*^9, 
  3.655037913954034*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"QN\", \"MessageName\"]\)\!\(\*
StyleBox[\"::\", \"MessageName\"]\)\!\(\*
StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as Lepton Number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6550374096249533`*^9, 3.655037447663039*^9}, 
   3.655037551040966*^9, {3.656940976048616*^9, 3.6569409786068287`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LN", "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Leading Order UFO Files", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.665143581395817*^9, 
   3.665143583298698*^9}, {3.6651436255564423`*^9, 3.665143630296493*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"QN\", \"MessageName\"]\)\!\(\*
StyleBox[\"::\", \"MessageName\"]\)\!\(\*
StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as lepton number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.656940935403554*^9, 3.656940952617087*^9}, {
  3.6648662530247602`*^9, 3.664866256652151*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", ",", "LN"}], "]"}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Generate On-Shell Renormalization Terms\
\>", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199318805483*^9, 
   3.6621993287719097`*^9}, {3.662216149623213*^9, 3.662216170908692*^9}, {
   3.665143633489994*^9, 3.6651436348954*^9}, {3.665143731576172*^9, 
   3.665143737517515*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"The", " ", "following", " ", "warnings", " ", "will", " ", 
   RowBox[{"appear", ":", " ", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"QN\", \"MessageName\"]\)\!\(\*
StyleBox[\"::\", \"MessageName\"]\)\!\(\*
StyleBox[\"NonConserv\", \"MessageName\"]\): \>\"", "Warning"}], ":", " ", 
    RowBox[{
    "non", " ", "quantum", " ", "number", " ", "conserving", " ", "vertex", 
     " ", 
     RowBox[{"encountered", "!"}], 
     "\"\<;\nThis is expected as lepton number is violated and FeynRules \
checks for this.\>"}]}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LRen", " ", "=", " ", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "LN"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SetDirectory", "[", "\"\<~/.../FeynArts/FeynArts-3.8/Models\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"LRen", ",", 
    RowBox[{"GenericFile", "\[Rule]", "False"}], ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<HeavyN_FA\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.665143335987589*^9, 3.665143336405964*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Write Counter Terms to BSM.nlo File\
\>", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.59620768137986*^9, 3.596207684212212*^9}, {3.662199461128889*^9, 
   3.662199467953211*^9}, {3.662216541485611*^9, 3.662216544705964*^9}, {
   3.66514364290946*^9, 3.665143643886175*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.664866502336069*^9, 3.664866536918194*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/.../FeynArts/FeynArts-3.8\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/.../FeynRules/feynrules-2_x\>\"", "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6605244352671556`*^9, 3.660524496529204*^9}, {
   3.660524555733032*^9, 3.660524556119355*^9}, 3.660528429455056*^9, {
   3.6605286020387897`*^9, 3.660528602100609*^9}, {3.660530319063929*^9, 
   3.660530319160571*^9}, {3.660530366154963*^9, 3.66053037265125*^9}, {
   3.660567620251087*^9, 3.6605676243565598`*^9}, {3.660568912072307*^9, 
   3.660568912133321*^9}, {3.66056999189439*^9, 3.660569993076742*^9}, {
   3.660570552697504*^9, 3.660570554442918*^9}, {3.6605786705389338`*^9, 
   3.660578696714662*^9}, {3.660579471210005*^9, 3.660579471258161*^9}, {
   3.660579558812049*^9, 3.6605795588460417`*^9}, {3.6605809812710743`*^9, 
   3.660580981737924*^9}, {3.662198567340746*^9, 3.662198568029338*^9}, {
   3.664866430517086*^9, 3.664866431258605*^9}, {3.664866469872073*^9, 
   3.664866472738167*^9}, {3.665143306503736*^9, 3.665143310039995*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Note", ":", " ", 
    RowBox[{"Grab", " ", "some", " ", "coffee"}]}], ";", " ", 
   RowBox[{"this", " ", "will", " ", "take", " ", "a", " ", "few", " ", 
    RowBox[{"minutes", ".", " ", "Output"}], " ", "is", " ", "located", " ", 
    "in", " ", "FeynRules", " ", 
    RowBox[{"directory", "."}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.660583519626089*^9, 3.660583556727778*^9}}],

Cell[BoxData[
 RowBox[{"WriteCT", "[", 
  RowBox[{"\"\<HeavyN_FA/HeavyN_FA\>\"", ",", "\"\<Lorentz\>\"", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SM_HeavyN\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ZeroMom", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"aS", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"F", "[", "7", "]"}], ",", 
         RowBox[{"V", "[", "4", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"F", "[", "7", "]"}]}]}], "}"}]}], "}"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
   RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.660577675799324*^9, 3.6605777030824823`*^9}, {
   3.660580587703251*^9, 3.660580590446691*^9}, {3.660580749662204*^9, 
   3.6605807699669333`*^9}, {3.660580838061507*^9, 3.660580868074533*^9}, {
   3.660581534014558*^9, 3.660581534403365*^9}, {3.6605816019013977`*^9, 
   3.660581602442067*^9}, {3.660582264939988*^9, 3.660582265472268*^9}, {
   3.6605825450914*^9, 3.660582545457938*^9}, {3.660582582287341*^9, 
   3.66058260852942*^9}, 3.660583287010807*^9, {3.661385930903625*^9, 
   3.661385938127997*^9}, {3.662216217715084*^9, 3.6622162416021957`*^9}, {
   3.6622169226201477`*^9, 3.6622169231786327`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Load BSM.nlo and Write UFO at NLO in QCD File\
\>", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.572348211890565*^9, 3.572348234275403*^9}, {3.596207324453108*^9, 
  3.596207326711195*^9}, {3.655036212669145*^9, 3.6550362220422897`*^9}, {
  3.655036282693001*^9, 3.655036287060457*^9}, {3.655037866940884*^9, 
  3.6550378926486187`*^9}, {3.660583469669636*^9, 3.6605834886500196`*^9}, {
  3.66514366512071*^9, 3.665143674147705*^9}, {3.6651437527468567`*^9, 
  3.665143757274291*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"quit", " ", "kernel", " ", "before", " ", "continuing"}], " ", 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.660583502811754*^9, 3.6605835046945877`*^9}, 
   3.66212390294204*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CurrentPath", "=", 
   RowBox[{"Directory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/.../FeynRules/feynrules-2_x\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$CurrentPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6648666749712143`*^9, 3.664866676189664*^9}, {
  3.66514335220398*^9, 3.665143352534133*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<heavyN.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<diagonalCKM.rst\>\"", ",", "\"\<massless.rst\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]}], "Input",
 CellChangeTimes->{{3.662827026079749*^9, 3.662827026713024*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Get", "[", "\"\<~/.../FeynRules/feynrules-2_x/SM_HeavyN.nlo\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
    RowBox[{"LSM", "+", "LN"}], ",", 
    RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<SM_HeavyN_NLO\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.665143385404313*^9, 3.6651433858550034`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1330, 779},
WindowMargins->{{Automatic, -10}, {Automatic, -8}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 283, 6, 32, "Input"],
Cell[831, 28, 1097, 25, 99, "Input"],
Cell[CellGroupData[{
Cell[1953, 57, 194, 3, 92, "Title"],
Cell[2150, 62, 1489, 26, 99, "Input"],
Cell[3642, 90, 330, 7, 32, "Input"],
Cell[3975, 99, 572, 13, 77, "Input"],
Cell[CellGroupData[{
Cell[4572, 116, 174, 2, 80, "Section"],
Cell[4749, 120, 112, 2, 32, "Input"],
Cell[4864, 124, 167, 3, 32, "Input"],
Cell[5034, 129, 371, 5, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5442, 139, 226, 3, 80, "Section"],
Cell[5671, 144, 720, 15, 55, "Input"],
Cell[6394, 161, 66, 1, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6497, 167, 286, 4, 81, "Section"],
Cell[6786, 173, 695, 15, 55, "Input"],
Cell[7484, 190, 106, 3, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7627, 198, 402, 8, 80, "Section"],
Cell[8032, 208, 578, 13, 55, "Input"],
Cell[8613, 223, 812, 19, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9462, 247, 347, 7, 80, "Section"],
Cell[9812, 256, 195, 4, 32, "Input"],
Cell[10010, 262, 70, 2, 32, "Input"],
Cell[10083, 266, 1434, 25, 143, "Input"],
Cell[11520, 293, 438, 9, 32, "Input"],
Cell[11961, 304, 1304, 26, 77, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13302, 335, 531, 9, 80, "Section"],
Cell[13836, 346, 129, 3, 32, "Input"],
Cell[13968, 351, 163, 4, 32, "Input"],
Cell[14134, 357, 542, 13, 99, "Input"],
Cell[14679, 372, 440, 11, 77, "Input"],
Cell[15122, 385, 520, 13, 55, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
