import os
import sys

path = sys.argv[1]

# The directory Fortran is created 

os.mkdir(path + 'Fortran')

# The files lorentz.py, vertices.py and parameters.py are renamed as *_old.py to keep the originals 

vertices = path + 'vertices.py'
vertices_old = path + 'vertices_old.py'
lorentz = path + 'lorentz.py'
lorentz_old = path + 'lorentz_old.py'
parameters = path + 'parameters.py'
parameters_old = path + 'parameters_old.py'

os.rename(vertices, vertices_old)
os.rename(lorentz, lorentz_old)
os.rename(parameters, parameters_old)

###############################
###############################
###############################
###############################

# We modify the file vertices to include the functions FFSS1 to FFSS9

with open(vertices_old) as f:
		content = f.readlines()
content = [x.strip() for x in content] 

# We asign the Lorentz functions FFSS1, FFSS2, and FFSS3 to the semileptonic D -> K lepton neutrino

# We asign the Lorentz functions FFSS4, FFSS5, and FFSS6 to the semileptonic K -> Pi0 lepton neutrino

# We asign the Lorentz functions FFSS7, FFSS8, and FFSS9 to the semileptonic K0 -> Pi lepton neutrino

# We asign the Lorentz functions FFSS10, FFSS11, and FFSS12 to the semileptonic B -> Pi0 lepton neutrino

# We asign the Lorentz functions FFSS13, FFSS14, and FFSS15 to the semileptonic B0-> Pi lepton neutrino

# We asign the Lorentz functions FFSS16, FFSS17, and FFSS18 to the semileptonic B -> D0 lepton neutrino

# We asign the Lorentz functions FFSS19, FFSS20, and FFSS21 to the semileptonic B0 -> D lepton neutrino

# We asign the Lorentz functions FFSS22, FFSS23, and FFSS24 to the semileptonic Bs0 -> Ds lepton neutrino

# We asign the Lorentz functions FFSS25, FFSS26, and FFSS27 to the semileptonic Bs0 -> K lepton neutrino

subs1 = 'P.D__minus__, P.K0bar ]'
subs2 = 'P.D__plus__, P.K0 ]'
subs3 = 'P.D0bar, P.K__minus__ ]'
subs4 = 'P.D0, P.K__plus__ ]'
subs5 = 'P.K__minus__, P.Pi0 ]'
subs6 = 'P.K__plus__, P.Pi0 ]'
subs7 = 'P.K0bar, P.Pi__minus__ ]' 
subs8 = 'P.K0, P.Pi__plus__ ]'
subs9 = 'P.B__plus__, P.Pi0 ]'
subs10 = 'P.B__minus__, P.Pi0 ]'
subs11 = 'P.B0bar, P.Pi__minus__ ]' 
subs12 = 'P.B0, P.Pi__plus__ ]' 
subs13 = 'P.B__plus__, P.D0 ]'
subs14 = 'P.B__minus__, P.D0bar ]'
subs15 = 'P.B0bar, P.D__minus__ ]' 
subs16 = 'P.B0, P.D__plus__ ]' 
subs17 = 'P.B0sbar, P.Ds__minus__ ]'
subs18 = 'P.B0s, P.Ds__plus__ ]' 
subs19 = 'P.B0sbar, P.K__minus__ ]'
subs20 = 'P.B0s, P.K__plus__ ]' 

for i in range(len(content)):
	if subs1 in content[i] or subs2 in content[i] or subs3 in content[i] or subs4 in content[i]:
		content[i+2]='lorentz = [ L.FFSS1, L.FFSS2, L.FFSS3 ],'
	if subs5 in content[i] or subs6 in content[i]:
		content[i+2]='lorentz = [ L.FFSS4, L.FFSS5, L.FFSS6 ],'
	if subs7 in content[i] or subs8 in content[i]:
		content[i+2]='lorentz = [ L.FFSS7, L.FFSS8, L.FFSS9 ],'
	if subs9 in content[i] or subs10 in content[i]:
		content[i+2]='lorentz = [ L.FFSS10, L.FFSS11, L.FFSS12 ], '
	if subs11 in content[i] or subs12 in content[i]:
	  content[i+2]='lorentz = [ L.FFSS13, L.FFSS14, L.FFSS15 ],'
	if subs13 in content[i] or subs14 in content[i]:
	  content[i+2]='lorentz = [ L.FFSS16, L.FFSS17, L.FFSS18 ],'
	if subs15 in content[i] or subs16 in content[i]:
	  content[i+2]='lorentz = [ L.FFSS19, L.FFSS20, L.FFSS21 ],'
	if subs17 in content[i] or subs18 in content[i]:
	  content[i+2]='lorentz = [ L.FFSS22, L.FFSS23, L.FFSS24 ],'
	if subs19 in content[i] or subs20 in content[i]:
	  content[i+2]='lorentz = [ L.FFSS25, L.FFSS26, L.FFSS27 ],'

#We export the new vertices.py

with open(vertices, 'w') as f:
		for item in content:
				f.write("%s\n" % item)

###############################
###############################
###############################
###############################

# We modify the lorentz file to include the functions FFSS1 to FFSS9 that will be used by the vertices file

with open(lorentz_old) as f:
		content = f.readlines()
content = [x.strip() for x in content] 

content[9]='   import form_factors as ForFac'
content[11]='   pass'

subs1 = 'FFSS1 ='
subs2 = 'FFSS2 ='
subs3 = 'FFSS3 ='

for i in range(len(content)):
	if subs1 in content[i]:
		content[i+2]="structure = 'func2((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')"
	if subs2 in content[i]:
		content[i+2]="structure = 'func1((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')"
	if subs3 in content[i]:
		content[i+2]="structure = 'func2((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS4 = Lorentz(name = 'FFSS4',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func4((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS5 = Lorentz(name = 'FFSS5',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func3((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS6 = Lorentz(name = 'FFSS6',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func4((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS7 = Lorentz(name = 'FFSS7',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func6((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS8 = Lorentz(name = 'FFSS8',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func5((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS9 = Lorentz(name = 'FFSS9',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func6((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS10 = Lorentz(name = 'FFSS10',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func8((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS11 = Lorentz(name = 'FFSS11',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func7((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS12 = Lorentz(name = 'FFSS12',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func8((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS13 = Lorentz(name = 'FFSS13',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func10((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS14 = Lorentz(name = 'FFSS14',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func9((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS15 = Lorentz(name = 'FFSS15',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func10((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS16 = Lorentz(name = 'FFSS16',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func12((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS17 = Lorentz(name = 'FFSS17',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func11((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS18 = Lorentz(name = 'FFSS18',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func12((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS19 = Lorentz(name = 'FFSS19',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func14((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS20 = Lorentz(name = 'FFSS20',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func13((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS21 = Lorentz(name = 'FFSS21',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func14((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS22 = Lorentz(name = 'FFSS22',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func16((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS23 = Lorentz(name = 'FFSS23',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func15((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS24 = Lorentz(name = 'FFSS24',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func16((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')\n\nFFSS25 = Lorentz(name = 'FFSS25',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func18((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjM(2,1)')\n\nFFSS26 = Lorentz(name = 'FFSS26',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func17((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*P(-1,4)*Gamma(-1,2,-2)*ProjM(-2,1)')\n\nFFSS27 = Lorentz(name = 'FFSS27',\nspins = [ 2, 2, 1, 1 ],\nstructure = 'func18((P(-2,3)+P(-2,4))*(P(-2,3)+P(-2,4)))*ProjP(2,1)')"


with open(lorentz, 'w') as f:
		for item in content:
				f.write("%s\n" % item)



# We modify the parameters file to set the average form factors to 1. 


with open(parameters_old) as f:
		content = f.readlines()
content = [x.strip() for x in content] 

for j in range(1,7):
	for k in range (1,4):
		subs1 = 'fplusDK%sx%s = Parameter' % (j, k)
		subs2 = 'fminusDK%sx%s = Parameter' % (j, k)
		subs3 = 'fplusKPi0%sx%s = Parameter' % (j, k)
		subs4 = 'fminusKPi0%sx%s = Parameter' % (j, k)
		subs5 = 'fplusK0Pi%sx%s = Parameter' % (j, k)
		subs6 = 'fminusK0Pi%sx%s = Parameter' % (j, k)
		subs7 = 'fplusBPi0%sx%s = Parameter' % (j, k)
		subs8 = 'fminusBPi0%sx%s = Parameter' % (j, k)
		subs9 = 'fplusB0Pi%sx%s = Parameter' % (j, k)
		subs10 = 'fminusB0Pi%sx%s = Parameter' % (j, k)
		subs11 = 'fplusBD0%sx%s = Parameter' % (j, k)
		subs12 = 'fminusBD0%sx%s = Parameter' % (j, k)
		subs13 = 'fplusB0D%sx%s = Parameter' % (j, k)
		subs14 = 'fminusB0D%sx%s = Parameter' % (j, k)
		subs15 = 'fplusB0sDs%sx%s = Parameter' % (j, k)
		subs16 = 'fminusB0sDs%sx%s = Parameter' % (j, k)
		subs17 = 'fplusB0sK%sx%s = Parameter' % (j, k)
		subs18 = 'fminusB0sK%sx%s = Parameter' % (j, k)

		for i in range(len(content)):
			if subs1 in content[i] or subs3 in content[i] or subs5 in content[i] or subs7 in content[i] or subs9 in content[i] or subs11 in content[i] or subs13 in content[i] or subs15 in content[i] or subs17 in content[i]:
				content[i+3] = "value = '1',"
			if subs2 in content[i] or subs4 in content[i] or subs6 in content[i] or subs8 in content[i] or subs10 in content[i] or subs12 in content[i] or subs14 in content[i] or subs16 in content[i] or subs18 in content[i]:
				content[i+3] = "value = '0',"

with open(parameters, 'w') as f:
		for item in content:
				f.write("%s\n" % item)

###############################
###############################
###############################
###############################

# We create the file functions.f inside the Fortran folder 

functions = path + 'Fortran/' + 'functions.f' 

with open(functions, 'w') as f:
	f.write('      double complex function tp(m1,m2)\n'
					'      implicit none\n'
				'      double complex m1,m2\n'
					'      real*8 rm1,rm2\n'
					'      rm1=real(m1)\n'
					'      rm2=real(m2)\n'
				'      tp=(rm1+rm2)**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function t0(m1,m2)\n'
					'      implicit none\n'
					'      double complex m1,m2\n'
				'      real*8 rm1,rm2\n'
					'      rm1=real(m1)\n'
					'      rm2=real(m2)\n'
					'      t0=(rm1+rm2)*(sqrt(rm1)-sqrt(rm2))**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function z(Q,m1,m2)\n'
					'      implicit none\n'
				'      double complex Q,m1,m2,tp,t0\n'
					'      real*8 rQ,rm1,rm2,rtp,rt0\n'
					'      rQ=real(Q)\n'
					'      rm1=real(m1)\n'
					'      rm2=real(m2)\n'
					'      rtp=real(tp(m1,m2))\n'
				'      rt0=real(t0(m1,m2))\n'
					'      z=(sqrt(rtp-rQ)-sqrt(rtp-rt0))/(sqrt(rtp-rQ)+sqrt(rtp-rt0))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpDK(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 f00DK, cpDK, MD, MK, rQ, rz,rz0,P\n'
					'      f00DK=0.7647\n'
					'      cpDK=-0.066\n'
					'      MD=1.86958\n'
					'      MK=0.493677\n'
					'      P=0.224\n'
					'      rq=real(Q)\n'
					'      rz=real(z(Q,MD,MK))\n'
					'      rz0=real(z(0,MD,MK))\n'
					'      fpDK=(f00DK+cpDK*(rz-rz0)*(1+0.5*(rz+rz0)))/(1-P*rQ)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0DK(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 f00DK, c0DK, MD, MK,rQ,rz,rz0\n'
					'      MD=1.86958\n'
					'      MK=0.493677\n'
				'      f00DK=0.7647\n'
					'      c0DK=-2.084\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MD,MK))\n'
					'      rz0=real(z(0,MD,MK))\n'
					'      f0DK=f00DK+c0DK*(rz-rz0)*(1+0.5*(rz+rz0))\n'
				'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmDK(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0DK,fpDK\n'
					'      real*8 MD, MK,rQ,rf0DK,rfpDK\n'
					'      MD=1.86958\n'
					'      MK=0.493677\n'
					'      rQ=real(Q)\n'
					'      rf0DK=real(f0DK(Q))\n'
					'      rfpDK=real(fpDK(Q))\n'
					'      fmDK=(MK**2-MD**2)/rQ*(rf0DK-rfpDK)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func1(S)\n'
					'      implicit none\n'
					'      double complex S,fpDK\n'
					'      func1=real(fpDK(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func2(S)\n'
					'      implicit none\n'
					'      double complex S,fpDK,fmDK\n'
					'      func2=real(fpDK(S))-real(fmDK(S))\n'
					'      return\n'
				'      end\n'
					'\n'
					'      double complex function fpKPi0(Q)\n'
					'      implicit none\n'
					'      double complex Q\n'
					'      real*8 rQ,f00KPi,lplusKPi0,MP,MPplus\n'
					'      f00KPi=0.9709\n'
					'      lplusKPi0=0.0297\n'
					'      MP=0.13498\n'
					'      MPplus=0.13957\n'
					'      rQ=real(Q)\n'
					'      fpKPi0=f00KPi*(1+lplusKPi0*rQ/MPplus**2)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0KPi0(Q)\n'
					'      implicit none\n'
					'      double complex Q\n'
					'      real*8 rQ,f00KPi,l0KPi0,MP,MPplus\n'
					'      f00KPi=0.9709\n'
					'      l0KPi0=0.0195\n'
					'      MP=0.13498\n'
					'      MPplus=0.13957\n'
					'      rQ=real(Q)\n'
					'      f0KPi0=f00KPi*(1+l0KPi0*rQ/MPplus**2)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmKPi0(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0KPi0,fpKPi0\n'
					'      real*8 MK,MP,rQ,rf0KPi0,rfpKPi0\n'
					'      MP=0.13498\n'
					'      MK=0.493677\n'
					'      rQ=real(Q)\n'
					'      rf0KPi0=real(f0KPi0(Q))\n'
					'      rfpKPi0=real(fpKPi0(Q))\n'
					'      fmKPi0=(MP**2-MK**2)/rQ*(rf0KPi0-rfpKPi0)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func3(S)\n'
					'      implicit none\n'
					'      double complex S,fpKPi0\n'
					'      func3=real(fpKPi0(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func4(S)\n'
					'      implicit none\n'
					'      double complex S,fpKPi0,fmKPi0\n'
					'      func4=real(fpKPi0(S))-real(fmKPi0(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpK0Pi(Q)\n'
					'      implicit none\n'
					'      double complex Q\n'
					'      real*8 rQ,f00KPi,lplusK0Pi,MP\n'
					'      f00KPi=0.9709\n'
					'      lplusK0Pi=0.0282\n'
					'      MP=0.13957\n'
					'      rQ=real(Q)\n'
					'      fpK0Pi=f00KPi*(1+lplusK0Pi*rQ/MP**2)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0K0Pi(Q)\n'
					'      implicit none\n'
					'      double complex Q\n'
					'      real*8 rQ,f00KPi,l0K0Pi,MP\n'
					'      f00KPi=0.9709\n'
					'      l0K0Pi=0.0138\n'
					'      MP=0.13957\n'
					'      rQ=real(Q)\n'
					'      f0K0Pi=f00KPi*(1+l0K0Pi*rQ/MP**2)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmK0Pi(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0K0Pi,fpK0Pi\n'
					'      real*8 MK0,MP,rQ,rf0K0Pi,rfpK0Pi\n'
					'      MP=0.13957\n'
					'      MK0=0.497611\n'
					'      rQ=real(Q)\n'
					'      rf0K0Pi=real(f0K0Pi(Q))\n'
					'      rfpK0Pi=real(fpK0Pi(Q))\n'
					'      fmK0Pi=(MP**2-MK0**2)/rQ*(rf0K0Pi-rfpK0Pi)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func5(S)\n'
					'      implicit none\n'
					'      double complex S,fpK0Pi\n'
					'      func5=real(fpK0Pi(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func6(S)\n'
					'      implicit none\n'
					'      double complex S,fpK0Pi,fmK0Pi\n'
					'      func6=real(fpK0Pi(S))-real(fmK0Pi(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpBPi0(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a0pBPi,a1pBPi,a2pBPi,MBstar,MB,MPi0\n'
					'      a0pBPi=0.404\n'
					'      a1pBPi=-0.68\n'
					'      a2pBPi=-0.86\n'
					'      MBstar=5.3247\n'
					'      MB=5.279\n'
					'      MPi0=0.13498\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB,MPi0))\n'
					'      fpBPi0=1/(1-rQ/MBstar**2)*(a0pBPi+a1pBPi*rz+a2pBPi*rz**2+(2*a2pBPi-a1pBPi)*rz**3/3)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0BPi0(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a00BPi,a10Bpi,a20BPi,MB,MPi0\n'
					'      a00BPi=0.49\n'
					'      a10BPi=-1.61\n'
					'      a20BPi=1.2528\n'
					'      MB=5.279\n'
					'      MPi0=0.13498\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB,MPi0))\n'
					'      f0BPi0=a00BPi+a10BPi*rz+a20BPi*rz**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmBPi0(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0BPi0,fpBPi0\n'
					'      real*8 MB,MPi0,rQ,rf0BPi0,rfpBPi0\n'
					'      MPi0=0.13498\n'
					'      MB=5.279\n'
					'      rQ=real(Q)\n'
					'      rf0BPi0=real(f0BPi0(Q))\n'
					'      rfpBPi0=real(fpBPi0(Q))\n'
					'      fmBPi0=(MPi0**2-MB**2)/rQ*(rf0BPi0-rfpBPi0)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func7(S)\n'
					'      implicit none\n'
					'      double complex S,fpBPi0\n'
					'      func7=real(fpBPi0(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func8(S)\n'
					'      implicit none\n'
					'      double complex S,fpBPi0,fmBPi0\n'
					'      func8=real(fpBPi0(S))-real(fmBPi0(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpB0Pi(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a0pBPi,a1pBPi,a2pBPi,MBstar,MB0,MPi\n'
					'      a0pBPi=0.404\n'
					'      a1pBPi=-0.68\n'
					'      a2pBPi=-0.86\n'
					'      MBstar=5.3247\n'
					'      MB0=5.28\n'
					'      MPi=0.13957\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0,MPi))\n'
					'      fpB0Pi=1/(1-rQ/MBstar**2)*(a0pBPi+a1pBPi*rz+a2pBPi*rz**2+(2*a2pBPi-a1pBPi)*rz**3/3)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0B0Pi(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a00BPi,a10Bpi,a20BPi,MB0,MPi\n'
					'      a00BPi=0.49\n'
					'      a10BPi=-1.61\n'
					'      a20BPi=1.2528\n'
					'      MB0=5.28\n'
					'      MPi=0.13957\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0,MPi))\n'
					'      f0B0Pi=a00BPi+a10BPi*rz+a20BPi*rz**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmB0Pi(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0B0Pi,fpB0Pi\n'
					'      real*8 MB0,MPi,rQ,rf0B0Pi,rfpB0Pi\n'
					'      MPi=0.13957\n'
					'      MB0=5.28\n'
					'      rQ=real(Q)\n'
					'      rf0B0Pi=real(f0B0Pi(Q))\n'
					'      rfpB0Pi=real(fpB0Pi(Q))\n'
					'      fmB0Pi=(MPi**2-MB0**2)/rQ*(rf0B0Pi-rfpB0Pi)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func9(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0Pi\n'
					'      func9=real(fpB0Pi(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func10(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0Pi,fmB0Pi\n'
					'      func10=real(fpB0Pi(S))-real(fmB0Pi(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpBD0(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a0pBD,a1pBD,a2pBD,MBstar,MB,MD0\n'
					'      a0pBD=0.909\n'
					'      a1pBD=-7.11\n'
					'      a2pBD=66\n'
					'      MBstar=5.3247\n'
					'      MB=5.28\n'
					'      MD0=1.865\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB,MD0))\n'
					'      fpBD0=1/(1-rQ/MBstar**2)*(a0pBD+a1pBD*rz+a2pBD*rz**2+(2*a2pBD-a1pBD)*rz**3/3)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0BD0(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a00BD,a10BD,a20BD,MB,MD0\n'
					'      a00BD=0.794\n'
					'      a10BD=-2.45\n'
					'      a20BD=33.21\n'
					'      MB=5.279\n'
					'      MD0=1.865\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB,MD0))\n'
					'      f0BD0=a00BD+a10BD*rz+a20BD*rz**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmBD0(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0BD0,fpBD0\n'
					'      real*8 MB,MD0,rQ,rf0BD0,rfpBD0\n'
					'      MD0=1.865\n'
					'      MB=5.279\n'
					'      rQ=real(Q)\n'
					'      rf0BD0=real(f0BD0(Q))\n'
					'      rfpBD0=real(fpBD0(Q))\n'
					'      fmBD0=(MD0**2-MB**2)/rQ*(rf0BD0-rfpBD0)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func11(S)\n'
					'      implicit none\n'
					'      double complex S,fpBD0\n'
					'      func11=real(fpBD0(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func12(S)\n'
					'      implicit none\n'
					'      double complex S,fpBD0,fmBD0\n'
					'      func12=real(fpBD0(S))-real(fmBD0(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpB0D(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a0pBD,a1pBD,a2pBD,MBstar,MB0,MD\n'
					'      a0pBD=0.909\n'
					'      a1pBD=-7.11\n'
					'      a2pBD=66\n'
					'      MBstar=5.3247\n'
					'      MB0=5.279\n'
					'      MD=1.869\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0,MD))\n'
					'      fpB0D=1/(1-rQ/MBstar**2)*(a0pBD+a1pBD*rz+a2pBD*rz**2+(2*a2pBD-a1pBD)*rz**3/3)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0B0D(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a00BD,a10BD,a20BD,MB0,MD\n'
					'      a00BD=0.794\n'
					'      a10BD=-2.45\n'
					'      a20BD=33.21\n'
					'      MB0=5.28\n'
					'      MD=1.869\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0,MD))\n'
					'      f0B0D=a00BD+a10BD*rz+a20BD*rz**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmB0D(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0B0D,fpB0D\n'
					'      real*8 MB0,MD,rQ,rf0B0D,rfpB0D\n'
					'      MD=1.869\n'
					'      MB0=5.28\n'
					'      rQ=real(Q)\n'
					'      rf0B0D=real(f0B0D(Q))\n'
					'      rfpB0D=real(fpB0D(Q))\n'
					'      fmB0D=(MD**2-MB0**2)/rQ*(rf0B0D-rfpB0D)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func13(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0D\n'
					'      func13=real(fpB0D(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func14(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0D,fmB0D\n'
					'      func14=real(fpB0D(S))-real(fmB0D(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpB0sDs(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a0pBD,a1pBD,a2pBD,MBstar,MB0s,MDs\n'
					'      a0pBD=0.909\n'
					'      a1pBD=-7.11\n'
					'      a2pBD=66\n'
					'      MBstar=5.3247\n'
					'      MB0s=5.367\n'
					'      MDs=1.9683\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0s,MDs))\n'
					'      fpB0sDs=1/(1-rQ/MBstar**2)*(a0pBD+a1pBD*rz+a2pBD*rz**2+(2*a2pBD-a1pBD)*rz**3/3)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0B0sDs(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a00BD,a10BD,a20BD,MB0s,MDs\n'
					'      a00BD=0.794\n'
					'      a10BD=-2.45\n'
					'      a20BD=39.2\n'
					'      MB0s=5.367\n'
					'      MDs=1.9683\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0s,MDs))\n'
					'      f0B0sDs=a00BD+a10BD*rz+a20BD*rz**2\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmB0sDs(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0B0sDs,fpB0sDs\n'
					'      real*8 MB0s,MDs,rQ,rf0B0sDs,rfpB0sDs\n'
					'      MDs=1.9683\n'
					'      MB0s=5.367\n'
					'      rQ=real(Q)\n'
					'      rf0B0sDs=real(f0B0sDs(Q))\n'
					'      rfpB0sDs=real(fpB0sDs(Q))\n'
					'      fmB0sDs=(MDs**2-MB0s**2)/rQ*(rf0B0sDs-rfpB0sDs)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func15(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0sDs\n'
					'      func15=real(fpB0sDs(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func16(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0sDs,fmB0sDs\n'
					'      func16=real(fpB0sDs(S))-real(fmB0sDs(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fpB0sK(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a0pBK,a1pBK,a2pBK,a3pBK,MBstar,MB0s,MK\n'
					'      a0pBK=0.374\n'
					'      a1pBK=-0.672\n'
					'      a2pBK=0.07\n'
					'      a3pBK=1.34\n'
					'      MBstar=5.3247\n'
					'      MB0s=5.367\n'
					'      MK=0.493677\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0s,MK))\n'
					'      fpB0sK=1/(1-rQ/MBstar**2)*(a0pBK+a1pBK*rz+a2pBK*rz**2+a3pBK*rz**3+(a1pBK-2*a2pBK+3*a3pBK)/4*rz**4)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function f0B0sK(Q)\n'
					'      implicit none\n'
					'      double complex Q,z\n'
					'      real*8 rQ,rz,a00BK,a10BK,a20BK,a30BK,MB0s,MK\n'
					'      a00BK=0.2203\n'
					'      a10BK=0.089\n'
					'      a20BK=0.24\n'
					'      a30BK=14.02\n'
					'      MB0s=5.367\n'
					'      MK=0.493677\n'
					'      rQ=real(Q)\n'
					'      rz=real(z(Q,MB0s,MK))\n'
					'      f0B0sK=a00BK+a10BK*rz+a20BK*rz**2+a30BK*rz**3\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function fmB0sK(Q)\n'
					'      implicit none\n'
					'      double complex Q,f0B0sK,fpB0sK\n'
					'      real*8 MB0s,MK,rQ,rf0B0sK,rfpB0sK\n'
					'      MK=0.493677\n'
					'      MB0s=5.367\n'
					'      rQ=real(Q)\n'
					'      rf0B0sK=real(f0B0sK(Q))\n'
					'      rfpB0sK=real(fpB0sK(Q))\n'
					'      fmB0sK=(MK**2-MB0s**2)/rQ*(rf0B0sK-rfpB0sK)\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func17(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0sK\n'
					'      func17=real(fpB0sK(S))\n'
					'      return\n'
					'      end\n'
					'\n'
					'      double complex function func18(S)\n'
					'      implicit none\n'
					'      double complex S,fpB0sK,fmB0sK\n'
					'      func18=real(fpB0sK(S))-real(fmB0sK(S))\n'
					'      return\n'
					'      end')