(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "HELatNLO";

M$Information = {
  Authors      -> {"B. Fuks"},
  Version      -> "0.1",
  Date         -> "05. 02. 2016",
  Institutions -> {"LPTHE Paris / UPMC"},
  Emails       -> {"fuks@lpthe.jussieu.fr"},
  References   -> "",
  URLs         -> "https://feynrules.irmp.ucl.ac.be/wiki/SILH"
};

FeynmanGauge = True;

(* Change log *)
 (* v0.1 (05.02.2016) KM: *)


(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == {
    Abelian          -> True,
    CouplingConstant -> g1,
    GaugeBoson       -> B,
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> G,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)
IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];
IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* *****  Orders        ***** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1}, {QED, 2}, {NP,2},{HIG,4},{HIW,6}};
M$InteractionOrderLimit = { {QCD, 99}, {QED, 99} , {NP,1}, {HIG,1},{HIW,1}};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW, Internal},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "G",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZ, 91.1876},
    Width	    -> {WZ, 2.4952},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MW,Internal}, 
    Width           -> {WW, 2.085}, 
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[32] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MW,Internal},
    Width           -> {WW, 2.085},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[4] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    PDG             -> 82,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },

(* Gauge bosons: unphysical vector fields *)
  V[11] == { 
    ClassName     -> B, 
    Unphysical    -> True, 
    SelfConjugate -> True, 
    Definitions   -> { B[mu_] -> -sw Z[mu] + cw A[mu]}
  },
  V[12] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> {
      Wi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2],
      Wi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]),
      Wi[mu_,3] -> cw Z[mu] + sw A[mu]}
  },

(* Ghosts: related to unphysical gauge bosons *)
  U[11] == {
    ClassName     -> ghB, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B, 
    Definitions   -> { ghB -> -sw ghZ + cw ghA}
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[3] -> cw ghZ+sw ghA}
  } ,

(* Fermions: physical fields *)
  F[1] == {
    ClassName        -> vl,
    ClassMembers     -> {ve,vm,vt},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> 0,
    Width            -> 0,
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"ve","vm","vt"},
    AntiParticleName -> {"ve~","vm~","vt~"},
    FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
  },
  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
  F[3] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mu, {MU, 2.55*^-3}, {MC,1.27}, {MT,172}},
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
  F[4] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Md, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* Fermions: unphysical fields *)
  F[11] == { 
    ClassName      -> LL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2},
    Definitions    -> { LL[sp1_,1,ff_] :> Module[{sp2}, ProjM[sp1,sp2] vl[sp2,ff]], LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]] }
  },
  F[12] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1},
    Definitions    -> { lR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }
  },
  F[13] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> { 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] uq[sp2,ff,cc]], 
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKM[ff,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]] }
  },
  F[14] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> { uR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] uq[sp2,ff,cc]] }
  },
  F[15] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3},
    Definitions    -> { dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }
  },

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> H,
    SelfConjugate   -> True,
    Mass            -> {MH,125},
    Width           -> {WH,0.00407},
    PropagatorLabel -> "H",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "H",
    FullName        -> "H"
  },

(* Higgs: physical scalars  *)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    PropagatorLabel -> "Go",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MW, Internal},
    QuantumNumbers   -> {Q -> 1},
    Width            -> {WW, 2.085},
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },

(* Higgs: unphysical scalars  *)
  S[11] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { Phi[1] -> -I GP, Phi[2] -> (vev + H + I G0)/Sqrt[2]  }
  }
};


(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = GaugeXi[Z];
GaugeXi[ S[3]  ] = GaugeXi[W];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4]  ] = GaugeXi[G];


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
(* The loop coefficients *)
sert[x_] := 1+ 7/30 x + 2/21 x^2 + 26/525 x^3;
serw[xw_, xt_] := 1 + xw * 66/235 +xw^2 * 228/1645 + xw^3 * 696/8225 +
            xw^4 * 5248/90475 +xw^5 * 1280/29939+ xw^6 * 54528/1646645- 
            xt * 56/705 - xt^2 * 32/987;

M$Parameters = {
  (* New physics parameters *)
  NPl == { TeX -> \[CapitalLambda],               ParameterType -> External,   Value -> 1000,  BlockName -> NEWCOUP,   OrderBlock -> 0                              },
  cWW == { TeX -> Subscript[C,W],    ParameterType -> External,   Value -> 0.1,   BlockName -> NEWCOUP,   OrderBlock -> 1 , InteractionOrder -> {{NP,1},{QED,-1}} },
  cHW == { TeX -> Subscript[C,HW],   ParameterType -> External,   Value -> 0.1,   BlockName -> NEWCOUP,   OrderBlock -> 2 , InteractionOrder -> {{NP,1},{QED,-1}} },
  cB == { TeX -> Subscript[C,B],     ParameterType -> External,   Value -> 0.1,   BlockName -> NEWCOUP,   OrderBlock -> 3,  InteractionOrder -> {{NP,1},{QED,-1}} },

  cHB == { TeX -> Subscript[C,HB],          
               ParameterType -> External,   
               Value -> 0.1,   
               BlockName -> NEWCOUP,   OrderBlock -> 4,   
               InteractionOrder -> {{NP,1},{QED,-1}} },  

  cBB == { TeX -> Subscript[C,BB],          
               ParameterType -> External,   
               Value -> 0.1,   
               BlockName -> NEWCOUP,   OrderBlock -> 5,   
               InteractionOrder -> {{NP,1},{QED,-1}} },

  AH  == { TeX->Subscript[A,H], ParameterType->Internal, Value -> ee^2/4/Pi/(Pi*vev)*(47/18)(*serw[(MH/2/MW)^2, (MH/2/MT)^2] comment to be consitent with hza*), InteractionOrder -> {HIW, 1}},
  gZAH  == { (*TeX->Subscript[g,ZAH], *)
ParameterType->Internal, 
Value -> Sqrt[aEW Gf MZ^2/(8 Pi Sqrt[2])](94 cw2-13)/(9 Pi vev), 
InteractionOrder -> {HIW, 1}},
  GH  == { TeX->Subscript[G,H], ParameterType->Internal, Value -> -gs^2/(4Pi(3Pi vev)) (*sert[(MH/2/MT)^2]*),                InteractionOrder -> {HIG, 1}},

  (* External parameters *)
 
  aEWM1 == { 
    ParameterType    -> External, 
    BlockName        -> SMINPUTS, 
    OrderBlock       -> 1, 
    Value            -> 127.9,
    InteractionOrder -> {QED,-2},
    Description      -> "Inverse of the EW coupling constant at the Z pole"
  },
  Gf == {
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 2,
    Value            -> 1.16637*^-5, 
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[G,f],
    Description      -> "Fermi constant"
  },
  aS    == { 
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 3,
    Value            -> 0.1184, 
    InteractionOrder -> {QCD,2},
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "Strong coupling constant at the Z pole"
  },
  ymdo == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 1,
    Value         -> 5.04*^-3,
    Description   -> "Down Yukawa mass"
  },
  ymup == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 2,
    Value         -> 2.55*^-3,
    Description   -> "Up Yukawa mass"
  },
  yms == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 3,
    Value         -> 0.101,
    Description   -> "Strange Yukawa mass"
  },
  ymc == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 4,
    Value         -> 1.27,
    Description   -> "Charm Yukawa mass"
  },
  ymb == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 5,
    Value         -> 4.7,
    Description   -> "Bottom Yukawa mass"
  },
  ymt == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 6,
    Value         -> 172,
    Description   -> "Top Yukawa mass"
  },
  yme == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 11,
    Value         -> 5.11*^-4,
    Description   -> "Electron Yukawa mass"
  },
  ymm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 13,
    Value         -> 0.10566,
    Description   -> "Muon Yukawa mass"
  },
  ymtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 15,
    Value         -> 1.777,
    Description   -> "Tau Yukawa mass"
  },
  cabi == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 1,
    Value         -> 0.227736,
    TeX           -> Subscript[\[Theta], c],
    Description   -> "Cabibbo angle"
  },

  (* Internal Parameters *)
  aEW == {
    ParameterType    -> Internal,
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[\[Alpha], EW],
    Description      -> "Electroweak coupling constant"
  },

  vev == {
    ParameterType    -> Internal,
    Value            -> Sqrt[1/(Sqrt[2] Gf)],
    InteractionOrder -> {QED,-1},
    Description      -> "Higgs vacuum expectation value"
  },

  ee == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aEW] (1+cWW  Pi aEW vev^2/2 /NPl^2 ),
    InteractionOrder -> {QED,1},
    TeX              -> e,
    Description      -> "Electric coupling constant"
  },

  cw2 == { 
    ParameterType -> Internal, 
    Value         ->(MZ^2*(8*NPl^2 - 4*cB*ee^2*vev^2) + 4*MZ*Sqrt[(MZ - ee*vev)*(MZ + ee*vev)]*(2*NPl^2 + cB*ee^2*vev^2) - ee^2*vev^2*(8*NPl^2 + cWW*ee^2*vev^2))/ (16*MZ*NPl^2*Sqrt[(MZ - ee*vev)*(MZ + ee*vev)])
  },

  cw == { 
    ParameterType -> Internal, 
    Value -> Sqrt[cw2],
    TeX           -> Subscript[c,w], 
    Description   -> "Cosine of the Weinberg angle"
  },
  sw2 == { 
    ParameterType -> Internal, 
    Value -> 1-(cw)^2,
    Description   -> "Squared Sin of the Weinberg angle"
  },

  sw == { 
    ParameterType -> Internal, 
    Value -> Sqrt[sw2],
    TeX           -> Subscript[s,w], 
    Description   -> "Sine of the Weinberg angle"
  },

  MW == { 
    ParameterType -> Internal, 
    Value         -> (ee*vev)/(2*sw) ,
    TeX           -> Subscript[M,W], 
    Description   -> "W mass"
  },
  gw == { 
    ParameterType    -> Internal, 
    Definitions      -> {gw->ee/sw/(1 + ( cWW ee^2/sw^2 vev^2)/(8 NPl^2))}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,w], 
    Description      -> "Weak coupling constant at the Z pole"
  },
  g1 == { 
    ParameterType    -> Internal, 
    Definitions      -> {g1->1/(1 + (cBB ee^2 vev^2)/(4 NPl^2 cw^2) )ee/cw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,1], 
    Description      -> "U(1)Y coupling constant at the Z pole"
  },
  gs == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[g,s], 
    ParameterName    -> G,
    Description      -> "Strong coupling constant at the Z pole"
  },
  lam == {
    ParameterType    -> Internal,
    Value            -> MH^2/(2*vev^2),
    InteractionOrder -> {QED, 2},
    Description      -> "Higgs quartic coupling"
  },
  muH == {
    ParameterType -> Internal,
    Value         -> Sqrt[vev^2 lam],
    TeX           -> \[Mu],
    Description   -> "Coefficient of the quadratic piece of the Higgs potential"
  },
  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yl[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yl[1,1] -> Sqrt[2] yme / vev, yl[2,2] -> Sqrt[2] ymm / vev, yl[3,3] -> Sqrt[2] ymtau / vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yl[1,1] -> ye, yl[2,2] -> ym, yl[3,3] -> ytau},
    TeX              -> Superscript[y, l],
    Description      -> "Lepton Yukawa couplings"
  },
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yu[1,1] -> Sqrt[2] ymup/vev, yu[2,2] -> Sqrt[2] ymc/vev, yu[3,3] -> Sqrt[2] ymt/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yu[1,1] -> yup, yu[2,2] -> yc, yu[3,3] -> yt},
    TeX              -> Superscript[y, u],
    Description      -> "Up-type Yukawa couplings"
  },
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yd[1,1] -> Sqrt[2] ymdo/vev, yd[2,2] -> Sqrt[2] yms/vev, yd[3,3] -> Sqrt[2] ymb/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yd[1,1] -> ydo, yd[2,2] -> ys, yd[3,3] -> yb},
    TeX              -> Superscript[y, d],
    Description      -> "Down-type Yukawa couplings"
  },
(* N. B. : only Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Value         -> {CKM[1,1] -> Cos[cabi],  CKM[1,2] -> Sin[cabi], CKM[1,3] -> 0,
                      CKM[2,1] -> -Sin[cabi], CKM[2,2] -> Cos[cabi], CKM[2,3] -> 0,
                      CKM[3,1] -> 0,          CKM[3,2] -> 0,         CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"}

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)


LGauge := Block[{mu,nu,ii,aa}, 
  ExpandIndices[-1/4 FS[B,mu,nu] FS[B,mu,nu] - 1/4 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa], FlavorExpand->SU2W]];

LFermions := Block[{mu}, 
  ExpandIndices[I*(
    QLbar.Ga[mu].DC[QL, mu] + LLbar.Ga[mu].DC[LL, mu] + uRbar.Ga[mu].DC[uR, mu] + dRbar.Ga[mu].DC[dR, mu] + lRbar.Ga[mu].DC[lR, mu]), 
  FlavorExpand->{SU2W,SU2D}]/.{CKM[a_,b_] Conjugate[CKM[a_,c_]]->IndexDelta[b,c], CKM[b_,a_] Conjugate[CKM[c_,a_]]->IndexDelta[b,c]}];

LHiggs := Block[{ii,mu, feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  ExpandIndices[DC[Phibar[ii],mu] DC[Phi[ii],mu] + muH^2 Phibar[ii] Phi[ii] - lam Phibar[ii] Phi[ii] Phibar[jj] Phi[jj], FlavorExpand->{SU2D,SU2W}]/.feynmangaugerules
 ];

LYukawa := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar ->0}, {}];
 
  yuk = ExpandIndices[
   -yd[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] Phi[ii] - 
    yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phi[ii] - 
    yu[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] Phibar[jj] Eps[ii, jj], FlavorExpand -> SU2D];
  yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
  yuk+HC[yuk]/.feynmangaugerules
 ];

LGhost := Block[{LGh1,LGhw,LGhs,LGhphi,mu, generators,gh,ghbar,Vectorize,phi1,phi2,togoldstones,doublet,doublet0},
  (* Pure gauge piece *)
  LGh1 = -ghBbar.del[DC[ghB,mu],mu];
  LGhw = -ghWibar.del[DC[ghWi,mu],mu];
  LGhs = -ghGbar.del[DC[ghG,mu],mu];

  (* Scalar pieces: see Peskin pages 739-742 *)
  (* phi1 and phi2 are the real degrees of freedom of GP *)
  (* Vectorize transforms a doublet in a vector in the phi-basis, i.e. the basis of real degrees of freedom *)
  gh    = {ghB, ghWi[1], ghWi[2], ghWi[3]};
  ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
  generators = {-I/2 g1 IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
  doublet = Expand[{(-I phi1 - phi2)/Sqrt[2], Phi[2]} /. MR$Definitions /. vev -> 0]; 
  doublet0 = {0, vev/Sqrt[2]};
  Vectorize[{a_, b_}]:= Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]}/.{Im[_]->0, Re[num_]->num}];
  togoldstones := {phi1 -> (GP + GPbar)/Sqrt[2], phi2 -> (-GP + GPbar)/(I Sqrt[2])};
  LGhphi=Plus@@Flatten[Table[-ghbar[[kkk]].gh[[lll]] Vectorize[generators[[kkk]].doublet0].Vectorize[generators[[lll]].(doublet+doublet0)],{kkk,4},{lll,4}]] /.togoldstones;

ExpandIndices[ LGhs + If[FeynmanGauge, LGh1 + LGhw + LGhphi,0], FlavorExpand->SU2W]];

LSM:= LGauge + LFermions + LHiggs + LYukawa + LGhost;

Wvec[mu_,nu_,ii_,jj_]:= Module[{aa},Ta[aa,ii,jj] FS[Wi,mu,nu,aa]];

LSILH := Block[{ii,jj,mu,nu, OW, OB, OHW, OHBi, OBB},

  OW = I cWW gw/2 (Phibar[ii] DC[Phi[jj],mu] - DC[Phibar[ii],mu] Phi[jj]) DC[Wvec[mu,nu,ii,jj],nu];
  OB = I cB  g1/2 (Phibar[ii] DC[Phi[ii],mu] - DC[Phibar[ii],mu] Phi[ii]) del[FS[B,mu,nu],nu];
  OHW= I cHW gw DC[Phibar[ii],mu] DC[Phi[jj],nu] Wvec[mu,nu,ii,jj];
  OHB= I cHB g1 DC[Phibar[ii],mu] DC[Phi[ii],nu] FS[B,mu,nu];
  OBB= cBB g1^2/4 Phibar[ii] Phi[ii] FS[B,mu,nu] FS[B,mu,nu];

  1/NPl^2 (OW+OB+OHB+OHW+OBB)
];

RedefineSMP[lag_]:=Block[{mylag},
  mylag := ExpandIndices[lag,FlavorExpand->{SU2D,SU2W}];
  (* Field redefinitions *)
  mylag = mylag/. {A[mu_] :> A[mu] (1 + ( cBB g1^2 cw^2 vev^2)/(4 NPl^2)) - 
                                             Z[mu] ((2* cB*cw^2*g1^2 + (2*cBB*cw^2*g1^2 - (1-cw^2) cWW*gw^2)*sw^2)*vev^2)/(8*cw*NPl^2*sw), 
  Z[mu_] :> Z[mu] (1 + ( cWW gw^2 vev^2)/(8 NPl^2) + (cB  g1^2 vev^2)/(4 NPl^2) + (cBB  g1^2 sw^2 vev^2)/(4 NPl^2)) - 
                  A[mu] ((2* cB *cw^2*g1^2 0 + (2*cBB*cw^2*g1^2 - cw^2 cWW*gw^2)*sw^2)*vev^2)/(8*cw*NPl^2*sw), 
  W[mu_] -> W[mu] (1 + (cWW gw^2 vev^2)/(8 NPl^2)), 
  Wbar[mu_] -> Wbar[mu] (1 + (cWW gw^2 vev^2)/(8 NPl^2))}//.MR$Definitions(*for g1 before series and the other ???*);
  (Normal[Series[#,{NPl,Infinity,2}]]&)/@ mylag
];

LLOPP := -1/4 GH FS[G, mu, nu, b] FS[G, mu, nu, b] H (1-0*H/(2 vev)) - 1/4 AH FS[A, mu, nu] FS[A, mu, nu] H- 1/2 gZAH FS[Z, mu, nu] FS[A, mu, nu] H;

Lag:=RedefineSMP[LSM+LSILH] + LLOPP;


