(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    481516,      12837]
NotebookOptionsPosition[    471148,      12683]
NotebookOutlinePosition[    471784,      12703]
CellTagsIndexPosition[    471741,      12700]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.605939383914187*^9, 3.605939389600998*^9}, {
  3.609154670325432*^9, 3.609154671020789*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"8f7c761c-624f-4318-b1ab-93d438c5cf80"],

Cell[CellGroupData[{

Cell["The Hidden Abelian Higgs model with variable MW", "Title",
 CellChangeTimes->{{3.411915778286763*^9, 3.4119157817267313`*^9}, {
  3.413720856398858*^9, 3.413720856723679*^9}, {3.509778928631168*^9, 
  3.509778939699687*^9}, {3.609239767121204*^9, 
  3.609239768579833*^9}},ExpressionUUID->"708b3756-2511-4160-8fbe-\
aec4faf12e29"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\</Users/davidcurtin/Software/feynrules-current-2.3\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}]}], "Input",
 CellChangeTimes->{3.869229275682345*^9, 3.86922937081586*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"97b19875-def0-4517-8267-6ca84ccb893c"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547967272*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"08621f92-bf12-41e2-8294-5baa8ee38e26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.31\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"26 January 2018\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.31", " (" "26 January 2018", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547980596*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"bb7adf4d-a17c-4150-afd1-87284e946b4f"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547982888*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"fda960f7-ec20-4c97-9b93-eb9eb1ee61bd"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.8880515479842577`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1b127b19-6cd8-49f2-9a46-3c1530f51bc2"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547985552*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b53acc50-095a-4ab5-9672-578a45a31f29"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547986679*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"afbf5365-e909-4dcd-b96a-b7472cc1a7f9"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547987759*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b5460b14-ab57-4298-8440-ee1bfe03cc8a"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547989057*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e326f61b-d540-46ca-8954-597d66e66a6b"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547990007*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"592df06d-ea2f-4864-a477-b0cee2b82697"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547990952*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d4dcc49f-feef-4d40-b509-fe8903da3b7e"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.6202312868885117`*^9, 3.620231306642997*^9}, 
   3.86922915671272*^9, 3.869229372464991*^9, 3.869770174707967*^9, 
   3.888051547991878*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"296e28ab-7bf1-4412-9875-e35f7b86108c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
   "modeldir", "=", 
    "\"\</Users/davidcurtin/Software/hidden_abelian_higgs_model_final/HAHM_\
variableMW_v5_allyuk/\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"modelfile", "=", "\"\<HAHM_final_variableMW_v5.fr\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{"modeldir", "<>", "modelfile"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.605249872680089*^9, {3.6053061313866796`*^9, 3.60530613146021*^9}, 
   3.605311257985278*^9, {3.605569568908189*^9, 3.605569570006483*^9}, {
   3.605572782711409*^9, 3.605572782965074*^9}, {3.6059393763057947`*^9, 
   3.605939391935643*^9}, {3.605940425194668*^9, 3.605940426910673*^9}, {
   3.605940676225548*^9, 3.605940696567214*^9}, {3.6059414342043257`*^9, 
   3.605941434348999*^9}, {3.6066476428102818`*^9, 3.606647654077117*^9}, {
   3.6066706011086597`*^9, 3.606670601274888*^9}, {3.6067471860389633`*^9, 
   3.6067471861784973`*^9}, {3.6091545943945932`*^9, 3.609154607763337*^9}, 
   3.609156687900199*^9, {3.60915816116991*^9, 3.609158251613903*^9}, {
   3.6091583284081697`*^9, 3.6091583402865334`*^9}, {3.60915850356952*^9, 
   3.609158506558864*^9}, {3.6092396745509787`*^9, 3.609239689023221*^9}, {
   3.6202290642803717`*^9, 3.620229096384314*^9}, {3.869229188370963*^9, 
   3.869229196371605*^9}, {3.869229268132497*^9, 3.869229270018696*^9}, {
   3.869229360119904*^9, 3.869229375369817*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"c8df7060-22ce-4711-805e-6f88cc38ffa2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554740159*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"e14a4eaf-bf2b-48bb-a113-a7b662665b14"],

Cell[BoxData["\<\"C. Duhr, David Curtin\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554741413*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"3eb88960-87f2-469f-8bff-cc2d1998fc3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.31\"\>"}],
  SequenceForm["Model Version: ", "2.3.31"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554743443*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"b8c6b88e-9ec3-4ad9-8822-7e01c764922b"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554744658*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"a246d1dd-e6b2-4098-82e0-70563cac7932"],

Cell[BoxData["\<\"J. D. Wells, \\\"How to Find a Hidden World at the Large \
Hadron Collider,\\\", [arXiv:0803.1243 [hep-ph]] \\nCurtin, Essig, Gori, \
Shelton , \\\"Illuminating Dark Photons with High-Energy Colliders\\\", \
[arXiv:1412.0018 [hep-ph]]\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.8880515547455797`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"f07134e1-1f42-4ff6-b810-e503ee7ba8e2"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be/view/Main/\
HiddenAbelianHiggsModel\\nhttps://github.com/davidrcurtin/HAHM\"\>"], "Print",\

 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554746611*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"62c41ef6-c395-4f2b-86c5-b7978c393ad2"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554747469*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"c00af7c3-cba3-47f0-aa3b-a2f1dd59ccc3"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554748209*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"fdab4bd1-d32b-44f0-9b93-53100f56a144"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554748962*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2de93410-6849-4fde-9289-8ea8a2418ccf"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554813238*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"30c46df2-f1f8-4d37-83ab-cfd5f87d4648"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.888051554818183*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"ece6c5e5-6b0c-4a25-81a0-0d1192a30718"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"HAHM_variableMW_v5\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "HAHM_variableMW_v5", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9, {3.620229077165268*^9, 3.6202291459221497`*^9}, 
   3.620230428442337*^9, {3.6202306515382957`*^9, 3.6202306545666323`*^9}, {
   3.620231039001643*^9, 3.620231040875616*^9}, {3.620231188696662*^9, 
   3.620231196115066*^9}, {3.869229198321164*^9, 3.869229208380001*^9}, 
   3.869229281978266*^9, 3.869229381708444*^9, 3.8697701805493937`*^9, 
   3.8880515548651447`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"2e535cdc-d843-4eab-9ae8-4d1b9fbedddc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.411915790793332*^9, 
  3.411915793199389*^9}},ExpressionUUID->"f4026d77-41f8-4dbe-85a5-\
c2703c09fa30"],

Cell[CellGroupData[{

Cell[BoxData["LHAHM"], "Input",
 CellChangeTimes->{{3.4119143176932583`*^9, 3.411914319401045*^9}, {
  3.509778966781176*^9, 3.509778967770995*^9}, {3.509779355012743*^9, 
  3.509779370460802*^9}},ExpressionUUID->"1da95652-fef6-400f-8949-\
30f65d69d630"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", "phih", " ", 
   SuperscriptBox["phih", "\[Dagger]"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "2"], " ", "\[Kappa]"}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "4"], " ", "\[Lambda]"}], "+", 
  RowBox[{"phih", " ", 
   SuperscriptBox["phih", "\[Dagger]"], " ", 
   TemplateBox[{"\[Mu]", "H", "2"},
    "Subsuperscript"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
   TemplateBox[{"\[Mu]", "SM", "2"},
    "Subsuperscript"]}], "-", 
  RowBox[{
   SuperscriptBox["phih", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["phih", "\[Dagger]"], ")"}], "2"], " ", "\[Rho]"}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["A", "H"], " ", "H", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["A", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["A", "nu"], "]"}]}], ")"}], "2"]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["B", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["B", "nu"], "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Chi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["B", "mu"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["B", "nu"], "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["X", "mu"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["X", "nu"], "]"}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["X", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["X", "nu"], "]"}]}], ")"}], "2"]}], "-", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubsuperscriptBox["ghG", "a", "\[Dagger]"], ".", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
         SubscriptBox["ghG", "a"], "]"}], "]"}], 
       SubscriptBox["g", "s"]], "+", 
      RowBox[{
       SubscriptBox["f", 
        RowBox[{"a", ",", "a2$2227", ",", "a3$2227"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
           SubscriptBox["ghG", "a3$2227"], "]"}], " ", 
          SubscriptBox["G", 
           RowBox[{"mu", ",", "a2$2227"}]]}], "+", 
         RowBox[{
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
           SubscriptBox["G", 
            RowBox[{"mu", ",", "a2$2227"}]], "]"}], " ", 
          SubscriptBox["ghG", "a3$2227"]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["dq", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "dq", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["l", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "l", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["uq", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "uq", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["vl", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "vl", "]"}]}]}], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["dq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["dq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "dq"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "l"}]}], 
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "l"}]}], 
   SubscriptBox["c", "w"]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["uq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["uq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "uq"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["vl", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}]}], 
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["dq", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "dq"}], "+", 
     RowBox[{
      OverscriptBox["uq", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "uq"}]}], ")"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a"}]]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"a1", ",", "a2", ",", "a3"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a2"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a3"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"a1", ",", "a4", ",", "a5"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a4"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a5"}]]}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["G", "H"], " ", "H", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "b"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "b"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"b", ",", "bb$2228", ",", "cc$2228"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "bb$2228"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "cc$2228"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "b"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "b"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"b", ",", "bb$2229", ",", "cc$2229"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "bb$2229"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "cc$2229"}]]}]}], ")"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "1"}]], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "2"}]]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "1"}]], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "2"}]]}]}], ")"}]}], 
   RowBox[{"8", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["B", "mu"]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "w"]}]], "-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "H", "]"}]}], 
      SqrtBox["2"]], "-", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["B", "mu"]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "w"]}]], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "H", "]"}]}], 
      SqrtBox["2"]], "-", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SubscriptBox["s", "w"]}]], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["vl", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "l"}], " ", 
       SubscriptBox["W", "mu"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ".", "CKM", ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}], " ", 
       SubscriptBox["W", "mu"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["l", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}], " ", 
       SubsuperscriptBox["W", "mu", "\[Dagger]"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["dq", "\<\"-\"\>"], ".", 
        SuperscriptBox["CKM", "\[Dagger]"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}], " ", 
       SubsuperscriptBox["W", "mu", "\[Dagger]"]}], "-", 
      RowBox[{
       RowBox[{
        OverscriptBox["dq", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "-", 
      RowBox[{
       RowBox[{
        OverscriptBox["l", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "l"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["vl", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}]}], ")"}]}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "i1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "w"], " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"i1", ",", "i2", ",", "i3"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "i2"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i3"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "i1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "w"], " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"i1", ",", "i4", ",", "i5"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "i4"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i5"}]]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "phih", "]"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "X"], " ", "phih", " ", 
      SubscriptBox["X", "mu"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SuperscriptBox["phih", "\[Dagger]"], "]"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "X"], " ", 
      SuperscriptBox["phih", "\[Dagger]"], " ", 
      SubscriptBox["X", "mu"]}]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["dq", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219", ",", "i$2219"}]], ".", 
     SubscriptBox["dq", 
      RowBox[{"r$2219", ",", "n$2219", ",", "i$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yd", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["dq", "\<\"-\"\>"], 
      RowBox[{"r$2221", ",", "n$2220", ",", "i$2220"}]], ".", 
     SubscriptBox["dq", 
      RowBox[{"r$2222", ",", "n$2220", ",", "i$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2221", ",", "r$2222"}]], " ", 
    SubscriptBox["yd", "n$2220"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["l", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219"}]], ".", 
     SubscriptBox["l", 
      RowBox[{"r$2219", ",", "n$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yl", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["l", "\<\"-\"\>"], 
      RowBox[{"r$2223", ",", "n$2220"}]], ".", 
     SubscriptBox["l", 
      RowBox[{"r$2224", ",", "n$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2223", ",", "r$2224"}]], " ", 
    SubscriptBox["yl", "n$2220"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["uq", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219", ",", "i$2219"}]], ".", 
     SubscriptBox["uq", 
      RowBox[{"r$2219", ",", "n$2219", ",", "i$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yu", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["uq", "\<\"-\"\>"], 
      RowBox[{"r$2225", ",", "n$2220", ",", "i$2220"}]], ".", 
     SubscriptBox["uq", 
      RowBox[{"r$2226", ",", "n$2220", ",", "i$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2225", ",", "r$2226"}]], " ", 
    SubscriptBox["yu", "n$2220"]}], 
   SqrtBox["2"]]}]], "Output",
 CellChangeTimes->{3.604964592307816*^9, 3.604974621986936*^9, 
  3.604986084942824*^9, 3.605249884285236*^9, 
  3.60923970107405*^9},ExpressionUUID->"ab491ae7-c188-462c-8093-019c8fde8531"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Feynman rules", "Section",
 CellChangeTimes->{{3.411915866249317*^9, 3.4119158716988153`*^9}, 
   3.509779363849759*^9},ExpressionUUID->"d83ab238-2cfb-44ac-b96a-\
d324ab9f39f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915928653887*^9}, {
   3.4137211614912577`*^9, 3.4137211708030777`*^9}, 3.508569350492257*^9, {
   3.509779361403779*^9, 
   3.509779374162471*^9}},ExpressionUUID->"fbca8125-09c3-4217-ba60-\
89c9c37886b5"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.604964596346346*^9},ExpressionUUID->"cae79006-ac83-41d8-b30e-\
9004df87211d"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.604964596348333*^9},ExpressionUUID->"0f6d6426-2b4b-4808-8fc3-\
9553e3c3d1c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.604964596350655*^9},ExpressionUUID->"3730374d-90c1-4207-95ae-\
bd52d1140b61"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.604964598531795*^9},ExpressionUUID->"6cc6a5b2-da59-47be-9b81-\
94562505b695"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "66", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{108., {3., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "66", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  66, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 66, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.604964598624443*^9},ExpressionUUID->"8a2a5d57-a94b-4237-be48-\
6495daf7e50b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"65", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[65, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.604964602309856*^9},ExpressionUUID->"e2a6291e-cfbc-405a-a894-\
5448f1f0d7dc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Kappa]"}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Lambda]"}], "+", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Lambda]"}], "+", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Kappa]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Lambda]"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["ghG", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ghG", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.60496460245289*^9},ExpressionUUID->"9330c5dc-8fcb-4a6e-a031-92f9d8097166"]
}, Closed]],

Cell["Or in a flavor expanded form", "Text",
 CellChangeTimes->{{3.411915937803143*^9, 
  3.4119159434558887`*^9}},ExpressionUUID->"5046a2f6-3f50-4277-a184-\
5f92dd3bc900"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LHAHM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915958983838*^9}, {
   3.508569657623721*^9, 3.508569668869379*^9}, {3.5097793668671083`*^9, 
   3.509779379186967*^9}, 3.5136893169327602`*^9, 3.869770206756049*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"c7457253-dd69-4de3-afc6-2731d1e4dd81"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.869770215182358*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"5ef2fe2d-13c3-4d26-9f50-6da91f7b725a"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.86977021518369*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"961d23b4-057e-417c-949e-221430ca9a99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.869770215185154*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"fde99e35-04a3-43da-93c4-fbf17a12013c"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.869770220825396*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"249e36ab-6965-4648-81c1-4707ee17fdae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "126", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "126", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  126, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 126, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.869770220920743*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"33b629c7-ef92-44c0-acef-994bc7f7d97b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"123", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[123, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.869770227855337*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"60799b4e-3741-4b11-8d18-dc8124891e74"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Kappa]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Lambda]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Lambda]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Lambda]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Kappa]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Lambda]"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["A", "H"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["A", "H"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       RowBox[{
        SubscriptBox["\<\"p\"\>", "1"], ".", 
        SubscriptBox["p", "2"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["A", "H"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["A", "H"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       RowBox[{
        SubscriptBox["\<\"p\"\>", "1"], ".", 
        SubscriptBox["p", "2"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       RowBox[{
        SubscriptBox["\<\"p\"\>", "1"], ".", 
        SubscriptBox["p", "2"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       RowBox[{
        SubscriptBox["\<\"p\"\>", "1"], ".", 
        SubscriptBox["p", "2"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["ghG", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ghG", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["G", "H"], " ", 
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["G", "H"], " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", "1"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", "1"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", "2"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", "2"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", "3"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", "3"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", "1"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", "1"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["m", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", "2"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["m", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", "2"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["tt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", "3"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["tt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", "3"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", "1"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", "1"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", "2"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", "2"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", "3"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", "3"]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"hs", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"hs", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["g", "X", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SuperscriptBox["\[Chi]", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["m", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["tt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["m", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["tt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["m", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["tt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{
        SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]], 
        SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["ve", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ve", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vm", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vm", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["ve", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ve", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vm", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vm", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]", 
             SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]", 
            SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["ve", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vm", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{"2", ",", "1"}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["c", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{"2", ",", "2"}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["t", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["u", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{"1", ",", "2"}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ve", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["m", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vm", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["tt", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vt", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["b", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{"2", ",", "1"}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["d", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{"1", ",", "1"}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{"2", ",", "2"}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["s", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{"1", ",", "2"}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8697702279306173`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"3a160aff-952a-4072-938c-778770e90847"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["checking mass spectrum", "Section",
 CellChangeTimes->{{3.604964662895247*^9, 
  3.604964665651083*^9}},ExpressionUUID->"424e69f1-4d4d-4439-a7f6-\
83a65efff36d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.6049646159829206`*^9, 
  3.604964633860752*^9}},ExpressionUUID->"77fa853a-bb3a-475a-9c4a-\
56b158e2f49a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.6092397209818897`*^9},ExpressionUUID->"5e86b184-f6ee-44c4-9f51-\
ed0398d58886"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Non diagonal mass term found: \"\>", "\[InvisibleSpace]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
     SubscriptBox["s", "h"], " ", 
     SuperscriptBox["v", "2"], " ", "\[Kappa]"}]}], "-", 
   RowBox[{"3", " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    SuperscriptBox["v", "2"], " ", "\[Lambda]"}], "-", 
   RowBox[{
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    TemplateBox[{"\[Mu]", "H", "2"},
     "Subsuperscript"]}], "+", 
   RowBox[{
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    TemplateBox[{"\[Mu]", "SM", "2"},
     "Subsuperscript"]}], "-", 
   RowBox[{
    SubsuperscriptBox["c", "h", "2"], " ", "h", " ", "hs", " ", "v", " ", 
    "\[Kappa]", " ", "\[Xi]"}], "+", 
   RowBox[{"h", " ", "hs", " ", 
    SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]", " ", 
    "\[Xi]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", "\[Kappa]", " ", 
    SuperscriptBox["\[Xi]", "2"]}], "+", 
   RowBox[{"3", " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    SuperscriptBox["\[Xi]", "2"], " ", "\[Rho]"}]}],
  SequenceForm[
  "Non diagonal mass term found: ", (((((
         Rational[
          1, 2] $CellContext`ch) $CellContext`h) $CellContext`hs) \
$CellContext`sh) 
     FeynRules`v^2) $CellContext`\[Kappa] - (((((
        3 $CellContext`ch) $CellContext`h) $CellContext`hs) $CellContext`sh) 
    FeynRules`v^2) $CellContext`\[Lambda] - ((($CellContext`ch \
$CellContext`h) $CellContext`hs) $CellContext`sh) $CellContext`\[Mu]H2 + \
((($CellContext`ch $CellContext`h) $CellContext`hs) $CellContext`sh) \
$CellContext`\[Mu]SM2 - (((($CellContext`ch^2 $CellContext`h) $CellContext`hs)
       FeynRules`v) $CellContext`\[Kappa]) $CellContext`\[Xi] + \
(((($CellContext`h $CellContext`hs) $CellContext`sh^2) 
      FeynRules`v) $CellContext`\[Kappa]) $CellContext`\[Xi] + (((((
         Rational[-1, 
           2] $CellContext`ch) $CellContext`h) $CellContext`hs) \
$CellContext`sh) $CellContext`\[Kappa]) $CellContext`\[Xi]^2 + (((((
         3 $CellContext`ch) $CellContext`h) $CellContext`hs) $CellContext`sh) \
$CellContext`\[Xi]^2) $CellContext`\[Rho]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.609239721306641*^9},ExpressionUUID->"553bf564-2ab6-4fe5-b3c8-\
33b14c986f42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non diagonal mass term found: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     SubscriptBox["c", "\[Alpha]"], " ", 
     SuperscriptBox["e", "2"], " ", 
     SubscriptBox["s", "\[Alpha]"], " ", 
     SuperscriptBox["v", "2"], " ", 
     SubscriptBox["Z", "mu"], " ", 
     SubscriptBox["Zp", "mu"]}], "-", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SubsuperscriptBox["c", "w", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["s", "w", "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SubsuperscriptBox["s", "w", "2"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubscriptBox["s", "w"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubscriptBox["s", "w"]}]], "-", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "w"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
      SubscriptBox["s", "w"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SuperscriptBox["\[Eta]", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SubsuperscriptBox["g", "X", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["\[Eta]", "2"], " ", 
      SuperscriptBox["\[Xi]", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     SuperscriptBox["\[Chi]", "2"]]}]}],
  SequenceForm[
  "Non diagonal mass term found: ", (((((Rational[-1, 2] $CellContext`ca) 
        FeynRules`ee^2) $CellContext`sa) FeynRules`v^2) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + (((((((
           Rational[-1, 4] $CellContext`ca) $CellContext`cw^2) 
         FeynRules`ee^2) $CellContext`sa) $CellContext`sw^(-2)) 
      FeynRules`v^2) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + (((((((
           Rational[-1, 4] $CellContext`ca) $CellContext`cw^(-2)) 
         FeynRules`ee^2) $CellContext`sa) $CellContext`sw^2) 
      FeynRules`v^2) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + ((((((Rational[-1, 4] $CellContext`ca^2) 
         FeynRules`ee^2)/$CellContext`sw) FeynRules`v^2) 
      FeynRules`\[Eta]) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + ((((((Rational[1, 4] 
          FeynRules`ee^2) $CellContext`sa^2)/$CellContext`sw) FeynRules`v^2) 
      FeynRules`\[Eta]) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + (((((((
           Rational[-1, 4] $CellContext`ca^2) $CellContext`cw^(-2)) 
         FeynRules`ee^2) $CellContext`sw) FeynRules`v^2) 
      FeynRules`\[Eta]) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + (((((((Rational[1, 4] $CellContext`cw^(-2)) 
          FeynRules`ee^2) $CellContext`sa^2) $CellContext`sw) FeynRules`v^2) 
      FeynRules`\[Eta]) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + (((((((
           Rational[1, 4] $CellContext`ca) $CellContext`cw^(-2)) 
         FeynRules`ee^2) $CellContext`sa) FeynRules`v^2) 
      FeynRules`\[Eta]^2) $CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + (((((($CellContext`ca $CellContext`gX^2) \
$CellContext`sa) 
        FeynRules`\[Eta]^2) $CellContext`\[Xi]^2) $CellContext`\[Chi]^(-2)) \
$CellContext`Z[
       FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]) $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.609239721341413*^9},ExpressionUUID->"f6290d92-b21d-4211-81fb-\
b3819cbe3804"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["computing widths", "Section",
 CellChangeTimes->{{3.604964673012329*^9, 
  3.604964674219133*^9}},ExpressionUUID->"72be2211-992f-4c3d-bf81-\
ed89a612b083"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"decays", "=", 
   RowBox[{"ComputeWidths", "[", 
    RowBox[{"FeynmanRules", "[", 
     RowBox[{"LHAHM", ",", " ", 
      RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"UpdateWidths", "[", "decays", "]"}]}], "Input",
 CellChangeTimes->{{3.604964698503813*^9, 3.6049647587517157`*^9}, 
   3.6052499155507927`*^9, {3.6052709918253393`*^9, 
   3.605270991994774*^9}},ExpressionUUID->"782909e4-c896-4463-a47e-\
56711bad724e"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.6092397343060427`*^9},ExpressionUUID->"c662a726-405a-4f2d-b347-\
1f39b2008980"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.6092397343083897`*^9},ExpressionUUID->"3b5620bb-85fa-47bf-af01-\
4c70d97495c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239734311686*^9},ExpressionUUID->"7c94993d-7a8d-4dbb-b680-\
7aa8629fc68e"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239736372183*^9},ExpressionUUID->"f34a7c38-16bf-4f06-b3b2-\
e7a95de5495f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "74", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{108., {3., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "74", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  74, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 74, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.6092397364623947`*^9},ExpressionUUID->"5c7fda6c-1c12-4bca-8365-\
a7078ca6cec7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"73", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[73, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239740621428*^9},ExpressionUUID->"a86307d7-8b74-409b-a61f-\
6fce5ee4aa2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{65., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "73"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 73],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.60923974144049*^9},ExpressionUUID->"c1433bc5-f289-443f-819c-4cdabf31a987"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239743803046*^9},ExpressionUUID->"60380b83-c179-45be-bd49-\
5acde4da46d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{122., {3., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "72"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239744164736*^9},ExpressionUUID->"397ae2c2-f711-4a72-b7b9-\
c652ee57a8b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{122., {3., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "65"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 65],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.6092397470947237`*^9},ExpressionUUID->"3bb58190-34a4-4da2-9b5e-\
bfa87eae72c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WH\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.00636986\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WH", " = ", "0.00636986", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239754590353*^9},ExpressionUUID->"7e737133-a92c-4d5b-9472-\
9d27992f0f22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WHS\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"18.4103\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WHS", " = ", "18.4103", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.6092397545921288`*^9},ExpressionUUID->"497320cb-08a8-4873-bf47-\
d5dde0a78b39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WT\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"1.57377\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WT", " = ", "1.57377", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239754593815*^9},ExpressionUUID->"60db431a-5364-4042-bab5-\
ccaa7e5cf036"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WW\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"2.09164\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WW", " = ", "2.09164", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239754595503*^9},ExpressionUUID->"3f7b9571-9ded-4da2-a0b3-\
b622cf01d03f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZ\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"2.49969\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WZ", " = ", "2.49969", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239754597271*^9},ExpressionUUID->"962e6656-876b-4bb2-8f16-\
6054623b37c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZp\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.0000354319\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WZp", " = ", "0.0000354319", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 
  3.609239754598975*^9},ExpressionUUID->"8c88aa63-5375-4aef-8567-\
20016e24e1e4"]
}, Open  ]]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.6053057661784267`*^9, 
  3.605305766712928*^9}},ExpressionUUID->"97f95f7d-e9bd-4287-bcb2-\
6b6f17d9973e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Export to UFO", "Section",
 CellChangeTimes->{{3.604964806489471*^9, 
  3.604964808080537*^9}},ExpressionUUID->"1c91b8f2-e506-4a92-b156-\
e13b9edf55df"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SetDirectory", "[", "modeldir", "]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LHAHM", ",", " ", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.604964810304481*^9, 3.604964842385274*^9}, {
  3.6066531173829193`*^9, 3.6066531174657927`*^9}, {3.86977022089082*^9, 
  3.86977022266951*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"b6f8b729-6a26-4a65-82b5-59694437b506"],

Cell[BoxData["\<\"/Users/davidcurtin/Software/hidden_abelian_higgs_model_\
final/HAHM_variableMW_v5_allyuk\"\>"], "Output",
 CellChangeTimes->{
  3.604964842846836*^9, {3.6049746742098494`*^9, 3.6049746798957*^9}, 
   3.6052505022725983`*^9, 3.6055698549486017`*^9, 3.606647705150442*^9, 
   3.606653319113881*^9, 3.606653967968173*^9, 3.606671355670191*^9, 
   3.606671715361816*^9, 3.606726567740533*^9, 3.606747230788603*^9, 
   3.6091595675130453`*^9, 3.609166725787594*^9, 3.609171450142783*^9, 
   3.609181896362587*^9, 3.609236894073102*^9, 3.609240744677514*^9, 
   3.609241218960959*^9, {3.620229109722753*^9, 3.62022914936265*^9}, 
   3.6202306613612843`*^9, 3.620231044919338*^9, 3.620231206469881*^9, 
   3.869229426115286*^9, 3.86977023008282*^9, 3.8880515591646013`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"1b6f6e60-dc33-4e27-bec4-966f6d492dbf"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515591852922`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"64fae88e-73ff-46af-af09-1fcefcb54bb5"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515593086853`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"12074a05-2daa-49c9-8af2-02199e4605e3"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.88805155931022*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"1e17d6e4-b922-4222-ba35-7b3b43597286"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051559311067*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"7d1014c7-d20a-422d-8c84-dcb316381f01"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515648781967`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"a6e59c67-5bb5-4ea3-812b-016cee9bd481"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "126", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "126", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  126, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 126, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051564970089*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"d050486f-e245-45fb-ad98-0e0d90ec2ffa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"123", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[123, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051571396681*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"635b6daf-18c6-4c11-b4ad-cd4d486f4ea0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "123"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 123],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515726679564`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"c9f9bba2-ef11-47cd-9dcb-ac553511bed6"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051577738699*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"c9881ad9-f0da-440e-9d68-d488fda0b74d"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051577756279*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"dde68808-14b7-4a62-ae17-4d69de968075"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "74"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 74],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515777918863`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"46ce0cbd-626d-497a-891b-6890dcb65802"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "7.710481`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 7.710481, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515977689457`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"0e4fc57d-903b-4ab2-914c-bcc03a8c38ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "83"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 83],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880515977711363`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"1f6baee2-9868-4f82-8b08-493d91ccf4fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "3.053186`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 3.053186, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051601448319*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"634635a5-d9b3-4b11-841f-6d0b6a6316bd"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880516014497423`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"39001d62-059d-437c-b4be-8e962914154e"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051601615491*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"e5c9eb2b-d8f8-4951-9770-23164cb03281"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880516016403303`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"3c8a51c3-ad68-42c6-b3ea-ea872b1aafa7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "123", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 123, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880516028617077`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"ef5d363b-85bd-4067-a124-757a8039b8f9"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.888051602999263*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"1e3320ae-172b-4826-afd5-65f62fe1c36d"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, 3.609240744679184*^9, 
   3.609241218962446*^9, {3.6202291097557383`*^9, 3.620229149395722*^9}, 
   3.6202306613623667`*^9, 3.620231044920498*^9, 3.620231206488277*^9, 
   3.869229426138722*^9, 3.8697702300993643`*^9, 3.8880516035944347`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"d45ca45d-fa9c-4663-8e1f-63cc573355d3"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Local3",
WindowSize->{1920, 980},
WindowMargins->{{0, Automatic}, {Automatic, -180}},
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->FrontEnd`FileName[{$RootDirectory, "Applications", 
   "Mathematica.app", "Contents", "SystemFiles", "FrontEnd", "StyleSheets", 
   "Creative"}, "PastelColor.nb", CharacterEncoding -> "UTF-8"],
ExpressionUUID->"38648444-bfc0-4b5a-a439-804345ff3578"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 268, 6, 42, "Input",ExpressionUUID->"8f7c761c-624f-4318-b1ab-93d438c5cf80"],
Cell[CellGroupData[{
Cell[851, 30, 336, 5, 61, "Title",ExpressionUUID->"708b3756-2511-4160-8fbe-aec4faf12e29"],
Cell[CellGroupData[{
Cell[1212, 39, 396, 9, 64, "Input",ExpressionUUID->"97b19875-def0-4517-8267-6ca84ccb893c"],
Cell[CellGroupData[{
Cell[1633, 52, 316, 6, 24, "Print",ExpressionUUID->"08621f92-bf12-41e2-8294-5baa8ee38e26"],
Cell[1952, 60, 595, 13, 24, "Print",ExpressionUUID->"bb7adf4d-a17c-4150-afd1-87284e946b4f"],
Cell[2550, 75, 368, 7, 24, "Print",ExpressionUUID->"fda960f7-ec20-4c97-9b93-eb9eb1ee61bd"],
Cell[2921, 84, 304, 6, 24, "Print",ExpressionUUID->"1b127b19-6cd8-49f2-9a46-3c1530f51bc2"],
Cell[3228, 92, 313, 6, 24, "Print",ExpressionUUID->"b53acc50-095a-4ab5-9672-578a45a31f29"],
Cell[3544, 100, 365, 7, 24, "Print",ExpressionUUID->"afbf5365-e909-4dcd-b96a-b7472cc1a7f9"],
Cell[3912, 109, 365, 7, 24, "Print",ExpressionUUID->"b5460b14-ab57-4298-8440-ee1bfe03cc8a"],
Cell[4280, 118, 302, 6, 24, "Print",ExpressionUUID->"e326f61b-d540-46ca-8954-597d66e66a6b"],
Cell[4585, 126, 332, 6, 24, "Print",ExpressionUUID->"592df06d-ea2f-4864-a477-b0cee2b82697"],
Cell[4920, 134, 302, 6, 24, "Print",ExpressionUUID->"d4dcc49f-feef-4d40-b509-fe8903da3b7e"],
Cell[5225, 142, 369, 7, 24, "Print",ExpressionUUID->"296e28ab-7bf1-4412-9875-e35f7b86108c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5643, 155, 1587, 29, 127, "Input",ExpressionUUID->"c8df7060-22ce-4711-805e-6f88cc38ffa2"],
Cell[CellGroupData[{
Cell[7255, 188, 1508, 22, 24, "Print",ExpressionUUID->"e14a4eaf-bf2b-48bb-a113-a7b662665b14"],
Cell[8766, 212, 1489, 22, 24, "Print",ExpressionUUID->"3eb88960-87f2-469f-8bff-cc2d1998fc3b"],
Cell[10258, 236, 1620, 26, 24, "Print",ExpressionUUID->"b8c6b88e-9ec3-4ad9-8822-7e01c764922b"],
Cell[11881, 264, 1479, 22, 24, "Print",ExpressionUUID->"a246d1dd-e6b2-4098-82e0-70563cac7932"],
Cell[13363, 288, 1704, 25, 44, "Print",ExpressionUUID->"f07134e1-1f42-4ff6-b810-e503ee7ba8e2"],
Cell[15070, 315, 1576, 24, 44, "Print",ExpressionUUID->"62c41ef6-c395-4f2b-86c5-b7978c393ad2"],
Cell[16649, 341, 1516, 23, 24, "Print",ExpressionUUID->"c00af7c3-cba3-47f0-aa3b-a2f1dd59ccc3"],
Cell[18168, 366, 1468, 22, 24, "Print",ExpressionUUID->"fdab4bd1-d32b-44f0-9b93-53100f56a144"],
Cell[19639, 390, 1498, 22, 24, "Print",ExpressionUUID->"2de93410-6849-4fde-9289-8ea8a2418ccf"],
Cell[21140, 414, 1501, 22, 24, "Print",ExpressionUUID->"30c46df2-f1f8-4d37-83ab-cfd5f87d4648"],
Cell[22644, 438, 1499, 22, 24, "Print",ExpressionUUID->"ece6c5e5-6b0c-4a25-81a0-0d1192a30718"],
Cell[24146, 462, 1694, 28, 44, "Print",ExpressionUUID->"2e535cdc-d843-4eab-9ae8-4d1b9fbedddc"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25889, 496, 159, 3, 57, "Section",ExpressionUUID->"f4026d77-41f8-4dbe-85a5-c2703c09fa30"],
Cell[CellGroupData[{
Cell[26073, 503, 254, 4, 38, "Input",ExpressionUUID->"1da95652-fef6-400f-8949-30f65d69d630"],
Cell[26330, 509, 18897, 582, 611, "Output",ExpressionUUID->"ab491ae7-c188-462c-8093-019c8fde8531"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45276, 1097, 183, 3, 43, "Section",ExpressionUUID->"d83ab238-2cfb-44ac-b96a-d324ab9f39f1"],
Cell[CellGroupData[{
Cell[45484, 1104, 322, 6, 42, "Input",ExpressionUUID->"fbca8125-09c3-4217-ba60-89c9c37886b5"],
Cell[CellGroupData[{
Cell[45831, 1114, 408, 11, 22, "Print",ExpressionUUID->"cae79006-ac83-41d8-b30e-9004df87211d"],
Cell[46242, 1127, 163, 3, 22, "Print",ExpressionUUID->"0f6d6426-2b4b-4808-8fc3-9553e3c3d1c9"],
Cell[46408, 1132, 337, 8, 22, "Print",ExpressionUUID->"3730374d-90c1-4207-95ae-bd52d1140b61"],
Cell[46748, 1142, 196, 4, 22, "Print",ExpressionUUID->"6cc6a5b2-da59-47be-9b81-94562505b695"],
Cell[46947, 1148, 678, 15, 22, "Print",ExpressionUUID->"8a2a5d57-a94b-4237-be48-6495daf7e50b"],
Cell[47628, 1165, 278, 7, 21, "Print",ExpressionUUID->"e2a6291e-cfbc-405a-a894-5448f1f0d7dc"]
}, Open  ]],
Cell[47921, 1175, 144689, 3900, 2980, "Output",ExpressionUUID->"9330c5dc-8fcb-4a6e-a031-92f9d8097166"]
}, Closed]],
Cell[192625, 5078, 172, 3, 27, "Text",ExpressionUUID->"5046a2f6-3f50-4277-a184-5f92dd3bc900"],
Cell[CellGroupData[{
Cell[192822, 5085, 428, 7, 42, "Input",ExpressionUUID->"c7457253-dd69-4de3-afc6-2731d1e4dd81"],
Cell[CellGroupData[{
Cell[193275, 5096, 452, 12, 24, "Print",ExpressionUUID->"5ef2fe2d-13c3-4d26-9f50-6da91f7b725a"],
Cell[193730, 5110, 206, 4, 24, "Print",ExpressionUUID->"961d23b4-057e-417c-949e-221430ca9a99"],
Cell[193939, 5116, 389, 9, 24, "Print",ExpressionUUID->"fde99e35-04a3-43da-93c4-fbf17a12013c"],
Cell[194331, 5127, 240, 5, 24, "Print",ExpressionUUID->"249e36ab-6965-4648-81c1-4707ee17fdae"],
Cell[194574, 5134, 725, 16, 24, "Print",ExpressionUUID->"33b629c7-ef92-44c0-acef-994bc7f7d97b"],
Cell[195302, 5152, 324, 8, 24, "Print",ExpressionUUID->"60799b4e-3741-4b11-8d18-dc8124891e74"]
}, Open  ]],
Cell[195641, 5163, 237055, 6627, 4133, "Output",ExpressionUUID->"3a160aff-952a-4072-938c-778770e90847"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[432745, 11796, 167, 3, 43, "Section",ExpressionUUID->"424e69f1-4d4d-4439-a7f6-83a65efff36d"],
Cell[CellGroupData[{
Cell[432937, 11803, 202, 4, 38, "Input",ExpressionUUID->"77fa853a-bb3a-475a-9c4a-56b158e2f49a"],
Cell[CellGroupData[{
Cell[433164, 11811, 506, 10, 22, "Print",ExpressionUUID->"5e86b184-f6ee-44c4-9f51-ed0398d58886"],
Cell[433673, 11823, 2733, 61, 39, "Print",ExpressionUUID->"553bf564-2ab6-4fe5-b3c8-33b14c986f42"],
Cell[436409, 11886, 6287, 156, 96, "Print",ExpressionUUID->"f6290d92-b21d-4211-81fb-b3819cbe3804"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[442757, 12049, 161, 3, 43, "Section",ExpressionUUID->"72be2211-992f-4c3d-bf81-ed89a612b083"],
Cell[CellGroupData[{
Cell[442943, 12056, 518, 12, 56, "Input",ExpressionUUID->"782909e4-c896-4463-a47e-56711bad724e"],
Cell[CellGroupData[{
Cell[443486, 12072, 572, 13, 22, "Print",ExpressionUUID->"c662a726-405a-4f2d-b347-1f39b2008980"],
Cell[444061, 12087, 327, 5, 22, "Print",ExpressionUUID->"3b5620bb-85fa-47bf-af01-4c70d97495c8"],
Cell[444391, 12094, 499, 10, 22, "Print",ExpressionUUID->"7c94993d-7a8d-4dbb-b680-7aa8629fc68e"],
Cell[444893, 12106, 358, 6, 22, "Print",ExpressionUUID->"f34a7c38-16bf-4f06-b3b2-e7a95de5495f"],
Cell[445254, 12114, 842, 17, 22, "Print",ExpressionUUID->"5c7fda6c-1c12-4bca-8365-a7078ca6cec7"],
Cell[446099, 12133, 440, 9, 21, "Print",ExpressionUUID->"a86307d7-8b74-409b-a61f-6fce5ee4aa2a"],
Cell[446542, 12144, 791, 15, 22, "Print",ExpressionUUID->"c1433bc5-f289-443f-819c-4cdabf31a987"],
Cell[447336, 12161, 606, 14, 22, "Print",ExpressionUUID->"60380b83-c179-45be-bd49-5acde4da46d9"],
Cell[447945, 12177, 561, 13, 21, "Print",ExpressionUUID->"397ae2c2-f711-4a72-b7b9-c652ee57a8b9"],
Cell[448509, 12192, 563, 13, 21, "Print",ExpressionUUID->"3bb58190-34a4-4da2-9b5e-bfa87eae72c8"],
Cell[449075, 12207, 522, 11, 21, "Print",ExpressionUUID->"7e737133-a92c-4d5b-9472-9d27992f0f22"],
Cell[449600, 12220, 519, 11, 21, "Print",ExpressionUUID->"497320cb-08a8-4873-bf47-d5dde0a78b39"],
Cell[450122, 12233, 515, 11, 21, "Print",ExpressionUUID->"60db431a-5364-4042-bab5-ccaa7e5cf036"],
Cell[450640, 12246, 515, 11, 21, "Print",ExpressionUUID->"3f7b9571-9ded-4da2-a0b3-b622cf01d03f"],
Cell[451158, 12259, 515, 11, 21, "Print",ExpressionUUID->"962e6656-876b-4bb2-8f16-6054623b37c0"],
Cell[451676, 12272, 528, 11, 22, "Print",ExpressionUUID->"8c88aa63-5375-4aef-8567-20016e24e1e4"]
}, Open  ]]
}, Open  ]],
Cell[452231, 12287, 144, 3, 29, "Text",ExpressionUUID->"97f95f7d-e9bd-4287-bcb2-6b6f17d9973e"]
}, Closed]],
Cell[CellGroupData[{
Cell[452412, 12295, 158, 3, 43, "Section",ExpressionUUID->"1c91b8f2-e506-4a92-b156-e13b9edf55df"],
Cell[CellGroupData[{
Cell[452595, 12302, 456, 8, 64, "Input",ExpressionUUID->"b6f8b729-6a26-4a65-82b5-59694437b506"],
Cell[453054, 12312, 862, 12, 42, "Output",ExpressionUUID->"1b6f6e60-dc33-4e27-bec4-966f6d492dbf"],
Cell[CellGroupData[{
Cell[453941, 12328, 711, 12, 24, "Print",ExpressionUUID->"64fae88e-73ff-46af-af09-1fcefcb54bb5"],
Cell[454655, 12342, 934, 19, 24, "Print",ExpressionUUID->"12074a05-2daa-49c9-8af2-02199e4605e3"],
Cell[455592, 12363, 686, 11, 24, "Print",ExpressionUUID->"1e17d6e4-b922-4222-ba35-7b3b43597286"],
Cell[456281, 12376, 869, 16, 24, "Print",ExpressionUUID->"7d1014c7-d20a-422d-8c84-dcb316381f01"],
Cell[457153, 12394, 722, 12, 24, "Print",ExpressionUUID->"a6e59c67-5bb5-4ea3-812b-016cee9bd481"],
Cell[457878, 12408, 1205, 23, 24, "Print",ExpressionUUID->"d050486f-e245-45fb-ad98-0e0d90ec2ffa"],
Cell[459086, 12433, 804, 15, 24, "Print",ExpressionUUID->"635b6daf-18c6-4c11-b4ad-cd4d486f4ea0"],
Cell[459893, 12450, 1160, 22, 24, "Print",ExpressionUUID->"c9f9bba2-ef11-47cd-9dcb-ac553511bed6"],
Cell[461056, 12474, 701, 11, 24, "Print",ExpressionUUID->"c9881ad9-f0da-440e-9d68-d488fda0b74d"],
Cell[461760, 12487, 968, 20, 24, "Print",ExpressionUUID->"dde68808-14b7-4a62-ae17-4d69de968075"],
Cell[462731, 12509, 924, 19, 24, "Print",ExpressionUUID->"46ce0cbd-626d-497a-891b-6890dcb65802"],
Cell[463658, 12530, 902, 16, 24, "Print",ExpressionUUID->"0e4fc57d-903b-4ab2-914c-bcc03a8c38ea"],
Cell[464563, 12548, 924, 19, 24, "Print",ExpressionUUID->"1f6baee2-9868-4f82-8b08-493d91ccf4fb"],
Cell[465490, 12569, 886, 16, 24, "Print",ExpressionUUID->"634635a5-d9b3-4b11-841f-6d0b6a6316bd"],
Cell[466379, 12587, 686, 11, 24, "Print",ExpressionUUID->"39001d62-059d-437c-b4be-8e962914154e"],
Cell[467068, 12600, 708, 12, 24, "Print",ExpressionUUID->"e5c9eb2b-d8f8-4951-9770-23164cb03281"],
Cell[467779, 12614, 901, 16, 24, "Print",ExpressionUUID->"3c8a51c3-ad68-42c6-b3ea-ea872b1aafa7"],
Cell[468683, 12632, 1060, 19, 24, "Print",ExpressionUUID->"ef5d363b-85bd-4067-a124-757a8039b8f9"],
Cell[469746, 12653, 680, 11, 24, "Print",ExpressionUUID->"1e3320ae-172b-4826-afd5-65f62fe1c36d"],
Cell[470429, 12666, 667, 11, 24, "Print",ExpressionUUID->"d45ca45d-fa9c-4663-8e1f-63cc573355d3"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

