(***************************************************************************************************************)
(******                       This is the FeynRules mod-file for the Abelian higgs model                  ******)
(******                                                                                                   ******)
(******     Authors: C. Duhr                                                                              ******)
(******                                                                                                   ******)
(***************************************************************************************************************)

M$ModelName = "HAHM_variablesw_v2";


M$Information = {Authors -> {"C. Duhr, David Curtin"}, 
             Date -> "02. 06. 2009",
             Institutions -> {"Universite catholique de Louvain (CP3), YITP Stony Brook"},
             Emails -> {"claude.duhr@uclouvain.be, david.r.curtin@gmail.com"},
             Version -> "1.5",
             References -> "  J. D. Wells, \"How to Find a Hidden World at the Large Hadron Collider,\", [arXiv:0803.1243 [hep-ph]]",
             URLs   -> "http://feynrules.phys.ucl.ac.be/view/Main/HiddenAbelianHiggsModel"};

(*
   v1.1: changed name for full Lagrangian from LSM to LHAHM
   v1.2: Benj: the lambda parameter had the same name as the leptons, which was making the code crashing.
   v1.3: David Curtin: fixed typos in definition of chi, mu_SM, mu_H and X -> Xp, Bp transformation 
   v1.4: David Curtin: added ggh and gagah effective vertices from effectiveSM FR model
   release v1 = v1.5: David Curtin: adding fully consistent treatment of mZ, mZd, and full higgs/Z mass eigenstates as input parameters. 
   release v2: David Curtin: added electron and muon yukawas, so that h->2a->2b2mu etc can be simulated.
*)

(* The U(1)X charge of the abelian Higgs is a free parameter *)

qX = 1;


(*
NOTE: 
if we take the effect of Z-Zd mixing into account fully consistently, then mZ0 (the Z mass 
before kinetic mixing with the U(1)X gauge boson) does not have to equal mZ (the mass of 
the mass eigenstate that is dominantly Z). 

This means that the SM tree-level relation Cos[Theta_w] = mW/mZ receives a correction, 
since the actual relationship is cw = mW/mZ0. 

If the kinetic mixing parameter is  too large, this model is then in conflict with 
electroweak precision constraints. However, if it is allowed, then there is a genuine
ambiguity as to where to 'push' this shift in parameters from the SM-best-fit value.

In this instance of the HAHM model we push that change into sw, setting the W mass to its
measured SM value and letting sw be an input.

Tiny wrinkle: in the notation of our higgs survey document, chi = epsilon/cw. Since our 
definition of epsilon is purely for convenience (the weak angle is unlikely to actually
appear in the kinetic mixing dynamically) we convert between epsilon and chi using
the SM value for sw. The shift between sw and swSM is tiny, so this will not make
any noticeable difference, and again it is purely notational only.

Philosophically speaking, this model should only be used for kinetic mixing below
the electroweak precision bound.
*)




(******* Index definitions ********)

IndexRange[ Index[Generation] ] = Range[3]

IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]

IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]

IndexRange[ Index[SU2W] ] = Unfold[Range[3]]


IndexStyle[Colour, i]

IndexStyle[Generation, f]

IndexStyle[Gluon ,a]

IndexStyle[SUW2 ,k]


(******* Gauge parameters (for FeynArts) ********)

GaugeXi[ V[1] ] = GaugeXi[A];
GaugeXi[ V[2] ] = GaugeXi[Z];
GaugeXi[ V[3] ] = GaugeXi[W];
GaugeXi[ V[4] ] = GaugeXi[G];
GaugeXi[ S[1] ] = 1;
GaugeXi[ S[2] ] = GaugeXi[Z];
GaugeXi[ S[3] ] = GaugeXi[W];
GaugeXi[ U[1] ] = GaugeXi[A];
GaugeXi[ U[2] ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4] ] = GaugeXi[G];



(******************loop functions for effective ggh and gagah couplings****************************)

sert[x_] := 1+ 7/30 x + 2/21 x^2 + 26/525 x^3;

serw[xw_, xt_] := 1 + xw * 66/235 +xw^2 * 228/1645 + xw^3 * 696/8225 +
            xw^4 * 5248/90475 +xw^5 * 1280/29939+ xw^6 * 54528/1646645- 
            xt * 56/705 - xt^2 * 32/987;

serp[x_] := 1 + x/3 + x^2 * 8/45 + x^3 * 4/35;



(*HACK IN A SIGN FUNCTION THAT (hopefully) FR/PYTHON UNDERSTANDS?*)

MySign[x_]:=(2/Pi) ArcTan[(10^100) x];

(*the relative numerical error on this for |x| = 10^-n is less than 10^(100-n),
so for x = 10^-10 the relative numerical error is < 10^-90 *)

(****************  Parameters *************)

M$Parameters = {

  (* External parameters *)
  
  
  (* DARK SECTOR PARAMS *)
  (*******************************************)
  (*******************************************)
  (*******************************************)
  
  mZDinput == {
		ParameterType -> External,
	   BlockName -> HIDDEN,
	   ParameterName -> mZDinput,
	   Value -> 20,
	   Description -> "Zd mass AFTER mixing (i.e. the mass eigenvalue)"},


   MHSinput == {
        ParameterType -> External,
        BlockName -> HIDDEN,
        ParameterName -> MHSinput,
        Value -> 200,
        Description -> "Singlet-like Higgs mass AFTER mixing (i.e. the mass eigenvalue)"},


   epsilon == {
        ParameterType -> External,
        BlockName -> HIDDEN,
        ParameterName -> epsilon,
        Value -> 0.01,
        Description -> "U(1)X - U(1)Y kinetic mixing parameter in SURVEY BASIS = chi * Cos[theta_w] in Well's basis"},

 
   \[Kappa] == {
        ParameterType -> External,
        BlockName -> HIDDEN,
        ParameterName -> kap,
        Value -> 0.000000001,
        InteractionOrder -> {QED, 2},
        Description -> "Coupling between the abelian and the SM Higgs: SAME AS ZETA IN SURVEY BASIS"},   
        
    
  (*******************************************)
  (*******************************************)    
  (*******************************************)
    
	(*this parameter doesn't matter once we fix mZd*)
	
  \[Alpha]XM1 == {
        ParameterType -> External,
        BlockName -> HIDDEN,
        ParameterName -> aXM1,
        InteractionOrder -> {QED, -2},
        Value -> 127.9,
        Description -> "Inverse of the U(1)X coupling constant"},
        
   
	   
  (*SM PARAMS*)


  swsqSM == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        Value -> 0.2250,
        Description -> "Sin[Theta_w] SM value"},




  \[Alpha]EWM1== {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEWM1,
        InteractionOrder -> {QED, -2},
        Value -> 127.9,
        Description -> "Inverse of the electroweak coupling constant"},

  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        InteractionOrder -> {QED, 2},
        Value -> 1.16639 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.118,
        Description -> "Strong coupling constant at the Z pole."},


  ymc == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.42,
        OrderBlock -> {4},
        Description -> "Charm Yukawa mass"},

 ymb == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 4.7,
        OrderBlock -> {5},
        Description -> "Bottom Yukawa mass"},

  ymt == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 174.3,
        OrderBlock -> {6},
        Description -> "Top Yukawa mass"},

  ymtau == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau Yukawa mass"},

  ymel == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 0.000511,
        OrderBlock -> {16},
        Description -> "Electron Yukawa mass"},

  ymmu == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 0.1057,
        OrderBlock -> {17},
        Description -> "Muon Yukawa mass"},




   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        OrderBlock -> {1},
        Value -> 0.488,
        Description -> "Cabibbo angle"},

  mZinput == {
  		 ParameterType -> External,
        BlockName -> GAUGEMASS,
        ParameterName -> mZinput,
        Value -> 91.188,
        Description -> "Z mass AFTER mixing, i.e. the mass eigenstate"},
        
 
        
   MHinput == {
        ParameterType -> External,
        BlockName -> HIGGS,
        ParameterName -> MHinput,
        Value -> 125,
        Description -> "SM Higgs mass AFTER mixing, i.e. the mass eigenstate"},


    MWinput == {
        ParameterType -> External,
        BlockName -> GAUGEMASS,
        ParameterName -> MWinput,
        Value ->  80.419,
        Description -> "measured value of W mass in SM"},


      
        


   (* Internal Parameters *)



 (********************************************)
  (*parameters for effective ggh and gagah vertices*)
  (*********************************************)  
  
  
  AH == {TeX -> Subscript[A, H],
       ParameterType -> Internal,
       InteractionOrder -> {HIW, 1},
       Value -> ee^2/4/Pi/(Pi*v)*(47/18)*serw[(MH/2/MW)^2, (MH/2/MT)^2]},

GH == {TeX -> Subscript[G, H],
       ParameterType -> Internal,
       InteractionOrder -> {HIG, 1},
       Value -> -gs^2/(4Pi(3Pi v)) sert[(MH/2/MT)^2] },

Gphi == {TeX -> Subscript[G, h],
       ParameterType -> Internal,
       InteractionOrder -> {HIG, 1},
       Value -> -gs^2/4/Pi/(2*Pi*v)*serp[(MH/2/MT)^2]},


        
        
(* Weak Mixing *)


   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> MW/MZ0,
        Description -> "Cos of the Weinberg angle"},  

   sw == {
        TeX -> Subscript[s, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - cw^2],
        Description -> "Sin of the Weinberg angle"},
        




(* Gauge couplings *)
  
  \[Alpha]EW == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]EWM1,
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Description -> "Electroweak coupling constant"},

   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},

   gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Value -> ee / sw,
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Value -> ee / cw,
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},

  \[Alpha]X == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]XM1,
        ParameterName -> aX,
        InteractionOrder -> {QED, 2},
        Description -> "U(1)X coupling contant"},

   gX == {
        TeX -> Subscript[g, X],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]X],
        InteractionOrder -> {QED, 1},
        Description -> "U(1)X coupling constant"},

(* New scales *)


       
  MZ0 == {
       ParameterType -> Internal,
       Value -> Sqrt[(mZDinput^2 + mZinput^2 + MW^2 \[Eta]^2 - 
 MySign[mZDinput - 
    mZinput] Sqrt[-4 mZDinput^2 mZinput^2 (1 + \[Eta]^2) + \
(mZDinput^2 + mZinput^2 + MW^2 \[Eta]^2)^2])/(1 + \[Eta]^2)]/Sqrt[2],
       Description -> "Z mass BEFORE mixing"}, 		


  \[CapitalDelta]Z =={
       ParameterType -> Internal,
       Value -> ((1 + \[Eta]^2) (mZDinput^2 + mZinput^2 + MW^2 \[Eta]^2 + 
   MySign[mZDinput - 
      mZinput] Sqrt[-4 mZDinput^2 mZinput^2 (1 + \[Eta]^2) + \
(mZDinput^2 + mZinput^2 + 
       MW^2 \[Eta]^2)^2]))/(mZDinput^2 + mZinput^2 + MW^2 \[Eta]^2 - 
 MySign[mZDinput - 
    mZinput] Sqrt[-4 mZDinput^2 mZinput^2 (1 + \[Eta]^2) + \
(mZDinput^2 + mZinput^2 + MW^2 \[Eta]^2)^2]),
       ParameterName -> DZ,
       Description -> "Ratio of scales"},



  MX =={
       ParameterType -> Internal,
       Value -> Sqrt[\[CapitalDelta]Z]* MZ0,
       Description -> "X mass BEFORE mixing"},



       
  MZ == {
       ParameterType -> Internal,
       Value -> mZinput,
       Description -> "Z mass AFTER mixing"}, 	
       
  MZp == {
       ParameterType -> Internal,
       Value -> mZDinput,
       Description -> "Z mass AFTER mixing"}, 		
       

        
(*W mass is an output*)

 MW == {
        TeX -> Subscript[M, W],
        ParameterType -> Internal,
        Value -> MWinput,
        Description -> "W mass"},  





(* Higgs sector *)

  MH == {
       ParameterType -> Internal,
       Value -> MHinput,
       Description -> "SM higgs mass AFTER mixing"}, 	
       
  MHS == {
       ParameterType -> Internal,
       Value -> MHSinput,
       Description -> "abelian higgs mass AFTER mixing"}, 		
       

  v == {
        ParameterType -> Internal,
        Value -> 1/Sqrt[Gf* Sqrt[2]],
        InteractionOrder -> {QED, -1},
        Description -> "SM Higgs VEV"},

  \[Xi] == {
        ParameterType -> Internal,
        Value -> MX Sqrt[1 - \[Chi]^2] /(qX gX),
        InteractionOrder -> {QED, -1},
        ParameterName -> xi,
        Description -> "Abelian Higgs VEV"},
  
  
  \[Lambda] == {
        ParameterType -> Internal,
        ParameterName -> lam,
        Value -> (MHinput^2 + MHSinput^2 + 
 Sqrt[(MHinput^2 - MHSinput^2)^2 - 4 v^2 \[Kappa]^2 \[Xi]^2]
   MySign[MHinput - MHSinput])/(4 v^2),
        InteractionOrder -> {QED, 2},
        Description -> "SM Higgs self-coupling"},



  \[Rho] == {
        ParameterType -> Internal,
        ParameterName -> rho,
        Value -> (MHinput^2 + MHSinput^2 - 
 Sqrt[(MHinput^2 - MHSinput^2)^2 - 4 v^2 \[Kappa]^2 \[Xi]^2]
   MySign[MHinput - MHSinput])/(4 \[Xi]^2),
        InteractionOrder -> {QED, 2},
        Description -> "Abelian Higgs self-coupling"},
        



(*CORRECTED TYPOS HERE*)

  \[Mu]SM2 =={
        TeX -> Subsuperscript[\[Mu], SM, 2],
        ParameterType -> Internal,
        Value ->  v^2 \[Lambda] + (\[Kappa] \[Xi]^2)/2,
        ParameterName -> muSM2,
        Description -> "Quadratic SM potential term"},

  \[Mu]H2 =={
        TeX -> Subsuperscript[\[Mu], H, 2],
        ParameterType -> Internal,
        Value ->  (v^2 \[Kappa])/2 + \[Xi]^2 \[Rho],
        ParameterName -> muH2,
        Description -> "Quadratic abelian potential term"},

(* Mixing parameters *)
  

   ta == {
        TeX -> Subscript[t, \[Alpha]],
        ParameterType -> Internal,
        Value ->  -((-1 + \[CapitalDelta]Z + sw^2 \[Eta]^2 - 
  Sqrt[4 sw^2 \[Eta]^2 + (-1 + \[CapitalDelta]Z + sw^2 \[Eta]^2)^2]
    MySign[-1 + \[CapitalDelta]Z])/(2 sw \[Eta])),
        Description -> "Tan of Z-Zd mixing angle"},

   ca == {
        TeX -> Subscript[c, \[Alpha]],
        ParameterType -> Internal,
        Value -> (1 + ta^2)^(-1/2),
        Description -> "Cosine of alp"},

   sa == {
        TeX -> Subscript[s, \[Alpha]],
        ParameterType -> Internal,
        Value -> ta (1 + ta^2)^(-1/2),
        Description -> "Sine of alp"},


(*FIXED DEFINITION OF CHI *)



	(*expressing the wells mixing parameter eta or chi in terms of our epsilon from exotic higgs decay survey*)

   \[Eta] == {
        ParameterType -> Internal,
        Value -> (epsilon/Sqrt[1 - swsqSM])/Sqrt[1 - (epsilon/Sqrt[1 - swsqSM])^2] ,
        ParameterName -> eta,
        Description -> "U(1)X - U(1)Y mixing parameter"},


   \[Chi] == {
        ParameterType -> Internal,
        Value -> \[Eta]/Sqrt[1 + \[Eta]^2],
        ParameterName -> chi,
        Description -> "kinetic mixing parameter"},

(* Higgs *)
(* updated mixing definition to make it work for MS < MH and also so that H is always the first mass eigenvalue *)
        
        
   th == {
        TeX -> Subscript[t, h],
        ParameterType -> Internal,
        Value -> (-MHinput^2 + MHSinput^2 + 
 MySign[MHinput - MHSinput] Sqrt[(MHinput^2 - MHSinput^2)^2 - 
   4 v^2 \[Kappa]^2 \[Xi]^2])/(2 v \[Kappa] \[Xi]),
        Description -> "Tan of theta_h, the mixing angle in the Higgs sector"},

        

        
   ch == {
        TeX -> Subscript[c, h],
        ParameterType -> Internal,
        Value -> (1+th^2)^(-1/2),
        Description -> "Cosine of theta_h"},

   sh == {
        TeX -> Subscript[s, h],
        ParameterType -> Internal,
        Value -> th (1+th^2)^(-1/2),
        Description -> "Sine of theta_h"},
        
(* Yukawa sector *)

    yl == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yl[1] -> Sqrt[2] ymel / v, yl[2] -> Sqrt[2] ymmu/v, yl[3] -> Sqrt[2] ymtau / v},
        ParameterName -> {yl[1] -> ye, yl[2] -> ym, yl[3] -> ytau},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "Lepton Yukawa coupling"},


   yu == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yu[1] -> 0, yu[2] -> Sqrt[2] ymc / v, yu[3] -> Sqrt[2] ymt / v},
        ParameterName -> {yu[1] -> yu, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yu[1] -> 0},
        Description -> "U-quark Yukawa coupling"},

   yd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yd[1] -> 0, yd[2] -> 0, yd[3] -> Sqrt[2] ymb / v},
        ParameterName -> {yd[1] -> yd, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Definitions -> {yd[1] -> 0, yd[2] -> 0},
        Description -> "D-quark Yukawa coupling"},


  CKM == {
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Definitions -> {CKM[3, 3] -> 1,
                       CKM[i_, 3] :> 0 /; i != 3,
                       CKM[3, i_] :> 0 /; i != 3},
       Value -> {CKM[1,2] -> Sin[cabi],
                   CKM[1,1] -> Cos[cabi],
                   CKM[2,1] -> -Sin[cabi],
                   CKM[2,2] -> Cos[cabi]},
       Description -> "CKM-Matrix"}



}


(************** Gauge Groups ******************)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> g1},

  U1X == {
        Abelian -> True,
        GaugeBoson -> X,
        Charge -> QX,
        CouplingConstant -> ee},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> Eps,
        CouplingConstant -> gw},

  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        SymmetricTensor -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}
}

(********* Particle Classes **********)

M$ClassesDescription = {

(********** Fermions ************)
	(* Leptons (neutrino): I_3 = +1/2, Q = 0 *)
  F[1] == {
        ClassName -> vl,
        ClassMembers -> {ve,vm,vt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
	PropagatorLabel -> {"v", "ve", "vm", "vt"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
  F[2] == {
        ClassName -> l,
        ClassMembers -> {e, m, tt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
	Mass -> {Ml, {ME, 0}, {MM, 0}, {MTA, 1.777}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
	PropagatorLabel -> {"l", "e", "m", "tt"},
	PropagatorType -> Straight,
        ParticleName -> {"e-", "m-", "tt-"},
        AntiParticleName -> {"e+", "m+", "tt+"},
	PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
  F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Mu, {MU, 0}, {MC, 1.42}, {MT, 174.3}},
        Width -> {0, 0, {WT, 1.50833649}},
	QuantumNumbers -> {Q -> 2/3},
	PropagatorLabel -> {"uq", "u", "c", "t"},
	PropagatorType -> Straight,
	PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
  F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Md, {MD, 0}, {MS, 0}, {MB, 4.7}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1/3},
	PropagatorLabel -> {"dq", "d", "s", "b"},
	PropagatorType -> Straight, 
	PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },

(********** Ghosts **********)

 	U[1] == {
       ClassName -> ghG,
       SelfConjugate -> False,
       Indices -> {Index[Gluon]},
       Ghost -> G,
       Mass -> 0,
       Width -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uG,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},


(************ Gauge Bosons ***************)
	(* Gauge bosons: Q = 0 *)
  V[1] == {
        ClassName -> A,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
        Width -> 0,
	PropagatorLabel -> "a",
	PropagatorType -> W,
	PropagatorArrow -> None,
        PDG -> 22,
        FullName -> "Photon" },

  V[21] == {
        ClassName -> Z,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZ, Internal},
        Width -> {WZ, 2.44140351},
	PropagatorLabel -> "Z",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 23,
        FullName -> "Z" },

  V[22] == {
        ClassName -> Zp,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZp, Internal},
        Width -> {WZp, 0.0008252},
	PropagatorLabel -> "Zp",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 1023,
        FullName -> "Zp" },

  V[210] == {
        ClassName -> Bp,
	SelfConjugate -> True,
        Unphysical -> True, 
	Indices -> {},
	Mass -> 0,
        Width -> 0,
        Definitions -> {Bp[mu_] :> cw A[mu] -sw ca Z[mu] + sw sa Zp[mu]}},

  V[220] == {
        ClassName -> Xp,
	SelfConjugate -> True,
        Unphysical -> True, 
	Indices -> {},
	Mass -> 0,
        Width -> 0,
        Definitions -> {Xp[mu_] :> sa Z[mu] + ca Zp[mu]}},


	(* Gauge bosons: Q = -1 *)
  V[3] == {
        ClassName -> W,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
        Width -> {WW, 2.04759951},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "W",
	PropagatorType -> Sine,
	PropagatorArrow -> Forward,
	ParticleName ->"W+",
	AntiParticleName ->"W-",
        PDG -> 24,
        FullName -> "W" },

V[4] == {
        ClassName -> G,
	SelfConjugate -> True,
	Indices -> {Index[Gluon]},
	Mass -> 0,
        Width -> 0,
        PropagatorLabel -> G,
	PropagatorType -> C,
	PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "G" },

V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> -cw sa Zp[mu] + cw ca  Z[mu] + sw A[mu]},
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0,
        PDG -> {1,2,3}},

V[6] == {
        ClassName -> B,
	SelfConjugate -> True,
        Definitions -> {B[mu_] -> Bp[mu] + \[Eta] Xp[mu]},
	Indices -> {},
	Mass -> 0,
        Unphysical -> True},

(*CHANGED eta * chi to eta/chi *)

V[61] == {
        ClassName -> X,
	SelfConjugate -> True,
        Definitions -> {X[mu_] -> \[Eta]/\[Chi] Xp[mu]},
	Indices -> {},
	Mass -> 0,
        Unphysical -> True},


(************ Scalar Fields **********)
	(* physical Higgs: Q = 0 *) 
  S[11] == {
        ClassName -> h,
	SelfConjugate -> True,
	Mass -> {MH, Internal},
        Width -> {WH, 0.00282299},
	PropagatorLabel -> "h",
	PropagatorType -> D,
	PropagatorArrow -> None,
        PDG -> 25,
        FullName -> "h" },

  S[12] == {
        ClassName -> hs,
	SelfConjugate -> True,
	Mass -> {MHS, Internal},
        Width -> {WHS, 5.23795},
	PropagatorLabel -> "hs",
	PropagatorType -> D,
	PropagatorArrow -> None,
        PDG -> 35,
        FullName -> "hs" },

 
	S[110] == {
        ClassName -> H,
	SelfConjugate -> True,
        Unphysical -> True,
        Definitions -> {H -> ch h + sh hs}},

  S[120] == {
        ClassName -> phih,
	SelfConjugate -> False,
        Unphysical -> True,
        Definitions -> {phih -> (\[Xi] - sh h + ch hs)/Sqrt[2] }}

}



(*****************************************************************************************)

(* SM Lagrangian *)

(******************** Gauge F^2 Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LGauge = -1/4 (del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw Eps[i1, i2, i3] Wi[mu, i2] Wi[nu, i3])*
 					(del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw Eps[i1, i4, i5] Wi[mu, i4] Wi[nu, i5]) -
	
	1/4 (del[B[nu], mu] - del[B[mu], nu])^2 - 1/4 (del[X[nu], mu] - del[X[mu], nu])^2 +
        \[Chi]/2 (del[X[nu], mu] - del[X[mu], nu]) (del[B[nu], mu] - del[B[mu], nu]) -
	
	1/4 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3])*
 		 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a4, a5] G[mu, a4] G[nu, a5]);


(********************* Fermion Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

    Lkin = I uqbar.Ga[mu].del[uq, mu] + 
    	I dqbar.Ga[mu].del[dq, mu] + 
    	I lbar.Ga[mu].del[l, mu] + 
    	I vlbar.Ga[mu].del[vl, mu];

    LQCD = gs (uqbar.Ga[mu].T[a].uq + 
    	dqbar.Ga[mu].T[a].dq)G[mu, a];

    LBright = 
       -2ee/cw B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
    	4ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjP.uq -       (*Y_uR=4/3*)
    	2ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjP.dq;        (*Y_dR=-2/3*)

    LBleft = 
     -ee/cw B[mu]/2 vlbar.Ga[mu].ProjM.vl -          (*Y_LL=-1*)
    	ee/cw B[mu]/2 lbar.Ga[mu].ProjM.l  +           (*Y_LL=-1*)
    	ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjM.uq +        (*Y_QL=1/3*)
    	ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjM.dq ;        (*Y_QL=1/3*)
	
	LWleft = ee/sw/2(
	   vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
    	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
    	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+
    	
    	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
    	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
    	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
    	);

    Lkin + LQCD + LBright + LBleft + LWleft];

(******************** Higgs Lagrangian terms****************************)
 Phi :=  {0, (v + H)/Sqrt[2]};
 Phibar := {0, (v + H)/Sqrt[2]};
 

    
 LHiggs := Block[{PMVec, WVec, Dc, Dcbar, Vphi},
    
    PMVec = Table[PauliSigma[i], {i, 3}];   
    Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

	(*Y_phi=1*)
    Dc[f_List, mu_] := I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 (Wvec[mu].PMVec).f;
    Dcbar[f_List, mu_] := -I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 f.(Wvec[mu].PMVec);

    Dc[phih, mu_] := del[phih, mu] -I gX qX X[mu] phih;
    Dc[phihbar, mu_] := del[phihbar, mu] +I gX qX X[mu] phihbar;

    Vphi[Phi2SM_, Phi2H_] := -\[Mu]SM2 Phi2SM + \[Lambda] (Phi2SM)^2 -
              \[Mu]H2 Phi2H + \[Rho] (Phi2H)^2 +
              \[Kappa] (Phi2H) (Phi2SM) ;

    (* The value of qX is set at the beginning of the notebook *)

    (Dcbar[Phibar, mu]).Dc[Phi, mu] + Dc[phihbar,mu] Dc[phih, mu] - Vphi[Phibar.Phi, phihbar phih]];
  
  
  
(*************** Yukawa Lagrangian***********************)
LYuk :=    Module[{s,r,n,m,i},                                                    -
	      yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+H)/Sqrt[2]  -
	      yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+H)/Sqrt[2]  -
	      yl[n]               lbar[s,n].ProjP[s,r].l[r,n]      (v+H)/Sqrt[2]
           ]

LYukawa := LYuk + HC[LYuk];



(**************Ghost terms**************************)
(* Now we need the ghost terms which are of the form:             *)
(* - g * antighost * d_BRST G                                     *)
(* where d_BRST G is BRST transform of the gauge fixing function. *)

LGhost := 
		Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];
 			 	
	(***********Now add the pieces together.********************)
	LGhostG]


(*include ggh and gagah effective vertices*)
LCPEven := -1/4 GH FS[G, mu, nu, b] FS[G, mu, nu, b] H - 1/4 AH FS[A, mu, nu] FS[A, mu, nu] H;
		
(*********Total SM Lagrangian*******)	 	
LHAHM := LGauge + LHiggs + LFermions + LYukawa  + LGhost + LCPEven;
		
		
