(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    232295,       5957]
NotebookOptionsPosition[    227828,       5822]
NotebookOutlinePosition[    228373,       5841]
CellTagsIndexPosition[    228330,       5838]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.605939383914187*^9, 3.605939389600998*^9}, {
  3.609154670325432*^9, 3.609154671020789*^9}}],

Cell[CellGroupData[{

Cell["\<\
The Hidden Abelian Higgs model with variable sw\
\>", "Title",
 CellChangeTimes->{{3.411915778286763*^9, 3.4119157817267313`*^9}, {
  3.413720856398858*^9, 3.413720856723679*^9}, {3.509778928631168*^9, 
  3.509778939699687*^9}, {3.609239767121204*^9, 3.609239768579833*^9}, {
  3.609240186678101*^9, 3.6092401878596163`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\</Users/davidcurtin/Documents/uni/Research/Collider_Physics/FeynRules_\
2.0/feynrules-current\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
   "modeldir", "=", 
    "\"\</Users/davidcurtin/Dropbox/Research_db/SharedZZD/david/hidden_\
abelian_higgs_model_final/HAHM_MGmodel_v2/\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"modelfile", "=", "\"\<HAHM_final_variablesw.fr\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{"modeldir", "<>", "modelfile"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.605249872680089*^9, {3.6053061313866796`*^9, 3.60530613146021*^9}, 
   3.605311257985278*^9, {3.605569568908189*^9, 3.605569570006483*^9}, {
   3.605572782711409*^9, 3.605572782965074*^9}, {3.6059393763057947`*^9, 
   3.605939391935643*^9}, {3.605940425194668*^9, 3.605940426910673*^9}, {
   3.605940676225548*^9, 3.605940696567214*^9}, {3.6059414342043257`*^9, 
   3.605941434348999*^9}, {3.6066476428102818`*^9, 3.606647654077117*^9}, {
   3.6066706011086597`*^9, 3.606670601274888*^9}, {3.6067471860389633`*^9, 
   3.6067471861784973`*^9}, {3.6091545943945932`*^9, 3.609154607763337*^9}, 
   3.609156687900199*^9, {3.60915816116991*^9, 3.609158251613903*^9}, {
   3.6091583284081697`*^9, 3.6091583402865334`*^9}, {3.60915850356952*^9, 
   3.609158506558864*^9}, {3.6092396745509787`*^9, 3.609239689023221*^9}, {
   3.609240193999422*^9, 3.609240194350603*^9}, 3.620229253591846*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307711040363`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.0.23\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"26 March 2014\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.0.23", " (" "26 March 2014", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771106572*^9}}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307711092033`*^9}}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771111094*^9}}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771112619*^9}}],

Cell[BoxData["\<\"    - arXiv:1310.1921;\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771114134*^9}}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771116454*^9}}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771118087*^9}}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307711194887`*^9}}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771120947*^9}}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230771122457*^9}}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307720024223`*^9}}],

Cell[BoxData["\<\"C. Duhr, David Curtin\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772003869*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.5\"\>"}],
  SequenceForm["Model Version: ", "1.5"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772005363*^9}}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772006988*^9}}],

Cell[BoxData["\<\"  J. D. Wells, \\\"How to Find a Hidden World at the Large \
Hadron Collider,\\\", [arXiv:0803.1243 [hep-ph]]\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772008584*^9}}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be/view/Main/\
HiddenAbelianHiggsModel\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772010077*^9}}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772011607*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772013129*^9}}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307720146847`*^9}}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.620230772122011*^9}}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307721510763`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"HAHM_variablesw_v2\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "HAHM_variablesw_v2", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.609240573672839*^9, 
   3.609240643108274*^9, 3.60924070537428*^9, 3.609241249132338*^9, {
   3.62022924337332*^9, 3.620229297379374*^9}, {3.620230710410858*^9, 
   3.6202307722005987`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.411915790793332*^9, 3.411915793199389*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LHAHM"], "Input",
 CellChangeTimes->{{3.4119143176932583`*^9, 3.411914319401045*^9}, {
  3.509778966781176*^9, 3.509778967770995*^9}, {3.509779355012743*^9, 
  3.509779370460802*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", "phih", " ", 
   SuperscriptBox["phih", "\[Dagger]"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "2"], " ", "\[Kappa]"}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "4"], " ", "\[Lambda]"}], "+", 
  RowBox[{"phih", " ", 
   SuperscriptBox["phih", "\[Dagger]"], " ", 
   TemplateBox[{"\[Mu]","H","2"},
    "Subsuperscript"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
   TemplateBox[{"\[Mu]","SM","2"},
    "Subsuperscript"]}], "-", 
  RowBox[{
   SuperscriptBox["phih", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["phih", "\[Dagger]"], ")"}], "2"], " ", "\[Rho]"}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["A", "H"], " ", "H", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["A", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["A", "nu"], "]"}]}], ")"}], "2"]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["B", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["B", "nu"], "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Chi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["B", "mu"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["B", "nu"], "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["X", "mu"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["X", "nu"], "]"}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["X", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["X", "nu"], "]"}]}], ")"}], "2"]}], "-", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubsuperscriptBox["ghG", "a", "\[Dagger]"], ".", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
         SubscriptBox["ghG", "a"], "]"}], "]"}], 
       SubscriptBox["g", "s"]], "+", 
      RowBox[{
       SubscriptBox["f", 
        RowBox[{"a", ",", "a2$2227", ",", "a3$2227"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
           SubscriptBox["ghG", "a3$2227"], "]"}], " ", 
          SubscriptBox["G", 
           RowBox[{"mu", ",", "a2$2227"}]]}], "+", 
         RowBox[{
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
           SubscriptBox["G", 
            RowBox[{"mu", ",", "a2$2227"}]], "]"}], " ", 
          SubscriptBox["ghG", "a3$2227"]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["dq", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "dq", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["l", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "l", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["uq", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "uq", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["vl", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "vl", "]"}]}]}], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["dq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["dq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "dq"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "l"}]}], 
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "l"}]}], 
   SubscriptBox["c", "w"]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["uq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["uq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "uq"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["vl", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}]}], 
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["dq", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "dq"}], "+", 
     RowBox[{
      OverscriptBox["uq", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "uq"}]}], ")"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a"}]]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"a1", ",", "a2", ",", "a3"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a2"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a3"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"a1", ",", "a4", ",", "a5"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a4"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a5"}]]}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["G", "H"], " ", "H", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "b"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "b"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"b", ",", "bb$2228", ",", "cc$2228"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "bb$2228"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "cc$2228"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "b"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "b"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"b", ",", "bb$2229", ",", "cc$2229"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "bb$2229"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "cc$2229"}]]}]}], ")"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "1"}]], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "2"}]]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "1"}]], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "2"}]]}]}], ")"}]}], 
   RowBox[{"8", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["B", "mu"]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "w"]}]], "-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "H", "]"}]}], 
      SqrtBox["2"]], "-", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["B", "mu"]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "w"]}]], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "H", "]"}]}], 
      SqrtBox["2"]], "-", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SubscriptBox["s", "w"]}]], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["vl", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "l"}], " ", 
       SubscriptBox["W", "mu"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ".", "CKM", ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}], " ", 
       SubscriptBox["W", "mu"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["l", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}], " ", 
       SubsuperscriptBox["W", "mu", "\[Dagger]"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["dq", "\<\"-\"\>"], ".", 
        SuperscriptBox["CKM", "\[Dagger]"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}], " ", 
       SubsuperscriptBox["W", "mu", "\[Dagger]"]}], "-", 
      RowBox[{
       RowBox[{
        OverscriptBox["dq", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "-", 
      RowBox[{
       RowBox[{
        OverscriptBox["l", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "l"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["vl", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}]}], ")"}]}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "i1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "w"], " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"i1", ",", "i2", ",", "i3"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "i2"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i3"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "i1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "w"], " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"i1", ",", "i4", ",", "i5"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "i4"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i5"}]]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "phih", "]"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "X"], " ", "phih", " ", 
      SubscriptBox["X", "mu"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SuperscriptBox["phih", "\[Dagger]"], "]"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "X"], " ", 
      SuperscriptBox["phih", "\[Dagger]"], " ", 
      SubscriptBox["X", "mu"]}]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["dq", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219", ",", "i$2219"}]], ".", 
     SubscriptBox["dq", 
      RowBox[{"r$2219", ",", "n$2219", ",", "i$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yd", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["dq", "\<\"-\"\>"], 
      RowBox[{"r$2221", ",", "n$2220", ",", "i$2220"}]], ".", 
     SubscriptBox["dq", 
      RowBox[{"r$2222", ",", "n$2220", ",", "i$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2221", ",", "r$2222"}]], " ", 
    SubscriptBox["yd", "n$2220"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["l", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219"}]], ".", 
     SubscriptBox["l", 
      RowBox[{"r$2219", ",", "n$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yl", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["l", "\<\"-\"\>"], 
      RowBox[{"r$2223", ",", "n$2220"}]], ".", 
     SubscriptBox["l", 
      RowBox[{"r$2224", ",", "n$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2223", ",", "r$2224"}]], " ", 
    SubscriptBox["yl", "n$2220"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["uq", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219", ",", "i$2219"}]], ".", 
     SubscriptBox["uq", 
      RowBox[{"r$2219", ",", "n$2219", ",", "i$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yu", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["uq", "\<\"-\"\>"], 
      RowBox[{"r$2225", ",", "n$2220", ",", "i$2220"}]], ".", 
     SubscriptBox["uq", 
      RowBox[{"r$2226", ",", "n$2220", ",", "i$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2225", ",", "r$2226"}]], " ", 
    SubscriptBox["yu", "n$2220"]}], 
   SqrtBox["2"]]}]], "Output",
 CellChangeTimes->{3.604964592307816*^9, 3.604974621986936*^9, 
  3.604986084942824*^9, 3.605249884285236*^9, 3.60923970107405*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Feynman rules", "Section",
 CellChangeTimes->{{3.411915866249317*^9, 3.4119158716988153`*^9}, 
   3.509779363849759*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915928653887*^9}, {
   3.4137211614912577`*^9, 3.4137211708030777`*^9}, 3.508569350492257*^9, {
   3.509779361403779*^9, 3.509779374162471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.604964596346346*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.604964596348333*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.604964596350655*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.604964598531795*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "66", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "66", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  66, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 66, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.604964598624443*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"65", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[65, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.604964602309856*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Kappa]"}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Lambda]"}], "+", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Lambda]"}], "+", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Kappa]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Lambda]"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["ghG", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ghG", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.60496460245289*^9}]
}, Closed]],

Cell["Or in a flavor expanded form", "Text",
 CellChangeTimes->{{3.411915937803143*^9, 3.4119159434558887`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LHAHM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915958983838*^9}, {
   3.508569657623721*^9, 3.508569668869379*^9}, {3.5097793668671083`*^9, 
   3.509779379186967*^9}, 3.5136893169327602`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["checking mass spectrum", "Section",
 CellChangeTimes->{{3.604964662895247*^9, 3.604964665651083*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.6049646159829206`*^9, 3.604964633860752*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.6092397209818897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Non diagonal mass term found: \"\>", "\[InvisibleSpace]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
     SubscriptBox["s", "h"], " ", 
     SuperscriptBox["v", "2"], " ", "\[Kappa]"}]}], "-", 
   RowBox[{"3", " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    SuperscriptBox["v", "2"], " ", "\[Lambda]"}], "-", 
   RowBox[{
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    TemplateBox[{"\[Mu]","H","2"},
     "Subsuperscript"]}], "+", 
   RowBox[{
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    TemplateBox[{"\[Mu]","SM","2"},
     "Subsuperscript"]}], "-", 
   RowBox[{
    SubsuperscriptBox["c", "h", "2"], " ", "h", " ", "hs", " ", "v", " ", 
    "\[Kappa]", " ", "\[Xi]"}], "+", 
   RowBox[{"h", " ", "hs", " ", 
    SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]", " ", 
    "\[Xi]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", "\[Kappa]", " ", 
    SuperscriptBox["\[Xi]", "2"]}], "+", 
   RowBox[{"3", " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    SuperscriptBox["\[Xi]", "2"], " ", "\[Rho]"}]}],
  SequenceForm[
  "Non diagonal mass term found: ", 
   Rational[1, 
      2] $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh 
    FeynRules`v^2 $CellContext`\[Kappa] - 
   3 $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh 
   FeynRules`v^2 $CellContext`\[Lambda] - $CellContext`ch $CellContext`h \
$CellContext`hs $CellContext`sh $CellContext`\[Mu]H2 + $CellContext`ch \
$CellContext`h $CellContext`hs $CellContext`sh $CellContext`\[Mu]SM2 - \
$CellContext`ch^2 $CellContext`h $CellContext`hs 
   FeynRules`v $CellContext`\[Kappa] $CellContext`\[Xi] + $CellContext`h \
$CellContext`hs $CellContext`sh^2 
    FeynRules`v $CellContext`\[Kappa] $CellContext`\[Xi] + 
   Rational[-1, 
      2] $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh \
$CellContext`\[Kappa] $CellContext`\[Xi]^2 + 
   3 $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh \
$CellContext`\[Xi]^2 $CellContext`\[Rho]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.609239721306641*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non diagonal mass term found: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     SubscriptBox["c", "\[Alpha]"], " ", 
     SuperscriptBox["e", "2"], " ", 
     SubscriptBox["s", "\[Alpha]"], " ", 
     SuperscriptBox["v", "2"], " ", 
     SubscriptBox["Z", "mu"], " ", 
     SubscriptBox["Zp", "mu"]}], "-", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SubsuperscriptBox["c", "w", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["s", "w", "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SubsuperscriptBox["s", "w", "2"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubscriptBox["s", "w"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubscriptBox["s", "w"]}]], "-", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "w"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
      SubscriptBox["s", "w"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SuperscriptBox["\[Eta]", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SubsuperscriptBox["g", "X", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["\[Eta]", "2"], " ", 
      SuperscriptBox["\[Xi]", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     SuperscriptBox["\[Chi]", "2"]]}]}],
  SequenceForm[
  "Non diagonal mass term found: ", 
   Rational[-1, 2] $CellContext`ca FeynRules`ee^2 $CellContext`sa 
    FeynRules`v^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca $CellContext`cw^2 
    FeynRules`ee^2 $CellContext`sa $CellContext`sw^(-2) 
    FeynRules`v^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sa $CellContext`sw^2 
    FeynRules`v^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca^2 FeynRules`ee^2 $CellContext`sw^(-1) 
    FeynRules`v^2 FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[1, 4] FeynRules`ee^2 $CellContext`sa^2 $CellContext`sw^(-1) 
    FeynRules`v^2 FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca^2 $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sw FeynRules`v^2 
    FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[1, 4] $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sa^2 $CellContext`sw FeynRules`v^2 
    FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[1, 4] $CellContext`ca $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sa FeynRules`v^2 
    FeynRules`\[Eta]^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + $CellContext`ca $CellContext`gX^2 $CellContext`sa 
    FeynRules`\[Eta]^2 $CellContext`\[Xi]^2 $CellContext`\[Chi]^(-2) \
$CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.609239721341413*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["computing widths", "Section",
 CellChangeTimes->{{3.604964673012329*^9, 3.604964674219133*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"decays", "=", 
   RowBox[{"ComputeWidths", "[", 
    RowBox[{"FeynmanRules", "[", 
     RowBox[{"LHAHM", ",", " ", 
      RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"UpdateWidths", "[", "decays", "]"}]}], "Input",
 CellChangeTimes->{{3.604964698503813*^9, 3.6049647587517157`*^9}, 
   3.6052499155507927`*^9, {3.6052709918253393`*^9, 3.605270991994774*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.6092406512715597`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240651272964*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.6092406512755938`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240653381912*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "74", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "74", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  74, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 74, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240653472582*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"73", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[73, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240657453891*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "73"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 73],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240658276807*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.6092406606717377`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "72"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240660702654*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "65"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 65],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.6092406637155523`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WH\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.00636984\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WH", " = ", "0.00636984", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240670102332*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WHS\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"18.4103\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WHS", " = ", "18.4103", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240670104383*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WT\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"1.58637\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WT", " = ", "1.58637", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240670106371*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WW\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"2.12157\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WW", " = ", "2.12157", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240670108354*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZ\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"2.5296\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WZ", " = ", "2.5296", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.609240670110326*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZp\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.0000355689\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WZp", " = ", "0.0000355689", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9, 
  3.6092406701122847`*^9}]
}, Open  ]]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.6053057661784267`*^9, 3.605305766712928*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Export to UFO", "Section",
 CellChangeTimes->{{3.604964806489471*^9, 3.604964808080537*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SetDirectory", "[", "modeldir", "]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteUFO", "[", "LHAHM", "]"}]}], "Input",
 CellChangeTimes->{{3.604964810304481*^9, 3.604964842385274*^9}, {
  3.6066531173829193`*^9, 3.6066531174657927`*^9}}],

Cell[BoxData["\<\"/Users/davidcurtin/Dropbox/Research_db/SharedZZD/david/\
hidden_abelian_higgs_model_final/HAHM_MGmodel_v2\"\>"], "Output",
 CellChangeTimes->{
  3.604964842846836*^9, {3.6049746742098494`*^9, 3.6049746798957*^9}, 
   3.6052505022725983`*^9, 3.6055698549486017`*^9, 3.606647705150442*^9, 
   3.606653319113881*^9, 3.606653967968173*^9, 3.606671355670191*^9, 
   3.606671715361816*^9, 3.606726567740533*^9, 3.606747230788603*^9, 
   3.6091595675130453`*^9, 3.609166725787594*^9, 3.609171450142783*^9, 
   3.609181896362587*^9, 3.609236894073102*^9, {3.6092406745058947`*^9, 
   3.609240716599139*^9}, 3.6092412523397617`*^9, {3.6202307175273237`*^9, 
   3.6202307754755383`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, {3.6202307175634317`*^9, 
   3.620230775507365*^9}}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, {3.6202307175634317`*^9, 
   3.620230776170271*^9}}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, {3.6202307175634317`*^9, 
   3.620230776172106*^9}}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230779949514*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "74", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "74", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  74, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 74, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.6202307800336933`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"73", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[73, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230785016069*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "73"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 73],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230785930955*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230787093581*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.6202307871239023`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "76"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 76],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230787146736*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "4.65711899999999978660980559652671217918`6.6887172485675315", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Squared matrix elent compute in ", 
   4.65711899999999978660980559652671217918`6.6887172485675315, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.6202307917654533`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "9.00000000000000022800771687370158`0.9748424227189488*^-6", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Decay widths computed in ", 
   9.00000000000000022800771687370158`0.9748424227189488*^-6, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230791767438*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230791902711*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230792058976*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.6202307920811157`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{7., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 2, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.620230793956255*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.62023079414498*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{
  3.6066533191261473`*^9, 3.60665396799714*^9, 3.606671355671577*^9, 
   3.606671715363266*^9, 3.6067265679520197`*^9, 3.606747230790098*^9, 
   3.6091595675178432`*^9, 3.609166725803389*^9, 3.609171450145883*^9, 
   3.609181896369216*^9, 3.609236894074719*^9, {3.609240674507689*^9, 
   3.609240716600608*^9}, 3.609241252372357*^9, 3.6202307175634317`*^9, 
   3.62023079463975*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1276, 668},
WindowMargins->{{Automatic, -1}, {Automatic, 5}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 20, \
2012)",
StyleDefinitions->FrontEnd`FileName[{$RootDirectory, "Applications", 
   "Mathematica.app", "SystemFiles", "FrontEnd", "StyleSheets", "Creative"}, 
  "PastelColor.nb", CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 185, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[767, 28, 335, 6, 61, "Title"],
Cell[CellGroupData[{
Cell[1127, 38, 1730, 35, 158, "Input"],
Cell[CellGroupData[{
Cell[2882, 77, 1154, 16, 22, "Print"],
Cell[4039, 95, 1427, 23, 21, "Print"],
Cell[5469, 120, 1206, 17, 22, "Print"],
Cell[6678, 139, 1138, 16, 21, "Print"],
Cell[7819, 157, 1149, 16, 21, "Print"],
Cell[8971, 175, 1159, 16, 21, "Print"],
Cell[10133, 193, 1201, 17, 22, "Print"],
Cell[11337, 212, 1138, 16, 21, "Print"],
Cell[12478, 230, 1170, 16, 22, "Print"],
Cell[13651, 248, 1138, 16, 21, "Print"],
Cell[14792, 266, 1205, 17, 22, "Print"],
Cell[16000, 285, 1179, 16, 22, "Print"],
Cell[17182, 303, 1158, 16, 21, "Print"],
Cell[18343, 321, 1283, 20, 21, "Print"],
Cell[19629, 343, 1148, 16, 21, "Print"],
Cell[20780, 361, 1246, 17, 22, "Print"],
Cell[22029, 380, 1204, 17, 22, "Print"],
Cell[23236, 399, 1185, 17, 22, "Print"],
Cell[24424, 418, 1137, 16, 21, "Print"],
Cell[25564, 436, 1169, 16, 22, "Print"],
Cell[26736, 454, 1170, 16, 22, "Print"],
Cell[27909, 472, 1170, 16, 22, "Print"],
Cell[29082, 490, 1363, 22, 38, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30494, 518, 99, 1, 73, "Section"],
Cell[CellGroupData[{
Cell[30618, 523, 197, 3, 38, "Input"],
Cell[30818, 528, 18835, 581, 611, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49702, 1115, 126, 2, 43, "Section"],
Cell[CellGroupData[{
Cell[49853, 1121, 261, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[50139, 1129, 348, 9, 22, "Print"],
Cell[50490, 1140, 103, 1, 22, "Print"],
Cell[50596, 1143, 277, 6, 22, "Print"],
Cell[50876, 1151, 136, 2, 22, "Print"],
Cell[51015, 1155, 617, 13, 22, "Print"],
Cell[51635, 1170, 218, 5, 21, "Print"]
}, Open  ]],
Cell[51868, 1178, 144631, 3899, 2980, "Output"]
}, Closed]],
Cell[196514, 5080, 112, 1, 26, "Text"],
Cell[196629, 5083, 328, 6, 38, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[196994, 5094, 107, 1, 43, "Section"],
Cell[CellGroupData[{
Cell[197126, 5099, 142, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[197293, 5105, 449, 9, 22, "Print"],
Cell[197745, 5116, 2563, 59, 39, "Print"],
Cell[200311, 5177, 5923, 142, 96, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[206295, 5326, 101, 1, 43, "Section"],
Cell[CellGroupData[{
Cell[206421, 5331, 457, 10, 56, "Input"],
Cell[CellGroupData[{
Cell[206903, 5345, 539, 12, 22, "Print"],
Cell[207445, 5359, 292, 4, 22, "Print"],
Cell[207740, 5365, 468, 9, 22, "Print"],
Cell[208211, 5376, 325, 5, 22, "Print"],
Cell[208539, 5383, 806, 16, 22, "Print"],
Cell[209348, 5401, 407, 8, 21, "Print"],
Cell[209758, 5411, 761, 15, 22, "Print"],
Cell[210522, 5428, 575, 13, 22, "Print"],
Cell[211100, 5443, 527, 12, 21, "Print"],
Cell[211630, 5457, 529, 12, 21, "Print"],
Cell[212162, 5471, 489, 10, 21, "Print"],
Cell[212654, 5483, 484, 10, 21, "Print"],
Cell[213141, 5495, 482, 10, 21, "Print"],
Cell[213626, 5507, 482, 10, 21, "Print"],
Cell[214111, 5519, 477, 9, 21, "Print"],
Cell[214591, 5530, 497, 10, 22, "Print"]
}, Open  ]]
}, Open  ]],
Cell[215115, 5544, 84, 1, 29, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[215236, 5550, 98, 1, 43, "Section"],
Cell[CellGroupData[{
Cell[215359, 5555, 259, 4, 56, "Input"],
Cell[215621, 5561, 695, 10, 38, "Output"],
Cell[CellGroupData[{
Cell[216341, 5575, 489, 8, 22, "Print"],
Cell[216833, 5585, 712, 15, 22, "Print"],
Cell[217548, 5602, 467, 7, 22, "Print"],
Cell[218018, 5611, 498, 8, 22, "Print"],
Cell[218519, 5621, 981, 19, 22, "Print"],
Cell[219503, 5642, 580, 11, 21, "Print"],
Cell[220086, 5655, 809, 15, 22, "Print"],
Cell[220898, 5672, 479, 7, 21, "Print"],
Cell[221380, 5681, 748, 16, 22, "Print"],
Cell[222131, 5699, 700, 15, 21, "Print"],
Cell[222834, 5716, 792, 15, 22, "Print"],
Cell[223629, 5733, 772, 15, 24, "Print"],
Cell[224404, 5750, 462, 7, 22, "Print"],
Cell[224869, 5759, 486, 8, 22, "Print"],
Cell[225358, 5769, 679, 12, 22, "Print"],
Cell[226040, 5783, 831, 15, 22, "Print"],
Cell[226874, 5800, 457, 7, 22, "Print"],
Cell[227334, 5809, 442, 7, 21, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
