(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    228356,       5888]
NotebookOptionsPosition[    223816,       5751]
NotebookOutlinePosition[    224361,       5770]
CellTagsIndexPosition[    224318,       5767]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.605939383914187*^9, 3.605939389600998*^9}, {
  3.609154670325432*^9, 3.609154671020789*^9}}],

Cell[CellGroupData[{

Cell["\<\
The Hidden Abelian Higgs model with variable MW\
\>", "Title",
 CellChangeTimes->{{3.411915778286763*^9, 3.4119157817267313`*^9}, {
  3.413720856398858*^9, 3.413720856723679*^9}, {3.509778928631168*^9, 
  3.509778939699687*^9}, {3.609239767121204*^9, 3.609239768579833*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\</Users/davidcurtin/Documents/uni/Research/Collider_Physics/FeynRules_\
2.0/feynrules-current\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
   "modeldir", "=", 
    "\"\</Users/davidcurtin/Documents/uni/Research/Collider_Physics/FeynRules_\
2.0/hidden_abelian_higgs_model_final/\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"modelfile", "=", "\"\<HAHM_final_variableMW.fr\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{"modeldir", "<>", "modelfile"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.605249872680089*^9, {3.6053061313866796`*^9, 3.60530613146021*^9}, 
   3.605311257985278*^9, {3.605569568908189*^9, 3.605569570006483*^9}, {
   3.605572782711409*^9, 3.605572782965074*^9}, {3.6059393763057947`*^9, 
   3.605939391935643*^9}, {3.605940425194668*^9, 3.605940426910673*^9}, {
   3.605940676225548*^9, 3.605940696567214*^9}, {3.6059414342043257`*^9, 
   3.605941434348999*^9}, {3.6066476428102818`*^9, 3.606647654077117*^9}, {
   3.6066706011086597`*^9, 3.606670601274888*^9}, {3.6067471860389633`*^9, 
   3.6067471861784973`*^9}, {3.6091545943945932`*^9, 3.609154607763337*^9}, 
   3.609156687900199*^9, {3.60915816116991*^9, 3.609158251613903*^9}, {
   3.6091583284081697`*^9, 3.6091583402865334`*^9}, {3.60915850356952*^9, 
   3.609158506558864*^9}, {3.6092396745509787`*^9, 3.609239689023221*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146612*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.0.23\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"26 March 2014\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.0.23", " (" "26 March 2014", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.6092412114681664`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121146979*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241211471471*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241211473051*^9}],

Cell[BoxData["\<\"    - arXiv:1310.1921;\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241211474696*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241211476862*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.6092412114793663`*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241211480878*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241211482423*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.6092412114846373`*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.6092412144868593`*^9}],

Cell[BoxData["\<\"C. Duhr, David Curtin\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214488619*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.5\"\>"}],
  SequenceForm["Model Version: ", "1.5"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214490473*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214492305*^9}],

Cell[BoxData["\<\"  J. D. Wells, \\\"How to Find a Hidden World at the Large \
Hadron Collider,\\\", [arXiv:0803.1243 [hep-ph]]\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121449441*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be/view/Main/\
HiddenAbelianHiggsModel\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214496317*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214498198*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214522731*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214524641*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.60924121459587*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.6092412146383677`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"HAHM_variableMW\"\>",
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "HAHM_variableMW", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.606671237709714*^9, 3.606671305990803*^9}, 
   3.606671682946636*^9, 3.6067264833328867`*^9, 3.6067471957740517`*^9, 
   3.6091546123653593`*^9, 3.6091546739736757`*^9, {3.6091548253179502`*^9, 
   3.609154876640957*^9}, 3.60915576916982*^9, 3.609155885628634*^9, {
   3.6091564891804657`*^9, 3.609156537802711*^9}, 3.60915659909568*^9, {
   3.609156661579623*^9, 3.609156694822513*^9}, 3.609157480332807*^9, 
   3.6091578371077957`*^9, 3.609157897213525*^9, 3.609158166186531*^9, 
   3.609158244534457*^9, 3.609158332567833*^9, 3.6091584183197193`*^9, 
   3.609158513658499*^9, 3.6091585830748796`*^9, 3.609158716680532*^9, 
   3.609158780599019*^9, 3.609158972389997*^9, 3.6091595096982737`*^9, {
   3.609159994768258*^9, 3.60916004633119*^9}, 3.609166702017494*^9, 
   3.609171413716868*^9, 3.6091818456347446`*^9, 3.609236869346047*^9, {
   3.609239678671795*^9, 3.609239693318098*^9}, 3.6092407416488934`*^9, 
   3.609241214694435*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The lagrangian", "Section",
 CellChangeTimes->{{3.411915790793332*^9, 3.411915793199389*^9}}],

Cell[CellGroupData[{

Cell[BoxData["LHAHM"], "Input",
 CellChangeTimes->{{3.4119143176932583`*^9, 3.411914319401045*^9}, {
  3.509778966781176*^9, 3.509778967770995*^9}, {3.509779355012743*^9, 
  3.509779370460802*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", "phih", " ", 
   SuperscriptBox["phih", "\[Dagger]"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "2"], " ", "\[Kappa]"}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "4"], " ", "\[Lambda]"}], "+", 
  RowBox[{"phih", " ", 
   SuperscriptBox["phih", "\[Dagger]"], " ", 
   TemplateBox[{"\[Mu]","H","2"},
    "Subsuperscript"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
   TemplateBox[{"\[Mu]","SM","2"},
    "Subsuperscript"]}], "-", 
  RowBox[{
   SuperscriptBox["phih", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["phih", "\[Dagger]"], ")"}], "2"], " ", "\[Rho]"}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["A", "H"], " ", "H", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["A", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["A", "nu"], "]"}]}], ")"}], "2"]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["B", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["B", "nu"], "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Chi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["B", "mu"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["B", "nu"], "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["X", "mu"], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["X", "nu"], "]"}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
        SubscriptBox["X", "mu"], "]"}]}], "+", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
       SubscriptBox["X", "nu"], "]"}]}], ")"}], "2"]}], "-", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubsuperscriptBox["ghG", "a", "\[Dagger]"], ".", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
         SubscriptBox["ghG", "a"], "]"}], "]"}], 
       SubscriptBox["g", "s"]], "+", 
      RowBox[{
       SubscriptBox["f", 
        RowBox[{"a", ",", "a2$2227", ",", "a3$2227"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
           SubscriptBox["ghG", "a3$2227"], "]"}], " ", 
          SubscriptBox["G", 
           RowBox[{"mu", ",", "a2$2227"}]]}], "+", 
         RowBox[{
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
           SubscriptBox["G", 
            RowBox[{"mu", ",", "a2$2227"}]], "]"}], " ", 
          SubscriptBox["ghG", "a3$2227"]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["dq", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "dq", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["l", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "l", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["uq", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "uq", "]"}]}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{
    OverscriptBox["vl", "\<\"-\"\>"], ".", 
    SuperscriptBox["\[Gamma]", "mu"], ".", 
    RowBox[{
     SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "vl", "]"}]}]}], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["dq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["dq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "dq"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "l"}]}], 
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "l"}]}], 
   SubscriptBox["c", "w"]], "+", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["uq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}]}], 
   RowBox[{"6", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["uq", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"+\"\>"], ".", "uq"}]}], 
   RowBox[{"3", " ", 
    SubscriptBox["c", "w"]}]], "-", 
  FractionBox[
   RowBox[{"e", " ", 
    SubscriptBox["B", "mu"], " ", 
    RowBox[{
     OverscriptBox["vl", "\<\"-\"\>"], ".", 
     SuperscriptBox["\[Gamma]", "mu"], ".", 
     SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}]}], 
   RowBox[{"2", " ", 
    SubscriptBox["c", "w"]}]], "+", 
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      OverscriptBox["dq", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "dq"}], "+", 
     RowBox[{
      OverscriptBox["uq", "\<\"-\"\>"], ".", 
      SuperscriptBox["T", "a"], ".", 
      SuperscriptBox["\[Gamma]", "mu"], ".", "uq"}]}], ")"}], " ", 
   SubscriptBox["G", 
    RowBox[{"mu", ",", "a"}]]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"a1", ",", "a2", ",", "a3"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a2"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a3"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "a1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"a1", ",", "a4", ",", "a5"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "a4"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "a5"}]]}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["G", "H"], " ", "H", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "b"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "b"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"b", ",", "bb$2228", ",", "cc$2228"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "bb$2228"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "cc$2228"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["G", 
        RowBox[{"mu", ",", "b"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "b"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubscriptBox["f", 
       RowBox[{"b", ",", "bb$2229", ",", "cc$2229"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"mu", ",", "bb$2229"}]], " ", 
      SubscriptBox["G", 
       RowBox[{"nu", ",", "cc$2229"}]]}]}], ")"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["e", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"H", "+", "v"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "1"}]], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "2"}]]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "1"}]], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "2"}]]}]}], ")"}]}], 
   RowBox[{"8", " ", 
    SubsuperscriptBox["s", "w", "2"]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["B", "mu"]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "w"]}]], "-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "H", "]"}]}], 
      SqrtBox["2"]], "-", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["B", "mu"]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "w"]}]], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "H", "]"}]}], 
      SqrtBox["2"]], "-", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{"H", "+", "v"}], ")"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SubscriptBox["s", "w"]}]], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["vl", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "l"}], " ", 
       SubscriptBox["W", "mu"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ".", "CKM", ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}], " ", 
       SubscriptBox["W", "mu"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["l", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}], " ", 
       SubsuperscriptBox["W", "mu", "\[Dagger]"]}], "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{
        OverscriptBox["dq", "\<\"-\"\>"], ".", 
        SuperscriptBox["CKM", "\[Dagger]"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}], " ", 
       SubsuperscriptBox["W", "mu", "\[Dagger]"]}], "-", 
      RowBox[{
       RowBox[{
        OverscriptBox["dq", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "dq"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "-", 
      RowBox[{
       RowBox[{
        OverscriptBox["l", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "l"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["uq", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "uq"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}], "+", 
      RowBox[{
       RowBox[{
        OverscriptBox["vl", "\<\"-\"\>"], ".", 
        SuperscriptBox["\[Gamma]", "mu"], ".", 
        SubscriptBox["P", "\<\"-\"\>"], ".", "vl"}], " ", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "3"}]]}]}], ")"}]}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "i1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "w"], " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"i1", ",", "i2", ",", "i3"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "i2"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i3"}]]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["\<\"\[PartialD]\"\>", "nu"], "[", 
       SubscriptBox["Wi", 
        RowBox[{"mu", ",", "i1"}]], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i1"}]], "]"}], "+", 
     RowBox[{
      SubscriptBox["g", "w"], " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"i1", ",", "i4", ",", "i5"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"mu", ",", "i4"}]], " ", 
      SubscriptBox["Wi", 
       RowBox[{"nu", ",", "i5"}]]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", "phih", "]"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "X"], " ", "phih", " ", 
      SubscriptBox["X", "mu"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"\[PartialD]\"\>", "mu"], "[", 
      SuperscriptBox["phih", "\[Dagger]"], "]"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "X"], " ", 
      SuperscriptBox["phih", "\[Dagger]"], " ", 
      SubscriptBox["X", "mu"]}]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["dq", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219", ",", "i$2219"}]], ".", 
     SubscriptBox["dq", 
      RowBox[{"r$2219", ",", "n$2219", ",", "i$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yd", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["dq", "\<\"-\"\>"], 
      RowBox[{"r$2221", ",", "n$2220", ",", "i$2220"}]], ".", 
     SubscriptBox["dq", 
      RowBox[{"r$2222", ",", "n$2220", ",", "i$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2221", ",", "r$2222"}]], " ", 
    SubscriptBox["yd", "n$2220"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["l", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219"}]], ".", 
     SubscriptBox["l", 
      RowBox[{"r$2219", ",", "n$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yl", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["l", "\<\"-\"\>"], 
      RowBox[{"r$2223", ",", "n$2220"}]], ".", 
     SubscriptBox["l", 
      RowBox[{"r$2224", ",", "n$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2223", ",", "r$2224"}]], " ", 
    SubscriptBox["yl", "n$2220"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["uq", "\<\"-\"\>"], 
      RowBox[{"s$2219", ",", "n$2219", ",", "i$2219"}]], ".", 
     SubscriptBox["uq", 
      RowBox[{"r$2219", ",", "n$2219", ",", "i$2219"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"+\"\>"], 
     RowBox[{"s$2219", ",", "r$2219"}]], " ", 
    SubscriptBox["yu", "n$2219"]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"H", "+", "v"}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["uq", "\<\"-\"\>"], 
      RowBox[{"r$2225", ",", "n$2220", ",", "i$2220"}]], ".", 
     SubscriptBox["uq", 
      RowBox[{"r$2226", ",", "n$2220", ",", "i$2220"}]]}], " ", 
    SubscriptBox[
     SubscriptBox["P", "\<\"-\"\>"], 
     RowBox[{"r$2225", ",", "r$2226"}]], " ", 
    SubscriptBox["yu", "n$2220"]}], 
   SqrtBox["2"]]}]], "Output",
 CellChangeTimes->{3.604964592307816*^9, 3.604974621986936*^9, 
  3.604986084942824*^9, 3.605249884285236*^9, 3.60923970107405*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Feynman rules", "Section",
 CellChangeTimes->{{3.411915866249317*^9, 3.4119158716988153`*^9}, 
   3.509779363849759*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915928653887*^9}, {
   3.4137211614912577`*^9, 3.4137211708030777`*^9}, 3.508569350492257*^9, {
   3.509779361403779*^9, 3.509779374162471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.604964596346346*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.604964596348333*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.604964596350655*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.604964598531795*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "66", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "66", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  66, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 66, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.604964598624443*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"65", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[65, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.604964602309856*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Kappa]"}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Lambda]"}], "+", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Lambda]"}], "+", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", 
       SubscriptBox["s", "h"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "4"], " ", "\[Lambda]"}], "-", 
      RowBox[{"24", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "4"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Kappa]"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "v", " ", "\[Lambda]"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "\[Kappa]", " ", "\[Xi]"}], "-", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "3"], " ", "v", " ", "\[Lambda]"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubscriptBox["s", "h"], " ", "\[Kappa]", " ", "\[Xi]"}], "+", 
      RowBox[{"12", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["s", "h", "3"], " ", "\[Xi]", " ", "\[Rho]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["ghG", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ghG", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "2"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "3"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "2"], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "1"], ",", 
         SubscriptBox["\<\"a\"\>", "3"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "4"], ",", "Gluon$1"}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["g", "w"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yd", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yl", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox["yu", 
         SubscriptBox["\<\"f\"\>", "1"]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "\[Alpha]"], " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubscriptBox["s", "\[Alpha]"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["c", "h", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["s", "h", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SubscriptBox["s", "w"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "h", "2"], " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["c", "h", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", "h"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SubscriptBox["c", "h"], " ", 
        SuperscriptBox["e", "2"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SubscriptBox["s", "h"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["s", "h"], " ", "v", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "v", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "h"], " ", 
        SubscriptBox["s", "w"], " ", "v", " ", "\[Eta]", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubsuperscriptBox["c", "w", "2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "h"], " ", "v", " ", 
        SuperscriptBox["\[Eta]", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", 
       SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
       SubscriptBox["c", "h"], " ", 
       SubsuperscriptBox["g", "X", "2"], " ", 
       SuperscriptBox["\[Eta]", "2"], " ", "\[Xi]", " ", 
       SuperscriptBox["\[Chi]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["c", "w", "2"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"]}]], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      SubsuperscriptBox["\[Gamma]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}], 
       SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"i\"\>", "1"], ",", 
        SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["CKM", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"i\"\>", "1"], ",", 
           SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"i\"\>", "1"], ",", 
          SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["vl", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        SubscriptBox["s", "\[Alpha]"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "\[Alpha]"], " ", "e", " ", "\[Eta]", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          SuperscriptBox["\[Gamma]", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"vl", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["CKM", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"i\"\>", "1"], ",", 
         SubscriptBox["\<\"i\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.60496460245289*^9}]
}, Closed]],

Cell["Or in a flavor expanded form", "Text",
 CellChangeTimes->{{3.411915937803143*^9, 3.4119159434558887`*^9}}],

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LHAHM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411915883502528*^9, 3.411915958983838*^9}, {
   3.508569657623721*^9, 3.508569668869379*^9}, {3.5097793668671083`*^9, 
   3.509779379186967*^9}, 3.5136893169327602`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["checking mass spectrum", "Section",
 CellChangeTimes->{{3.604964662895247*^9, 3.604964665651083*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LHAHM", "]"}]], "Input",
 CellChangeTimes->{{3.6049646159829206`*^9, 3.604964633860752*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.6092397209818897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Non diagonal mass term found: \"\>", "\[InvisibleSpace]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
     SubscriptBox["s", "h"], " ", 
     SuperscriptBox["v", "2"], " ", "\[Kappa]"}]}], "-", 
   RowBox[{"3", " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    SuperscriptBox["v", "2"], " ", "\[Lambda]"}], "-", 
   RowBox[{
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    TemplateBox[{"\[Mu]","H","2"},
     "Subsuperscript"]}], "+", 
   RowBox[{
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    TemplateBox[{"\[Mu]","SM","2"},
     "Subsuperscript"]}], "-", 
   RowBox[{
    SubsuperscriptBox["c", "h", "2"], " ", "h", " ", "hs", " ", "v", " ", 
    "\[Kappa]", " ", "\[Xi]"}], "+", 
   RowBox[{"h", " ", "hs", " ", 
    SubsuperscriptBox["s", "h", "2"], " ", "v", " ", "\[Kappa]", " ", 
    "\[Xi]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", "\[Kappa]", " ", 
    SuperscriptBox["\[Xi]", "2"]}], "+", 
   RowBox[{"3", " ", 
    SubscriptBox["c", "h"], " ", "h", " ", "hs", " ", 
    SubscriptBox["s", "h"], " ", 
    SuperscriptBox["\[Xi]", "2"], " ", "\[Rho]"}]}],
  SequenceForm[
  "Non diagonal mass term found: ", 
   Rational[1, 
      2] $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh 
    FeynRules`v^2 $CellContext`\[Kappa] - 
   3 $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh 
   FeynRules`v^2 $CellContext`\[Lambda] - $CellContext`ch $CellContext`h \
$CellContext`hs $CellContext`sh $CellContext`\[Mu]H2 + $CellContext`ch \
$CellContext`h $CellContext`hs $CellContext`sh $CellContext`\[Mu]SM2 - \
$CellContext`ch^2 $CellContext`h $CellContext`hs 
   FeynRules`v $CellContext`\[Kappa] $CellContext`\[Xi] + $CellContext`h \
$CellContext`hs $CellContext`sh^2 
    FeynRules`v $CellContext`\[Kappa] $CellContext`\[Xi] + 
   Rational[-1, 
      2] $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh \
$CellContext`\[Kappa] $CellContext`\[Xi]^2 + 
   3 $CellContext`ch $CellContext`h $CellContext`hs $CellContext`sh \
$CellContext`\[Xi]^2 $CellContext`\[Rho]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.609239721306641*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non diagonal mass term found: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     SubscriptBox["c", "\[Alpha]"], " ", 
     SuperscriptBox["e", "2"], " ", 
     SubscriptBox["s", "\[Alpha]"], " ", 
     SuperscriptBox["v", "2"], " ", 
     SubscriptBox["Z", "mu"], " ", 
     SubscriptBox["Zp", "mu"]}], "-", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SubsuperscriptBox["c", "w", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["s", "w", "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SubsuperscriptBox["s", "w", "2"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "-", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubscriptBox["s", "w"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubscriptBox["s", "w"]}]], "-", 
    FractionBox[
     RowBox[{
      SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "w"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["e", "2"], " ", 
      SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
      SubscriptBox["s", "w"], " ", 
      SuperscriptBox["v", "2"], " ", "\[Eta]", " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["v", "2"], " ", 
      SuperscriptBox["\[Eta]", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     RowBox[{"4", " ", 
      SubsuperscriptBox["c", "w", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["c", "\[Alpha]"], " ", 
      SubsuperscriptBox["g", "X", "2"], " ", 
      SubscriptBox["s", "\[Alpha]"], " ", 
      SuperscriptBox["\[Eta]", "2"], " ", 
      SuperscriptBox["\[Xi]", "2"], " ", 
      SubscriptBox["Z", "mu"], " ", 
      SubscriptBox["Zp", "mu"]}], 
     SuperscriptBox["\[Chi]", "2"]]}]}],
  SequenceForm[
  "Non diagonal mass term found: ", 
   Rational[-1, 2] $CellContext`ca FeynRules`ee^2 $CellContext`sa 
    FeynRules`v^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca $CellContext`cw^2 
    FeynRules`ee^2 $CellContext`sa $CellContext`sw^(-2) 
    FeynRules`v^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sa $CellContext`sw^2 
    FeynRules`v^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca^2 FeynRules`ee^2 $CellContext`sw^(-1) 
    FeynRules`v^2 FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[1, 4] FeynRules`ee^2 $CellContext`sa^2 $CellContext`sw^(-1) 
    FeynRules`v^2 FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[-1, 4] $CellContext`ca^2 $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sw FeynRules`v^2 
    FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[1, 4] $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sa^2 $CellContext`sw FeynRules`v^2 
    FeynRules`\[Eta] $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] + 
   Rational[1, 4] $CellContext`ca $CellContext`cw^(-2) 
    FeynRules`ee^2 $CellContext`sa FeynRules`v^2 
    FeynRules`\[Eta]^2 $CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[
      FeynRules`Lorentz, 
       FeynRules`mu]] + $CellContext`ca $CellContext`gX^2 $CellContext`sa 
    FeynRules`\[Eta]^2 $CellContext`\[Xi]^2 $CellContext`\[Chi]^(-2) \
$CellContext`Z[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]] $CellContext`Zp[
      FeynRules`Index[FeynRules`Lorentz, FeynRules`mu]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.6049646383990307`*^9, 3.604974632631802*^9, 
  3.605233467511797*^9, 3.605250485736414*^9, 3.6091567208740463`*^9, 
  3.609239721341413*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["computing widths", "Section",
 CellChangeTimes->{{3.604964673012329*^9, 3.604964674219133*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"decays", "=", 
   RowBox[{"ComputeWidths", "[", 
    RowBox[{"FeynmanRules", "[", 
     RowBox[{"LHAHM", ",", " ", 
      RowBox[{"ScreenOutput", "\[Rule]", "False"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"UpdateWidths", "[", "decays", "]"}]}], "Input",
 CellChangeTimes->{{3.604964698503813*^9, 3.6049647587517157`*^9}, 
   3.6052499155507927`*^9, {3.6052709918253393`*^9, 3.605270991994774*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343060427`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397343083897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239734311686*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239736372183*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "74", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "74", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  74, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 74, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397364623947`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"73", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[73, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239740621428*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "73"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 73],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.60923974144049*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239743803046*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "72"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239744164736*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "65"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 65],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397470947237`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WH\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.00636986\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WH", " = ", "0.00636986", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239754590353*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WHS\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"18.4103\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WHS", " = ", "18.4103", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.6092397545921288`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WT\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"1.57377\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WT", " = ", "1.57377", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239754593815*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WW\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"2.09164\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WW", " = ", "2.09164", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239754595503*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZ\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"2.49969\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  
  SequenceForm["WZ", " = ", "2.49969", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239754597271*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WZp\"\>", "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", "\<\"0.0000354319\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["WZp", " = ", "0.0000354319", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.605311282595245*^9, 3.605570753630722*^9, 
  3.605571958113603*^9, 3.6055727984304256`*^9, 3.605581635995611*^9, 
  3.605939400580206*^9, 3.605940325291546*^9, 3.609239754598975*^9}]
}, Open  ]]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.6053057661784267`*^9, 3.605305766712928*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Export to UFO", "Section",
 CellChangeTimes->{{3.604964806489471*^9, 3.604964808080537*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SetDirectory", "[", "modeldir", "]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteUFO", "[", "LHAHM", "]"}]}], "Input",
 CellChangeTimes->{{3.604964810304481*^9, 3.604964842385274*^9}, {
  3.6066531173829193`*^9, 3.6066531174657927`*^9}}],

Cell[BoxData["\<\"/Users/davidcurtin/Documents/uni/Research/Collider_Physics/\
FeynRules_2.0/hidden_abelian_higgs_model_final\"\>"], "Output",
 CellChangeTimes->{
  3.604964842846836*^9, {3.6049746742098494`*^9, 3.6049746798957*^9}, 
   3.6052505022725983`*^9, 3.6055698549486017`*^9, 3.606647705150442*^9, 
   3.606653319113881*^9, 3.606653967968173*^9, 3.606671355670191*^9, 
   3.606671715361816*^9, 3.606726567740533*^9, 3.606747230788603*^9, 
   3.6091595675130453`*^9, 3.609166725787594*^9, 3.609171450142783*^9, 
   3.609181896362587*^9, 3.609236894073102*^9, 3.609240744677514*^9, 
   3.609241218960959*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241218962446*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.6092412191844053`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.6092412191864433`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241219187681*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.6092412213835087`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "74", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "74", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  74, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 74, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.6092412214696503`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"73", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[73, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241225704836*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "73"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 73],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241226654917*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241229443885*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241229471467*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "72"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241229472494*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "1.20782100000000003348077370901592075825`6.102602489557746", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Squared matrix elent compute in ", 
   1.20782100000000003348077370901592075825`6.102602489557746, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241232747692*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "65"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 65],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241232801581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.23039799999999999169375541896442882717`5.383078618097058", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Decay widths computed in ", 
   0.23039799999999999169375541896442882717`5.383078618097058, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241233026165*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241233027073*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241233183712*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.6092412332135468`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{22., {1., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "113", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 113, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241233732541*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.6092412338798523`*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.6066533191261473`*^9, 3.60665396799714*^9, 
  3.606671355671577*^9, 3.606671715363266*^9, 3.6067265679520197`*^9, 
  3.606747230790098*^9, 3.6091595675178432`*^9, 3.609166725803389*^9, 
  3.609171450145883*^9, 3.609181896369216*^9, 3.609236894074719*^9, 
  3.609240744679184*^9, 3.609241234535277*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1276, 668},
WindowMargins->{{Automatic, -1}, {Automatic, 5}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 20, \
2012)",
StyleDefinitions->FrontEnd`FileName[{$RootDirectory, "Applications", 
   "Mathematica.app", "SystemFiles", "FrontEnd", "StyleSheets", "Creative"}, 
  "PastelColor.nb", CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 185, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[767, 28, 284, 5, 61, "Title"],
Cell[CellGroupData[{
Cell[1076, 37, 1660, 34, 158, "Input"],
Cell[CellGroupData[{
Cell[2761, 75, 1011, 14, 22, "Print"],
Cell[3775, 91, 1289, 21, 21, "Print"],
Cell[5067, 114, 1063, 15, 22, "Print"],
Cell[6133, 131, 998, 14, 21, "Print"],
Cell[7134, 147, 1009, 14, 21, "Print"],
Cell[8146, 163, 1019, 14, 21, "Print"],
Cell[9168, 179, 1061, 15, 22, "Print"],
Cell[10232, 196, 1000, 14, 21, "Print"],
Cell[11235, 212, 1028, 14, 22, "Print"],
Cell[12266, 228, 998, 14, 21, "Print"],
Cell[13267, 244, 1067, 15, 22, "Print"],
Cell[14337, 261, 1039, 14, 22, "Print"],
Cell[15379, 277, 1018, 14, 21, "Print"],
Cell[16400, 293, 1143, 18, 21, "Print"],
Cell[17546, 313, 1008, 14, 21, "Print"],
Cell[18557, 329, 1105, 15, 22, "Print"],
Cell[19665, 346, 1064, 15, 22, "Print"],
Cell[20732, 363, 1045, 15, 22, "Print"],
Cell[21780, 380, 997, 14, 21, "Print"],
Cell[22780, 396, 1027, 14, 22, "Print"],
Cell[23810, 412, 1029, 14, 22, "Print"],
Cell[24842, 428, 1030, 14, 22, "Print"],
Cell[25875, 444, 1211, 19, 38, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27135, 469, 99, 1, 73, "Section"],
Cell[CellGroupData[{
Cell[27259, 474, 197, 3, 38, "Input"],
Cell[27459, 479, 18835, 581, 611, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46343, 1066, 126, 2, 43, "Section"],
Cell[CellGroupData[{
Cell[46494, 1072, 261, 4, 38, "Input"],
Cell[CellGroupData[{
Cell[46780, 1080, 348, 9, 22, "Print"],
Cell[47131, 1091, 103, 1, 22, "Print"],
Cell[47237, 1094, 277, 6, 22, "Print"],
Cell[47517, 1102, 136, 2, 22, "Print"],
Cell[47656, 1106, 617, 13, 22, "Print"],
Cell[48276, 1121, 218, 5, 21, "Print"]
}, Open  ]],
Cell[48509, 1129, 144631, 3899, 2980, "Output"]
}, Closed]],
Cell[193155, 5031, 112, 1, 26, "Text"],
Cell[193270, 5034, 328, 6, 38, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[193635, 5045, 107, 1, 43, "Section"],
Cell[CellGroupData[{
Cell[193767, 5050, 142, 2, 38, "Input"],
Cell[CellGroupData[{
Cell[193934, 5056, 449, 9, 22, "Print"],
Cell[194386, 5067, 2563, 59, 39, "Print"],
Cell[196952, 5128, 5923, 142, 96, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[202936, 5277, 101, 1, 43, "Section"],
Cell[CellGroupData[{
Cell[203062, 5282, 457, 10, 56, "Input"],
Cell[CellGroupData[{
Cell[203544, 5296, 512, 11, 22, "Print"],
Cell[204059, 5309, 267, 3, 22, "Print"],
Cell[204329, 5314, 439, 8, 22, "Print"],
Cell[204771, 5324, 298, 4, 22, "Print"],
Cell[205072, 5330, 781, 15, 22, "Print"],
Cell[205856, 5347, 380, 7, 21, "Print"],
Cell[206239, 5356, 733, 14, 22, "Print"],
Cell[206975, 5372, 546, 12, 22, "Print"],
Cell[207524, 5386, 500, 11, 21, "Print"],
Cell[208027, 5399, 502, 11, 21, "Print"],
Cell[208532, 5412, 462, 9, 21, "Print"],
Cell[208997, 5423, 459, 9, 21, "Print"],
Cell[209459, 5434, 455, 9, 21, "Print"],
Cell[209917, 5445, 455, 9, 21, "Print"],
Cell[210375, 5456, 455, 9, 21, "Print"],
Cell[210833, 5467, 468, 9, 22, "Print"]
}, Open  ]]
}, Open  ]],
Cell[211328, 5480, 84, 1, 29, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[211449, 5486, 98, 1, 43, "Section"],
Cell[CellGroupData[{
Cell[211572, 5491, 259, 4, 56, "Input"],
Cell[211834, 5497, 615, 9, 38, "Output"],
Cell[CellGroupData[{
Cell[212474, 5510, 406, 6, 22, "Print"],
Cell[212883, 5518, 631, 13, 22, "Print"],
Cell[213517, 5533, 386, 5, 22, "Print"],
Cell[213906, 5540, 558, 10, 22, "Print"],
Cell[214467, 5552, 419, 6, 22, "Print"],
Cell[214889, 5560, 900, 17, 22, "Print"],
Cell[215792, 5579, 499, 9, 21, "Print"],
Cell[216294, 5590, 853, 16, 22, "Print"],
Cell[217150, 5608, 398, 5, 21, "Print"],
Cell[217551, 5615, 665, 14, 22, "Print"],
Cell[218219, 5631, 619, 13, 21, "Print"],
Cell[218841, 5646, 707, 13, 22, "Print"],
Cell[219551, 5661, 619, 13, 21, "Print"],
Cell[220173, 5676, 693, 13, 22, "Print"],
Cell[220869, 5691, 381, 5, 22, "Print"],
Cell[221253, 5698, 405, 6, 22, "Print"],
Cell[221661, 5706, 598, 10, 22, "Print"],
Cell[222262, 5718, 755, 13, 22, "Print"],
Cell[223020, 5733, 379, 5, 22, "Print"],
Cell[223402, 5740, 362, 5, 21, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
