(**************************************************************************************************************)
(******                       This is the FeynRules mod-file for the Georgi-Machacek model                ******)
(******                                                                                                   ******)
(******                          Authors: Katy Hartling, Kunal Kumar, Heather E. Logan                    ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(******                                                                                                   ******)
(****** This .fr file was made by starting with SM.fr(v1.3) and modifying relevant sections               ******) 
(****** The implementation is based on arXiv:1404.2640                                                    ******)
(***************************************************************************************************************)


M$ModelName = "GM";

M$Information = {Authors -> {"K. Hartling", "K. Kumar","H. Logan"}, 
             Version -> "1.2",
             Date -> "12. 10. 2014",
             Institutions -> {"Carleton University"},
             Emails -> {"khally@physics.carleton.ca","kkumar@physics.carleton.ca","logan@physics.carleton.ca"},
             URLs -> "https://feynrules.irmp.ucl.ac.be/wiki/GeorgiMachacekModel"};

FR$DSign=-1;
FeynmanGauge = True;


(****** Change Log *******)
(*	v1.2 : Modified AntiParticleNames of some scalars for clarity        	*)	
(*             Changed name of EXT. variable th --> tanth for clarity 	 	*)
(*             Modified the labels used for some terms of the Lagrangian 	*)
(*             Modified default values of certain EXT. parameters        	*)
(*             Added the field "TeX-->" for EXT. parameters lam2-lam5    	*)

							

(******* Index definitions ********)

IndexRange[ Index[Generation] ] = Range[3]
IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]
IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]
IndexRange[ Index[SU2W] ] = Unfold[Range[3]]


IndexStyle[Colour, i]
IndexStyle[Generation, f]
IndexStyle[Gluon ,a]
IndexStyle[SU2W ,k]


(******* Gauge parameters (for FeynArts) ********)

GaugeXi[ V[1] ] = GaugeXi[A];
GaugeXi[ V[2] ] = GaugeXi[Z];
GaugeXi[ V[3] ] = GaugeXi[W];
GaugeXi[ V[4] ] = GaugeXi[G];
GaugeXi[ S[1] ] = 1;
GaugeXi[ S[2] ] = GaugeXi[Z];
GaugeXi[ S[3] ] = GaugeXi[W];
GaugeXi[ U[1] ] = GaugeXi[A];
GaugeXi[ U[2] ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4] ] = GaugeXi[G];

(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderHierarchy = {
     {QCD, 1},
     {QED, 2}
    };


(****************  Parameters *************)

M$Parameters = {

  (* External parameters *)

  \[Alpha]EWM1== {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        ParameterName -> aEWM1,
        InteractionOrder -> {QED, -2},
        Value -> 127.9,
        Description -> "Inverse of the electroweak coupling constant"},

  Gf == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        TeX -> Subscript[G, f],
        InteractionOrder -> {QED, 2},
        Value -> 1.16637 * 10^(-5),
        Description -> "Fermi constant"},

  \[Alpha]S == {
        ParameterType -> External,
        BlockName -> SMINPUTS,
        TeX -> Subscript[\[Alpha], s],
        ParameterName -> aS,
        InteractionOrder -> {QCD, 2},
        Value -> 0.1184,
        Description -> "Strong coupling constant at the Z pole."},

  ymdo == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 5.04*10^(-3),
	OrderBlock -> {1},
	Description -> "Down Yukawa mass"},


  ymup == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 2.55*10^(-3),
        OrderBlock -> {2},
        Description -> "Up Yukawa mass"},

  yms == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 0.101,
	OrderBlock -> {3},
	Description -> "Strange Yukawa mass"},


  ymc == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.27,
        OrderBlock -> {4},
        Description -> "Charm Yukawa mass"},

 ymb == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 4.7,
        OrderBlock -> {5},
        Description -> "Bottom Yukawa mass"},

  ymt == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 172.0,
        OrderBlock -> {6},
        Description -> "Top Yukawa mass"},

  yme == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value ->  5.11*10^(-4),
        OrderBlock -> {11},
        Description -> "Electron Yukawa mass"},

  ymm == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 0.10566,
        OrderBlock -> {13},
        Description -> "Muon Yukawa mass"},

  ymtau == {
        ParameterType -> External,
        BlockName -> YUKAWA,
        Value -> 1.777,
        OrderBlock -> {15},
        Description -> "Tau Yukawa mass"},

   cabi == {
        TeX -> Subscript[\[Theta], c],
        ParameterType -> External,
        BlockName -> CKMBLOCK,
        Value -> 0.227736,
        Description -> "Cabibbo angle"},


(* BSM EXTERNAL PARAMETERS *)
    
    lam2 == {
        ParameterType -> External,
        BlockName -> POTENTIALPARAM,
        Value -> 0.1,
        TeX -> Subscript[\[Lambda], 2],
        InteractionOrder -> {QED,2},
        Description -> "Ext. Scalar Potential"},

    lam3 == {
        ParameterType -> External,
        BlockName -> POTENTIALPARAM,
        Value -> 0.1,
	TeX -> Subscript[\[Lambda], 3],
        InteractionOrder -> {QED,2},
        Description -> "Ext. Scalar Potential"},

    lam4 == {
        ParameterType -> External,
        BlockName -> POTENTIALPARAM,
        Value -> 0.1,
	TeX -> Subscript[\[Lambda], 4],
        InteractionOrder -> {QED,2},
        Description -> "Ext. Scalar Potential"},

    lam5 == {
        ParameterType -> External,
        BlockName -> POTENTIALPARAM,
        Value -> 0.1,
	TeX -> Subscript[\[Lambda], 5],
        InteractionOrder -> {QED,2},
        Description -> "Ext. Scalar Potential"},

    M1coeff == {
        ParameterType -> External,
        BlockName -> POTENTIALPARAM,
        Value -> 100,
	TeX -> Subscript[M, 1],
        InteractionOrder -> {QED,1},
        Description -> "Ext. Scalar Potential (parameter M1)"},

     M2coeff == {
        ParameterType -> External,
        BlockName -> POTENTIALPARAM,
        Value -> 100,
	TeX -> Subscript[M, 2],
        InteractionOrder -> {QED,1},
        Description -> "Ext. Scalar Potential (parameter M2)"},

     tanth == {
        ParameterType -> External,
        BlockName -> VEV,
        Value -> 0.1,
	TeX -> Subscript[t, H],
        Description -> "tan(theta_H)"},
     

   (* Internal Parameters *)

  \[Alpha]EW == {
        ParameterType -> Internal,
        Value -> 1/\[Alpha]EWM1,
        TeX -> Subscript[\[Alpha], EW],
        ParameterName -> aEW,
        InteractionOrder -> {QED, 2},
        Description -> "Electroweak coupling contant"},


  MW == {
        ParameterType -> Internal,
        Value -> Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]*\[Alpha]EW/Gf*MZ^2]],
        TeX  -> Subscript[M, W],
        Description -> "W mass"},

  sw2 == {
        ParameterType -> Internal,
        Value -> 1-(MW/MZ)^2,
        Description -> "Squared Sin of the Weinberg angle"},

   ee == {
        TeX -> e,
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]EW],
        InteractionOrder -> {QED, 1},
        Description -> "Electric coupling constant"},

   cw == {
        TeX -> Subscript[c, w],
        ParameterType -> Internal,
        Value -> Sqrt[1 - sw2],
        Description -> "Cos of the Weinberg angle"},  

   sw == {
        TeX -> Subscript[s, w],
        ParameterType -> Internal,
        Value -> Sqrt[sw2],
        Description -> "Sin of the Weinberg angle"},  

   gw == {
        TeX -> Subscript[g, w],
        ParameterType -> Internal,
        Value -> ee / sw,
        InteractionOrder -> {QED, 1},
        Description -> "Weak coupling constant"},

   g1 == {
        TeX -> Subscript[g, 1],
        ParameterType -> Internal,
        Value -> ee / cw,
        InteractionOrder -> {QED, 1},
        Description -> "U(1)Y coupling constant"},

   gs == {
        TeX -> Subscript[g, s],
        ParameterType -> Internal,
        Value -> Sqrt[4 Pi \[Alpha]S],
        InteractionOrder -> {QCD, 1},
        ParameterName -> G,
        Description -> "Strong coupling constant"},


   v == {
        ParameterType -> Internal,
        Value -> (* 2*MW*sw/ee *) 1/Sqrt[Sqrt[2] Gf] ,  
        InteractionOrder -> {QED, -1},
        Description -> "SM Higgs VEV"},

(*BLOCK WITH A SUBSET OF NEW INTERNAL PARAMS *)

    sh == {
        ParameterType -> Internal,
        Value -> tanth/Sqrt[1 + tanth^2],
	TeX -> Subscript[s,H],
        Description -> "Sine of theta_H"},

    ch == {
        ParameterType -> Internal,
        Value -> Sqrt[1-sh^2],
	TeX -> Subscript[c,H],
        Description -> "Cosine of theta_H"},


      vchi == {
        ParameterType -> Internal,
        Value -> sh/Sqrt[8 Sqrt[2]Gf],
	TeX -> Subscript[v,\[Chi]],
        InteractionOrder -> {QED,-1},
        Description -> "Triplet vev"},

      vphi == {
        ParameterType -> Internal,
        Value -> 2 Sqrt[2] vchi/tanth,
	TeX -> Subscript[v,\[Phi]],
        InteractionOrder -> {QED,-1},
        Description -> "Doublet vev"},

(*  END OF BLOCK*)


   yl == {
        TeX -> Superscript[y, l],
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yl[1] -> Sqrt[2] yme / vphi, yl[2] -> Sqrt[2] ymm / vphi, yl[3] -> Sqrt[2] ymtau / vphi},
        ParameterName -> {yl[1] -> ye, yl[2] -> ym, yl[3] -> ytau},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "Lepton Yukawa coupling"},

   yu == {
        TeX -> Superscript[y, u],
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yu[1] -> Sqrt[2] ymup / vphi, yu[2] -> Sqrt[2] ymc / vphi, yu[3] -> Sqrt[2] ymt / vphi},
        ParameterName -> {yu[1] -> yup, yu[2] -> yc, yu[3] -> yt},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "U-quark Yukawa coupling"},

   yd == {
        TeX -> Superscript[y, d],
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {yd[1] -> Sqrt[2] ymdo / vphi, yd[2] -> Sqrt[2] yms / vphi, yd[3] -> Sqrt[2] ymb / vphi},
        ParameterName -> {yd[1] -> ydo, yd[2] -> ys, yd[3] -> yb},
        InteractionOrder -> {QED, 1},
        ComplexParameter -> False,
        Description -> "D-quark Yukawa coupling"},

(* N. B. : only Cabibbo mixing! *)
  CKM == { 
       Indices -> {Index[Generation], Index[Generation]},
       TensorClass -> CKM,
       Unitary -> True,
       Value -> {CKM[1,1] -> Cos[cabi],
                 CKM[1,2] -> Sin[cabi],
                 CKM[1,3] -> 0,
                 CKM[2,1] -> -Sin[cabi],
                 CKM[2,2] -> Cos[cabi],
                 CKM[2,3] -> 0,
                 CKM[3,1] -> 0,
                 CKM[3,2] -> 0,
                 CKM[3,3] -> 1},
       Description -> "CKM-Matrix"},

(* BLOCK WITH REMAINING NEW INTERNAL PARAMETERS *)

    MH3 == {
        ParameterType -> Internal,
        Value -> Sqrt[(M1coeff/(4 vchi) + lam5/2) v^2 ],
        TeX  -> Subscript[M, 3],
        Description -> "SU(2)_C triplet mass"},

    MH5 == {
        ParameterType -> Internal,
        Value -> Sqrt[ M1coeff vphi^2 /(4 vchi) + 12 M2coeff vchi + (3/2) lam5 vphi^2 + 8 lam3 vchi^2 ] ,
        TeX  -> Subscript[M, 5],
        Description -> "SU(2)_C fiveplet mass"},


    Mat12sq == {
        ParameterType -> Internal,
        Value -> (Sqrt[3]/2) vphi (-M1coeff + 4 (2 lam2 - lam5) vchi) ,
        Description -> "Singlet Scalar Mass Matrix Element"},

    Mat22sq == {
        ParameterType -> Internal,
        Value -> M1coeff vphi^2/(4 vchi) - 6 M2coeff vchi + 8(lam3 + 3 lam4) vchi^2,
        Description -> "Singlet Scalar Mass Matrix Element"},


    lam1 == {
        ParameterType -> Internal,
        BlockName -> POTENTIALPARAM,
        Value -> (1/(8 vphi^2))(Mh^2 + Mat12sq^2/(Mat22sq - Mh^2)),
	TeX -> Subscript[\[Lambda],1],
        InteractionOrder -> {QED,2},
        Description -> "Ext. Scalar Potential"},

    Mat11sq == {
        ParameterType -> Internal,
        Value -> 8 lam1 vphi^2,
        Description -> "Singlet Scalar Mass Matrix Element"}, 

    MH == {
        ParameterType -> Internal,
        Value -> Sqrt[Mat11sq + Mat22sq - Mh^2],
        TeX  -> Subscript[M, H],
        Description -> " mass of the other higgs that is lighter/heavier than the 125 GeV resonance "},

   sa == {
        ParameterType -> Internal,
        Value -> Sin[0.5 ArcSin[2 Mat12sq/(MH^2 - Mh^2)]],
	TeX  -> Subscript[s, \[Alpha]],
        Description -> "Sine of the mixing angle alpha"},

    ca == {
        ParameterType -> Internal,
        Value -> Sqrt[1-sa^2],
	 TeX  -> Subscript[c, \[Alpha]],
        Description -> "Cosine of the mixing angle alpha"},

    mu2sq == {
        ParameterType -> Internal,
        Value -> -4 lam1 vphi^2 -3(2 lam2 - lam5) vchi^2 + (3/2) M1coeff vchi,
        Description -> "Ext. Scalar Potential (parameter \\mu_2^2)"},

    mu3sq == {
        ParameterType -> Internal,
        Value -> -(2 lam2 - lam5)vphi^2 - 4(lam3 + 3 lam4) vchi^2 + M1coeff vphi^2/(4 vchi) + 6 M2coeff vchi,
        Description -> "Ext. Scalar Potential (parameter \\mu_3^2)"}

(* END OF NEW INT. PARAMS *)

}


(************** Gauge Groups ******************)

M$GaugeGroups = {

  U1Y == {
        Abelian -> True,
        GaugeBoson -> B,
        Charge -> Y,
        CouplingConstant -> g1},

  SU2L == {
        Abelian -> False,
        GaugeBoson -> Wi,
        StructureConstant -> Eps,
        CouplingConstant -> gw},

  SU3C == {
        Abelian -> False,
        GaugeBoson -> G,
        StructureConstant -> f,
        SymmetricTensor -> dSUN,
        Representations -> {T, Colour},
        CouplingConstant -> gs}
}

(********* Particle Classes **********)

M$ClassesDescription = {

(********** Fermions ************)
	(* Leptons (neutrino): I_3 = +1/2, Q = 0 *)
  F[1] == {
        ClassName -> vl,
        ClassMembers -> {ve,vm,vt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
        Mass -> 0,
        Width -> 0,
	QuantumNumbers -> {LeptonNumber -> 1},
	PropagatorLabel -> {"v", "ve", "vm", "vt"} ,
	PropagatorType -> S,
	PropagatorArrow -> Forward,
        PDG -> {12,14,16},
        FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} },

	(* Leptons (electron): I_3 = -1/2, Q = -1 *)
  F[2] == {
        ClassName -> l,
        ClassMembers -> {e, m, tt},
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation]},
	Mass -> {Ml, {Me, 5.11 * 10^(-4)}, {MM, 0.10566}, {MTA, 1.777}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
	PropagatorLabel -> {"l", "e", "m", "tt"},
	PropagatorType -> Straight,
        ParticleName -> {"e-", "m-", "tt-"},
        AntiParticleName -> {"e+", "m+", "tt+"},
	PropagatorArrow -> Forward,
        PDG -> {11, 13, 15},
        FullName -> {"Electron", "Muon", "Tau"} },

	(* Quarks (u): I_3 = +1/2, Q = +2/3 *)
  F[3] == {
        ClassMembers -> {u, c, t},
        ClassName -> uq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Mu, {MU, 2.55*10^(-3)}, {MC, 1.42}, {MT, 172}},
        Width -> {0, 0, {WT, 1.50833649}},
	QuantumNumbers -> {Q -> 2/3},
	PropagatorLabel -> {"uq", "u", "c", "t"},
	PropagatorType -> Straight,
	PropagatorArrow -> Forward,
        PDG -> {2, 4, 6}, 
        FullName -> {"u-quark", "c-quark", "t-quark"}},

	(* Quarks (d): I_3 = -1/2, Q = -1/3 *) 
  F[4] == {
        ClassMembers -> {d, s, b},
        ClassName -> dq,
        FlavorIndex -> Generation,
	SelfConjugate -> False,
	Indices -> {Index[Generation], Index[Colour]},
	Mass -> {Md, {MD,  5.04*10^(-3)}, {MS, 0.101}, {MB, 4.7}},
        Width -> 0,
	QuantumNumbers -> {Q -> -1/3},
	PropagatorLabel -> {"dq", "d", "s", "b"},
	PropagatorType -> Straight, 
	PropagatorArrow -> Forward,
        PDG -> {1,3,5},
        FullName -> {"d-quark", "s-quark", "b-quark"} },

(********** Ghosts **********)
	U[1] == {
       ClassName -> ghA,
       SelfConjugate -> False,
       Indices -> {},
       Ghost -> A,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uA,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

	U[2] == {
       ClassName -> ghZ,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MZ, 91.1876},
       Ghost -> Z,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uZ,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

	U[31] == {
       ClassName -> ghWp,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MW, Internal},
       Ghost -> W,
       QuantumNumbers -> {Q-> 1, GhostNumber -> 1},
       PropagatorLabel -> uWp,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

   U[32] == {
       ClassName -> ghWm,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MW, Internal},
       Ghost -> Wbar,
       QuantumNumbers -> {Q-> -1, GhostNumber -> 1},
       PropagatorLabel -> uWm,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

 	U[4] == {
       ClassName -> ghG,
       SelfConjugate -> False,
       Indices -> {Index[Gluon]},
       Ghost -> G,
       Mass -> 0,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uG,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},

	U[5] == {
        ClassName -> ghWi,
        Unphysical -> True,
        Definitions -> {ghWi[1] -> (ghWp + ghWm)/Sqrt[2],
                        ghWi[2] -> (ghWm - ghWp)/Sqrt[2]/I,
                        ghWi[3] -> cw ghZ + sw ghA},
        SelfConjugate -> False,
        Ghost -> Wi,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W},

	U[6] == {
        ClassName -> ghB,
	SelfConjugate -> False,
        Definitions -> {ghB -> -sw ghZ + cw ghA},
	Indices -> {},
        Ghost -> B,
        Unphysical -> True},

(************ Gauge Bosons ***************)
	(* Gauge bosons: Q = 0 *)
  V[1] == {
        ClassName -> A,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
        Width -> 0,
	PropagatorLabel -> "a",
	PropagatorType -> W,
	PropagatorArrow -> None,
        PDG -> 22,
        FullName -> "Photon" },

  V[2] == {
        ClassName -> Z,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZ, 91.1876},
        Width -> {WZ, 2.4952},
	PropagatorLabel -> "Z",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 23,
        FullName -> "Z" },

	(* Gauge bosons: Q = -1 *)
  V[3] == {
        ClassName -> W,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
        Width -> {WW, 2.085},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "W",
	PropagatorType -> Sine,
	PropagatorArrow -> Forward,
	ParticleName ->"W+",
	TeXParticleName ->"W^+",
	AntiParticleName ->"W-",
	TeXAntiParticleName ->"W-",
        PDG -> 24,
        FullName -> "W" },

V[4] == {
        ClassName -> G,
	SelfConjugate -> True,
	Indices -> {Index[Gluon]},
	Mass -> 0,
        Width -> 0,
        PropagatorLabel -> G,
	PropagatorType -> C,
	PropagatorArrow -> None,
        PDG -> 21,
        FullName -> "G" },

V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> cw Z[mu] + sw A[mu]},
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},
        FlavorIndex -> SU2W,
        Mass -> 0,
        PDG -> {1,2,3}},

V[6] == {
        ClassName -> B,
	SelfConjugate -> True,
        Definitions -> {B[mu_] -> -sw Z[mu] + cw A[mu]},
	Indices -> {},
	Mass -> 0,
        Unphysical -> True},


(************ Scalar Fields **********)
	(* physical Higgs: Q = 0 *) 
 S[1] == {
        ClassName -> h,
        SelfConjugate -> True,
        Mass -> {Mh, 125},
        Width -> {Wh, 0.00575308848},
        PropagatorLabel -> "h",
        PropagatorType -> D,
        PropagatorArrow -> None,
        PDG -> 25,
        TeXParticleName -> "h",
        TeXClassName -> "h",
        FullName -> "h" },

S[2] == {
        ClassName -> G0,
        SelfConjugate -> True,
        Mass -> {MZ, 91.1876},
        Width -> WG0,
        PropagatorLabel -> "G0",
        PropagatorType -> D,
        PropagatorArrow -> None,
        ParticleName ->"G0",
        TeXParticleName ->"G^0",
        PDG -> 250,
        FullName -> "G0",
        Goldstone -> Z },

S[3] == {
        ClassName -> Gp,
        SelfConjugate -> False,
        Mass -> {MW, Internal},
        Width -> WGp,
        PropagatorLabel -> "Gp",
        PropagatorType -> D,
        PropagatorArrow -> None,
        ParticleName ->"G+",
        AntiParticleName ->"G-",
        PDG -> 251,
        FullName -> "Gp",
        TeXClassName -> "G^+",
        TeXParticleName -> "G^+",
        TeXAntiParticleName -> "G^-",
        Goldstone -> W,
        QuantumNumbers -> {Q -> 1}},

S[4] ==  {
        ClassName -> H,
        SelfConjugate -> True,
        Mass -> {MH,Internal},
        Width -> {WH,1},
        PropagatorLabel -> "H",
        PropagatorType -> D,
        PropagatorArrow -> None,
        PDG -> 252,
        TeXParticleName -> "H",
        TeXClassName -> "H",
        FullName -> "H" },

S[5] ==  {
        ClassName -> H3p,
        SelfConjugate -> False,
        Mass -> {MH3,Internal},
        Width -> {WH3p,1},
        PropagatorLabel -> "H3p",
        PropagatorType -> D,
        PropagatorArrow -> None,
        ParticleName -> "H3p",
        AntiParticleName -> "H3p~",
        PDG -> 253,
        FullName -> "H3p",
        TeXClassName -> "H_3^+",
        TeXParticleName -> "H_3^+",
	TeXAntiParticleName -> "H_3^{+*}",
        TeXClassName -> "H_3^+",
        QuantumNumbers -> {Q -> 1} },

S[6] == {
        ClassName -> H3z,
        SelfConjugate -> True,
        Mass -> {MH3,Internal},
        Width -> {WH3z,1},
        PropagatorLabel -> "H3z",
        PropagatorType -> D,
        PropagatorArrow -> None,
        PDG -> 254,
        TeXParticleName -> "H_3^0",
        TeXClassName -> "H_3^0",
        FullName -> "H3z" },
S[7] ==  {
        ClassName -> H5pp,
        SelfConjugate -> False,
        Mass -> {MH5,Internal},
        Width -> {WH5pp,1},
        PropagatorLabel -> "H5pp",
        PropagatorType -> D,
        PropagatorArrow -> None,
        ParticleName -> "H5pp",
        AntiParticleName -> "H5pp~",
        PDG -> 255,
        FullName -> "H5pp",
        TeXClassName -> "H_5^{++}",
        TeXParticleName -> "H_5^{++}",
	TeXAntiParticleName -> "H_5^{++*}",
        TeXClassName -> "H_5^{++}",
        QuantumNumbers -> {Q -> 2} },

S[8] ==  {
        ClassName -> H5p,
        SelfConjugate -> False,
        Mass -> {MH5,Internal},
        Width -> {WH5p,1},
        PropagatorLabel -> "H5p",
        PropagatorType -> D,
        PropagatorArrow -> None,
        ParticleName -> "H5p",
        AntiParticleName -> "H5p~",
        PDG -> 256,
        FullName -> "H5p",
        TeXClassName -> "H_5^+",
        TeXParticleName -> "H_5^+",
	TeXAntiParticleName -> "H_5^{+*}",
        TeXClassName -> "H_5^+",
        QuantumNumbers -> {Q -> 1} },

S[9] == {
        ClassName -> H5z,
        SelfConjugate -> True,
        Mass -> {MH5,Internal},
        Width -> {WH5z,1},
        PropagatorLabel -> "H5z",
        PropagatorType -> D,
        PropagatorArrow -> None,
        PDG -> 257,
        TeXParticleName -> "H_5^0",
        TeXClassName -> "H_5^0",
        FullName -> "H5z" }

}

(* define replacements needed in case unitary gauge is chosen *) 
ugauge = {Gp->0,Gpbar->0,G0->0};


PHItemp := {{(vphi + ca h + sa H)/Sqrt[2] - (I/Sqrt[2])(ch G0 - sh H3z), ch Gp - sh H3p }
         ,{ch (-Gpbar) -sh (-H3pbar), (vphi + ca h + sa H)/Sqrt[2] + (I/Sqrt[2])(ch G0 - sh H3z)}};

PHIdagtemp := {{(vphi + ca h + sa H)/Sqrt[2] + (I/Sqrt[2])(ch G0 - sh H3z), -(ch Gp - sh H3p)},
           {-(ch(-Gpbar) - sh (-H3pbar)), (vphi + ca h + sa H)/Sqrt[2] - (I/Sqrt[2])(ch G0 - sh H3z)}};

Xtemp := {{(1/Sqrt[2])(-Sqrt[2/3] sa h + Sqrt[2/3] ca H - Sqrt[1/3] H5z)
                                    - (I/Sqrt[2])(sh G0 + ch H3z) + vchi , (sh/Sqrt[2])Gp + (ch/Sqrt[2] H3p -(1/Sqrt[2])H5p), H5pp},
      {(sh/Sqrt[2])(-Gpbar) +(ch/Sqrt[2])(-H3pbar) + (1/Sqrt[2])(-H5pbar),-(sa/Sqrt[3]) h + (ca/Sqrt[3])H + Sqrt[2/3]H5z +vchi,
        (sh/Sqrt[2])Gp +(ch/Sqrt[2])H3p + (1/Sqrt[2])H5p},
      {H5ppbar,(sh/Sqrt[2])(-Gpbar) + (ch/Sqrt[2] (-H3pbar) +(1/Sqrt[2])(H5pbar)),(1/Sqrt[2])(-Sqrt[2/3] sa h + Sqrt[2/3]   ca H - Sqrt[1/3] H5z)  + (I/Sqrt[2])(sh G0 + ch H3z) + vchi}};

Xdagtemp := {{(1/Sqrt[2])(-Sqrt[2/3] sa h + Sqrt[2/3] ca H - Sqrt[1/3] H5z)  + (I/Sqrt[2])(sh G0 + ch H3z) +vchi ,-((sh/Sqrt[2])Gp +(ch/Sqrt[2])H3p + (1/Sqrt[2])H5p), H5pp },
         {-((sh/Sqrt[2])(-Gpbar) + (ch/Sqrt[2](- H3pbar) -(1/Sqrt[2])(-H5pbar))), -(sa/Sqrt[3]) h + (ca/Sqrt[3])H + Sqrt[2/3]H5z + vchi,
          -((sh/Sqrt[2])Gp + (ch/Sqrt[2] H3p -(1/Sqrt[2])H5p))},
         {H5ppbar,-((sh/Sqrt[2])(-Gpbar) +(ch/Sqrt[2])(-H3pbar) + (1/Sqrt[2])(-H5pbar)),
          (1/Sqrt[2])(-Sqrt[2/3] sa h + Sqrt[2/3] ca H - Sqrt[1/3] H5z)
                                    - (I/Sqrt[2])(sh G0 + ch H3z) + vchi}};

(* Defining bi-doublet PHI and bi-triplet X for Feynman gauge or Unitary Gauge  *)

PHI := If[FeynmanGauge,PHItemp,PHItemp/.ugauge];
PHIdag := If[FeynmanGauge,PHIdagtemp,PHIdagtemp/.ugauge];
X := If[FeynmanGauge,Xtemp,Xtemp/.ugauge];
Xdag := If[FeynmanGauge,Xdagtemp,Xdagtemp/.ugauge];

(* Matrix that rotates X to Cartesian basis *)
MatU := {{ -1/Sqrt[2], 0,1/Sqrt[2]},
         { -I/Sqrt[2],0, -I/Sqrt[2]},
         {0,1,0}};
  
MatUdag := {{ -1/Sqrt[2], I/Sqrt[2],0},
                {0,0,1},
                {1/Sqrt[2], I/Sqrt[2],0}};

(* Generators of SU(2) doublet representation  *)
t2 = Table[{{0,0},{0,0}},{itemp,1,3}];
For[itemp=1,itemp<=3,itemp++,
For[jtemp=1,jtemp<=2,jtemp++,
For[ktemp=1,ktemp<=2,ktemp++,
t2[[itemp,jtemp,ktemp]] = PauliSigma[itemp,jtemp,ktemp]/2];];];

(* Generators of SU(2) triplet representation   *)
t3 = Table[{{0,0,0},{0,0,0},{0,0,0}},{i,1,3}];
t3[[1]]={{0,1/Sqrt[2],0},{1/Sqrt[2],0,1/Sqrt[2]},{0,1/Sqrt[2],0}};
t3[[2]]={{0,-I/Sqrt[2],0},{I/Sqrt[2],0,-I/Sqrt[2]},{0,I/Sqrt[2],0}};
t3[[3]]={{1,0,0},{0,0,0},{0,0,-1}};


(******************** Gauge F^2 Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LGauge = -1/4 (del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw Eps[i1, i2, i3] Wi[mu, i2] Wi[nu, i3])*
 					(del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw Eps[i1, i4, i5] Wi[mu, i4] Wi[nu, i5]) -
	
	1/4 (del[B[nu], mu] - del[B[mu], nu])^2 -
	
	1/4 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3])*
 		 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a4, a5] G[mu, a4] G[nu, a5]);


(********************* Fermion Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

    Lkin = I uqbar.Ga[mu].del[uq, mu] + 
    	I dqbar.Ga[mu].del[dq, mu] + 
    	I lbar.Ga[mu].del[l, mu] + 
    	I vlbar.Ga[mu].del[vl, mu];

    LQCD = gs (uqbar.Ga[mu].T[a].uq + 
    	dqbar.Ga[mu].T[a].dq)G[mu, a];

    LBright = 
       -2ee/cw B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
    	4ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjP.uq -       (*Y_uR=4/3*)
    	2ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjP.dq;        (*Y_dR=-2/3*)

    LBleft = 
       -ee/cw B[mu]/2 vlbar.Ga[mu].ProjM.vl -          (*Y_LL=-1*)
    	ee/cw B[mu]/2 lbar.Ga[mu].ProjM.l  +           (*Y_LL=-1*)
    	ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjM.uq +        (*Y_QL=1/3*)
    	ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjM.dq ;        (*Y_QL=1/3*)
	
    LWleft = ee/sw/2(
	vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
    	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
    	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+
    	
    	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
    	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
    	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
    	);

    Lkin + LQCD + LBright + LBleft + LWleft];




(*************** Yukawa Lagrangian***********************)
(* ProjP is the chiral projection operator P_R = (1+gamma^5)/2. In uqbar[s,n,i] i is the color index and n denotes generation *) 

LYuk := If[FeynmanGauge,

      Module[{s,r,n,m,i},                                                                 -
              yd[m] CKM[n,m]     uqbar[s,n,i].ProjP[s,r].dq[r,m,i] ( ch Gp -sh H3p)              -
              yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] ((vphi + ca h + sa H)/Sqrt[2] + (I/Sqrt[2])(ch G0 - sh H3z))   -

              yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] ((vphi + ca h + sa H)/Sqrt[2] - (I/Sqrt[2])(ch G0 - sh H3z))   + (*This sign from eps matrix*)
              yu[m] Conjugate[CKM[m,n]] dqbar[s,n,i].ProjP[s,r].uq[r,m,i] ( ch Gpbar -sh H3pbar)    -

              yl[n]              vlbar[s,n].ProjP[s,r].l[r,n]  ( ch Gp -sh H3p)               -
              yl[n]               lbar[s,n].ProjP[s,r].l[r,n]  ((vphi + ca h + sa H)/Sqrt[2] + (I/Sqrt[2])(ch G0 - sh H3z)) 
           ],
       Module[{s,r,n,m,i},                                                                 -
              yd[m] CKM[n,m]     uqbar[s,n,i].ProjP[s,r].dq[r,m,i] ( -sh H3p)              -
              yd[n]              dqbar[s,n,i].ProjP[s,r].dq[r,n,i] ((vphi + ca h + sa H)/Sqrt[2] + (I/Sqrt[2])( - sh H3z))   -

              yu[n]              uqbar[s,n,i].ProjP[s,r].uq[r,n,i] ((vphi + ca h + sa H)/Sqrt[2] - (I/Sqrt[2])( - sh H3z))   + (*This sign from eps matrix*)
              yu[m] Conjugate[CKM[m,n]] dqbar[s,n,i].ProjP[s,r].uq[r,m,i] (  -sh H3pbar)    -

              yl[n]              vlbar[s,n].ProjP[s,r].l[r,n]  ( -sh H3p)               -
              yl[n]               lbar[s,n].ProjP[s,r].l[r,n]  ((vphi + ca h + sa H)/Sqrt[2] + (I/Sqrt[2])( - sh H3z)) 
           ]
         ];

LYukawa := LYuk + HC[LYuk];


(**************Ghost terms**************************)
(* Now we need the ghost terms which are of the form:             *)
(* - g * antighost * d_BRST G                                     *)
(* where d_BRST G is BRST transform of the gauge fixing function. *)

LGhost := If[FeynmanGauge, 
		Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];
 	
	dBRSTWi[mu_,i_] := sw/ee Module[{i2, i3}, del[ghWi[i], mu] + ee/sw Eps[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ee/sw ghWibar[a].del[dBRSTWi[mu,a],mu];	
 	
	dBRSTB[mu_] := cw/ee del[ghB, mu];
		LGhostB := - ee/cw ghBbar.del[dBRSTB[mu],mu];
	
	(***********Next the piece from the scalar field.************)
		 LGhostphi := -   ee/(2*sw*cw) MW ( Gp   ( (cw^2-sw^2)ghWpbar.ghZ + 2sw*cw ghWpbar.ghA )  +
                         Gpbar ( (cw^2-sw^2)ghWmbar.ghZ + 2sw*cw ghWmbar.ghA )    ) -
                        ee/(2*sw) MW ( ( (v+h) + I G0) ghWpbar.ghWp + ( (v + h) - I G0) ghWmbar.ghWm   ) -
                        I ee/(2*sw) MZ ( I Gpbar ghZbar.ghWp + I Gp ghZbar.ghWm ) -
                        ee/(2*sw*cw) MZ (v + h) ghZbar.ghZ ;

	
		 	
	(***********Now add the pieces together.********************)
	LGhostG + LGhostWi + LGhostB + LGhostphi]

, 

        (*If unitary gauge, only include the gluonic ghost.*)
                Block[{dBRSTG,LGhostG},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];		 	
		 	
	(***********Now add the pieces together.********************)
	LGhostG]

];

(***SCALAR POTENTIAL****)

        Potmu2 := Tr[PHIdag.PHI];
        Potmu3 := Tr[Xdag.X];
        Potlam1 := (Tr[PHIdag.PHI])^2;
        Potlam2 := Tr[PHIdag.PHI] Tr[Xdag.X];
        Potlam3 := Tr[Xdag.X.Xdag.X];
        Potlam4 := (Tr[Xdag.X])^2;
        Potlam5 := Sum[Tr[PHIdag.t2[[a]].PHI.t2[[b]]] Tr[Xdag.t3[[a]].X.t3[[b]]],{a,1,3},{b,1,3}];

        PotM1 := Sum[Tr[PHIdag.t2[[a]].PHI.t2[[b]]] MatU[[a, c]] X[[c, d]] MatUdag[[d,
     b]], {a, 1, 3}, {b, 1, 3}, {c, 1, 3}, {d, 1, 3}];
        PotM2 := Sum[Tr[Xdag.t3[[a]].X.t3[[b]]] MatU[[a, c]] X[[c, d]] MatUdag[[d,
     b]], {a, 1, 3}, {b, 1, 3}, {c, 1, 3}, {d, 1, 3}];

   ScPot := (mu2sq/2) Potmu2 +
          (mu3sq/2) Potmu3 +
          lam1 Potlam1 +
          lam2 Potlam2 +
          lam3 Potlam3 +
          lam4 Potlam4 -
          lam5 Potlam5 -
          M1coeff PotM1 -
          M2coeff PotM2;
    
   LScPot := -ScPot;

(*****SCALAR KINETIC TERMS ****)

PMVec2 = Table[PauliSigma[itemp], {itemp, 3}];
PMVec3 = Table[t3[[itemp]], {itemp, 3}];

Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};
Dc2[f_, mu_] :=
   I del[f, mu] - (ee/cw) ( B[mu]/2) f.PMVec2[[3]] +
    ee/sw/2 (Sum[Wvec[mu][[itemp]] PMVec2[[itemp]], {itemp, 1, 3}]).f;

Dc2bar[f_, mu_] := -I del[f, mu] - ee/cw B[mu]/2 (PMVec2[[3]].f) +
    ee/sw/2 f.(Sum[Wvec[mu][[itemp]] PMVec2[[itemp]], {itemp, 1, 3}]);

Dc3[f_, mu_] :=
   I del[f, mu] - (ee/cw) B[mu] f.PMVec3[[3]] +
    ee/sw (Sum[Wvec[mu][[itemp]] PMVec3[[itemp]], {itemp, 1, 3}]).f;

Dc3bar[f_, mu_] := -I del[f, mu] - ee/cw B[mu] (PMVec3[[3]].f) +
    ee/sw f.(Sum[Wvec[mu][[itemp]] PMVec3[[itemp]], {itemp, 1, 3}]);

LScKin :=1/2 Tr[(Dc2bar[PHIdag, mu]).Dc2[PHI, mu]] +
 1/2 Tr[(Dc3bar[Xdag, mu]).Dc3[X, mu]];	

LScalar := LScPot + LScKin;
	
(*********Total GM Lagrangian*******)
 LGM := LGauge + LFermions + LYukawa  + LGhost + LScalar;	 	
