(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60086,       1651]
NotebookOptionsPosition[     52694,       1409]
NotebookOutlinePosition[     53173,       1428]
CellTagsIndexPosition[     53130,       1425]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.615736665212343*^9}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4921467751527157`*^9, 3.492146776183146*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", "\"\<<address of the package>\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.602217995985836*^9, 3.6022179998047447`*^9}, {
  3.6272250139168673`*^9, 3.627225019803317*^9}}],

Cell[BoxData["\<\"/Users/kunalkumar/Tools/FR/feynrules-current\"\>"], "Output",
 CellChangeTimes->{
  3.602218005815249*^9, 3.602231481670665*^9, 3.602260718337453*^9, 
   3.602260838933773*^9, 3.602607691849435*^9, 3.6029478802669573`*^9, 
   3.6029496404616213`*^9, 3.602950953302823*^9, 3.60295217078552*^9, 
   3.602957243630823*^9, 3.603043284760852*^9, 3.605543126734695*^9, 
   3.605588590147891*^9, 3.605982445695034*^9, 3.6066571884103403`*^9, 
   3.6098155077818832`*^9, 3.609855927715042*^9, 3.623482023151462*^9, 
   3.623483777368164*^9, 3.6237733948987722`*^9, 3.624197684073341*^9, 
   3.624200036088786*^9, 3.6242002335254097`*^9, 3.6242002772410383`*^9, 
   3.624200334261507*^9, 3.624200474452684*^9, 3.624204570665675*^9, 
   3.6242048529438257`*^9, 3.624214439811397*^9, 3.624214729267809*^9, 
   3.624216008121912*^9, 3.6243675057720957`*^9, 3.624367661623311*^9, 
   3.624368828308498*^9, 3.624370400584598*^9, 3.6243705661140547`*^9, 
   3.6243706674879847`*^9, 3.62437092299825*^9, 3.624370996944985*^9, 
   3.624371132288024*^9, 3.624371222340218*^9, 3.62437127938163*^9, 
   3.6243716684161*^9, 3.62437322814981*^9, 3.624374004568513*^9, {
   3.624374073420727*^9, 3.624374091945863*^9}, 3.625227735306149*^9, 
   3.625336905088808*^9, 3.625594472301175*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.547535564344927*^9, 3.547535564971527*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.625594472490453*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.0.17\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"19 February 2014\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.0.17", " (" "19 February 2014", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.6255944724997873`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.625594472506364*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.625594472512669*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.6255944725185337`*^9}],

Cell[BoxData["\<\"    - arXiv:1310.1921;\"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.6255944725225487`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.625594472526099*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.6255944725318832`*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.625594472535754*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.62559447253905*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.6243705667506647`*^9, 3.624370668494337*^9, 3.624370924730633*^9, 
   3.6243709979531603`*^9, 3.6243711333287497`*^9, 3.624371223559156*^9, 
   3.624371280702222*^9, 3.624371669489863*^9, 3.624373230520236*^9, 
   3.624374005686028*^9, {3.624374075055183*^9, 3.62437409331072*^9}, 
   3.6252277364299603`*^9, 3.625336938772874*^9, 3.625594472543333*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\<< model directory address>\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.602218019181407*^9, 3.602218020115342*^9}, {3.62348203003272*^9, 
  3.623482032128873*^9}, {3.62559445517922*^9, 3.62559446042483*^9}, {
  3.627225032859611*^9, 3.627225084578452*^9}}],

Cell[CellGroupData[{

Cell["The Georgi-Machacek (GM) Model", "Title",
 CellChangeTimes->{{3.6242046763422813`*^9, 3.6242046876458893`*^9}}],

Cell["We first load in the Standard Model model-file", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<GM.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, 3.542453089813714*^9, 3.547534567644828*^9, {
   3.6022180331507263`*^9, 3.602218034154315*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.6255944790191717`*^9}],

Cell[BoxData["\<\"K. Hartling\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.6255944790215187`*^9}],

Cell[BoxData["\<\"K. Kumar\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479024186*^9}],

Cell[BoxData["\<\"H. Logan\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479027289*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.2\"\>"}],
  SequenceForm["Model Version: ", "1.2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.62559447902983*^9}],

Cell[BoxData["\<\"https://feynrules.irmp.ucl.ac.be/wiki/GeorgiMachacekModel\"\
\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479032361*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479034721*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479037059*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479039308*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479229609*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479286481*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"GM\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "GM", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.624373237075913*^9, 3.6243740122304277`*^9, 
  3.6243741014765987`*^9, 3.6252277461689997`*^9, 3.625336949842184*^9, 
  3.625594479350362*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The GM model lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.624204667100444*^9, 3.624204695421753*^9}}],

Cell[CellGroupData[{

Cell["Unitary Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}}],

Cell["\<\
By default the GM model is loaded in Unitary Gauge (i.e. FeynmanGauge=False). \
The full lagrangian in unitary gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.624204804162891*^9, 3.624204822647955*^9}, {
  3.624204884766046*^9, 3.624204893151622*^9}}],

Cell[BoxData["LGM"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.624204704243165*^9, 3.624204705304317*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the extended scalar sector can be \
accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}, {3.624204925193535*^9, 3.6242049264936132`*^9}, {
  3.624204997297559*^9, 3.624204998743548*^9}, {3.6242152061584387`*^9, 
  3.624215212738056*^9}}],

Cell[BoxData["LScalar"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}, {3.624204929727079*^9, 
  3.624204932127887*^9}, {3.6242147622068777`*^9, 3.624214764019405*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}, {
  3.411910431304595*^9, 3.41191043361451*^9}}],

Cell["\<\
By default, SM lagrangian is loaded in unitary gauge. However, Feynman gauge \
can be obtained by putting\
\>", "Text",
 CellChangeTimes->{{3.411910440565042*^9, 3.411910480762147*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910487433539*^9, 3.4119104927114267`*^9}}],

Cell["\<\
The full lagrangian in Feynman gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.411910436148773*^9, 3.411910437013105*^9}}],

Cell[BoxData["LGM"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.624205023442636*^9, 3.62420502370514*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the extended scalar sector can be \
accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
   3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
   3.411910287709094*^9}, {3.624204925193535*^9, 3.6242049264936132`*^9}, {
   3.624204997297559*^9, 3.624204998743548*^9}, {3.624214795223812*^9, 
   3.6242147986997538`*^9}, 3.624215223374722*^9}],

Cell[BoxData["LScalar"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}, {3.624204929727079*^9, 
  3.624204932127887*^9}, {3.624214802246067*^9, 3.6242148039579973`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.4119106057673063`*^9, 
  3.411910606397141*^9}}],

Cell["\<\
The part of the lagrangian representing the ghost sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.4119106110136833`*^9, 3.411910611661195*^9}}],

Cell[BoxData["LGhost"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.411910615100849*^9, 
  3.411910615781582*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the Lagrangian", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.4234159280429783`*^9, 3.423415934798614*^9}, {
  3.588417616520516*^9, 3.588417617062751*^9}}],

Cell[CellGroupData[{

Cell["Checking hermiticity", "Subsection",
 CellChangeTimes->{{3.4234156831783743`*^9, 3.423415689540821*^9}}],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellChangeTimes->{{3.423415694323595*^9, 3.423415707867804*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LGM", "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
  3.5884182415538187`*^9, 3.5884182416874647`*^9}, {3.624205049979954*^9, 
  3.624205051112173*^9}}],

Cell["\<\
The same command can be applied to the flavor - expanded Lagrangian\
\>", "Text",
 CellChangeTimes->{{3.423415721582508*^9, 3.423415739787958*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LGM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763604111637*^9, 3.4147636044973803`*^9}, {
  3.6242050529673347`*^9, 3.624205054208926*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the mass spectrum", "Subsection",
 CellChangeTimes->{{3.423415831209465*^9, 3.423415835278742*^9}}],

Cell["\<\
FeynRules can check whether all the values of the masses given in the model \
file ar ein agreement with the masses given in the Lagrangian:\
\>", "Text",
 CellChangeTimes->{{3.423415751305388*^9, 3.423415792594919*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LScalar", "]"}]], "Input",
 CellChangeTimes->{{3.414736325829801*^9, 3.414736326065997*^9}, 
   3.4147528281460342`*^9, {3.624205057320355*^9, 3.624205059216099*^9}, {
   3.624205291219987*^9, 3.624205292532325*^9}, 3.624214478256811*^9, {
   3.6242148252068653`*^9, 3.624214826925099*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594580768627*^9}],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{3.625594581493135*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{G0, G0}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{G0, G0}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594592790544*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{Gp, Gpbar}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{Gp, Gpbar}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594592794797*^9}],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{3.62559459284205*^9}],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{3.625594592847374*^9}]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"h", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "\[Alpha]", "2"], " ", "mu2sq"}], "2"], "+", 
        
        FractionBox[
         RowBox[{"mu3sq", " ", 
          SubsuperscriptBox["s", "\[Alpha]", "2"]}], "2"], "-", 
        RowBox[{
         FractionBox["3", "4"], " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["M", "1"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "-", 
        RowBox[{"6", " ", 
         SubscriptBox["M", "2"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "+", 
        RowBox[{"3", " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "-", 
        RowBox[{
         FractionBox["3", "2"], " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["\[Lambda]", "3"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"18", " ", 
         SubscriptBox["\[Lambda]", "4"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox["3"], " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["M", "1"], " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "-", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["v", "\[Chi]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["v", "\[Chi]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "+", 
        RowBox[{"6", " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "1"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}]}]]}], "125.00000000000003`", 
     "125.`"},
    {"H", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "\[Alpha]", "2"], " ", "mu3sq"}], "2"], "+", 
        
        FractionBox[
         RowBox[{"mu2sq", " ", 
          SubsuperscriptBox["s", "\[Alpha]", "2"]}], "2"], "-", 
        RowBox[{"6", " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["M", "2"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "-", 
        RowBox[{
         FractionBox["3", "4"], " ", 
         SubscriptBox["M", "1"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "+", 
        RowBox[{"6", " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "3"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"18", " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "4"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"3", " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "-", 
        RowBox[{
         FractionBox["3", "2"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox["3"], " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["M", "1"], " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["v", "\[Chi]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SubscriptBox["c", "\[Alpha]"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubscriptBox["s", "\[Alpha]"], " ", 
         SubscriptBox["v", "\[Chi]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "+", 
        RowBox[{
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SubsuperscriptBox["c", "\[Alpha]", "2"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["\[Lambda]", "1"], " ", 
         SubsuperscriptBox["s", "\[Alpha]", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}]}]]}], "413.559218937433`", 
     "413.55921893743295`"},
    {"H3p", 
     SqrtBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["c", "H", "2"], " ", "mu3sq"}], "+", 
       RowBox[{"mu2sq", " ", 
        SubsuperscriptBox["s", "H", "2"]}], "-", 
       RowBox[{"6", " ", 
        SubsuperscriptBox["c", "H", "2"], " ", 
        SubscriptBox["M", "2"], " ", 
        SubscriptBox["v", "\[Chi]"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SubscriptBox["M", "1"], " ", 
        SubsuperscriptBox["s", "H", "2"], " ", 
        SubscriptBox["v", "\[Chi]"]}], "+", 
       RowBox[{"4", " ", 
        SubsuperscriptBox["c", "H", "2"], " ", 
        SubscriptBox["\[Lambda]", "3"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{"12", " ", 
        SubsuperscriptBox["c", "H", "2"], " ", 
        SubscriptBox["\[Lambda]", "4"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{"6", " ", 
        SubscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["s", "H", "2"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["\[Lambda]", "5"], " ", 
        SubsuperscriptBox["s", "H", "2"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{
        SqrtBox["2"], " ", 
        SubscriptBox["c", "H"], " ", 
        SubscriptBox["M", "1"], " ", 
        SubscriptBox["s", "H"], " ", 
        SubscriptBox["v", "\[Phi]"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", 
        SubscriptBox["c", "H"], " ", 
        SubscriptBox["\[Lambda]", "5"], " ", 
        SubscriptBox["s", "H"], " ", 
        SubscriptBox["v", "\[Chi]"], " ", 
        SubscriptBox["v", "\[Phi]"]}], "+", 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "H", "2"], " ", 
        SubscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SubsuperscriptBox["c", "H", "2"], " ", 
        SubscriptBox["\[Lambda]", "5"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["\[Lambda]", "1"], " ", 
        SubsuperscriptBox["s", "H", "2"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}]}]], "421.9049871387697`", 
     "421.9049871387698`"},
    {"H3z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "H", "2"], " ", "mu3sq"}], "2"], "+", 
        FractionBox[
         RowBox[{"mu2sq", " ", 
          SubsuperscriptBox["s", "H", "2"]}], "2"], "-", 
        RowBox[{"3", " ", 
         SubsuperscriptBox["c", "H", "2"], " ", 
         SubscriptBox["M", "2"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SubscriptBox["M", "1"], " ", 
         SubsuperscriptBox["s", "H", "2"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "+", 
        RowBox[{"2", " ", 
         SubsuperscriptBox["c", "H", "2"], " ", 
         SubscriptBox["\[Lambda]", "3"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"6", " ", 
         SubsuperscriptBox["c", "H", "2"], " ", 
         SubscriptBox["\[Lambda]", "4"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"3", " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["s", "H", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["s", "H", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        FractionBox[
         RowBox[{
          SubscriptBox["c", "H"], " ", 
          SubscriptBox["M", "1"], " ", 
          SubscriptBox["s", "H"], " ", 
          SubscriptBox["v", "\[Phi]"]}], 
         SqrtBox["2"]], "+", 
        RowBox[{
         SqrtBox["2"], " ", 
         SubscriptBox["c", "H"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubscriptBox["s", "H"], " ", 
         SubscriptBox["v", "\[Chi]"], " ", 
         SubscriptBox["v", "\[Phi]"]}], "+", 
        RowBox[{
         SubsuperscriptBox["c", "H", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "-", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SubsuperscriptBox["c", "H", "2"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Lambda]", "1"], " ", 
         SubsuperscriptBox["s", "H", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}]}]]}], "421.9049871387698`", 
     "421.9049871387698`"},
    {"H5p", 
     SqrtBox[
      RowBox[{"mu3sq", "+", 
       RowBox[{"6", " ", 
        SubscriptBox["M", "2"], " ", 
        SubscriptBox["v", "\[Chi]"]}], "+", 
       RowBox[{"12", " ", 
        SubscriptBox["\[Lambda]", "3"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{"12", " ", 
        SubscriptBox["\[Lambda]", "4"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SubscriptBox["\[Lambda]", "5"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}]}]], "438.9741134354872`", 
     "438.9741134354872`"},
    {"H5pp", 
     SqrtBox[
      RowBox[{"mu3sq", "+", 
       RowBox[{"6", " ", 
        SubscriptBox["M", "2"], " ", 
        SubscriptBox["v", "\[Chi]"]}], "+", 
       RowBox[{"12", " ", 
        SubscriptBox["\[Lambda]", "3"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{"12", " ", 
        SubscriptBox["\[Lambda]", "4"], " ", 
        SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SubscriptBox["\[Lambda]", "5"], " ", 
        SubsuperscriptBox["v", "\[Phi]", "2"]}]}]], "438.9741134354872`", 
     "438.9741134354872`"},
    {"H5z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["mu3sq", "2"], "+", 
        RowBox[{"3", " ", 
         SubscriptBox["M", "2"], " ", 
         SubscriptBox["v", "\[Chi]"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["\[Lambda]", "3"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{"6", " ", 
         SubscriptBox["\[Lambda]", "4"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Lambda]", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SubscriptBox["\[Lambda]", "5"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}]}]]}], "438.9741134354872`", 
     "438.9741134354872`"},
    {"W", 
     SqrtBox[
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["e", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], 
        RowBox[{"4", " ", 
         SubsuperscriptBox["s", "w", "2"]}]]}]], "79.82435974619779`", 
     "79.82435974619784`"},
    {"Z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["e", "2"], " ", 
         SubsuperscriptBox["v", "\[Chi]", "2"]}], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["v", "\[Chi]", "2"]}], 
         SubsuperscriptBox["s", "w", "2"]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SubsuperscriptBox["v", "\[Chi]", "2"]}], 
         SubsuperscriptBox["c", "w", "2"]], "+", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SuperscriptBox["e", "2"], " ", 
         SubsuperscriptBox["v", "\[Phi]", "2"]}], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["v", "\[Phi]", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SubsuperscriptBox["v", "\[Phi]", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.18759999999995`", 
     "91.1876`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.6255945928564577`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the kinetic terms", "Subsection",
 CellChangeTimes->{{3.423415843532096*^9, 3.42341584850035*^9}}],

Cell["\<\
In the same way, FeynRules can check whether all kinetic terms are correctly \
normalized :\
\>", "Text",
 CellChangeTimes->{{3.423415798800013*^9, 3.423415817964087*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LGM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4147636651636972`*^9, 3.414763667250185*^9}, {
  3.6242050630083847`*^9, 3.624205064088174*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594503542074*^9}],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{3.625594504269515*^9}],

Cell[BoxData["\<\"All kinetic terms are correctly normalized.\"\>"], "Print",
 CellChangeTimes->{3.625594521037692*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.6255945210405893`*^9}]
}, Open  ]],

Cell["\<\
The same command cen be used at the level of the flavor - expanded Lagrangian \
:\
\>", "Text",
 CellChangeTimes->{{3.423415868906054*^9, 3.4234158864202538`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LGM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.62420506609689*^9, 3.624205067128241*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594547384931*^9}],

Cell[BoxData["\<\"All kinetic terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{3.6255945485120697`*^9}],

Cell[BoxData["\<\"All kinetic terms are correctly normalized.\"\>"], "Print",
 CellChangeTimes->{3.62559456862864*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.625594568632038*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}}],

Cell["\<\
We will calculate now explicitly the Feynman rules for the SM in Feynman \
gauge.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 3.411910672936666*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsection",
 CellChangeTimes->{{3.411910690443768*^9, 3.411910692233274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGauge", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGauge", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.40274690437012*^9, {3.402746954727231*^9, 3.4027469691642714`*^9}, {
   3.4032592998045692`*^9, 3.403259304564069*^9}, 3.403267976055098*^9, {
   3.411910705212987*^9, 3.411910705553741*^9}, {3.423415993272615*^9, 
   3.42341600147605*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar Sector", "Subsection",
 CellChangeTimes->{
  3.404470070069872*^9, {3.624214936064766*^9, 3.6242149372900763`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsHiggs", "=", 
   RowBox[{"FeynmanRules", "[", "LScalar", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 3.423416065626593*^9, {
   3.6242149402131166`*^9, 3.624214941868855*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.625594594669417*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.62559459467141*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594594674799*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.625594614113493*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "418", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{27., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "418", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  418, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 418, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6255946146645527`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"418", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[418, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.625594635923892*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteTeXOutput", "[", "vertsHiggs", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.625594637704794*^9, 3.625594649416555*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"TeX output written on \"\>", 
   "\[InvisibleSpace]", "\<\"GM.tex\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["TeX output written on ", "GM.tex", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.62559465169667*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matter sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsFermions", "=", 
   RowBox[{"FeynmanRules", "[", "LFermions", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.402205118991502*^9, 3.4022051228508387`*^9}, 
   3.402747846432675*^9, {3.4032613449872217`*^9, 3.403261349245253*^9}, {
   3.403266977133403*^9, 3.4032669793125563`*^9}, {3.411910788644576*^9, 
   3.411910789233307*^9}, {3.423416034294303*^9, 3.423416042739814*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsYukawa", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LYukawa", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
  3.411910826105542*^9, 3.411910826777452*^9}, {3.423416089772278*^9, 
  3.423416095643961*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LGhost sector", "Subsection",
 CellChangeTimes->{{3.411910849714159*^9, 3.411910851088325*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGhosts", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGhost", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
   3.411910826105542*^9, 3.411910826777452*^9}, {3.411910857580064*^9, 
   3.411910870001601*^9}, 3.415256462464088*^9, {3.423416107236608*^9, 
   3.423416112835993*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}}],

Cell[CellGroupData[{

Cell["FeynArts output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}}],

Cell["The FeynArts output for the SM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911062212926*^9, 3.4119110634765463`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"LGauge", ",", "LScalar", ",", "LFermions", ",", "LYukawa", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185480912915*^9}, {3.41245048911446*^9, 
   3.4124504892674522`*^9}, 3.414315634453483*^9, {3.423416180751266*^9, 
   3.423416182892613*^9}, {3.624215005341929*^9, 3.624215007218308*^9}}],

Cell["FeynArts also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121854851672792`*^9, 3.412185494183435*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{
  "LGauge", ",", "LScalar", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
   ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<GM.mod\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
  3.412185470680571*^9, 3.412185506240796*^9}, {3.4234161971513453`*^9, 
  3.423416209716672*^9}, {3.624215021244478*^9, 3.624215029833962*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sherpa output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}}],

Cell["The Sherpa output for the SM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteSHOutput", "[", 
  RowBox[{"LGauge", ",", "LScalar", ",", "LFermions", ",", "LYukawa"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185455856553*^9, 3.412185456628922*^9}, {3.4143156544792233`*^9, 
  3.414315668290971*^9}, {3.423416222700699*^9, 3.423416235756197*^9}, {
  3.624215040761606*^9, 3.624215042457138*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}}],

Cell["CalcHep also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", "LGM", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
  3.4124504817138367`*^9}, {3.624215059864361*^9, 3.6242150606286287`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.412185367693318*^9, 3.412185407947097*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Whizard output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}, {3.5074389822322817`*^9, 
  3.507438983565652*^9}}],

Cell["Whizard also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}, {
  3.507438990997637*^9, 3.507438992828805*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteWOOutput", "[", 
   RowBox[{
   "LGauge", ",", "LScalar", ",", "LFermions", ",", "LYukawa", ",", 
    "LGhost"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
  3.4124504817138367`*^9}, {3.507438986168689*^9, 3.507438987383316*^9}, {
  3.624215064431674*^9, 3.624215066222713*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.412185367693318*^9, 3.412185407947097*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}, {3.5074389822322817`*^9, 
  3.507438983565652*^9}, {3.507439158477231*^9, 3.507439159035309*^9}}],

Cell["\<\
MG5 also supports the Feynman gauge\
\>", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}, {
  3.507438990997637*^9, 3.507438992828805*^9}, {3.625337165353299*^9, 
  3.625337166451006*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteUFO", "[", "LGM", "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.412185367693318*^9, 3.412185407947097*^9, {3.5074391727475023`*^9, 
   3.5074391804929533`*^9}, {3.624215074750321*^9, 3.624215083364794*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1152, 679},
WindowMargins->{{Automatic, 48}, {28, Automatic}},
ShowSelection->True,
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 6, \
2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 69, 1, 33, "Input"],
Cell[617, 23, 120, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[762, 29, 401, 7, 33, "Input"],
Cell[1166, 38, 1284, 18, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2487, 61, 120, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[2632, 67, 427, 6, 25, "Print"],
Cell[3062, 75, 710, 13, 25, "Print"],
Cell[3775, 90, 479, 7, 25, "Print"],
Cell[4257, 99, 413, 6, 25, "Print"],
Cell[4673, 107, 426, 6, 25, "Print"],
Cell[5102, 115, 436, 6, 25, "Print"],
Cell[5541, 123, 476, 7, 25, "Print"],
Cell[6020, 132, 415, 6, 25, "Print"],
Cell[6438, 140, 443, 6, 25, "Print"],
Cell[6884, 148, 412, 6, 25, "Print"],
Cell[7299, 156, 480, 7, 25, "Print"]
}, Open  ]]
}, Open  ]],
Cell[7806, 167, 414, 8, 33, "Input"],
Cell[CellGroupData[{
Cell[8245, 179, 117, 1, 95, "Title"],
Cell[8365, 182, 62, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[8452, 186, 1078, 15, 33, "Input"],
Cell[CellGroupData[{
Cell[9555, 205, 240, 3, 25, "Print"],
Cell[9798, 210, 211, 3, 25, "Print"],
Cell[10012, 215, 206, 3, 25, "Print"],
Cell[10221, 220, 206, 3, 25, "Print"],
Cell[10430, 225, 343, 7, 25, "Print"],
Cell[10776, 234, 257, 4, 25, "Print"],
Cell[11036, 240, 246, 4, 25, "Print"],
Cell[11285, 246, 198, 3, 25, "Print"],
Cell[11486, 251, 228, 3, 25, "Print"],
Cell[11717, 256, 231, 3, 25, "Print"],
Cell[11951, 261, 229, 3, 25, "Print"],
Cell[12183, 266, 386, 8, 45, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12618, 280, 157, 2, 83, "Section"],
Cell[CellGroupData[{
Cell[12800, 286, 100, 1, 42, "Subsection"],
Cell[12903, 289, 432, 7, 32, "Text"],
Cell[13338, 298, 144, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[13507, 304, 105, 1, 30, "Subsubsection"],
Cell[13615, 307, 219, 4, 32, "Text"],
Cell[13837, 313, 98, 1, 33, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13972, 319, 154, 2, 30, "Subsubsection"],
Cell[14129, 323, 427, 8, 32, "Text"],
Cell[14559, 333, 245, 3, 33, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14841, 341, 158, 2, 30, "Subsubsection"],
Cell[15002, 345, 272, 5, 32, "Text"],
Cell[15277, 352, 148, 2, 33, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15462, 359, 155, 2, 30, "Subsubsection"],
Cell[15620, 363, 271, 6, 32, "Text"],
Cell[15894, 371, 150, 2, 33, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16093, 379, 148, 2, 42, "Subsection"],
Cell[16244, 383, 195, 4, 32, "Text"],
Cell[16442, 389, 149, 3, 33, "Input"],
Cell[16594, 394, 303, 5, 32, "Text"],
Cell[16900, 401, 143, 2, 33, "Input"],
Cell[CellGroupData[{
Cell[17068, 407, 105, 1, 30, "Subsubsection"],
Cell[17176, 410, 219, 4, 32, "Text"],
Cell[17398, 416, 98, 1, 33, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17533, 422, 154, 2, 30, "Subsubsection"],
Cell[17690, 426, 453, 8, 32, "Text"],
Cell[18146, 436, 245, 3, 33, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18428, 444, 158, 2, 37, "Subsubsection"],
Cell[18589, 448, 272, 5, 40, "Text"],
Cell[18864, 455, 148, 2, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19049, 462, 155, 2, 37, "Subsubsection"],
Cell[19207, 466, 271, 6, 40, "Text"],
Cell[19481, 474, 150, 2, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19668, 481, 205, 3, 37, "Subsubsection"],
Cell[19876, 486, 316, 5, 40, "Text"],
Cell[20195, 493, 198, 3, 41, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20454, 503, 110, 1, 103, "Section"],
Cell[20567, 506, 199, 4, 41, "Input"],
Cell[CellGroupData[{
Cell[20791, 514, 110, 1, 52, "Subsection"],
Cell[20904, 517, 134, 1, 40, "Text"],
Cell[21041, 520, 241, 4, 41, "Input"],
Cell[21285, 526, 157, 3, 40, "Text"],
Cell[21445, 531, 257, 5, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21739, 541, 114, 1, 52, "Subsection"],
Cell[21856, 544, 230, 4, 40, "Text"],
Cell[CellGroupData[{
Cell[22111, 552, 340, 5, 41, "Input"],
Cell[CellGroupData[{
Cell[22476, 561, 327, 7, 31, "Print"],
Cell[22806, 570, 104, 1, 31, "Print"],
Cell[22913, 573, 370, 9, 31, "Print"],
Cell[23286, 584, 376, 9, 31, "Print"],
Cell[23665, 595, 97, 1, 31, "Print"],
Cell[23765, 598, 139, 2, 31, "Print"]
}, Open  ]],
Cell[23919, 603, 15485, 404, 673, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39453, 1013, 113, 1, 52, "Subsection"],
Cell[39569, 1016, 181, 4, 40, "Text"],
Cell[CellGroupData[{
Cell[39775, 1024, 270, 5, 41, "Input"],
Cell[CellGroupData[{
Cell[40070, 1033, 327, 7, 31, "Print"],
Cell[40400, 1042, 107, 1, 31, "Print"],
Cell[40510, 1045, 119, 1, 31, "Print"]
}, Open  ]],
Cell[40644, 1049, 75, 1, 41, "Output"]
}, Open  ]],
Cell[40734, 1053, 173, 4, 40, "Text"],
Cell[CellGroupData[{
Cell[40932, 1061, 216, 4, 41, "Input"],
Cell[CellGroupData[{
Cell[41173, 1069, 327, 7, 31, "Print"],
Cell[41503, 1078, 109, 1, 31, "Print"],
Cell[41615, 1081, 118, 1, 31, "Print"]
}, Open  ]],
Cell[41748, 1085, 73, 1, 41, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41882, 1093, 116, 1, 103, "Section"],
Cell[42001, 1096, 170, 4, 40, "Text"],
Cell[42174, 1102, 149, 3, 41, "Input"],
Cell[CellGroupData[{
Cell[42348, 1109, 100, 1, 52, "Subsection"],
Cell[42451, 1112, 457, 10, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42945, 1127, 128, 2, 52, "Subsection"],
Cell[CellGroupData[{
Cell[43098, 1133, 311, 6, 41, "Input"],
Cell[CellGroupData[{
Cell[43434, 1143, 348, 9, 31, "Print"],
Cell[43785, 1154, 102, 1, 31, "Print"],
Cell[43890, 1157, 277, 6, 31, "Print"],
Cell[44170, 1165, 136, 2, 31, "Print"],
Cell[44309, 1169, 624, 13, 31, "Print"],
Cell[44936, 1184, 220, 5, 31, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45205, 1195, 160, 3, 41, "Input"],
Cell[45368, 1200, 284, 6, 31, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45701, 1212, 35, 0, 52, "Subsection"],
Cell[45739, 1214, 417, 7, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46193, 1226, 35, 0, 52, "Subsection"],
Cell[46231, 1228, 360, 8, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46628, 1241, 101, 1, 52, "Subsection"],
Cell[46732, 1244, 433, 9, 41, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47214, 1259, 132, 2, 103, "Section"],
Cell[CellGroupData[{
Cell[47371, 1265, 103, 1, 52, "Subsection"],
Cell[47477, 1268, 185, 2, 40, "Text"],
Cell[47665, 1272, 616, 11, 90, "Input"],
Cell[48284, 1285, 124, 1, 40, "Text"],
Cell[48411, 1288, 622, 13, 90, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49070, 1306, 103, 1, 52, "Subsection"],
Cell[49176, 1309, 183, 2, 40, "Text"],
Cell[49362, 1313, 524, 11, 90, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49923, 1329, 155, 2, 52, "Subsection"],
Cell[50081, 1333, 123, 1, 40, "Text"],
Cell[50207, 1336, 427, 9, 90, "Input"],
Cell[50637, 1347, 90, 1, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50764, 1353, 206, 3, 52, "Subsection"],
Cell[50973, 1358, 172, 2, 40, "Text"],
Cell[51148, 1362, 565, 13, 90, "Input"],
Cell[51716, 1377, 90, 1, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51843, 1383, 248, 3, 52, "Subsection"],
Cell[52094, 1388, 225, 5, 40, "Text"],
Cell[52322, 1395, 81, 2, 41, "Input"],
Cell[52406, 1399, 248, 5, 41, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
