(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    614964,      16312]
NotebookOptionsPosition[    603865,      16013]
NotebookOutlinePosition[    604530,      16035]
CellTagsIndexPosition[    604487,      16032]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.746080524555826*^9, 3.746080527205069*^9}, {
   3.747028024755624*^9, 3.747028035459062*^9}, 3.7470280793372707`*^9},
 ExpressionUUID -> "ea204303-3637-4112-800d-a24341a823e0"],

Cell["", "PageBreak",
 PageBreakBelow->True,ExpressionUUID->"5fc5f4b1-fbe3-4315-9787-e2261e266682"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", "\"\</Users/sanjoymandal/Softwares/FeynRules\>\"", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}]}], "Input",
 CellChangeTimes->{{3.746080524555826*^9, 3.746080527205069*^9}, {
   3.747028024755624*^9, 3.747028035459062*^9}, 3.7470280793372707`*^9, {
   3.7760902881628036`*^9, 3.7760903052666273`*^9}, {3.847017736298255*^9, 
   3.8470177704584417`*^9}, {3.8510723212336206`*^9, 3.8510723262005873`*^9}},
 
 ExpressionUUID -> "e41cab99-0426-4847-9917-d2ece01c58ad"],

Cell[BoxData["\<\"/Users/sanjoymandal/Softwares/FeynRules\"\>"], "Output",
 CellChangeTimes->{
  3.746080540907291*^9, 3.7469793411651697`*^9, 3.746979418542094*^9, 
   3.746979949886504*^9, 3.746980043805517*^9, 3.7469809907210627`*^9, 
   3.746981255769177*^9, 3.746981378676499*^9, 3.746981451503866*^9, 
   3.746981992134856*^9, 3.746982344269367*^9, 3.746983249964353*^9, 
   3.7469833488771257`*^9, 3.746983520673109*^9, 3.747012863502186*^9, 
   3.747013051318262*^9, 3.747014374914872*^9, 3.747015134748982*^9, 
   3.747017050645417*^9, 3.747018435213273*^9, 3.747026109944803*^9, 
   3.7470263370860643`*^9, 3.747026493633946*^9, 3.7470276905350447`*^9, 
   3.747027771879772*^9, 3.74702808576259*^9, 3.747029941431243*^9, 
   3.747030131013197*^9, 3.7470302073956957`*^9, 3.747030350243202*^9, 
   3.7470304938491373`*^9, 3.7470306037066307`*^9, 3.7470315224847307`*^9, 
   3.747031774866808*^9, 3.747031870745593*^9, 3.747032246020562*^9, 
   3.747032507810568*^9, 3.747033204377378*^9, 3.747033539328999*^9, 
   3.747037593489361*^9, 3.7470428693678703`*^9, 3.747043680151544*^9, 
   3.747046348218955*^9, 3.7470467312114573`*^9, 3.747047425388052*^9, 
   3.747055920296722*^9, 3.7471053350837107`*^9, 3.7471054690270653`*^9, 
   3.7471245505283337`*^9, 3.747127446455117*^9, 3.747149668497756*^9, 
   3.747186418614575*^9, 3.747314101404661*^9, 3.7473142275432158`*^9, 
   3.747317045833618*^9, 3.747396438426654*^9, 3.7474000045042753`*^9, 
   3.7474001598345346`*^9, 3.74740363927794*^9, 3.747407806119212*^9, 
   3.7474105608137836`*^9, 3.747413083479844*^9, 3.747481478738566*^9, 
   3.747483733348042*^9, 3.747484949234207*^9, 3.747639742023815*^9, 
   3.747753470843522*^9, 3.747754134704976*^9, 3.750134903590371*^9, 
   3.750137012999329*^9, 3.750138394825027*^9, 3.750139609049124*^9, 
   3.750142074163608*^9, 3.754894268400738*^9, 3.755346094636882*^9, 
   3.755346326754897*^9, 3.755346361126395*^9, {3.7760903000075912`*^9, 
   3.77609031176805*^9}, 3.789640541374358*^9, 3.806697584281945*^9, 
   3.821889132823311*^9, 3.83251241702673*^9, 3.83251339415779*^9, 
   3.847017776777137*^9, 3.850865756146624*^9, 3.8508807644477177`*^9, 
   3.850881770419067*^9, 3.8508870641412563`*^9, 3.850904430156708*^9, 
   3.850906189461205*^9, 3.850948618575077*^9, 3.8509825045263767`*^9, 
   3.850993236328765*^9, 3.851045891012762*^9, 3.851055411725787*^9, 
   3.851055518354093*^9, 3.851072331000134*^9},
 ExpressionUUID -> "e34f86db-8550-4514-8b9c-b3e1e84657eb"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.8510723310029182`*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.49\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"29 September 2021\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.49", " (" "29 September 2021", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.851072331004697*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.8510723310078983`*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.851072331010159*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.851072331012484*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.851072331016626*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.85107233101935*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.8510723310218678`*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.851072331024309*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.851072331026635*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.77609031177147*^9, 3.7896405414789257`*^9, 
  3.806697584289908*^9, 3.821889132836812*^9, 3.832512417038105*^9, 
  3.83251339418088*^9, 3.8470177768148403`*^9, 3.8508657562078323`*^9, 
  3.8508807645028687`*^9, 3.850881770511332*^9, 3.850887064197658*^9, 
  3.8509044301775837`*^9, 3.850906189519374*^9, 3.850948618626553*^9, 
  3.850982504595437*^9, 3.850993236377143*^9, 3.851045891031129*^9, 
  3.851055411962782*^9, 3.851055518359261*^9, 3.8510723310292397`*^9},
 ExpressionUUID -> "8e618d23-c005-44f8-a739-71a4f9bb2b2b"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/U1XGeneric\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.424068987980844*^9, 3.4240689893965273`*^9}, {3.7469793552640247`*^9, 
  3.746979357013974*^9}, {3.7469800240464478`*^9, 3.746980024955142*^9}, {
  3.746980998299732*^9, 3.746980999763442*^9}, {3.851047685087286*^9, 
  3.851047692179797*^9}},
 ExpressionUUID -> "c2728d7c-990b-487c-9c87-243bd77bfe2c"],

Cell[CellGroupData[{

Cell["The generic U(1)X extension of the Standard Model", "Title",
 CellChangeTimes->{{3.424069004105296*^9, 3.424069007850328*^9}, {
  3.851047618832896*^9, 
  3.851047630333591*^9}},ExpressionUUID->"d1bf0893-cf2c-4d49-a437-\
0cedda0e6bde"],

Cell["We first load in the B-L Model model-file", "Text",
 CellChangeTimes->{{3.424069016807353*^9, 
  3.4240690172628117`*^9}},ExpressionUUID->"61db4aef-65fb-456c-a31a-\
20de276c2500"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<U1XGeneric.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, {3.4240690195427647`*^9, 3.424069028019803*^9}, {
   3.746979372517106*^9, 3.746979373941243*^9}, {3.746980028187269*^9, 
   3.746980029044972*^9}, {3.746981006227182*^9, 3.746981007603279*^9}, {
   3.7471864272216177`*^9, 3.7471864310375557`*^9}, {3.7473142363835297`*^9, 
   3.747314241447364*^9}, {3.747403647911851*^9, 3.747403657606475*^9}, {
   3.74740781305091*^9, 3.747407819442765*^9}, {3.747410568581757*^9, 
   3.74741057214149*^9}, {3.747413091268428*^9, 3.747413095861931*^9}, {
   3.747484960087738*^9, 3.747484964199719*^9}, {3.7476397731280727`*^9, 
   3.747639776087564*^9}, {3.747754144030325*^9, 3.747754147541741*^9}, {
   3.750134912646644*^9, 3.750134918534808*^9}, {3.7548942881093063`*^9, 
   3.7548942913651752`*^9}, {3.75534611137821*^9, 3.755346114367014*^9}, {
   3.7553463338837957`*^9, 3.755346337314412*^9}, {3.7760903215466022`*^9, 
   3.776090325458721*^9}, {3.789640555983595*^9, 3.7896405626109247`*^9}, {
   3.832512434033279*^9, 3.832512439376174*^9}, {3.850865774719036*^9, 
   3.850865783598137*^9}},
 ExpressionUUID -> "7f889700-cd70-462f-861f-f71da20efa4d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342155525*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"Sanjoy Mandal\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342157658*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"Arindam Das\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342160269*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.1.0\"\>"}],
  SequenceForm["Model Version: ", "1.1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342162689*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342165091*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342167862*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.851072342170248*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.8510723421729593`*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.8510723425161257`*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.85107234256604*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"U1XGeneric\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "U1XGeneric", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.755346369714416*^9, 3.776090328724597*^9, 
  3.7896405755040083`*^9, 3.8066976009907093`*^9, 3.821889143221088*^9, 
  3.8325124421191473`*^9, 3.832513401278173*^9, 3.8470178135528097`*^9, 
  3.850865786443536*^9, 3.850880793814986*^9, 3.850881780731019*^9, 
  3.850887084646796*^9, 3.850904443978429*^9, 3.8509061998472023`*^9, 
  3.850948633393744*^9, 3.850982521751495*^9, 3.850993259942494*^9, 
  3.851045903190041*^9, 3.851055548739985*^9, 3.85107234276466*^9},
 ExpressionUUID -> "ba0a021f-9aaf-4b0e-8718-cdaddf598337"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 
  3.41191064360071*^9}},ExpressionUUID->"8f13d435-d304-4b9d-acbb-\
69e80ea817cb"],

Cell["\<\
We will calculate now explicitly the Feynman rules for the SM in Feynman \
gauge.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 
  3.411910672936666*^9}},ExpressionUUID->"9dc8d904-b785-45ac-a324-\
9f55d43d1c07"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}},
 ExpressionUUID -> "92fc7fe0-342a-4e23-8262-09c1664c339b"],

Cell[CellGroupData[{

Cell["Higgs Sector", "Subsection",
 CellChangeTimes->{
  3.404470070069872*^9},ExpressionUUID->"ed9b35d2-9b95-4ad7-ba55-\
b811909eb7ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vertsHiggs", "=", 
  RowBox[{"FeynmanRules", "[", "LHiggs", "]"}]}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 3.423416065626593*^9, 
   3.850993306745035*^9},
 ExpressionUUID -> "2a6a91f3-d4e5-4129-9b08-fe83c2e590c0"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.850993310250286*^9},
 ExpressionUUID -> "fb9260ab-8f65-42d6-807d-2e4f846e74ab"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.8509933102527742`*^9},
 ExpressionUUID -> "758d1c5a-dd3f-4fbe-a142-2741ae5f64ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8509933102567453`*^9},
 ExpressionUUID -> "53334d5d-f623-4546-ba1a-1426a0be19bc"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.8509933253487883`*^9},
 ExpressionUUID -> "f992b80d-c5fd-44e3-a356-cc2565cc34d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "126", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{135., {3., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "126", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  126, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 126, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850993325480665*^9},
 ExpressionUUID -> "1ee6ca57-9c83-4675-82c8-e7a6e6ab30f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"126", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[126, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8509933341337*^9},
 ExpressionUUID -> "48257837-8c5a-4046-bce9-070194640eb1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "4"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["sg", "4"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Lambda]1"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "4"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "4"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "\[Lambda]1"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Ca", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]2"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Ca", " ", "Sa", " ", 
       "\[Lambda]1"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Sa", " ", "\[Lambda]3"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "Sa", " ", "\[Lambda]1"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "3"], " ", "\[Lambda]2"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "Sa", " ", "\[Lambda]3"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "3"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "4"], " ", "\[Lambda]3"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "4"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "3"], " ", "\[Lambda]1"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "Sa", " ", "\[Lambda]2"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "Sa", " ", "\[Lambda]3"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "3"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "4"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "4"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "3"], " ", "sg", " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["sg", "3"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "3"], " ", "sg", " ", "\[Lambda]3"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["sg", "3"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "cg", " ", "sg", " ", "\[Lambda]1"}], 
      "-", 
      RowBox[{"\[ImaginaryI]", " ", "cg", " ", "sg", " ", "\[Lambda]3"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "cg", " ", "sg", " ", "\[Lambda]1"}], 
      "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["Sa", "2"], " ", "sg", " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "cg", " ", "sg", " ", "\[Lambda]3"}], 
      "+", 
      RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["Sa", "2"], " ", "sg", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "Sa", " ", "sg", 
       " ", "\[Lambda]1"}], "+", 
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "Sa", " ", "sg", 
       " ", "\[Lambda]2"}], "-", 
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "Sa", " ", "sg", 
       " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["Sa", "2"], " ", "sg", " ", "\[Lambda]1"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "cg", " ", "sg", " ", "\[Lambda]2"}], 
      "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "cg", " ", "sg", " ", "\[Lambda]3"}], 
      "-", 
      RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["Sa", "2"], " ", "sg", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "4"], " ", "\[Lambda]3"}], "+", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["sg", "4"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Ca", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]1"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "\[Lambda]3"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"6", " ", "\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["sg", "3"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "3"], " ", "sg", " ", "\[Lambda]2"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "3"], " ", "sg", " ", "\[Lambda]3"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["sg", "3"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["sg", "4"], " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "4"], " ", "\[Lambda]2"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "vev", " ", "\[Lambda]1"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "x", " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["sg", "2"], " ", "vev", " ", "\[Lambda]3"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "x", " ", 
       "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Ca", " ", "vev", " ", 
       "\[Lambda]1"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Sa", " ", "x", " ", "\[Lambda]3"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "vev", " ", "\[Lambda]1"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "3"], " ", "x", " ", "\[Lambda]2"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "2"], " ", "vev", " ", "\[Lambda]3"}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "Sa", " ", "x", " ", 
       "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "vev", " ", "\[Lambda]1"}], 
      "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["sg", "2"], " ", "x", " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "vev", " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "x", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Sa", " ", "vev", " ", 
       "\[Lambda]1"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "x", " ", "\[Lambda]3"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "Sa", " ", "vev", " ", "\[Lambda]1"}], 
      "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "2"], " ", "x", " ", "\[Lambda]2"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "Sa", " ", "vev", " ", "\[Lambda]3"}], 
      "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "3"], " ", "vev", " ", "\[Lambda]3"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "x", " ", "\[Lambda]3"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "2"], " ", "x", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "2"], " ", "vev", " ", "\[Lambda]1"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "Sa", " ", "x", " ", "\[Lambda]2"}], 
      "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "vev", " ", "\[Lambda]3"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "2"], " ", "vev", " ", "\[Lambda]3"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "Sa", " ", "x", " ", "\[Lambda]3"}], 
      "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "3"], " ", "x", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Sa", "3"], " ", "vev", " ", "\[Lambda]1"}], "-", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "3"], " ", "x", " ", "\[Lambda]2"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", "Sa", " ", "vev", " ", "\[Lambda]3"}], 
      "-", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Sa", "2"], " ", "x", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "sg", " ", "vev", 
       " ", "\[Lambda]1"}], "+", 
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "cg", " ", "Sa", " ", "sg", " ", "x", 
       " ", "\[Lambda]2"}], "-", 
      RowBox[{
      "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "sg", " ", "vev", " ", 
       "\[Lambda]3"}], "-", 
      RowBox[{
      "\[ImaginaryI]", " ", "cg", " ", "Sa", " ", "sg", " ", "x", " ", 
       "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "cg", " ", "Sa", " ", "sg", " ", "vev", 
       " ", "\[Lambda]1"}], "-", 
      RowBox[{
      "2", " ", "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "sg", " ", "x", 
       " ", "\[Lambda]2"}], "-", 
      RowBox[{
      "\[ImaginaryI]", " ", "cg", " ", "Sa", " ", "sg", " ", "vev", " ", 
       "\[Lambda]3"}], "+", 
      RowBox[{
      "\[ImaginaryI]", " ", "Ca", " ", "cg", " ", "sg", " ", "x", " ", 
       "\[Lambda]3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["sg", "2"], " ", "vev", " ", "\[Lambda]1"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "x", " ", "\[Lambda]2"}], 
      "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "vev", " ", "\[Lambda]3"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "x", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "Sa", " ", 
       SuperscriptBox["sg", "2"], " ", "vev", " ", "\[Lambda]1"}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["cg", "2"], " ", "x", " ", "\[Lambda]2"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", "Sa", " ", "vev", " ", "\[Lambda]3"}], 
      "-", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["sg", "2"], " ", "x", " ", "\[Lambda]3"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["e", "2"], " ", 
      SubscriptBox["\[Eta]", 
       RowBox[{
        SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
        SubscriptBox["\<\"\[Mu]\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", 
        SubscriptBox["\<\"\[Mu]\"\>", "1"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Ca", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", "sg", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "cg", " ", "e", " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Ca", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"e", " ", "Sa", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"e", " ", "Sa", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "e", " ", "sg", " ", 
         SubsuperscriptBox["\<\"p\"\>", "1", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"Ca", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["e", "2"], " ", "Sa", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", "sg", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["e", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Ca", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"e", " ", "Sa", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"e", " ", "Sa", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "4"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["e", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubsuperscriptBox["s", "w", "2"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "a1", " ", "Ca", " ", "cg", " ", "g1p", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
      "2", " ", "b1", " ", "g1p", " ", "Sa", " ", "sg", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Ca", " ", "cg", " ", "g1p", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
      "2", " ", "b1", " ", "g1p", " ", "Sa", " ", "sg", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "a1", " ", "cg", " ", "g1p", " ", "Sa", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "g1p", " ", "sg", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"cg", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"cg", " ", "Cp", " ", "e", " ", "Sa", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "cg", " ", "g1p", " ", "Sa", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "g1p", " ", "sg", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"cg", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", "Cp", " ", "e", " ", "Sa", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "a1", " ", "g1p", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "a1", " ", "g1p", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "b1", " ", "cg", " ", "g1p", " ", "Sa", " ", 
       "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Ca", " ", "g1p", " ", "sg", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "Cp", " ", "e", " ", "sg", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
      "2", " ", "b1", " ", "cg", " ", "g1p", " ", "Sa", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Ca", " ", "g1p", " ", "sg", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "Cp", " ", "e", " ", "sg", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "cg", " ", "g1p", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "g1p", " ", "Sa", " ", "sg", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"Cp", " ", "e", " ", "Sa", " ", "sg", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "cg", " ", "g1p", " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "g1p", " ", "Sa", " ", "sg", 
       " ", "Sp", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", "sg", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Cp", " ", "e", " ", "Sa", " ", "sg", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Ca", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"a1", " ", "Ca", " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"a1", " ", "e", " ", "g1p", " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
         SuperscriptBox["e", "2"], " ", "sg", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", "sg", " ", "Sp",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Cp", " ", 
        SuperscriptBox["e", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"a1", " ", "e", " ", "g1p", " ", "Sp", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Ca", " ", "Cp", " ", 
         SuperscriptBox["e", "2"], " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", "Ca", " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cp", " ", 
         SuperscriptBox["e", "2"], " ", "Sa", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", "e", " ", "g1p", " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
         SuperscriptBox["e", "2"], " ", "sg", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", "sg", " ", "Sp",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cp", " ", 
         SuperscriptBox["e", "2"], " ", "vev", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", "e", " ", "g1p", " ", "Sp", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", "Cp", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", "Cp", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Ca", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Ca", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", "Sp", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", "e", " ", "g1p",
         " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "cg", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", "sg", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "cg", " ", 
       SuperscriptBox["g1p", "2"], " ", "sg", " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "cg", " ", 
       SuperscriptBox["g1p", "2"], " ", "sg", " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "cg", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "sg", " ", "Sp", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "Cp", " ", "e", " ", "g1p",
         " ", "sg", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["sg", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["sg", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Ca", " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", "vev", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", "e", " ", "g1p",
         " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", 
       SuperscriptBox["Sp", "2"], " ", "x", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", 
       SuperscriptBox["Sp", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", "Sp", 
        " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", "Sa",
         " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Ca", " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", "x", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "a1", " ", "Ca", " ", "cg", " ", "Cp", 
       " ", "g1p", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
      "2", " ", "b1", " ", "Cp", " ", "g1p", " ", "Sa", " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Ca", " ", "cg", " ", "Cp", " ",
        "g1p", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
      "2", " ", "b1", " ", "Cp", " ", "g1p", " ", "Sa", " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "cg", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "a1", " ", "cg", " ", "Cp", " ", "g1p", 
       " ", "Sa", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "Cp", " ", "g1p", " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", "e", " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "cg", " ", "Cp", " ", "g1p", 
       " ", "Sa", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "Cp", " ", "g1p", " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"cg", " ", "e", " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "a1", " ", "Cp", " ",
        "g1p", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "a1", " ", "Cp", " ",
        "g1p", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "b1", " ", "cg", " ", "Cp", " ", "g1p", " ", 
       "Sa", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Ca", " ", "Cp", " ", "g1p", 
       " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{"Ca", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "sg", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"Ca", " ", "e", " ", "sg", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
      "2", " ", "b1", " ", "cg", " ", "Cp", " ", "g1p", " ", "Sa", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Ca", " ", "Cp", " ", "g1p", 
       " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{"Ca", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "sg", " ", "Sp", " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"Ca", " ", "e", " ", "sg", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "cg", " ", "Cp", " ", "g1p", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Cp", " ", "g1p", " ", "Sa", 
       " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "-", 
      FractionBox[
       RowBox[{
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", "sg", " ", "Sp", 
        " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"e", " ", "Sa", " ", "sg", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
      "2", " ", "b1", " ", "Ca", " ", "cg", " ", "Cp", " ", "g1p", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "a1", " ", "Cp", " ", "g1p", " ", "Sa", 
       " ", "sg", " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["c", "w"], " ", "e", " ", "Sa", " ", "sg", " ", "Sp", 
        " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"e", " ", "Sa", " ", "sg", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
         SuperscriptBox["e", "2"], " ", "Sp", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "Cp", " ", "e", " ", "g1p",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Ca", " ", 
         SuperscriptBox["e", "2"], " ", "Sp", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"a1", " ", "Ca", " ", "Cp", " ", "e", " ", "g1p", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"a1", " ", "Cp", " ", "e", " ", "g1p", " ", "Sa", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", "sg",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", "Sp", " ", "vev", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"a1", " ", "Cp", " ", "e", " ", "g1p", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
         SuperscriptBox["e", "2"], " ", "Sp", " ", 
         SubscriptBox["\[Eta]", 
          RowBox[{
           SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["c", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "Cp", " ", "e", " ", "g1p",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Ca", " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", "Ca", " ", "Cp", " ", "e", " ", "g1p", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", "Cp", " ", "e", " ", "g1p", " ", "Sa", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", "sg",
         " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["e", "2"], " ", "Sp", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", "Cp", " ", "e", " ", "g1p", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["cg", "2"], " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["cg", "2"], " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["cg", "2"], " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["sg", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["sg", "2"], " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "Ca", " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Ca", " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Ca", " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", "Sa", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "e", " ", "g1p", " ", "Sa",
         " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "cg", " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "sg", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "cg", " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "sg", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "cg", " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "sg", " ", "Sp", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "cg", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "sg", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "cg", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "sg", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "cg", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", "sg", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "e", " ", "g1p", " ", "sg",
         " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "Ca", " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "Sp", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Ca", " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", "Sp", " ", "x", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "Cp", " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", "Sp", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", "vev", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Cp", "2"], " ", "e", " ", "g1p", " ", "Sa", " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "e", " ", "g1p", " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", "Sp", " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Ca", " ", "Cp", " ", 
       SuperscriptBox["g1p", "2"], " ", "Sp", " ", "x", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["cg", "2"], " ", "Cp", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["cg", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"GP", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", 
        SuperscriptBox["Ca", "2"], " ", "Cp", " ", "e", " ", "g1p", " ", "Sp",
         " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["Ca", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["Ca", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sa", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["Sa", "2"], " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sa", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["cg", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["sg", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["sg", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", "Sp", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", 
        SuperscriptBox["sg", "2"], " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["sg", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Ca", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Ca", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", "Sp", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", "e", " ", "g1p",
         " ", "Sa", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "cg", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "sg", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "cg", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "sg", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
       SuperscriptBox["e", "2"], " ", "sg", " ", 
       SuperscriptBox["Sp", "2"], " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "cg", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "sg", " ", "Sp", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["s", "w"]], "-", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "cg", " ", "Cp", " ", "e", " ", "g1p",
         " ", "sg", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "cg", " ", 
        SuperscriptBox["e", "2"], " ", "sg", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", "Ca", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
       SuperscriptBox["e", "2"], " ", 
       SuperscriptBox["Sp", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sp", " ", "vev", 
        " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Ca", " ", "Cp", " ", "e", " ", "g1p",
         " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SuperscriptBox["e", "2"], " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "-", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", "x", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["a1", "2"], " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "Sa", " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["e", "2"], " ", "Sa", " ", 
       SuperscriptBox["Sp", "2"], " ", "vev", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubsuperscriptBox["c", "w", "2"], " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["s", "w", "2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "a1", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "g1p", " ", "Sa", " ", "Sp", 
        " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["s", "w"]], "+", 
      FractionBox[
       RowBox[{
       "\[ImaginaryI]", " ", "a1", " ", "Cp", " ", "e", " ", "g1p", " ", "Sa",
         " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       SubscriptBox["c", "w"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["e", "2"], " ", "Sa", " ", 
        SuperscriptBox["Sp", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev", " ", 
        SubscriptBox["\[Eta]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], 
       RowBox[{"2", " ", 
        SubsuperscriptBox["c", "w", "2"]}]], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["b1", "2"], " ", "Ca", " ", 
       SuperscriptBox["Cp", "2"], " ", 
       SuperscriptBox["g1p", "2"], " ", "x", " ", 
       SubscriptBox["\[Eta]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.850993334210025*^9},
 ExpressionUUID -> "e7e81d86-0547-4fcf-b9c2-a7248edd8c7c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matter sector", "Subsection",ExpressionUUID->"ed9d29f7-5a77-4e67-8a38-e652f364019d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vertsFermions", "=", 
  RowBox[{"FeynmanRules", "[", "LFermions", "]"}]}]], "Input",
 ExpressionUUID -> "39f7af7e-882e-4aae-9992-abc332e440bc"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.8510741981057053`*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074198107568*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074198109569*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074203437025*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "32", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "32", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  32, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 32, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074203504224*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850881839360668*^9, 3.850887165298978*^9, 
  3.8509825702842817`*^9, 3.851074208210596*^9},
 ExpressionUUID -> "38644f83-c560-44ff-9a2f-a6da47fb4ed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"nH", ",", "l", ",", "W"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`nH, FeynRules`l, FeynRules`W}, 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074208212521*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850881839360668*^9, 3.850887165298978*^9, 
  3.8509825702842817`*^9, 3.851074208341716*^9},
 ExpressionUUID -> "38644f83-c560-44ff-9a2f-a6da47fb4ed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"nL", ",", "l", ",", "W"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`nL, FeynRules`l, FeynRules`W}, 
   "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074208344366*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850881839360668*^9, 3.850887165298978*^9, 
  3.8509825702842817`*^9, 3.8510742084767923`*^9},
 ExpressionUUID -> "38644f83-c560-44ff-9a2f-a6da47fb4ed2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(QN :: \
NonConserv\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during \
this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850881839360668*^9, 3.850887165298978*^9, 
  3.8509825702842817`*^9, 3.8510742085338297`*^9},
 ExpressionUUID -> "38644f83-c560-44ff-9a2f-a6da47fb4ed2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ",", "nH", ",", 
     SuperscriptBox["W", "\[Dagger]"]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`lbar, $CellContext`nH, \
$CellContext`Wbar}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.8510742085356903`*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ",", "nL", ",", 
     SuperscriptBox["W", "\[Dagger]"]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`lbar, $CellContext`nL, \
$CellContext`Wbar}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.8510742085379543`*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"23", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[23, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850881825178611*^9, 3.850887150070633*^9, 
  3.85098255723103*^9, 3.851074208542542*^9},
 ExpressionUUID -> "b29fb27a-7906-491f-af2f-af66f301f78b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "e", " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"A", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", "\[ImaginaryI]", " ", "e", " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["g", "s"], " ", 
      TemplateBox[{SubscriptBox["\[Gamma]", 
         RowBox[{
           SubscriptBox["\"s\"", "1"], ",", 
           SubscriptBox["\"s\"", "2"]}]],SubscriptBox["\"\[Mu]\"", "3"]},
       "Superscript"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
      SubsuperscriptBox["T", 
       RowBox[{
        SubscriptBox["\<\"m\"\>", "1"], ",", 
        SubscriptBox["\<\"m\"\>", "2"]}], 
       SubscriptBox["\<\"a\"\>", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        TemplateBox[{"V","CKM"},
         "Superscript"], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","CKM"},
          "Superscript"], ")"}], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"W", ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["s", "w"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"6", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"3", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"S","m"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"4", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"S","m"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          TemplateBox[{"U","PMNS"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"S","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"U","PMNS"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          TemplateBox[{"U","PMNS"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"4", " ", 
         SubscriptBox["s", "w"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["s", "w"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"]}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"U","PMNS"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Cp", " ", 
         SubscriptBox["c", "w"], " ", "e", " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "1"], ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          RowBox[{
           TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
            "Superscript"], ".", 
           SubscriptBox["P", "\<\"-\"\>"]}], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["s", "w"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "e", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["c", "w"], " ", "e", " ", "Sp", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["s", "w"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"-\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["c", "w"]}]], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", "Sp", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         RowBox[{
          TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
           "Superscript"], ".", 
          SubscriptBox["P", "\<\"+\"\>"]}], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SubscriptBox["c", "w"]], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xH", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xPhi", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.850881839607959*^9, 3.850887165515133*^9, 
  3.850982570508235*^9, 3.8510742087771387`*^9},
 ExpressionUUID -> "473d12d9-1149-4144-b6bf-f6cc1bea225a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LYukawa", "]"}]], "Input",
 CellChangeTimes->{{3.850983698403797*^9, 3.850983711678684*^9}},
 ExpressionUUID -> "805137a5-65e7-45aa-9231-7bce1a56da24"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074345953225*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.8510743459548798`*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074346980341*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.8510743470755453`*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850983715877544*^9, 3.8510470782567387`*^9, 
  3.851074348044957*^9},
 ExpressionUUID -> "77c393e4-f91e-452f-b79e-8003aad4d86f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ",", "nH", ",", 
     SuperscriptBox["GP", "\[Dagger]"]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`lbar, $CellContext`nH, \
$CellContext`GPbar}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074348046796*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850983715877544*^9, 3.8510470782567387`*^9, 
  3.8510743481830997`*^9},
 ExpressionUUID -> "77c393e4-f91e-452f-b79e-8003aad4d86f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ",", "nL", ",", 
     SuperscriptBox["GP", "\[Dagger]"]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`lbar, $CellContext`nL, \
$CellContext`GPbar}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074348186631*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850983715877544*^9, 3.8510470782567387`*^9, 
  3.851074348339251*^9},
 ExpressionUUID -> "77c393e4-f91e-452f-b79e-8003aad4d86f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(QN :: \
NonConserv\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during \
this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.850983715877544*^9, 3.8510470782567387`*^9, 
  3.851074348430471*^9},
 ExpressionUUID -> "77c393e4-f91e-452f-b79e-8003aad4d86f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"nH", ",", "l", ",", "GP"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`nH, 
    FeynRules`l, $CellContext`GP}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074348434259*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"nL", ",", "l", ",", "GP"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`nL, 
    FeynRules`l, $CellContext`GP}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074348440648*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[18, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.850983713360812*^9, 3.851047075671515*^9, 
  3.851074348443012*^9},
 ExpressionUUID -> "95e4f0d3-c94b-494f-bb64-3ad8094f10a4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","CKM"},
          "Superscript"], ")"}], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "2"], ",", "Generation$1"}], "\<\"*\"\>"], 
       " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"y","d"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","CKM"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox[
        SubscriptBox["P", "\<\"+\"\>"], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        TemplateBox[{"y","u"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"cg", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","d"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","d"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","d"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["dq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","d"},
           "Superscript"], ")"}], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"cg", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","l"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","l"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","l"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","l"},
           "Superscript"], ")"}], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"dq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        TemplateBox[{"V","CKM"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"y","u"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox[
        SubscriptBox["P", "\<\"-\"\>"], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       SubscriptBox[
        TemplateBox[{"V","CKM"},
         "Superscript"], 
        RowBox[{
         SubscriptBox["\<\"f\"\>", "1"], ",", "Generation$1"}]], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       SubscriptBox[
        SubscriptBox["P", "\<\"+\"\>"], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
       SubscriptBox[
        TemplateBox[{"y","d"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","u"},
           "Superscript"], ")"}], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "2"], ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","u"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","u"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["uq", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"uq", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"sg", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","u"},
            "Superscript"], ")"}], 
          RowBox[{
           SubscriptBox["\<\"f\"\>", "2"], ",", 
           SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
         SubscriptBox["\[Delta]", 
          RowBox[{
           SubscriptBox["\<\"m\"\>", "1"], ",", 
           SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{
          SubscriptBox["\<\"f\"\>", "1"], ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      SubsuperscriptBox[
       RowBox[{"(", 
        TemplateBox[{"y","l"},
         "Superscript"], ")"}], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"S","m"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      SubsuperscriptBox[
       RowBox[{"(", 
        TemplateBox[{"y","l"},
         "Superscript"], ")"}], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"U","PMNS"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"S","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"]}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","l"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"U","PMNS"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"]}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","l"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "2"]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.850983715980341*^9, 3.851047078408854*^9, 
  3.8510743484665956`*^9},
 ExpressionUUID -> "1900c822-4a07-4f8c-9886-31e826b6f3b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vertsFermionsNR", "=", 
  RowBox[{"FeynmanRules", "[", "LFermionsNR", "]"}]}]], "Input",
 CellChangeTimes->{{3.850882071037043*^9, 3.85088207715975*^9}, {
  3.8508821806177588`*^9, 3.850882205705518*^9}, {3.850882277082376*^9, 
  3.850882279503973*^9}, {3.850882456435153*^9, 3.850882460286067*^9}, {
  3.850887229983877*^9, 3.8508872326623907`*^9}, {3.850993606838644*^9, 
  3.850993608209837*^9}},
 ExpressionUUID -> "e9c9c8fb-e7ea-4c1d-8474-576596430fc4"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.850882078603703*^9, {3.850882194817638*^9, 3.850882207032655*^9}, 
   3.85088246180079*^9, 3.850887193476156*^9, 3.850887234043108*^9, 
   3.8509838328331833`*^9, 3.85107435400272*^9},
 ExpressionUUID -> "61c8993a-257e-4904-a95b-24b67b2f679f"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.850882078603703*^9, {3.850882194817638*^9, 3.850882207032655*^9}, 
   3.85088246180079*^9, 3.850887193476156*^9, 3.850887234043108*^9, 
   3.8509838328331833`*^9, 3.851074354004382*^9},
 ExpressionUUID -> "61c8993a-257e-4904-a95b-24b67b2f679f"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.850882078603703*^9, {3.850882194817638*^9, 3.850882207032655*^9}, 
   3.85088246180079*^9, 3.850887193476156*^9, 3.850887234043108*^9, 
   3.8509838328331833`*^9, 3.8510743545590267`*^9},
 ExpressionUUID -> "61c8993a-257e-4904-a95b-24b67b2f679f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{9., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  6, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 6, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.850882078603703*^9, {3.850882194817638*^9, 3.850882207032655*^9}, 
   3.85088246180079*^9, 3.850887193476156*^9, 3.850887234043108*^9, 
   3.8509838328331833`*^9, 3.851074354628294*^9},
 ExpressionUUID -> "61c8993a-257e-4904-a95b-24b67b2f679f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[6, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.850882078603703*^9, {3.850882194817638*^9, 3.850882207032655*^9}, 
   3.85088246180079*^9, 3.850887193476156*^9, 3.850887234043108*^9, 
   3.8509838328331833`*^9, 3.8510743550491257`*^9},
 ExpressionUUID -> "61c8993a-257e-4904-a95b-24b67b2f679f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "g1p", " ", "Sp", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "g1p", " ", "Sp", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "Cp", " ", "g1p", " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"T","m"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Zp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"-\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "Cp", " ", "g1p", 
       " ", "xPhi", " ", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
       SubscriptBox[
        TemplateBox[{"V","V"},
         "Superscript"], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         SubscriptBox["P", "\<\"+\"\>"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8508820788017807`*^9, {3.850882194999659*^9, 3.850882207300618*^9}, 
   3.850882462080989*^9, 3.850887194870391*^9, 3.850887235482957*^9, 
   3.8509838340906057`*^9, 3.8510743551646547`*^9},
 ExpressionUUID -> "7e0fb574-aaa3-4cf1-bf1c-cbd9d56bd82b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.850888719595208*^9, 3.850888731312722*^9}},
 ExpressionUUID -> "cd032f03-2869-4be6-8ea7-b47e4b4e9a29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LYukawaNR", ",", 
   RowBox[{"FlavorExpand", "->", " ", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.850885362809791*^9, 3.850885395698728*^9}},
 ExpressionUUID -> "1bb3284d-c4c2-443f-875d-97cc00e88145"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074366813715*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074366815878*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.8510743668213463`*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074373110897*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "16", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "16", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  16, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 16, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.8510743731796923`*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.851074379772997*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"nL", ",", "l", ",", "GP"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`nL, 
    FeynRules`l, $CellContext`GP}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074379774776*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.851074379917141*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"nH", ",", "l", ",", "GP"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`nH, 
    FeynRules`l, $CellContext`GP}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074379920732*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.851074380056457*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(QN :: \
NonConserv\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during \
this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.851074380114089*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ",", "nL", ",", 
     SuperscriptBox["GP", "\[Dagger]"]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`lbar, $CellContext`nL, \
$CellContext`GPbar}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074380115767*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     OverscriptBox["l", "\<\"-\"\>"], ",", "nH", ",", 
     SuperscriptBox["GP", "\[Dagger]"]}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`lbar, $CellContext`nH, \
$CellContext`GPbar}, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074380117592*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[16, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8508853730203133`*^9, 3.850885397340332*^9}, 
   3.850887971912018*^9, 3.85088857410812*^9, 3.850888749202545*^9, 
   3.851074380121961*^9},
 ExpressionUUID -> "dc1b873d-187b-48c7-a0f7-a9f73f875e1f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      SubsuperscriptBox[
       RowBox[{"(", 
        TemplateBox[{"y","nd"},
         "Superscript"], ")"}], 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "2"], ",", "Generation$1"}], "\<\"*\"\>"], 
      " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"T","m"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "1"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"T","m"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"T","m"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"sg", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"T","m"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"T","m"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"U","PMNS"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"T","m"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"U","PMNS"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nL", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"sg", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"T","m"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"U","PMNS"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"U","PMNS"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"U","PMNS"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", "Generation$1"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"T","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"T","m"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"GP", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      SubsuperscriptBox[
       RowBox[{"(", 
        TemplateBox[{"y","nd"},
         "Superscript"], ")"}], 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "2"], ",", "Generation$1"}], "\<\"*\"\>"], 
      " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"-\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"V","V"},
        "Superscript"], 
       RowBox[{"Generation$1", ",", 
        SubscriptBox["\<\"f\"\>", "1"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"G0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"V","V"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"H2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"V","V"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Sa", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "Ca", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"nH", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"phiZp", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"sg", " ", 
         SubsuperscriptBox[
          RowBox[{"(", 
           TemplateBox[{"y","nd"},
            "Superscript"], ")"}], 
          RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
         SubscriptBox[
          SubscriptBox["P", "\<\"-\"\>"], 
          RowBox[{
           SubscriptBox["\<\"s\"\>", "1"], ",", 
           SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"S","m"},
           "Superscript"], 
          RowBox[{"Generation$1", ",", 
           SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
         SubscriptBox[
          TemplateBox[{"V","V"},
           "Superscript"], 
          RowBox[{"Generation$2", ",", 
           SubscriptBox["\<\"f\"\>", "1"]}]]}], 
        SqrtBox["2"]]}], "-", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","nd"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", "Generation$2"}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"S","m"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"sg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"S","m"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"y","nd"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       SqrtBox["2"]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"V","V"},
           "Superscript"], ")"}], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"], " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"+\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "-", 
      FractionBox[
       RowBox[{"cg", " ", 
        SubscriptBox[
         SubscriptBox["P", "\<\"-\"\>"], 
         RowBox[{
          SubscriptBox["\<\"s\"\>", "1"], ",", 
          SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$1", ",", 
          SubscriptBox["\<\"f\"\>", "1"]}]], " ", 
        SubscriptBox[
         TemplateBox[{"V","V"},
          "Superscript"], 
         RowBox[{"Generation$2", ",", 
          SubscriptBox["\<\"f\"\>", "2"]}]], " ", 
        SubscriptBox[
         SubscriptBox["y", "MN"], 
         RowBox[{"Generation$1", ",", "Generation$2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nL", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"T","m"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"]}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","nd"},
        "Superscript"], 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", "Generation$1"}]]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["l", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nH", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["GP", "\[Dagger]"], ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox[
        RowBox[{"(", 
         TemplateBox[{"V","V"},
          "Superscript"], ")"}], 
        RowBox[{"Generation$1", ",", 
         SubscriptBox["\<\"f\"\>", "2"]}], "\<\"*\"\>"]}], " ", 
      SubscriptBox[
       SubscriptBox["P", "\<\"+\"\>"], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
      SubscriptBox[
       TemplateBox[{"y","nd"},
        "Superscript"], 
       RowBox[{
        SubscriptBox["\<\"f\"\>", "1"], ",", "Generation$1"}]]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8508853753362303`*^9, 3.850885399685184*^9}, 
   3.8508879919130783`*^9, 3.85088858891162*^9, 3.850888763345212*^9, 
   3.851074380309847*^9},
 ExpressionUUID -> "9b5fd127-c0a7-43ad-9c1f-5fbcbb71887b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}, {
   3.850985838502554*^9, 
   3.850985841726392*^9}},ExpressionUUID->"0247bce5-b29e-451d-8e3c-\
f2985cfa814d"],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.528797217186555*^9, 
  3.528797236293277*^9}},ExpressionUUID->"572cfdd4-ad99-4cb7-9169-\
81ac74e2b274"],

Cell["\<\
The UFO output (for MadGraph5) for this model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.4119111540967712`*^9, 
  3.411911155096376*^9}, {3.535205860814587*^9, 3.535205867141062*^9}, {
  3.535205914201091*^9, 3.5352059214019833`*^9}, {3.8510475577016773`*^9, 
  3.851047560621006*^9}},ExpressionUUID->"a86627d1-9b2e-4097-bc49-\
dcf6824a395e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
    ",", " ", "LRHN", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", " ", "SU2W"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.528797221130815*^9, 3.528797221131584*^9}, {
   3.535205850686822*^9, 3.535205854235278*^9}, {3.7471053569188004`*^9, 
   3.747105357926936*^9}, {3.8325134655900183`*^9, 3.832513491698386*^9}, 
   3.850889112226372*^9, {3.850889142719158*^9, 3.850889144831066*^9}},
 ExpressionUUID -> "dbd8fe43-da9e-4a7f-a274-6f3d5e8ce7ab"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAO6ArNDgfSAA6i4MU=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBWmpGeHQ6kAQ4A4Lc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA+tzw9OxxIAwATyeFy
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA22ZSeHQ6kAQ9G4OM=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB2sFubHQ6kAQ4e4ME=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "12", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  12, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 12, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBm9V+XHQ6kAQzD4Jg=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"12", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[12, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIQlEYAOCbICVCWFqUiSEtJSQSYpBpHciCXoMYgtGQIIgWFkFBSksR
GClRFhRC4dZDMUGwiAZdjKAXgksW6vVi3hsYZuLWf4aPT2Ky68x1BEHIgX65
OvJepJGRokJ4S5Cdx5sGUpo0/DSzKvuAF6YvM3iFf/8xCytXPN4cvC4M3pPw
birwjK9vP5rMwz5/bQ7vWhRb8aKGjWM8Vc3c4GMqYxMFO5mgCv/HcSgL8BjP
9lCE5eShjIbPrL8OBr6wawL4Vk6O9Q0PK5PSHzjTHR3n0DRK6BSz+D5R+KoZ
Dn3dtQhgn6BSFsPbmXhODlu5EvMpTKX4e/idoqs/BhM93IqWoZGtsUM9CofV
vYmXEo2yhbjvFZ44UOvf4KWo+xNPBjb5SdjpiZ+TNRoFyc416SCDtnhd2pKb
QZHIkBNPyVjz5RCDWKzbKfY1gyyGNq4QPvGmbQb4HxRo4aE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIAmEcAHATpEQIS4syMaSlhERCDDKtD7Kg1yCGYDQkCKKFRVCQ0lIE
Rkr0gkAo3Hp4mCBYRIMuRtALwaWs0+sw7wLDTNz6f8OPn9zqMtpqOByOCpgW
K0OvBQZZaDqMtxO8T7y1L61/gx+mlpUZeG7ynMSrg7v3WViz5N/PwasS4paC
t9OhR3xt6+H4JxwIVmfw3nmZAy+tWzvC0xXyCh/XWhpo2MMSWvwf363JwyNC
510BVlEHSgY+cfy6WfjMpQ/hm/k57jc8qEkpfmCyMzbKZxiUNKqn8T3SyEUj
HP66aRLDAXG5JIM3yUROBTsEctsxTKdFO/itgrc3DnO6BGUDyyBnfZtuGI7o
upNPRQZl84nAMzy2pzO9wAsx3zueCq2LUrDHnzilqgwiqPYVRT+LNoQdhqKP
RdHogAdPK7mzpTCLuNzrCd4li+zmFoEENn5knGb4HxRC4aY=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIjLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLIKClC5F
YKREGwRC4a3FwQTBIjroxQjaELy0oI6DORMYZuKt/x0+PpnFabDWEAShBMal
yvBbgUFmmg7hbSQ3h7f0p3Tv8OP0iuIDnp+6SONVgb2HDKxe9h1k4TUxeUfB
O6ngE7627WgiB/sD1Vm8Z0Fqx0vq1o/xdCV9jY9pzI007GZJDf6P51Ln4VGB
474AK6lDBQOf2n9dLHzu1AXxLbws5xseUiflP3C6KzrGYxiUMKhm8L2S8GUT
HPq6bRbBflG5JIW30vGsErbzZdYTmE4Jd/HbBU9fDCa6+WU9yyBHQ7t2BA5r
exLPRQZl8nH/Czy+rzW+wotR7yeeCm4Ik7DbFz+jqgwiqY5V+QCLNgWd+qKX
RZHIoBtPKzhzpRCLOJybSe4Vi2ymVr4Yrmc/HCb4HxJm4Ww=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLIKClC5F
YKREGwRC4a1FMUGwiA5KYARtCF7KUMfBnAkMNfHW/w4fn8Rk15nrCIKQA/1y
deSjQCMjRQXxlgA7hzcNJDWf8PPMqiwFL0xfpvEK3/5TBlaueA6z8LowcE/C
u0n/C76+/XgyB3t9tTm8a1FsxYsaNk7wVDV9g4+qjE0U7GQCKvwfx6HMw2M8
22MBlpNHMho+s5YdDHxh1/jxrZws6wceViakv3C6OzLOoWkU1ylm8X2i0FUz
HPy+axHAXkGlJIa307GsHLZyJeZTmEry9/A7BVd/FCZ6uBUtQyNbY4d6FA6p
e+OvRRpl8jHvGzxxoNa/w0sR9xee9G/yE7DTEzsnazQKkJ1r0kEGbfG6tEU3
g8LhISeekrHmS0EGsVi3U+xrBlkMbVwh/FBO2QzwPxhm4i0=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB+pM+ZGw6kAQ734LI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "126", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "126", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  126, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 126, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQKS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQTi6AgpUsR
GCnRBoFQeGtxMEGwiA56MYI2BC8tqONgzgSGqXjrf4ePT2p26i11LBZLAQzL
1dH3Ao1MFBXCWwlODm8eTGk/4KfZVfknvDhzmcYrA/uPGVi14jvMwusi4p6E
d1PBZ3x9x/FUDvYHavN4j0Niw4sbNk7wVDV9g4+pTc0U7GYINb7Cdany8Djf
/lCAFeSRnIbPbH8uBr5waoP4Nm6W/QOPqJKyXzjdE53g0jRK6JVz+H5x+KoF
Dn3ftQphv7BcksDb6XhWAdt4UsspTKUEe/idgmcgBrN6eWUdQyN7U6dmDA5r
+hIvRRpl8nH/Kzx5oDG8wUtR7xeeDG4KkrDbFz8nazQiyK412RCDtvjduqKX
QZHIsBtPydkLpRCD2Ozbac41g6zGdp4Irnw2OozwPxR44Xk=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"126", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[126, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJCe8sArLxxIAwAS6eFX
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC+MS8wLxxIAwATZeFg
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCNkgMweiQIIhWFkFBSpci
MFKiDQKh8FammCBYRAe9GEEbgpcW1HEwZwLDTLz1v8PHJzHZdeYagiDkQL9c
GXor0MhIUSG8JcjO4U19Kc07/Di9KvuA5yf9abzCt/+QgZUrnsMsvC4M3pHw
birwhK9tPR7PwV5fdRbvWhBb8aK6jRM8VUlf42MqYwMFO5mgCv/HcSjz8AjP
dl+A5eSRjIbPrL8OBr6wawL4Zk6W9Q0PKpPSHzjdGR3l0DRK6BQz+B5R+LIR
Dn3dNglgr6BcEsPb6XhWDlu5EvMpTKX4e/idgqs3BhNd3LKWoZGtvk09DIfV
3YnnIo0y+bj3BR47UOtf4aWo+xNPBjb5SdjpiZ+TVRoFyfY1aT+Dtngd2qKb
QZHIgBNPyVhzpRCDWKybCfYVgyyGFq4Q9oenFg3wPxKJ4Uc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBOPBqYFw6kARC+4RA=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC2WP07LxxIAwASvOF3
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "32", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "32", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  32, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 32, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAOr/ibFw6kARJb4WU=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"23", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[23, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC2aenJDwfSAA824OY=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAWce7LDwfSAAw74H8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC2CevLDwfSAA4A4Lo=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBu6N6UHw6kARJr4Vc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  18, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 18, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBuOrElPxxIAwAUMuGY
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[18, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQLi6AgpUsR
GGnRBoFQeGtxMEGwiA56MYIWEby0MDoN5kxgmIm3/nf4+ORWl9FWw+FwVMC0
WBl6LTDIQtNhvJ3gfeKtfRn9G/w4tax8h+cmL0i8Orj3kIU1S/6DHLwqIe4o
eDsTesLXth6Nf8KBYHUG752XOfDSurVjPF0hr/FxraWBhj0socX/8d2aPDwi
dN4XYBV1qGTgU8evm4XPXfoQvpmf437Dg5q04gcmO2OjfIZBSaN6Gt8jjVw2
wuGv2yYxHBCXSzJ4k0zkVLBDILedwHRGtIvfKnh74zCnS1A2sAxy1rfphuGI
rjv5XGRQNp8IvMBj+zpTCl6I+T7wVGhdlIY9/sQZVWUQQbWvKPpZtCHsMBR9
LIpGBzx4WsmdLYVZxOXeTPCuWGQ3twgkcGkn5TLD/xbf4e4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIAmEcAHATpEQIS4syMaSlhERCDDKtD7Kg1yCGYDQkCKKFRVCQ0lIE
Rkr0gkAo3Hp4mCBYRIMuVlAWgksPTq/DvAsMM3Hr/w0/fnKry2ir4XA4KmBa
rAy9Fhhkoekw3k7wPvHWvoz+DX6cWla+w3OT5yReHdx9yMKaJf9+Dl6VELcU
vJ0JPeFrWw/HP+FAsDqD987LHHhp3doRnq6QV/i41tJAwx6W0OL/+G5NHh4R
Ou8KsIo6UDLwiePXzcJnLn0I38zPcb/hQU1a8QOTnbFRPsOgpFE9je+RRi4a
4fDXTZMYDojLJRm8SSZyKtghkNuOYToj2sFvFby9cZjTJSgbWAY569t0w3BE
151MFRmUzScCz/DYns70Ai/EfB94KrQuSsMef+KUqjKIoNpXFP0s2hB2GIo+
FkWjAx48reTOlsIs4nKvJ3iXLLKbWwQS+D6Vdpnhfxdq4gg=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtUhQRAtLIKClC5F
YKREGwRC4a3FwQTBIjroxQjaELy0oI6DORMYZuKt/x0+PpnFabDWcDgcJTAu
VYbeCgwy03QIbyO5ObylL6V7hx+nVhQf8PzkRRqvCuw9ZGD1su8gC6+JyTsK
3kkFn/C1rUfjOdgfqM7iPQtSO15St36Mpyvpa3xMY26gYTdLavB/PJc6D48I
HPcFWEkdKhj41P7rYuFzpy6Ib+ZliW94UJ2U/8Dpzugoj2FQwqCaxvdIwpeN
cOjrtkkE+0XlkhTeSsezStjOl1lPYDol3MVvFzy9MZjTxS/rWQY56tu0w3BY
2514LjIok4/7X+Cxfa3xFV6Mej/xVHBDmITdvvgZVWUQSbWvyvtZtCno0Be9
LIpEBtx4WkHMlUIsIoibCe4Vi2ymFr4YnikknSb4HxSw4bQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJCuFLqaHw6kAQ+24Po=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB2mGhQEA6kAQ2O4Jw=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "45", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "45", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  45, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 45, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmIGGRaD7Kg7SCGYHRIEEQLjaAgpUsR
GCnRBoFQeGtxMEGwiA56MYI2BC8tjE6DORMYZuKt/x0+PrnNbbLXcTgcFTAv
Vodfiwyy0nQU7yB4n3hbf9bwBj9MLyvf4fmpcxKvCe/e52DtUnA/D69KiFsK
3s5GHvH17YcTn3AoXJvF+xdkTry0Ye0IT1fJK3xSZ22iYR9L6PB/fK+2AI8K
XXdFWEUdKBn4xPnrZeEztyGCb+Xnud/wkDaj+IHJ7sQYn2FQ2qSZwaulsYtm
OPp10yKGQ+JKWQZvkqm8CnYK5PZjmM6KdvBbRX9fEub0CCpGlkGuxg79CBzT
96afSgzKFVKhZ3h8T29+gT2JwAeeiqyLMrAvmDqlagwiqM4VxQCLNoRdxlKA
RfH4oA9PK7lz5SiLuNzrSd4lixyWNoEEzlXVHgv8DxV04aY=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"45", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[45, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDuKY8vCAfSABBS4P0=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBe1pNaEA6kARHZ4TI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBump9aEA6kARE+4SE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC22J1aEA6kAQ+y4PM=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDerGpaGA6kAQ5V4Kk=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "22", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{18., {0., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "22", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  22, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 22, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAWDjEvDAfSAAqq4Do=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"22", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[22, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBWWMVdFA6kAQxp4HI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{27., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "236"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 236],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDW6okoCQfSAA2/4K0=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIAmEcAHA7kBIhLC3KxJCWEhIJMci0PsiCXoMYgtGQIIgWFoFBSksR
GCnRCwKhcOvhYYJgEQ26GEFWCC49UM/DvAsMK3Hr/w0/fjKL02Ct43A4SmBc
ro68lhhkpukw3kZyC3jLQEb3Bj/OuBTv8ML0RRavCu495GD1iv8gD6+JyTsK
3smEUvj69qPJAhwI1ubw3kWpHS9pWD/G09XsNT6uMTfRsIclNfg/nltdhMcE
jvsSrKQOFQx8av9xs/C5UxfCt/LyxBc8rE7Lv+Fsd2ycxzAoaVDN4vskkctm
OPx52yKCA6LfihTeyibyStjOl1lPYDoj3MVvl7z9cZjTw//VswxyNHZoR+GI
tjf5VGZQrpgIPMMT+1rjC7wU833gqdCGMA17/IkzqsYgkupclQ+yaFPQpS/7
WBSNDnnwtIKYr4RZRBA3U9wrFtlMbXwxHJOnXCb4HxJV4VI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.747032541592949*^9, 3.7470332415321407`*^9, 
  3.7470335800666857`*^9, 3.7470376340817738`*^9, 3.7470429055968246`*^9, 
  3.74704371572055*^9, 3.747046382486937*^9, 3.747046777191633*^9, 
  3.747047462774602*^9, 3.747055972901135*^9, 3.747105376576249*^9, 
  3.747105516694899*^9, 3.747124601832901*^9, 3.747127490761243*^9, 
  3.747149749162427*^9, 3.747186488852084*^9, 3.747412804904952*^9, 
  3.747413146416369*^9, 3.747484117821159*^9, 3.747753922379798*^9, 
  3.7477545002922783`*^9, 3.750135386746479*^9, 3.75013708864893*^9, 
  3.7501385566240597`*^9, 3.7501396700011387`*^9, 3.750142133457443*^9, 
  3.7548946975324297`*^9, 3.7896407038912363`*^9, 3.8325131369344587`*^9, 
  3.832513635453644*^9, 3.8508696234408073`*^9, 3.850906357764472*^9, 
  3.850948831084876*^9, 3.851074486945903*^9},
 ExpressionUUID -> "fbc5b6a2-4ee9-4bb8-aa3a-83795322f8fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N1", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N1bar, FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA2D75XFg6kAQ/G4Qk=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.747032541592949*^9, 3.7470332415321407`*^9, 
  3.7470335800666857`*^9, 3.7470376340817738`*^9, 3.7470429055968246`*^9, 
  3.74704371572055*^9, 3.747046382486937*^9, 3.747046777191633*^9, 
  3.747047462774602*^9, 3.747055972901135*^9, 3.747105376576249*^9, 
  3.747105516694899*^9, 3.747124601832901*^9, 3.747127490761243*^9, 
  3.747149749162427*^9, 3.747186488852084*^9, 3.747412804904952*^9, 
  3.747413146416369*^9, 3.747484117821159*^9, 3.747753922379798*^9, 
  3.7477545002922783`*^9, 3.750135386746479*^9, 3.75013708864893*^9, 
  3.7501385566240597`*^9, 3.7501396700011387`*^9, 3.750142133457443*^9, 
  3.7548946975324297`*^9, 3.7896407038912363`*^9, 3.8325131369344587`*^9, 
  3.832513635453644*^9, 3.8508696234408073`*^9, 3.850906357764472*^9, 
  3.850948831084876*^9, 3.851074487078471*^9},
 ExpressionUUID -> "fbc5b6a2-4ee9-4bb8-aa3a-83795322f8fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N1", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N1bar, FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCFg9iCEaHBEG0sAgMUroU
gZEibRAIhbcWxQTBIjroxQjaELy0oI6DORMYZuKt/x0+PonZobc0sFgsOTCs
1MbeSjQyUVQEbw2zC3jzUEbzDj/OOmUf8KLuIotXBPcecrBy1XeQh9eF4TsS
3s2EnvCNnUfTBTgQrM/jPUtiG17UtHGMp2rZa3xCZWqhYDcTVuH/OC5lEZ7g
2e9LsJw8lNHwqe3XxcDnDk0I387JE9/wqDIt/YGzvfFJDk2jlF4xhx8QRS9b
4cjXbZsADgiqFTG8nU3m5bCNK7GcwFSG78fvlDyDCZjVx61qGRrZm7vU43BU
3Z96LtMoV0wGXuCpfbXhFV6Oez/xZGiTn4bdvuQZWadRmOxekw4zaIvXoy17
GRSLjbjxlIxYqEQYRBA3M+wrBlmNHVwhrPPnnEb4HxJB4WE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"QN", "::", "NonConserv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: non quantum number conserving vertex encountered!\
\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.747032541592949*^9, 3.7470332415321407`*^9, 
  3.7470335800666857`*^9, 3.7470376340817738`*^9, 3.7470429055968246`*^9, 
  3.74704371572055*^9, 3.747046382486937*^9, 3.747046777191633*^9, 
  3.747047462774602*^9, 3.747055972901135*^9, 3.747105376576249*^9, 
  3.747105516694899*^9, 3.747124601832901*^9, 3.747127490761243*^9, 
  3.747149749162427*^9, 3.747186488852084*^9, 3.747412804904952*^9, 
  3.747413146416369*^9, 3.747484117821159*^9, 3.747753922379798*^9, 
  3.7477545002922783`*^9, 3.750135386746479*^9, 3.75013708864893*^9, 
  3.7501385566240597`*^9, 3.7501396700011387`*^9, 3.750142133457443*^9, 
  3.7548946975324297`*^9, 3.7896407038912363`*^9, 3.8325131369344587`*^9, 
  3.832513635453644*^9, 3.8508696234408073`*^9, 3.850906357764472*^9, 
  3.850948831084876*^9, 3.8510744872088823`*^9},
 ExpressionUUID -> "fbc5b6a2-4ee9-4bb8-aa3a-83795322f8fc"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(QN :: \
NonConserv\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during \
this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.747032541592949*^9, 3.7470332415321407`*^9, 
  3.7470335800666857`*^9, 3.7470376340817738`*^9, 3.7470429055968246`*^9, 
  3.74704371572055*^9, 3.747046382486937*^9, 3.747046777191633*^9, 
  3.747047462774602*^9, 3.747055972901135*^9, 3.747105376576249*^9, 
  3.747105516694899*^9, 3.747124601832901*^9, 3.747127490761243*^9, 
  3.747149749162427*^9, 3.747186488852084*^9, 3.747412804904952*^9, 
  3.747413146416369*^9, 3.747484117821159*^9, 3.747753922379798*^9, 
  3.7477545002922783`*^9, 3.750135386746479*^9, 3.75013708864893*^9, 
  3.7501385566240597`*^9, 3.7501396700011387`*^9, 3.750142133457443*^9, 
  3.7548946975324297`*^9, 3.7896407038912363`*^9, 3.8325131369344587`*^9, 
  3.832513635453644*^9, 3.8508696234408073`*^9, 3.850906357764472*^9, 
  3.850948831084876*^9, 3.8510744872708263`*^9},
 ExpressionUUID -> "fbc5b6a2-4ee9-4bb8-aa3a-83795322f8fc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N1", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N1bar, $CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIAmEcAHA7kBIhLC3KxJCWEhIJMai0PsiCXoMYgtGQIIgWFoFBSksR
GCnRCwKhcKv0MEGwiAZdjKAXgksP1PMw7wLDTNz6f8OPn8zs0FvqOByOEhhW
qqNvRQaZaDqMt5LcPN48kNa+w4+zTsUHvDhzmcGrAvsPWVi96jvMweti8o6C
d9OhJ3x9+/FUHvYHavN4z5LUhpc0bJzg6WrmGh8fNDXRsJslB/F/PJe6AI8L
7PdFWEkdKRj4zPbrYuELhzaEb+XliG94RJ2S/8CZ7tgEj2FQUq+aw/dJIsFm
OPx12yKC/aJKWQpvZxI5JWzjyyynMJ0W7uF3ip7+OMzp4Vd0LIPsjR2aMTii
6U0+lxiULST8L/DkgcbwCi/HvJ94KrQpTMFuX+KcqjGIpDrX5EMs2hJ06Upe
FkWjw248rSAWymEWEcTNNPeKRVZjG18MB2MFpxH+BxZt4e0=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N2", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N2bar, FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQLi8AgpUsR
GCnRBoFQeGtxMEGwiA4KYQRtCF5aGJ0GcyYwzMRb/zt8fHKry2ir4XA4KmBa
rAy9FhhkoekI3k7wPvHWvoz+DX6Ycivf4bnJMxKvDu3cZ2HNUmAvB69IiBsK
3sqEH/G1rQfjn3AwVJ3B++ZlDry0bvUQT1fIS3xCa2mgYS9LaPF/fI8mD48I
nXcFWEXtKxn42PHrYeFTlz6Mb+bnuN/woCat+IHJzvgon2FQyqiexvdIo+eN
cOTrukkMB8XlkgzeIJM5FewQyG1HMJ0RbeM3C77eBMzpEpQNLIOc9W26YTiq
6049FRmUzSeDz/DYrs70Ai/E/R94KrwmSsPeQPKEqjKIoNqXFf0sWhd2GIp+
FsViA148reTOliIs4nKvJngXLLKbWwQSOHubd5vhfxh/4jE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N2", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N2bar, FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tjI6DORMYVmKn/nf4+GQWp8FaQxCEEhgX
K0MvRQaZaTqCt4W5ebylL6N7he+nXIo3eG7yjMSrgjt3WVi95N/LwSvi8A0F
b2VCD/ja1oPxPBwIVmfw3nmpHS+pWz3E0xXyEp/QmBto2MOGNfhfnltdgEcE
jtsirKT2FQx8bP92s/CpUxfCN/NynE94UJ2Wf8FkZ3yUxzAoZVBN43sk0fNG
OPJx3SSCA6KfshTeIJM5JWzny6xHMJ0RbuM3i97eBEx08X/0LIMc9W3aYTiq
7U49lhiULSQDT/DYrtb4DC/Efe94KrQmTMMef/KEqjIoTLUvy/tZtC7o0Jd8
LIrFBjx4WsGZLUdYxOFcTXAvWGQztfDF8B9bcJngfxpJ4m8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N2", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N2bar, $CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD2k35ZFg6kAQ844PM=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N3", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N3bar, FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD2MXlZFg6kAQ/X4Qo=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N3", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N3bar, FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDO8X5ZFg6kARF44UE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["N3", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`N3bar, $CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYglGQIIgWFoFBSpci
MFKiDQKh8NaimCBYRAe9GEEbgpdK1HFQZwKjTLz1v8PHJzHZdeY6FoslB/qV
6sh7iUZGigrhLUF2Hm8aSGk+4KcZh+wTXpy+zOAV/v3HLKxc9R7m4HVh8J6E
d1OBZ3x9+/FkHvb5a3N495LYihc1bJzgqWrmBh9TGZso2MUEVfg/jlNZgMd4
tocSLCePZDR8Zv11MvCFXRPAt3JyxBc8rExKv+FMd3ScQ9MooVPM4vtE4atm
OFS8axHAPkHlRwxvZ+I5OWzlSsynMJXi7+F3Su7+GMzq4Va0DI1sjR3qUTis
7k28lGmULcR9r/DEgVr/Bi9HPWk8GdjkJ2GXN35O1mgUJDvXpIMM2uJ1acse
BkUiQy48JSMWfkIMIojbKfY1gyyGNq4QTs8XHQb4HxWV4cc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL1", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL1bar, FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBWKH5ZFg6kARAw4R0=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL1", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL1bar, FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDWbH9ZFg6kAREE4To=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL1", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL1bar, $CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREG0RC4a1FMUGwiA56MYI2BC8tqOOgzgSGmXjrf4ePT2Ky68x1BEHIgX65
OvJepJGRokJ4S5Cdw5sGUpoP+GnGIfuEF6Yv03iFf+8xAytXvAdZeE0YvCfh
nVTgGV/ffjSZg33+2hzevSi24kUN68d4qpq+wcdUxiYKdjFBFf6P41Tm4TGe
7aEIy8lDGQ2fWX+dDHxh1wTwrZws6xseVialP3C6OzrOoWmU0Clm8X2i8FUz
HCrctQhgn6BSFsNb6XhWDlu5EvMpTKX4u/jtors/BhM93IqWoZGtsUM9CofV
vYmXEo0y+bjvFZ7YV+vf4KWo5wtPBjb4SdjljZ+TNRoFyc5V6SCDNnld2pKH
QZHIkAtPyVjz5RCDWKzbKfY1gyyGNq4QLpwUHAb4HxeQ4g4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL2", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL2bar, FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBQhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tqOOgzgSGmXjrf4ePT2p26C0NLBZLAQwr
tdH3Eo1MFBXGW0PsPN48mNZ+wE+zTvknvDhzmcErA/uPWVi16jvMweui0D0J
76aDz/jGjuOpPOwP1OfxniWJDS/mbJzgqVrmBh9Xm5op2M2E1Pg/rktVgMf5
9ocSrCCP5DR8Zvt1MfCFQxvEt3FzxDc8okrJfuBMT2yCS9MoqVfO4fvFkasW
OFy8axXCfmG1IoG3M4mcArbxpJZTmEoL9vA7Jc9AHGb18qo6hkb2pk7NGBzR
9CVfyjTKFhL+V3jyQGN4g5dj3i88GdwUpGC3L3FO1mkUIrvWZEMM2uJ368pe
BkWjw248JScWKmEGEcTtNPuaQVZjO08Ec8JFpxH+BxEb4UI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL2", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL2bar, FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSopBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA7awQjaELy0oE6DOhMYZuKt/x0+PonZobfUsVgsOTAs
VYffijQyUVQYbw2xv/Dm/rT2HX6cdso+4Pmp8wxeEdh9yMLKZd9+Dl4Vhm5J
eDsdfMLXtx9OfMH+QG0W71kQ2/CihrUjPFXNXOHjalMTBbuZkBr/x3Ep8/Ao
z35fhOXkgYyGT2y/LgY+c2iD+FZOjviGh5Qp6Q+c6Y6NcWgaJfWKGXyfKHLR
DIcLNy0C2C+olMXwZiaRk8M2rsRyDFNp/g5+q+hRxWFWD7eiY2hkb+zQjMAR
TW/yuUSjbD7hf4HH9zSGV3gx5v3Ek8F1fgp2+xKnZI1GIbJzRTrAoA1el67k
ZVA0OujGUzJirhxmEEFcT7IvGWQ1tnGFsOqu4DTC/xMf4YU=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL2", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL2bar, $CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJCedONlWTiQBgAWg+H0
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL3", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL3bar, FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYlBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tjI6DOhMYZuKt/x0+PpnZobfUcTgcJTCs
VEffiwwy0XQYbw1xc3jzQFr7AT/NOhWf8OLMJYlXBfYfM7B61XeYhdfFoXsK
3k0Hn/H17cdTOdgfqM3jPUtSG17SsHGCp6vkDT4+aGqiYTcbGsT/8VzqPDwu
sD8UYSV1pGDgM9uvi4UvHNogvpWXJb7hEXVK/gOT3bEJHsOgpF41h++TRK6a
4XDhrkUE+0WVshTeJhNZJWzjyyynMJ0W7uF3ip7+OMzp4Vd0LIPsjR2aMTii
6U2+lBiUySf8r/DkgcbwBi/HvF94KrgpTMFuX+KcqjEoRHWuyYdYtCXo0pW8
LIpGh914WkEslMMsIojbae41i6zGNr4YtpQKTiP8DxXD4d8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL3", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL3bar, FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA+wvKqLBxIAwASTeFT
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"W", ",", 
     OverscriptBox["nL3", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, " not conserved in vertex ", {
   FeynRules`W, $CellContext`nL3bar, $CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3MxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiAi9GEEbgpcW1HEwZwLDTLz1v8PHJzU79JY6FoulAIal
6vBbkUYmigrjrSF2Hm/uT2vf4cdpp/wDnp86z+CVgd2HLKxa9u3n4FVR6JaE
t9PBJ3x92+FEHvYHarN4z4LEhhc3rB3hqWrmCh9Xm5oo2M2E1Pg/jktVgEd5
9vsirCAP5DR8Yvt1MfCZQxvEt3JyxDc8pErJfuBMV2yMQ9MoqVfO4HvFkYtm
OPx10yKA/YJKWQJvZhI5BWzjSi3HMJXm7+C3ip6+OMzq5lZ0DI3sje2aETii
6Uk+l2iULST8L/D4nsbwCi/GvJ94MrjOT8FuX+KUrNEoRHasyAYYtMHr1JW8
DIpGB914Sk7MlcMMIojrSfYlg6xGIVcE3wmLTiP8DxK54WM=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "N1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`ebar, \
$CellContext`N1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD+p/OqLBxIAwAVNeG1
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "N2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`ebar, \
$CellContext`N2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD2c3xVFg6kARBI4Ro=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "N3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`ebar, \
$CellContext`N3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBuCX1VFg6kARKE4WQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "N1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`mubar, \
$CellContext`N1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONgMxMYZuKt/x0+PpnFabDWcTgcJTAu
V0feaAaZKSqCt4W5BbxlIKN7hx9nXIoPeGH6IotXBfcecrB6xX+Qh9fE4TsS
3smEnvD17UeTBTgQrM3hvYtSO17SsH6Mp6rZa3xCY26iYA8b1uD/eG51ER4T
OO5pWEkeKhj41P7rZuFzpy6Eb+XliW94WJ2W/8DZ7vg4j2FQyqCaxfdJopfN
cOTrtkUEB0SVshTeyibzStjOl1lPYCoj3MVv097+BMzp4Vf0LIMcjR3aUTiq
7U09lxiUKyYDL/DEvtb4Ci/FfZ94MrQhTMMef/KMrDEoTHauygdZtCno0pd8
LIrFhjx4SkHMlyMsIoibKe4Vi2ymNr4Yjtpplwn+BxSH4ac=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "N2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`mubar, \
$CellContext`N2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC2aXpVFg6kARF/4Uk=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "N3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`mubar, \
$CellContext`N3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQLi8AgpUsS
GCnRBoFgeGtRTBAsooNejKANwUsL6jjYzASGmXjrf4ePT2p26C0NLBZLAQyr
tbE3ikYmkozirRFOEW8eymrf4cc5p/wDXpq9yOGVof2HPKxa8x8W4A1R5I6A
d7PhJ3xj5/F0EQ6E6gt477LEhhc3bZ7gyVruGp9Um1pI2M1E1Pg/rktVgif4
9nsKVhBHcho+tf26GPjcoQ3j27kF9jc8qsrIfuBcb2KSS9MorVfO4wfEsctW
OPp12yaEA8JqRQJv51IFBWzjSS1BmMwK9vA7lHcwCbP6eFUdQyN7c5dmHI5p
+tPPZRrlS6nACzx1oDG8wisJ3yeeCG8JMrDbnzoj6jSKEN3rsmEGefg9urKP
QfH4iBtPytmLlSiD2OybGc4Vg6zGDp4I9gQppxH+BxSK4a4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "N1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`tabar, \
$CellContext`N1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKFlC5F
YKREGwRC4a1FMUGwkA56MYI2BC8tqONgzgSGmXjrf4ePT2Ky68wNLBZLDvSr
tbG3Eo2MFBXGW0LsAt40lNG8w49zDtkHvDR7mcUrAvsPOVi55jvMw+vC0B0J
72aCT/jGzuPpAuwP1BfwnmWxFS9q2jjBU7XsDT6hMrZQsJsJqfB/HJeyCE/w
bPclWE4eyWj4zPrrYuALuyaIb+fkiW94VJmW/sDZ3tgkh6ZRSqeYxw+IIlet
cPgr3iaA/YJqRQxvZ5N5OWzlSsynMJXh7+F3Sp7BBMzq41a1DI1szV3qcTii
7k89l2mUKyb9L/DUgVr/Cq/EvJ94MrjJT8NuX/KcrNMoRHY7pcMM2uL1aMte
BkWjI248JSMWK2EGEcTtDPuaQRZDB1cIO+MlhwH+BxTt4b4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "N2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`tabar, \
$CellContext`N2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBeduFVWTiQBgAW8eIB
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "N3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`tabar, \
$CellContext`N3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQLi8AgpUsR
GCnRBoFQeGtxMEGwiA56MYI2BDu0oE6DzUxgmIm3/nf4+ORWl9FWw+FwVMC0
WBl6pRlkoagI3k7wPvHWvoz+Db6fcivf4bnJsyxeHdq5y8GapcBeHl6REDck
vJUJP+BrWw/GP+FgqDqD983LHHhp3eohnqpkL/EJraWBgr0socX/8T2aAjwi
dN7SsIrcVzLwsePXw8KnLn0Y38zPc7/hQU1a8QNnO+OjfIZBKaN6Gt8jjZ43
wpGv6yYxHBSXSzJ4I5vMq2CHQG47gqmMaBu/Sft6EzCnS1A2sAxy1rfphuGo
rjv1WGRQrpAMPsFjuzrTM7wQ93/gyfCaKA17A8kTssoggmxfVvSzaF3YYSj6
WRSLDXjxlJI7W4qwiMu9muBdsMhubhFI4BeSdpvhfxkN4kc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "nL1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`ebar, \
$CellContext`nL1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAO+PuqLBxIAwAVfOHY
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "nL2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`ebar, \
$CellContext`nL2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJiQSYlBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a3FwQTBIjroxQjaELy0oI6DORMYZuKt/x0+PpnFabDWcTgcFTAu
V0feigwy03QYbyO5ebylP617hx9nXMoPeGH6IoNXB/cesrBmxX+Qg9fE5B0F
76RDT/j69qPJPBwI1ubw3kWpHS9pWD/G09XMNT4+YG6iYQ9LDuD/eG5NAR4T
OO6LsIo6VDLwqf3XzcLnTl0I38rLEd/wsCal+IEz8tg4j2FQ0qCexfdKIpfN
cPjrtkUEB0SVshTeyiRyKtjOl1lPYDot3MVvF719cZjTza/oWQY5Gju0o3BE
25N8LjEoW0gEXuCJfa3xFV6K+T7xVGhDmII9/sQZVWMQSXWuKgZZtCno0pd8
LIpGhzx4WknMl8MsIoibKe4Vi2ymNr4YJuWMywT/AxKf4WI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "nL3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`ebar, \
$CellContext`nL3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC2cXhdFg6kAQ+34Qg=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "nL1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`mubar, \
$CellContext`nL1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEkQLi8AgpUsR
GCnRBoFQeGpTTBAsooNejKANwUsLo+NgzgSGmXjrf4ePT2p26C01LBZLAQxL
laG3Ao1MFBXGW0OcHN7cl9a+w49TTvkHPD95QeCVgd2HDKxa9u1n4VVR6I6E
t9PBJ3xt6+F4DvYHqjN4z4LEhhfXrR3hqQpxjY+rTQ0U7GZCavwf16XKwyN8
+30BVpAHcho+sf26GPjcoQ3im7lZ9jc8qErJfmCiMzbKpWmU1Cun8T3iyGUj
HP66bRLCfmG5JIE3iURWAdt4UssxTKUFO/itgqc3DrO6eGUdQyN7fZtmGI5o
upPPRRpl8gn/Czy2pzG8wosx7yeeDK4LUrDblzgjqzQKke0rsn4GbfA7dEUv
g6LRATeekrNnS2EGsdk3E5wrBlmNLTwRfDpHO43wPxQT4Zg=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "nL2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`mubar, \
$CellContext`nL2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAOrXpdFg6kARIV4Vs=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "nL3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`mubar, \
$CellContext`nL3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIQlEYAOCbICVCWFqUiSEtJSQSYpBpHciCXoMYgtGQIIgWFoFBSksR
GCnSCwKhcOuhmCBYRIMuRtALwaUM9Xox7w0MM3HrP8PHJzHZdeYGgiDkQL9a
G3sv0chIUWG8JcQu4E1Dac0H/DTnkGXgpdnLLF4R2H/Mwco172Ee3hCG7kl4
Lx18xjd2Hk8XYH+gvoB3L4uteFHT5gmeqmVv8HGVsYWCXUxIhf/jOJVFeIJn
eyjBcvJIRsNn1l8nA1/YNUF8OyfP+oZHlSnpD5ztjU1yaBoldYp5/IAoctUK
h7/u2gSwX1CtiOGdbCIvh61cifkUptJ8H3635B6Mw0Qft6plaGRr7lKPwxF1
f/KlTKNcMeF/hacO1Po3eCXm+cSTwS1+CnZ5E+dknUYhsntdOsygbV6Ptuxh
UDQ64sJTMtZiJcwgFut2hn3NIIuhgyuEMz7aYYD/ARb34fo=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "nL1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`tabar, \
$CellContext`nL1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDWWva6LBxIAwAR8eFc
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "nL2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`tabar, \
$CellContext`nL2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATrEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQLi8AgpUsR
GCnRBoFQeGtRTBAsqoNejKANwUsLo+NgzgSGmXjrf4ePT2p26C01LBZLAQxL
leG3Ao1MFBXGW0OcHN7cn9a+w4/TTvkHPD91TuCVgd2HDKxa9u1n4VVR6I6E
t9PBJ3xd2+FEDvYHqrN4z4LEhhfXrx3hqQpxhY+rTY0U7GZCavwf16XKw6N8
+30BVpAHcho+sf26GPjMoQ3iW7hZ9jc8pErJfmCiKzbGpWmU1Ctn8L3iyEUT
HP66aRbCfmG5JIE3iURWAdt4UssxTKUFO/itgqcvDrO6eWUdQyN7Q7tmBI5o
epLPRRpl8gn/Czy+pzG8wosx7yeeDK4LUrDblzglqzQKkR0rsgEGbfA7dUUv
g6LRQTeekrPnSmEGsdnXk5xLBlmNrTwRXHtLO43wPxFy4U8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["W", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "nL3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`Wbar, $CellContext`tabar, \
$CellContext`nL3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCYmEGGRaD7Kg7SCGYHRIEEQLi8AgpUsR
GCnRBoFQeGtxMEGwiA56MYI2BCFaGJ0GcyYwzMRb/zt8fHKry2ir4XA4KmBa
rAy9FhhkoekI3k7wPvHWvoz+Db6fcivf4bnJMxKvDu3cZWHNUmAvB69IiBsK
3sqEH/C1rQfjn3AwVJ3B++ZlDry0bvUQT1fIS3xCa2mgYS9LaPF/fI8mD48I
nbcFWEXtKxn42PHrYeFTlz6Mb+bnuN/woCat+IHJzvgon2FQyqiexvdIo+eN
cOTrukkMB8XlkgzeIJM5FewQyG1HMJ0RbeM3C77eBMzpEpQNLIOc9W26YTiq
6049FhmUzSeDT/DYrs70DC/E/R94KrwmSsPeQPKEqjKIoNqXFf0sWhd2GIp+
FsViA148reTOliIs4nKvJngXLLKbWwQSOPvCuM3wPxkd4kg=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "N1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`ebar, \
$CellContext`N1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC2Y3lTFg6kAQ4p4M8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "N2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`ebar, \
$CellContext`N2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA2kX1TFg6kAQ6I4N4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "N3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`ebar, \
$CellContext`N3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQWYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMcGwiA56MYI2BC8tqONgzgSGmXjrf4ePT2Ky68w1LBZLDvRL
leG3Ao2MFBXCW4LsHN7Un9K8w4/TDtkHPD91nsYr/LsPGVi57N3PwqvC4B0J
b6cCT/ja1sOJHOzzV2fx7gWxFS+qWzvCU5X0NT6mMjZQsIsJqvB/HKcyD4/y
bPcFWE4eyGj4xPrrZOAzuyaAb+ZkiW94SJmU/sDpzugYh6ZRQqeYwfeKwheN
cOjrtkkA+wTlkhjeTMezctjKlZiPYSrF38FvFdx9MZjVxS1rGRrZ6tvUI3BY
3Z14LtIok4/7XuDxPbX+FV6Mej7xZGCdn4Rd3vgpWaVRkGxfkQ4waIPXoS16
GBSJDLrwlIyYK4UYRBA3k+xLBlkMLVwhfNXDOAzwPxMk4XQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "N1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`mubar, \
$CellContext`N1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBucXtTFg6kARIn4Vc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "N2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`mubar, \
$CellContext`N2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtIhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONgzgSGqXjrf4ePT2J26CwNLBZLDvQr
tbH3Io2MFBXGW0PsPN48lNZ8wE9zTtknvDh7mcErAvuPWVi56jvMwevC0D0J
76aDz/jGzuPpPOwP1OfxniWxDS9q2jjBU7XMDT6uMrZQsJsJqfBVjktZgCd4
9ociLCePZDR8ZvtzMfCFQxPEt3NyxA88qkxJf+FMb2ySQ9MoqVOY8AOiyFUr
HP6+axPAfkGlLIa3M4mcHLZxJZZTmErz9/A7Rc9gHGb1cStahkb25i71OBxR
9ydfSjTKFhL+V3jqQK1/g5dj3i88Gdzkp2C3L3FO1mkUIrvXpMMM2uL1aEte
BkWjI248JSMWymEGEcTtDPuaQVZDB1cIV02M0wD/AxZK4d4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "N3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`mubar, \
$CellContext`N3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA2KXxTFg6kARDU4TI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "N1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`tabar, \
$CellContext`N1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBe0vmmLBxIAwAU/OG6
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "N2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`tabar, \
$CellContext`N2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtTAKDlC5F
YKREGwRS4a1FMUGwiA56MYI2BC8tqONgzgSGmXjrf4ePT2Ky68x1BEHIgd5R
HXkr0shIUWG8JcTO400Dac07/DjjlH3AC9MXGbwisPuQhZXLvv0cvCoM3ZHw
djr4hK9vP5zMw/5AbQ7vWRRb8aKGtSM8Vc1c4+MqYxMFu5mQCv/HcSkL8BjP
dl+E5eSBjIZPrb8uBj63a4L4Vk6O9Q0PK1PSHzjTHRvn0DRK6hSz+D5R5LIZ
Dn/dtghgv6BSFsObmURODlu5EvMJTKX5O/itoqc/DhM93IqWoZGtsUM9CkfU
vcnnEo2yhYT/BZ7YU+tf4aWY9xNPBtf5KdjtS5yRNRqFyM4V6SCDNnhd2pKX
QdHokBtPyVjz5TCDWKybKfYVgyyGNq4QdhwzTgP8DxP34Zw=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "N3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`tabar, \
$CellContext`N3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIAmEcAHATpEQIS4syMaSlhERCDCqtD7Kg1yCGYDQkCKKFRWCQ0lIE
RkqUBYFQuPXwMEGwiAZdjKAXgksPTs/DvAsMM3Hr/w0/fnKL02Ct43A4KmBc
qY6+FRlkpukI3kbw8njLQEb3Dj/OupQf8OLMBYlXh/YfsrBm1R/IwesS4o6C
dzPhJ3x9+9FUHg6GavN475LMjpc2bBzj6Sp5jU8Mmpto2MMSg/g/vltTgMeF
jvsirKIOlQx8av91s/C5UxfGt/Jz3G94RJNW/MBkd3yCzzAoZVDP4fuk0ctm
OPJ12yKGg+JKWQZvk8mcCrYL5NYTmM6I9vA7RW9/Aub0CCp6lkGOxg7tGBzV
9qaeSwzKFpLBF3jyQGt8hZfjvk88Fd4UpWGPP3lG1RhEUJ1riiEWbQm79CUf
i2KxYQ+eVnIXyhEWcbk307wrFtlMbQIJHIiyLhP8DxWb4dM=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "nL1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`ebar, \
$CellContext`nL1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA4KYQRtSF5aUMfBnAkMM/HW/w4fn8Rk15lrCIKQA/1i
ZeitQCMjRYXwliA7hzf1pTTv8MOUQ/YBz02epfEK/859BlYuefey8IoweEPC
W6nAI7629WA8B/v81Rm8e15sxYvqVg/xVCV9iY+pjA0U7GKCKvwfx6nMwyM8
210BlpP7Mho+tv46GfjUrgngmzlZ1jc8qExKf+B0Z3SUQ9MooVNM43tE4fNG
OPR13SSAfYJySQxvpONZOWzlSsxHMJXib+M3C+7eGEx0cctahka2+jb1MBxW
dyeeijTK5OO+Z3hsV61/gReink88GVjjJ2GXN35CVmkUJNuXpf0MWud1aIse
BkUiAy48JWPNlkIMYrGuJtgXDLIYWrhC+PWWcRjgfxg34ik=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "nL2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`ebar, \
$CellContext`nL2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIAmEcAPDrQEqEsLQoE0NaSkgkxCDT+iALeg1iCEZDgiBaWAQGKS1F
YKRELwiEwq2HYoJgEQ26GEEvBJcy1PMw7wLDStz6f8OPn9Ts0FvqCIJQAMNy
deStxCATTYfx1hCngDcPpLXv8OOMU56BF6YvsnhlYO8hB6tWfAd5eE0UuqPg
nXTwCV/ffjRZgP2B2hzesyix4cUN68d4upq9xsfVpiYadrMhNf6P61IV4TG+
/b4EK6hDOQOf2n5cLHzu0Abxrdw8+QUPq1KybzjbHRvnMgxK6pWz+D5x5LIZ
Dn/etghhv/C3IoG3som8ArbxpJYTmE4LdvHbJU9/HCZ6eL86lkH2xg7NKBzR
9CafywzKFRP+F3hiX2N4hZdi3g88FdwQpGC3L3FG1RgUojpXZYMs2uR36cpe
FkWjQ248LSfnK2EWkeTNFOeKRVZjG08EGzKs0wj/AxTP4b8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["e", "\<\"-\"\>"], ",", "nL3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`ebar, \
$CellContext`nL3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD+8+9NWTiQBgAa7+KH
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "nL1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`mubar, \
$CellContext`nL1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD2kXpbFg6kAQ854PQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "nL2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`mubar, \
$CellContext`nL2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB2M3hbFg6kAQ+j4QQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["mu", "\<\"-\"\>"], ",", "nL3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`mubar, \
$CellContext`nL3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAucHlbFg6kARF/4UI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "nL1"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`tabar, \
$CellContext`nL1}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDuiHhbFg6kARLL4W4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "nL2"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`tabar, \
$CellContext`nL2}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIQlEYAGC7ICVCWFqUiSEtJSQSYlBpHciCXoMYgtGQIIgmFoFBSksR
GCnRCwKhcMtSTBAsokEXI+iF4NID9Xox7xUMM3HrP8PHJzHataYGFoslB7rV
2vh7kUYGigrjzSF2Hm8cSqs/4Kd5h+wTXp67zOAV/oPHLKxc8x7l4A1h6J6E
99LBZ3xj58lMHvb564t4t01swYuaNk/xVC1zg48PG1oo2MWEhvF/HKeyAE/y
rA9FWE4ey2j43PLrZOCAXR3Et3NyRAkeU6akP3CmNzbFoWmU1CoW8AOiyFUr
HP6+axPAPkG1IoZ3MomcHLZwJaYzmErz9/G7RfdgHGb1casahkbW5i7VBBxR
9SdfyjTKFhK+V3j6UKV7g1dini88Gdzip2CXN3FB1mkUIrvXpSMM2ub1aMoe
BkWjoy48JSOWKmEGEcTtLPuaQWZ9B1cIB2wlhx7+BxRu4aU=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["GP", "\[Dagger]"], ",", 
     OverscriptBox["ta", "\<\"-\"\>"], ",", "nL3"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GPbar, $CellContext`tabar, \
$CellContext`nL3}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBma35bFg6kAQ/o4Rc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N1", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N1bar, 
    FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBJkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGxRC4a1FMUGwiA56MYI2BC8tqONgzgiGmXjrf4ePT2Ky68x1BEHIgX65
OvJeoJGRokJ4S5Cdw5sGUpoP+GnGIfuEF6Yv03iFf+8xAytXvAdZeE0YvCfh
nVTgGV/ffjSZg33+2hzevSi24kUN68d4qpq+wcdUxiYKdjFBFf6P41Tm4TGe
7aEAy8lDGQ2fWX+dDHxh1wTwrZwsqwgPK5PSHzjdHR3n0DRK6BSz+D5R+KoZ
Dn3ftQhgn6BSFsNb6XhWDlu5EvMpTKX4u/jtgrs/BhM93IqWoZGtsUM9CofV
vYmXEo0y+bjvFZ7YV+vf4KWo5wtPBjb4SdjljZ+TNRoFyc5V6SCDNnld2pKH
QZHIkAtPyVjz5RCDWKzbKfY1gyyGNq4QLp0UHQb4HxfZ4hg=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N1", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N1bar, 
    FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiAi9GEEbgpcW1HEwZwTDTLz1v8PHJzHZdeY6FoslB/rl
6sh7gUZGigrhLUF2Dm8aSGk+4KcZh+wTXpi+SOMV/r3HDKxc8R5k4TVh8I6E
d1KBZ3x9+9FkDvb5a3N496LYihc1rB/jqWr6Gh9TGZso2MUEVfg/jlOZh8d4
tocCLCcPZTR8av11MvC5XRPAt3KyRBEeVialP3C6OzrOoWmU0Clm8X2i8GUz
HPq+bRHAPkGlLIa30vGsHLZyJeYTmErxd/HbBXd/DGb1cCtahka2xg71KBxW
9yZeSjTK5OO+V3hiX61/g5eini88GdjgJ2GXN35G1mgUJDtXpYMM2uR1aUse
BkUiQy48JSPmyyEGEcTNFPuKQRZDG1cIl+6LDgP8Dxjj4j4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N1", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N1bar, \
$CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONkzgiGmXjrf4ePT2Ky68x1LBZLDvTL
1ZG3Ao2MFBXCW4LsHN40kNK8w48zDtkHvDB9kcYr/HsPGVi54j3IwmvC4B0J
76QCT/j69qPJHOzz1+bw7kWxFS9qWD/GU9X0NT6mMjZRsIsJqvB/HKcyD4/x
bPcFWE4eymj41PrrZOBzuyaAb+VkiSI8rExKf+B0d3ScQ9MooVPM4vtE4ctm
OPR92yKAfYJKWQxvpeNZOWzlSswnMJXi7+K3C+7+GMzq4Va0DI1sjR3qUTis
7k08l2iUycd9L/DEvlr/Ci9FPZ94MrDBT8Iub/yMrNEoSHauSgcZtMnr0pY8
DIpEhlx4SkbMl0MMIoibKfYVgyyGNq4QDn8VHQb4HxgE4ic=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N2", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N2bar, 
    FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJCO43tXFg6kAQ974Ps=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N2", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N2bar, 
    FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAOMHtXFg6kARAj4RU=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N2", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N2bar, \
$CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJCWin1XFg6kAQ+E4QY=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N3", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N3bar, 
    FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD2aH1XFg6kARIM4Vw=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N3", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N3bar, 
    FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJD+tOJdWTiQBgAYUeIp
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["N3", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`N3bar, \
$CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGATpEQIS4syMaRLCckQYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYo2BC8tqONgzhSGmXjrf4ePT2qy68w1LBaLAPrF
ytBrgUZGigrhLUFODm/qS2ne4Icph/wdnps8S+MV/p27DKxc8u5l4RVR8IaE
t1KBR3xt68F4Dvb5qzN497zEihfXrR7iqUr6Eh9TGRso2MUEVfg/rlOZh0f4
ttsCTJD7cho+tv46GfjUrgngm7lZ9hc8qEzKfuB0Z3SUS9MooVNM43vE4fNG
OPR53SSEfcJySQJvpONZArbypOYjmEoJtvGbBXdvDGZ18cpahka2+jb1MBxW
dyeeijTK5OO+Z3hsV61/gReing88GVgTJGGXN35CVmkUJNuXZf0MWud3aIse
BkUiAy48JWfPlkIMYrOvJjgXDLIYWngimLj/dhjgfxM94Ys=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL1", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL1bar, 
    FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBLPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONgzhSGmXjrf4ePT2J26C11LBZLDgxL
1eHXIo1MFBXGW0PsPN48kNa+wQ/TTtk7PD91nsErArv3WVi57NvPwavC0C0J
b6eDj/j69sOJPOwP1GbxngWxDS9qWDvCU9XMFT6uMjVRsJsJqfB/HJeyAI/y
7HdFWE4eyGj4xPbrYuAzhzaIb+XkiC94SJmS/sCZ7tgYh6ZRUq+YwfeJIhfN
cPjzpkUA+wWVshjezCRyctjGlViOYSrN38FvFT39cZjVw63oGBrZGzs0I3BE
05t8KtEoW0j4n+HxPY3hBV6MeT/wZHCdn4LdvsQpWaNRiOxckaoZtMHr0pW8
DIpGB914SkbMlcMMIojrSfYlg6zGNq4QVpe/nUb4HxSu4b4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL1", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL1bar, 
    FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3SxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC5F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONgzkSGmXjrf4ePT2p26C11LBZLAQxL
1eHXIo1MFBXGW0PsPN7cn9a+wQ/TTvk7PD91nsErA7v3WVi17NvPwaui0C0J
b6eDj/h64eFEHvYHarN4z4LEhhc3rB3hqWrmCh9Xm5oo2M2E1Pg/jktVgEd5
9rsirCAP5DR8Yvt1MfCZQxvEt3JyxBc8pErJfuBMV2yMQ9MoqVfO4HvFkYtm
OPx50yKA/YJKWQJvZhI5BWzjSi3HMJXm7+C3ip6+OMzq5lZ0DI3sje2aETii
6Uk+lWiULST8z/D4nsbwAi/GvB94MrjOT8FuX+KUrNEoRHasyAYYtMHr1JW8
DIpGB914Sk7MlcMMIojrSfYlg6zGNq4Izgu/nUb4HxQG4Y4=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL1", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL1bar, \
$CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBWc3xfFg6kAQ8m4Pc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL2", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL2bar, 
    FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDmy3hfFg6kAQ934QY=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL2", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL2bar, 
    FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJDuan9fFg6kARQw4aE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL2", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL2bar, \
$CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLAKDlC6F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONgzkSGmXjrf4ePT2Ky68x1LBZLDvTL
1ZHXIo2MFBXGW0LsPN40kNa8wQ8zDtk7vDB9nsErArv3WVi54tvPwWvC0C0J
b6eDj/j69sPJPOwP1ObwnkWxFS9qWD/CU9XMFT6uMjZRsIsJqfB/HKeyAI/x
bHdFWE4eyGj4xPrrZOAzuyaIb+XkiC94WJmS/sCZ7tg4h6ZRUqeYxfeJIhfN
cPjzpkUA+wWVshh2ZxI5OWzlSszHMJXm7+C3ip7+OMzq4Va0DI1sjR3qUTii
7k0+lWiULST8z/DEnlr/Ai/FvB94MrjBT8EuX+KUrNEoRHauSgcZtMnr0pa8
DIpGh1x4SkbMl8MMIojrKfYlgyyGNq4Qdvu/HQb4HxSj4bI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL3", "\<\"-\"\>"], ",", "e"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL3bar, 
    FeynRules`e}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJBevvF9WTiQBgAWPuHo
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL3", "\<\"-\"\>"], ",", "mu"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL3bar, 
    FeynRules`mu}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3MxJAuJSQSYpBpPciCtoMYgtEhQRAtLIKClC5F
YKREGwRC4a1FMUGwiA56MYo2BC8tqONgzkSGmXjrf4ePT2p26C01LBZLAQwL
lcHXAo1MFBXCW4PsHN7cm9K+wQ+TS/J3eHbiLI1X+nfuMrBq0buXhVdEwRsS
3koFHvG1LQdjOdjnr07j3XMSG15ct3qIpyrpS3xMbWqgYBcTVOP/OE5VHh7m
2W8LsILcl9Pwse3XycCnDm0A38zJEl/wgCop+4HTHdERDk2jhF45he8Wh88b
4dDndZMA9gnKJQm8kY5nFbCNK7UcwVSKv43fLLh7YjCrk1vWMTSy17dqhuCw
pivxVKRRJh/3PcOjuxrDCzwf9XzgycAaPwm7vPETskqjINm2LOtj0DqvXVf0
MCgS6XfhKTkxUwoxiCCuxtkXDLIahVwRLLz/XjLC/xKD4XQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Quantum number \"\>", "\[InvisibleSpace]", "LeptonNumber", 
   "\[InvisibleSpace]", "\<\" not conserved in vertex \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"GP", ",", 
     OverscriptBox["nL3", "\<\"-\"\>"], ",", "ta"}], "}"}], 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Quantum number ", $CellContext`LeptonNumber, 
   " not conserved in vertex ", {$CellContext`GP, $CellContext`nL3bar, \
$CellContext`ta}, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLIKCFC9F
YKREGwRC4a1FMUGwiA56MYI2BC8tqONgzlSGmXjrf4ePT2Ky68w1LBZLDvSL
laGXAo2MFBXCW4LsHN7Ul9K8wvdTy7I3eG7yLI1X+HfuMrByybuXhVeFwRsS
3koFHvC1rQfjOdjnr87g3fNiK15U5zrEU5X0JT6mMjZQsJMJqvB/HIcyD4/w
bLcFWE7uy2j42PrrYOBTuyaAb+ZkiU94UJmU/sDpzugoh6ZRQqeYxveIwueN
cOjjukkA+wTlkhjeSMezctjKlZiPYCrF38ZvFty9MZjVxS1rGRrZ6tvUw3BY
3Z14LNIok4/7nuCxXbX+GV6Iet7xZGCNn4Sd3vgJWaVRkGxfkfYzaJ3XoS16
GBSJDDjxlIyYLYUYRBBXE+wLBlkMLVwh7Pr6XjbA/xah4fw=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAOBpQEqEsLQoE0O6lJBIiEGm9SAL2g5iCEaHBEG0sAgMUroU
gZESbRAIhbcWxQTBIjroxQjaELy0oI6DORMYZuKt/x0+PqnZobfUEQShAIbl
6shbkUEmmg7jrSFOHm8eSGvf4ccZp/wDXpi+yOCVgb2HLKxa8R3k4DVR6I6C
d9LBJ3x9+9FkHvYHanN4z6LEhhc3rB/j6WrmGh9Xm5po2M2G1Pg/rktVgMf4
9vsirKAO5Qx8avt1sfC5QxvEt3Jz5Dc8rErJfuBMd2ycyzAoqVfO4vvEkctm
OPx12yKE/cJKWQJvZRI5BWzjSS0nMJ0W7OK3i57+OEz08Co6lkH2xg7NKBzR
9CafSwzKFhL+F3hiX2N4hZdi3k88FdwQpGC3L3FG1RgUojpXZYMs2uR36Upe
FkWjQ248LSfny2EWkeTNFOeKRVZjG08EZ8mS0wj/AxNT4XU=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{27., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "186"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 186],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJAW0P5QFg6kAQ3i4Mw=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "252.53902999999999678948370274156332015991`8.422928421293541", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Squared matrix elent compute in ", 
   252.53902999999999678948370274156332015991`8.422928421293541, " seconds."],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB+FeW7OBxIAwATCuFf
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{27., {1., 10.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "277"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 277],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJC+kda8OBxIAwAUEuGP
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "352.64038900000002740853233262896537780762`8.567931965188743", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Decay widths computed in ", 
   352.64038900000002740853233262896537780762`8.567931965188743, " seconds."],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB2cbK9GA6kAQ244L8=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJCOz7G9GA6kAQ+24QQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwVxT1IAmEYAGATpEQIS4syMaSlhERCDDKtD7Kgv0EMwWhIEEILi6AgpaUI
jJToDwKhcMvyMEGwiAZdjKAyBJd+OD0P8y4wzMSt9xseHrnVabTVcTgcFTCt
VEfeigyy0HQYv0Dw8njrQEb/Dj/NrCk/4MXpSxKvDhw8ZmHNqu8oB29IiHsK
3suEnvH17SeTedgfqM3hPUsyO17asHmKp6vkDT6utTTRsJsltPg/vktTgMeE
jocirKKOlQx8bv91sXDQqQ/hW/k57jc8rEkrfmCyOzbOZxiUNKpn8X3SyFUz
HP66axHDfnGlLIN3yEROBdsFctsZTGdE+/jdoqc/DnN6BBUDyyBHY4duFI7o
epMvJQZlCwl/Cp441Jle4eWY9xNPhbZEadjtS1xQNQYRVOe6YpBF28IuQ8nL
omh0yI2nldz5cphFXO7tFO+aRQvmNoEEDsadKTP8DxWU4dc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJB24624GA6kAQ234Mc=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{27., {1., 10.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "486", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 486, " ."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxTtIQlEYAGATpEQIS4syMaSlhERCDDKtA1lgj0EMwWhIEEQLi6AgpaUI
jJToBYFQuPVQTBAsokEXI+ghgosVV68X897AMBO3/jN8fFKL02BtYLFYCmBc
qY1lSzQyU1QYbwtxCnjLUEb7Dj/Prsk/4MWZKwKvDBw85WDVqu8oD2+IQg8k
vJcJvuAbO0+mCrA/UJ/He5Ykdry4afMUT9WIW3xcbW6hYDcTUuP/uC5VEZ7g
Ox5LsII8ltPwuf3XxcCXTm0Q387Ns7/hUVVa9gMTvTE9l6ZR0qCcww+II9et
cPjrvk0I+4XVigTeIRJ5BWznSa1nMJUR7ON3S57BOMzq41V1DI0czV2acTii
6U++lmmUKyb8b/DkocaYgpdj3k88GdwSpGG3L3FB1mkUIrvXZcMM2ub36Mpe
BkWjI248JWcvVMIMYrPvpjk3DLKZOngiWJ+Vp0zwPxHJ4VE=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOKQwu8ud169dox69mwDiM5Yx/oURCdZXbe7C6TPhZbp
3QPSOX6rH4Jok0WTTj8C0mbFfVMeA+kqqXX7ngDpnutrz4NodslpPk+B9JxF
P2NBdGeuXBaIluGomwmin31/uBNEH7KOEnwGpGverLMG0d84q81eAGl3geyT
r4C0wZOpeq+B9IKsL9VvgPSqfLu1IFqM8zHTWyDtYHZF6yOQfqixw4vz9WvH
E0Em0SDaSGbTGiEgveHlHlERID1H5OtnOSDd9vDwYwMgncWtmDofSD+7LjwB
RHe96jQ/BKQZNLm/ur557ZjNJ23rBqQ32eqeuPDhteOjF4fnXATS3pNtQy4B
6YIdvfdB9JO1zcJXgHRN3+GVT36+dlz3RL5cy+aNY4uAsuuH3jeOW7fa14Do
Z3pMiZ83vHFkYtrly7rxjWNGuAS3FJA2s026FA6kAQ4I4NI=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVxUlIAlEYAGAbkBIhLC3KxJAuJSQSYpBpPciCtoMYgtEhQRAtLIKClC5F
YKSELRAIhbcWxQTBIjroxQjaELy0MDoO5kxgmIm3/nf4+GQWp8Fax+FwlMC4
XB15KzLITNMRvC3MzeMtAxndO/w4s6r4gBemL0i8Kuh/yMLqFd9BDl4Xh+8o
eDcTesLXtx9N5uFAsDaH9yxK7XhJw8Yxnq6S1/iExtxEw242rMH/8VzqAjwm
cNwXYSV1qGDgU/uvi4XPnboQvpWXI77hYXVa/gOT3fFxHsOglEE1i++TRC+b
4cjXbYsIDogqZSm8TSZzStjOl1lPYDoj3MPvFD39CZjTw6/oWQY5Gju0o3BU
25t6LjEoW0gGXuCJfa3xFV6Kez/xVGhTmIbdvuQZVWNQmOpckw+yaEvQpS95
WRSLDbnxtIKYL0dYRBA3U9wrFtlMbXwx7CfItAn+BxJP4XQ=
  "],
 ExpressionUUID -> "9e0fa9be-2f5e-492d-82b4-7bb65ea424db"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440, 801},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
TaggingRules->Association["TryRealOnly" -> False],
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 20, \
2012)",
StyleDefinitions->"Default.nb",
ExpressionUUID -> "ff1ee7b6-5a86-4e8f-acea-9117667c38f7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 251, 4, 35, "Input"],
Cell[799, 26, 99, 1, 4, "PageBreak",
 PageBreakBelow->True],
Cell[CellGroupData[{
Cell[923, 31, 568, 11, 57, "Input"],
Cell[1494, 44, 2481, 35, 36, "Output"],
Cell[CellGroupData[{
Cell[4000, 83, 596, 8, 26, "Print"],
Cell[4599, 93, 877, 15, 26, "Print"],
Cell[5479, 110, 648, 9, 26, "Print"],
Cell[6130, 121, 580, 8, 26, "Print"],
Cell[6713, 131, 591, 8, 26, "Print"],
Cell[7307, 141, 643, 9, 26, "Print"],
Cell[7953, 152, 642, 9, 26, "Print"],
Cell[8598, 163, 582, 8, 26, "Print"],
Cell[9183, 173, 610, 8, 26, "Print"],
Cell[9796, 183, 580, 8, 26, "Print"],
Cell[10379, 193, 649, 9, 26, "Print"]
}, Open  ]]
}, Open  ]],
Cell[11055, 206, 522, 10, 36, "Input"],
Cell[CellGroupData[{
Cell[11602, 220, 241, 4, 114, "Title"],
Cell[11846, 226, 185, 3, 37, "Text"],
Cell[CellGroupData[{
Cell[12056, 233, 2088, 29, 35, "Input"],
Cell[CellGroupData[{
Cell[14169, 266, 621, 8, 26, "Print"],
Cell[14793, 276, 594, 8, 26, "Print"],
Cell[15390, 286, 592, 8, 26, "Print"],
Cell[15985, 296, 731, 12, 26, "Print"],
Cell[16719, 310, 612, 8, 26, "Print"],
Cell[17334, 320, 629, 9, 26, "Print"],
Cell[17966, 331, 581, 8, 26, "Print"],
Cell[18550, 341, 613, 8, 26, "Print"],
Cell[19166, 351, 616, 8, 26, "Print"],
Cell[19785, 361, 611, 8, 26, "Print"],
Cell[20399, 371, 784, 13, 46, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21232, 390, 176, 3, 100, "Section"],
Cell[21411, 395, 230, 6, 37, "Text"],
Cell[21644, 403, 208, 4, 36, "Input"],
Cell[CellGroupData[{
Cell[21877, 411, 136, 3, 54, "Subsection"],
Cell[CellGroupData[{
Cell[22038, 418, 324, 6, 36, "Input"],
Cell[CellGroupData[{
Cell[22387, 428, 407, 10, 26, "Print"],
Cell[22797, 440, 164, 2, 26, "Print"],
Cell[22964, 444, 346, 7, 26, "Print"],
Cell[23313, 453, 197, 3, 26, "Print"],
Cell[23513, 458, 682, 14, 26, "Print"],
Cell[24198, 474, 277, 6, 26, "Print"]
}, Open  ]],
Cell[24490, 483, 186411, 5079, 6652, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210950, 5568, 90, 0, 54, "Subsection"],
Cell[CellGroupData[{
Cell[211065, 5572, 167, 3, 36, "Input"],
Cell[CellGroupData[{
Cell[211257, 5579, 477, 11, 26, "Print"],
Cell[211737, 5592, 230, 3, 26, "Print"],
Cell[211970, 5597, 412, 8, 26, "Print"],
Cell[212385, 5607, 263, 4, 26, "Print"],
Cell[212651, 5613, 745, 15, 26, "Print"]
}, Open  ]],
Cell[213411, 5631, 381, 9, 28, "Message"],
Cell[213795, 5642, 650, 15, 26, "Print"],
Cell[214448, 5659, 381, 9, 28, "Message"],
Cell[214832, 5670, 650, 15, 26, "Print"],
Cell[215485, 5687, 383, 9, 28, "Message"],
Cell[215871, 5698, 663, 13, 29, "Message"],
Cell[CellGroupData[{
Cell[216559, 5715, 731, 17, 42, "Print"],
Cell[217293, 5734, 731, 17, 42, "Print"],
Cell[218027, 5753, 345, 7, 26, "Print"]
}, Open  ]],
Cell[218387, 5763, 110390, 3066, 3248, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328814, 8834, 196, 3, 36, "Input"],
Cell[CellGroupData[{
Cell[329035, 8841, 454, 11, 26, "Print"],
Cell[329492, 8854, 211, 3, 26, "Print"],
Cell[329706, 8859, 242, 4, 26, "Print"],
Cell[329951, 8865, 725, 15, 26, "Print"]
}, Open  ]],
Cell[330691, 8883, 359, 9, 28, "Message"],
Cell[331053, 8894, 710, 17, 42, "Print"],
Cell[331766, 8913, 361, 9, 28, "Message"],
Cell[332130, 8924, 710, 17, 42, "Print"],
Cell[332843, 8943, 359, 9, 28, "Message"],
Cell[333205, 8954, 639, 13, 29, "Message"],
Cell[CellGroupData[{
Cell[333869, 8971, 635, 15, 26, "Print"],
Cell[334507, 8988, 635, 15, 26, "Print"],
Cell[335145, 9005, 324, 7, 26, "Print"]
}, Open  ]],
Cell[335484, 9015, 25924, 794, 917, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[361445, 9814, 482, 8, 36, "Input"],
Cell[CellGroupData[{
Cell[361952, 9826, 574, 13, 26, "Print"],
Cell[362529, 9841, 330, 5, 26, "Print"],
Cell[362862, 9848, 365, 6, 26, "Print"],
Cell[363230, 9856, 840, 17, 26, "Print"],
Cell[364073, 9875, 445, 9, 26, "Print"]
}, Open  ]],
Cell[364533, 9887, 17840, 505, 549, "Output"]
}, Open  ]],
Cell[382388, 10395, 207, 4, 36, "Input"],
Cell[CellGroupData[{
Cell[382620, 10403, 265, 5, 36, "Input"],
Cell[CellGroupData[{
Cell[382910, 10412, 528, 12, 26, "Print"],
Cell[383441, 10426, 283, 4, 26, "Print"],
Cell[383727, 10432, 467, 9, 26, "Print"],
Cell[384197, 10443, 316, 5, 26, "Print"],
Cell[384516, 10450, 800, 16, 26, "Print"]
}, Open  ]],
Cell[385331, 10469, 251, 7, 28, "Message"],
Cell[385585, 10478, 709, 16, 26, "Print"],
Cell[386297, 10496, 251, 7, 28, "Message"],
Cell[386551, 10505, 709, 16, 26, "Print"],
Cell[387263, 10523, 251, 7, 28, "Message"],
Cell[387517, 10532, 531, 11, 29, "Message"],
Cell[CellGroupData[{
Cell[388073, 10547, 784, 18, 42, "Print"],
Cell[388860, 10567, 784, 18, 42, "Print"],
Cell[389647, 10587, 398, 8, 26, "Print"]
}, Open  ]],
Cell[390060, 10598, 86182, 2497, 3473, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[476303, 13102, 228, 5, 100, "Section"],
Cell[CellGroupData[{
Cell[476556, 13111, 158, 3, 54, "Subsection"],
Cell[476717, 13116, 464, 8, 37, "Text"],
Cell[CellGroupData[{
Cell[477206, 13128, 683, 14, 57, "Input"],
Cell[CellGroupData[{
Cell[477914, 13146, 661, 12, 26, "Print"],
Cell[478578, 13160, 884, 19, 26, "Print"],
Cell[479465, 13181, 639, 11, 26, "Print"],
Cell[480107, 13194, 821, 16, 26, "Print"],
Cell[480931, 13212, 672, 12, 26, "Print"],
Cell[481606, 13226, 1154, 23, 26, "Print"],
Cell[482763, 13251, 754, 15, 26, "Print"],
Cell[483520, 13268, 884, 19, 26, "Print"],
Cell[484407, 13289, 639, 11, 26, "Print"],
Cell[485049, 13302, 821, 16, 26, "Print"],
Cell[485873, 13320, 672, 12, 26, "Print"],
Cell[486548, 13334, 1158, 23, 26, "Print"],
Cell[487709, 13359, 756, 15, 26, "Print"],
Cell[488468, 13376, 884, 19, 26, "Print"],
Cell[489355, 13397, 639, 11, 26, "Print"],
Cell[489997, 13410, 821, 16, 26, "Print"],
Cell[490821, 13428, 672, 12, 26, "Print"],
Cell[491496, 13442, 1154, 23, 26, "Print"],
Cell[492653, 13467, 754, 15, 26, "Print"],
Cell[493410, 13484, 884, 19, 26, "Print"],
Cell[494297, 13505, 639, 11, 26, "Print"],
Cell[494939, 13518, 672, 12, 26, "Print"],
Cell[495614, 13532, 1154, 23, 26, "Print"],
Cell[496771, 13557, 754, 15, 26, "Print"],
Cell[497528, 13574, 884, 19, 26, "Print"],
Cell[498415, 13595, 639, 11, 26, "Print"],
Cell[499057, 13608, 821, 16, 26, "Print"],
Cell[499881, 13626, 672, 12, 26, "Print"],
Cell[500556, 13640, 1154, 23, 26, "Print"],
Cell[501713, 13665, 754, 15, 26, "Print"],
Cell[502470, 13682, 884, 19, 26, "Print"],
Cell[503357, 13703, 639, 11, 26, "Print"],
Cell[503999, 13716, 821, 16, 26, "Print"],
Cell[504823, 13734, 672, 12, 26, "Print"],
Cell[505498, 13748, 1154, 23, 26, "Print"],
Cell[506655, 13773, 754, 15, 26, "Print"],
Cell[507412, 13790, 1111, 22, 26, "Print"],
Cell[508526, 13814, 653, 11, 26, "Print"]
}, Open  ]],
Cell[509194, 13828, 1089, 19, 28, "Message"],
Cell[510286, 13849, 1092, 23, 42, "Print"],
Cell[511381, 13874, 1089, 19, 28, "Message"],
Cell[512473, 13895, 1094, 23, 42, "Print"],
Cell[513570, 13920, 1091, 19, 28, "Message"],
Cell[514664, 13941, 1371, 23, 29, "Message"],
Cell[CellGroupData[{
Cell[516060, 13968, 1097, 23, 42, "Print"],
Cell[517160, 13993, 1092, 23, 42, "Print"],
Cell[518255, 14018, 1094, 23, 42, "Print"],
Cell[519352, 14043, 1097, 23, 42, "Print"],
Cell[520452, 14068, 1092, 23, 42, "Print"],
Cell[521547, 14093, 1094, 23, 42, "Print"],
Cell[522644, 14118, 1097, 23, 42, "Print"],
Cell[523744, 14143, 1094, 23, 42, "Print"],
Cell[524841, 14168, 1096, 23, 42, "Print"],
Cell[525940, 14193, 1099, 23, 42, "Print"],
Cell[527042, 14218, 1094, 23, 42, "Print"],
Cell[528139, 14243, 1096, 23, 42, "Print"],
Cell[529238, 14268, 1099, 23, 42, "Print"],
Cell[530340, 14293, 1094, 23, 42, "Print"],
Cell[531437, 14318, 1096, 23, 42, "Print"],
Cell[532536, 14343, 1099, 23, 42, "Print"],
Cell[533638, 14368, 1138, 25, 39, "Print"],
Cell[534779, 14395, 1138, 25, 39, "Print"],
Cell[535920, 14422, 1138, 25, 39, "Print"],
Cell[537061, 14449, 1140, 25, 39, "Print"],
Cell[538204, 14476, 1140, 25, 39, "Print"],
Cell[539347, 14503, 1140, 25, 39, "Print"],
Cell[540490, 14530, 1140, 25, 41, "Print"],
Cell[541633, 14557, 1140, 25, 41, "Print"],
Cell[542776, 14584, 1140, 25, 41, "Print"],
Cell[543919, 14611, 1140, 25, 39, "Print"],
Cell[545062, 14638, 1140, 25, 39, "Print"],
Cell[546205, 14665, 1140, 25, 39, "Print"],
Cell[547348, 14692, 1142, 25, 39, "Print"],
Cell[548493, 14719, 1142, 25, 39, "Print"],
Cell[549638, 14746, 1142, 25, 39, "Print"],
Cell[550783, 14773, 1142, 25, 41, "Print"],
Cell[551928, 14800, 1142, 25, 41, "Print"],
Cell[553073, 14827, 1142, 25, 41, "Print"],
Cell[554218, 14854, 1140, 25, 39, "Print"],
Cell[555361, 14881, 1140, 25, 39, "Print"],
Cell[556504, 14908, 1140, 25, 39, "Print"],
Cell[557647, 14935, 1142, 25, 39, "Print"],
Cell[558792, 14962, 1142, 25, 39, "Print"],
Cell[559937, 14989, 1142, 25, 39, "Print"],
Cell[561082, 15016, 1142, 25, 41, "Print"],
Cell[562227, 15043, 1142, 25, 41, "Print"],
Cell[563372, 15070, 1142, 25, 41, "Print"],
Cell[564517, 15097, 1142, 25, 39, "Print"],
Cell[565662, 15124, 1142, 25, 39, "Print"],
Cell[566807, 15151, 1142, 25, 39, "Print"],
Cell[567952, 15178, 1144, 25, 39, "Print"],
Cell[569099, 15205, 1144, 25, 39, "Print"],
Cell[570246, 15232, 1144, 25, 39, "Print"],
Cell[571393, 15259, 1144, 25, 41, "Print"],
Cell[572540, 15286, 1144, 25, 41, "Print"],
Cell[573687, 15313, 1144, 25, 41, "Print"],
Cell[574834, 15340, 1102, 24, 42, "Print"],
Cell[575939, 15366, 1104, 24, 42, "Print"],
Cell[577046, 15392, 1104, 24, 42, "Print"],
Cell[578153, 15418, 1102, 24, 42, "Print"],
Cell[579258, 15444, 1104, 24, 42, "Print"],
Cell[580365, 15470, 1104, 24, 42, "Print"],
Cell[581472, 15496, 1102, 24, 42, "Print"],
Cell[582577, 15522, 1104, 24, 42, "Print"],
Cell[583684, 15548, 1104, 24, 42, "Print"],
Cell[584791, 15574, 1104, 24, 42, "Print"],
Cell[585898, 15600, 1106, 24, 42, "Print"],
Cell[587007, 15626, 1106, 24, 42, "Print"],
Cell[588116, 15652, 1104, 24, 42, "Print"],
Cell[589223, 15678, 1106, 24, 42, "Print"],
Cell[590332, 15704, 1106, 24, 42, "Print"],
Cell[591441, 15730, 1104, 24, 42, "Print"],
Cell[592548, 15756, 1106, 24, 42, "Print"],
Cell[593657, 15782, 1106, 24, 42, "Print"],
Cell[594766, 15808, 920, 20, 26, "Print"],
Cell[595689, 15830, 877, 19, 26, "Print"],
Cell[596569, 15851, 969, 20, 26, "Print"],
Cell[597541, 15873, 877, 19, 26, "Print"],
Cell[598421, 15894, 955, 20, 26, "Print"],
Cell[599379, 15916, 636, 11, 26, "Print"],
Cell[600018, 15929, 660, 12, 26, "Print"],
Cell[600681, 15943, 851, 16, 26, "Print"],
Cell[601535, 15961, 1011, 19, 26, "Print"],
Cell[602549, 15982, 632, 11, 26, "Print"],
Cell[603184, 15995, 617, 11, 26, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

