(***************************************************************************************************************)
(******                       This is the FeynRules mod-file for the generic U(1)_X model                 ******)
(***************************************************************************************************************)
(****** Contains three massive Majorana neutrinos and a scalar. All the SM particles and new scalar are ********)
(*****  charged under the new gauge U(1)X. Heavy neutrino masses MNi and mixing parameters VlNi between ********)
(****  heavy mass eigenstate and flavour eigenstates are considered as independent parameter.           ********)
(***************************************************************************************************************)
(****** Contact Authors: Sanjoy Mandal, Arindam Das                                                       ******)
(***************************************************************************************************************)                                                                                                   
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "U1XGeneric";

M$Information = {
  Authors      -> {"Sanjoy Mandal", "Arindam Das"}, 
  Version      -> "1.1.0",
  Date         -> "28. 01. 2022",
  Institutions -> {"Korea Institute of Advanced Study, Seoul 02455”, "Hokkaido University, Sapporo 060-0817, Japan"},
  Emails       -> {"mandal.sanjoy10@gmail.com", "dasarindamphysics@gmail.com"},
  URLs         -> "http://feynrules.phys.ucl.ac.be"
};

FeynmanGauge = True;

(* ************************** *)
(* ***** NLO Variables ****** *)
(******************************)

FR$LoopSwitches = {{Gf, MW}};
FR$RmDblExt = { ymb -> MB, ymc -> MC, ymdo -> MD, yme -> Me, 
   ymm -> MMU, yms -> MS, ymt -> MT, ymtau -> MTA, ymup -> MU};


(* ************************** *)
(* *****      vevs      ***** *)
(* ************************** *)
M$vevs = { {Phi[2],vev} };

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1BL == {
        Abelian -> True,
        GaugeBoson -> Bp,
        Charge -> BL,
        CouplingConstant -> g1p},
  
  U1Y  == { 
    Abelian          -> True,  
    CouplingConstant -> g1, 
    GaugeBoson       -> B, 
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> G,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};


(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {QED, 2}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW, 80.379},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "G",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },
V[5] == {
        ClassName -> Zp,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MZp, 3000},
        Width -> {WZp, 1.0},
	PropagatorLabel -> "Zp",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        PDG -> 9900032,
        FullName -> "Zp" },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZ,91.1876},  
    Width	    -> {WZ, 2.4952},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MW,80.379}, 
    Width           -> {WW, 2.085}, 
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[32] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MW,80.379}, 
    Width           -> {WW, 2.085},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[4] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    PDG             -> 82,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[5] == {
       ClassName -> ghZp,
       SelfConjugate -> False,
       Indices -> {},
       Mass -> {MZp, 3000},
       Width -> {WZp, 1.0},
       Ghost -> Zp,
       QuantumNumbers -> {GhostNumber -> 1},
       PropagatorLabel -> uZp,
       PropagatorType -> GhostDash,
       PropagatorArrow -> Forward},


(* Gauge bosons: unphysical vector fields *)
  V[11] == { 
    ClassName     -> B, 
    Unphysical    -> True, 
    SelfConjugate -> True, 
    Definitions   -> { B[mu_] -> cw A[mu] - sw*Cp Z[mu] + sw*Sp Zp[mu]} 
  },
  V[12] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { Wi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2], Wi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]), Wi[mu_,3] -> sw A[mu] + cw*Cp Z[mu] - cw*Sp Zp[mu]}
  },
 V[13] == {
        ClassName -> Bp,
	SelfConjugate -> True,
        Definitions -> {Bp[mu_] ->  Sp Z[mu] + Cp Zp[mu]},
	Indices -> {},
        Unphysical -> True},

(* Ghosts: related to unphysical gauge bosons *)
  U[11] == {
    ClassName     -> ghB, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B, 
    Definitions   -> { ghB -> -sw*Cp ghZ + cw ghA + sw*Sp ghZp }
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[3] -> cw*Cp ghZ + sw ghA - cw*Sp ghZp }
  } ,
  U[13] == {
        ClassName -> ghBp,
	SelfConjugate -> False,
        Definitions -> {ghBp -> Sp ghZ + Cp ghZp },
	Indices -> {},
        Unphysical -> True,
	Ghost -> Bp},

(* Fermions: physical fields *)
 F[1] == {
    ClassName        -> nL,
    ClassMembers     -> {nL1,nL2,nL3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True,
    QuantumNumbers   -> {},
    Mass             -> {MnL,{MnL1, 0},{MnL2, 0},{MnL3, 0}},
    Width            -> 0,
    PropagatorLabel  -> {"nL", "nul1", "nul2", "nul3"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {1200,1400,1600},
    ParticleName     -> {"v1","v2","v3"},
    FullName         -> {"Light neutrino 1", "Light neutrino 2", "Light neutrino 3"}
  },
  F[16] == {
    ClassName        -> nH,
    ClassMembers     -> {N1, N2, N3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True,
    QuantumNumbers   -> {},
    Mass             -> {MnH,{MN1, 200.00},{MN2, 400.00},{MN3, 600.00}},
    Width            -> {{WN1,1},{WN2,1},{WN3,1}},
    PropagatorLabel  -> {"nH","nuh1","nuh2","nuh3"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {9910012, 9910014, 9910016},
    ParticleName     -> {"N1","N2","N3"},
    FullName         -> {"Heavy neutrino 1", "Heavy neutrino 2", "Heavy neutrino 3"}
  },
   (* unphysical *)
  F[17] == {
    ClassName        -> nuF,
    ClassMembers     -> {nuF1,nuF2,nuF3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True, 
    Unphysical       -> True,
    Definitions      -> {nuF[sp_,ff_] -> Module[{ff2}, UPMNS[ff,ff2] nL[sp,ff2] + Sm[ff,ff2]  nH[sp,ff2]]}
  },
   (* unphysical *)
  F[18] == {
    ClassName        -> nuH,
    ClassMembers     -> {nuH1,nuH2,nuH3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True, 
    Unphysical       -> True,
    Definitions      -> {nuH[sp_,ff_] -> Module[{ff2}, Conjugate[Tm[ff,ff2]] nL[sp,ff2] + Conjugate[VV[ff,ff2]] nH[sp,ff2]]}
  },
  
   F[19] == {
    ClassName        -> nuHp,
    ClassMembers     -> {nuHp1,nuHp2,nuHp3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True, 
    Unphysical       -> True,
    Definitions      -> {nuHp[sp_,ff_] -> Module[{ff2}, Tm[ff,ff2] nL[sp,ff2] + VV[ff,ff2] nH[sp,ff2]]}
  },

  (* Flavour-eigenstate neutrino: unphysical *)    
  (* Righthanded flavor neutrino: unphysical *)
  F[20] == {
    ClassName        -> NR,
    Unphysical       -> True,
    Indices          -> {Index[Generation]},
    QuantumNumbers  -> {Y -> 0, BL -> -xPhi},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Definitions      -> { NR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] nuH[sp2,ff]]}
  },

 F[21] == {
    ClassName        -> NRc,
    Unphysical       -> True,
    Indices          -> {Index[Generation]},
    QuantumNumbers  -> {Y -> 0, BL -> xPhi},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Definitions      -> { NRc[sp1_,ff_] :> Module[{sp2}, ProjM[sp1,sp2] nuHp[sp2,ff]]}
  },

  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}},
    Width            -> 0,
    QuantumNumbers -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
  F[3] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mu, {MU, 2.55*^-3}, {MC,1.27}, {MT,172}},
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
  F[4] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Md, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}},
    Width            -> 0,
    QuantumNumbers -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* Fermions: unphysical fields *)
  F[11] == { 
    ClassName      -> LL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2, BL -> -(1/2)*xH-xPhi },
    Definitions    -> { LL[sp1_,1,ff_] :> Module[{sp2}, ProjM[sp1,sp2] nuF[sp2,ff]], LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]] }
  },
  
  F[12] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1, BL -> -xH-xPhi},
    Definitions    -> { lR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }
  },
  F[13] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6, BL -> (1/6)*xH+(1/3)*xPhi},
    Definitions    -> { 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] uq[sp2,ff,cc]], 
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKM[ff,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]] }
  },
  F[14] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3, BL -> (2/3)*xH+(1/3)*xPhi},
    Definitions    -> { uR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] uq[sp2,ff,cc]] }
  },
  F[15] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3, BL -> -(1/3)*xH+(1/3)*xPhi},
    Definitions    -> { dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }
  },

 

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> H1,
    SelfConjugate   -> True,
    Mass            -> {MH1,125.18},
    Width           -> {WH1,0.00407},
    PropagatorLabel -> "H1",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "H1",
    FullName        -> "H1"
  },

(* Higgs: physical scalars  *)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    PropagatorLabel -> "Go",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MW, 80.379},
    QuantumNumbers   -> {Q -> 1},
    Width            -> {WW, 2.085},
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },
  S[4] == {
        ClassName -> H2,
	SelfConjugate -> True,
	Mass -> {MH2, 450}, 
        Width -> {WH2, 1.0},
	PropagatorLabel -> "H2",
	PropagatorType -> D,
	PropagatorArrow -> None,
        PDG -> 9900035,
        FullName -> "H2" },
  S[5] == {
        ClassName -> phiZp,
	SelfConjugate -> True,
	Mass -> {MZp, 3000},
        Width -> {WZp, 1.0},
	PropagatorLabel -> "phiZp",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"phiZp",
        PDG -> 9900252,
        FullName -> "PhiZp",
        Goldstone -> Zp },

  S[6] == {
        ClassName -> GZ,
	Unphysical -> True,
        Definitions -> {GZ -> cg G0 - sg phiZp},
	SelfConjugate -> True},

  S[7] == {
        ClassName -> GZp,
	Unphysical -> True,
        Definitions -> {GZp -> sg G0 + cg phiZp},
	SelfConjugate -> True},

(* Higgs: unphysical scalars  *)
  S[11] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2, BL -> xH/2},
    Definitions    -> { Phi[1] -> -I GP, Phi[2] -> (vev + Ca*H1+Sa*H2  + I GZ)/Sqrt[2]  }
  },
  S[12] == { 
    ClassName      -> Chi, 
    Unphysical     -> True, 
    Indices        -> {},
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 0, BL -> 2*xPhi},
    Definitions    -> { Chi -> (x -Sa*H1+Ca*H2 + I GZp)/Sqrt[2]  }
  }
};


(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ V[5] ] = GaugeXi[Zp];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = GaugeXi[Z];
GaugeXi[ S[3]  ] = GaugeXi[W];
GaugeXi[ S[4] ] = 1;
GaugeXi[ S[5] ] = GaugeXi[Zp];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4]  ] = GaugeXi[G];
GaugeXi[ U[5] ] = GaugeXi[Zp];


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)
  aEWM1 == { 
    ParameterType    -> External, 
    BlockName        -> SMINPUTS, 
    OrderBlock       -> 1, 
    Value            -> 127.9,
    InteractionOrder -> {QED,-2},
    Description      -> "Inverse of the EW coupling constant at the Z pole"
  },
  Gf == {
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 2,
    Value            -> 1.16637*^-5, 
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[G,f],
    Description      -> "Fermi constant"
  },
  aS    == { 
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 3,
    Value            -> 0.1184, 
    InteractionOrder -> {QCD,2},
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "Strong coupling constant at the Z pole"
  },

  
  xH == {
        ParameterType -> External,
        BlockName -> BLINPUTS,
        Value -> 1,
        Description -> "xH parameter"},

  xPhi == {
        ParameterType -> External,
        BlockName -> BLINPUTS,
        Value -> 1,
        Description -> "xPhi parameter"},


  g1p == {
        ParameterType -> External,
        BlockName -> BLINPUTS,
	InteractionOrder -> {QED, 1},
        Value -> 0.2,
        Description -> "Zp coupling"},
        
  g1pp == {
        ParameterType -> Internal,
        BlockName -> BLINPUTS,
	InteractionOrder -> {QED, 1},
        Value -> g1p*xPhi,
        Description -> "effective-Zp coupling"},


  gt == {
        ParameterType -> Internal,
        BlockName -> BLINPUTS,
	InteractionOrder -> {QED, 1},
        Value -> g1p*xH,
        Description -> "Z-Zp mixing coupling"},


  Sa == {
        ParameterType -> External,
        BlockName -> BLINPUTS,
	Value -> 0.01,
        Description -> "Sine of Higgses mixing angle"},

  Ca == {
        ParameterType -> Internal,
	Value -> Sqrt[1-Sa^2],
	ParameterName -> Ca,
        Description -> "Cosine of Higgses mixing angle"},

  ymdo == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 1,
    Value         -> 5.04*^-3,
    Description   -> "Down Yukawa mass"
  },
  ymup == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 2,
    Value         -> 2.55*^-3,
    Description   -> "Up Yukawa mass"
  },
  yms == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 3,
    Value         -> 0.101,
    Description   -> "Strange Yukawa mass"
  },
  ymc == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 4,
    Value         -> 1.27,
    Description   -> "Charm Yukawa mass"
  },
  ymb == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 5,
    Value         -> 4.7,
    Description   -> "Bottom Yukawa mass"
  },
  ymt == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 6,
    Value         -> 172,
    Description   -> "Top Yukawa mass"
  },
  yme == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 11,
    Value         -> 5.11*^-4,
    Description   -> "Electron Yukawa mass"
  },
  ymm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 13,
    Value         -> 0.10566,
    Description   -> "Muon Yukawa mass"
  },
  ymtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 15,
    Value         -> 1.777,
    Description   -> "Tau Yukawa mass"
  },
  cabi == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 1,
    Value         -> 0.227736,
    TeX           -> Subscript[\[Theta], c],
    Description   -> "Cabibbo angle"
  },

  (* Internal Parameters *)
  aEW == {
    ParameterType    -> Internal,
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[\[Alpha], EW],
    Description      -> "Electroweak coupling contant"
  },

  sw2 == { 
    ParameterType -> Internal, 
    Value         -> 0.231, 
    Description   -> "Squared Sin of the Weinberg angle"
  },
  ee == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aEW], 
    InteractionOrder -> {QED,1}, 
    TeX              -> e,  
    Description      -> "Electric coupling constant"
  },
  cw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[1-sw2], 
    TeX           -> Subscript[c,w], 
    Description   -> "Cosine of the Weinberg angle"
  },
  sw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[sw2], 
    TeX           -> Subscript[s,w], 
    Description   -> "Sine of the Weinberg angle"
  },
  gw == { 
    ParameterType    -> Internal, 
    Definitions      -> {gw->ee/sw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,w], 
    Description      -> "Weak coupling constant at the Z pole"
  },
  g1 == { 
    ParameterType    -> Internal, 
    Definitions      -> {g1->ee/cw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,1], 
    Description      -> "U(1)Y coupling constant at the Z pole"
  },
  gs == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[g,s], 
    ParameterName    -> G,
    Description      -> "Strong coupling constant at the Z pole"
  },

  vev == {
    ParameterType    -> Internal,
    BlockName        -> VEV,
    Value            -> 2*MW*sw/ee, 
    InteractionOrder -> {QED,-1},
    Description      -> "SM Higgs vacuum expectation value"
  },
  
   x == {
        ParameterType -> Internal,
        BlockName -> VEV,
	Value -> MZp/(2*g1pp)*Sqrt[1-gt^2*vev^2/(4*MZp^2-vev^2*(gw^2+g1^2))],
	InteractionOrder -> {QED, -1},
        Description -> "Non SM Higgs VEV"},


  \[Lambda]1 == {
    ParameterType    -> Internal,
        Value -> MH1^2 /(2*vev^2)*Ca^2 + MH2^2 /(2*vev^2)*Sa^2,
        ParameterName -> lam1,
        InteractionOrder -> {QED, 2},
        Description -> "Lambda 1"},

   \[Lambda]2 == {
        ParameterType -> Internal,
        Value -> MH1^2 /(2*x^2)*Sa^2 + MH2^2 /(2*x^2)*Ca^2,
        ParameterName -> lam2,
        InteractionOrder -> {QED, 2},
        Description -> "Lambda 2"},

   \[Lambda]3 == {
        ParameterType -> Internal,
        Value -> (MH2^2 - MH1^2)/(x*vev)*Sa*Ca,
        ParameterName -> lam3,
        InteractionOrder -> {QED, 2},
        Description -> "Lambda 3, mixing parameter"},

   mu2H1 == {
        ParameterType -> Internal,
	Value ->  \[Lambda]1 * vev^2 + \[Lambda]3 /2 * x^2,
        TeX -> m^2,
        Description -> "Coefficient of the quadratic piece of the H1 potential"},

   mu2H2 == {
        ParameterType -> Internal,
	Value ->  \[Lambda]3 /2 * vev^2 + \[Lambda]2 * x^2,
        TeX -> \[Mu]^2,
        Description -> "Coefficient of the quadratic piece of the H2 potential"},

   Sp2num == {
        ParameterType -> Internal,
        Value -> 2*gt*Sqrt[(ee/sw)^2+(ee/cw)^2]},

   Cp2num == {
        ParameterType -> Internal,
        Value -> gt^2+16*(x/vev)^2*(g1pp)^2-(ee/sw)^2-(ee/cw)^2},

   Sp == {
        ParameterType -> Internal,
        Value -> Sin[ArcSin[Sp2num/Sqrt[Sp2num^2+Cp2num^2]]/2],
        ComplexParameter -> False,
        Description -> "sine mixing Zp-Z"},

   Cp == {
        ParameterType -> Internal,
        Value -> Sqrt[1-Sp^2],
        ComplexParameter -> False,
        Description -> "cosine mixing Zp-Z"},

   Cn == {
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> (ee/sw)^2+(ee/cw)^2+gt^2+16*(x/vev)^2*(g1pp)^2},

   Dn == {
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> 64*((ee/sw)^2+(ee/cw)^2)*(g1pp)^2*vev^2*x^2},
	

(*   MZ == {
        ParameterType -> Internal,
        Value -> Sqrt[(Cn*vev^2-Sqrt[-Dn+vev^4*Cn^2])/8],
        Description -> "Z mass"}, *)

   S2gNum == {
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> 8*x/vev*gt*(g1pp)},

   C2gNum == {
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> (ee/sw)^2+(ee/cw)^2+gt^2-16*(x/vev)^2*(g1pp)^2},    

   
   sg == {
        ParameterType -> Internal,
        ComplexParameter -> False,
        Value -> Sin[ArcSin[-S2gNum/Sqrt[S2gNum^2+C2gNum^2]]/2],
        Description -> "cosine of Z-Zp goldostone mixing angle"},
   cg == {
        ParameterType -> Internal,
        ComplexParameter -> False,
	Value -> Sqrt[1-sg^2],
        Description -> "sine of Z-Zp goldstone mixing angle"},


  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yl[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yl[1,1] -> Sqrt[2] yme / vev, yl[2,2] -> Sqrt[2] ymm / vev, yl[3,3] -> Sqrt[2] ymtau / vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yl[1,1] -> ye, yl[2,2] -> ym, yl[3,3] -> ytau},
    TeX              -> Superscript[y, l],
    Description      -> "Lepton Yukawa couplings"
  },
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yu[1,1] -> Sqrt[2] ymup/vev, yu[2,2] -> Sqrt[2] ymc/vev, yu[3,3] -> Sqrt[2] ymt/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yu[1,1] -> yup, yu[2,2] -> yc, yu[3,3] -> yt},
    TeX              -> Superscript[y, u],
    Description      -> "Up-type Yukawa couplings"
  },
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yd[1,1] -> Sqrt[2] ymdo/vev, yd[2,2] -> Sqrt[2] yms/vev, yd[3,3] -> Sqrt[2] ymb/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yd[1,1] -> ydo, yd[2,2] -> ys, yd[3,3] -> yb},
    TeX              -> Superscript[y, d],
    Description      -> "Down-type Yukawa couplings"
  },
 
(* Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Value         -> {CKM[1,1] -> Cos[cabi],  CKM[1,2] -> Sin[cabi], CKM[1,3] -> 0,
                      CKM[2,1] -> -Sin[cabi], CKM[2,2] -> Cos[cabi], CKM[2,3] -> 0,
                      CKM[3,1] -> 0,          CKM[3,2] -> 0,         CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"},
    
        (* ***** RHN  parameters   ***** *)
    
 VeN1 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 1, 
    Value            -> 0.001,
    ComplexParameter -> False,
    TeX              -> Subscript[V,eN1],
    Description      -> "Mixing between ve flavor/gauge state and N1 mass state"
	},

 VeN2 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 2, 
    Value            -> 0.0,
    ComplexParameter -> False,
    TeX              -> Subscript[V,eN2],
    Description      -> "Mixing between ve flavor/gauge state and N2 mass state"
	},

 VeN3 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 3, 
    Value            -> 0.0,
    ComplexParameter -> False,
    TeX              -> Subscript[V,eN3],
    Description      -> "Mixing between ve flavor/gauge state and N3 mass state"
	},

 VmuN1 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 4, 
    Value            -> 0.0,
    ComplexParameter -> False,
    TeX              -> Subscript[V,muN1],
    Description      -> "Mixing between vm flavor/gauge state and N1 mass state"
	},

 VmuN2 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 5, 
    Value            -> 0.001,
    ComplexParameter -> False,
    TeX              -> Subscript[V,muN2],
    Description      -> "Mixing between vm flavor/gauge state and N2 mass state"
	},

 VmuN3 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 6, 
    Value            -> 0.0,
    ComplexParameter -> False,
    TeX              -> Subscript[V,muN3],
    Description      -> "Mixing between vm flavor/gauge state and N3 mass state"
	},

 VtaN1 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 7, 
    Value            -> 0.0,
    ComplexParameter -> False,
    TeX              -> Subscript[V,taN1],
    Description      -> "Mixing between vt flavor/gauge state and N1 mass state"
	},

 VtaN2 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 8, 
    Value            -> 0.0,
    ComplexParameter -> False,
    TeX              -> Subscript[V,taN2],
    Description      -> "Mixing between vt flavor/gauge state and N2 mass state"
	},

 VtaN3 == {
    ParameterType    -> External, 
    BlockName        -> NUMIXING, 
    OrderBlock       -> 9, 
    Value            -> 0.001,
    ComplexParameter -> False,
    TeX              -> Subscript[V,taN3],
    Description      -> "Mixing between vt flavor/gauge state and N3 mass state"
	},

Sm == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Value         -> {Sm[1,1] -> VeN1,  Sm[1,2] -> VeN2, Sm[1,3] -> VeN3,
                      Sm[2,1] -> VmuN1, Sm[2,2] -> VmuN2, Sm[2,3] -> VmuN3,
                      Sm[3,1] -> VtaN1,          Sm[3,2] -> VtaN2,         Sm[3,3] -> VtaN3},
    TeX         -> Superscript[S,m],
    Description -> "S-Matrix"},
    
    
UPMNS == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Value         -> {UPMNS[1,1] -> 1,  UPMNS[1,2] -> 0, UPMNS[1,3] -> 0,
                      UPMNS[2,1] -> 0, UPMNS[2,2] -> 1, UPMNS[2,3] -> 0,
                      UPMNS[3,1] -> 0,          UPMNS[3,2] -> 0,         UPMNS[3,3] -> 1},
    ComplexParameter -> True,
    ParameterName -> {UPMNS[1,1]->U11, UPMNS[1,2]->U12, UPMNS[1,3]->U13, UPMNS[2,1]->U21, UPMNS[2,2]->U22, UPMNS[2,3]->U23, UPMNS[3,1]->U31, UPMNS[3,2]->U32, UPMNS[3,3]->U33},
    TeX         -> Superscript[U,PMNS],
    Description -> "PMNS-Matrix"},    
        
    
Tm == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Value         -> {Tm[1,1] -> -VeN1,  Tm[1,2] -> -VmuN1, Tm[1,3] -> -VtaN1,
                      Tm[2,1] -> -VeN2,  Tm[2,2] -> -VmuN2, Tm[2,3] -> -VtaN2,
                      Tm[3,1] -> -VeN3,  Tm[3,2] -> -VmuN3, Tm[3,3] -> -VtaN3},
    TeX         -> Superscript[T,m],
    Description -> "T-Matrix"},      
    
    
VV == { 
    ParameterType -> External,
    Indices       -> {Index[Generation], Index[Generation]},
    BlockName        -> VV, 
    Value         -> {VV[1,1] -> 1,  VV[1,2] -> 0, VV[1,3] -> 0,
                      VV[2,1] -> 0, VV[2,2] -> 1, VV[2,3] -> 0,
                      VV[3,1] -> 0,          VV[3,2] -> 0,         VV[3,3] -> 1},
    ComplexParameter -> True,
    TeX         -> Superscript[V,V],
    Description -> "V-Matrix"},   
    
    ynd == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Value         -> {ynd[1,1] -> Sqrt[2] VeN1 MN1/(vev) ,  ynd[1,2] -> 0, ynd[1,3] -> 0,
                      ynd[2,1] ->  0, ynd[2,2] -> Sqrt[2] VmuN2 MN2/(vev), ynd[2,3] -> 0,
                      ynd[3,1] -> 0,          ynd[3,2] -> 0,         ynd[3,3] -> Sqrt[2] VtaN3 MN3/(vev)},
    TeX         -> Superscript[y,nd],
    InteractionOrder -> {QED,1},
    Description -> "ynd-Matrix"},       
 
  ynm == {
     ComplexParameter -> False,
     ParameterType    -> Internal, 
     Indices          -> {Index[Generation], Index[Generation]},
     Value            -> {ynm[1, 1] -> MN1/(Sqrt[2]*x), ynm[1, 2] -> 0.0, ynm[1, 3] -> 0.0,
			   ynm[2, 1] -> 0.0, ynm[2, 2] -> MN2/(Sqrt[2]*x), ynm[2, 3] -> 0.0,
			   ynm[3, 1] -> 0.0, ynm[3, 2] -> 0.0, ynm[3, 3] -> MN3/(Sqrt[2]*x) },
     InteractionOrder -> {QED,1},
     Description      -> "Majorana yukawa",
     TeX              -> Subscript[y, MN]
	}        
    
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

(* Kinetic terms for SM gauge fields and U(1)X gauge field Bp *)

LGauge := Block[{mu,nu,ii,aa}, 
  ExpandIndices[-1/4 FS[B,mu,nu] FS[B,mu,nu] -1/4 FS[Bp,mu,nu] FS[Bp,mu,nu] - 1/4 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa], FlavorExpand->SU2W]];

(* Note that as we redefine LL in presence of light and heavy neutrino mixing, the term  LLbar.Ga[mu].DC[LL, mu] contains all the new mixing dependent charged and neutral current interactions such as N-l-W, N-vl-Z, N-N-Z *)

LFermions := Block[{mu}, 
  ExpandIndices[I*(
    QLbar.Ga[mu].DC[QL, mu] + LLbar.Ga[mu].DC[LL, mu] + uRbar.Ga[mu].DC[uR, mu] + dRbar.Ga[mu].DC[dR, mu] + lRbar.Ga[mu].DC[lR, mu] ), 
  FlavorExpand->{SU2W,SU2D}]/.{CKM[a_,b_] Conjugate[CKM[a_,c_]]->IndexDelta[b,c], CKM[b_,a_] Conjugate[CKM[c_,a_]]->IndexDelta[b,c]}];

(* Most general Higgs potential with SM Higgs doublet and new scalar Chi *)

LHiggs := Block[{ii,mu, feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {GZ|GP|GPbar|GZp ->0}, {}];
 
  ExpandIndices[DC[Phibar[ii],mu] DC[Phi[ii],mu] + (DC[Chibar, mu]).DC[Chi, mu] + mu2H1 Phibar[ii] Phi[ii] + mu2H2 Chibar.Chi - \[Lambda]1 Phibar[ii] Phi[ii] Phibar[jj] Phi[jj]-\[Lambda]2 (Chibar.Chi)^2 -
 \[Lambda]3 (Phibar[ii] Phi[ii])*(Chibar.Chi), FlavorExpand->{SU2D,SU2W}]/.feynmangaugerules
 ];

(* SM Yukawa *)
LYukawa := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {GZ|GP|GPbar|GZp ->0}, {}];
 
  yuk = ExpandIndices[
   -yd[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] Phi[ii] - 
    yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phi[ii] - yu[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] Phibar[jj] Eps[ii, jj] , FlavorExpand -> SU2D];
  yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
  yuk+HC[yuk]/.feynmangaugerules
 ];

(* ************************** *)
(* ***** RHN  Lagrangian   ***** *)
(* ************************** *)

LFermionsNR := Block[{mu}, 
  ExpandIndices[I*( NRbar.Ga[mu].DC[NR,mu] ), 
  FlavorExpand->{SU2W,SU2D}]];

(* LYukawaNR contains all the Higgs interactions such as vl-vl-H, vl-N-H, N-N-H *)
LYukawaNR := Block[{ff1,ff2,sp,ii,yun,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {GZ|GP|GPbar|GZp ->0}, {}];
  yun = ExpandIndices[
    -ynd[ff1,ff2] LLbar[sp,ii,ff1].NR[sp,ff2] Phibar[jj] Eps[ii, jj] - ynm[ff1,ff2]/2 NRcbar[sp,ff1].NR[sp,ff2] Chi, FlavorExpand -> SU2D];
  yun+HC[yun]/.feynmangaugerules
  ];
  
LGhost := If[FeynmanGauge, 
		Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB, dBRSTBp, LGhostBp},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];
 	
	dBRSTWi[mu_,i_] := sw/ee Module[{i2, i3}, del[ghWi[i], mu] + ee/sw Eps[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ee/sw ghWibar[a].del[dBRSTWi[mu,a],mu];	
 	
	dBRSTB[mu_] := cw/ee del[ghB, mu];
		LGhostB := - ee/cw ghBbar.del[dBRSTB[mu],mu];

	dBRSTBp[mu_] := 1/g1pp del[ghBp, mu];
		LGhostBp := - g1pp ghBpbar.del[dBRSTBp[mu],mu];
	
	(***********Next the piece from the scalar field.************)
	LGhostphi := 
(1/4*gw*vev (-gw*(vev +Ca*H1+Sa*H2) ghWibar[1].ghWi[1] + g1 phi2 ghWibar[1].ghB +gw phi2 ghWibar[1].ghWi[3] -gw GZ ghWibar[1].ghWi[2] + gt phi2 ghWibar[1].ghBp) +
1/4*gw*vev (-gw*(vev +Ca*H1+Sa*H2) ghWibar[2].ghWi[2] - g1 phi1 ghWibar[2].ghB -gw phi1 ghWibar[2].ghWi[3] +gw GZ ghWibar[2].ghWi[1] -gt phi1 ghWibar[2].ghBp) +
1/4*gw*vev (g1*(vev +Ca*H1+Sa*H2) ghWibar[3].ghB -gw*(vev +Ca*H1+Sa*H2) ghWibar[3].ghWi[3] +gw phi1 ghWibar[3].ghWi[2] 
-gw phi2 ghWibar[3].ghWi[1]   +gt (vev +Ca*H1+Sa*H2) ghWibar[3].ghBp ) + 
1/4*g1*vev (-g1*(vev +Ca*H1+Sa*H2) ghBbar.ghB +gw*(vev +Ca*H1+Sa*H2) ghBbar.ghWi[3] -gw phi1 ghBbar.ghWi[2] +gw phi2 ghBbar.ghWi[1] -gt*(vev +Ca*H1+Sa*H2) ghBbar.ghBp) +
1/4*gt*vev (-g1*(vev +Ca*H1+Sa*H2) ghBpbar.ghB +gw*(vev +Ca*H1+Sa*H2) ghBpbar.ghWi[3] -gw phi1 ghBpbar.ghWi[2] +gw phi2 ghBpbar.ghWi[1] -gt (vev +Ca*H1+Sa*H2) ghBpbar.ghBp) -
4*g1pp^2*x*(x-Sa*H1+Ca*H2) ghBpbar.ghBp) /.{phi1 -> (GP + GPbar)/Sqrt[2], phi2 -> (-GP + GPbar)/(I Sqrt[2])}
;
		 	
	(***********Now add the pieces together.********************)
	LGhostG + LGhostWi + LGhostB + LGhostphi + LGhostBp ], 
        (*If unitary gauge, only include the gluonic ghost.*)
                Block[{dBRSTG,LGhostG},		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];		 		 	
	(***********Now add the pieces together.********************)
	LGhostG]
];


LRHN := LFermionsNR + LYukawaNR;

LSM:= LGauge + LFermions + LHiggs + LYukawa + LGhost;
Lfull := LSM+LRHN;
