(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31229,        863]
NotebookOptionsPosition[     28077,        760]
NotebookOutlinePosition[     28433,        776]
CellTagsIndexPosition[     28390,        773]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.641624023578207*^9, 3.641624026778105*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$FeynRulesPath", " ", "=", " ", 
  RowBox[{"SetDirectory", "[", "\"\<~/FeynRules\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.6416240315823917`*^9, 3.6416240526641283`*^9}}],

Cell[BoxData["\<\"/Users/arturamorim/FeynRules\"\>"], "Output",
 CellChangeTimes->{3.641624055144146*^9, 3.64162428775243*^9, 
  3.6518256593460217`*^9, 3.653674806317245*^9, 3.653676957623468*^9, 
  3.653681238736064*^9, 3.653806026458891*^9, 3.653806079452402*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.6416240627998238`*^9, 3.6416240681435738`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081845689*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.1\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"10 May 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.1", " (" "10 May 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.6538060818518353`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081857767*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081863669*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.6538060818696337`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081875813*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.6538060818818197`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081887444*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081893013*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.653806081898911*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.6416240692315893`*^9, 3.641624289947372*^9, 
  3.651825663644217*^9, 3.653674808859461*^9, 3.65367695800169*^9, 
  3.653681240756557*^9, 3.653806028256892*^9, 3.6538060819046583`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<~/Desktop/topFCNC\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.6416240908145*^9, 3.6416241082234364`*^9}, {
  3.653806086019691*^9, 3.65380608726643*^9}}],

Cell[BoxData["\<\"/Users/arturamorim/Desktop/topFCNC\"\>"], "Output",
 CellChangeTimes->{3.641624109405312*^9, 3.641624294256714*^9, 
  3.65182575701213*^9, 3.6536748172815866`*^9, 3.653676963619643*^9, 
  3.6536812446103354`*^9, 3.653806089041045*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM.fr\>\"", ",", "\"\<topFCNC.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.6416241153359823`*^9, 3.641624143774004*^9}, {
  3.653806092779645*^9, 3.653806094499549*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100317202*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100333658*^9}],

Cell[BoxData["\<\"A.Amorim\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100339353*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100345194*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100350811*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100356409*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100362321*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100494351*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.653806100501212*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"topFCNC_JLOperators\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "topFCNC_JLOperators", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624145765635*^9, 3.641624301474267*^9, 
  3.6518257645831633`*^9, 3.653674820731448*^9, 3.6536769675657988`*^9, 
  3.653681247441236*^9, 3.6538061006104927`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "Ltot", "]"}]], "Input",
 CellChangeTimes->{{3.641624323422627*^9, 3.641624332100013*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.653806170214344*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.653806170220695*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.65380634137712*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.6538063413874483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.653806341393971*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.653806343300049*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.65380634332933*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.65380634333585*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.641624336039813*^9, 3.651825834323975*^9, 
  3.653674892830927*^9, 3.653677043513899*^9, 3.653681313746684*^9, 
  3.653806343344611*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.6416243641101303`*^9, 3.651825989672021*^9, 
  3.6536750664401608`*^9, 3.653677218247385*^9, 3.653681481326324*^9, 
  3.6538063433535023`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "Ltot", "]"}]], "Input",
 CellChangeTimes->{{3.641624519762713*^9, 3.641624527690579*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6416245407385674`*^9, 3.6518261640784807`*^9, 
  3.653675416596346*^9, 3.6536773167394257`*^9, 3.653681577053567*^9, 
  3.6538064746846046`*^9}],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{3.6416245407385674`*^9, 3.6518261640784807`*^9, 
  3.653675416596346*^9, 3.6536773167394257`*^9, 3.653681577053567*^9, 
  3.653806476981387*^9}],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{3.6416245407385674`*^9, 3.6518261640784807`*^9, 
  3.653675416596346*^9, 3.6536773167394257`*^9, 3.653681577053567*^9, 
  3.653806499208045*^9}],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{3.6416245407385674`*^9, 3.6518261640784807`*^9, 
  3.653675416596346*^9, 3.6536773167394257`*^9, 3.653681577053567*^9, 
  3.653806499214452*^9}]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"H", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["\[Mu]", "2"], "2"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "lam", " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.00000000000006`", 
     "125.`"},
    {"b", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","d"},
           "Superscript"], ")"}], 
         RowBox[{"3", ",", "3"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{"3", ",", "3"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "4.700000000000002`", "4.7`"},
    {"d", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","d"},
           "Superscript"], ")"}], 
         RowBox[{"1", ",", "1"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{"1", ",", "1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "0.005040000000000001`", "0.00504`"},
    {"s", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","d"},
           "Superscript"], ")"}], 
         RowBox[{"2", ",", "2"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","d"},
          "Superscript"], 
         RowBox[{"2", ",", "2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "0.10100000000000002`", "0.101`"},
    {"e", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","l"},
           "Superscript"], ")"}], 
         RowBox[{"1", ",", "1"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{"1", ",", "1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "0.0005110000000000001`", "0.000511`"},
    {"mu", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","l"},
           "Superscript"], ")"}], 
         RowBox[{"2", ",", "2"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{"2", ",", "2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "0.10566000000000003`", "0.10566`"},
    {"ta", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","l"},
           "Superscript"], ")"}], 
         RowBox[{"3", ",", "3"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","l"},
          "Superscript"], 
         RowBox[{"3", ",", "3"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "1.7770000000000006`", "1.777`"},
    {"c", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","u"},
           "Superscript"], ")"}], 
         RowBox[{"2", ",", "2"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{"2", ",", "2"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "1.2700000000000002`", "1.27`"},
    {"t", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","u"},
           "Superscript"], ")"}], 
         RowBox[{"3", ",", "3"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{"3", ",", "3"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "172.00000000000003`", "172.`"},
    {"u", 
     RowBox[{
      FractionBox[
       RowBox[{"vev", " ", 
        SubsuperscriptBox[
         RowBox[{"(", 
          TemplateBox[{"y","u"},
           "Superscript"], ")"}], 
         RowBox[{"1", ",", "1"}], "\<\"*\"\>"]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], "+", 
      FractionBox[
       RowBox[{"vev", " ", 
        SubscriptBox[
         TemplateBox[{"y","u"},
          "Superscript"], 
         RowBox[{"1", ",", "1"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], "0.002550000000000001`", "0.00255`"},
    {"W", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.82435974619786`", 
     "79.82435974619784`"},
    {"Z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.18760000000003`", 
     "91.1876`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.641624551959584*^9, 3.651826176871113*^9, 
  3.653675440823331*^9, 3.653677341192923*^9, 3.6536816009878607`*^9, 
  3.653806499345439*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"Ltot", ",", " ", 
   RowBox[{"Output", "\[Rule]", "\"\<topFCNC_UFO\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.641624586203664*^9, 3.6416246119008017`*^9}, {
  3.653681658141623*^9, 3.653681658947329*^9}, {3.653806758919674*^9, 
  3.6538067611113977`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806828174676*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806829697217*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806829700945*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538068297028513`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806845680951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "52", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "52", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  52, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 52, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538068457594547`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"47", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[47, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806852852973*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "47"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 47],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806854279316*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538068595377827`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806859562626*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "64"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 64],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653806859572463*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "378.519109`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 378.519109, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538075432207127`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "81"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 81],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653807543223518*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "2.218262`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 2.218262, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538075462601852`*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538075462625113`*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538075466125193`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653807546656579*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "91", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 91, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.6538075485303373`*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653807548736144*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.641624616967731*^9, 3.6518262472785873`*^9, 
  3.6536755419554033`*^9, 3.653677462046027*^9, 3.653681725819296*^9, 
  3.653807549485708*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 655},
WindowMargins->{{152, Automatic}, {Automatic, 42}},
FrontEndVersion->"10.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 23, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 118, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[701, 26, 199, 3, 28, "Input"],
Cell[903, 31, 266, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1206, 39, 124, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[1355, 45, 252, 3, 22, "Print"],
Cell[1610, 50, 523, 10, 22, "Print"],
Cell[2136, 62, 304, 4, 22, "Print"],
Cell[2443, 68, 238, 3, 21, "Print"],
Cell[2684, 73, 251, 3, 21, "Print"],
Cell[2938, 78, 301, 4, 22, "Print"],
Cell[3242, 84, 303, 4, 22, "Print"],
Cell[3548, 90, 238, 3, 21, "Print"],
Cell[3789, 95, 268, 3, 22, "Print"],
Cell[4060, 100, 238, 3, 21, "Print"],
Cell[4301, 105, 307, 4, 22, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4657, 115, 203, 3, 28, "Input"],
Cell[4863, 120, 252, 3, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5152, 128, 231, 4, 28, "Input"],
Cell[CellGroupData[{
Cell[5408, 136, 240, 3, 22, "Print"],
Cell[5651, 141, 258, 3, 22, "Print"],
Cell[5912, 146, 226, 3, 21, "Print"],
Cell[6141, 151, 364, 7, 21, "Print"],
Cell[6508, 160, 266, 4, 22, "Print"],
Cell[6777, 166, 218, 3, 21, "Print"],
Cell[6998, 171, 248, 3, 22, "Print"],
Cell[7249, 176, 251, 3, 22, "Print"],
Cell[7503, 181, 249, 3, 22, "Print"],
Cell[7755, 186, 446, 9, 38, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8250, 201, 138, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[8413, 207, 273, 4, 22, "Print"],
Cell[8689, 213, 269, 4, 22, "Print"],
Cell[8961, 219, 463, 11, 22, "Print"],
Cell[9427, 232, 221, 3, 22, "Print"],
Cell[9651, 237, 401, 8, 22, "Print"],
Cell[10055, 247, 252, 4, 22, "Print"],
Cell[10310, 253, 209, 3, 21, "Print"],
Cell[10522, 258, 331, 7, 21, "Print"],
Cell[10856, 267, 220, 3, 22, "Print"]
}, Open  ]],
Cell[11091, 273, 209, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11337, 282, 139, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[11501, 288, 451, 9, 22, "Print"],
Cell[11955, 299, 226, 3, 22, "Print"],
Cell[12184, 304, 220, 3, 22, "Print"],
Cell[12407, 309, 261, 4, 22, "Print"]
}, Open  ]],
Cell[12683, 316, 7127, 236, 526, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19847, 557, 313, 6, 28, "Input"],
Cell[CellGroupData[{
Cell[20185, 567, 245, 4, 22, "Print"],
Cell[20433, 573, 468, 11, 22, "Print"],
Cell[20904, 586, 223, 3, 22, "Print"],
Cell[21130, 591, 407, 8, 22, "Print"],
Cell[21540, 601, 256, 4, 22, "Print"],
Cell[21799, 607, 739, 15, 22, "Print"],
Cell[22541, 624, 338, 7, 21, "Print"],
Cell[22882, 633, 692, 14, 22, "Print"],
Cell[23577, 649, 239, 3, 21, "Print"],
Cell[23819, 654, 504, 12, 22, "Print"],
Cell[24326, 668, 458, 11, 21, "Print"],
Cell[24787, 681, 442, 8, 22, "Print"],
Cell[25232, 691, 458, 11, 21, "Print"],
Cell[25693, 704, 424, 8, 22, "Print"],
Cell[26120, 714, 222, 3, 22, "Print"],
Cell[26345, 719, 246, 4, 22, "Print"],
Cell[26594, 725, 435, 8, 22, "Print"],
Cell[27032, 735, 594, 11, 22, "Print"],
Cell[27629, 748, 216, 3, 22, "Print"],
Cell[27848, 753, 201, 3, 21, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
