(****** This is the FeynRules mod-file for the extension of the SM  *********)
(*      where a new quark Q is added                                        *)
(*      This model file needs the Standard Model model file SM.fr.          *)
(*                                                                          *)
(*      We use unitary gauge (default in SM.fr)                             *)
(*                                                                          *)
(****************************************************************************)


M$ModelName = "topFCNC_JLOperators";

(* We work in the unitary gauge (just to make sure we do it again) *)
FeynmanGauge = False;

M$Information = {Authors -> "A.Amorim",                    
   Institutions -> 
    "University of Porto & LIP",
                    Emails -> "artur@lip.pt",
                    Date -> "25.September.2015",
                    Version  ->  "1.0"};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)

M$Parameters = {
  
(* External parameters *)
  
ReXLut  == { TeX -> Subscript[ReX,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 1, InteractionOrder -> {NP,1} },
ImXLut  == { TeX -> Subscript[ImX,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 2, InteractionOrder -> {NP,1} },
ReXRut  == { TeX -> Subscript[ReX,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 3, InteractionOrder -> {NP,1} },
ImXRut  == { TeX -> Subscript[ImX,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 4, InteractionOrder -> {NP,1} },
ReXLct  == { TeX -> Subscript[ReX,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 5, InteractionOrder -> {NP,1} },
ImXLct  == { TeX -> Subscript[ImX,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 6, InteractionOrder -> {NP,1} },
ReXRct  == { TeX -> Subscript[ReX,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 7, InteractionOrder -> {NP,1} },
ImXRct  == { TeX -> Subscript[ImX,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 8, InteractionOrder -> {NP,1} },
ReKLut  == { TeX -> Subscript[ReK,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 9, InteractionOrder -> {NP,1} },
ImKLut  == { TeX -> Subscript[ImK,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 10, InteractionOrder -> {NP,1} },
ReKRut  == { TeX -> Subscript[ReK,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 11, InteractionOrder -> {NP,1} },
ImKRut  == { TeX -> Subscript[ImK,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 12, InteractionOrder -> {NP,1} },
ReKLct  == { TeX -> Subscript[ReK,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 13, InteractionOrder -> {NP,1} },
ImKLct  == { TeX -> Subscript[ImK,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 14, InteractionOrder -> {NP,1} },
ReKRct  == { TeX -> Subscript[ReK,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 15, InteractionOrder -> {NP,1} },
ImKRct  == { TeX -> Subscript[ImK,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 16, InteractionOrder -> {NP,1} },
ReZetaLut  == { TeX -> Subscript[ReZeta,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 17, InteractionOrder -> {NP,1} },
ImZetaLut  == { TeX -> Subscript[ImZeta,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 18, InteractionOrder -> {NP,1} },
ReZetaRut  == { TeX -> Subscript[ReZeta,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 19, InteractionOrder -> {NP,1} },
ImZetaRut  == { TeX -> Subscript[ImZeta,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 20, InteractionOrder -> {NP,1} },
ReZetaLct  == { TeX -> Subscript[ReZeta,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 21, InteractionOrder -> {NP,1} },
ImZetaLct  == { TeX -> Subscript[ImZeta,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 22, InteractionOrder -> {NP,1} },
ReZetaRct  == { TeX -> Subscript[ReZeta,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 23, InteractionOrder -> {NP,1} },
ImZetaRct  == { TeX -> Subscript[ImZeta,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 24, InteractionOrder -> {NP,1} },
ReEtaLut  == { TeX -> Subscript[ReEta,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 25, InteractionOrder -> {NP,1} },
ImEtaLut  == { TeX -> Subscript[ImEta,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 26, InteractionOrder -> {NP,1} },
ReEtaRut  == { TeX -> Subscript[ReEta,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 27, InteractionOrder -> {NP,1} },
ImEtaRut  == { TeX -> Subscript[ImEta,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 28, InteractionOrder -> {NP,1} },
ReEtaLct  == { TeX -> Subscript[ReEta,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 29, InteractionOrder -> {NP,1} },
ImEtaLct  == { TeX -> Subscript[ImEta,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 30, InteractionOrder -> {NP,1} },
ReEtaRct  == { TeX -> Subscript[ReEta,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 31, InteractionOrder -> {NP,1} },
ImEtaRct  == { TeX -> Subscript[ImEta,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 32, InteractionOrder -> {NP,1} },
ReLambdaLut  == { TeX -> Subscript[ReLambda,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 33, InteractionOrder -> {NP,1} },
ImLambdaLut  == { TeX -> Subscript[ImLambda,Lut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 34, InteractionOrder -> {NP,1} },
ReLambdaRut  == { TeX -> Subscript[ReLambda,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 35, InteractionOrder -> {NP,1} },
ImLambdaRut  == { TeX -> Subscript[ImLambda,Rut], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 36, InteractionOrder -> {NP,1} },
ReLambdaLct  == { TeX -> Subscript[ReLambda,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 37, InteractionOrder -> {NP,1} },
ImLambdaLct  == { TeX -> Subscript[ImLambda,Lct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 38, InteractionOrder -> {NP,1} },
ReLambdaRct  == { TeX -> Subscript[ReLambda,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 39, InteractionOrder -> {NP,1} },
ImLambdaRct  == { TeX -> Subscript[ImLambda,Rct], ParameterType -> External, Value -> 0.0, BlockName -> NEWCOUP, OrderBlock -> 40, InteractionOrder -> {NP,1} }




(* Internal Parameters *)


};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

(* H to glue glue *)

LZFCNC := Block[{la},
        la = -(gw*(ReXLct+I*ImXLct)/(2*cw))*(cbar.Ga[mu].ProjM.t)*Z[mu]-(gw*(ReXLut+I*ImXLut)/(2*cw))*(ubar.Ga[mu].ProjM.t)*Z[mu]
        -(gw*(ReXRct+I*ImXRct)/(2*cw))*(cbar.Ga[mu].ProjP.t)*Z[mu]-(gw*(ReXRut+I*ImXRut)/(2*cw))*(ubar.Ga[mu].ProjP.t)*Z[mu]
        +(gw*(ReKLct+I*ImKLct)*I/(4*cw*MZ))*(cbar.Ga[mu].Ga[nu].ProjM.t)*del[Z[nu],mu] - (gw*(ReKLct+I*ImKLct)*I/(4*cw*MZ))*(cbar.Ga[nu].Ga[mu].ProjM.t)*del[Z[nu],mu]
        +(gw*(ReKRct+I*ImKRct)*I/(4*cw*MZ))*(cbar.Ga[mu].Ga[nu].ProjP.t)*del[Z[nu],mu] - (gw*(ReKRct+I*ImKRct)*I/(4*cw*MZ))*(cbar.Ga[nu].Ga[mu].ProjP.t)*del[Z[nu],mu]
        +(gw*(ReKLut+I*ImKLut)*I/(4*cw*MZ))*(ubar.Ga[mu].Ga[nu].ProjM.t)*del[Z[nu],mu] - (gw*(ReKLut+I*ImKLut)*I/(4*cw*MZ))*(ubar.Ga[nu].Ga[mu].ProjM.t)*del[Z[nu],mu]
        +(gw*(ReKRut+I*ImKRut)*I/(4*cw*MZ))*(ubar.Ga[mu].Ga[nu].ProjP.t)*del[Z[nu],mu] - (gw*(ReKRut+I*ImKRut)*I/(4*cw*MZ))*(ubar.Ga[nu].Ga[mu].ProjP.t)*del[Z[nu],mu];
        la + HC[la]];

LphotonFCNC := Block[{la},
        la =((ReLambdaLct+I*ImLambdaLct)*I*ee/(2*MT))*(cbar.Ga[mu].Ga[nu].ProjM.t)*del[A[nu],mu]-((ReLambdaLct+I*ImLambdaLct)*I*ee/(2*MT))*(cbar.Ga[nu].Ga[mu].ProjM.t)*del[A[nu],mu]
        +((ReLambdaRct+I*ImLambdaRct)*I*ee/(2*MT))*(cbar.Ga[mu].Ga[nu].ProjP.t)*del[A[nu],mu]-((ReLambdaRct+I*ImLambdaRct)*I*ee/(2*MT))*(cbar.Ga[nu].Ga[mu].ProjP.t)*del[A[nu],mu]
        +((ReLambdaLut+I*ImLambdaLut)*I*ee/(2*MT))*(ubar.Ga[mu].Ga[nu].ProjM.t)*del[A[nu],mu]-((ReLambdaLut+I*ImLambdaLut)*I*ee/(2*MT))*(ubar.Ga[nu].Ga[mu].ProjM.t)*del[A[nu],mu]
        +((ReLambdaRut+I*ImLambdaRut)*I*ee/(2*MT))*(ubar.Ga[mu].Ga[nu].ProjP.t)*del[A[nu],mu]-((ReLambdaRut+I*ImLambdaRut)*I*ee/(2*MT))*(ubar.Ga[nu].Ga[mu].ProjP.t)*del[A[nu],mu];
        la + HC[la]];

LgluonFCNC := Block[{la},
        la = (gs*(ReZetaLct+I*ImZetaLct)*I/(2*MT))*2*(cbar.T[a].Ga[mu].Ga[nu].ProjM.t)*del[G[nu,a],mu]-(gs*(ReZetaLct+I*ImZetaLct)*I/(2*MT))*2*(cbar.T[a].Ga[nu].Ga[mu].ProjM.t)*del[G[nu,a],mu]
        +(gs*(ReZetaRct+I*ImZetaRct)*I/(2*MT))*2*(cbar.T[a].Ga[mu].Ga[nu].ProjP.t)*del[G[nu,a],mu]-(gs*(ReZetaRct+I*ImZetaRct)*I/(2*MT))*2*(cbar.T[a].Ga[nu].Ga[mu].ProjP.t)*del[G[nu,a],mu]
        +(gs*(ReZetaLut+I*ImZetaLut)*I/(2*MT))*2*(ubar.T[a].Ga[mu].Ga[nu].ProjM.t)*del[G[nu,a],mu]-(gs*(ReZetaLut+I*ImZetaLut)*I/(2*MT))*2*(ubar.T[a].Ga[nu].Ga[mu].ProjM.t)*del[G[nu,a],mu]
        +(gs*(ReZetaRut+I*ImZetaRut)*I/(2*MT))*2*(ubar.T[a].Ga[mu].Ga[nu].ProjP.t)*del[G[nu,a],mu]-(gs*(ReZetaRut+I*ImZetaRut)*I/(2*MT))*2*(ubar.T[a].Ga[nu].Ga[mu].ProjP.t)*del[G[nu,a],mu];
        la + HC[la]];

LHiggsFCNC := Block[{la},
        la = -((ReEtaLut+I*ImEtaLut)/Sqrt[2])*(ubar.ProjM.t)*H-((ReEtaRut+I*ImEtaRut)/Sqrt[2])*(ubar.ProjP.t)*H
        -((ReEtaLct+I*ImEtaLct)/Sqrt[2])*(cbar.ProjM.t)*H-((ReEtaRct+I*ImEtaRct)/Sqrt[2])*(cbar.ProjP.t)*H;
        la + HC[la]];


Ltot := LSM + LZFCNC + LgluonFCNC + LHiggsFCNC + LphotonFCNC;

