(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    277876,       4532]
NotebookOptionsPosition[    267757,       4394]
NotebookOutlinePosition[    268190,       4411]
CellTagsIndexPosition[    268147,       4408]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.650775848525028*^9, 3.650775850862257*^9}, {
  3.656711800473441*^9, 3.6567118018571033`*^9}, {3.658229201849017*^9, 
  3.65822920320895*^9}},ExpressionUUID->"5ec45779-d10f-40a9-8b67-\
fa4ea1ab2938"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.650779245705666*^9, 
  3.6507792470409403`*^9}},ExpressionUUID->"a6951ce1-0ae0-45b0-a61e-\
1b9f0fab81d8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Dropbox/Work/PhysSoftware/feynrules-current/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM_noH.fr\>\"", ",", "\"\<LesHouchesModelFreezeIn-leptons.fr\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"(*", 
    RowBox[{
    "\"\<~/Work/PhysSoftware/feynrules-current/Models/SM/Massless.rst\>\"", 
     ","}], "*)"}], 
   "\"\<~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst\>\"", 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.504423447270249*^9, {3.507209594206577*^9, 3.507209600067323*^9}, {
   3.514799374048591*^9, 3.514799404330376*^9}, {3.515062647798441*^9, 
   3.515062653173225*^9}, {3.515135742551162*^9, 3.515135748404658*^9}, {
   3.551191781661876*^9, 3.551191796346917*^9}, {3.589877382659015*^9, 
   3.589877391686277*^9}, {3.589878062567462*^9, 3.589878067455187*^9}, {
   3.589878109496549*^9, 3.589878111197733*^9}, {3.59055306646451*^9, 
   3.590553091624037*^9}, 3.620364186079145*^9, 3.643521386632444*^9, {
   3.650775807478299*^9, 3.650775846833221*^9}, {3.6507763739543247`*^9, 
   3.650776383058586*^9}, {3.6507769890796022`*^9, 3.650776995383911*^9}, {
   3.650778402069853*^9, 3.650778402441492*^9}, {3.656688195123386*^9, 
   3.656688202507885*^9}, {3.656707591564633*^9, 3.656707593862214*^9}, {
   3.6567081194883204`*^9, 3.656708124503265*^9}, {3.656708347865992*^9, 
   3.656708348809312*^9}, 3.656708994015786*^9, {3.656711329669117*^9, 
   3.6567113577720737`*^9}, {3.656711432727879*^9, 3.6567114596044073`*^9}, {
   3.656711640746749*^9, 3.656711641778183*^9}, {3.656711895213398*^9, 
   3.656711899204385*^9}, {3.656838620561311*^9, 3.656838627830728*^9}, 
   3.662109534352394*^9, {3.666088203821269*^9, 3.666088204092046*^9}, {
   3.66610247441702*^9, 3.666102478615559*^9}, 3.7068777077767572`*^9, {
   3.7068789795632753`*^9, 3.706878984704603*^9}, {3.708339042321351*^9, 
   3.7083390466800632`*^9}, 3.7173095636637573`*^9, 3.731391282867195*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"674a449c-ebe8-4afe-a89b-ed9cf8db3350"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357024717283`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b41b5d10-3128-48d4-adfb-9d858ba81246"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.2\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"31 May 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.2", " (" "31 May 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702473345*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a81acbc4-6277-4413-aafe-9cc0010db47a"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357024754868`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"80d1ea72-cc7f-4c7b-921a-0abdd88797f3"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702476652*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"39fa1073-71df-4636-89a7-4968f84dd857"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702477594*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"9a5f30a0-3f55-4948-a4db-a54cc0dfe7bd"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702478531*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ba01115f-ea44-4e8b-8aa6-91327d5a0b82"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357024794493`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b327e588-51c7-4833-894b-6d3ed8c47784"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357024803057`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3ccb39cb-ad36-498f-93db-5a3a685e4956"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702481183*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4b718880-5729-4f4f-ab36-bf75ed765bc2"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702482048*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3605b954-6aec-471e-97d8-6ef881f2bf16"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135702482956*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b73e8033-9709-4faf-90dd-883feedd1a40"],

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705428405*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e8288466-ee10-4eb2-ad17-af5b33fe0704"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705457251*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"410e6184-0cc6-46fc-9fbc-376a75e4089e"],

Cell[BoxData["\<\"Genevieve Belanger, Nishita Desai, Andreas Goudelis, Julia \
Harz, Andre Lessa, Jose Miguel No, Alexander Pukhov, Sezen Sekmen, Dipan \
Sengupta, Bryan Zaldivar, Jose Zurita\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705458775*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d0a4b11f-1cfa-4882-9b14-871d293c02eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705460143*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"84aefce5-cbf0-4fb4-8667-246d834d9b92"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705461771*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"042d8d66-aca2-4610-aaa6-34bd4029a20c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357054632607`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"742504a5-f419-4534-a11c-df943a03b7da"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705464842*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"bbd2236e-5fd8-43ae-acd4-aba008fe7975"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357055989656`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f5a91517-03f1-4f97-8b85-d914787b8464"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705623383*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"45fcc225-a7b5-4d16-874e-701c977114fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"LesHouchesModelFreezeIn-leptons\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "LesHouchesModelFreezeIn-leptons", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135705687199*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"23ab275c-ae1e-4d49-8bb7-0372c4ffa089"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get","noopen",
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"~/Work/PhysSoftware/feynrules-current/Models/SM/\
DiagonalCKM.rst\\\\\\\"\\\"}]\\).\"",2,5,1,32416065863699900617,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.750135705785346*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b939df9c-e830-421c-b622-2840ab9e7d8a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{8., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm[
  "Loading restrictions from ", 
   "~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7501357067090683`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f7aa6e73-2ba0-4795-8c69-dc7ec8d84dd3"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.750135706819199*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5f4df8d6-97e9-4c05-9abe-694aac98d941"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checks", "Section",
 CellChangeTimes->{{3.6507792417995567`*^9, 
  3.650779242257778*^9}},ExpressionUUID->"7d7906c8-5fe7-4218-bd22-\
ea113896928e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LNP", "]"}]], "Input",
 CellChangeTimes->{{3.650779144898395*^9, 3.650779226197805*^9}, 
   3.6507796370351048`*^9, {3.6507799542733107`*^9, 3.650779954775826*^9}, 
   3.65670844124369*^9, {3.6567084734627542`*^9, 3.656708475077517*^9}, {
   3.6567086177844677`*^9, 3.65670861820015*^9}, {3.6567089657011833`*^9, 
   3.6567089669488373`*^9}, {3.656709000689712*^9, 3.6567090012231293`*^9}, {
   3.6567114398937197`*^9, 3.656711440036572*^9}, {3.7089385871933813`*^9, 
   3.708938588525648*^9}, {3.7089386630268517`*^9, 3.708938665030877*^9}, {
   3.712571481652707*^9, 3.7125714822191277`*^9}, {3.7125715566010723`*^9, 
   3.712571557139542*^9}, {3.712572886863242*^9, 3.7125729052131844`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"5598e096-9040-46e6-af0f-b29f2b844778"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.750135714272902*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"a6c8283f-dd3f-4b9f-a221-e88ac2e3ff3e"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.750135714289425*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"d027a5ad-1fb6-4e4d-bc1c-35547eddeaaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{G0, G0}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{G0, G0}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.750135714863804*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"d82b6608-6c8e-4d72-ad51-c1b5c2cfdd61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{GP, GPbar}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{GP, GPbar}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.750135714865307*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"710e0a7f-67c6-4bad-a29d-cbb1ec9cd003"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.750135714890818*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"bb5dbab8-10fb-45c9-8111-c5d5924dd2a3"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7501357148918657`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"266b060f-7f9a-48a5-8c50-77faa208f65d"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"h", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Mu]", "H", "2"], "2"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          SubscriptBox["\[Lambda]", "H"], " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.00000000000001`", 
     "125.`"},
    {"s0", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         SubsuperscriptBox["\[Mu]", "s0", "2"], "2"], "-", 
        FractionBox[
         RowBox[{
          SubscriptBox["\[Lambda]", "s0h"], " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.`", "125.`"},
    {"HE", "mHE", "100.`", "100.`"},
    {"W", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.82435974619786`", 
     "79.82435974619784`"},
    {"Z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.18760000000003`", 
     "91.1876`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.712571564762248*^9, {3.712572896796516*^9, 3.712572911838369*^9}, 
   3.712573115779406*^9, 3.712573434690213*^9, 3.717309594311844*^9, 
   3.717310028097417*^9, 3.717311988773814*^9, 3.7173120818157587`*^9, 
   3.717312113339554*^9, 3.717312175114628*^9, 3.717312283061097*^9, 
   3.7173123648631773`*^9, {3.717312400887726*^9, 3.7173124295225887`*^9}, {
   3.717312481701285*^9, 3.717312509813918*^9}, 3.7173126042171183`*^9, 
   3.7173126873535213`*^9, 3.717312721953888*^9, 3.717313048645419*^9, 
   3.717316880185884*^9, 3.7173195919823837`*^9, 3.717320654807839*^9, 
   3.717320776592683*^9, 3.7173301809928627`*^9, 3.717330424745611*^9, 
   3.71733702198682*^9, 3.719029134776349*^9, 3.731391293587998*^9, 
   3.7501357148947153`*^9},
 CellLabel->
  "Out[6]//TableForm=",ExpressionUUID->"53ddd376-f598-4d2e-9199-dc83f950ac99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LNP", "]"}]], "Input",
 CellChangeTimes->{{3.662109944482068*^9, 3.662109949959669*^9}, {
  3.7070520925079317`*^9, 3.707052094151979*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"c62bc199-e9eb-4f32-97a4-34f206f6f63c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.75013572361509*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6fd06400-6134-4128-90b8-678f0ecc4461"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.750135723617194*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7be588e5-9d06-44aa-bde6-18d536de2d1b"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.7501357254183283`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"252d34f1-0f63-422d-a9a9-4ff0507c6ebc"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.750135725419723*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"98b44338-d794-4e51-bd66-305b9ef26b51"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.7501357254879913`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f3c7ab6a-3a30-4800-8ccb-0364155056b3"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.750135725489294*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2f924626-15aa-483d-a266-f1eb2c307441"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.750135725490497*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8998a8ef-2944-4605-9ce1-27df1a37d494"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.750135725491776*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2bcd3c95-a584-4423-abf3-c30f039e1f18"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.662109951378407*^9, 3.662110049947618*^9, 3.6621100998351517`*^9, 
   3.662110230328856*^9, 3.662110556605912*^9, 3.6621115659622173`*^9, 
   3.662111691085476*^9, 3.662111987347905*^9, 3.662299837179309*^9, 
   3.662460270761208*^9, 3.662461076456791*^9, 3.662461176813862*^9, 
   3.66609470427413*^9, 3.6660947832833767`*^9, 3.666094824582155*^9, 
   3.6660948890397797`*^9, 3.6660949420967913`*^9, 3.6660950405602217`*^9, 
   3.6660950807879753`*^9, {3.6660958916258173`*^9, 3.6660959206518106`*^9}, {
   3.666095970622983*^9, 3.666096022386922*^9}, 3.666096209735268*^9, 
   3.6660964517873077`*^9, 3.666096506736858*^9, 3.6660968019201097`*^9, 
   3.6660971258492203`*^9, 3.666097216165155*^9, 3.66609749119268*^9, 
   3.666098649761964*^9, 3.6660990864511538`*^9, 3.666105647539627*^9, 
   3.6661056995078573`*^9, 3.666105777441723*^9, 3.666106138783424*^9, 
   3.666106326347747*^9, 3.666106927863018*^9, 3.666106986378415*^9, 
   3.6661074988713627`*^9, 3.666107542812337*^9, 3.666107781108523*^9, 
   3.666108203122014*^9, 3.6661083033618193`*^9, 3.666108641518971*^9, 
   3.666108816209578*^9, 3.66610896823496*^9, 3.66611007525498*^9, 
   3.666162980783061*^9, 3.666172837677167*^9, 3.666173554435424*^9, 
   3.6661736283472443`*^9, 3.666256565913422*^9, 3.6662569898703337`*^9, 
   3.666257037252726*^9, 3.6662582852313557`*^9, 3.6938355927370863`*^9, 
   3.706879144695354*^9, 3.7068792163020782`*^9, 3.706879307338579*^9, 
   3.706879399543598*^9, 3.707020692581769*^9, 3.70702087142515*^9, 
   3.7070209592958384`*^9, 3.707115326899603*^9, 3.7083426979576273`*^9, 
   3.7084105585559053`*^9, 3.7086883139925613`*^9, 3.7087830944199944`*^9, 
   3.708786137420226*^9, 3.708786280387837*^9, 3.708844254882721*^9, 
   3.708857134449316*^9, 3.7088572393670397`*^9, 3.708857311628956*^9, 
   3.7088574157731037`*^9, 3.708941773070489*^9, 3.712572932788961*^9, 
   3.712573127822146*^9, 3.71730993581514*^9, 3.717310022535645*^9, 
   3.717312612968665*^9, 3.717312726629593*^9, 3.717313051510038*^9, 
   3.717316883915576*^9, 3.717319594879335*^9, 3.7173200150136013`*^9, 
   3.717320659913966*^9, 3.717320780219535*^9, 3.717330184859136*^9, 
   3.717330430788595*^9, 3.717337025527526*^9, 3.7190291399198008`*^9, 
   3.731391299355544*^9, 3.750135725493054*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"ffc556e9-0297-4d3d-9da6-3337a89d5e12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interfaces", "Section",
 CellChangeTimes->{{3.650782302772278*^9, 
  3.6507823065682487`*^9}},ExpressionUUID->"e7413e10-883c-496f-94ea-\
d252a70b9204"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteCHOutput", "[", 
  RowBox[{"LSM", ",", "LNP"}], "]"}]], "Input",
 CellChangeTimes->{{3.6242538526978188`*^9, 3.624253855246005*^9}, {
   3.6242539619622*^9, 3.624253962288993*^9}, 3.6435484136339283`*^9, {
   3.650782323830791*^9, 3.650782325054451*^9}, {3.6508794326823387`*^9, 
   3.650879434504023*^9}, {3.656697807213163*^9, 3.656697807404377*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"58eaf90f-6270-4e21-91b6-eb88bb862e68"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaKP2Tt8u/DhtSMAVOK+KA==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"86d6c6cf-14e4-499a-9167-a0e78d5315fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaIF/B2+Xfjw2hEAT6K9gg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"0a32d8cb-ed25-4bcf-b8f6-d0e65bf6dbb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaIvRjl8u/DhtSMAVfe+Tg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b14a098f-a179-4a70-940d-8c5295b648de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/home/andrikos/Dropbox/LH_LLPs_freezein/andreas/\
ColliderFriendlyFreezeInModels-FRpage/LesHouchesModelFreezeIn-leptons/\
LesHouchesModelFreezeIn-leptons-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/home/andrikos/Dropbox/LH_LLPs_freezein/andreas/\
ColliderFriendlyFreezeInModels-FRpage/LesHouchesModelFreezeIn-leptons/\
LesHouchesModelFreezeIn-leptons-CH."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaKfpDh8u/DhtSMAVtW+aw==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"99114edd-4332-4033-ac49-a47b5a844ae2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaIb8h2+Xfjw2hEAVAK+Eg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"289aaf91-d1f3-4180-900d-36c7c4ff2fd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaIn9Dl+u/DhtSMAVWG+Qg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"a17a6c85-5620-4090-8461-f8bfff65db14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaIjZjh+u/DhtSMAU+e+FA==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"54058b2d-f93e-4034-b818-d197da756197"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaLPzXT6duHDa0cAV6S+jA==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"128157ca-1f79-40a3-b285-dce1f433369c"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaLnLXH6duHDa0cAVnG+Zw==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7636da0f-ac89-42ab-8089-626661a25cd2"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaK7Prt/u/DhtSMAWBi+pw==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"8b45a003-0078-4577-a5cb-6fa78d140092"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaLn/XP/duHDa0cAWQW+xg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"4864a998-4bbc-4950-84ff-5bcadfd0c854"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL3cXp8u/DhtSMAU1i98g==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"13253990-8341-4e32-be28-fc80c8c3bc16"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaJnPTT9fuHDa0cAV7O+lA==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d482d73a-2a23-43da-9a11-62b4fa8bad31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "111", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "111", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  111, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 111, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaLf7zb/fuHDa0cAWV2+xQ==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"c272b2da-4596-40ef-bd9a-72c6c727dff5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"106", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[106, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaKjuU58v/DhtSMAU0y+EQ==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"9aa86f23-4af3-48b9-b4f0-208899c2ed3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "106"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 106],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaJ3aEn9uPDhtSMAUwW94Q==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"59f74074-5ae8-464f-b27d-653d6ff11e23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaK3FTH9vPDhtSMAVGK+EA==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"57ced8e7-56d5-44af-8140-0e38f3563c7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaKTbk/+eeHDa0cAWAe+tg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"019d4130-8b3a-458b-a302-e64c25ae8309"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaJvtUz7eeHDa0cAWXi+2g==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"74648d03-7d4c-45fb-a937-ee98252e79ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.44min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.44min!"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQA2Ihh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaIFlk37eeHDa0cAVBa+Mg==
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"e3d4979c-311b-4c8d-97f6-4e86e21227cb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", ",", "LNP"}], "]"}]], "Input",
 CellChangeTimes->{{3.515066451500599*^9, 3.51506645766863*^9}, {
   3.515066553825666*^9, 3.515066567557489*^9}, {3.517657052212844*^9, 
   3.5176570535784883`*^9}, {3.517657087674789*^9, 3.5176570975167933`*^9}, {
   3.517657162889937*^9, 3.517657189106102*^9}, {3.62036438703964*^9, 
   3.620364399043768*^9}, 3.643548416121323*^9, {3.650782333532228*^9, 
   3.650782334611961*^9}, {3.6508794376715517`*^9, 3.650879441489379*^9}, {
   3.656697825115713*^9, 3.65669782525168*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"b4dde509-82ce-4dc0-93c3-0bb8f493b4f4"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135768370071*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"884ddbde-e019-4b21-9d30-1686fb2ed4b2"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135768718885*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"cacbce31-0314-4ea2-9c5d-5e751a8bc159"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135768721362*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"607d9bc0-a569-4c8e-9517-1af30034eb08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135768722608*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"34ddae1d-3430-4a99-89cd-2a2f9444a32c"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135774115937*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"5b4b6fc6-cd43-4b08-af90-6f4145053b6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "60", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "60", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  60, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 60, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501357741584587`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"a4806506-ee6b-409c-a8d3-8e7c5aa2d6c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"55", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[55, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501357773413353`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"a3a9df77-e814-4434-8d1c-b027d1651c64"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135777366784*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e417c644-5dab-4cdb-ba05-f57db487b309"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501357773680058`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"a0c8cc8e-0c32-4369-9633-85c54e7480c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135777369071*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"f37e9678-6030-4372-8602-53c4cc6389c3"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135779480157*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"0b670c6d-5c22-4639-be50-a3b8bef269ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "51", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "51", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  51, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 51, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135779515094*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"329d3197-aa81-4ed9-8bcd-09ef8273f937"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"51", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[51, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501357809815893`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"005e8d61-1ef7-46ef-a7fe-76441aa6c0b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "106"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 106],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135783649364*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"751bb160-27ef-4463-b10d-47e358f8e3a5"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135791415867*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"479fb835-47ec-4263-a7da-78bd5c5a4aa0"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.75013579146402*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"7efef4af-512b-46d0-9895-f4d5c9ed4c31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "56"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 56],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501357915277767`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e25ab1b1-3dad-4958-a858-922d8c4a2e50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "5.120082`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 5.120082, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135801157786*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"5481e6a4-fa79-4d3e-9ccb-dbd34c0f1eac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "71"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 71],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501358012138443`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"1b8f5c49-5ff0-4040-8b07-f88afd405ccb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "1.139261`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 1.139261, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501358026683207`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"ef841c61-47b6-4597-bf72-605b8bddc988"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501358026717854`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"22a07015-46b2-4aac-87ec-e2278724a2ff"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135802922112*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"821ea0ab-76ef-43e5-8d9b-4f0a0d91735e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501358029572573`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e2843305-4ffe-4500-80ca-9ff8c7252808"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "176", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 176, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135805006115*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"2202e99f-34aa-41d4-8df1-d1c07163f0a9"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501358052049007`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"98fefb89-598b-4926-994f-c0a942f8fa90"],

Cell[BoxData[
 StyleBox["\<\"Warning: Non positive interaction order QED.\\n                \
This might reduce the efficiency of certain matrix element generators.\\n     \
           See logfile for more details.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.7501358053376293`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e6b071f8-ed58-44dc-9982-9c329fc787df"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.750135805495749*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"3f20a490-c742-43fb-9e1f-8aa17f80d1c9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1855, 1056},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"11.3 for Linux x86 (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 274, 5, 31, "Input",ExpressionUUID->"5ec45779-d10f-40a9-8b67-fa4ea1ab2938"],
Cell[CellGroupData[{
Cell[844, 29, 152, 3, 68, "Section",ExpressionUUID->"a6951ce1-0ae0-45b0-a61e-1b9f0fab81d8"],
Cell[CellGroupData[{
Cell[1021, 36, 2361, 46, 124, "Input",ExpressionUUID->"674a449c-ebe8-4afe-a89b-ed9cf8db3350"],
Cell[CellGroupData[{
Cell[3407, 86, 8101, 114, 25, "Print",ExpressionUUID->"b41b5d10-3128-48d4-adfb-9d858ba81246"],
Cell[11511, 202, 8368, 121, 25, "Print",ExpressionUUID->"a81acbc4-6277-4413-aafe-9cc0010db47a"],
Cell[19882, 325, 8153, 115, 25, "Print",ExpressionUUID->"80d1ea72-cc7f-4c7b-921a-0abdd88797f3"],
Cell[28038, 442, 8085, 114, 25, "Print",ExpressionUUID->"39fa1073-71df-4636-89a7-4968f84dd857"],
Cell[36126, 558, 8096, 114, 25, "Print",ExpressionUUID->"9a5f30a0-3f55-4948-a4db-a54cc0dfe7bd"],
Cell[44225, 674, 8148, 115, 25, "Print",ExpressionUUID->"ba01115f-ea44-4e8b-8aa6-91327d5a0b82"],
Cell[52376, 791, 8150, 115, 25, "Print",ExpressionUUID->"b327e588-51c7-4833-894b-6d3ed8c47784"],
Cell[60529, 908, 8087, 114, 25, "Print",ExpressionUUID->"3ccb39cb-ad36-498f-93db-5a3a685e4956"],
Cell[68619, 1024, 8115, 114, 25, "Print",ExpressionUUID->"4b718880-5729-4f4f-ab36-bf75ed765bc2"],
Cell[76737, 1140, 8085, 114, 25, "Print",ExpressionUUID->"3605b954-6aec-471e-97d8-6ef881f2bf16"],
Cell[84825, 1256, 8152, 115, 25, "Print",ExpressionUUID->"b73e8033-9709-4faf-90dd-883feedd1a40"],
Cell[92980, 1373, 8106, 114, 25, "Print",ExpressionUUID->"e8288466-ee10-4eb2-ad17-af5b33fe0704"],
Cell[101089, 1489, 8124, 114, 25, "Print",ExpressionUUID->"410e6184-0cc6-46fc-9fbc-376a75e4089e"],
Cell[109216, 1605, 8257, 116, 25, "Print",ExpressionUUID->"d0a4b11f-1cfa-4882-9b14-871d293c02eb"],
Cell[117476, 1723, 8230, 118, 25, "Print",ExpressionUUID->"84aefce5-cbf0-4fb4-8667-246d834d9b92"],
Cell[125709, 1843, 8132, 115, 25, "Print",ExpressionUUID->"042d8d66-aca2-4610-aaa6-34bd4029a20c"],
Cell[133844, 1960, 8086, 114, 25, "Print",ExpressionUUID->"742504a5-f419-4534-a11c-df943a03b7da"],
Cell[141933, 2076, 8114, 114, 25, "Print",ExpressionUUID->"bbd2236e-5fd8-43ae-acd4-aba008fe7975"],
Cell[150050, 2192, 8119, 114, 25, "Print",ExpressionUUID->"f5a91517-03f1-4f97-8b85-d914787b8464"],
Cell[158172, 2308, 8115, 114, 25, "Print",ExpressionUUID->"45fcc225-a7b5-4d16-874e-701c977114fe"],
Cell[166290, 2424, 8334, 120, 48, "Print",ExpressionUUID->"23ab275c-ae1e-4d49-8bb7-0372c4ffa089"]
}, Open  ]],
Cell[174639, 2547, 406, 10, 22, "Message",ExpressionUUID->"b939df9c-e830-421c-b622-2840ab9e7d8a"],
Cell[CellGroupData[{
Cell[175070, 2561, 8681, 127, 25, "Print",ExpressionUUID->"f7aa6e73-2ba0-4795-8c69-dc7ec8d84dd3"],
Cell[183754, 2690, 8104, 114, 25, "Print",ExpressionUUID->"5f4df8d6-97e9-4c05-9abe-694aac98d941"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[191919, 2811, 153, 3, 68, "Section",ExpressionUUID->"7d7906c8-5fe7-4218-bd22-ea113896928e"],
Cell[CellGroupData[{
Cell[192097, 2818, 822, 11, 31, "Input",ExpressionUUID->"5598e096-9040-46e6-af0f-b29f2b844778"],
Cell[CellGroupData[{
Cell[192944, 2833, 1177, 21, 25, "Print",ExpressionUUID->"a6c8283f-dd3f-4b9f-a221-e88ac2e3ff3e"],
Cell[194124, 2856, 954, 15, 25, "Print",ExpressionUUID->"d027a5ad-1fb6-4e4d-bc1c-35547eddeaaa"],
Cell[195081, 2873, 1220, 23, 25, "Print",ExpressionUUID->"d82b6608-6c8e-4d72-ad51-c1b5c2cfdd61"],
Cell[196304, 2898, 1226, 23, 25, "Print",ExpressionUUID->"710e0a7f-67c6-4bad-a29d-cbb1ec9cd003"],
Cell[197533, 2923, 948, 15, 25, "Print",ExpressionUUID->"bb5dbab8-10fb-45c9-8111-c5d5924dd2a3"],
Cell[198484, 2940, 991, 16, 25, "Print",ExpressionUUID->"266b060f-7f9a-48a5-8c50-77faa208f65d"]
}, Open  ]],
Cell[199490, 2959, 3255, 89, 271, "Output",ExpressionUUID->"53ddd376-f598-4d2e-9199-dc83f950ac99"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202782, 3053, 266, 4, 31, "Input",ExpressionUUID->"c62bc199-e9eb-4f32-97a4-34f206f6f63c"],
Cell[CellGroupData[{
Cell[203073, 3061, 2500, 37, 25, "Print",ExpressionUUID->"6fd06400-6134-4128-90b8-678f0ecc4461"],
Cell[205576, 3100, 2497, 37, 25, "Print",ExpressionUUID->"7be588e5-9d06-44aa-bde6-18d536de2d1b"],
Cell[208076, 3139, 2694, 44, 25, "Print",ExpressionUUID->"252d34f1-0f63-422d-a9a9-4ff0507c6ebc"],
Cell[210773, 3185, 2447, 36, 25, "Print",ExpressionUUID->"98b44338-d794-4e51-bd66-305b9ef26b51"],
Cell[213223, 3223, 2482, 37, 25, "Print",ExpressionUUID->"f3c7ab6a-3a30-4800-8ccb-0364155056b3"],
Cell[215708, 3262, 2438, 36, 25, "Print",ExpressionUUID->"2f924626-15aa-483d-a266-f1eb2c307441"],
Cell[218149, 3300, 2560, 40, 25, "Print",ExpressionUUID->"8998a8ef-2944-4605-9ce1-27df1a37d494"],
Cell[220712, 3342, 2448, 36, 25, "Print",ExpressionUUID->"2bcd3c95-a584-4423-abf3-c30f039e1f18"]
}, Open  ]],
Cell[223175, 3381, 2418, 35, 35, "Output",ExpressionUUID->"ffc556e9-0297-4d3d-9da6-3337a89d5e12"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[225642, 3422, 157, 3, 68, "Section",ExpressionUUID->"e7413e10-883c-496f-94ea-d252a70b9204"],
Cell[CellGroupData[{
Cell[225824, 3429, 459, 7, 31, "Input",ExpressionUUID->"58eaf90f-6270-4e21-91b6-eb88bb862e68"],
Cell[CellGroupData[{
Cell[226308, 3440, 678, 13, 25, "Print",ExpressionUUID->"86d6c6cf-14e4-499a-9167-a0e78d5315fb"],
Cell[226989, 3455, 1119, 27, 25, "Print",ExpressionUUID->"0a32d8cb-ed25-4bcf-b8f6-d0e65bf6dbb2"],
Cell[228111, 3484, 1111, 27, 25, "Print",ExpressionUUID->"b14a098f-a179-4a70-940d-8c5295b648de"],
Cell[229225, 3513, 1365, 34, 48, "Print",ExpressionUUID->"99114edd-4332-4033-ac49-a47b5a844ae2"],
Cell[230593, 3549, 1083, 27, 48, "Print",ExpressionUUID->"289aaf91-d1f3-4180-900d-36c7c4ff2fd7"],
Cell[231679, 3578, 1097, 27, 48, "Print",ExpressionUUID->"a17a6c85-5620-4090-8461-f8bfff65db14"],
Cell[232779, 3607, 1097, 27, 48, "Print",ExpressionUUID->"54058b2d-f93e-4034-b818-d197da756197"],
Cell[233879, 3636, 1097, 27, 48, "Print",ExpressionUUID->"128157ca-1f79-40a3-b285-dce1f433369c"],
Cell[234979, 3665, 633, 13, 25, "Print",ExpressionUUID->"7636da0f-ac89-42ab-8089-626661a25cd2"],
Cell[235615, 3680, 905, 21, 25, "Print",ExpressionUUID->"8b45a003-0078-4577-a5cb-6fa78d140092"],
Cell[236523, 3703, 660, 13, 25, "Print",ExpressionUUID->"4864a998-4bbc-4950-84ff-5bcadfd0c854"],
Cell[237186, 3718, 842, 18, 25, "Print",ExpressionUUID->"13253990-8341-4e32-be28-fc80c8c3bc16"],
Cell[238031, 3738, 693, 14, 25, "Print",ExpressionUUID->"d482d73a-2a23-43da-9a11-62b4fa8bad31"],
Cell[238727, 3754, 1178, 25, 25, "Print",ExpressionUUID->"c272b2da-4596-40ef-bd9a-72c6c727dff5"],
Cell[239908, 3781, 777, 17, 25, "Print",ExpressionUUID->"9aa86f23-4af3-48b9-b4f0-208899c2ed3f"],
Cell[240688, 3800, 1131, 24, 25, "Print",ExpressionUUID->"59f74074-5ae8-464f-b27d-653d6ff11e23"],
Cell[241822, 3826, 1290, 31, 70, "Print",ExpressionUUID->"57ced8e7-56d5-44af-8140-0e38f3563c7b"],
Cell[243115, 3859, 1083, 27, 48, "Print",ExpressionUUID->"019d4130-8b3a-458b-a302-e64c25ae8309"],
Cell[244201, 3888, 1096, 27, 25, "Print",ExpressionUUID->"74648d03-7d4c-45fb-a937-ee98252e79ac"],
Cell[245300, 3917, 1041, 27, 48, "Print",ExpressionUUID->"e3d4979c-311b-4c8d-97f6-4e86e21227cb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246390, 3950, 649, 10, 31, "Input",ExpressionUUID->"b4dde509-82ce-4dc0-93c3-0bb8f493b4f4"],
Cell[CellGroupData[{
Cell[247064, 3964, 606, 10, 25, "Print",ExpressionUUID->"884ddbde-e019-4b21-9d30-1686fb2ed4b2"],
Cell[247673, 3976, 829, 17, 25, "Print",ExpressionUUID->"cacbce31-0314-4ea2-9c5d-5e751a8bc159"],
Cell[248505, 3995, 584, 9, 25, "Print",ExpressionUUID->"607d9bc0-a569-4c8e-9517-1af30034eb08"],
Cell[249092, 4006, 766, 14, 25, "Print",ExpressionUUID->"34ddae1d-3430-4a99-89cd-2a2f9444a32c"],
Cell[249861, 4022, 617, 10, 25, "Print",ExpressionUUID->"5b4b6fc6-cd43-4b08-af90-6f4145053b6b"],
Cell[250481, 4034, 1100, 21, 25, "Print",ExpressionUUID->"a4806506-ee6b-409c-a8d3-8e7c5aa2d6c8"],
Cell[251584, 4057, 701, 13, 25, "Print",ExpressionUUID->"a3a9df77-e814-4434-8d1c-b027d1651c64"],
Cell[252288, 4072, 829, 17, 25, "Print",ExpressionUUID->"e417c644-5dab-4cdb-ba05-f57db487b309"],
Cell[253120, 4091, 586, 9, 25, "Print",ExpressionUUID->"a0c8cc8e-0c32-4369-9633-85c54e7480c9"],
Cell[253709, 4102, 766, 14, 25, "Print",ExpressionUUID->"f37e9678-6030-4372-8602-53c4cc6389c3"],
Cell[254478, 4118, 617, 10, 25, "Print",ExpressionUUID->"0b670c6d-5c22-4639-be50-a3b8bef269ea"],
Cell[255098, 4130, 1098, 21, 25, "Print",ExpressionUUID->"329d3197-aa81-4ed9-8bcd-09ef8273f937"],
Cell[256199, 4153, 701, 13, 25, "Print",ExpressionUUID->"005e8d61-1ef7-46ef-a7fe-76441aa6c0b3"],
Cell[256903, 4168, 1055, 20, 25, "Print",ExpressionUUID->"751bb160-27ef-4463-b10d-47e358f8e3a5"],
Cell[257961, 4190, 598, 9, 25, "Print",ExpressionUUID->"479fb835-47ec-4263-a7da-78bd5c5a4aa0"],
Cell[258562, 4201, 864, 18, 25, "Print",ExpressionUUID->"7efef4af-512b-46d0-9895-f4d5c9ed4c31"],
Cell[259429, 4221, 821, 17, 25, "Print",ExpressionUUID->"e25ab1b1-3dad-4958-a858-922d8c4a2e50"],
Cell[260253, 4240, 797, 14, 25, "Print",ExpressionUUID->"5481e6a4-fa79-4d3e-9ccb-dbd34c0f1eac"],
Cell[261053, 4256, 821, 17, 25, "Print",ExpressionUUID->"1b8f5c49-5ff0-4040-8b07-f88afd405ccb"],
Cell[261877, 4275, 785, 14, 25, "Print",ExpressionUUID->"ef841c61-47b6-4597-bf72-605b8bddc988"],
Cell[262665, 4291, 583, 9, 25, "Print",ExpressionUUID->"22a07015-46b2-4aac-87ec-e2278724a2ff"],
Cell[263251, 4302, 605, 10, 25, "Print",ExpressionUUID->"821ea0ab-76ef-43e5-8d9b-4f0a0d91735e"],
Cell[263859, 4314, 798, 14, 25, "Print",ExpressionUUID->"e2843305-4ffe-4500-80ca-9ff8c7252808"],
Cell[264660, 4330, 955, 17, 25, "Print",ExpressionUUID->"2202e99f-34aa-41d4-8df1-d1c07163f0a9"],
Cell[265618, 4349, 579, 9, 25, "Print",ExpressionUUID->"98fefb89-598b-4926-994f-c0a942f8fa90"],
Cell[266200, 4360, 952, 18, 70, "Print",ExpressionUUID->"e6b071f8-ed58-44dc-9982-9c329fc787df"],
Cell[267155, 4380, 562, 9, 25, "Print",ExpressionUUID->"3f20a490-c742-43fb-9e1f-8aa17f80d1c9"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

