(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    288859,       4695]
NotebookOptionsPosition[    278730,       4557]
NotebookOutlinePosition[    279163,       4574]
CellTagsIndexPosition[    279120,       4571]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.650775848525028*^9, 3.650775850862257*^9}, {
  3.656711800473441*^9, 3.6567118018571033`*^9}, {3.658229201849017*^9, 
  3.65822920320895*^9}},ExpressionUUID->"5ec45779-d10f-40a9-8b67-\
fa4ea1ab2938"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.650779245705666*^9, 
  3.6507792470409403`*^9}},ExpressionUUID->"a6951ce1-0ae0-45b0-a61e-\
1b9f0fab81d8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Dropbox/Work/PhysSoftware/feynrules-current/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM_noH.fr\>\"", ",", "\"\<LesHouchesModelFreezeIn-down.fr\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"(*", 
    RowBox[{
    "\"\<~/Work/PhysSoftware/feynrules-current/Models/SM/Massless.rst\>\"", 
     ","}], "*)"}], 
   "\"\<~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst\>\"", 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.504423447270249*^9, {3.507209594206577*^9, 3.507209600067323*^9}, {
   3.514799374048591*^9, 3.514799404330376*^9}, {3.515062647798441*^9, 
   3.515062653173225*^9}, {3.515135742551162*^9, 3.515135748404658*^9}, {
   3.551191781661876*^9, 3.551191796346917*^9}, {3.589877382659015*^9, 
   3.589877391686277*^9}, {3.589878062567462*^9, 3.589878067455187*^9}, {
   3.589878109496549*^9, 3.589878111197733*^9}, {3.59055306646451*^9, 
   3.590553091624037*^9}, 3.620364186079145*^9, 3.643521386632444*^9, {
   3.650775807478299*^9, 3.650775846833221*^9}, {3.6507763739543247`*^9, 
   3.650776383058586*^9}, {3.6507769890796022`*^9, 3.650776995383911*^9}, {
   3.650778402069853*^9, 3.650778402441492*^9}, {3.656688195123386*^9, 
   3.656688202507885*^9}, {3.656707591564633*^9, 3.656707593862214*^9}, {
   3.6567081194883204`*^9, 3.656708124503265*^9}, {3.656708347865992*^9, 
   3.656708348809312*^9}, 3.656708994015786*^9, {3.656711329669117*^9, 
   3.6567113577720737`*^9}, {3.656711432727879*^9, 3.6567114596044073`*^9}, {
   3.656711640746749*^9, 3.656711641778183*^9}, {3.656711895213398*^9, 
   3.656711899204385*^9}, {3.656838620561311*^9, 3.656838627830728*^9}, 
   3.662109534352394*^9, {3.666088203821269*^9, 3.666088204092046*^9}, {
   3.66610247441702*^9, 3.666102478615559*^9}, 3.7068777077767572`*^9, {
   3.7068789795632753`*^9, 3.706878984704603*^9}, {3.708339042321351*^9, 
   3.7083390466800632`*^9}, 3.7173095636637573`*^9, 3.731391282867195*^9, {
   3.73139232130669*^9, 3.731392321385263*^9}, {3.731585105617503*^9, 
   3.731585106171125*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"674a449c-ebe8-4afe-a89b-ed9cf8db3350"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434157303*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"9eda77d4-f941-49fb-a3c7-c055e4207b87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.2\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"31 May 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.2", " (" "31 May 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.7501354341592913`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e8d9b53e-f632-4a90-acff-bdd20ca1207b"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434161696*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"10b850b3-b67c-410f-9e8c-303161f37e00"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434163*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1bd2e8aa-7361-4c8b-bcf2-6b1e73c37554"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434164303*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b7ac9705-f676-4de4-b006-96a3ff1f5381"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434165662*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d22d26c4-3cf1-4c48-9d3a-a5e8cc4cbc19"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434167102*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ab984015-fe90-4c62-8ca5-f56571130ddf"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.7501354341684313`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"70e1415a-c546-48e7-8c94-952f2100b14b"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.7501354341697683`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a630566b-b252-4460-97a8-0b991e872131"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135434171051*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"269dbc60-441e-4cc6-8c08-ac8d2b2888c6"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.75013543417242*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"021496a6-3481-4812-922f-59ff2807ac78"],

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437060602*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f874e715-d9cb-4c90-a33b-dbb401b489a3"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.7501354371060677`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"77f690bf-f1a5-4036-a672-e4703e931f76"],

Cell[BoxData["\<\"Genevieve Belanger, Nishita Desai, Andreas Goudelis, Julia \
Harz, Andre Lessa, Jose Miguel No, Alexander Pukhov, Sezen Sekmen, Dipan \
Sengupta, Bryan Zaldivar, Jose Zurita\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437108593*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"395d132a-15d8-40d0-b79f-fa05306bac11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437110313*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"ba75c6a9-625d-44a0-8e72-6d403ddf315f"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437111848*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"49ed6d58-8e88-4949-be8b-a2926da2f5fe"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437113254*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a6767cf4-4479-4d8c-b1a2-0f986b6658d6"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.7501354371149483`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d9c34ed9-833e-48c2-87b5-2ec53b370f98"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437251403*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6f803133-91de-45d4-82f1-f2e9f8c2d982"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437288522*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"afb604ff-02db-43d0-9d6b-2b7b1d618523"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"LesHouchesModelFreezeIn-down\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "LesHouchesModelFreezeIn-down", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135437343595*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a1a45dbb-3d0b-4854-a3cf-11b7ce9b0369"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get","noopen",
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"~/Work/PhysSoftware/feynrules-current/Models/SM/\
DiagonalCKM.rst\\\\\\\"\\\"}]\\).\"",2,5,1,32416064100575972728,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.750135437469984*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a89248b6-30e5-40a7-bf50-e56ae9264094"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{8., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm[
  "Loading restrictions from ", 
   "~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.7501354383606358`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"85ee72d1-0977-4ae8-a4ca-d4b7780f6983"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.731585107990788*^9, 3.750135438464306*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"f77c04d3-0603-4980-be0a-ad2ae545aedc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checks", "Section",
 CellChangeTimes->{{3.6507792417995567`*^9, 
  3.650779242257778*^9}},ExpressionUUID->"7d7906c8-5fe7-4218-bd22-\
ea113896928e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LNP", "]"}]], "Input",
 CellChangeTimes->{{3.650779144898395*^9, 3.650779226197805*^9}, 
   3.6507796370351048`*^9, {3.6507799542733107`*^9, 3.650779954775826*^9}, 
   3.65670844124369*^9, {3.6567084734627542`*^9, 3.656708475077517*^9}, {
   3.6567086177844677`*^9, 3.65670861820015*^9}, {3.6567089657011833`*^9, 
   3.6567089669488373`*^9}, {3.656709000689712*^9, 3.6567090012231293`*^9}, {
   3.6567114398937197`*^9, 3.656711440036572*^9}, {3.7089385871933813`*^9, 
   3.708938588525648*^9}, {3.7089386630268517`*^9, 3.708938665030877*^9}, {
   3.712571481652707*^9, 3.7125714822191277`*^9}, {3.7125715566010723`*^9, 
   3.712571557139542*^9}, {3.712572886863242*^9, 3.7125729052131844`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"5598e096-9040-46e6-af0f-b29f2b844778"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731585116025855*^9, 
   3.7501354556272087`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"658ffe81-ebf5-4d60-9831-29b94a48c47c"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731585116025855*^9, 
   3.7501354556517076`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"843a5db9-041c-48a9-82ce-87dd66a223b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{G0, G0}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{G0, G0}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731585116025855*^9, 
   3.750135456296077*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"2615a545-e3ca-4be4-af59-25a1a9d1614b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{GP, GPbar}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{GP, GPbar}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731585116025855*^9, 
   3.75013545629757*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"254f308e-f818-4a38-9baf-2b389aa568df"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731585116025855*^9, 
   3.750135456339264*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"2d9e8ea1-9cf1-4a43-a5f4-51168820724b"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731585116025855*^9, 
   3.750135456340949*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"701c898d-4550-433c-89b6-82dc856eeadc"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"h", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Mu]", "H", "2"], "2"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          SubscriptBox["\[Lambda]", "H"], " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.00000000000001`", 
     "125.`"},
    {"s0", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         SubsuperscriptBox["\[Mu]", "s0", "2"], "2"], "-", 
        FractionBox[
         RowBox[{
          SubscriptBox["\[Lambda]", "s0h"], " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.`", "125.`"},
    {"HE", "mHE", "100.`", "100.`"},
    {"W", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.82435974619786`", 
     "79.82435974619784`"},
    {"Z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.18760000000003`", 
     "91.1876`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.731393295779994*^9, 3.731393366646595*^9, 
  3.731393443878311*^9, 3.73139356953161*^9, 3.731585116537828*^9, 
  3.750135456343605*^9},
 CellLabel->
  "Out[6]//TableForm=",ExpressionUUID->"4398fc55-131d-41bf-8783-e93ce3062176"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LNP", "]"}]], "Input",
 CellChangeTimes->{{3.662109944482068*^9, 3.662109949959669*^9}, {
  3.7070520925079317`*^9, 3.707052094151979*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"c62bc199-e9eb-4f32-97a4-34f206f6f63c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.750135458705085*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"772c469d-0e31-4c71-a9ec-9ab74a596021"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.75013545870691*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8a13662f-907c-4764-add6-333e191bbdf3"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.750135460682765*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ae948003-1e27-406c-97da-51504550c45f"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.750135460684115*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8a2b8561-d4fe-42bd-b7c3-2374f9f0c183"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.750135460759844*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b3cd25af-b8a9-45be-9156-1dc6c8ba3cc0"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.7501354607611856`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3427d716-8628-4e7a-a074-71d8cfd671ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.750135460762467*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8d7e3f34-a94e-4e59-8cf7-5a09ab3d01a3"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.7315851209959497`*^9, 
   3.750135460763487*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"616f6a01-ddb6-414f-b377-9c164c58b2b4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.662109951378407*^9, 3.662110049947618*^9, 3.6621100998351517`*^9, 
   3.662110230328856*^9, 3.662110556605912*^9, 3.6621115659622173`*^9, 
   3.662111691085476*^9, 3.662111987347905*^9, 3.662299837179309*^9, 
   3.662460270761208*^9, 3.662461076456791*^9, 3.662461176813862*^9, 
   3.66609470427413*^9, 3.6660947832833767`*^9, 3.666094824582155*^9, 
   3.6660948890397797`*^9, 3.6660949420967913`*^9, 3.6660950405602217`*^9, 
   3.6660950807879753`*^9, {3.6660958916258173`*^9, 3.6660959206518106`*^9}, {
   3.666095970622983*^9, 3.666096022386922*^9}, 3.666096209735268*^9, 
   3.6660964517873077`*^9, 3.666096506736858*^9, 3.6660968019201097`*^9, 
   3.6660971258492203`*^9, 3.666097216165155*^9, 3.66609749119268*^9, 
   3.666098649761964*^9, 3.6660990864511538`*^9, 3.666105647539627*^9, 
   3.6661056995078573`*^9, 3.666105777441723*^9, 3.666106138783424*^9, 
   3.666106326347747*^9, 3.666106927863018*^9, 3.666106986378415*^9, 
   3.6661074988713627`*^9, 3.666107542812337*^9, 3.666107781108523*^9, 
   3.666108203122014*^9, 3.6661083033618193`*^9, 3.666108641518971*^9, 
   3.666108816209578*^9, 3.66610896823496*^9, 3.66611007525498*^9, 
   3.666162980783061*^9, 3.666172837677167*^9, 3.666173554435424*^9, 
   3.6661736283472443`*^9, 3.666256565913422*^9, 3.6662569898703337`*^9, 
   3.666257037252726*^9, 3.6662582852313557`*^9, 3.6938355927370863`*^9, 
   3.706879144695354*^9, 3.7068792163020782`*^9, 3.706879307338579*^9, 
   3.706879399543598*^9, 3.707020692581769*^9, 3.70702087142515*^9, 
   3.7070209592958384`*^9, 3.707115326899603*^9, 3.7083426979576273`*^9, 
   3.7084105585559053`*^9, 3.7086883139925613`*^9, 3.7087830944199944`*^9, 
   3.708786137420226*^9, 3.708786280387837*^9, 3.708844254882721*^9, 
   3.708857134449316*^9, 3.7088572393670397`*^9, 3.708857311628956*^9, 
   3.7088574157731037`*^9, 3.708941773070489*^9, 3.712572932788961*^9, 
   3.712573127822146*^9, 3.71730993581514*^9, 3.717310022535645*^9, 
   3.717312612968665*^9, 3.717312726629593*^9, 3.717313051510038*^9, 
   3.717316883915576*^9, 3.717319594879335*^9, 3.7173200150136013`*^9, 
   3.717320659913966*^9, 3.717320780219535*^9, 3.717330184859136*^9, 
   3.717330430788595*^9, 3.717337025527526*^9, 3.7190291399198008`*^9, 
   3.731391299355544*^9, 3.7313923599209414`*^9, 3.731392657786044*^9, 
   3.7313929370039263`*^9, 3.7313933019081173`*^9, 3.731393370270252*^9, 
   3.731393447813367*^9, 3.731393574969151*^9, 3.731585122470602*^9, 
   3.7501354607643642`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"5cf2925c-9593-4116-b632-412e4d778a67"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interfaces", "Section",
 CellChangeTimes->{{3.650782302772278*^9, 
  3.6507823065682487`*^9}},ExpressionUUID->"e7413e10-883c-496f-94ea-\
d252a70b9204"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteCHOutput", "[", 
  RowBox[{"LSM", ",", "LNP"}], "]"}]], "Input",
 CellChangeTimes->{{3.6242538526978188`*^9, 3.624253855246005*^9}, {
   3.6242539619622*^9, 3.624253962288993*^9}, 3.6435484136339283`*^9, {
   3.650782323830791*^9, 3.650782325054451*^9}, {3.6508794326823387`*^9, 
   3.650879434504023*^9}, {3.656697807213163*^9, 3.656697807404377*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"58eaf90f-6270-4e21-91b6-eb88bb862e68"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBtNbXxGsXPrx2BACJd8d9
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f364b2f7-6617-4917-a737-cc02e65d534f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9E/5pGsXPrx2BACKG8d3
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"0dfe2a85-e88c-43cf-8bea-bfa65bca18bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9Bv9pGsXPrx2BACKI8d6
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"89f999bc-2bef-4987-95df-dac8d90b9eb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/home/andrikos/Dropbox/LH_LLPs_freezein/andreas/\
ColliderFriendlyFreezeInModels-FRpage/LesHouchesModelFreezeIn-down/\
LesHouchesModelFreezeIn-down-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/home/andrikos/Dropbox/LH_LLPs_freezein/andreas/\
ColliderFriendlyFreezeInModels-FRpage/LesHouchesModelFreezeIn-down/\
LesHouchesModelFreezeIn-down-CH."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBNJ910rULH147AgCDh8ao
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"16b5927d-b425-4828-897e-c1536cac74e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9BeXpGsXPrx2BACK9seX
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"3c7bbc31-a605-4270-8b33-1f867a07e5b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9KKE5GsXPrx2BACJMMdi
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"89a133fb-fa24-48c7-a15a-5e5959733201"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBdHh28rULH147AgCHJcci
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"cd008a7d-d469-42a2-9ab8-d6ac857925d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9MeS5GsXPrx2BACMNMfF
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"2b379f9c-2509-4194-826c-38d9f7e6256f"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBdGxN8rULH147AgCHzMc5
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"7c88103d-e9d3-49fc-bd6b-37fe65ad49a9"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBtNbejGsXPrx2BACIGcdM
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d802caa9-33ec-4ad9-9371-501ae5b4817f"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBNMuJjGsXPrx2BACHNscx
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"082d90dd-9bab-40c6-840b-8d6550e0c21f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBNNvljGsXPrx2BACHk8c+
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"1d8f5106-b96e-4c75-a4d1-732f48f208dc"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9LKdgdcvfHjtCACLWMeu
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"dfce685a-74ab-4611-9f28-d97b39c79881"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "112", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "112", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  112, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 112, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBtFNV8PULH147AgCGi8cN
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b4a44fa8-3942-4b5c-bc93-d0f1cdbee745"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"107", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[107, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9C2LW9cvfHjtCACMp8fq
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d5163870-1797-4806-8291-bc7cfad0610d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "107"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 107],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9CxDvRsXPrx2BACGc8b4
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d6e6199d-780f-4ff9-b92f-94d421aae92c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBdNMezZsXPrx2BACJZ8dn
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"266f7875-b562-47ad-8b29-0a83b2d6291a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBtHPYgZsXPrx2BACIL8dZ
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"9393171e-7ba8-4211-ab80-67f732e051bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOBdN+bQzcvfHjtCACOrcg8
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b07cfbed-b641-4dea-8519-74c5450e86b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.45min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.45min!"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikQ/La+fOB9Cv2wzcvfHjtCACLUMe0
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"da6f572f-a565-43a7-8809-13c364dd2a99"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", ",", "LNP"}], "]"}]], "Input",
 CellChangeTimes->{{3.515066451500599*^9, 3.51506645766863*^9}, {
   3.515066553825666*^9, 3.515066567557489*^9}, {3.517657052212844*^9, 
   3.5176570535784883`*^9}, {3.517657087674789*^9, 3.5176570975167933`*^9}, {
   3.517657162889937*^9, 3.517657189106102*^9}, {3.62036438703964*^9, 
   3.620364399043768*^9}, 3.643548416121323*^9, {3.650782333532228*^9, 
   3.650782334611961*^9}, {3.6508794376715517`*^9, 3.650879441489379*^9}, {
   3.656697825115713*^9, 3.65669782525168*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"b4dde509-82ce-4dc0-93c3-0bb8f493b4f4"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135506340692*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"8fde20d0-2b9b-46f7-8ada-b42550dfc79b"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355066994867`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"05fdb0b8-1c20-4c1c-a0e3-ee636df17a8e"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135506701222*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"7dc5c6ee-f8f7-4c19-bc93-edc86524d315"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135506702483*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"703cd303-fd03-4cdc-88ad-214b7366d135"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355118394814`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"32b49705-8fcc-485d-b85b-e554dccebc5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "60", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "60", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  60, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 60, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135511882449*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"90d82407-9ee3-49c6-938b-350ddbf90271"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"55", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[55, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135515206965*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"6cd7e1ce-2f2c-4c44-9cf4-2a6d6ad08bbb"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135515216125*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"4e0c25fb-ce8c-4ddf-996d-0b613f2bc3f0"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135515217719*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"9eb6a956-249d-41e7-86a9-2816c3d2feb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135515219459*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"ff7a848e-ab61-4873-8929-8740edcda49f"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355175984707`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"7846279b-3657-4b57-9f87-a38618812e01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "52", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "52", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  52, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 52, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135517614006*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"3ead18c1-2039-4e3c-9ef3-ec859404e25a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"52", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[52, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355191372213`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"b1ad4b93-0b40-4828-b68a-2d402eeb553a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "107"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 107],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135521841598*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"78455a50-6882-425e-bfc2-09a7d2e8029e"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.75013552936511*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"47827c37-39fa-4f12-97c0-0562da231bdd"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355294116583`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"3365ce28-f1b8-4015-8d32-76000c8d3e6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "56"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 56],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135529475399*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"707b8cd2-80d4-4884-a989-4af1a2adc799"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "4.802528`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 4.802528, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135538717163*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"6704a95c-4622-4a08-ac60-76ed36bc6a34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "71"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 71],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135538765072*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"ddcc3456-72bb-4f21-ae35-9aa898a39d73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "1.286674`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 1.286674, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135540378521*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"e3455695-dbd3-403e-b982-ca7f28124951"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355403819427`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"2dc5a4d9-9daf-4c31-bcb3-3a0796269af2"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135540647472*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"c1dd505e-ebd8-4ea1-8b10-4dcf87938fe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135540683807*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"843f4385-2daa-4247-ad7e-1e6f4f00b1c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "177", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 177, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.7501355427542562`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"eeb957ca-4f47-4be5-b281-ef78dc861f28"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135542954023*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"36975beb-59ec-4efc-bd05-eb0c121fbaf8"],

Cell[BoxData[
 StyleBox["\<\"Warning: Non positive interaction order QED.\\n                \
This might reduce the efficiency of certain matrix element generators.\\n     \
           See logfile for more details.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135543086966*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"90c9f193-1f84-4630-97c7-d98dafc7975d"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.731585169068914*^9, 3.750135543230048*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"b012159f-5697-42f2-b6cc-54303dd050ec"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1855, 1056},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"11.3 for Linux x86 (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 274, 5, 31, "Input",ExpressionUUID->"5ec45779-d10f-40a9-8b67-fa4ea1ab2938"],
Cell[CellGroupData[{
Cell[844, 29, 152, 3, 68, "Section",ExpressionUUID->"a6951ce1-0ae0-45b0-a61e-1b9f0fab81d8"],
Cell[CellGroupData[{
Cell[1021, 36, 2457, 48, 124, "Input",ExpressionUUID->"674a449c-ebe8-4afe-a89b-ed9cf8db3350"],
Cell[CellGroupData[{
Cell[3503, 88, 8385, 118, 25, "Print",ExpressionUUID->"9eda77d4-f941-49fb-a3c7-c055e4207b87"],
Cell[11891, 208, 8656, 125, 25, "Print",ExpressionUUID->"e8d9b53e-f632-4a90-acff-bdd20ca1207b"],
Cell[20550, 335, 8437, 119, 25, "Print",ExpressionUUID->"10b850b3-b67c-410f-9e8c-303161f37e00"],
Cell[28990, 456, 8368, 118, 25, "Print",ExpressionUUID->"1bd2e8aa-7361-4c8b-bcf2-6b1e73c37554"],
Cell[37361, 576, 8382, 118, 25, "Print",ExpressionUUID->"b7ac9705-f676-4de4-b006-96a3ff1f5381"],
Cell[45746, 696, 8434, 119, 25, "Print",ExpressionUUID->"d22d26c4-3cf1-4c48-9d3a-a5e8cc4cbc19"],
Cell[54183, 817, 8434, 119, 25, "Print",ExpressionUUID->"ab984015-fe90-4c62-8ca5-f56571130ddf"],
Cell[62620, 938, 8373, 118, 25, "Print",ExpressionUUID->"70e1415a-c546-48e7-8c94-952f2100b14b"],
Cell[70996, 1058, 8403, 118, 25, "Print",ExpressionUUID->"a630566b-b252-4460-97a8-0b991e872131"],
Cell[79402, 1178, 8371, 118, 25, "Print",ExpressionUUID->"269dbc60-441e-4cc6-8c08-ac8d2b2888c6"],
Cell[87776, 1298, 8437, 119, 25, "Print",ExpressionUUID->"021496a6-3481-4812-922f-59ff2807ac78"],
Cell[96216, 1419, 8392, 118, 25, "Print",ExpressionUUID->"f874e715-d9cb-4c90-a33b-dbb401b489a3"],
Cell[104611, 1539, 8412, 118, 25, "Print",ExpressionUUID->"77f690bf-f1a5-4036-a672-e4703e931f76"],
Cell[113026, 1659, 8543, 120, 25, "Print",ExpressionUUID->"395d132a-15d8-40d0-b79f-fa05306bac11"],
Cell[121572, 1781, 8516, 122, 25, "Print",ExpressionUUID->"ba75c6a9-625d-44a0-8e72-6d403ddf315f"],
Cell[130091, 1905, 8418, 119, 25, "Print",ExpressionUUID->"49ed6d58-8e88-4949-be8b-a2926da2f5fe"],
Cell[138512, 2026, 8370, 118, 25, "Print",ExpressionUUID->"a6767cf4-4479-4d8c-b1a2-0f986b6658d6"],
Cell[146885, 2146, 8402, 118, 25, "Print",ExpressionUUID->"d9c34ed9-833e-48c2-87b5-2ec53b370f98"],
Cell[155290, 2266, 8403, 118, 25, "Print",ExpressionUUID->"6f803133-91de-45d4-82f1-f2e9f8c2d982"],
Cell[163696, 2386, 8401, 118, 25, "Print",ExpressionUUID->"afb604ff-02db-43d0-9d6b-2b7b1d618523"],
Cell[172100, 2506, 8614, 124, 48, "Print",ExpressionUUID->"a1a45dbb-3d0b-4854-a3cf-11b7ce9b0369"]
}, Open  ]],
Cell[180729, 2633, 406, 10, 22, "Message",ExpressionUUID->"a89248b6-30e5-40a7-bf50-e56ae9264094"],
Cell[CellGroupData[{
Cell[181160, 2647, 8967, 131, 25, "Print",ExpressionUUID->"85ee72d1-0977-4ae8-a4ca-d4b7780f6983"],
Cell[190130, 2780, 8390, 118, 25, "Print",ExpressionUUID->"f77c04d3-0603-4980-be0a-ad2ae545aedc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198581, 2905, 153, 3, 68, "Section",ExpressionUUID->"7d7906c8-5fe7-4218-bd22-ea113896928e"],
Cell[CellGroupData[{
Cell[198759, 2912, 822, 11, 31, "Input",ExpressionUUID->"5598e096-9040-46e6-af0f-b29f2b844778"],
Cell[CellGroupData[{
Cell[199606, 2927, 1441, 25, 25, "Print",ExpressionUUID->"658ffe81-ebf5-4d60-9831-29b94a48c47c"],
Cell[201050, 2954, 1218, 19, 25, "Print",ExpressionUUID->"843a5db9-041c-48a9-82ce-87dd66a223b3"],
Cell[202271, 2975, 1482, 27, 25, "Print",ExpressionUUID->"2615a545-e3ca-4be4-af59-25a1a9d1614b"],
Cell[203756, 3004, 1487, 27, 25, "Print",ExpressionUUID->"254f308e-f818-4a38-9baf-2b389aa568df"],
Cell[205246, 3033, 1210, 19, 25, "Print",ExpressionUUID->"2d9e8ea1-9cf1-4a43-a5f4-51168820724b"],
Cell[206459, 3054, 1251, 20, 25, "Print",ExpressionUUID->"701c898d-4550-433c-89b6-82dc856eeadc"]
}, Open  ]],
Cell[207725, 3077, 2646, 80, 271, "Output",ExpressionUUID->"4398fc55-131d-41bf-8783-e93ce3062176"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210408, 3162, 266, 4, 31, "Input",ExpressionUUID->"c62bc199-e9eb-4f32-97a4-34f206f6f63c"],
Cell[CellGroupData[{
Cell[210699, 3170, 2699, 40, 25, "Print",ExpressionUUID->"772c469d-0e31-4c71-a9ec-9ab74a596021"],
Cell[213401, 3212, 2694, 40, 25, "Print",ExpressionUUID->"8a13662f-907c-4764-add6-333e191bbdf3"],
Cell[216098, 3254, 2890, 47, 25, "Print",ExpressionUUID->"ae948003-1e27-406c-97da-51504550c45f"],
Cell[218991, 3303, 2645, 39, 25, "Print",ExpressionUUID->"8a2b8561-d4fe-42bd-b7c3-2374f9f0c183"],
Cell[221639, 3344, 2678, 40, 25, "Print",ExpressionUUID->"b3cd25af-b8a9-45be-9156-1dc6c8ba3cc0"],
Cell[224320, 3386, 2638, 39, 25, "Print",ExpressionUUID->"3427d716-8628-4e7a-a074-71d8cfd671ea"],
Cell[226961, 3427, 2758, 43, 25, "Print",ExpressionUUID->"8d7e3f34-a94e-4e59-8cf7-5a09ab3d01a3"],
Cell[229722, 3472, 2646, 39, 25, "Print",ExpressionUUID->"616f6a01-ddb6-414f-b377-9c164c58b2b4"]
}, Open  ]],
Cell[232383, 3514, 2614, 38, 35, "Output",ExpressionUUID->"5cf2925c-9593-4116-b632-412e4d778a67"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[235046, 3558, 157, 3, 68, "Section",ExpressionUUID->"e7413e10-883c-496f-94ea-d252a70b9204"],
Cell[CellGroupData[{
Cell[235228, 3565, 459, 7, 31, "Input",ExpressionUUID->"58eaf90f-6270-4e21-91b6-eb88bb862e68"],
Cell[CellGroupData[{
Cell[235712, 3576, 694, 13, 25, "Print",ExpressionUUID->"f364b2f7-6617-4917-a737-cc02e65d534f"],
Cell[236409, 3591, 1135, 27, 25, "Print",ExpressionUUID->"0dfe2a85-e88c-43cf-8bea-bfa65bca18bb"],
Cell[237547, 3620, 1127, 27, 25, "Print",ExpressionUUID->"89f999bc-2bef-4987-95df-dac8d90b9eb3"],
Cell[238677, 3649, 1369, 34, 48, "Print",ExpressionUUID->"16b5927d-b425-4828-897e-c1536cac74e6"],
Cell[240049, 3685, 1099, 27, 48, "Print",ExpressionUUID->"3c7bbc31-a605-4270-8b33-1f867a07e5b2"],
Cell[241151, 3714, 1113, 27, 48, "Print",ExpressionUUID->"89a133fb-fa24-48c7-a15a-5e5959733201"],
Cell[242267, 3743, 1113, 27, 48, "Print",ExpressionUUID->"cd008a7d-d469-42a2-9ab8-d6ac857925d3"],
Cell[243383, 3772, 1113, 27, 48, "Print",ExpressionUUID->"2b379f9c-2509-4194-826c-38d9f7e6256f"],
Cell[244499, 3801, 649, 13, 25, "Print",ExpressionUUID->"7c88103d-e9d3-49fc-bd6b-37fe65ad49a9"],
Cell[245151, 3816, 921, 21, 25, "Print",ExpressionUUID->"d802caa9-33ec-4ad9-9371-501ae5b4817f"],
Cell[246075, 3839, 676, 13, 25, "Print",ExpressionUUID->"082d90dd-9bab-40c6-840b-8d6550e0c21f"],
Cell[246754, 3854, 858, 18, 25, "Print",ExpressionUUID->"1d8f5106-b96e-4c75-a4d1-732f48f208dc"],
Cell[247615, 3874, 709, 14, 25, "Print",ExpressionUUID->"dfce685a-74ab-4611-9f28-d97b39c79881"],
Cell[248327, 3890, 1194, 25, 25, "Print",ExpressionUUID->"b4a44fa8-3942-4b5c-bc93-d0f1cdbee745"],
Cell[249524, 3917, 793, 17, 25, "Print",ExpressionUUID->"d5163870-1797-4806-8291-bc7cfad0610d"],
Cell[250320, 3936, 1147, 24, 25, "Print",ExpressionUUID->"d6e6199d-780f-4ff9-b92f-94d421aae92c"],
Cell[251470, 3962, 1306, 31, 70, "Print",ExpressionUUID->"266f7875-b562-47ad-8b29-0a83b2d6291a"],
Cell[252779, 3995, 1099, 27, 48, "Print",ExpressionUUID->"9393171e-7ba8-4211-ab80-67f732e051bc"],
Cell[253881, 4024, 1112, 27, 25, "Print",ExpressionUUID->"b07cfbed-b641-4dea-8519-74c5450e86b1"],
Cell[254996, 4053, 1057, 27, 48, "Print",ExpressionUUID->"da6f572f-a565-43a7-8809-13c364dd2a99"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256102, 4086, 649, 10, 31, "Input",ExpressionUUID->"b4dde509-82ce-4dc0-93c3-0bb8f493b4f4"],
Cell[CellGroupData[{
Cell[256776, 4100, 653, 11, 25, "Print",ExpressionUUID->"8fde20d0-2b9b-46f7-8ada-b42550dfc79b"],
Cell[257432, 4113, 878, 18, 25, "Print",ExpressionUUID->"05fdb0b8-1c20-4c1c-a0e3-ee636df17a8e"],
Cell[258313, 4133, 631, 10, 25, "Print",ExpressionUUID->"7dc5c6ee-f8f7-4c19-bc93-edc86524d315"],
Cell[258947, 4145, 813, 15, 25, "Print",ExpressionUUID->"703cd303-fd03-4cdc-88ad-214b7366d135"],
Cell[259763, 4162, 666, 11, 25, "Print",ExpressionUUID->"32b49705-8fcc-485d-b85b-e554dccebc5c"],
Cell[260432, 4175, 1145, 22, 25, "Print",ExpressionUUID->"90d82407-9ee3-49c6-938b-350ddbf90271"],
Cell[261580, 4199, 746, 14, 25, "Print",ExpressionUUID->"6cd7e1ce-2f2c-4c44-9cf4-2a6d6ad08bbb"],
Cell[262329, 4215, 876, 18, 25, "Print",ExpressionUUID->"4e0c25fb-ce8c-4ddf-996d-0b613f2bc3f0"],
Cell[263208, 4235, 631, 10, 25, "Print",ExpressionUUID->"9eb6a956-249d-41e7-86a9-2816c3d2feb8"],
Cell[263842, 4247, 813, 15, 25, "Print",ExpressionUUID->"ff7a848e-ab61-4873-8929-8740edcda49f"],
Cell[264658, 4264, 666, 11, 25, "Print",ExpressionUUID->"7846279b-3657-4b57-9f87-a38618812e01"],
Cell[265327, 4277, 1145, 22, 25, "Print",ExpressionUUID->"3ead18c1-2039-4e3c-9ef3-ec859404e25a"],
Cell[266475, 4301, 748, 14, 25, "Print",ExpressionUUID->"b1ad4b93-0b40-4828-b68a-2d402eeb553a"],
Cell[267226, 4317, 1102, 21, 25, "Print",ExpressionUUID->"78455a50-6882-425e-bfc2-09a7d2e8029e"],
Cell[268331, 4340, 644, 10, 25, "Print",ExpressionUUID->"47827c37-39fa-4f12-97c0-0562da231bdd"],
Cell[268978, 4352, 914, 19, 25, "Print",ExpressionUUID->"3365ce28-f1b8-4015-8d32-76000c8d3e6d"],
Cell[269895, 4373, 866, 18, 25, "Print",ExpressionUUID->"707b8cd2-80d4-4884-a989-4af1a2adc799"],
Cell[270764, 4393, 844, 15, 25, "Print",ExpressionUUID->"6704a95c-4622-4a08-ac60-76ed36bc6a34"],
Cell[271611, 4410, 866, 18, 25, "Print",ExpressionUUID->"ddcc3456-72bb-4f21-ae35-9aa898a39d73"],
Cell[272480, 4430, 830, 15, 25, "Print",ExpressionUUID->"e3455695-dbd3-403e-b982-ca7f28124951"],
Cell[273313, 4447, 630, 10, 25, "Print",ExpressionUUID->"2dc5a4d9-9daf-4c31-bcb3-3a0796269af2"],
Cell[273946, 4459, 652, 11, 25, "Print",ExpressionUUID->"c1dd505e-ebd8-4ea1-8b10-4dcf87938fe2"],
Cell[274601, 4472, 843, 15, 25, "Print",ExpressionUUID->"843f4385-2daa-4247-ad7e-1e6f4f00b1c5"],
Cell[275447, 4489, 1004, 18, 25, "Print",ExpressionUUID->"eeb957ca-4f47-4be5-b281-ef78dc861f28"],
Cell[276454, 4509, 624, 10, 25, "Print",ExpressionUUID->"36975beb-59ec-4efc-bd05-eb0c121fbaf8"],
Cell[277081, 4521, 997, 19, 70, "Print",ExpressionUUID->"90c9f193-1f84-4630-97c7-d98dafc7975d"],
Cell[278081, 4542, 609, 10, 25, "Print",ExpressionUUID->"b012159f-5697-42f2-b6cc-54303dd050ec"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

