(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    288743,       4691]
NotebookOptionsPosition[    278615,       4553]
NotebookOutlinePosition[    279048,       4570]
CellTagsIndexPosition[    279005,       4567]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.650775848525028*^9, 3.650775850862257*^9}, {
  3.656711800473441*^9, 3.6567118018571033`*^9}, {3.658229201849017*^9, 
  3.65822920320895*^9}},ExpressionUUID->"5ec45779-d10f-40a9-8b67-\
fa4ea1ab2938"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.650779245705666*^9, 
  3.6507792470409403`*^9}},ExpressionUUID->"a6951ce1-0ae0-45b0-a61e-\
1b9f0fab81d8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", 
    "\"\<~/Dropbox/Work/PhysSoftware/feynrules-current/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM_noH.fr\>\"", ",", "\"\<LesHouchesModelFreezeIn-up.fr\>\""}],
   "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"(*", 
    RowBox[{
    "\"\<~/Work/PhysSoftware/feynrules-current/Models/SM/Massless.rst\>\"", 
     ","}], "*)"}], 
   "\"\<~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst\>\"", 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.504423447270249*^9, {3.507209594206577*^9, 3.507209600067323*^9}, {
   3.514799374048591*^9, 3.514799404330376*^9}, {3.515062647798441*^9, 
   3.515062653173225*^9}, {3.515135742551162*^9, 3.515135748404658*^9}, {
   3.551191781661876*^9, 3.551191796346917*^9}, {3.589877382659015*^9, 
   3.589877391686277*^9}, {3.589878062567462*^9, 3.589878067455187*^9}, {
   3.589878109496549*^9, 3.589878111197733*^9}, {3.59055306646451*^9, 
   3.590553091624037*^9}, 3.620364186079145*^9, 3.643521386632444*^9, {
   3.650775807478299*^9, 3.650775846833221*^9}, {3.6507763739543247`*^9, 
   3.650776383058586*^9}, {3.6507769890796022`*^9, 3.650776995383911*^9}, {
   3.650778402069853*^9, 3.650778402441492*^9}, {3.656688195123386*^9, 
   3.656688202507885*^9}, {3.656707591564633*^9, 3.656707593862214*^9}, {
   3.6567081194883204`*^9, 3.656708124503265*^9}, {3.656708347865992*^9, 
   3.656708348809312*^9}, 3.656708994015786*^9, {3.656711329669117*^9, 
   3.6567113577720737`*^9}, {3.656711432727879*^9, 3.6567114596044073`*^9}, {
   3.656711640746749*^9, 3.656711641778183*^9}, {3.656711895213398*^9, 
   3.656711899204385*^9}, {3.656838620561311*^9, 3.656838627830728*^9}, 
   3.662109534352394*^9, {3.666088203821269*^9, 3.666088204092046*^9}, {
   3.66610247441702*^9, 3.666102478615559*^9}, 3.7068777077767572`*^9, {
   3.7068789795632753`*^9, 3.706878984704603*^9}, {3.708339042321351*^9, 
   3.7083390466800632`*^9}, 3.7173095636637573`*^9, 3.731391282867195*^9, {
   3.73139232130669*^9, 3.731392321385263*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"674a449c-ebe8-4afe-a89b-ed9cf8db3350"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361458809023`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"47376186-5a76-47d8-9508-598daf6695bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.2\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"31 May 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.2", " (" "31 May 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136145882741*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e81cedda-5ad6-42c6-b410-8a07dc8029f9"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.75013614588551*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3a1ad39e-e02d-46bc-8ca8-0ae507ca6e30"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136145886962*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"08f275d6-9c07-471f-ba0a-9cf0c236c8ad"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361458884087`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7250eba6-f985-420b-9364-2a017fa5b95f"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361458899593`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c3cb145e-a0ba-4581-ba63-1870cf0a6594"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136145891466*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0c580dae-1bb0-46d0-9581-d9ea96c785ee"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136145892899*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a6abd289-4db8-4324-8f84-176bfbc18cba"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.75013614589429*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"17784336-ba2b-4840-bbe4-306ee73378a8"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136145895286*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"9e58a76e-9bbc-420b-8de0-ea5ea8fae41d"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136145896372*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1b20928f-f81f-4dd4-bff3-853c0bb77bec"],

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136148940563*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7ef60dbf-e8a2-4b93-b7e4-98bf21ce448e"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136148968053*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"009ae989-851d-4e56-b916-0973d379eeca"],

Cell[BoxData["\<\"Genevieve Belanger, Nishita Desai, Andreas Goudelis, Julia \
Harz, Andre Lessa, Jose Miguel No, Alexander Pukhov, Sezen Sekmen, Dipan \
Sengupta, Bryan Zaldivar, Jose Zurita\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361489694757`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"091961ef-2951-4045-b052-f02791980993"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136148970845*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e728ac0f-c6db-41c9-b2de-7d7c9785e57a"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136148972122*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"fad0f89f-325c-4391-8638-88a6055dfcf8"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361489733467`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"e92d1ca0-b39d-4c72-920b-33b5d68e54ee"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136148974778*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"9022c4ab-432b-459a-a48c-022d1537ee85"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136149122037*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"cc4990ca-825d-430e-87f8-f1ad70ecd216"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361491464443`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c045f0b4-3cb1-42d8-9e1a-3f9f99e507a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"LesHouchesModelFreezeIn-up\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "LesHouchesModelFreezeIn-up", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.75013614921139*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dd53db7c-824c-4d0c-9a15-720920bf9709"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Get","noopen",
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"~/Work/PhysSoftware/feynrules-current/Models/SM/\
DiagonalCKM.rst\\\\\\\"\\\"}]\\).\"",2,5,1,32416068865407926916,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.750136149323121*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"bf685a14-6d70-4644-975d-88cccf791d8a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", \
"\<\"~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{8., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "0"}],
  SequenceForm[
  "Loading restrictions from ", 
   "~/Work/PhysSoftware/feynrules-current/Models/SM/DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.7501361502439337`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"05fb31a6-229e-449b-9208-388de0dd603f"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{{3.650778390689226*^9, 3.650778405274962*^9}, {
   3.650778449256279*^9, 3.6507784646421947`*^9}, 3.650779031544446*^9, {
   3.650779081894877*^9, 3.6507790998784857`*^9}, 3.650779237029664*^9, 
   3.650779336214197*^9, 3.650779470031231*^9, {3.650779579449168*^9, 
   3.650779601418454*^9}, 3.650779868134864*^9, 3.650779929752392*^9, 
   3.6507804501233463`*^9, 3.650780491006068*^9, 3.650780601878729*^9, 
   3.6507807613756237`*^9, 3.650780911209879*^9, 3.6507810583108664`*^9, 
   3.65078172225025*^9, 3.650781776043808*^9, 3.6507820387185163`*^9, 
   3.650782141619762*^9, 3.650879292922963*^9, 3.6508794227562428`*^9, 
   3.656688205898918*^9, 3.656698160658053*^9, {3.656707597932906*^9, 
   3.65670761261903*^9}, 3.656707823300315*^9, 3.656707905585382*^9, 
   3.656707945653792*^9, {3.6567079814797573`*^9, 3.656708019948929*^9}, {
   3.656708124732604*^9, 3.656708133783574*^9}, 3.656708211442645*^9, 
   3.6567083493245287`*^9, 3.656708752389554*^9, 3.65670884404949*^9, 
   3.656708914803637*^9, {3.656708991222938*^9, 3.65670899829044*^9}, 
   3.656711349891283*^9, 3.656711383161908*^9, {3.656711427789394*^9, 
   3.6567114630074463`*^9}, {3.656711629295726*^9, 3.656711645740097*^9}, 
   3.656711805356144*^9, 3.6567118994743147`*^9, 3.656711934712439*^9, 
   3.656838631070702*^9, 3.656934972555221*^9, 3.656935304013435*^9, 
   3.656935688611961*^9, 3.656936100044401*^9, 3.65693631647514*^9, 
   3.657001949534729*^9, 3.657545005732752*^9, 3.6579701221970243`*^9, 
   3.657970272893396*^9, 3.657970454613255*^9, {3.6582288765009537`*^9, 
   3.658228941203725*^9}, 3.658229022150999*^9, {3.658229064098349*^9, 
   3.658229090988328*^9}, {3.658229141173667*^9, 3.658229162652519*^9}, 
   3.658229207100018*^9, 3.658229313625429*^9, 3.65822949968688*^9, 
   3.658571253361657*^9, 3.662109539297909*^9, 3.66210979742028*^9, 
   3.662109828974708*^9, 3.662109896001733*^9, 3.662110043583807*^9, {
   3.662110089361968*^9, 3.662110116922476*^9}, 3.662110472765123*^9, 
   3.662110548984344*^9, 3.662111559935062*^9, 3.662111682464838*^9, 
   3.6621119777803802`*^9, 3.66229982813647*^9, 3.662460264024168*^9, 
   3.662461068906213*^9, 3.662461171149035*^9, {3.662461691421184*^9, 
   3.662461696298691*^9}, 3.6624620397838707`*^9, {3.664012782416032*^9, 
   3.66401281211222*^9}, 3.665583212149569*^9, {3.666088192556732*^9, 
   3.666088217145042*^9}, {3.66609465805514*^9, 3.6660946731207523`*^9}, 
   3.666094775657896*^9, 3.666094817921084*^9, 3.666094882453017*^9, 
   3.666094934817461*^9, 3.666095032335832*^9, 3.6660950746312027`*^9, {
   3.6660958852388287`*^9, 3.6660959142560177`*^9}, {3.666095961612997*^9, 
   3.666096014678405*^9}, 3.6660962027015047`*^9, 3.66609644574125*^9, 
   3.666096501862561*^9, 3.666096795103121*^9, 3.666097116751132*^9, {
   3.666097192137705*^9, 3.6660972089057007`*^9}, 3.666097285929289*^9, 
   3.6660974836023083`*^9, 3.666098643624137*^9, 3.666098813110757*^9, 
   3.666098914245557*^9, 3.666099074144917*^9, {3.6661056203452168`*^9, 
   3.666105641461576*^9}, 3.666105693788805*^9, 3.666105770572324*^9, 
   3.6661061334998493`*^9, 3.666106320055026*^9, 3.666106721745861*^9, 
   3.666106921709633*^9, 3.666106976301322*^9, 3.666107488326663*^9, 
   3.6661075330766897`*^9, 3.666107770007831*^9, 3.666108185999193*^9, 
   3.666108294137442*^9, 3.666108635189541*^9, 3.666108811807485*^9, 
   3.666108951236856*^9, 3.666110066301271*^9, 3.666162976181126*^9, 
   3.666172828799247*^9, 3.666173545281354*^9, 3.666173622518011*^9, 
   3.666256559336883*^9, 3.666256982582883*^9, 3.666257029519786*^9, 
   3.666258279011314*^9, 3.693835582903075*^9, 3.7068776625229597`*^9, 
   3.7068777120265512`*^9, 3.706877919554235*^9, {3.706877965464929*^9, 
   3.7068779831179667`*^9}, {3.706878013286251*^9, 3.7068780370044737`*^9}, 
   3.7068780770076427`*^9, 3.7068781730997963`*^9, 3.706878245325876*^9, {
   3.706878303738708*^9, 3.706878344015082*^9}, {3.7068783762456408`*^9, 
   3.7068784041197987`*^9}, {3.706878451877482*^9, 3.706878528477559*^9}, {
   3.7068787195054417`*^9, 3.706878747041246*^9}, {3.70687890499292*^9, 
   3.7068789173880863`*^9}, {3.706878960512453*^9, 3.70687900061709*^9}, {
   3.706879082001034*^9, 3.706879097152458*^9}, 3.706879181170763*^9, 
   3.7068792778745823`*^9, 3.706879325587719*^9, 3.706879365264605*^9, 
   3.70702066591518*^9, {3.707020839076015*^9, 3.707020855262985*^9}, 
   3.70702093762927*^9, 3.7070520677710733`*^9, 3.707115304629545*^9, 
   3.708338994000348*^9, 3.7083390534158573`*^9, 3.708339120308641*^9, 
   3.708342594770336*^9, 3.7083471927318497`*^9, 3.708410538280896*^9, 
   3.708411044420313*^9, 3.708412489572969*^9, 3.7084126911465282`*^9, 
   3.7084134481319*^9, 3.7086720871979427`*^9, 3.708688289118533*^9, 
   3.7086886195501623`*^9, 3.708688821672942*^9, 3.708688854851478*^9, {
   3.7086889057637463`*^9, 3.708688934371421*^9}, {3.7086948625990477`*^9, 
   3.708694891711685*^9}, 3.7086949302033043`*^9, 3.708695016048316*^9, 
   3.708695048897883*^9, 3.708695251338797*^9, 3.708695467506958*^9, 
   3.708695660869792*^9, {3.7086956921428223`*^9, 3.708695715429339*^9}, 
   3.708697403369258*^9, 3.70869746007119*^9, 3.7086975020075006`*^9, 
   3.708697782907813*^9, 3.708697860397737*^9, 3.7086979764097424`*^9, 
   3.708698080479035*^9, 3.708698111793748*^9, 3.7087818329571457`*^9, 
   3.708781982973268*^9, 3.7087820366223383`*^9, 3.708782258990506*^9, 
   3.70878230468257*^9, 3.70878234026934*^9, 3.70878239519137*^9, 
   3.708783069931431*^9, 3.7087831676695557`*^9, 3.708783247861689*^9, 
   3.708783311724452*^9, 3.7087833633904753`*^9, 3.708784640264431*^9, 
   3.708784892255045*^9, 3.708784978443986*^9, 3.708785158868779*^9, 
   3.70878522858261*^9, 3.708786109570324*^9, 3.7087862221779547`*^9, {
   3.7087878235288343`*^9, 3.708787842129982*^9}, 3.7087879010675507`*^9, 
   3.708844167054658*^9, 3.708844204308136*^9, 3.708844243287479*^9, 
   3.708844295529039*^9, 3.708844389521969*^9, 3.708856096607934*^9, 
   3.708856578715221*^9, {3.7088567522868834`*^9, 3.708856758868087*^9}, 
   3.708857102138801*^9, 3.708857218094933*^9, 3.7088572857615557`*^9, 
   3.70885740017085*^9, 3.708857441398176*^9, 3.708857877137186*^9, 
   3.7088580060467663`*^9, 3.70885807891691*^9, 3.708863818846258*^9, {
   3.708864031574244*^9, 3.708864053152733*^9}, 3.708864090517086*^9, {
   3.708865987761099*^9, 3.708866012475531*^9}, 3.7089295281852713`*^9, 
   3.708931852416243*^9, 3.708932402982017*^9, 3.70893819521614*^9, 
   3.708938568516967*^9, 3.708938668102831*^9, 3.7089387587661448`*^9, 
   3.708938824616132*^9, 3.7089405315673933`*^9, 3.7089413382766953`*^9, 
   3.708941563564392*^9, 3.7089416396501226`*^9, {3.708941678820012*^9, 
   3.708941703385344*^9}, 3.70901161273129*^9, 3.7092919328609858`*^9, 
   3.709295886254904*^9, 3.709300240569208*^9, 3.712570849654889*^9, {
   3.712570963825712*^9, 3.712570985250771*^9}, 3.712571191993246*^9, 
   3.712571249704342*^9, 3.712571299989088*^9, {3.712571487329031*^9, 
   3.71257149537316*^9}, 3.7125729788562927`*^9, 3.712573105010412*^9, 
   3.71257342381139*^9, 3.7173095707350492`*^9, 3.717309801490851*^9, 
   3.717309895865185*^9, 3.7173100132607813`*^9, 3.7173116574330473`*^9, 
   3.717311728660171*^9, 3.717311845376512*^9, 3.717311946889495*^9, 
   3.717311981649768*^9, 3.717312076322318*^9, 3.717312108260642*^9, 
   3.7173121709588223`*^9, 3.71731227647968*^9, 3.717312360171792*^9, {
   3.717312396235837*^9, 3.717312424484536*^9}, {3.7173124767952433`*^9, 
   3.717312504831834*^9}, 3.71731259986694*^9, 3.717312680157626*^9, 
   3.717312716846757*^9, 3.717313043943969*^9, 3.717316875591222*^9, 
   3.717319587544795*^9, 3.717319921464326*^9, 3.717320004234008*^9, 
   3.717320618445541*^9, 3.717320649843465*^9, {3.717320740093042*^9, 
   3.717320769026238*^9}, 3.7173208199889793`*^9, 3.717330176325055*^9, 
   3.717330418879303*^9, 3.7173370159138947`*^9, 3.719029127921464*^9, 
   3.731391286401842*^9, 3.7313923462542*^9, 3.731392401838813*^9, 
   3.731392698057212*^9, 3.7313928555060587`*^9, {3.731393120192917*^9, 
   3.731393137021015*^9}, 3.7313932192855597`*^9, 3.731393288380866*^9, 
   3.731393360299468*^9, 3.7313934378794203`*^9, 3.731393562956623*^9, 
   3.7315846207017517`*^9, 3.750136150352844*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5bd270c5-0900-4af9-a73f-6bac26e15075"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checks", "Section",
 CellChangeTimes->{{3.6507792417995567`*^9, 
  3.650779242257778*^9}},ExpressionUUID->"7d7906c8-5fe7-4218-bd22-\
ea113896928e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LNP", "]"}]], "Input",
 CellChangeTimes->{{3.650779144898395*^9, 3.650779226197805*^9}, 
   3.6507796370351048`*^9, {3.6507799542733107`*^9, 3.650779954775826*^9}, 
   3.65670844124369*^9, {3.6567084734627542`*^9, 3.656708475077517*^9}, {
   3.6567086177844677`*^9, 3.65670861820015*^9}, {3.6567089657011833`*^9, 
   3.6567089669488373`*^9}, {3.656709000689712*^9, 3.6567090012231293`*^9}, {
   3.6567114398937197`*^9, 3.656711440036572*^9}, {3.7089385871933813`*^9, 
   3.708938588525648*^9}, {3.7089386630268517`*^9, 3.708938665030877*^9}, {
   3.712571481652707*^9, 3.7125714822191277`*^9}, {3.7125715566010723`*^9, 
   3.712571557139542*^9}, {3.712572886863242*^9, 3.7125729052131844`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"5598e096-9040-46e6-af0f-b29f2b844778"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731584627272955*^9, 
   3.750136154026464*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"2a9ed9a1-36b6-407a-b13b-d9679a348c67"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731584627272955*^9, 
   3.7501361540514183`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"36d57038-0d88-41d7-93f5-0ea0d03cf610"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{G0, G0}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{G0, G0}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731584627272955*^9, 
   3.750136154707152*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"be0bf5a4-11ba-430c-b96e-f7425773a406"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: mass term for \"\>", 
   "\[InvisibleSpace]", "\<\"{GP, GPbar}\"\>", 
   "\[InvisibleSpace]", "\<\"seems not to have the correct sign.\"\>"}],
  SequenceForm[
  "Warning: mass term for ", "{GP, GPbar}", 
   "seems not to have the correct sign."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731584627272955*^9, 
   3.7501361547309713`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"5eb3e85e-aafd-46ea-b1d9-9e39a4bbf3bf"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731584627272955*^9, 
   3.7501361547319527`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"fd6a69dd-762d-4c0a-a49b-94533f3314f2"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{
  3.712571507518738*^9, 3.712571561988954*^9, {3.712572892524877*^9, 
   3.712572909264141*^9}, 3.7125731130704727`*^9, 3.712573431965942*^9, 
   3.717309593932678*^9, 3.717310027684804*^9, 3.7173119884040613`*^9, 
   3.717312081440387*^9, 3.7173121129656267`*^9, 3.71731217475568*^9, 
   3.7173122826505136`*^9, 3.7173123644907627`*^9, {3.717312400511965*^9, 
   3.717312429158051*^9}, {3.717312481337357*^9, 3.7173125094387608`*^9}, 
   3.71731260384566*^9, 3.717312686946999*^9, 3.717312721559805*^9, 
   3.717313048228971*^9, 3.7173168797867393`*^9, 3.717319591609168*^9, 
   3.717320654392755*^9, 3.71732077606849*^9, 3.7173301805268517`*^9, 
   3.717330424268552*^9, 3.717337021525988*^9, 3.7190291343361197`*^9, 
   3.731391293113297*^9, 3.7313923537236137`*^9, 3.7313924467124453`*^9, 
   3.731392705462411*^9, 3.731392860580359*^9, 3.731393142682778*^9, 
   3.731393224521163*^9, 3.731393295304797*^9, 3.731393366086296*^9, 
   3.731393443345744*^9, 3.731393569008182*^9, 3.731584627272955*^9, 
   3.75013615473293*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"1e90c741-2a5e-4bcb-a57b-d86b7552ee3b"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"h", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Mu]", "H", "2"], "2"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          SubscriptBox["\[Lambda]", "H"], " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.00000000000001`", 
     "125.`"},
    {"s0", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         SubsuperscriptBox["\[Mu]", "s0", "2"], "2"], "-", 
        FractionBox[
         RowBox[{
          SubscriptBox["\[Lambda]", "s0h"], " ", 
          SuperscriptBox["vev", "2"]}], "2"]}]]}], "125.`", "125.`"},
    {"HE", "mHE", "100.`", "100.`"},
    {"W", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        SubsuperscriptBox["s", "w", "2"]]]}], "79.82435974619786`", 
     "79.82435974619784`"},
    {"Z", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "4"], "+", 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["c", "w", "2"], " ", 
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["s", "w", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SubsuperscriptBox["s", "w", "2"], " ", 
          SuperscriptBox["vev", "2"]}], 
         RowBox[{"8", " ", 
          SubsuperscriptBox["c", "w", "2"]}]]}]]}], "91.18760000000003`", 
     "91.1876`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.731393295779994*^9, 3.731393366646595*^9, 
  3.731393443878311*^9, 3.73139356953161*^9, 3.731584627774033*^9, 
  3.7501361547355223`*^9},
 CellLabel->
  "Out[6]//TableForm=",ExpressionUUID->"4b94fa8c-209d-4379-b0f4-2a7fe4a03349"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LNP", "]"}]], "Input",
 CellChangeTimes->{{3.662109944482068*^9, 3.662109949959669*^9}, {
  3.7070520925079317`*^9, 3.707052094151979*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"c62bc199-e9eb-4f32-97a4-34f206f6f63c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.75013615907829*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f7726fa9-29bd-42c3-9971-2029e9603bc3"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.7501361590799513`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"86297e27-8ea4-485d-b026-1152e14b4bc3"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.750136161123374*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"103be1d7-0938-42e8-adea-04d46ed7655b"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.750136161124688*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4b439781-51e4-4dd0-912e-38b3befcea78"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.750136161201271*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c1a631f0-880f-47f6-8a7c-18713bf8c2b5"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.7501361612023373`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"34016aed-d8d9-4789-8709-81c72ff87dfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.750136161203598*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"fbfd5157-1792-423e-a236-97a62135c760"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{
  3.662109950611717*^9, 3.6621100491907177`*^9, 3.662110099288418*^9, 
   3.6621102297781343`*^9, 3.662110556031708*^9, 3.662111565422152*^9, 
   3.662111690732912*^9, 3.662111986990986*^9, 3.662299836631556*^9, 
   3.6624602702238607`*^9, 3.662461075903812*^9, 3.662461176273719*^9, 
   3.666094703136882*^9, 3.66609478219595*^9, 3.666094823843472*^9, 
   3.666094887984742*^9, 3.66609494138925*^9, 3.666095039319365*^9, 
   3.666095080046657*^9, {3.666095890378615*^9, 3.6660959194067183`*^9}, {
   3.66609596936066*^9, 3.666096021135317*^9}, 3.666096209031279*^9, 
   3.666096451057599*^9, 3.6660965061770067`*^9, 3.666096801340404*^9, 
   3.666097125276428*^9, 3.6660972155723886`*^9, 3.666097490555674*^9, 
   3.666098649136683*^9, 3.666099085708466*^9, 3.666105646827078*^9, 
   3.666105698706766*^9, 3.666105776748055*^9, 3.666106138041951*^9, 
   3.666106325650318*^9, 3.666106927127924*^9, 3.666106983507677*^9, 
   3.6661074960066633`*^9, 3.666107539953541*^9, 3.6661077782324953`*^9, 
   3.6661082002236423`*^9, 3.666108300626935*^9, 3.666108641105934*^9, 
   3.6661088157868156`*^9, 3.666108967542158*^9, 3.666110074551958*^9, 
   3.666162980048913*^9, 3.66617283689258*^9, 3.666173553689439*^9, 
   3.666173627588743*^9, 3.6662565651008472`*^9, 3.666256988983639*^9, 
   3.6662570364231377`*^9, 3.666258284401793*^9, 3.693835592032103*^9, 
   3.706879119873847*^9, 3.706879196573152*^9, 3.70687929017339*^9, 
   3.706879380111734*^9, 3.707020678790742*^9, 3.707020866782268*^9, 
   3.707020952559111*^9, 3.707115321779415*^9, 3.7083426907404537`*^9, 
   3.708410551711368*^9, 3.7086883052053013`*^9, 3.7087830851303263`*^9, 
   3.7087861309493217`*^9, 3.70878627397226*^9, 3.708844248739506*^9, 
   3.708857121152726*^9, 3.708857226283862*^9, 3.708857298165777*^9, 
   3.7088574093451347`*^9, 3.708941765995262*^9, 3.7125729256971703`*^9, 
   3.712573120589476*^9, 3.71730993461721*^9, 3.7173100214104958`*^9, 
   3.7173126119401083`*^9, 3.717312725447649*^9, 3.7173130501727457`*^9, 
   3.717316882845475*^9, 3.717319593668646*^9, 3.717320013811453*^9, 
   3.7173206587074747`*^9, 3.717320778810032*^9, 3.717330183581362*^9, 
   3.7173304295048323`*^9, 3.717337024199233*^9, 3.719029138658031*^9, 
   3.7313912979634132`*^9, 3.731392358374024*^9, 3.7313926562543497`*^9, 
   3.7313929357330513`*^9, 3.7313933004940357`*^9, 3.731393368791439*^9, 
   3.7313934463187733`*^9, 3.731393573409615*^9, 3.73158463334827*^9, 
   3.7501361612046137`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"76553fff-8940-4cd6-861a-835729622128"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.662109951378407*^9, 3.662110049947618*^9, 3.6621100998351517`*^9, 
   3.662110230328856*^9, 3.662110556605912*^9, 3.6621115659622173`*^9, 
   3.662111691085476*^9, 3.662111987347905*^9, 3.662299837179309*^9, 
   3.662460270761208*^9, 3.662461076456791*^9, 3.662461176813862*^9, 
   3.66609470427413*^9, 3.6660947832833767`*^9, 3.666094824582155*^9, 
   3.6660948890397797`*^9, 3.6660949420967913`*^9, 3.6660950405602217`*^9, 
   3.6660950807879753`*^9, {3.6660958916258173`*^9, 3.6660959206518106`*^9}, {
   3.666095970622983*^9, 3.666096022386922*^9}, 3.666096209735268*^9, 
   3.6660964517873077`*^9, 3.666096506736858*^9, 3.6660968019201097`*^9, 
   3.6660971258492203`*^9, 3.666097216165155*^9, 3.66609749119268*^9, 
   3.666098649761964*^9, 3.6660990864511538`*^9, 3.666105647539627*^9, 
   3.6661056995078573`*^9, 3.666105777441723*^9, 3.666106138783424*^9, 
   3.666106326347747*^9, 3.666106927863018*^9, 3.666106986378415*^9, 
   3.6661074988713627`*^9, 3.666107542812337*^9, 3.666107781108523*^9, 
   3.666108203122014*^9, 3.6661083033618193`*^9, 3.666108641518971*^9, 
   3.666108816209578*^9, 3.66610896823496*^9, 3.66611007525498*^9, 
   3.666162980783061*^9, 3.666172837677167*^9, 3.666173554435424*^9, 
   3.6661736283472443`*^9, 3.666256565913422*^9, 3.6662569898703337`*^9, 
   3.666257037252726*^9, 3.6662582852313557`*^9, 3.6938355927370863`*^9, 
   3.706879144695354*^9, 3.7068792163020782`*^9, 3.706879307338579*^9, 
   3.706879399543598*^9, 3.707020692581769*^9, 3.70702087142515*^9, 
   3.7070209592958384`*^9, 3.707115326899603*^9, 3.7083426979576273`*^9, 
   3.7084105585559053`*^9, 3.7086883139925613`*^9, 3.7087830944199944`*^9, 
   3.708786137420226*^9, 3.708786280387837*^9, 3.708844254882721*^9, 
   3.708857134449316*^9, 3.7088572393670397`*^9, 3.708857311628956*^9, 
   3.7088574157731037`*^9, 3.708941773070489*^9, 3.712572932788961*^9, 
   3.712573127822146*^9, 3.71730993581514*^9, 3.717310022535645*^9, 
   3.717312612968665*^9, 3.717312726629593*^9, 3.717313051510038*^9, 
   3.717316883915576*^9, 3.717319594879335*^9, 3.7173200150136013`*^9, 
   3.717320659913966*^9, 3.717320780219535*^9, 3.717330184859136*^9, 
   3.717330430788595*^9, 3.717337025527526*^9, 3.7190291399198008`*^9, 
   3.731391299355544*^9, 3.7313923599209414`*^9, 3.731392657786044*^9, 
   3.7313929370039263`*^9, 3.7313933019081173`*^9, 3.731393370270252*^9, 
   3.731393447813367*^9, 3.731393574969151*^9, 3.7315846348209047`*^9, 
   3.750136161205595*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"9d3fbb30-11e9-433b-9140-bb7540e6d811"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interfaces", "Section",
 CellChangeTimes->{{3.650782302772278*^9, 3.6507823065682487`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteCHOutput", "[", 
  RowBox[{"LSM", ",", "LNP"}], "]"}]], "Input",
 CellChangeTimes->{{3.6242538526978188`*^9, 3.624253855246005*^9}, {
   3.6242539619622*^9, 3.624253962288993*^9}, 3.6435484136339283`*^9, {
   3.650782323830791*^9, 3.650782325054451*^9}, {3.6508794326823387`*^9, 
   3.650879434504023*^9}, {3.656697807213163*^9, 3.656697807404377*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"58eaf90f-6270-4e21-91b6-eb88bb862e68"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to CalcHep/CompHEP\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0nblN3UvfnjtCACOLMd9
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"688027ca-962f-44ea-8612-c043ac52ecf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Authors:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" N. Christensen, C. Duhr\"\>"}],
  SequenceForm[" - - - ", 
   Style["Authors:", 
    RGBColor[0, 0, 1]], " N. Christensen, C. Duhr"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0t9ab+pe/PDaEQCUTshD
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"edd5e39a-25ea-4252-9300-5b34a8bcf80c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" - - - \"\>", "\[InvisibleSpace]", 
   StyleBox["\<\"Please cite:\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" arXiv:0906.2474\"\>"}],
  SequenceForm[" - - - ", 
   Style["Please cite:", 
    RGBColor[0, 0, 1]], " arXiv:0906.2474"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0kmTbupe/PDaEQCQCce8
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"a92bb5c4-d2e4-49f6-800a-9cdc74901614"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" files to \
/home/andrikos/Dropbox/LH_LLPs_freezein/andreas/\
ColliderFriendlyFreezeInModels-FRpage/LesHouchesModelFreezeIn-up/\
LesHouchesModelFreezeIn-up-CH.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " files to \
/home/andrikos/Dropbox/LH_LLPs_freezein/andreas/\
ColliderFriendlyFreezeInModels-FRpage/LesHouchesModelFreezeIn-up/\
LesHouchesModelFreezeIn-up-CH."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0gfn3NS9+OG1IwCTR8gl
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"caf41826-3f7d-48fd-8add-07a71e4b7fae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" particles file 'prtcls1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " particles file 'prtcls1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0kdW3NS9+OG1IwCTs8g0
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"3bf365f4-acc6-4a31-b7eb-3afdd5d009d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external parameter file 'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external parameter file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0hckb+te/PDaEQCQNsez
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"bf8b5b61-ffdd-411a-abba-c2eacf36be67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0owqt3UvfnjtCACKC8bv
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"772208ec-a3a7-4fca-b11b-3d665068a47f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" external library file 'extlib1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], " external library file 'extlib1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0q90bute/PDaEQCRi8fg
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"d0a045a1-794d-45e4-aeea-2ddd811113de"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0r0mt3UvfnjtCACO28eL
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"a7322564-768c-45d1-942a-ab924ed694fb"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0scWPdC9+OG1IwCTw8g3
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"833da389-136f-45f2-b80b-906cb9099310"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0q/WPtC9+OG1IwCVMMhm
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"33e50430-62d5-467d-9493-faeea1e3f457"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0iE7H+he/PDaEQCQ1Mfc
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"b387b9a2-0e02-49e2-8499-cf6efc4a9d81"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0m9MLuhd/PDaEQCRlsfg
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"ecfc8595-5f21-4dc6-bb89-5b19055ddf83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "112", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "112", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  112, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 112, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0i5sl/QufnjtCACLIMcM
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"3551dac7-0357-4d44-bef0-9978e9296832"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"107", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[107, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0mue5ehf/PDaEQCSIcfv
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"0f5dabcc-ae2b-477f-a07c-f4d914acf292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "107"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 107],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0m82HdS/+OG1IwCUs8hQ
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f7164bb7-8f8d-4ecb-aa29-f95305c24182"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nWriting\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'\\nand appending \
variable file 'func1.mdl', particle file 'prtcls1.mdl' and variable file \
'vars1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nWriting", 
    RGBColor[0, 0, 1]], 
   " vertices file 'lgrng1.mdl'\nand appending variable file 'func1.mdl', \
particle file 'prtcls1.mdl' and variable file 'vars1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0uXlBw0ufnjtCACPc8eh
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"dee03ed0-441b-4854-bd73-9c23eedcb691"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nFinishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" vertices file 'lgrng1.mdl'.\"\>"}],
  SequenceForm[
   Style["\nFinishing", 
    RGBColor[0, 0, 1]], " vertices file 'lgrng1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0t8+xBle/PDaEQCUbcg3
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"851a2a1e-7caa-45c1-b05f-d49508706b7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"Finishing\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" internal parameter file 'func1.mdl'.\"\>"}],
  SequenceForm[
   Style["Finishing", 
    RGBColor[0, 0, 1]], " internal parameter file 'func1.mdl'."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0p9CEg0vfnjtCACQG8ea
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"dcc0ec3b-38ad-4553-a1ab-b0110aa19587"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["\<\"\\nDone\"\>",
    StripOnInput->False,
    LineColor->RGBColor[0, 0, 1],
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontColor->RGBColor[0, 0, 1]], 
   "\[InvisibleSpace]", "\<\" in 0.47min!\"\>"}],
  SequenceForm[
   Style["\nDone", 
    RGBColor[0, 0, 1]], " in 0.47min!"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAGIhh1/77tq9dlR9sbSQ1/6148I9vHW6QLrifNwqM4fX
ji2Pfh/QdnrtqJMx58xrj9eOx3dOegOiG+/0V70B0i6PDBaA6LdaFREenq8d
j1SFrJ8GpHk6HglPB9IX7v+XB9FuwsmJIFqkYlIPiOa45dvUGvDaseHyZ4M2
IB1jXxEKoiX8l9SC6PMb9naA6IuTVSaB6AOpS9aC6HmqzrbtQLolZJs7iBaJ
2x0AonMUr8WB6BcZ9XUgOkGkWr8bSAt4TgoA0f+0Nj8H0XnTpnwB0WvkFsr2
AGmp6n1GINpCZosbiPZnWXsFRM+7cv7uaiDtvV7S4CqQritYdNBu0WtH8c9d
1xKA9GFLg1vaK187yhn8W2S36bXjLKcbm0F09Nb1B0D0y/fOWQJnXztuCN9U
AaL/vP/XKgikI3YJXMwD0l4JiYYXP7x2BACLL8b+
  "],
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"1878ec1b-7db2-4279-a6d6-974aa6811e74"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSM", ",", "LNP"}], "]"}]], "Input",
 CellChangeTimes->{{3.515066451500599*^9, 3.51506645766863*^9}, {
   3.515066553825666*^9, 3.515066567557489*^9}, {3.517657052212844*^9, 
   3.5176570535784883`*^9}, {3.517657087674789*^9, 3.5176570975167933`*^9}, {
   3.517657162889937*^9, 3.517657189106102*^9}, {3.62036438703964*^9, 
   3.620364399043768*^9}, 3.643548416121323*^9, {3.650782333532228*^9, 
   3.650782334611961*^9}, {3.6508794376715517`*^9, 3.650879441489379*^9}, {
   3.656697825115713*^9, 3.65669782525168*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"b4dde509-82ce-4dc0-93c3-0bb8f493b4f4"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136207385312*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"4b91c965-797a-4426-8775-793bfb307032"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136207730467*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"72a845f3-bdc1-447c-85bd-918b10b114a6"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136207732972*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"f67ad567-77d7-4b66-8b41-4fe46db54968"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136207734063*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"c829f9e1-487d-41ef-8b07-765f00ebe144"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136213171069*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"1867d8df-3968-44e8-8d9e-713915bdf658"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "60", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "60", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  60, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 60, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362132142467`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"943a3f30-8b82-487f-bdb3-9d85dd1aecf6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"55", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[55, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136216394367*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"363e7ef7-3f66-4944-9689-d995319eb062"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362164030447`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"eb956bac-6262-4b23-8379-1cfb62b18894"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136216404243*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"4c01f87b-16a9-4142-a08a-6edeacfff3db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362164054527`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"968f1e31-2209-448b-9910-ae70f78d7892"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362183499126`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"516f3952-add5-44f7-bb7a-d7cc4ffe8388"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "52", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "52", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  52, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 52, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136218364992*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"2a752c64-621f-4430-9151-6d00b8349126"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"52", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[52, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136219794304*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"009e58a5-c78e-4f79-82e4-a8740c75a63d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "107"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 107],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362225819817`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"60a01f84-45cd-4f9e-8b43-319245d57533"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136230141499*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"2f6a62af-ab14-4741-a205-143938982327"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136230190414*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"96d7c6be-9eb7-4a28-9c1c-8570d8aa087a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "56"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 56],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362302548923`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"aac6b2b5-3566-4a9c-9dd1-8bcbc640fefa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "4.978298`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 4.978298, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136239677788*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"224cac60-6981-4b76-a9b1-9c3c7ef58d72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "71"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 71],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362397385178`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"f8979a7d-9695-40c2-8068-7e1e2b906d6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.653762`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.653762, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136240710271*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"1a35b95b-f06b-4643-ab63-73ae89eb7e5c"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136240712023*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"84878726-44cd-4767-a295-1b7ae1c9198c"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362409396477`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"d860a8f6-e7a4-495d-9334-8d10fcfa2728"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.75013624097644*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"bd9f0dae-3ed9-42b1-854b-48854664fe1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{23., {0., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "177", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 177, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136243059264*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"932c9e2e-8996-4687-817e-f75f1a0fed3d"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.750136243254306*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"c5fcba4e-aced-4f2e-bcaa-31f5a70899e4"],

Cell[BoxData[
 StyleBox["\<\"Warning: Non positive interaction order QED.\\n                \
This might reduce the efficiency of certain matrix element generators.\\n     \
           See logfile for more details.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362433795547`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"31977cba-3930-4ef8-b415-641a57785eb6"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.656838666863022*^9, 3.656936352774835*^9, 
  3.657001989422866*^9, 3.657545061886578*^9, 3.6585712892343397`*^9, 
  3.662110321786396*^9, 3.6621105760687933`*^9, 3.662111709311957*^9, 
  3.6621120085340433`*^9, 3.662299857119891*^9, 3.662460296537409*^9, 
  3.662461197267544*^9, 3.6624617203317337`*^9, 3.6624620641370287`*^9, 
  3.731391335180002*^9, 3.731391453132354*^9, 3.731393605564269*^9, 
  3.73158466720546*^9, 3.7501362435297747`*^9},
 CellLabel->
  "During evaluation of \
In[9]:=",ExpressionUUID->"cb532140-01f5-4ea5-b2d9-43954438205b"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1855, 1056},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"11.3 for Linux x86 (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 274, 5, 31, "Input",ExpressionUUID->"5ec45779-d10f-40a9-8b67-fa4ea1ab2938"],
Cell[CellGroupData[{
Cell[844, 29, 152, 3, 68, "Section",ExpressionUUID->"a6951ce1-0ae0-45b0-a61e-1b9f0fab81d8"],
Cell[CellGroupData[{
Cell[1021, 36, 2402, 46, 124, "Input",ExpressionUUID->"674a449c-ebe8-4afe-a89b-ed9cf8db3350"],
Cell[CellGroupData[{
Cell[3448, 86, 8389, 118, 25, "Print",ExpressionUUID->"47376186-5a76-47d8-9508-598daf6695bd"],
Cell[11840, 206, 8656, 125, 25, "Print",ExpressionUUID->"e81cedda-5ad6-42c6-b410-8a07dc8029f9"],
Cell[20499, 333, 8438, 119, 25, "Print",ExpressionUUID->"3a1ad39e-e02d-46bc-8ca8-0ae507ca6e30"],
Cell[28940, 454, 8373, 118, 25, "Print",ExpressionUUID->"08f275d6-9c07-471f-ba0a-9cf0c236c8ad"],
Cell[37316, 574, 8386, 118, 25, "Print",ExpressionUUID->"7250eba6-f985-420b-9364-2a017fa5b95f"],
Cell[45705, 694, 8438, 119, 25, "Print",ExpressionUUID->"c3cb145e-a0ba-4581-ba63-1870cf0a6594"],
Cell[54146, 815, 8436, 119, 25, "Print",ExpressionUUID->"0c580dae-1bb0-46d0-9581-d9ea96c785ee"],
Cell[62585, 936, 8373, 118, 25, "Print",ExpressionUUID->"a6abd289-4db8-4324-8f84-176bfbc18cba"],
Cell[70961, 1056, 8402, 118, 25, "Print",ExpressionUUID->"17784336-ba2b-4840-bbe4-306ee73378a8"],
Cell[79366, 1176, 8373, 118, 25, "Print",ExpressionUUID->"9e58a76e-9bbc-420b-8de0-ea5ea8fae41d"],
Cell[87742, 1296, 8440, 119, 25, "Print",ExpressionUUID->"1b20928f-f81f-4dd4-bff3-853c0bb77bec"],
Cell[96185, 1417, 8394, 118, 25, "Print",ExpressionUUID->"7ef60dbf-e8a2-4b93-b7e4-98bf21ce448e"],
Cell[104582, 1537, 8412, 118, 25, "Print",ExpressionUUID->"009ae989-851d-4e56-b916-0973d379eeca"],
Cell[112997, 1657, 8547, 120, 25, "Print",ExpressionUUID->"091961ef-2951-4045-b052-f02791980993"],
Cell[121547, 1779, 8518, 122, 25, "Print",ExpressionUUID->"e728ac0f-c6db-41c9-b2de-7d7c9785e57a"],
Cell[130068, 1903, 8420, 119, 25, "Print",ExpressionUUID->"fad0f89f-325c-4391-8638-88a6055dfcf8"],
Cell[138491, 2024, 8374, 118, 25, "Print",ExpressionUUID->"e92d1ca0-b39d-4c72-920b-33b5d68e54ee"],
Cell[146868, 2144, 8402, 118, 25, "Print",ExpressionUUID->"9022c4ab-432b-459a-a48c-022d1537ee85"],
Cell[155273, 2264, 8405, 118, 25, "Print",ExpressionUUID->"cc4990ca-825d-430e-87f8-f1ad70ecd216"],
Cell[163681, 2384, 8405, 118, 25, "Print",ExpressionUUID->"c045f0b4-3cb1-42d8-9e1a-3f9f99e507a1"],
Cell[172089, 2504, 8611, 124, 48, "Print",ExpressionUUID->"dd53db7c-824c-4d0c-9a15-720920bf9709"]
}, Open  ]],
Cell[180715, 2631, 406, 10, 22, "Message",ExpressionUUID->"bf685a14-6d70-4644-975d-88cccf791d8a"],
Cell[CellGroupData[{
Cell[181146, 2645, 8969, 131, 25, "Print",ExpressionUUID->"05fb31a6-229e-449b-9208-388de0dd603f"],
Cell[190118, 2778, 8392, 118, 25, "Print",ExpressionUUID->"5bd270c5-0900-4af9-a73f-6bac26e15075"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198571, 2903, 153, 3, 68, "Section",ExpressionUUID->"7d7906c8-5fe7-4218-bd22-ea113896928e"],
Cell[CellGroupData[{
Cell[198749, 2910, 822, 11, 31, "Input",ExpressionUUID->"5598e096-9040-46e6-af0f-b29f2b844778"],
Cell[CellGroupData[{
Cell[199596, 2925, 1439, 25, 25, "Print",ExpressionUUID->"2a9ed9a1-36b6-407a-b13b-d9679a348c67"],
Cell[201038, 2952, 1218, 19, 25, "Print",ExpressionUUID->"36d57038-0d88-41d7-93f5-0ea0d03cf610"],
Cell[202259, 2973, 1482, 27, 25, "Print",ExpressionUUID->"be0bf5a4-11ba-430c-b96e-f7425773a406"],
Cell[203744, 3002, 1490, 27, 25, "Print",ExpressionUUID->"5eb3e85e-aafd-46ea-b1d9-9e39a4bbf3bf"],
Cell[205237, 3031, 1212, 19, 25, "Print",ExpressionUUID->"fd6a69dd-762d-4c0a-a49b-94533f3314f2"],
Cell[206452, 3052, 1250, 20, 25, "Print",ExpressionUUID->"1e90c741-2a5e-4bcb-a57b-d86b7552ee3b"]
}, Open  ]],
Cell[207717, 3075, 2648, 80, 271, "Output",ExpressionUUID->"4b94fa8c-209d-4379-b0f4-2a7fe4a03349"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210402, 3160, 266, 4, 31, "Input",ExpressionUUID->"c62bc199-e9eb-4f32-97a4-34f206f6f63c"],
Cell[CellGroupData[{
Cell[210693, 3168, 2695, 40, 25, "Print",ExpressionUUID->"f7726fa9-29bd-42c3-9971-2029e9603bc3"],
Cell[213391, 3210, 2694, 40, 25, "Print",ExpressionUUID->"86297e27-8ea4-485d-b026-1152e14b4bc3"],
Cell[216088, 3252, 2887, 47, 25, "Print",ExpressionUUID->"103be1d7-0938-42e8-adea-04d46ed7655b"],
Cell[218978, 3301, 2642, 39, 25, "Print",ExpressionUUID->"4b439781-51e4-4dd0-912e-38b3befcea78"],
Cell[221623, 3342, 2675, 40, 25, "Print",ExpressionUUID->"c1a631f0-880f-47f6-8a7c-18713bf8c2b5"],
Cell[224301, 3384, 2635, 39, 25, "Print",ExpressionUUID->"34016aed-d8d9-4789-8709-81c72ff87dfe"],
Cell[226939, 3425, 2755, 43, 25, "Print",ExpressionUUID->"fbfd5157-1792-423e-a236-97a62135c760"],
Cell[229697, 3470, 2645, 39, 25, "Print",ExpressionUUID->"76553fff-8940-4cd6-861a-835729622128"]
}, Open  ]],
Cell[232357, 3512, 2614, 38, 35, "Output",ExpressionUUID->"9d3fbb30-11e9-433b-9140-bb7540e6d811"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[235020, 3556, 97, 1, 68, "Section",ExpressionUUID->"e7413e10-883c-496f-94ea-d252a70b9204"],
Cell[CellGroupData[{
Cell[235142, 3561, 459, 7, 31, "Input",ExpressionUUID->"58eaf90f-6270-4e21-91b6-eb88bb862e68"],
Cell[CellGroupData[{
Cell[235626, 3572, 694, 13, 25, "Print",ExpressionUUID->"688027ca-962f-44ea-8612-c043ac52ecf6"],
Cell[236323, 3587, 1135, 27, 25, "Print",ExpressionUUID->"edd5e39a-25ea-4252-9300-5b34a8bcf80c"],
Cell[237461, 3616, 1127, 27, 25, "Print",ExpressionUUID->"a92bb5c4-d2e4-49f6-800a-9cdc74901614"],
Cell[238591, 3645, 1361, 34, 48, "Print",ExpressionUUID->"caf41826-3f7d-48fd-8add-07a71e4b7fae"],
Cell[239955, 3681, 1099, 27, 48, "Print",ExpressionUUID->"3bf365f4-acc6-4a31-b7eb-3afdd5d009d0"],
Cell[241057, 3710, 1113, 27, 48, "Print",ExpressionUUID->"bf8b5b61-ffdd-411a-abba-c2eacf36be67"],
Cell[242173, 3739, 1113, 27, 48, "Print",ExpressionUUID->"772208ec-a3a7-4fca-b11b-3d665068a47f"],
Cell[243289, 3768, 1113, 27, 48, "Print",ExpressionUUID->"d0a045a1-794d-45e4-aeea-2ddd811113de"],
Cell[244405, 3797, 649, 13, 25, "Print",ExpressionUUID->"a7322564-768c-45d1-942a-ab924ed694fb"],
Cell[245057, 3812, 921, 21, 25, "Print",ExpressionUUID->"833da389-136f-45f2-b80b-906cb9099310"],
Cell[245981, 3835, 676, 13, 25, "Print",ExpressionUUID->"33e50430-62d5-467d-9493-faeea1e3f457"],
Cell[246660, 3850, 858, 18, 25, "Print",ExpressionUUID->"b387b9a2-0e02-49e2-8499-cf6efc4a9d81"],
Cell[247521, 3870, 709, 14, 25, "Print",ExpressionUUID->"ecfc8595-5f21-4dc6-bb89-5b19055ddf83"],
Cell[248233, 3886, 1194, 25, 25, "Print",ExpressionUUID->"3551dac7-0357-4d44-bef0-9978e9296832"],
Cell[249430, 3913, 793, 17, 25, "Print",ExpressionUUID->"0f5dabcc-ae2b-477f-a07c-f4d914acf292"],
Cell[250226, 3932, 1147, 24, 25, "Print",ExpressionUUID->"f7164bb7-8f8d-4ecb-aa29-f95305c24182"],
Cell[251376, 3958, 1306, 31, 70, "Print",ExpressionUUID->"dee03ed0-441b-4854-bd73-9c23eedcb691"],
Cell[252685, 3991, 1099, 27, 48, "Print",ExpressionUUID->"851a2a1e-7caa-45c1-b05f-d49508706b7d"],
Cell[253787, 4020, 1112, 27, 25, "Print",ExpressionUUID->"dcc0ec3b-38ad-4553-a1ab-b0110aa19587"],
Cell[254902, 4049, 1057, 27, 48, "Print",ExpressionUUID->"1878ec1b-7db2-4279-a6d6-974aa6811e74"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256008, 4082, 649, 10, 31, "Input",ExpressionUUID->"b4dde509-82ce-4dc0-93c3-0bb8f493b4f4"],
Cell[CellGroupData[{
Cell[256682, 4096, 652, 11, 25, "Print",ExpressionUUID->"4b91c965-797a-4426-8775-793bfb307032"],
Cell[257337, 4109, 875, 18, 25, "Print",ExpressionUUID->"72a845f3-bdc1-447c-85bd-918b10b114a6"],
Cell[258215, 4129, 630, 10, 25, "Print",ExpressionUUID->"f67ad567-77d7-4b66-8b41-4fe46db54968"],
Cell[258848, 4141, 812, 15, 25, "Print",ExpressionUUID->"c829f9e1-487d-41ef-8b07-765f00ebe144"],
Cell[259663, 4158, 663, 11, 25, "Print",ExpressionUUID->"1867d8df-3968-44e8-8d9e-713915bdf658"],
Cell[260329, 4171, 1146, 22, 25, "Print",ExpressionUUID->"943a3f30-8b82-487f-bdb3-9d85dd1aecf6"],
Cell[261478, 4195, 745, 14, 25, "Print",ExpressionUUID->"363e7ef7-3f66-4944-9689-d995319eb062"],
Cell[262226, 4211, 877, 18, 25, "Print",ExpressionUUID->"eb956bac-6262-4b23-8379-1cfb62b18894"],
Cell[263106, 4231, 630, 10, 25, "Print",ExpressionUUID->"4c01f87b-16a9-4142-a08a-6edeacfff3db"],
Cell[263739, 4243, 814, 15, 25, "Print",ExpressionUUID->"968f1e31-2209-448b-9910-ae70f78d7892"],
Cell[264556, 4260, 665, 11, 25, "Print",ExpressionUUID->"516f3952-add5-44f7-bb7a-d7cc4ffe8388"],
Cell[265224, 4273, 1144, 22, 25, "Print",ExpressionUUID->"2a752c64-621f-4430-9151-6d00b8349126"],
Cell[266371, 4297, 745, 14, 25, "Print",ExpressionUUID->"009e58a5-c78e-4f79-82e4-a8740c75a63d"],
Cell[267119, 4313, 1103, 21, 25, "Print",ExpressionUUID->"60a01f84-45cd-4f9e-8b43-319245d57533"],
Cell[268225, 4336, 644, 10, 25, "Print",ExpressionUUID->"2f6a62af-ab14-4741-a205-143938982327"],
Cell[268872, 4348, 911, 19, 25, "Print",ExpressionUUID->"96d7c6be-9eb7-4a28-9c1c-8570d8aa087a"],
Cell[269786, 4369, 867, 18, 25, "Print",ExpressionUUID->"aac6b2b5-3566-4a9c-9dd1-8bcbc640fefa"],
Cell[270656, 4389, 843, 15, 25, "Print",ExpressionUUID->"224cac60-6981-4b76-a9b1-9c3c7ef58d72"],
Cell[271502, 4406, 867, 18, 25, "Print",ExpressionUUID->"f8979a7d-9695-40c2-8068-7e1e2b906d6a"],
Cell[272372, 4426, 829, 15, 25, "Print",ExpressionUUID->"1a35b95b-f06b-4643-ab63-73ae89eb7e5c"],
Cell[273204, 4443, 627, 10, 25, "Print",ExpressionUUID->"84878726-44cd-4767-a295-1b7ae1c9198c"],
Cell[273834, 4455, 653, 11, 25, "Print",ExpressionUUID->"d860a8f6-e7a4-495d-9334-8d10fcfa2728"],
Cell[274490, 4468, 841, 15, 25, "Print",ExpressionUUID->"bd9f0dae-3ed9-42b1-854b-48854664fe1c"],
Cell[275334, 4485, 1001, 18, 25, "Print",ExpressionUUID->"932c9e2e-8996-4687-817e-f75f1a0fed3d"],
Cell[276338, 4505, 623, 10, 25, "Print",ExpressionUUID->"c5fcba4e-aced-4f2e-bcaa-31f5a70899e4"],
Cell[276964, 4517, 998, 19, 70, "Print",ExpressionUUID->"31977cba-3930-4ef8-b415-641a57785eb6"],
Cell[277965, 4538, 610, 10, 25, "Print",ExpressionUUID->"cb532140-01f5-4ea5-b2d9-43954438205b"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

