(***************************************************************************************************************)
(******       This is the FeynRules mod-file for the EW boson pair production effective theory            ******)
(******                                                                                                   ******)
(******     Authors: C. Degrande                                                                          ******)
(******                                                                                                   ******)
(***************************************************************************************************************)

M$ModelName = "EWdim6";


M$Information = {Authors -> {"C. Degrande"}, 
             Version -> "1.2",
             Date -> "12.12. 2013",
             Institutions -> {"University of Illinois at Urbana-Champaign"},
             Emails -> {"celine.degrande@uclouvain.be"},
             URLs -> "http://feynrules.phys.ucl.ac.be"};
             
(* 1.1 log : Operators with the Higgs relevant for VBS added *)    
(* 1.2 log : 1/2 factor added for the dual*)         

M$InteractionOrderHierarchy = {(*{HIW,2},{HIG,2},*)
{NP,1}
};

M$InteractionOrderLimit = {
{NP,2}(*,{HIW,1},{HIG,1}*)
};



(****************  Parameters *************)

M$Parameters = {

(* External parameters *)


  CWWWL2== {
        ParameterType -> External,
        ParameterName -> CWWWL2,
        BlockName -> DIM6,
        OrderBlock -> 1,
	  InteractionOrder -> {{QED,-3},{ NP, 2}},
        Value -> 1,
	  TeX -> Subscript[C,WWW]/\[CapitalLambda]^2,
        Description -> "coefficient of OWWW in TeV-2"},

  CWL2== {
        ParameterType -> External,
        ParameterName -> CWL2,
        BlockName -> DIM6,
        OrderBlock -> 2,
	  InteractionOrder -> {{QED,-1},{ NP, 2}},
        Value -> 1,
	  TeX -> Subscript[C,W]/\[CapitalLambda]^2,
        Description -> "coefficient of OW in TeV-2"},

  CBL2== {
        ParameterType -> External,
        ParameterName -> CBL2,
        BlockName -> DIM6,
        OrderBlock -> 3,
	  InteractionOrder -> {{QED,-1}, {NP, 2}},
        Value -> 1,
	  TeX -> Subscript[C,B]/\[CapitalLambda]^2,
        Description -> "coefficient of OB in TeV-2"},

  CphiWL2== {
        ParameterType -> External,
        ParameterName -> CphiWL2,
        BlockName -> DIM6,
        OrderBlock -> 7,
	  InteractionOrder -> {{QED,-1},{ NP, 2}},
        Value -> 1,
	  TeX -> Subscript[C,\[Phi]W]/\[CapitalLambda]^2,
        Description -> "coefficient of OphiW in TeV-2"},

  CphiBL2== {
        ParameterType -> External,
        ParameterName -> CphiBL2,
        BlockName -> DIM6,
        OrderBlock -> 8,
	  InteractionOrder -> {{QED,-1}, {NP, 2}},
        Value -> 1,
	  TeX -> Subscript[C,\[Phi]B]/\[CapitalLambda]^2,
        Description -> "coefficient of OphiB in TeV-2"},

  CPWWWL2== {
        ParameterType -> External,
        ParameterName -> CPWWWL2,
        BlockName -> DIM6,
        OrderBlock -> 4,
	  InteractionOrder -> {{QED,-3}, {NP, 2}},
        Value -> 1,
	  TeX -> Subscript[CP,WWW]/\[CapitalLambda]^2,
        Description -> "coefficient of OWWW tilde in TeV-2"},

  CPWL2== {
        ParameterType -> External,
        ParameterName -> CPWL2,
        BlockName -> DIM6,
        OrderBlock -> 5,
	  InteractionOrder -> {{QED,-1}, {NP, 2}},
        Value -> 1,
	  TeX -> Subscript[CP,W]/\[CapitalLambda]^2,
        Description -> "coefficient of OW tilde in TeV-2"}    

}


LX2phi2 := Module[{mu,nu,ii,aa,kk}, 
  ExpandIndices[(Phibar[kk] Phi[kk]-vev^2/2)(-g1^2/4 CphiBL2 FS[B,mu,nu] FS[B,mu,nu] - gw^2/2 CphiWL2 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii]), FlavorExpand->{SU2W,SU2D}]]*10^(-6)/.{CphidL2->0};


Lphi4 := CphidL2*10^(-6) Module[{ii,jj,kk,mu}, ExpandIndices[ del[Phibar[ii] Phi[ii],mu] del[(Phibar[jj] Phi[jj]),mu], FlavorExpand->{SU2D,SU2W}]/.{CphidL2->0}];

LWWW := ExpandIndices[CWWWL2*10^(-6) gw^3/4 Module[{mu, nu, rho, L, J, K}, Eps[L, J, K] FS[Wi, mu, nu, L] FS[Wi, nu, rho, J] FS[Wi, rho, mu,K]],FlavorExpand->{SU2W,SU2D}] /.{CphidL2->0};

LHB := ExpandIndices[I g1/2*CBL2*10^(-6) Module[{mu, nu,jj}, DC[Phibar[jj],mu] FS[B,mu,nu] DC[Phi[jj],nu]], FlavorExpand -> {SU2W,SU2D}] /.{CphidL2->0};

LHW := ExpandIndices[I gw*CWL2*10^(-6) Module[{jj,ii,kk,  mu, nu}, DC[Phibar[kk],mu] FS[Wi,mu,nu,ii] DC[Phi[jj],nu] Ta[ii,kk,jj]], FlavorExpand -> {SU2W,SU2D}]/.{CphidL2->0};

(* CP Violating operators *)
(*%%%%%%%%%%%%%%%%%%%%%%%%*)

LCPW := 1/2 ExpandIndices[I gw*CPWL2*10^(-6) Module[{ii,jj,kk,  mu, nu, rho, sig}, DC[Phibar[kk],mu] FS[Wi,rho,sig,ii] DC[Phi[jj],nu] Ta[ii,kk,jj] Eps[mu, nu, rho, sig]], FlavorExpand -> {SU2W,SU2D}]/.{CphidL2->0};

LCPWWW := 1/2 ExpandIndices[CPWWWL2*10^(-6) gw^3/4 Module[{mu, nu, rho, al, sig, L, J, K}, Eps[L, J, K] Eps[mu, nu, al, sig] FS[Wi, al, sig, L] FS[Wi, nu, rho, J] FS[Wi, rho, mu, K]],FlavorExpand -> {SU2W,SU2D}]/.{CphidL2->0};

LEFW := LWWW+LHB+LHW+Lphi4+LX2phi2;

LCPEFW := LCPWWW+LCPW;

