# This file was automatically created by FeynRules 2.3.35
# Mathematica version: 12.0.0 for Linux x86 (64-bit) (April 7, 2019)
# Date: Tue 26 May 2020 14:55:03



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
Lambda = Parameter(name = 'Lambda',
                   nature = 'external',
                   type = 'real',
                   value = 100000.,
                   texname = '\\Lambda',
                   lhablock = 'LDARK',
                   lhacode = [ 1 ])

CAn = Parameter(name = 'CAn',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = 'C_{\\text{An}}',
                lhablock = 'LDARK',
                lhacode = [ 2 ])

CBan = Parameter(name = 'CBan',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = 'C_{\\text{Ban}}',
                 lhablock = 'LDARK',
                 lhacode = [ 3 ])

CMag = Parameter(name = 'CMag',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = 'C_{\\text{Mag}}',
                 lhablock = 'LDARK',
                 lhacode = [ 4 ])

CBmag = Parameter(name = 'CBmag',
                  nature = 'external',
                  type = 'real',
                  value = 1.,
                  texname = 'C_{\\text{Bmag}}',
                  lhablock = 'LDARK',
                  lhacode = [ 5 ])

CElec = Parameter(name = 'CElec',
                  nature = 'external',
                  type = 'real',
                  value = 1.,
                  texname = 'C_{\\text{Elec}}',
                  lhablock = 'LDARK',
                  lhacode = [ 6 ])

CBelec = Parameter(name = 'CBelec',
                   nature = 'external',
                   type = 'real',
                   value = 1.,
                   texname = 'C_{\\text{Belec}}',
                   lhablock = 'LDARK',
                   lhacode = [ 7 ])

Ccr = Parameter(name = 'Ccr',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = 'C_{\\text{CR}}',
                lhablock = 'LDARK',
                lhacode = [ 8 ])

CBcr = Parameter(name = 'CBcr',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = 'C_{\\text{Bcr}}',
                 lhablock = 'LDARK',
                 lhacode = [ 9 ])

CDan = Parameter(name = 'CDan',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = 'C_{\\text{Dan}}',
                 lhablock = 'LDARK',
                 lhacode = [ 10 ])

CBdan = Parameter(name = 'CBdan',
                  nature = 'external',
                  type = 'real',
                  value = 1.,
                  texname = 'C_{\\text{Bdan}}',
                  lhablock = 'LDARK',
                  lhacode = [ 11 ])

Mreno = Parameter(name = 'Mreno',
                  nature = 'external',
                  type = 'real',
                  value = 555,
                  texname = 'M_{\\text{reno}}',
                  lhablock = 'Renor',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymdo = Parameter(name = 'ymdo',
                 nature = 'external',
                 type = 'real',
                 value = 0.00504,
                 texname = '\\text{ymdo}',
                 lhablock = 'YUKAWA',
                 lhacode = [ 1 ])

ymup = Parameter(name = 'ymup',
                 nature = 'external',
                 type = 'real',
                 value = 0.00255,
                 texname = '\\text{ymup}',
                 lhablock = 'YUKAWA',
                 lhacode = [ 2 ])

yms = Parameter(name = 'yms',
                nature = 'external',
                type = 'real',
                value = 0.101,
                texname = '\\text{yms}',
                lhablock = 'YUKAWA',
                lhacode = [ 3 ])

ymc = Parameter(name = 'ymc',
                nature = 'external',
                type = 'real',
                value = 1.27,
                texname = '\\text{ymc}',
                lhablock = 'YUKAWA',
                lhacode = [ 4 ])

ymb = Parameter(name = 'ymb',
                nature = 'external',
                type = 'real',
                value = 4.7,
                texname = '\\text{ymb}',
                lhablock = 'YUKAWA',
                lhacode = [ 5 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

yme = Parameter(name = 'yme',
                nature = 'external',
                type = 'real',
                value = 0.000511,
                texname = '\\text{yme}',
                lhablock = 'YUKAWA',
                lhacode = [ 11 ])

ymm = Parameter(name = 'ymm',
                nature = 'external',
                type = 'real',
                value = 0.10566,
                texname = '\\text{ymm}',
                lhablock = 'YUKAWA',
                lhacode = [ 13 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MW = Parameter(name = 'MW',
               nature = 'external',
               type = 'real',
               value = 79.8244,
               texname = '\\text{MW}',
               lhablock = 'MASS',
               lhacode = [ 24 ])

Me = Parameter(name = 'Me',
               nature = 'external',
               type = 'real',
               value = 0.000511,
               texname = '\\text{Me}',
               lhablock = 'MASS',
               lhacode = [ 11 ])

MM = Parameter(name = 'MM',
               nature = 'external',
               type = 'real',
               value = 0.10566,
               texname = '\\text{MM}',
               lhablock = 'MASS',
               lhacode = [ 13 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MU = Parameter(name = 'MU',
               nature = 'external',
               type = 'real',
               value = 0.00255,
               texname = 'M',
               lhablock = 'MASS',
               lhacode = [ 2 ])

MC = Parameter(name = 'MC',
               nature = 'external',
               type = 'real',
               value = 1.27,
               texname = '\\text{MC}',
               lhablock = 'MASS',
               lhacode = [ 4 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MD = Parameter(name = 'MD',
               nature = 'external',
               type = 'real',
               value = 0.00504,
               texname = '\\text{MD}',
               lhablock = 'MASS',
               lhacode = [ 1 ])

MS = Parameter(name = 'MS',
               nature = 'external',
               type = 'real',
               value = 0.101,
               texname = '\\text{MS}',
               lhablock = 'MASS',
               lhacode = [ 3 ])

MB = Parameter(name = 'MB',
               nature = 'external',
               type = 'real',
               value = 4.7,
               texname = '\\text{MB}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

MChi = Parameter(name = 'MChi',
                 nature = 'external',
                 type = 'real',
                 value = 10.,
                 texname = '\\text{MChi}',
                 lhablock = 'MASS',
                 lhacode = [ 9990 ])

MPsi = Parameter(name = 'MPsi',
                 nature = 'external',
                 type = 'real',
                 value = 10.,
                 texname = '\\text{MPsi}',
                 lhablock = 'MASS',
                 lhacode = [ 9991 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00575308848,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'MW/MZ',
               texname = 'c_w')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'MH/cmath.sqrt(2)',
                texname = '\\mu')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - MW**2/MZ**2)',
               texname = 's_w')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(1/Gf)/2**0.25',
                texname = 'v')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '(2*MW*sw)/vev',
               texname = 'e')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = 'ee**2/(4.*cmath.pi)',
                texname = '\\alpha _{\\text{EW}}')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'internal',
                  type = 'real',
                  value = '1/aEW',
                  texname = '\\text{aEWM1}')

