(***************************************************************************************************************)
(******                    This is the FeynRules mod-file for the Standard model plus DY                  ******)
(******                                                                                                   ******)
(******     Authors: N. Christensen                                                                       ******)
(******                                                                                                   ******)
(****** It is to be used with the SM in unitary gauge.                                                    ******)
(****** It is only designed to be used in Drell-Yan 2->2 processes.                                         ****)
(***************************************************************************************************************)

M$ModelName = "Standard Model plus DY";


M$Information = {Authors -> {"N. Christensen"}, 
             Version -> "1.0",
             Date -> "July 28, 2011",
             Institutions -> {"University of Wisconsin - Madison"},
             Emails -> {"neil@hep.wisc.edu"},
             URLs -> "http://feynrules.irmp.ucl.ac.be/wiki/DY-SM"};





(****************  Parameters *************)

M$Parameters = {

(********************************************************)
(*         Neutral Scalar Field : SV                    *)
(*                Up Quark                              *)
(********************************************************)

   gSu == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSu,
        Definitions   -> {gSu[a_,b_] -> gSuR[a,b]+I gSuI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Scalar - up quark coupling constant"},

   gSuR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSuR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gSuR[1,1] -> 0,
                          gSuR[1,2] -> 0,
                          gSuR[2,2] -> 0
			 },
        Definitions   -> {  
                          gSuR[2,1] -> gSuR[1,2],
                          gSuR[1,3] -> 0,
                          gSuR[2,3] -> 0,
                          gSuR[3,1] -> 0,
                          gSuR[3,2] -> 0,
                          gSuR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Scalar - up quark coupling constant"},

   gSuI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSuI,
	ComplexParameter -> False,
	Value         -> { 
                          gSuI[1,2] -> 0
			 },
        Definitions   -> {  
                          gSuI[2,1] -> - gSuI[1,2],
		      	  gSuI[1,1] -> 0,
                          gSuI[2,2] -> 0,
                          gSuI[1,3] -> 0,
                          gSuI[2,3] -> 0,
                          gSuI[3,1] -> 0,
                          gSuI[3,2] -> 0,
                          gSuI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Scalar - up quark coupling constant"},

   gPu == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPu,
        Definitions   -> {gPu[a_,b_] -> gPuR[a,b]+I gPuI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Pseudoscalar - up quark coupling constant"},

   gPuR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPuR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gPuR[1,1] -> 0,
                          gPuR[1,2] -> 0,
                          gPuR[2,2] -> 0
			 },
        Definitions   -> {  
                          gPuR[2,1] -> gPuR[1,2],
                          gPuR[1,3] -> 0,
                          gPuR[2,3] -> 0,
                          gPuR[3,1] -> 0,
                          gPuR[3,2] -> 0,
                          gPuR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Pseudoscalar - up quark coupling constant"},

   gPuI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPuI,
	ComplexParameter -> False,
	Value         -> { 
                          gPuI[1,2] -> 0
			 },
        Definitions   -> {  
                          gPuI[2,1] -> - gPuI[1,2],
                          gPuI[2,2] -> 0,
		      	  gPuI[1,1] -> 0,
                          gPuI[1,3] -> 0,
                          gPuI[2,3] -> 0,
                          gPuI[3,1] -> 0,
                          gPuI[3,2] -> 0,
                          gPuI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Pseudoscalar - up quark coupling constant"},

(********************************************************)
(*         Neutral Scalar Field : SV                    *)
(*               Down Quark                             *)
(********************************************************)

   gSd == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSd,
        Definitions   -> {gSd[a_,b_] -> gSdR[a,b]+I gSdI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Scalar - down quark coupling constant"},

   gSdR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSdR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gSdR[1,1] -> 0,
                          gSdR[1,2] -> 0,
                          gSdR[2,2] -> 0
			 },
        Definitions   -> {  
                          gSdR[2,1] -> gSdR[1,2],
                          gSdR[1,3] -> 0,
                          gSdR[2,3] -> 0,
                          gSdR[3,1] -> 0,
                          gSdR[3,2] -> 0,
                          gSdR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Scalar - down quark coupling constant"},

   gSdI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSdI,
	ComplexParameter -> False,
	Value         -> { 
                          gSdI[1,2] -> 0
			 },
        Definitions   -> {  
                          gSdI[2,1] -> - gSdI[1,2],
		      	  gSdI[1,1] -> 0,
                          gSdI[2,2] -> 0,
                          gSdI[1,3] -> 0,
                          gSdI[2,3] -> 0,
                          gSdI[3,1] -> 0,
                          gSdI[3,2] -> 0,
                          gSdI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Scalar - down quark coupling constant"},

   gPd == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPd,
        Definitions   -> {gPd[a_,b_] -> gPdR[a,b]+I gPdI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Pseudoscalar - down quark coupling constant"},

   gPdR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPdR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gPdR[1,1] -> 0,
                          gPdR[1,2] -> 0,
                          gPdR[2,2] -> 0
			 },
        Definitions   -> {  
                          gPdR[2,1] -> gPdR[1,2],
                          gPdR[1,3] -> 0,
                          gPdR[2,3] -> 0,
                          gPdR[3,1] -> 0,
                          gPdR[3,2] -> 0,
                          gPdR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Pseudoscalar - down quark coupling constant"},

   gPdI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPdI,
	ComplexParameter -> False,
	Value         -> { 
                          gPdI[1,2] -> 0
			 },
        Definitions   -> {  
                          gPdI[2,1] -> - gPdI[1,2],
                          gPdI[2,2] -> 0,
		      	  gPdI[1,1] -> 0,
                          gPdI[1,3] -> 0,
                          gPdI[2,3] -> 0,
                          gPdI[3,1] -> 0,
                          gPdI[3,2] -> 0,
                          gPdI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Pseudoscalar - down quark coupling constant"},

(********************************************************)
(*         Neutral Scalar Field : SV                    *)
(*             Charged Lepton                           *)
(********************************************************)

   gSl == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSl,
        Definitions   -> {gSl[a_,b_] -> gSlR[a,b]+I gSlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Scalar - charged lepton coupling constant"},

   gSlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gSlR[1,1] -> 0,
                          gSlR[1,2] -> 0,
                          gSlR[2,2] -> 0
			 },
        Definitions   -> {  
                          gSlR[2,1] -> gSlR[1,2],
                          gSlR[1,3] -> 0,
                          gSlR[2,3] -> 0,
                          gSlR[3,1] -> 0,
                          gSlR[3,2] -> 0,
                          gSlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Scalar - charged lepton coupling constant"},

   gSlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gSlI,
	ComplexParameter -> False,
	Value         -> { 
                          gSlI[1,2] -> 0
			 },
        Definitions   -> {  
                          gSlI[2,1] -> - gSlI[1,2],
		      	  gSlI[1,1] -> 0,
                          gSlI[2,2] -> 0,
                          gSlI[1,3] -> 0,
                          gSlI[2,3] -> 0,
                          gSlI[3,1] -> 0,
                          gSlI[3,2] -> 0,
                          gSlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Scalar - charged lepton coupling constant"},

   gPl == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPl,
        Definitions   -> {gPl[a_,b_] -> gPlR[a,b]+I gPlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Pseudoscalar - charged lepton coupling constant"},

   gPlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gPlR[1,1] -> 0,
                          gPlR[1,2] -> 0,
                          gPlR[2,2] -> 0
			 },
        Definitions   -> {  
                          gPlR[2,1] -> gPlR[1,2],
                          gPlR[1,3] -> 0,
                          gPlR[2,3] -> 0,
                          gPlR[3,1] -> 0,
                          gPlR[3,2] -> 0,
                          gPlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Pseudoscalar - charged lepton coupling constant"},

   gPlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gPlI,
	ComplexParameter -> False,
	Value         -> { 
                          gPlI[1,2] -> 0
			 },
        Definitions   -> {  
                          gPlI[2,1] -> - gPlI[1,2],
                          gPlI[2,2] -> 0,
		      	  gPlI[1,1] -> 0,
                          gPlI[1,3] -> 0,
                          gPlI[2,3] -> 0,
                          gPlI[3,1] -> 0,
                          gPlI[3,2] -> 0,
                          gPlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Pseudoscalar - charged lepton coupling constant"},


(********************************************************)
(*         Neutral Scalar Field : SV                    *)
(*                 Gluon                                *)
(********************************************************)

   gSg == {
        ParameterType -> External,
	Value         -> 0,
        InteractionOrder -> {QED, 1},
        Description   -> "Neutral Scalar - gluon coupling constant"},


(********************************************************)
(*         Neutral Vector Field : VV                    *)
(*                Up Quark                              *)
(********************************************************)

   gVu == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVu,
        Definitions   -> {gVu[a_,b_] -> gVuR[a,b]+I gVuI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Vector - up quark coupling constant"},

   gVuR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVuR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gVuR[1,1] -> 0,
                          gVuR[1,2] -> 0,
                          gVuR[2,2] -> 0
			 },
        Definitions   -> {  
                          gVuR[2,1] -> gVuR[1,2],
                          gVuR[1,3] -> 0,
                          gVuR[2,3] -> 0,
                          gVuR[3,1] -> 0,
                          gVuR[3,2] -> 0,
                          gVuR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Vector - up quark coupling constant"},

   gVuI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVuI,
	ComplexParameter -> False,
	Value         -> { 
                          gVuI[1,2] -> 0
			 },
        Definitions   -> {  
                          gVuI[2,1] -> - gVuI[1,2],
		      	  gVuI[1,1] -> 0,
                          gVuI[2,2] -> 0,
                          gVuI[1,3] -> 0,
                          gVuI[2,3] -> 0,
                          gVuI[3,1] -> 0,
                          gVuI[3,2] -> 0,
                          gVuI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Vector - up quark coupling constant"},

   gAu == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAu,
        Definitions   -> {gAu[a_,b_] -> gAuR[a,b]+I gAuI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Axial vector - up quark coupling constant"},

   gAuR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAuR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gAuR[1,1] -> 0,
                          gAuR[1,2] -> 0,
                          gAuR[2,2] -> 0
			 },
        Definitions   -> {  
                          gAuR[2,1] -> gAuR[1,2],
                          gAuR[1,3] -> 0,
                          gAuR[2,3] -> 0,
                          gAuR[3,1] -> 0,
                          gAuR[3,2] -> 0,
                          gAuR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral axial vector - up quark coupling constant"},

   gAuI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAuI,
	ComplexParameter -> False,
	Value         -> { 
                          gAuI[1,2] -> 0
			 },
        Definitions   -> {  
                          gAuI[2,1] -> - gAuI[1,2],
                          gAuI[2,2] -> 0,
		      	  gAuI[1,1] -> 0,
                          gAuI[1,3] -> 0,
                          gAuI[2,3] -> 0,
                          gAuI[3,1] -> 0,
                          gAuI[3,2] -> 0,
                          gAuI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral axial vector - up quark coupling constant"},

(********************************************************)
(*         Neutral Vector Field : VV                    *)
(*               Down Quark                             *)
(********************************************************)

   gVd == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVd,
        Definitions   -> {gVd[a_,b_] -> gVdR[a,b]+I gVdI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Vector - down quark coupling constant"},

   gVdR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVdR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gVdR[1,1] -> 0,
                          gVdR[1,2] -> 0,
                          gVdR[2,2] -> 0
			 },
        Definitions   -> {  
                          gVdR[2,1] -> gVdR[1,2],
                          gVdR[1,3] -> 0,
                          gVdR[2,3] -> 0,
                          gVdR[3,1] -> 0,
                          gVdR[3,2] -> 0,
                          gVdR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral vector - down quark coupling constant"},

   gVdI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVdI,
	ComplexParameter -> False,
	Value         -> { 
                          gVdI[1,2] -> 0
			 },
        Definitions   -> {  
                          gVdI[2,1] -> - gVdI[1,2],
		      	  gVdI[1,1] -> 0,
                          gVdI[2,2] -> 0,
                          gVdI[1,3] -> 0,
                          gVdI[2,3] -> 0,
                          gVdI[3,1] -> 0,
                          gVdI[3,2] -> 0,
                          gVdI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral vector - down quark coupling constant"},

   gAd == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAd,
        Definitions   -> {gAd[a_,b_] -> gAdR[a,b]+I gAdI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Axial vector - down quark coupling constant"},

   gAdR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAdR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gAdR[1,1] -> 0,
                          gAdR[1,2] -> 0,
                          gAdR[2,2] -> 0
			 },
        Definitions   -> {  
                          gAdR[2,1] -> gAdR[1,2],
                          gAdR[1,3] -> 0,
                          gAdR[2,3] -> 0,
                          gAdR[3,1] -> 0,
                          gAdR[3,2] -> 0,
                          gAdR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral axial vector - down quark coupling constant"},

   gAdI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAdI,
	ComplexParameter -> False,
	Value         -> { 
                          gAdI[1,2] -> 0
			 },
        Definitions   -> {  
                          gAdI[2,1] -> - gAdI[1,2],
                          gAdI[2,2] -> 0,
		      	  gAdI[1,1] -> 0,
                          gAdI[1,3] -> 0,
                          gAdI[2,3] -> 0,
                          gAdI[3,1] -> 0,
                          gAdI[3,2] -> 0,
                          gAdI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral axial vector - down quark coupling constant"},

(********************************************************)
(*         Neutral Vector Field : VV                    *)
(*             Charged Lepton                           *)
(********************************************************)

   gVl == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVl,
        Definitions   -> {gVl[a_,b_] -> gVlR[a,b]+I gVlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral vector - charged lepton coupling constant"},

   gVlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gVlR[1,1] -> 0,
                          gVlR[1,2] -> 0,
                          gVlR[2,2] -> 0
			 },
        Definitions   -> {  
                          gVlR[2,1] -> gVlR[1,2],
                          gVlR[1,3] -> 0,
                          gVlR[2,3] -> 0,
                          gVlR[3,1] -> 0,
                          gVlR[3,2] -> 0,
                          gVlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral vector - charged lepton coupling constant"},

   gVlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gVlI,
	ComplexParameter -> False,
	Value         -> { 
                          gVlI[1,2] -> 0
			 },
        Definitions   -> {  
                          gVlI[2,1] -> - gVlI[1,2],
		      	  gVlI[1,1] -> 0,
                          gVlI[2,2] -> 0,
                          gVlI[1,3] -> 0,
                          gVlI[2,3] -> 0,
                          gVlI[3,1] -> 0,
                          gVlI[3,2] -> 0,
                          gVlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral vector - charged lepton coupling constant"},

   gAl == {
        ParameterType -> Internal,
	Hermitian     -> True,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAl,
        Definitions   -> {gAl[a_,b_] -> gAlR[a,b]+I gAlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral axial vector - charged lepton coupling constant"},

   gAlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gAlR[1,1] -> 0,
                          gAlR[1,2] -> 0,
                          gAlR[2,2] -> 0
			 },
        Definitions   -> {  
                          gAlR[2,1] -> gAlR[1,2],
                          gAlR[1,3] -> 0,
                          gAlR[2,3] -> 0,
                          gAlR[3,1] -> 0,
                          gAlR[3,2] -> 0,
                          gAlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral axial vector - charged lepton coupling constant"},

   gAlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gAlI,
	ComplexParameter -> False,
	Value         -> { 
                          gAlI[1,2] -> 0
			 },
        Definitions   -> {  
                          gAlI[2,1] -> - gAlI[1,2],
                          gAlI[2,2] -> 0,
		      	  gAlI[1,1] -> 0,
                          gAlI[1,3] -> 0,
                          gAlI[2,3] -> 0,
                          gAlI[3,1] -> 0,
                          gAlI[3,2] -> 0,
                          gAlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral axial vector - charged lepton coupling constant"},


(********************************************************)
(*         Neutral Vector Field : VV                    *)
(*                 Gluon                                *)
(********************************************************)

   gVg == {
        ParameterType -> External,
	ComplexParameter -> False,
	Value         -> 0,
        InteractionOrder -> {QED, 1},
        Description   -> "Neutral Vector - gluon coupling constant"},


(********************************************************)
(*         Neutral Tensor Field : TV                    *)
(*                Up Quark                              *)
(********************************************************)

   gTu == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTu,
        Definitions   -> {gTu[a_,b_] -> gTuR[a,b]+I gTuI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Symmetric Tensor - up quark coupling constant"},

   gTuR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTuR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gTuR[1,1] -> 0,
                          gTuR[1,2] -> 0,
                          gTuR[2,1] -> 0,
                          gTuR[2,2] -> 0
			 },
        Definitions   -> {  
                          gTuR[1,3] -> 0,
                          gTuR[2,3] -> 0,
                          gTuR[3,1] -> 0,
                          gTuR[3,2] -> 0,
                          gTuR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Symmetric Tensor - up quark coupling constant"},

   gTuI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTuI,
	ComplexParameter -> False,
	Value         -> { 
		      	  gTuI[1,1] -> 0,
                          gTuI[1,2] -> 0,
			  gTuI[2,1] -> 0,
			  gTuI[2,2] -> 0
			 },
        Definitions   -> {  
                          gTuI[1,3] -> 0,
                          gTuI[2,3] -> 0,
                          gTuI[3,1] -> 0,
                          gTuI[3,2] -> 0,
                          gTuI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Symmetric Tensor - up quark coupling constant"},

   gUu == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUu,
        Definitions   -> {gUu[a_,b_] -> gUuR[a,b]+I gUuI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral axial Symmetric Tensor - up quark coupling constant"},

   gUuR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUuR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gUuR[1,1] -> 0,
                          gUuR[1,2] -> 0,
			  gUuR[2,1] -> 0,
                          gUuR[2,2] -> 0
			 },
        Definitions   -> {  
                          gUuR[1,3] -> 0,
                          gUuR[2,3] -> 0,
                          gUuR[3,1] -> 0,
                          gUuR[3,2] -> 0,
                          gUuR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral axial Symmetric Tensor - up quark coupling constant"},

   gUuI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUuI,
	ComplexParameter -> False,
	Value         -> { 
		      	  gUuI[1,1] -> 0,
                          gUuI[1,2] -> 0,
                          gUuI[2,1] -> 0,
                          gUuI[2,2] -> 0
			 },
        Definitions   -> {  
                          gUuI[1,3] -> 0,
                          gUuI[2,3] -> 0,
                          gUuI[3,1] -> 0,
                          gUuI[3,2] -> 0,
                          gUuI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral axial Symmetric Tensor - up quark coupling constant"},

(********************************************************)
(*         Neutral Tensor Field : TV                    *)
(*               Down Quark                             *)
(********************************************************)

   gTd == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTd,
        Definitions   -> {gTd[a_,b_] -> gTdR[a,b]+I gTdI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Symmetric Tensor - down quark coupling constant"},

   gTdR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTdR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gTdR[1,1] -> 0,
                          gTdR[1,2] -> 0,
			  gTdR[2,1] -> 0,
                          gTdR[2,2] -> 0
			 },
        Definitions   -> {  
                          gTdR[1,3] -> 0,
                          gTdR[2,3] -> 0,
                          gTdR[3,1] -> 0,
                          gTdR[3,2] -> 0,
                          gTdR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Symmetric Tensor - down quark coupling constant"},

   gTdI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTdI,
	ComplexParameter -> False,
	Value         -> { 
		      	  gTdI[1,1] -> 0,
                          gTdI[1,2] -> 0,
                          gTdI[2,1] -> 0,
                          gTdI[2,2] -> 0
			 },
        Definitions   -> {  
                          gTdI[1,3] -> 0,
                          gTdI[2,3] -> 0,
                          gTdI[3,1] -> 0,
                          gTdI[3,2] -> 0,
                          gTdI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Symmetric Tensor - down quark coupling constant"},

   gUd == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUd,
        Definitions   -> {gUd[a_,b_] -> gUdR[a,b]+I gUdI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral axial Symmetric Tensor - down quark coupling constant"},

   gUdR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUdR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gUdR[1,1] -> 0,
                          gUdR[1,2] -> 0,
			  gUdR[2,1] -> 0,
                          gUdR[2,2] -> 0
			 },
        Definitions   -> {  
                          gUdR[1,3] -> 0,
                          gUdR[2,3] -> 0,
                          gUdR[3,1] -> 0,
                          gUdR[3,2] -> 0,
                          gUdR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral axial Symmetric Tensor - down quark coupling constant"},

   gUdI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUdI,
	ComplexParameter -> False,
	Value         -> { 
		      	  gUdI[1,1] -> 0,
                          gUdI[1,2] -> 0,
                          gUdI[2,1] -> 0,
                          gUdI[2,2] -> 0
			 },
        Definitions   -> {  
                          gUdI[1,3] -> 0,
                          gUdI[2,3] -> 0,
                          gUdI[3,1] -> 0,
                          gUdI[3,2] -> 0,
                          gUdI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral axial Symmetric Tensor - down quark coupling constant"},

(********************************************************)
(*         Neutral Tensor Field : TV                    *)
(*             Charged Lepton                           *)
(********************************************************)

   gTl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTl,
        Definitions   -> {gTl[a_,b_] -> gTlR[a,b]+I gTlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral Symmetric Tensor - charged lepton coupling constant"},

   gTlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gTlR[1,1] -> 0,
                          gTlR[1,2] -> 0,
			  gTlR[2,1] -> 0,
                          gTlR[2,2] -> 0
			 },
        Definitions   -> {  
                          gTlR[1,3] -> 0,
                          gTlR[2,3] -> 0,
                          gTlR[3,1] -> 0,
                          gTlR[3,2] -> 0,
                          gTlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral Symmetric Tensor - charged lepton coupling constant"},

   gTlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gTlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  gTlI[1,1] -> 0,
                          gTlI[1,2] -> 0,
                          gTlI[2,1] -> 0,
                          gTlI[2,2] -> 0
			 },
        Definitions   -> {  
                          gTlI[1,3] -> 0,
                          gTlI[2,3] -> 0,
                          gTlI[3,1] -> 0,
                          gTlI[3,2] -> 0,
                          gTlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral Symmetric Tensor - charged lepton coupling constant"},

   gUl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUl,
        Definitions   -> {gUl[a_,b_] -> gUlR[a,b]+I gUlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Neutral axial Symmetric Tensor - charged lepton coupling constant"},

   gUlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  gUlR[1,1] -> 0,
                          gUlR[1,2] -> 0,
			  gUlR[2,1] -> 0,
                          gUlR[2,2] -> 0
			 },
        Definitions   -> {  
                          gUlR[1,3] -> 0,
                          gUlR[2,3] -> 0,
                          gUlR[3,1] -> 0,
                          gUlR[3,2] -> 0,
                          gUlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Neutral axial Symmetric Tensor - charged lepton coupling constant"},

   gUlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> gUlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  gUlI[1,1] -> 0,
                          gUlI[1,2] -> 0,
                          gUlI[2,1] -> 0,
                          gUlI[2,2] -> 0
			 },
        Definitions   -> {  
                          gUlI[1,3] -> 0,
                          gUlI[2,3] -> 0,
                          gUlI[3,1] -> 0,
                          gUlI[3,2] -> 0,
                          gUlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Neutral axial Symmetric Tensor - charged lepton coupling constant"},


(********************************************************)
(*         Neutral Tensor Field : TV                    *)
(*                 Gluon                                *)
(********************************************************)

   gTg == {
        ParameterType -> External,
	Value         -> 0,
        InteractionOrder -> {QED, 1},
        Description   -> "Neutral Tensor - gluon coupling constant"},


(********************************************************)
(*         Charged Scalar Field : SV'                   *)
(*                  Quark                               *)
(********************************************************)

   hSq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hSq,
        Definitions   -> {hSq[a_,b_] -> hSqR[a,b]+I hSqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged scalar - quark coupling constant"},

   hSqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hSqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hSqR[1,1] -> 0,
                          hSqR[1,2] -> 0,
                          hSqR[2,1] -> 0,
                          hSqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hSqR[1,3] -> 0,
                          hSqR[2,3] -> 0,
                          hSqR[3,1] -> 0,
                          hSqR[3,2] -> 0,
                          hSqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged scalar - quark coupling constant"},

   hSqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hSqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hSqI[1,1] -> 0,
                          hSqI[1,2] -> 0,
                          hSqI[2,1] -> 0,
                          hSqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hSqI[1,3] -> 0,
                          hSqI[2,3] -> 0,
                          hSqI[3,1] -> 0,
                          hSqI[3,2] -> 0,
                          hSqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged scalar - quark coupling constant"},

   hPq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hPq,
        Definitions   -> {hPq[a_,b_] -> hPqR[a,b]+I hPqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged pseudoscalar - quark coupling constant"},

   hPqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hPqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hPqR[1,1] -> 0,
                          hPqR[1,2] -> 0,
                          hPqR[2,1] -> 0,
                          hPqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hPqR[1,3] -> 0,
                          hPqR[2,3] -> 0,
                          hPqR[3,1] -> 0,
                          hPqR[3,2] -> 0,
                          hPqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged pseudoscalar - quark coupling constant"},

   hPqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hPqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hPqI[1,1] -> 0,
                          hPqI[1,2] -> 0,
                          hPqI[2,1] -> 0,
                          hPqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hPqI[1,3] -> 0,
                          hPqI[2,3] -> 0,
                          hPqI[3,1] -> 0,
                          hPqI[3,2] -> 0,
                          hPqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged pseudoscalar - quark coupling constant"},

(********************************************************)
(*         Charged Scalar Field : SV'                   *)
(*                 Lepton                               *)
(********************************************************)

   hSl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hSl,
        Definitions   -> {hSl[a_,b_] -> hSlR[a,b]+I hSlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged scalar - lepton coupling constant"},

   hSlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hSlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hSlR[1,1] -> 0,
                          hSlR[1,2] -> 0,
                          hSlR[2,1] -> 0,
                          hSlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hSlR[1,3] -> 0,
                          hSlR[2,3] -> 0,
                          hSlR[3,1] -> 0,
                          hSlR[3,2] -> 0,
                          hSlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged scalar - lepton coupling constant"},

   hSlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hSlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hSlI[1,1] -> 0,
                          hSlI[1,2] -> 0,
                          hSlI[2,1] -> 0,
                          hSlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hSlI[1,3] -> 0,
                          hSlI[2,3] -> 0,
                          hSlI[3,1] -> 0,
                          hSlI[3,2] -> 0,
                          hSlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged scalar - lepton coupling constant"},

   hPl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hPl,
        Definitions   -> {hPl[a_,b_] -> hPlR[a,b]+I hPlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged pseudoscalar - lepton coupling constant"},

   hPlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hPlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hPlR[1,1] -> 0,
                          hPlR[1,2] -> 0,
                          hPlR[2,1] -> 0,
                          hPlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hPlR[1,3] -> 0,
                          hPlR[2,3] -> 0,
                          hPlR[3,1] -> 0,
                          hPlR[3,2] -> 0,
                          hPlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged pseudoscalar - lepton coupling constant"},

   hPlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hPlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hPlI[1,1] -> 0,
                          hPlI[1,2] -> 0,
                          hPlI[2,1] -> 0,
                          hPlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hPlI[1,3] -> 0,
                          hPlI[2,3] -> 0,
                          hPlI[3,1] -> 0,
                          hPlI[3,2] -> 0,
                          hPlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged pseudoscalar - lepton coupling constant"},

(********************************************************)
(*         Charged Vector Field : VV'                   *)
(*                  Quark                               *)
(********************************************************)

   hVq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hVq,
        Definitions   -> {hVq[a_,b_] -> hVqR[a,b]+I hVqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged vector - quark coupling constant"},

   hVqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hVqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hVqR[1,1] -> 0,
                          hVqR[1,2] -> 0,
                          hVqR[2,1] -> 0,
                          hVqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hVqR[1,3] -> 0,
                          hVqR[2,3] -> 0,
                          hVqR[3,1] -> 0,
                          hVqR[3,2] -> 0,
                          hVqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged vector - quark coupling constant"},

   hVqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hVqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hVqI[1,1] -> 0,
                          hVqI[1,2] -> 0,
                          hVqI[2,1] -> 0,
                          hVqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hVqI[1,3] -> 0,
                          hVqI[2,3] -> 0,
                          hVqI[3,1] -> 0,
                          hVqI[3,2] -> 0,
                          hVqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged vector - quark coupling constant"},

   hAq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hAq,
        Definitions   -> {hAq[a_,b_] -> hAqR[a,b]+I hAqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged axial vector - quark coupling constant"},

   hAqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hAqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hAqR[1,1] -> 0,
                          hAqR[1,2] -> 0,
                          hAqR[2,1] -> 0,
                          hAqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hAqR[1,3] -> 0,
                          hAqR[2,3] -> 0,
                          hAqR[3,1] -> 0,
                          hAqR[3,2] -> 0,
                          hAqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged axial vector - quark coupling constant"},

   hAqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hAqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hAqI[1,1] -> 0,
                          hAqI[1,2] -> 0,
                          hAqI[2,1] -> 0,
                          hAqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hAqI[1,3] -> 0,
                          hAqI[2,3] -> 0,
                          hAqI[3,1] -> 0,
                          hAqI[3,2] -> 0,
                          hAqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged axial vector - quark coupling constant"},

(********************************************************)
(*         Charged Vector Field : VV'                   *)
(*                 Lepton                               *)
(********************************************************)

   hVl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hVl,
        Definitions   -> {hVl[a_,b_] -> hVlR[a,b]+I hVlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged vector - lepton coupling constant"},

   hVlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hVlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hVlR[1,1] -> 0,
                          hVlR[1,2] -> 0,
                          hVlR[2,1] -> 0,
                          hVlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hVlR[1,3] -> 0,
                          hVlR[2,3] -> 0,
                          hVlR[3,1] -> 0,
                          hVlR[3,2] -> 0,
                          hVlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged vector - lepton coupling constant"},

   hVlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hVlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hVlI[1,1] -> 0,
                          hVlI[1,2] -> 0,
                          hVlI[2,1] -> 0,
                          hVlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hVlI[1,3] -> 0,
                          hVlI[2,3] -> 0,
                          hVlI[3,1] -> 0,
                          hVlI[3,2] -> 0,
                          hVlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged vector - lepton coupling constant"},

   hAl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hAl,
        Definitions   -> {hAl[a_,b_] -> hAlR[a,b]+I hAlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged axial vector - lepton coupling constant"},

   hAlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hAlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hAlR[1,1] -> 0,
                          hAlR[1,2] -> 0,
                          hAlR[2,1] -> 0,
                          hAlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hAlR[1,3] -> 0,
                          hAlR[2,3] -> 0,
                          hAlR[3,1] -> 0,
                          hAlR[3,2] -> 0,
                          hAlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged axial vector - lepton coupling constant"},

   hAlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hAlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hAlI[1,1] -> 0,
                          hAlI[1,2] -> 0,
                          hAlI[2,1] -> 0,
                          hAlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hAlI[1,3] -> 0,
                          hAlI[2,3] -> 0,
                          hAlI[3,1] -> 0,
                          hAlI[3,2] -> 0,
                          hAlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged axial vector - lepton coupling constant"},

(********************************************************)
(*         Charged Tensor Field : TV'                   *)
(*                  Quark                               *)
(********************************************************)

   hTq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hTq,
        Definitions   -> {hTq[a_,b_] -> hTqR[a,b]+I hTqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged Symmetric Tensor - quark coupling constant"},

   hTqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hTqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hTqR[1,1] -> 0,
                          hTqR[1,2] -> 0,
                          hTqR[2,1] -> 0,
                          hTqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hTqR[1,3] -> 0,
                          hTqR[2,3] -> 0,
                          hTqR[3,1] -> 0,
                          hTqR[3,2] -> 0,
                          hTqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged Symmetric Tensor - quark coupling constant"},

   hTqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hTqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hTqI[1,1] -> 0,
                          hTqI[1,2] -> 0,
                          hTqI[2,1] -> 0,
                          hTqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hTqI[1,3] -> 0,
                          hTqI[2,3] -> 0,
                          hTqI[3,1] -> 0,
                          hTqI[3,2] -> 0,
                          hTqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged Symmetric Tensor - quark coupling constant"},

   hUq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hUq,
        Definitions   -> {hUq[a_,b_] -> hUqR[a,b]+I hUqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged axial Symmetric Tensor - quark coupling constant"},

   hUqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hUqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hUqR[1,1] -> 0,
                          hUqR[1,2] -> 0,
                          hUqR[2,1] -> 0,
                          hUqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hUqR[1,3] -> 0,
                          hUqR[2,3] -> 0,
                          hUqR[3,1] -> 0,
                          hUqR[3,2] -> 0,
                          hUqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged axial Symmetric Tensor - quark coupling constant"},

   hUqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hUqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hUqI[1,1] -> 0,
                          hUqI[1,2] -> 0,
                          hUqI[2,1] -> 0,
                          hUqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hUqI[1,3] -> 0,
                          hUqI[2,3] -> 0,
                          hUqI[3,1] -> 0,
                          hUqI[3,2] -> 0,
                          hUqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged axial Symmetric Tensor - quark coupling constant"},

   hYq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hYq,
        Definitions   -> {hYq[a_,b_] -> hYqR[a,b]+I hYqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged Symmetric Tensor - quark coupling constant"},

   hYqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hYqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hYqR[1,1] -> 0,
                          hYqR[1,2] -> 0,
                          hYqR[2,1] -> 0,
                          hYqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hYqR[1,3] -> 0,
                          hYqR[2,3] -> 0,
                          hYqR[3,1] -> 0,
                          hYqR[3,2] -> 0,
                          hYqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged Symmetric Tensor - quark coupling constant"},

   hYqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hYqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hYqI[1,1] -> 0,
                          hYqI[1,2] -> 0,
                          hYqI[2,1] -> 0,
                          hYqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hYqI[1,3] -> 0,
                          hYqI[2,3] -> 0,
                          hYqI[3,1] -> 0,
                          hYqI[3,2] -> 0,
                          hYqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged Symmetric Tensor - quark coupling constant"},

   hZq == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hZq,
        Definitions   -> {hZq[a_,b_] -> hZqR[a,b]+I hZqI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged axial Symmetric Tensor - quark coupling constant"},

   hZqR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hZqR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hZqR[1,1] -> 0,
                          hZqR[1,2] -> 0,
                          hZqR[2,1] -> 0,
                          hZqR[2,2] -> 0
			 },
        Definitions   -> {  
                          hZqR[1,3] -> 0,
                          hZqR[2,3] -> 0,
                          hZqR[3,1] -> 0,
                          hZqR[3,2] -> 0,
                          hZqR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged axial Symmetric Tensor - quark coupling constant"},

   hZqI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hZqI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hZqI[1,1] -> 0,
                          hZqI[1,2] -> 0,
                          hZqI[2,1] -> 0,
                          hZqI[2,2] -> 0
			 },
        Definitions   -> {  
                          hZqI[1,3] -> 0,
                          hZqI[2,3] -> 0,
                          hZqI[3,1] -> 0,
                          hZqI[3,2] -> 0,
                          hZqI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged axial Symmetric Tensor - quark coupling constant"},

(********************************************************)
(*         Charged Tensor Field : TV'                   *)
(*                 Lepton                               *)
(********************************************************)

   hTl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hTl,
        Definitions   -> {hTl[a_,b_] -> hTlR[a,b]+I hTlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged Symmetric Tensor - lepton coupling constant"},

   hTlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hTlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hTlR[1,1] -> 0,
                          hTlR[1,2] -> 0,
                          hTlR[2,1] -> 0,
                          hTlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hTlR[1,3] -> 0,
                          hTlR[2,3] -> 0,
                          hTlR[3,1] -> 0,
                          hTlR[3,2] -> 0,
                          hTlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged Symmetric Tensor - lepton coupling constant"},

   hTlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hTlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hTlI[1,1] -> 0,
                          hTlI[1,2] -> 0,
                          hTlI[2,1] -> 0,
                          hTlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hTlI[1,3] -> 0,
                          hTlI[2,3] -> 0,
                          hTlI[3,1] -> 0,
                          hTlI[3,2] -> 0,
                          hTlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged Symmetric Tensor - lepton coupling constant"},

   hUl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hUl,
        Definitions   -> {hUl[a_,b_] -> hUlR[a,b]+I hUlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged axial Symmetric Tensor - lepton coupling constant"},

   hUlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hUlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hUlR[1,1] -> 0,
                          hUlR[1,2] -> 0,
                          hUlR[2,1] -> 0,
                          hUlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hUlR[1,3] -> 0,
                          hUlR[2,3] -> 0,
                          hUlR[3,1] -> 0,
                          hUlR[3,2] -> 0,
                          hUlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged axial Symmetric Tensor - lepton coupling constant"},

   hUlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hUlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hUlI[1,1] -> 0,
                          hUlI[1,2] -> 0,
                          hUlI[2,1] -> 0,
                          hUlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hUlI[1,3] -> 0,
                          hUlI[2,3] -> 0,
                          hUlI[3,1] -> 0,
                          hUlI[3,2] -> 0,
                          hUlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged axial Symmetric Tensor - lepton coupling constant"},

   hYl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hYl,
        Definitions   -> {hYl[a_,b_] -> hYlR[a,b]+I hYlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged Symmetric Tensor - lepton coupling constant"},

   hYlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hYlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hYlR[1,1] -> 0,
                          hYlR[1,2] -> 0,
                          hYlR[2,1] -> 0,
                          hYlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hYlR[1,3] -> 0,
                          hYlR[2,3] -> 0,
                          hYlR[3,1] -> 0,
                          hYlR[3,2] -> 0,
                          hYlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged Symmetric Tensor - lepton coupling constant"},

   hYlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hYlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hYlI[1,1] -> 0,
                          hYlI[1,2] -> 0,
                          hYlI[2,1] -> 0,
                          hYlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hYlI[1,3] -> 0,
                          hYlI[2,3] -> 0,
                          hYlI[3,1] -> 0,
                          hYlI[3,2] -> 0,
                          hYlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged Symmetric Tensor - lepton coupling constant"},

   hZl == {
        ParameterType -> Internal,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hZl,
        Definitions   -> {hZl[a_,b_] -> hZlR[a,b]+I hZlI[a,b]},
        InteractionOrder -> {QED, 1},
        Description    -> "Charged axial Symmetric Tensor - lepton coupling constant"},

   hZlR == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hZlR,
	ComplexParameter -> False,
	Value         -> { 
		      	  hZlR[1,1] -> 0,
                          hZlR[1,2] -> 0,
                          hZlR[2,1] -> 0,
                          hZlR[2,2] -> 0
			 },
        Definitions   -> {  
                          hZlR[1,3] -> 0,
                          hZlR[2,3] -> 0,
                          hZlR[3,1] -> 0,
                          hZlR[3,2] -> 0,
                          hZlR[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Real part of Charged axial Symmetric Tensor - lepton coupling constant"},

   hZlI == {
        ParameterType -> External,
	Indices       -> {Index[Generation], Index[Generation]},
        TensorClass   -> hZlI,
	ComplexParameter -> False,
	Value         -> { 
		      	  hZlI[1,1] -> 0,
                          hZlI[1,2] -> 0,
                          hZlI[2,1] -> 0,
                          hZlI[2,2] -> 0
			 },
        Definitions   -> {  
                          hZlI[1,3] -> 0,
                          hZlI[2,3] -> 0,
                          hZlI[3,1] -> 0,
                          hZlI[3,2] -> 0,
                          hZlI[3,3] -> 0
			 },
       InteractionOrder -> {QED, 1},
       Description    -> "Imaginary part of Charged axial Symmetric Tensor - lepton coupling constant"}

};



(********* Particle Classes **********)

M$ClassesDescription = {


(************ Scalar Fields **********)

S[4] == {
        ClassName -> SV,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MSV, 1000},
        Width -> {WSV, 20},
	PropagatorLabel -> "SV",
	PropagatorType -> D,
	PropagatorArrow -> None,
        FullName -> "New Neutral Scalar" },

S[5] == {
        ClassName -> SVP,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MSVP, 1000},
        Width -> {WSVP, 20},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "SVP",
	PropagatorType -> D,
	PropagatorArrow -> Forward,
	ParticleName ->"SVP+",
	AntiParticleName ->"SVP-",
        FullName -> "New Charged Scalar" },

(************ Vector Bosons ***************)

V[7] == {
        ClassName -> VV,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MVV, 1000},
        Width -> {WVV, 20},
	PropagatorLabel -> "VV",
	PropagatorType -> Sine,
	PropagatorArrow -> None,
        FullName -> "New Neutral Vector" },

V[8] == {
        ClassName -> VVP,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MVVP, 1000},
        Width -> {WVVP, 20},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "VVP",
	PropagatorType -> Sine,
	PropagatorArrow -> Forward,
	ParticleName ->"VVP+",
	AntiParticleName ->"VVP-",
        FullName -> "New Charged Vector" },

(************ Tensor Fields **********)

T[1] == {
        ClassName -> TV,
	SelfConjugate -> True, 
	Indices -> {},
	Mass -> {MTV, 1000},
        Width -> {WTV, 20},
	PropagatorLabel -> "TV",
	PropagatorArrow -> None,
        FullName -> "New Neutral Symmetric Tensor" },

T[2] == {
        ClassName -> TVP,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MTVP, 1000},
        Width -> {WTVP, 20},
	QuantumNumbers -> {Q -> 1},
	PropagatorLabel -> "TVP",
	PropagatorArrow -> Forward,
	ParticleName ->"TVP+",
	AntiParticleName ->"TVP-",
        FullName -> "New Charged Symmetric Tensor" }

};

FSG[\[Mu]_, \[Nu]_, a_] :=  Module[{a2, a3}, 
  del[G[\[Nu], a], \[Mu]] - del[G[\[Mu], a], \[Nu]] + gs f[a, a2, a3] G[\[Mu], a2] G[\[Nu], a3]
];


LSV = SV (
   gSu[i, j] uqbar[s, i, a].uq[s, j, a] + I gPu[i, j] uqbar[r, i, a].Ga[5, r, s].uq[s, j, a] +
   gSd[i, j] dqbar[s, i, a].dq[s, j, a] + I gPd[i, j] dqbar[r, i, a].Ga[5, r, s].dq[s, j, a] +
    gSl[i, j] lbar[s, i].l[s, j] + I gPl[i, j] lbar[r, i].Ga[5, r, s].l[s, j] -
    1/4 gSg FSG[\[Mu], \[Nu], a] FSG[\[Mu], \[Nu], a]
   );

LVV = VV[\[Mu]] (
   uqbar[r, i, a].(gVu[i, j].Ga[\[Mu], r, s] + gAu[i, j].Ga[\[Mu], r, t].Ga[5, t, s]).uq[s, j, a] +
   dqbar[r, i, a].(gVd[i, j].Ga[\[Mu], r, s] + gAd[i, j].Ga[\[Mu], r, t].Ga[5, t, s]).dq[s, j, a] +
       lbar[r, i].(gVl[i, j].Ga[\[Mu], r, s] + gAl[i, j].Ga[\[Mu], r, t].Ga[5, t, s]).l[s, j]
   ) -
 (1/4) gVg FSG[\[Mu], \[Nu], a] FSG[\[Mu], \[Nu], a] del[VV[\[Alpha]], \[Alpha]];


LTV = I TV[\[Mu], \[Nu]] ((gTu[i, j].uqbar[r1, i, a] - 
        gUu[i, j].uqbar[r, i, a].Ga[5, r, r1]).(Ga[\[Mu], r1, s].del[
          uq[s, j, a], \[Nu]] + 
        Ga[\[Nu], r1, s].del[uq[s, j, a], \[Mu]]) + (gTd[i, j].dqbar[
          r1, i, a] - 
        gUd[i, j].dqbar[r, i, a].Ga[5, r, r1]).(Ga[\[Mu], r1, s].del[
          dq[s, j, a], \[Nu]] + 
        Ga[\[Nu], r1, s].del[dq[s, j, a], \[Mu]]) + (gTl[i, j].lbar[
          r1, i] - 
        gUl[i, j].lbar[r, i].Ga[5, r, r1]).(Ga[\[Mu], r1, s].del[
          l[s, j], \[Nu]] + Ga[\[Nu], r1, s].del[l[s, j], \[Mu]])) - 
  I TV[\[Mu], \[Nu]] ((del[uqbar[s, i, a], \[Mu]].Ga[\[Nu], s, r1] + 
        del[uqbar[s, i, a], \[Nu]].Ga[\[Mu], s, r1]).(Conjugate[
          gTu[j, i]].uq[r1, j, a] + 
        Conjugate[gUu[j, i]].Ga[5, r1, r].uq[r, j, a]) + (del[
          dqbar[s, i, a], \[Mu]].Ga[\[Nu], s, r1] + 
        del[dqbar[s, i, a], \[Nu]].Ga[\[Mu], s, r1]).(Conjugate[
          gTd[j, i]].dq[r1, j, a] + 
        Conjugate[gUd[j, i]].Ga[5, r1, r].dq[r, j, a]) + (del[
          lbar[s, i], \[Mu]].Ga[\[Nu], s, r1] + 
        del[lbar[s, i], \[Nu]].Ga[\[Mu], s, r1]).(Conjugate[
          gTl[j, i]].l[r1, j] + 
        Conjugate[gUl[j, i]].Ga[5, r1, r].l[r, j])) -
 1/4 gTg FSG[\[Mu], \[Alpha], a] FSG[\[Mu], \[Beta], a] TV[\[Alpha], \[Beta]];


LSVP = SVP (
    hSq[i, j] uqbar[s, i, a].dq[s, j, a] + 
     I hPq[i, j] uqbar[r, i, a].Ga[5, r, s].dq[s, j, a] +
     hSl[i, j] vlbar[s, i].l[s, j] + 
     I hPl[i, j] vlbar[r, i].Ga[5, r, s].l[s, j]
    ) +
  SVPbar (
    Conjugate[hSq[j, i]] dqbar[s, i, a].uq[s, j, a] + 
     I Conjugate[hPq[j, i]] dqbar[r, i, a].Ga[5, r, s].uq[s, j, a] +
     Conjugate[hSl[j, i]] lbar[s, i].vl[s, j] + 
     I Conjugate[hPl[j, i]] lbar[r, i].Ga[5, r, s].vl[s, j]
    );


LVVP = VVP[\[Mu]] (
    hVq[i, j] uqbar[s, i, a].Ga[\[Mu], s, r].dq[r, j, a] + 
     hAq[i, j] uqbar[s, i, a].Ga[\[Mu], s, r1].Ga[5, r1, r].dq[r, j, 
        a] +
     hVl[i, j] vlbar[s, i].Ga[\[Mu], s, r].l[r, j] + 
     hAl[i, j] vlbar[s, i].Ga[\[Mu], s, r1].Ga[5, r1, r].l[r, j]
    ) +
  VVPbar[\[Mu]] (
    Conjugate[hVq[j, i]] dqbar[s, i, a].Ga[\[Mu], s, r].uq[r, j, a] + 
     Conjugate[
       hAq[j, i]] dqbar[s, i, a].Ga[\[Mu], s, r1].Ga[5, r1, r].uq[r, 
        j, a] +
     Conjugate[hVl[j, i]] lbar[s, i].Ga[\[Mu], s, r].vl[r, j] + 
     Conjugate[
       hAl[j, i]] lbar[s, i].Ga[\[Mu], s, r1].Ga[5, r1, r].vl[r, j]
    );


LTVP = I TVP[\[Mu], \[Nu]] (
    (hTq[i, j].uqbar[r1, i, a] - 
        hUq[i, j].uqbar[r, i, a].Ga[5, r, r1]).(Ga[\[Mu], r1, s].del[
          dq[s, j, a], \[Nu]] + 
        Ga[\[Nu], r1, s].del[dq[s, j, a], \[Mu]]) +
     (hTl[i, j].vlbar[r1, i] - 
        hUl[i, j].vlbar[r, i].Ga[5, r, r1]).(Ga[\[Mu], r1, s].del[
          l[s, j], \[Nu]] + Ga[\[Nu], r1, s].del[l[s, j], \[Mu]])
    ) -
  I TVP[\[Mu], \[Nu]] (
    (del[uqbar[s, i, a], \[Mu]].Ga[\[Nu], s, r1] + 
        del[uqbar[s, i, a], \[Nu]].Ga[\[Mu], s, r1]).(hYq[i, j].dq[r1,
           j, a] + hZq[i, j].Ga[5, r1, r].dq[r, j, a]) +
     (del[vlbar[s, i], \[Mu]].Ga[\[Nu], s, r1] + 
        del[vlbar[s, i], \[Nu]].Ga[\[Mu], s, r1]).(hYl[i, j].l[r1, 
          j] + hZl[i, j].Ga[5, r1, r].l[r, j])
    ) -
  I TVPbar[\[Mu], \[Nu]] (
    (del[dqbar[s, i, a], \[Mu]].Ga[\[Nu], s, r1] + 
        del[dqbar[s, i, a], \[Nu]].Ga[\[Mu], s, r1]).(Conjugate[
          hTq[j, i]].uq[r1, j, a] + 
        Conjugate[hUq[j, i]].Ga[5, r1, r].uq[r, j, a]) +
     (del[lbar[s, i], \[Mu]].Ga[\[Nu], s, r1] + 
        del[lbar[s, i], \[Nu]].Ga[\[Mu], s, r1]).(Conjugate[
          hTl[j, i]].vl[r1, j] + 
        Conjugate[hUl[j, i]].Ga[5, r1, r].vl[r, j])
    ) +
  I TVPbar[\[Mu], \[Nu]] (
    (Conjugate[hYq[j, i]].dqbar[r1, i, a] - 
        Conjugate[hZq[j, i]].dqbar[r, i, a].Ga[5, r, r1]).(Ga[\[Mu], 
          r1, s].del[uq[s, j, a], \[Nu]] + 
        Ga[\[Nu], r1, s].del[uq[s, j, a], \[Mu]]) +
     (Conjugate[hYl[j, i]].lbar[r1, i] - 
        Conjugate[hZl[j, i]].lbar[r, i].Ga[5, r, r1]).(Ga[\[Mu], r1, 
          s].del[vl[s, j], \[Nu]] + 
        Ga[\[Nu], r1, s].del[vl[s, j], \[Mu]])
    );


Lplus=LSV+LVV+LTV+LSVP+LVVP+LTVP;