(* ****************************************************************** *)
(* *****                                                        ***** *)
(* *****  FeynRules model file: Simplified DM models            ***** *)
(* *****                                                        ***** *)
(* *****  Author: Benjamin Fuks                                 ***** *)
(* *****                                                        ***** *)
(* ****************************************************************** *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "DMsimp_t";

M$Information = { Authors->{"Benjamin Fuks"}, Emails->{"fuks@lpthe.jussieu.fr"},
                  Institutions->{"LPTHE / Sorbonne U."},
                  Date->"29.10.19", Version->"1.2",
                  URLs->"http://feynrules.irmp.ucl.ac.be/wiki/DMsimpt/"};

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 2019.05.22 v1.0 - First version                       *)
(* 2019.08.27 v1.1 - Changing a few PDG codes            *)
(* 2019.10.29 v1.2 - Adding complex scalar and vector DM *)

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)
M$InteractionOrderLimit     = { {DMT, 2} };
M$InteractionOrderHierarchy = { {QCD, 1}, {DMT, 2}, {QED, 2} };

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
  (* Dark matter *)
  F[100] == { ClassName -> Xm, SelfConjugate -> True,
              Mass -> {MXm, 10.}, Width -> 0, PDG -> 52},
  F[101] == { ClassName -> Xd, SelfConjugate -> False,
              Mass -> {MXd, 13.}, Width -> 0, PDG -> 57},
  S[100] == { ClassName -> Xs, SelfConjugate -> True,
              Mass -> {MXs, 11.}, Width -> 0, PDG -> 51},
  S[101] == { ClassName -> Xc, SelfConjugate -> False,
              Mass -> {MXc, 14.}, Width -> 0, PDG -> 56},
  V[100] == { ClassName -> Xv, SelfConjugate -> True,
              Mass -> {MXv, 12.}, Width -> 0, PDG -> 53},
  V[101] == { ClassName -> Xw, SelfConjugate -> False,
              Mass -> {MXw, 15.}, Width -> 0, PDG -> 58},

  (* Mediators *)
  S[200] == { ClassName -> YS3Q, Unphysical -> True, SelfConjugate -> False,
              Indices -> {Index[SU2D],Index[Generation],Index[Colour]}, FlavorIndex -> SU2D,
              QuantumNumbers -> {Y->1/6},
              Definitions -> {YS3Q[1,ff_,cc_]->YS3Qu[ff,cc], YS3Q[2,ff_,cc_]->YS3Qd[ff,cc]}},
  S[201] == { ClassName -> YS3Qu, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YS3Qu1, YS3Qu2, YS3Qu3},
              QuantumNumbers -> {Q->2/3}, PDG -> {1000002,1000004,1000006},
              Mass  -> {MYS3Qu, {MYS3Qu1, 1000.}, {MYS3Qu2, 1001.}, {MYS3Qu3, 1002.}},
              Width -> {WYS3Qu, {WYS3Qu1, 10.  }, {WYS3Qu2, 11.  }, {WYS3Qu3, 12.  }}},
  S[202] == { ClassName -> YS3Qd, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YS3Qd1, YS3Qd2, YS3Qd3},
              QuantumNumbers -> {Q->-1/3}, PDG -> {1000001,1000003,1000005},
              Mass  -> {MYS3Qd, {MYS3Qd1, 1003.}, {MYS3Qd2, 1004.}, {MYS3Qd3, 1005.}},
              Width -> {WYS3Qd, {WYS3Qd1, 13.  }, {WYS3Qd2, 14.  }, {WYS3Qd3, 15.  }}},
  S[203] == { ClassName -> YS3u, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YS3u1, YS3u2, YS3u3},
              QuantumNumbers -> {Y->2/3, Q->2/3}, PDG -> {2000002,2000004,2000006},
              Mass  -> {MYS3u, {MYS3u1, 2000.}, {MYS3u2, 2001.}, {MYS3u3, 2002.}},
              Width -> {WYS3u, {WYS3u1, 20.  }, {WYS3u2, 21.  }, {WYS3u3, 22.  }}},
  S[204] == { ClassName -> YS3d, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YS3d1, YS3d2, YS3d3},
              QuantumNumbers -> {Y->-1/3, Q->-1/3}, PDG -> {2000001,2000003,2000005},
              Mass  -> {MYS3d, {MYS3d1, 2003.}, {MYS3d2, 2004.}, {MYS3d3, 2005.}},
              Width -> {WYS3d, {WYS3d1, 23.  }, {WYS3d2, 24.  }, {WYS3d3, 25.  }}},
  F[200] == { ClassName -> YF3Q, Unphysical -> True, SelfConjugate -> False,
              Indices -> {Index[SU2D],Index[Generation],Index[Colour]}, FlavorIndex -> SU2D,
              QuantumNumbers -> {Y->1/6},
              Definitions -> {YF3Q[sp_,1,ff_,cc_]->YF3Qu[sp,ff,cc], YF3Q[sp_,2,ff_,cc_]->YF3Qd[sp,ff,cc]}},
  F[201] == { ClassName -> YF3Qu, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YF3Qu1, YF3Qu2, YF3Qu3},
              QuantumNumbers -> {Q->2/3}, PDG -> {5910002,5910004,5910006},
              Mass  -> {MYF3Qu, {MYF3Qu1, 3000.}, {MYF3Qu2, 3001.}, {MYF3Qu3, 3002.}},
              Width -> {WYF3Qu, {WYF3Qu1, 30.  }, {WYF3Qu2, 31.  }, {WYF3Qu3, 32.  }}},
  F[202] == { ClassName -> YF3Qd, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YF3Qd1, YF3Qd2, YF3Qd3},
              QuantumNumbers -> {Q->-1/3}, PDG -> {5910001,5910003,5910005},
              Mass  -> {MYF3Qd, {MYF3Qd1, 3003.}, {MYF3Qd2, 3004.}, {MYF3Qd3, 3005.}},
              Width -> {WYF3Qd, {WYF3Qd1, 33.  }, {WYF3Qd2, 34.  }, {WYF3Qd3, 35.  }}},
  F[203] == { ClassName -> YF3u, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YF3u1, YF3u2, YF3u3},
              QuantumNumbers -> {Y->2/3, Q->2/3}, PDG -> {5920002,5920004,5920006},
              Mass  -> {MYF3u, {MYF3u1, 4000.}, {MYF3u2, 4001.}, {MYF3u3, 4002.}},
              Width -> {WYF3u, {WYF3u1, 40.  }, {WYF3u2, 41.  }, {WYF3u3, 42.  }}},
  F[204] == { ClassName -> YF3d, SelfConjugate -> False,
              Indices -> {Index[Generation],Index[Colour]}, FlavorIndex -> Generation,
              ClassMembers -> {YF3d1, YF3d2, YF3d3},
              QuantumNumbers -> {Y->-1/3, Q->-1/3}, PDG -> {5920001,5920003,5920005},
              Mass  -> {MYF3d, {MYF3d1, 4003.}, {MYF3d2, 4004.}, {MYF3d3, 4005.}},
              Width -> {WYF3d, {WYF3d1, 43.  }, {WYF3d2, 44.  }, {WYF3d3, 45.  }}}

};

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

 lamS3Q == { ParameterType -> External, ComplexParameter -> False,
            TeX -> Subscript[\[Lambda],Q], BlockName -> DMS3Q,
            Indices -> {Index[Generation], Index[Generation]},
            InteractionOrder -> {DMT,1},
            Definitions -> {lamS3Q[i_?NumericQ, j_?NumericQ] :> 0  /; (i=!=j)},
            Value -> {lamS3Q[1,1] -> 0.10, lamS3Q[2,2] -> 0.11, lamS3Q[3,3] -> 0.12}},
 lamS3u == { ParameterType -> External, ComplexParameter -> False,
            TeX -> Subscript[\[Lambda],u], BlockName -> DMS3U,
            Indices -> {Index[Generation], Index[Generation]},
            InteractionOrder -> {DMT,1},
            Definitions -> {lamS3u[i_?NumericQ, j_?NumericQ] :> 0  /; (i=!=j)},
            Value -> {lamS3u[1,1] -> 0.13, lamS3u[2,2] -> 0.14, lamS3u[3,3] -> 0.15}},
 lamS3d == { ParameterType -> External, ComplexParameter -> False,
            TeX -> Subscript[\[Lambda],d], BlockName -> DMS3D,
            Indices -> {Index[Generation], Index[Generation]},
            InteractionOrder -> {DMT,1},
            Definitions -> {lamS3d[i_?NumericQ, j_?NumericQ] :> 0  /; (i=!=j)},
            Value -> {lamS3d[1,1] -> 0.16, lamS3d[2,2] -> 0.17, lamS3d[3,3] -> 0.18}},
 lamF3Q == { ParameterType -> External, ComplexParameter -> False,
            TeX -> Subscript[OverHat[\[Lambda]],Q], BlockName -> DMF3Q,
            Indices -> {Index[Generation], Index[Generation]},
            InteractionOrder -> {DMT,1},
            Definitions -> {lamF3Q[i_?NumericQ, j_?NumericQ] :> 0  /; (i=!=j)},
            Value -> {lamF3Q[1,1] -> 0.20, lamF3Q[2,2] -> 0.21, lamF3Q[3,3] -> 0.22}},
 lamF3u == { ParameterType -> External, ComplexParameter -> False,
            TeX -> Subscript[OverHat[\[Lambda]],u], BlockName -> DMF3U,
            Indices -> {Index[Generation], Index[Generation]},
            InteractionOrder -> {DMT,1},
            Definitions -> {lamF3u[i_?NumericQ, j_?NumericQ] :> 0  /; (i=!=j)},
            Value -> {lamF3u[1,1] -> 0.23, lamF3u[2,2] -> 0.24, lamF3u[3,3] -> 0.25}},
 lamF3d == { ParameterType -> External, ComplexParameter -> False,
            TeX -> Subscript[OverHat[\[Lambda]],d], BlockName -> DMF3D,
            Indices -> {Index[Generation], Index[Generation]},
            InteractionOrder -> {DMT,1},
            Definitions -> {lamF3d[i_?NumericQ, j_?NumericQ] :> 0  /; (i=!=j)},
            Value -> {lamF3d[1,1] -> 0.26, lamF3d[2,2] -> 0.27, lamF3d[3,3] -> 0.28}}
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LDMSIMPt := Block[{LKinDM, LKinS3, LKinF3, LIntS3, LIntF3, ii,ff,ffp,cc,mu,nu,sp,sp2},
  LKinDM :=  \
      1/2 del[Xs,mu]^2 - 1/2 MXs^2 Xs^2 \
    + del[Xc,mu] del[Xcbar,mu] - MXc^2 Xc Xcbar \
    + I/2*Xmbar.Ga[mu].DC[Xm,mu] - 1/2 MXm Xmbar.Xm \
    + I*Xdbar.Ga[mu].DC[Xd,mu] - MXd Xdbar.Xd \
    - 1/4 FS[Xv,mu,nu]^2 + 1/2 MXv^2 Xv[mu]^2 \
    - 1/2 FS[Xw,mu,nu] FS[Xwbar,mu,nu] + MXw^2 Xw[mu] Xwbar[mu];

  LKinS3 :=  \
      Plus @@ (DC[anti[#],mu] DC[#,mu] &/@ { YS3Q[ii,ff,cc], YS3ubar[ff,cc], YS3dbar[ff,cc]}) \
    - MYS3Qu[ff]^2 YS3Qubar[ff,cc] YS3Qu[ff,cc] - MYS3Qd[ff]^2 YS3Qdbar[ff,cc] YS3Qd[ff,cc] \
    - MYS3u[ff]^2  YS3ubar[ff,cc]  YS3u[ff,cc]  - MYS3d[ff]^2 YS3dbar[ff,cc] YS3d[ff,cc];

  LKinF3 :=  \
      Plus @@ (I anti[#].Ga[mu].DC[#,mu] &/@ { YF3Q, YF3u, YF3d } ) \
    - MYF3Qu[ff] YF3Qubar[sp,ff,cc].YF3Qu[sp,ff,cc] - MYF3Qd[ff] YF3Qdbar[sp,ff,cc].YF3Qd[sp,ff,cc] \
    - MYF3u[ff] YF3ubar[sp,ff,cc].YF3u[sp,ff,cc] \
    - MYF3d[ff] YF3dbar[sp,ff,cc].YF3d[sp,ff,cc];

  LIntS3 := \
     lamS3Q[ff,ffp] Xmbar[sp].QL[sp,ii,ff,cc] YS3Qbar[ii,ffp,cc] \
   + lamS3u[ff,ffp] Xmbar[sp].uR[sp,ff,cc] YS3ubar[ffp,cc] \
   + lamS3d[ff,ffp] Xmbar[sp].dR[sp,ff,cc] YS3dbar[ffp,cc] \
   + lamS3Q[ff,ffp] Xdbar[sp].QL[sp,ii,ff,cc] YS3Qbar[ii,ffp,cc] \
   + lamS3u[ff,ffp] Xdbar[sp].uR[sp,ff,cc] YS3ubar[ffp,cc] \
   + lamS3d[ff,ffp] Xdbar[sp].dR[sp,ff,cc] YS3dbar[ffp,cc];

  LIntF3 := \
     lamF3Q[ff,ffp] YF3Qbar[sp,ii,ffp,cc].QL[sp2,ii,ff,cc] (Xs IndexDelta[sp,sp2] + Xc IndexDelta[sp,sp2] + Xv[mu] Ga[mu,sp,sp2] + Xw[mu] Ga[mu,sp,sp2]) \
   + lamF3u[ff,ffp] YF3ubar[sp,ffp,cc].uR[sp2,ff,cc] (Xs IndexDelta[sp,sp2] + Xc IndexDelta[sp,sp2] + Xv[mu] Ga[mu,sp,sp2] + Xw[mu] Ga[mu,sp,sp2]) \
   + lamF3d[ff,ffp] YF3dbar[sp,ffp,cc].dR[sp2,ff,cc] (Xs IndexDelta[sp,sp2] + Xc IndexDelta[sp,sp2] + Xv[mu] Ga[mu,sp,sp2] + Xw[mu] Ga[mu,sp,sp2]);

LKinDM + LKinS3 + LKinF3 + LIntS3 + LIntF3 + HC[LIntS3] +HC[LIntF3]];



