(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16891,        387]
NotebookOptionsPosition[     15815,        346]
NotebookOutlinePosition[     16192,        363]
CellTagsIndexPosition[     16149,        360]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.7638865422974358`*^9, 3.763886542860983*^9}, {
  3.767372147789777*^9, 3.7673721483716993`*^9}}],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.518892288721245*^9, 3.518892291440427*^9}, {
  3.648272586359296*^9, 3.648272589589151*^9}, {3.744951163067635*^9, 
  3.744951164882929*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<FeynRules-path>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<dmsimpt_v1.2.fr\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.715342142509688*^9, 3.715342163031452*^9}, {
   3.715344057238492*^9, 3.715344058291609*^9}, {3.7178506900799713`*^9, 
   3.717850690973333*^9}, {3.7180002809816017`*^9, 3.718000300883692*^9}, {
   3.718000394980835*^9, 3.7180003951009827`*^9}, {3.745153113604156*^9, 
   3.745153113886346*^9}, {3.757403422964182*^9, 3.757403423697225*^9}, {
   3.758251145793989*^9, 3.7582511468706083`*^9}, 3.7582513470889874`*^9, {
   3.76335111930016*^9, 3.763351139093457*^9}, {3.7633511693483973`*^9, 
   3.763351173687544*^9}, {3.763886545633397*^9, 3.763886571907737*^9}, 
   3.767099220292862*^9, {3.767374514400957*^9, 3.767374515454331*^9}, {
   3.767375022418717*^9, 3.76737502255937*^9}, {3.7674580186709423`*^9, 
   3.767458019546134*^9}, {3.767610478088133*^9, 3.767610507175609*^9}, {
   3.767610538533186*^9, 3.76761053951677*^9}, {3.767610603703107*^9, 
   3.7676106297846937`*^9}, {3.7676900131323767`*^9, 
   3.7676900151887627`*^9}, {3.76858524470041*^9, 3.768585245204138*^9}, 
   3.7813360361054363`*^9, {3.787998176454199*^9, 3.787998182520714*^9}, {
   3.787998229044076*^9, 3.7879982315047207`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some tests with the model", "Section",
 CellChangeTimes->{{3.767692787921207*^9, 3.7676927912711573`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ldmt", " ", "=", " ", 
   RowBox[{"ExpandIndices", "[", "LDMSIMPt", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.781336183950905*^9, 3.781336191215129*^9}}],

Cell[BoxData[
 RowBox[{"GetMassSpectrum", "[", "ldmt", "]"}]], "Input",
 CellChangeTimes->{{3.767610740950831*^9, 3.7676107602572117`*^9}, {
   3.781336051591538*^9, 3.78133606108606*^9}, 3.7813361099861307`*^9, {
   3.781336188767009*^9, 3.7813361897629137`*^9}}],

Cell[BoxData[
 RowBox[{"CheckDiagonalQuadraticTerms", "[", "ldmt", "]"}]], "Input",
 CellChangeTimes->{{3.7676895540665007`*^9, 3.7676895951953173`*^9}, {
  3.781336198255192*^9, 3.781336198734817*^9}}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", "ldmt", "]"}]], "Input",
 CellChangeTimes->{{3.7676896174849567`*^9, 3.767689625546659*^9}, {
  3.781336201268805*^9, 3.781336201722522*^9}}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "ldmt", "]"}]], "Input",
 CellChangeTimes->{{3.767689518861446*^9, 3.767689528147897*^9}, {
  3.781341832372389*^9, 3.781341832878992*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating the NLO contributions", "Section",
 CellChangeTimes->{{3.642999850465013*^9, 3.642999854784058*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<DiagonalCKM.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lren", "=", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{
     RowBox[{"ExpandIndices", "[", 
      RowBox[{"LSM", "+", "LDMSIMPt"}], "]"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteFeynArtsOutput", "[", 
   RowBox[{"Lren", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<DMsimpt_v1_2_FA\>\""}], ",", 
    RowBox[{"ConservedQuantumNumbers", "\[Rule]", "Q"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.6429998579231567`*^9, 3.642999859329811*^9}, {
   3.643276600822646*^9, 3.643276602600128*^9}, 3.643452302817659*^9, {
   3.643480537105691*^9, 3.643480544715995*^9}, {3.643505764015731*^9, 
   3.643505765417059*^9}, {3.644167428496661*^9, 3.644167429429887*^9}, {
   3.644562474709917*^9, 3.6445624788370237`*^9}, {3.6446876189863234`*^9, 
   3.644687621537224*^9}, {3.644687662149605*^9, 3.644687673094878*^9}, {
   3.644687705747959*^9, 3.6446877072824593`*^9}, {3.644716329653895*^9, 
   3.644716337245138*^9}, {3.653766992283938*^9, 3.6537669926652613`*^9}, {
   3.66486033666195*^9, 3.664860348452221*^9}, {3.6651967505902653`*^9, 
   3.66519675295021*^9}, {3.666353407678645*^9, 3.6663534078574247`*^9}, {
   3.6696408162954607`*^9, 3.6696408168073807`*^9}, {3.680924453059774*^9, 
   3.680924453696932*^9}, {3.684872238601376*^9, 3.684872238783848*^9}, {
   3.685101810835946*^9, 3.6851018117067204`*^9}, {3.685258606756963*^9, 
   3.685258632938881*^9}, {3.7022822288595123`*^9, 3.7022822295009947`*^9}, {
   3.705919839077444*^9, 3.7059198410538063`*^9}, {3.7196587589519463`*^9, 
   3.7196587651284313`*^9}, {3.7676928183490562`*^9, 
   3.7676928418497753`*^9}, {3.767692880674725*^9, 3.767692886898861*^9}, {
   3.767693498862368*^9, 3.767693501513042*^9}, {3.767696534455364*^9, 
   3.7676965469737167`*^9}, {3.781341692617463*^9, 3.781341693849312*^9}, {
   3.7813418682918777`*^9, 3.7813418691373663`*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.642999917153137*^9, 3.642999917670817*^9}}],

Cell[CellGroupData[{

Cell["The following part takes about 2 hours", "Subsubsection",
 CellChangeTimes->{{3.768618629083808*^9, 3.768618637043517*^9}}],

Cell[BoxData[{
 RowBox[{"<<", " ", "FeynArts`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<<FeynRules-path\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", " ", "NLOCT`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{
   "\"\<DMsimpt_5FNS_FA/DMsimpt_v1_2_FA\>\"", ",", 
    "\"\<DMsimpt_5FNS_FA/DMsimpt_v1_2_FA\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"Output", "->", "\"\<DMsimpt_v1_2\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"KeptIndices", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", ">", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"MXs", ">", "0"}], ",", 
       RowBox[{"MXm", ">", "0"}], ",", 
       RowBox[{"MXv", ">", "0"}], ",", 
       RowBox[{"MXc", ">", "0"}], ",", 
       RowBox[{"MXw", ">", "0"}], ",", 
       RowBox[{"MXd", ">", "0"}], ",", " ", 
       RowBox[{"MYS3Qu1", ">", "0"}], ",", 
       RowBox[{"MYS3Qu2", ">", "0"}], ",", 
       RowBox[{"MYS3Qu3", ">", "0"}], ",", 
       RowBox[{"MYS3u1", ">", "0"}], ",", 
       RowBox[{"MYS3u2", ">", "0"}], ",", 
       RowBox[{"MYS3u3", ">", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"MYS3Qd1", ">", "0"}], ",", 
       RowBox[{"MYS3Qd2", ">", "0"}], ",", 
       RowBox[{"MYS3Qd3", ">", "0"}], ",", 
       RowBox[{"MYS3d1", ">", "0"}], ",", 
       RowBox[{"MYS3d2", ">", "0"}], ",", 
       RowBox[{"MYS3d3", ">", "0"}], ",", " ", 
       RowBox[{"MYF3Qu1", ">", "0"}], ",", 
       RowBox[{"MYF3Qu2", ">", "0"}], ",", 
       RowBox[{"MYF3Qu3", ">", "0"}], ",", 
       RowBox[{"MYF3u1", ">", "0"}], ",", 
       RowBox[{"MYF3u2", ">", "0"}], ",", 
       RowBox[{"MYF3u3", ">", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"MYF3Qd1", ">", "0"}], ",", 
       RowBox[{"MYF3Qd2", ">", "0"}], ",", 
       RowBox[{"MYF3Qd3", ">", "0"}], ",", 
       RowBox[{"MYF3d1", ">", "0"}], ",", 
       RowBox[{"MYF3d2", ">", "0"}], ",", 
       RowBox[{"MYF3d3", ">", "0"}]}], "\[IndentingNewLine]", "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"CTparameters", "\[Rule]", "True"}], ",", 
    RowBox[{"MaxDim", "\[Rule]", "4"}], ",", 
    RowBox[{"EvenOnly", "\[Rule]", "False"}], ",", 
    RowBox[{"IsFeynmanGauge", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.642999923841711*^9, 3.642999971642317*^9}, {
   3.6430000242728033`*^9, 3.6430000258010807`*^9}, {3.643000095706285*^9, 
   3.643000131827043*^9}, 3.643130451253806*^9, {3.64348055340506*^9, 
   3.6434805576479883`*^9}, {3.643505367192779*^9, 3.64350537935256*^9}, {
   3.644148039245747*^9, 3.644148042099621*^9}, {3.6441484397475653`*^9, 
   3.644148448904045*^9}, {3.6441699926794443`*^9, 3.644170028874009*^9}, {
   3.644562487653529*^9, 3.644562523323406*^9}, {3.644688360980824*^9, 
   3.644688386313058*^9}, {3.6446884667375603`*^9, 3.644688489652257*^9}, {
   3.644688523143263*^9, 3.644688525417777*^9}, {3.644688597819372*^9, 
   3.64468860628026*^9}, {3.644688740582252*^9, 3.644688753170827*^9}, {
   3.644689067130622*^9, 3.6446890722102203`*^9}, {3.644716655505249*^9, 
   3.644716662092123*^9}, {3.6537477330376*^9, 3.653747733378034*^9}, {
   3.653767291988488*^9, 3.653767310117466*^9}, {3.664861289489751*^9, 
   3.664861292258481*^9}, 3.664863692532228*^9, {3.664867992675673*^9, 
   3.664867993234062*^9}, {3.664868576870771*^9, 3.664868577096312*^9}, {
   3.665197213131104*^9, 3.6651972517927322`*^9}, 3.665224591796699*^9, {
   3.6652246469325542`*^9, 3.6652246689666843`*^9}, 3.66522470623314*^9, {
   3.666353902841914*^9, 3.666353914000782*^9}, {3.680925124972067*^9, 
   3.680925151786419*^9}, {3.68487289426202*^9, 3.68487290445006*^9}, {
   3.685102785032526*^9, 3.685102805534514*^9}, {3.6852586646434383`*^9, 
   3.685258799023717*^9}, {3.685296637485779*^9, 3.6852966377979794`*^9}, {
   3.702282507829064*^9, 3.702282517906333*^9}, {3.7059200467759657`*^9, 
   3.705920084081114*^9}, {3.7155691757631693`*^9, 3.715569226231048*^9}, {
   3.7196601365561113`*^9, 3.719660158999943*^9}, {3.767693883945985*^9, 
   3.767694033308322*^9}, {3.781413981225663*^9, 3.7814140015802794`*^9}, {
   3.78799824185106*^9, 3.787998260428205*^9}, {3.7879982967676897`*^9, 
   3.7879983127861757`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating the UFO model files", "Section",
 CellChangeTimes->{{3.518892302672626*^9, 3.518892305688608*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.643510536070684*^9, 3.643510536921255*^9}, {
  3.685115982897347*^9, 3.685115983927444*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<FeynRules-path\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<sm.fr\>\"", ",", "\"\<dmsimpt_v1.2.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<DiagonalCKM.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Get", "[", "\"\<DMsimpt_v1_2.nlo\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
    RowBox[{"ExpandIndices", "[", 
     RowBox[{"LSM", "+", "LDMSIMPt"}], "]"}], ",", 
    RowBox[{"UVCounterterms", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"UV$vertlist", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "\[Rule]", "1"}], ",", 
         RowBox[{"FR$IRLog", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], " ", ",", 
    RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", " ", 
    RowBox[{"CTParameters", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FR$CTparam", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FR$IR", "\[Rule]", "1"}], ",", 
         RowBox[{"FR$IRLog", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"Output", "\[Rule]", "\"\<DMSimpt_NLO_v1_2_UFO\>\""}], ",", 
    RowBox[{"ConservedQuantumNumbers", "\[Rule]", "Q"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.616474426822394*^9, 3.616474431300906*^9}, {
   3.616474476497079*^9, 3.616474500189231*^9}, 3.616474613066862*^9, {
   3.616494779207423*^9, 3.616494783828376*^9}, {3.616580249965948*^9, 
   3.616580268353311*^9}, {3.616580334915408*^9, 3.616580354074359*^9}, {
   3.616730859450924*^9, 3.6167308627148323`*^9}, {3.618221520121941*^9, 
   3.618221562907246*^9}, {3.618575869806182*^9, 3.6185758768210573`*^9}, {
   3.622267142817052*^9, 3.622267158950058*^9}, {3.622517903231851*^9, 
   3.6225179034762793`*^9}, {3.643130455506323*^9, 3.643130457362434*^9}, {
   3.6434346190475397`*^9, 3.643434619424014*^9}, {3.64348057990516*^9, 
   3.643480585441132*^9}, {3.643510546826219*^9, 3.643510547036009*^9}, 
   3.643510612235943*^9, {3.644167155986382*^9, 3.644167191812931*^9}, 
   3.644167230066971*^9, {3.6441963555808783`*^9, 3.644196376311118*^9}, {
   3.644655765357386*^9, 3.644655792069653*^9}, {3.644657487967403*^9, 
   3.644657488293757*^9}, {3.644690534728881*^9, 3.644690564194496*^9}, {
   3.644718127240486*^9, 3.644718150450329*^9}, {3.644773045108694*^9, 
   3.64477305063905*^9}, {3.6648679275349216`*^9, 3.664867941450377*^9}, {
   3.66486800077952*^9, 3.664868030360639*^9}, 3.665157439581449*^9, {
   3.665167780369707*^9, 3.665167780545179*^9}, {3.665168588211299*^9, 
   3.665168592717914*^9}, {3.6651971988810463`*^9, 3.66519722299328*^9}, {
   3.665202155064212*^9, 3.665202192262845*^9}, {3.665203934931046*^9, 
   3.665203948163241*^9}, {3.6652275940615873`*^9, 3.665227626288574*^9}, {
   3.666370588762989*^9, 3.666370599370613*^9}, {3.6809283770423527`*^9, 
   3.680928391177864*^9}, {3.6809284597589483`*^9, 3.680928468565295*^9}, {
   3.6850905415403833`*^9, 3.685090563522331*^9}, {3.685115987844707*^9, 
   3.685116002486989*^9}, {3.685296608849427*^9, 3.68529667156424*^9}, 
   3.685296720871242*^9, {3.7004397932622633`*^9, 3.700439818286146*^9}, {
   3.702287485923066*^9, 3.702287489851747*^9}, {3.7027196245861387`*^9, 
   3.702719662830946*^9}, {3.70593026317251*^9, 3.705930278721766*^9}, {
   3.7059383683537188`*^9, 3.70593839697304*^9}, {3.719671059944165*^9, 
   3.7196710793237*^9}, 3.719671534996559*^9, {3.767696470779224*^9, 
   3.767696479654022*^9}, {3.767696557679223*^9, 3.767696575761361*^9}, {
   3.767703118281695*^9, 3.7677030816273823`*^9}, {3.76770356577351*^9, 
   3.767703584369676*^9}, {3.781509394665051*^9, 3.78150943303577*^9}, {
   3.787998319494505*^9, 3.7879983270071917`*^9}}]
}, Open  ]]
},
WindowSize->{1311, 939},
WindowMargins->{{Automatic, 78}, {30, Automatic}},
ShowSelection->True,
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 171, 3, 28, "Input"],
Cell[CellGroupData[{
Cell[741, 27, 188, 3, 64, "Section"],
Cell[932, 32, 1604, 29, 80, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2573, 66, 112, 1, 64, "Section"],
Cell[2688, 69, 194, 4, 28, "Input"],
Cell[2885, 75, 264, 4, 28, "Input"],
Cell[3152, 81, 202, 3, 28, "Input"],
Cell[3357, 86, 202, 3, 28, "Input"],
Cell[3562, 91, 188, 3, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3787, 99, 117, 1, 64, "Section"],
Cell[3907, 102, 2279, 42, 80, "Input"],
Cell[6189, 146, 118, 2, 28, "Input"],
Cell[CellGroupData[{
Cell[6332, 152, 129, 1, 35, "Subsubsection"],
Cell[6464, 155, 4908, 97, 250, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11421, 258, 115, 1, 64, "Section"],
Cell[11539, 261, 167, 3, 28, "Input"],
Cell[11709, 266, 4090, 77, 148, "Input"]
}, Open  ]]
}
]
*)

