# This file was automatically created by FeynRules 2.4.55
# Mathematica version: 11.0.1 for Mac OS X x86 (64-bit) (September 21, 2016)
# Date: Thu 16 Mar 2017 17:39:37



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# This is a default parameter object representing the renormalization scale (MU_R).
MU_R = Parameter(name = 'MU_R',
                 nature = 'external',
                 type = 'real',
                 value = 91.188,
                 texname = '\\text{\\mu_r}',
                 lhablock = 'LOOP',
                 lhacode = [1])

# User-defined parameters.
Lambda = Parameter(name = 'Lambda',
                   nature = 'external',
                   type = 'real',
                   value = 1000.,
                   texname = '\\Lambda',
                   lhablock = 'DMINPUTS',
                   lhacode = [ 1 ])

gTg = Parameter(name = 'gTg',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = '\\text{gT}_g',
                lhablock = 'DMINPUTS',
                lhacode = [ 2 ])

gTw = Parameter(name = 'gTw',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = '\\text{gT}_W',
                lhablock = 'DMINPUTS',
                lhacode = [ 3 ])

gTb = Parameter(name = 'gTb',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = '\\text{gT}_B',
                lhablock = 'DMINPUTS',
                lhacode = [ 4 ])

gTq = Parameter(name = 'gTq',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = '\\text{gT}_q',
                lhablock = 'DMINPUTS',
                lhacode = [ 5 ])

gTq3 = Parameter(name = 'gTq3',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = '\\text{gT}_{\\text{q3}}',
                 lhablock = 'DMINPUTS',
                 lhacode = [ 6 ])

gTl = Parameter(name = 'gTl',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = '\\text{gT}_l',
                lhablock = 'DMINPUTS',
                lhacode = [ 7 ])

gTh = Parameter(name = 'gTh',
                nature = 'external',
                type = 'real',
                value = 1.,
                texname = '\\text{gT}_h',
                lhablock = 'DMINPUTS',
                lhacode = [ 8 ])

gTXr = Parameter(name = 'gTXr',
                 nature = 'external',
                 type = 'real',
                 value = 0.,
                 texname = '\\text{gT}_{\\text{Xr}}',
                 lhablock = 'DMINPUTS',
                 lhacode = [ 9 ])

gTXd = Parameter(name = 'gTXd',
                 nature = 'external',
                 type = 'real',
                 value = 1.,
                 texname = '\\text{gT}_{\\text{Xd}}',
                 lhablock = 'DMINPUTS',
                 lhacode = [ 10 ])

gTXv = Parameter(name = 'gTXv',
                 nature = 'external',
                 type = 'real',
                 value = 0.,
                 texname = '\\text{gT}_{\\text{Xv}}',
                 lhablock = 'DMINPUTS',
                 lhacode = [ 11 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

MXr = Parameter(name = 'MXr',
                nature = 'external',
                type = 'real',
                value = 10.,
                texname = '\\text{MXr}',
                lhablock = 'MASS',
                lhacode = [ 5000511 ])

MXd = Parameter(name = 'MXd',
                nature = 'external',
                type = 'real',
                value = 10.,
                texname = '\\text{MXd}',
                lhablock = 'MASS',
                lhacode = [ 5000521 ])

MXv = Parameter(name = 'MXv',
                nature = 'external',
                type = 'real',
                value = 10.,
                texname = '\\text{MXv}',
                lhablock = 'MASS',
                lhacode = [ 5000531 ])

MY2 = Parameter(name = 'MY2',
                nature = 'external',
                type = 'real',
                value = 1000.,
                texname = '\\text{MY2}',
                lhablock = 'MASS',
                lhacode = [ 5000002 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00407,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

WY2 = Parameter(name = 'WY2',
                nature = 'external',
                type = 'real',
                value = 10.,
                texname = '\\text{WY2}',
                lhablock = 'DECAY',
                lhacode = [ 5000002 ])

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(2*MW*sw)/ee',
                texname = '\\text{vev}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/vev',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = '(ymtau*cmath.sqrt(2))/vev',
                 texname = '\\text{ytau}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*vev**2)',
                texname = '\\mu')

