(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     62317,       1461]
NotebookOptionsPosition[     52307,       1329]
NotebookOutlinePosition[     52700,       1345]
CellTagsIndexPosition[     52657,       1342]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"$FeynRulesPath", "=", 
    RowBox[{
    "SetDirectory", 
     "[", "\"\</Users/gianmarcolucchetti/PhD/MadDM/models/feynrules-current\>\
\"", "]"}]}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.872077100083353*^9, 3.87207710008435*^9}, 
   3.9578501222262983`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"3e77898c-71b5-4706-b397-586470c893e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], "\n"}]], "Input",
 CellChangeTimes->{{3.8720771131728888`*^9, 3.87207711317389*^9}, 
   3.872135464524799*^9, 3.8721355151883593`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"6d9385a4-1a91-4810-95eb-9d05eb36abef"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272527322*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2c1a3de7-b084-4473-b1be-d9e2907a16de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.49\"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"29 September 2021\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.49", " (" "29 September 2021", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272527953*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a7b4458b-6e18-45f0-ba5c-9c3d1ca87457"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272529845*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2c8530b3-e1e2-434d-bb9e-fb0f48b563eb"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272530182*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"efba7342-9ab4-4879-9cc4-a7872bca9e91"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272530472*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"7d30eecf-d673-4d43-b06e-1a447b812f98"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272530767*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"9cf61268-17ea-49a8-8317-0394250ea815"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272531083*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"979324c4-1ebc-43e1-bfc1-961cecd4c638"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272531384*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"c814d2f4-825b-43d2-b070-7a65c685e03f"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.9578632725316772`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"f96e4ddd-fd43-4e45-8c45-5fa49b6fc1f7"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272531988*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"f885c4f0-d57e-402d-b144-e9e32f5e2a9c"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.9578501321960077`*^9, 3.957850864057578*^9, 
  3.9578509081025667`*^9, 3.9578513126644583`*^9, 3.957862516585202*^9, 
  3.9578628932246428`*^9, 3.957863272532279*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"849ed595-5e4a-4aab-acb5-e25160b8180e"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 2, 1, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{{3.957850020251515*^9, 3.95785003638723*^9}, 
   3.957850096382869*^9, 3.9578501323569927`*^9, 3.957850864200902*^9, 
   3.957850908263095*^9, 3.957851312822927*^9, 3.957862516743368*^9, 
   3.957862893374837*^9, 3.957863272705143*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"568162b7-f996-4a90-9bb8-eb84743f604f"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 2, 2, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{{3.957850020251515*^9, 3.95785003638723*^9}, 
   3.957850096382869*^9, 3.9578501323569927`*^9, 3.957850864200902*^9, 
   3.957850908263095*^9, 3.957851312822927*^9, 3.957862516743368*^9, 
   3.957862893374837*^9, 3.957863272751128*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"5c31c7d7-2bcb-445b-a5aa-cfa55509322a"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 2, 3, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{{3.957850020251515*^9, 3.95785003638723*^9}, 
   3.957850096382869*^9, 3.9578501323569927`*^9, 3.957850864200902*^9, 
   3.957850908263095*^9, 3.957851312822927*^9, 3.957862516743368*^9, 
   3.957862893374837*^9, 3.957863272753231*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"c0add526-4701-4f79-ae96-269713dd7f8d"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 2, 4, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{{3.957850020251515*^9, 3.95785003638723*^9}, 
   3.957850096382869*^9, 3.9578501323569927`*^9, 3.957850864200902*^9, 
   3.957850908263095*^9, 3.957851312822927*^9, 3.957862516743368*^9, 
   3.957862893374837*^9, 3.9578632727552423`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"27ad3765-137a-44e5-84e3-28fa2afc366e"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 5, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9578632768146143`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"b56b70ea-5207-43d2-88f9-e7430a9fc916"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 6, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276842696*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"83af00ec-16e8-489c-84c4-0907922dde44"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 7, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276856552*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"8a806ece-90dc-4fa6-b940-be8ae6d3bdad"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 8, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276880652*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"305af8f6-d959-498c-b6da-097841fb373e"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 9, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276898919*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"0ec84c5e-2fde-417a-948d-2630ac9bff58"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 10, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9578632769192743`*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"a73e3a92-c25b-4ba2-8527-b5058d47f9f1"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 11, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276940756*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"42aea943-0d13-4d3a-9f0c-6fab2e9046f3"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 12, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276951561*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"af3a05dd-9b74-4396-b610-0a8ecd126dac"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 13, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276963896*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"f26b8489-3f76-4880-a0b6-f11e0de5ac2a"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 14, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276968646*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"27627377-aa6d-413a-b0bf-36a1aa1c655c"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 15, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9578632769808273`*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"14a7c0c8-8c9d-48b2-a9f9-d32c08afb24f"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 16, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863276994134*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"fcb236c5-212a-49c3-b923-3252c2d90606"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 17, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.95786327700008*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"485d3fe4-f015-4c90-ac4b-44f98f4fa1d6"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 18, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9578632770123873`*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"e3e53fe5-54d6-42d8-84b0-51b0c3773890"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 19, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277029697*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"e08ba1d5-d461-4dee-9d09-43f26d274904"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 20, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.95786327703461*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"488287e0-3436-4cf3-a627-85883f71f29a"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 21, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277047275*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"c1a7ad55-2860-40c6-9ab6-0b37e3ee1dad"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 22, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.95786327705204*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"d52cc4d2-94bc-4b0f-89eb-7d3778d924d1"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 23, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277064145*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"b0bb7b30-a1da-4d1e-9de0-313881f54daa"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 24, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277080873*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"d44ffdf1-6d6a-401e-9c6d-0cc1f68f32af"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 25, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277086774*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"4f741ecd-9059-4634-8114-f7f370f1bc01"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 26, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277101816*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"0177d6e6-ca9a-47e9-bf41-62f6afaabecb"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 27, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277127378*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"e870b7b0-85eb-4a6f-a01f-2bbaf5a6b247"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 28, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277132563*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"37ce6831-df99-4158-9223-2d889f0c677c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 29, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277144668*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"560b9bf3-7674-40b2-bc5e-bf108a62a91e"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 30, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277149403*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"f65bf00a-9c6f-4772-bdff-44d1d8d655db"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 31, 
   29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277161374*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"620c46b8-a391-4813-ac7d-afc6e3635b51"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 32, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277165943*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"1128d463-73c7-487e-a529-68a9cbec593c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 33, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.95786327717822*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"6d6ebb8f-468c-457f-8f65-6b0496bb7aa6"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 34, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277182679*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"8bf35404-e4a2-43ba-9ef0-984329d0e72f"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 35, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9578632771973763`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"40eefeb2-162c-43b8-bd55-004c998e4ab2"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 36, 29336549118663890662, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957863277200919*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"7e31dd13-1551-4c32-a6f8-806bfd8a3328"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", 
    "[", "\"\</Users/gianmarcolucchetti/PhD/MadDM/models/eDMsimp_s_spin1\>\"",
     "]"}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.87207712133959*^9, 3.872077121341593*^9}, {
   3.8721390541533685`*^9, 3.872139059524665*^9}, {3.910686612090931*^9, 
   3.91068661404452*^9}, 3.911220194467496*^9, {3.957849900665443*^9, 
   3.957849919468021*^9}, {3.957850073203478*^9, 3.957850078879385*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"2aff33bf-c914-4c58-a535-9a6bebf7fb4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<SM.fr\>\"", ",", "\"\<edm_s_spin1.fr\>\""}], "]"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.872077136459931*^9, 3.8720771364609213`*^9}, {
   3.8720776190764093`*^9, 3.8720776198076553`*^9}, 3.872135517957418*^9, {
   3.9112201871147866`*^9, 3.9112201894423585`*^9}, {3.9578500014694767`*^9, 
   3.95785000409621*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"e6fa683c-955c-4919-8308-10befe9bb548"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278024888*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0eb1681d-167e-4863-af33-6e8d5ad7a7e2"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278028325*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"ca2759f9-f80e-448e-9774-4d3fe579adfe"],

Cell[BoxData["\<\"Gian Marco Lucchetti\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278028989*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"34a227d0-5ff1-40b5-a532-8a1f2d8a87c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.9578632780295057`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d4b279ea-6fcf-49d1-988b-5a91c9660cbf"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278029842*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"da1a86f6-e62f-46d1-9799-7b3176ab129f"],

Cell[BoxData["\<\"Haider Alhazmi et al., arXiv:2006.16252v2\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.9578632780304003`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0a009dd8-8872-45ab-85e2-62c2b4eabc3b"],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278031106*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0da577e8-3dd2-4107-9e13-a9df0b8bf4a6"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278031679*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"8cf36fc3-50ef-4c57-9f58-fad45960f7ba"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278032383*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"45b6924a-d0fc-4306-83ce-2dcb73f69574"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278032919*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2e39683c-b7b5-4da2-a9d6-794cae9a079c"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278091446*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"633f427e-01d7-4d6b-9eaf-b43f7a98bf4e"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.957863278093329*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c642c435-72e7-461d-a346-f7b25ada7d3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"eDMsimp_s_spin1\"\>",
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "eDMsimp_s_spin1", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.957850137110907*^9, 3.957850868197448*^9, 
  3.957850912130094*^9, 3.9578513165678873`*^9, 3.957862521015276*^9, 
  3.9578628983102617`*^9, 3.9578632781191*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"cfb3356e-9ff8-41d5-a6de-7cb3191d8f67"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LVNew", "]"}]], "Input",
 CellChangeTimes->{{3.8770670459058666`*^9, 3.8770670476847286`*^9}, {
  3.877068200855322*^9, 3.8770682047763433`*^9}, {3.910686142636731*^9, 
  3.910686146810019*^9}, {3.9106862133632708`*^9, 3.9106862187720175`*^9}, {
  3.910686401207466*^9, 3.910686411290904*^9}, {3.9106866933488398`*^9, 
  3.9106866950576477`*^9}, {3.9112202087681146`*^9, 3.9112202165547323`*^9}, {
  3.957850007722612*^9, 3.957850008003125*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"3983cf50-bf60-485f-8860-de91e9bf0df4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.9578632781351147`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"95a1bce6-5613-4482-937c-aaa38e440c48"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.9578632781358147`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"94d28c47-b81c-41a8-b7fa-71f38a5566a4"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.957863278207388*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"905befb2-33e5-4b54-a1c5-3d46f6918d09"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.957863278208168*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"78c11aa4-040f-4b40-8bf3-26d20f458fe6"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.9578632782085733`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"af5396fb-4a57-4b83-bd7b-72552c762e5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.957863278208982*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"784fac0f-e638-4789-bda9-4ba586129d20"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.957850137212668*^9, 3.957850868410883*^9, 
  3.957850912227116*^9, 3.957851316667791*^9, 3.957862521131319*^9, 
  3.957862898416211*^9, 3.957863278221142*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"1f6db9e5-a7f5-4739-a0c4-e66024bd30bc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.9112773586263933`*^9, {3.957850022442808*^9, 3.957850036418784*^9}, 
   3.957850096403322*^9, 3.9578501373109922`*^9, 3.957850868604772*^9, 
   3.957850912304996*^9, 3.957851316747369*^9, 3.9578625212223387`*^9, 
   3.95786289844906*^9, 3.957863278226427*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"6a7deaee-42b8-4f67-a2e1-54197069e0e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LVNew", "]"}]], "Input",
 CellChangeTimes->{{3.872077145528018*^9, 3.872077145530012*^9}, {
   3.87207757884532*^9, 3.8720775825562205`*^9}, 3.872077843857835*^9, 
   3.872077891379122*^9, {3.8720780071521072`*^9, 3.872078017191123*^9}, {
   3.872132071016568*^9, 3.8721320822718163`*^9}, {3.87213213811709*^9, 
   3.8721321553273335`*^9}, {3.872132476741374*^9, 3.8721324772007523`*^9}, {
   3.872132739663206*^9, 3.8721327405161123`*^9}, {3.872132810266752*^9, 
   3.872132810613639*^9}, {3.872132967243039*^9, 3.872132974622429*^9}, {
   3.8721330059010286`*^9, 3.8721330061654263`*^9}, {3.872135798254359*^9, 
   3.87213579850436*^9}, {3.872136269162527*^9, 3.8721362708497796`*^9}, {
   3.8745576842117624`*^9, 3.8745576890348773`*^9}, {3.8746596190482454`*^9, 
   3.8746596217558985`*^9}, {3.874916809712614*^9, 3.8749168359643936`*^9}, {
   3.8749172458329077`*^9, 3.8749172474381657`*^9}, 3.8765681993172007`*^9, {
   3.876568307070857*^9, 3.8765683197423906`*^9}, {3.8765700363536687`*^9, 
   3.8765700418412275`*^9}, {3.8765715469937387`*^9, 3.876571564240671*^9}, {
   3.876571962494031*^9, 3.876571963744278*^9}, {3.8769039833998356`*^9, 
   3.8769039866137557`*^9}, {3.8769205602164097`*^9, 3.876920561107032*^9}, {
   3.9106863807723503`*^9, 3.9106863871706133`*^9}, {3.9112202200231447`*^9, 
   3.911220221497362*^9}, {3.957850011371787*^9, 3.9578500115726337`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"3b58d9f5-310b-4525-aa2a-0add26b681e8"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.957850137342011*^9, 3.957850868610218*^9, 
  3.957850912309417*^9, 3.9578513167514763`*^9, 3.9578625212590218`*^9, 
  3.9578628984675083`*^9, 3.957863278257099*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"ee7b247b-64e6-4c42-9702-dfb1edc43abc"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.957850137342011*^9, 3.957850868610218*^9, 
  3.957850912309417*^9, 3.9578513167514763`*^9, 3.9578625212590218`*^9, 
  3.9578628984675083`*^9, 3.9578632782582684`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"45885e0e-a74c-4013-89d4-bca34f49160c"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.957850137342011*^9, 3.957850868610218*^9, 
  3.957850912309417*^9, 3.9578513167514763`*^9, 3.9578625212590218`*^9, 
  3.9578628984675083`*^9, 3.957863278285202*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"34cc3736-e66c-492b-a91d-588ef2baa90f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7.2, {0.14400000000000002`, 7.8}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.957850137342011*^9, 3.957850868610218*^9, 
  3.957850912309417*^9, 3.9578513167514763`*^9, 3.9578625212590218`*^9, 
  3.9578628984675083`*^9, 3.9578632782858763`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"cd10400d-7feb-4583-8fd3-4b525d496470"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.957850137342011*^9, 3.957850868610218*^9, 
  3.957850912309417*^9, 3.9578513167514763`*^9, 3.9578625212590218`*^9, 
  3.9578628984675083`*^9, 3.957863278311459*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"9d15fcfa-bbbf-4bbe-a9e9-aa033dde7a27"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Xc", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["Xc", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["g", "VXc"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       SubscriptBox["g", "VXc"], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", 
        SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["g", "Ve"], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "2"]}]], 
         SubscriptBox["\"\[Mu]\"", "3"]},
        "Superscript"]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "Ae"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         TemplateBox[{"\[Gamma]", "5"},
          "Superscript"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["Xd", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Xd", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y1", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SubscriptBox["g", "VXd"], " ", 
       TemplateBox[{
         SubscriptBox["\[Gamma]", 
          RowBox[{
            SubscriptBox["\"s\"", "1"], ",", 
            SubscriptBox["\"s\"", "2"]}]], 
         SubscriptBox["\"\[Mu]\"", "3"]},
        "Superscript"]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["g", "AXd"], " ", 
       SubscriptBox[
        RowBox[{
         TemplateBox[{"\[Gamma]", 
           SubscriptBox["\"\[Mu]\"", "3"]},
          "Superscript"], ".", 
         TemplateBox[{"\[Gamma]", "5"},
          "Superscript"]}], 
        RowBox[{
         SubscriptBox["\<\"s\"\>", "1"], ",", 
         SubscriptBox["\<\"s\"\>", "2"]}]]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.911277358734739*^9, {3.9578500224545593`*^9, 3.957850036425763*^9}, 
   3.957850096405505*^9, 3.957850137367487*^9, 3.957850868627516*^9, 
   3.957850912331108*^9, 3.957851316775236*^9, 3.9578625212805767`*^9, 
   3.9578628984729156`*^9, 3.957863278312681*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"bf7b0d2d-5aaa-4910-aa31-50b1d6f6c8ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LVNew", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<eDMsimp_s_spin1\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8721372444575977`*^9, 3.8721372552385683`*^9}, {
   3.872137592022423*^9, 3.872137605834735*^9}, {3.8721378900616055`*^9, 
   3.872137920558133*^9}, {3.8721385100161266`*^9, 3.8721385192702665`*^9}, {
   3.8745577139896994`*^9, 3.8745577243853226`*^9}, {3.8746596314772105`*^9, 
   3.874659637685503*^9}, {3.874664509450314*^9, 3.8746645102900352`*^9}, {
   3.8746649805407157`*^9, 3.8746649833099194`*^9}, {3.8747247798822*^9, 
   3.8747247809812*^9}, {3.874916851099608*^9, 3.8749168569253073`*^9}, {
   3.8749169691405797`*^9, 3.874916972227862*^9}, {3.8749170133912687`*^9, 
   3.874917016961607*^9}, {3.8749172786720047`*^9, 3.874917283190253*^9}, {
   3.8749831528084793`*^9, 3.8749831666834574`*^9}, {3.8749834429957933`*^9, 
   3.8749834474447374`*^9}, {3.8749866602585096`*^9, 3.874986670960102*^9}, {
   3.87498835791786*^9, 3.874988359769135*^9}, {3.8749896247078905`*^9, 
   3.874989634910725*^9}, {3.8749897757965164`*^9, 3.874989780279598*^9}, 
   3.875002223225602*^9, {3.875007631154958*^9, 3.875007640412775*^9}, {
   3.8750087254095945`*^9, 3.8750087261638327`*^9}, {3.8750107247456956`*^9, 
   3.8750107497448263`*^9}, {3.875164207872332*^9, 3.87516420808233*^9}, {
   3.876478991862991*^9, 3.8764789962901096`*^9}, 3.876482850744162*^9, {
   3.8764847013381233`*^9, 3.8764847015289335`*^9}, 3.8765681908240366`*^9, {
   3.8766483316201468`*^9, 3.876648345437724*^9}, {3.8766487470915456`*^9, 
   3.876648747458584*^9}, {3.8769039570932283`*^9, 3.8769039587063055`*^9}, {
   3.876905136183753*^9, 3.876905136435742*^9}, {3.8769205695610104`*^9, 
   3.876920571447193*^9}, {3.876994359202108*^9, 3.876994361122461*^9}, {
   3.8769980647702255`*^9, 3.8769980677022896`*^9}, {3.877066817415344*^9, 
   3.877066817743554*^9}, {3.8770674700239944`*^9, 3.877067472284876*^9}, {
   3.877068222980262*^9, 3.8770682305046015`*^9}, 3.8878764609720683`*^9, {
   3.889181831998684*^9, 3.889181832248888*^9}, {3.8891925268591843`*^9, 
   3.8891925297109504`*^9}, {3.9106861628547525`*^9, 3.910686166433447*^9}, {
   3.9106864541704583`*^9, 3.9106864610018806`*^9}, {3.9106866993322406`*^9, 
   3.910686700222829*^9}, {3.9112202321974363`*^9, 3.9112202352174625`*^9}, {
   3.957849880688299*^9, 3.9578498860449553`*^9}, 3.957862242241626*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"5a085b42-0388-4478-80d7-91d3b3e023b0"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278319675*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"0a03395e-99bf-439b-80db-c25f48a48626"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.9578632785798798`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"8a163d40-c261-4ff8-9745-66c04bf7cec6"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278581954*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f8063b48-bd4b-4e42-a23e-0797663dcf84"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278607575*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a252faf9-aefd-4c6a-b12b-9686a40f4a21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7.2, {0.14400000000000002`, 7.8}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278608775*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4bf83ea2-a538-49b3-98b5-0abbf6f7b247"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278629375*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"62ed2e9f-d5c0-461e-bbfe-1415de779fae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{7.2, {0.14400000000000002`, 7.8}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278649056*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6bd86589-6cdf-47e8-80b2-ad072f6ad690"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.95786327865963*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7c0ceeb2-cb23-4345-8cb9-dc8ba46d2d46"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278662345*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cd85073e-b657-4305-830f-a5f9cd48c96f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7.2, {0.14400000000000002`, 7.8}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278662876*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"99669281-e105-4d60-89c2-22592a8544a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "0.013604`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 0.013604, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.9578632786835213`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"b92a2ea2-7b7d-48a0-ae98-09a8c56e2452"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.00054`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.00054, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.9578632786842546`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"7703c660-a650-4895-8391-f27f54f1810f"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.9578632786846333`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"330c29bb-7af2-417a-a2f2-b76b0a8511ea"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278684948*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"16285d92-6f6d-47b5-8a78-3a0f2aabf4ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", "\[InvisibleSpace]",
    "3", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 3, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863278685272*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"3e6a593e-3133-4afc-9f33-74e723235bbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{7.2, {0.14400000000000002`, 7.8}}], 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 3, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863279274108*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"da6def06-0367-4a58-b83d-2cb5e3814413"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.957863279275653*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"df48414a-fd78-46fc-b93e-f06ca1f5b3e6"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.911277358816326*^9, 3.957862521284272*^9, 
  3.957862898493029*^9, 3.9578632792965*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"e5a235dd-8f2d-49f3-9179-6fe2758b931d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1470, 891},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.2 for Mac OS X ARM (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6522a454-637b-4e4a-b93a-0b2f51cde9c5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 392, 10, 49, "Input",ExpressionUUID->"3e77898c-71b5-4706-b397-586470c893e6"],
Cell[CellGroupData[{
Cell[975, 34, 268, 5, 49, "Input",ExpressionUUID->"6d9385a4-1a91-4810-95eb-9d05eb36abef"],
Cell[CellGroupData[{
Cell[1268, 43, 341, 6, 23, "Print",ExpressionUUID->"2c1a3de7-b084-4473-b1be-d9e2907a16de"],
Cell[1612, 51, 620, 12, 23, "Print",ExpressionUUID->"a7b4458b-6e18-45f0-ba5c-9c3d1ca87457"],
Cell[2235, 65, 393, 7, 23, "Print",ExpressionUUID->"2c8530b3-e1e2-434d-bb9e-fb0f48b563eb"],
Cell[2631, 74, 327, 6, 23, "Print",ExpressionUUID->"efba7342-9ab4-4879-9cc4-a7872bca9e91"],
Cell[2961, 82, 338, 6, 23, "Print",ExpressionUUID->"7d30eecf-d673-4d43-b06e-1a447b812f98"],
Cell[3302, 90, 390, 7, 23, "Print",ExpressionUUID->"9cf61268-17ea-49a8-8317-0394250ea815"],
Cell[3695, 99, 390, 7, 23, "Print",ExpressionUUID->"979324c4-1ebc-43e1-bfc1-961cecd4c638"],
Cell[4088, 108, 327, 6, 23, "Print",ExpressionUUID->"c814d2f4-825b-43d2-b070-7a65c685e03f"],
Cell[4418, 116, 359, 6, 23, "Print",ExpressionUUID->"f96e4ddd-fd43-4e45-8c45-5fa49b6fc1f7"],
Cell[4780, 124, 327, 6, 23, "Print",ExpressionUUID->"f885c4f0-d57e-402d-b144-e9e32f5e2a9c"],
Cell[5110, 132, 394, 7, 23, "Print",ExpressionUUID->"849ed595-5e4a-4aab-acb5-e25160b8180e"]
}, Open  ]],
Cell[5519, 142, 700, 15, 26, "Message",ExpressionUUID->"568162b7-f996-4a90-9bb8-eb84743f604f"],
Cell[6222, 159, 701, 15, 26, "Message",ExpressionUUID->"5c31c7d7-2bcb-445b-a5aa-cfa55509322a"],
Cell[6926, 176, 700, 15, 26, "Message",ExpressionUUID->"c0add526-4701-4f79-ae96-269713dd7f8d"],
Cell[7629, 193, 681, 14, 26, "Message",ExpressionUUID->"27ad3765-137a-44e5-84e3-28fa2afc366e"],
Cell[8313, 209, 501, 12, 20, "Message",ExpressionUUID->"b56b70ea-5207-43d2-88f9-e7430a9fc916"],
Cell[8817, 223, 499, 12, 20, "Message",ExpressionUUID->"83af00ec-16e8-489c-84c4-0907922dde44"],
Cell[9319, 237, 499, 12, 20, "Message",ExpressionUUID->"8a806ece-90dc-4fa6-b940-be8ae6d3bdad"],
Cell[9821, 251, 499, 12, 20, "Message",ExpressionUUID->"305af8f6-d959-498c-b6da-097841fb373e"],
Cell[10323, 265, 499, 12, 20, "Message",ExpressionUUID->"0ec84c5e-2fde-417a-948d-2630ac9bff58"],
Cell[10825, 279, 502, 12, 22, "Message",ExpressionUUID->"a73e3a92-c25b-4ba2-8527-b5058d47f9f1"],
Cell[11330, 293, 500, 12, 22, "Message",ExpressionUUID->"42aea943-0d13-4d3a-9f0c-6fab2e9046f3"],
Cell[11833, 307, 501, 12, 20, "Message",ExpressionUUID->"af3a05dd-9b74-4396-b610-0a8ecd126dac"],
Cell[12337, 321, 501, 12, 20, "Message",ExpressionUUID->"f26b8489-3f76-4880-a0b6-f11e0de5ac2a"],
Cell[12841, 335, 501, 12, 20, "Message",ExpressionUUID->"27627377-aa6d-413a-b0bf-36a1aa1c655c"],
Cell[13345, 349, 502, 12, 20, "Message",ExpressionUUID->"14a7c0c8-8c9d-48b2-a9f9-d32c08afb24f"],
Cell[13850, 363, 501, 12, 20, "Message",ExpressionUUID->"fcb236c5-212a-49c3-b923-3252c2d90606"],
Cell[14354, 377, 500, 12, 20, "Message",ExpressionUUID->"485d3fe4-f015-4c90-ac4b-44f98f4fa1d6"],
Cell[14857, 391, 503, 12, 20, "Message",ExpressionUUID->"e3e53fe5-54d6-42d8-84b0-51b0c3773890"],
Cell[15363, 405, 501, 12, 20, "Message",ExpressionUUID->"e08ba1d5-d461-4dee-9d09-43f26d274904"],
Cell[15867, 419, 499, 12, 20, "Message",ExpressionUUID->"488287e0-3436-4cf3-a627-85883f71f29a"],
Cell[16369, 433, 500, 12, 20, "Message",ExpressionUUID->"c1a7ad55-2860-40c6-9ab6-0b37e3ee1dad"],
Cell[16872, 447, 499, 12, 20, "Message",ExpressionUUID->"d52cc4d2-94bc-4b0f-89eb-7d3778d924d1"],
Cell[17374, 461, 501, 12, 20, "Message",ExpressionUUID->"b0bb7b30-a1da-4d1e-9de0-313881f54daa"],
Cell[17878, 475, 500, 12, 20, "Message",ExpressionUUID->"d44ffdf1-6d6a-401e-9c6d-0cc1f68f32af"],
Cell[18381, 489, 500, 12, 20, "Message",ExpressionUUID->"4f741ecd-9059-4634-8114-f7f370f1bc01"],
Cell[18884, 503, 500, 12, 22, "Message",ExpressionUUID->"0177d6e6-ca9a-47e9-bf41-62f6afaabecb"],
Cell[19387, 517, 500, 12, 22, "Message",ExpressionUUID->"e870b7b0-85eb-4a6f-a01f-2bbaf5a6b247"],
Cell[19890, 531, 479, 11, 20, "Message",ExpressionUUID->"37ce6831-df99-4158-9223-2d889f0c677c"],
Cell[20372, 544, 479, 11, 20, "Message",ExpressionUUID->"560b9bf3-7674-40b2-bc5e-bf108a62a91e"],
Cell[20854, 557, 479, 11, 20, "Message",ExpressionUUID->"f65bf00a-9c6f-4772-bdff-44d1d8d655db"],
Cell[21336, 570, 500, 12, 20, "Message",ExpressionUUID->"620c46b8-a391-4813-ac7d-afc6e3635b51"],
Cell[21839, 584, 479, 11, 20, "Message",ExpressionUUID->"1128d463-73c7-487e-a529-68a9cbec593c"],
Cell[22321, 597, 478, 11, 20, "Message",ExpressionUUID->"6d6ebb8f-468c-457f-8f65-6b0496bb7aa6"],
Cell[22802, 610, 479, 11, 20, "Message",ExpressionUUID->"8bf35404-e4a2-43ba-9ef0-984329d0e72f"],
Cell[23284, 623, 481, 11, 20, "Message",ExpressionUUID->"40eefeb2-162c-43b8-bd55-004c998e4ab2"],
Cell[23768, 636, 479, 11, 20, "Message",ExpressionUUID->"7e31dd13-1551-4c32-a6f8-806bfd8a3328"]
}, Open  ]],
Cell[24262, 650, 544, 11, 49, "Input",ExpressionUUID->"2aff33bf-c914-4c58-a535-9a6bebf7fb4e"],
Cell[CellGroupData[{
Cell[24831, 665, 468, 9, 49, "Input",ExpressionUUID->"e6fa683c-955c-4919-8308-10befe9bb548"],
Cell[CellGroupData[{
Cell[25324, 678, 344, 6, 23, "Print",ExpressionUUID->"0eb1681d-167e-4863-af33-6e8d5ad7a7e2"],
Cell[25671, 686, 362, 6, 23, "Print",ExpressionUUID->"ca2759f9-f80e-448e-9774-4d3fe579adfe"],
Cell[26036, 694, 342, 6, 23, "Print",ExpressionUUID->"34a227d0-5ff1-40b5-a532-8a1f2d8a87c9"],
Cell[26381, 702, 470, 10, 23, "Print",ExpressionUUID->"d4b279ea-6fcf-49d1-988b-5a91c9660cbf"],
Cell[26854, 714, 333, 6, 23, "Print",ExpressionUUID->"da1a86f6-e62f-46d1-9799-7b3176ab129f"],
Cell[27190, 722, 365, 6, 23, "Print",ExpressionUUID->"0a009dd8-8872-45ab-85e2-62c2b4eabc3b"],
Cell[27558, 730, 359, 6, 23, "Print",ExpressionUUID->"0da577e8-3dd2-4107-9e13-a9df0b8bf4a6"],
Cell[27920, 738, 370, 7, 23, "Print",ExpressionUUID->"8cf36fc3-50ef-4c57-9f58-fad45960f7ba"],
Cell[28293, 747, 322, 6, 23, "Print",ExpressionUUID->"45b6924a-d0fc-4306-83ce-2dcb73f69574"],
Cell[28618, 755, 352, 6, 23, "Print",ExpressionUUID->"2e39683c-b7b5-4da2-a9d6-794cae9a079c"],
Cell[28973, 763, 355, 6, 23, "Print",ExpressionUUID->"633f427e-01d7-4d6b-9eaf-b43f7a98bf4e"],
Cell[29331, 771, 353, 6, 23, "Print",ExpressionUUID->"c642c435-72e7-461d-a346-f7b25ada7d3d"],
Cell[29687, 779, 534, 11, 41, "Print",ExpressionUUID->"cfb3356e-9ff8-41d5-a6de-7cb3191d8f67"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30270, 796, 572, 8, 29, "Input",ExpressionUUID->"3983cf50-bf60-485f-8860-de91e9bf0df4"],
Cell[CellGroupData[{
Cell[30867, 808, 401, 7, 23, "Print",ExpressionUUID->"95a1bce6-5613-4482-937c-aaa38e440c48"],
Cell[31271, 817, 397, 7, 23, "Print",ExpressionUUID->"94d28c47-b81c-41a8-b7fa-71f38a5566a4"],
Cell[31671, 826, 590, 14, 23, "Print",ExpressionUUID->"905befb2-33e5-4b54-a1c5-3d46f6918d09"],
Cell[32264, 842, 345, 6, 23, "Print",ExpressionUUID->"78c11aa4-040f-4b40-8bf3-26d20f458fe6"],
Cell[32612, 850, 338, 6, 23, "Print",ExpressionUUID->"af5396fb-4a57-4b83-bd7b-72552c762e5d"],
Cell[32953, 858, 458, 10, 23, "Print",ExpressionUUID->"784fac0f-e638-4789-bda9-4ba586129d20"],
Cell[33414, 870, 346, 6, 23, "Print",ExpressionUUID->"1f6db9e5-a7f5-4739-a0c4-e66024bd30bc"]
}, Open  ]],
Cell[33775, 879, 407, 7, 33, "Output",ExpressionUUID->"6a7deaee-42b8-4f67-a2e1-54197069e0e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34219, 891, 1504, 20, 29, "Input",ExpressionUUID->"3b58d9f5-310b-4525-aa2a-0add26b681e8"],
Cell[CellGroupData[{
Cell[35748, 915, 596, 14, 23, "Print",ExpressionUUID->"ee7b247b-64e6-4c42-9702-dfb1edc43abc"],
Cell[36347, 931, 353, 6, 23, "Print",ExpressionUUID->"45885e0e-a74c-4013-89d4-bca34f49160c"],
Cell[36703, 939, 384, 7, 23, "Print",ExpressionUUID->"34cc3736-e66c-492b-a91d-588ef2baa90f"],
Cell[37090, 948, 886, 19, 23, "Print",ExpressionUUID->"cd10400d-7feb-4583-8fd3-4b525d496470"],
Cell[37979, 969, 464, 10, 23, "Print",ExpressionUUID->"9d15fcfa-bbbf-4bbe-a9e9-aa033dde7a27"]
}, Open  ]],
Cell[38458, 982, 3371, 99, 45, "Output",ExpressionUUID->"bf7b0d2d-5aaa-4910-aa31-50b1d6f6c8ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41866, 1086, 2493, 34, 29, "Input",ExpressionUUID->"5a085b42-0388-4478-80d7-91d3b3e023b0"],
Cell[CellGroupData[{
Cell[44384, 1124, 298, 6, 23, "Print",ExpressionUUID->"0a03395e-99bf-439b-80db-c25f48a48626"],
Cell[44685, 1132, 523, 13, 23, "Print",ExpressionUUID->"8a163d40-c261-4ff8-9745-66c04bf7cec6"],
Cell[45211, 1147, 276, 5, 23, "Print",ExpressionUUID->"f8063b48-bd4b-4e42-a23e-0797663dcf84"],
Cell[45490, 1154, 309, 6, 23, "Print",ExpressionUUID->"a252faf9-aefd-4c6a-b12b-9686a40f4a21"],
Cell[45802, 1162, 809, 18, 23, "Print",ExpressionUUID->"4bf83ea2-a538-49b3-98b5-0abbf6f7b247"],
Cell[46614, 1182, 389, 9, 23, "Print",ExpressionUUID->"62ed2e9f-d5c0-461e-bbfe-1415de779fae"],
Cell[47006, 1193, 637, 13, 23, "Print",ExpressionUUID->"6bd86589-6cdf-47e8-80b2-ad072f6ad690"],
Cell[47646, 1208, 289, 5, 23, "Print",ExpressionUUID->"7c0ceeb2-cb23-4345-8cb9-dc8ba46d2d46"],
Cell[47938, 1215, 557, 14, 23, "Print",ExpressionUUID->"cd85073e-b657-4305-830f-a5f9cd48c96f"],
Cell[48498, 1231, 544, 13, 23, "Print",ExpressionUUID->"99669281-e105-4d60-89c2-22592a8544a8"],
Cell[49045, 1246, 491, 10, 23, "Print",ExpressionUUID->"b92a2ea2-7b7d-48a0-ae98-09a8c56e2452"],
Cell[49539, 1258, 475, 10, 23, "Print",ExpressionUUID->"7703c660-a650-4895-8391-f27f54f1810f"],
Cell[50017, 1270, 275, 5, 23, "Print",ExpressionUUID->"330c29bb-7af2-417a-a2f2-b76b0a8511ea"],
Cell[50295, 1277, 297, 6, 23, "Print",ExpressionUUID->"16285d92-6f6d-47b5-8a78-3a0f2aabf4ea"],
Cell[50595, 1285, 488, 10, 23, "Print",ExpressionUUID->"3e6a593e-3133-4afc-9f33-74e723235bbf"],
Cell[51086, 1297, 666, 14, 23, "Print",ExpressionUUID->"da6def06-0367-4a58-b83d-2cb5e3814413"],
Cell[51755, 1313, 269, 5, 23, "Print",ExpressionUUID->"df48414a-fd78-46fc-b93e-f06ca1f5b3e6"],
Cell[52027, 1320, 252, 5, 23, "Print",ExpressionUUID->"e5a235dd-8f2d-49f3-9179-6fe2758b931d"]
}, Open  ]]
}, Open  ]]
}
]
*)

