(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     56216,       1375]
NotebookOptionsPosition[     46210,       1243]
NotebookOutlinePosition[     46605,       1259]
CellTagsIndexPosition[     46562,       1256]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"$FeynRulesPath", "=", 
    RowBox[{
    "SetDirectory", 
     "[", "\"\</Users/gianmarcolucchetti/PhD/MadDM/models/feynrules-current\>\
\"", "]"}]}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.872077100083353*^9, 3.87207710008435*^9}, 
   3.957516134798175*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"3e77898c-71b5-4706-b397-586470c893e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "FeynRules`"}], "\n"}]], "Input",
 CellChangeTimes->{{3.8720771131728888`*^9, 3.87207711317389*^9}, 
   3.872135464524799*^9, 3.8721355151883593`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"6d9385a4-1a91-4810-95eb-9d05eb36abef"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974192356*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"7ecd53c1-a2bd-4229-892a-b6ca4f61f338"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.49\"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"29 September 2021\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.49", " (" "29 September 2021", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.9576989741928368`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"f853d30a-1a00-4a42-a89e-de7ad3f7490c"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974193329*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"8a2401e9-674e-4b39-9ae5-0f466e8b9a52"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974193625*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"8b9f8939-e68c-48cb-996d-31be04489ccd"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.9576989741938868`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"fc5b29f1-8cad-426f-9e1b-5f769de8d378"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974194148*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"9a807eed-f664-4860-a621-b1aec07557a3"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974194419*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"7a9d49c4-5b3d-4476-bf3c-ca0eeba30d2b"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974194685*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"109fced0-0416-4cc3-a81f-6943a68d4156"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974194933*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ff292bbe-e6a4-4779-895d-0a9308c022cf"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974195204*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"9c9e01b8-603c-4efc-a06f-bfe6b3ceeacb"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.9575166339885406`*^9, 3.9576988439074802`*^9, 
  3.957698974195466*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"d5baa2f7-1f6d-45ad-b5f9-c2369ea65b65"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 2, 1, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.957516634136368*^9, 3.957698844049429*^9, 
  3.957698974340109*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"39d9e4c9-f454-49e0-b3b2-f48cdeb08430"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 2, 2, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.957516634136368*^9, 3.957698844049429*^9, 
  3.957698974343919*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ad824359-e176-484b-8da1-e035e28e6e09"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", 2, 2, 3, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.957516634136368*^9, 3.957698844049429*^9, 
  3.9576989743453903`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"353c476a-2159-4627-b939-85f70bdf4b30"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 2, 4, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.957516634136368*^9, 3.957698844049429*^9, 
  3.957698974346755*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"6c103403-2523-41f0-a205-960b0be5f739"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 5, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977011878*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"070bb756-3a9e-45ef-b8ad-d4b66dd01a3c"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 6, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989770308104`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"972a1a74-ab8d-4887-b1b9-04e29cad5246"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 7, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977048958*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"2af81bf9-0db8-4e6c-9a15-c5f61021c0b7"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 8, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977057377*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"9fef6b9e-e280-4e1e-8eba-836a89c0ccde"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 9, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977071005*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"a663872c-1320-4c78-ae80-36598e11d993"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 10, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977074408*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"fd651e13-a95c-43aa-ac53-e00663fa80d3"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 11, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977079481*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"3f73e077-65f2-485a-87cc-56c6296a9651"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"S\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 12, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977084085*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"411c51cd-54d2-4504-ab20-f1678bdca706"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 13, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977101659*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"82400d65-064c-4e51-8fb5-ce0c3187ebae"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 14, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771072073`*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"7700ab9b-58c2-42a0-9e4e-faf5cce66d06"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 15, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977119317*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"cbaad969-6136-4fe8-ac58-28dd2a78fa96"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 16, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771226788`*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"dbfc76a4-8274-4a09-87a2-797df4101645"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 17, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771253033`*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"75fedefd-f70d-4b0b-a937-7435e2b1b5c9"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 18, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771298037`*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"d5411e5f-d8b2-41c2-a4dd-c817933d446d"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 19, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977134285*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"16ec52df-ac19-4837-b7aa-630c62b85ab6"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"PS\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 20, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771391497`*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"29fd5319-7875-4f04-ba3f-aa21054697a7"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 21, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771570787`*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"33de93fe-5234-4b0c-8bb0-3efcdab6fc06"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 22, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.95769897717097*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"f9a2b700-baa7-4999-8254-863f7a13f3af"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 23, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771736307`*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"c79d0456-55d1-4365-ad93-5631d49532a1"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 24, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977176754*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"89af71b8-4245-4fb5-8ff1-03fb9ea5343d"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 25, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977180914*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"1d5dac57-1ad2-42c6-afb7-8d57df487192"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 26, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977183864*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"10ecf43a-cbcb-4b60-8617-8db57707c02f"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 27, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989771989717`*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"2c52e448-f031-4738-a3f9-fb264efb4bca"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"MatrixSymbol\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"MatrixSymbol\\\", \\\"[\\\", RowBox[{\\\"id_\\\", \
\\\",\\\", \\\"L\\\"}], \\\"]\\\"}]\\) is Protected.\"", None, 2, 28, 
   29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977214992*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"1b0f0a85-9188-4df4-add7-4b5f51802c6f"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 29, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977231555*^9},
 CellLabel->
  "(kernel 1)",ExpressionUUID->"dee7e1a9-e4cc-4595-bbdd-38a1767f6fb0"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 30, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977234221*^9},
 CellLabel->
  "(kernel 2)",ExpressionUUID->"72038db8-4fe6-411a-ae84-ef77227756a2"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 31, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977247889*^9},
 CellLabel->
  "(kernel 3)",ExpressionUUID->"32c5fa35-d6f1-42fd-8299-d702c96166e3"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 32, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977250526*^9},
 CellLabel->
  "(kernel 4)",ExpressionUUID->"ffe503b6-4851-46ea-8f0e-b57fe7c94732"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 33, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977265012*^9},
 CellLabel->
  "(kernel 5)",ExpressionUUID->"5c55ebf5-3fcc-4265-811b-6a52d2a4bc91"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 34, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.957698977267503*^9},
 CellLabel->
  "(kernel 6)",ExpressionUUID->"1e796723-6569-4f24-8364-a13e04b4620e"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 35, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.95769897728094*^9},
 CellLabel->
  "(kernel 7)",ExpressionUUID->"d8c6d788-914a-4ff9-ae0d-807e6222537e"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", None, 2, 36, 29335472256085388606, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message", "MSG",
 ShowCellLabel->True,
 CellChangeTimes->{3.9576989772834873`*^9},
 CellLabel->
  "(kernel 8)",ExpressionUUID->"f2719915-e08b-4598-af5e-e46a6ff09311"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", 
    "[", "\"\</Users/gianmarcolucchetti/PhD/MadDM/models/eDMsimp_s_spin0\>\"",
     "]"}], ";"}], "\n"}]], "Input",
 CellChangeTimes->{{3.87207712133959*^9, 3.872077121341593*^9}, {
   3.8721390541533685`*^9, 3.872139059524665*^9}, {3.910686612090931*^9, 
   3.91068661404452*^9}, 3.911220194467496*^9, {3.9575161716660347`*^9, 
   3.957516227114341*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"2aff33bf-c914-4c58-a535-9a6bebf7fb4e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<SM.fr\>\"", ",", "\"\<edm_s_spin0.fr\>\""}], "]"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.872077136459931*^9, 3.8720771364609213`*^9}, {
   3.8720776190764093`*^9, 3.8720776198076553`*^9}, 3.872135517957418*^9, {
   3.9112201871147866`*^9, 3.9112201894423585`*^9}, 3.9575162330241613`*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"e6fa683c-955c-4919-8308-10befe9bb548"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978051868*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5c1baa7b-749c-4544-981d-254be83cd284"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.9576989780548058`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a7913bb6-9b46-473a-84c1-e1c899ccfeac"],

Cell[BoxData["\<\"Gian Marco Lucchetti\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978056508*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"b8a94f84-b580-4290-b903-940dbfceceef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978056799*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"4a9b6dac-7f5c-4dce-b175-911f4900fae9"],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978057068*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"127f2f58-365f-4403-9993-3df489f1ee4b"],

Cell[BoxData["\<\"Haider Alhazmi et al., arXiv:2006.16252v2\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.9576989780573187`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5d34b01f-181d-46ae-92e8-5d0fa232d1ce"],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978057576*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e2daf5cf-aea5-45b9-b1c9-31c4ed93d6e8"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978057836*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"09eddbca-756a-4a13-9314-d2d3d1dcd686"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978058092*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"cf791800-5d9b-4c9f-bd68-a522b6302f33"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.95769897805833*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"34f2e4c4-853b-4637-9a3b-03ec098e2710"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978113731*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"e0baa54d-4c9b-4d92-8341-4f0fcb2986b3"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.957698978115533*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"29c7535b-2803-4537-9f2e-812f78627cd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"eDMsimp_s_spin0\"\>",
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "eDMsimp_s_spin0", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166382890778`*^9, 3.957698852527519*^9, 
  3.95769897814039*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"8164a508-e34f-4b7f-aa15-1cf004aafd6b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", "LSNew", "]"}]], "Input",
 CellChangeTimes->{{3.8770670459058666`*^9, 3.8770670476847286`*^9}, {
  3.877068200855322*^9, 3.8770682047763433`*^9}, {3.910686142636731*^9, 
  3.910686146810019*^9}, {3.9106862133632708`*^9, 3.9106862187720175`*^9}, {
  3.910686401207466*^9, 3.910686411290904*^9}, {3.9106866933488398`*^9, 
  3.9106866950576477`*^9}, {3.9112202087681146`*^9, 3.9112202165547323`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"3983cf50-bf60-485f-8860-de91e9bf0df4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.957698978156129*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"1b048953-c3a1-4ef6-ada2-a95d69248ba1"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.957698978156535*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"8a397ca9-1211-479b-82c4-6214edf734f2"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.9576989781819983`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4c6586f6-776b-4fe7-b0b5-7962003bfa8c"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.957698978182413*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"4f77dac6-be3c-4253-8071-337392b20a97"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.9576989781826878`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"b72db86a-4ad6-432e-8116-6d742fad1d6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.957698978182981*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"7cd5b8bf-fa8b-4540-814b-19a2e0fa25d2"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.957516638392866*^9, 3.957698854070964*^9, 
  3.9576989781832438`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"cd24665a-7667-4833-b0aa-ef9e5e5017f5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.9575166384320498`*^9, 3.9576988541021843`*^9, 
  3.957698978196342*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"3c95fc71-f282-46fb-ba8b-3fe505c02775"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynmanRules", "[", "LSNew", "]"}]], "Input",
 CellChangeTimes->{{3.872077145528018*^9, 3.872077145530012*^9}, {
   3.87207757884532*^9, 3.8720775825562205`*^9}, 3.872077843857835*^9, 
   3.872077891379122*^9, {3.8720780071521072`*^9, 3.872078017191123*^9}, {
   3.872132071016568*^9, 3.8721320822718163`*^9}, {3.87213213811709*^9, 
   3.8721321553273335`*^9}, {3.872132476741374*^9, 3.8721324772007523`*^9}, {
   3.872132739663206*^9, 3.8721327405161123`*^9}, {3.872132810266752*^9, 
   3.872132810613639*^9}, {3.872132967243039*^9, 3.872132974622429*^9}, {
   3.8721330059010286`*^9, 3.8721330061654263`*^9}, {3.872135798254359*^9, 
   3.87213579850436*^9}, {3.872136269162527*^9, 3.8721362708497796`*^9}, {
   3.8745576842117624`*^9, 3.8745576890348773`*^9}, {3.8746596190482454`*^9, 
   3.8746596217558985`*^9}, {3.874916809712614*^9, 3.8749168359643936`*^9}, {
   3.8749172458329077`*^9, 3.8749172474381657`*^9}, 3.8765681993172007`*^9, {
   3.876568307070857*^9, 3.8765683197423906`*^9}, {3.8765700363536687`*^9, 
   3.8765700418412275`*^9}, {3.8765715469937387`*^9, 3.876571564240671*^9}, {
   3.876571962494031*^9, 3.876571963744278*^9}, {3.8769039833998356`*^9, 
   3.8769039866137557`*^9}, {3.8769205602164097`*^9, 3.876920561107032*^9}, {
   3.9106863807723503`*^9, 3.9106863871706133`*^9}, {3.9112202200231447`*^9, 
   3.911220221497362*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"3b58d9f5-310b-4525-aa2a-0add26b681e8"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.95751663843574*^9, 3.957698978204864*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"695d3809-3f40-4ac5-9654-5d3a3ad88547"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.95751663843574*^9, 3.957698978205213*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"db52213e-a76b-4fb6-808f-17a0218f669b"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.95751663843574*^9, 3.957698978223296*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"2975b9a8-584b-46d9-a5cb-685f9127bbad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7.2, {0., 7.656000000000001}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.95751663843574*^9, 3.9576989782237387`*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"f9329390-badf-494b-9287-1a13de83c5ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.95751663843574*^9, 3.957698978224308*^9},
 CellLabel->
  "During evaluation of \
In[6]:=",ExpressionUUID->"f0366643-edfd-4036-8cdd-25da6d0c9e5c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Xc", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["Xc", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["g", "SXc"], " ", "MXc"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Xr", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Xr", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["g", "SXr"], " ", "MXr"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["e", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["g", "Se"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["Xd", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Xd", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Y0", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SubscriptBox["g", "SXd"], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.957516638459364*^9, 3.957698978224715*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"ede3c523-bfc4-4197-bad8-28ab1a1d1eb1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{"LSNew", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<eDMsimp_s_spin0\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8721372444575977`*^9, 3.8721372552385683`*^9}, {
   3.872137592022423*^9, 3.872137605834735*^9}, {3.8721378900616055`*^9, 
   3.872137920558133*^9}, {3.8721385100161266`*^9, 3.8721385192702665`*^9}, {
   3.8745577139896994`*^9, 3.8745577243853226`*^9}, {3.8746596314772105`*^9, 
   3.874659637685503*^9}, {3.874664509450314*^9, 3.8746645102900352`*^9}, {
   3.8746649805407157`*^9, 3.8746649833099194`*^9}, {3.8747247798822*^9, 
   3.8747247809812*^9}, {3.874916851099608*^9, 3.8749168569253073`*^9}, {
   3.8749169691405797`*^9, 3.874916972227862*^9}, {3.8749170133912687`*^9, 
   3.874917016961607*^9}, {3.8749172786720047`*^9, 3.874917283190253*^9}, {
   3.8749831528084793`*^9, 3.8749831666834574`*^9}, {3.8749834429957933`*^9, 
   3.8749834474447374`*^9}, {3.8749866602585096`*^9, 3.874986670960102*^9}, {
   3.87498835791786*^9, 3.874988359769135*^9}, {3.8749896247078905`*^9, 
   3.874989634910725*^9}, {3.8749897757965164`*^9, 3.874989780279598*^9}, 
   3.875002223225602*^9, {3.875007631154958*^9, 3.875007640412775*^9}, {
   3.8750087254095945`*^9, 3.8750087261638327`*^9}, {3.8750107247456956`*^9, 
   3.8750107497448263`*^9}, {3.875164207872332*^9, 3.87516420808233*^9}, {
   3.876478991862991*^9, 3.8764789962901096`*^9}, 3.876482850744162*^9, {
   3.8764847013381233`*^9, 3.8764847015289335`*^9}, 3.8765681908240366`*^9, {
   3.8766483316201468`*^9, 3.876648345437724*^9}, {3.8766487470915456`*^9, 
   3.876648747458584*^9}, {3.8769039570932283`*^9, 3.8769039587063055`*^9}, {
   3.876905136183753*^9, 3.876905136435742*^9}, {3.8769205695610104`*^9, 
   3.876920571447193*^9}, {3.876994359202108*^9, 3.876994361122461*^9}, {
   3.8769980647702255`*^9, 3.8769980677022896`*^9}, {3.877066817415344*^9, 
   3.877066817743554*^9}, {3.8770674700239944`*^9, 3.877067472284876*^9}, {
   3.877068222980262*^9, 3.8770682305046015`*^9}, 3.8878764609720683`*^9, {
   3.889181831998684*^9, 3.889181832248888*^9}, {3.8891925268591843`*^9, 
   3.8891925297109504`*^9}, {3.9106861628547525`*^9, 3.910686166433447*^9}, {
   3.9106864541704583`*^9, 3.9106864610018806`*^9}, {3.9106866993322406`*^9, 
   3.910686700222829*^9}, {3.9112202321974363`*^9, 3.9112202352174625`*^9}, {
   3.957695559016638*^9, 3.95769556473454*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"5a085b42-0388-4478-80d7-91d3b3e023b0"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978230949*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a1ec18ce-5f65-4d9c-8434-70e5c6f88243"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978465212*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"6d7a1b9a-4a8d-457a-9561-57be985af25a"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978467222*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"ff8367e3-e8f1-43da-a2cb-1dddc0e4a357"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978489719*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"9b3b4e39-f502-4d3d-b896-22da3f59b5e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{7.2, {0., 7.656000000000001}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  4, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978490252*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"899d037a-29da-4c45-8dfd-2173726eb21c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[4, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978490758*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"cd3930aa-8922-4c69-8f55-3a5f4d71db5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{7.2, {0., 7.656000000000001}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.9576989785127563`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"dda49f57-5f09-41e5-b015-5e891de7823e"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978516239*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f25a55b5-b3e0-4595-910e-5fad723ab43f"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.9576989785182877`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5d50d798-559f-4613-8a0b-598c511130fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[FeynRules`FR$DecayCounter, StandardForm],
    ImageSizeCache->{7.2, {0., 7.656000000000001}}], 
   "\[InvisibleSpace]", "\<\" / \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm[
   Dynamic[FeynRules`FR$DecayCounter], " / ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.9576989785187607`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"4fb6a253-6cba-4d07-b7b9-fca57cd85a94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "0.004765`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 0.004765, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978523121*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a992012d-ea90-4b03-a6a8-dda2d0cd8576"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.000549`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.000549, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.9576989785235243`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"2e981d5d-6e8f-4a19-82ea-ce12d4317cc4"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978523815*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"c329f7bc-4d79-48be-8993-e4f97654d141"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.9576989785240927`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"5e2f3191-f7fb-4a7c-abff-e7cdd1fd17ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", "\[InvisibleSpace]",
    "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698978524379*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"a91f64f1-384a-482e-ad13-dbd7599b069d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{7.2, {0., 7.656000000000001}}], 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 4, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.9576989790538893`*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"f14dd732-41f2-495b-b5b9-4b8f7ea8f1eb"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698979054822*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"582d0f54-e343-4fe6-8cad-f70718c5e099"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.9575166384644947`*^9, 3.9576988813044443`*^9, 
  3.957698979069702*^9},
 CellLabel->
  "During evaluation of \
In[7]:=",ExpressionUUID->"bc92615a-c7d1-4f11-81be-607b5a1d3c14"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1470, 891},
WindowMargins->{{0, Automatic}, {Automatic, 124}},
FrontEndVersion->"14.2 for Mac OS X ARM (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6522a454-637b-4e4a-b93a-0b2f51cde9c5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 390, 10, 49, "Input",ExpressionUUID->"3e77898c-71b5-4706-b397-586470c893e6"],
Cell[CellGroupData[{
Cell[973, 34, 268, 5, 49, "Input",ExpressionUUID->"6d9385a4-1a91-4810-95eb-9d05eb36abef"],
Cell[CellGroupData[{
Cell[1266, 43, 246, 5, 23, "Print",ExpressionUUID->"7ecd53c1-a2bd-4229-892a-b6ca4f61f338"],
Cell[1515, 50, 527, 11, 23, "Print",ExpressionUUID->"f853d30a-1a00-4a42-a89e-de7ad3f7490c"],
Cell[2045, 63, 298, 6, 23, "Print",ExpressionUUID->"8a2401e9-674e-4b39-9ae5-0f466e8b9a52"],
Cell[2346, 71, 232, 5, 23, "Print",ExpressionUUID->"8b9f8939-e68c-48cb-996d-31be04489ccd"],
Cell[2581, 78, 245, 5, 23, "Print",ExpressionUUID->"fc5b29f1-8cad-426f-9e1b-5f769de8d378"],
Cell[2829, 85, 295, 6, 23, "Print",ExpressionUUID->"9a807eed-f664-4860-a621-b1aec07557a3"],
Cell[3127, 93, 295, 6, 23, "Print",ExpressionUUID->"7a9d49c4-5b3d-4476-bf3c-ca0eeba30d2b"],
Cell[3425, 101, 232, 5, 23, "Print",ExpressionUUID->"109fced0-0416-4cc3-a81f-6943a68d4156"],
Cell[3660, 108, 262, 5, 23, "Print",ExpressionUUID->"ff292bbe-e6a4-4779-895d-0a9308c022cf"],
Cell[3925, 115, 232, 5, 23, "Print",ExpressionUUID->"9c9e01b8-603c-4efc-a06f-bfe6b3ceeacb"],
Cell[4160, 122, 299, 6, 23, "Print",ExpressionUUID->"d5baa2f7-1f6d-45ad-b5f9-c2369ea65b65"]
}, Open  ]],
Cell[4474, 131, 534, 13, 26, "Message",ExpressionUUID->"39d9e4c9-f454-49e0-b3b2-f48cdeb08430"],
Cell[5011, 146, 535, 13, 26, "Message",ExpressionUUID->"ad824359-e176-484b-8da1-e035e28e6e09"],
Cell[5549, 161, 536, 13, 26, "Message",ExpressionUUID->"353c476a-2159-4627-b939-85f70bdf4b30"],
Cell[6088, 176, 513, 12, 26, "Message",ExpressionUUID->"6c103403-2523-41f0-a205-960b0be5f739"],
Cell[6604, 190, 499, 12, 22, "Message",ExpressionUUID->"070bb756-3a9e-45ef-b8ad-d4b66dd01a3c"],
Cell[7106, 204, 501, 12, 22, "Message",ExpressionUUID->"972a1a74-ab8d-4887-b1b9-04e29cad5246"],
Cell[7610, 218, 499, 12, 22, "Message",ExpressionUUID->"2af81bf9-0db8-4e6c-9a15-c5f61021c0b7"],
Cell[8112, 232, 499, 12, 22, "Message",ExpressionUUID->"9fef6b9e-e280-4e1e-8eba-836a89c0ccde"],
Cell[8614, 246, 499, 12, 22, "Message",ExpressionUUID->"a663872c-1320-4c78-ae80-36598e11d993"],
Cell[9116, 260, 500, 12, 22, "Message",ExpressionUUID->"fd651e13-a95c-43aa-ac53-e00663fa80d3"],
Cell[9619, 274, 500, 12, 22, "Message",ExpressionUUID->"3f73e077-65f2-485a-87cc-56c6296a9651"],
Cell[10122, 288, 500, 12, 22, "Message",ExpressionUUID->"411c51cd-54d2-4504-ab20-f1678bdca706"],
Cell[10625, 302, 501, 12, 22, "Message",ExpressionUUID->"82400d65-064c-4e51-8fb5-ce0c3187ebae"],
Cell[11129, 316, 503, 12, 22, "Message",ExpressionUUID->"7700ab9b-58c2-42a0-9e4e-faf5cce66d06"],
Cell[11635, 330, 501, 12, 22, "Message",ExpressionUUID->"cbaad969-6136-4fe8-ac58-28dd2a78fa96"],
Cell[12139, 344, 503, 12, 22, "Message",ExpressionUUID->"dbfc76a4-8274-4a09-87a2-797df4101645"],
Cell[12645, 358, 503, 12, 22, "Message",ExpressionUUID->"75fedefd-f70d-4b0b-a937-7435e2b1b5c9"],
Cell[13151, 372, 503, 12, 22, "Message",ExpressionUUID->"d5411e5f-d8b2-41c2-a4dd-c817933d446d"],
Cell[13657, 386, 501, 12, 22, "Message",ExpressionUUID->"16ec52df-ac19-4837-b7aa-630c62b85ab6"],
Cell[14161, 400, 503, 12, 22, "Message",ExpressionUUID->"29fd5319-7875-4f04-ba3f-aa21054697a7"],
Cell[14667, 414, 502, 12, 22, "Message",ExpressionUUID->"33de93fe-5234-4b0c-8bb0-3efcdab6fc06"],
Cell[15172, 428, 499, 12, 22, "Message",ExpressionUUID->"f9a2b700-baa7-4999-8254-863f7a13f3af"],
Cell[15674, 442, 502, 12, 22, "Message",ExpressionUUID->"c79d0456-55d1-4365-ad93-5631d49532a1"],
Cell[16179, 456, 500, 12, 22, "Message",ExpressionUUID->"89af71b8-4245-4fb5-8ff1-03fb9ea5343d"],
Cell[16682, 470, 500, 12, 22, "Message",ExpressionUUID->"1d5dac57-1ad2-42c6-afb7-8d57df487192"],
Cell[17185, 484, 500, 12, 22, "Message",ExpressionUUID->"10ecf43a-cbcb-4b60-8617-8db57707c02f"],
Cell[17688, 498, 502, 12, 22, "Message",ExpressionUUID->"2c52e448-f031-4738-a3f9-fb264efb4bca"],
Cell[18193, 512, 500, 12, 22, "Message",ExpressionUUID->"1b0f0a85-9188-4df4-add7-4b5f51802c6f"],
Cell[18696, 526, 479, 11, 22, "Message",ExpressionUUID->"dee7e1a9-e4cc-4595-bbdd-38a1767f6fb0"],
Cell[19178, 539, 479, 11, 22, "Message",ExpressionUUID->"72038db8-4fe6-411a-ae84-ef77227756a2"],
Cell[19660, 552, 479, 11, 22, "Message",ExpressionUUID->"32c5fa35-d6f1-42fd-8299-d702c96166e3"],
Cell[20142, 565, 479, 11, 22, "Message",ExpressionUUID->"ffe503b6-4851-46ea-8f0e-b57fe7c94732"],
Cell[20624, 578, 479, 11, 22, "Message",ExpressionUUID->"5c55ebf5-3fcc-4265-811b-6a52d2a4bc91"],
Cell[21106, 591, 479, 11, 22, "Message",ExpressionUUID->"1e796723-6569-4f24-8364-a13e04b4620e"],
Cell[21588, 604, 478, 11, 22, "Message",ExpressionUUID->"d8c6d788-914a-4ff9-ae0d-807e6222537e"],
Cell[22069, 617, 481, 11, 22, "Message",ExpressionUUID->"f2719915-e08b-4598-af5e-e46a6ff09311"]
}, Open  ]],
Cell[22565, 631, 500, 11, 49, "Input",ExpressionUUID->"2aff33bf-c914-4c58-a535-9a6bebf7fb4e"],
Cell[CellGroupData[{
Cell[23090, 646, 441, 8, 49, "Input",ExpressionUUID->"e6fa683c-955c-4919-8308-10befe9bb548"],
Cell[CellGroupData[{
Cell[23556, 658, 251, 5, 23, "Print",ExpressionUUID->"5c1baa7b-749c-4544-981d-254be83cd284"],
Cell[23810, 665, 271, 5, 23, "Print",ExpressionUUID->"a7913bb6-9b46-473a-84c1-e1c899ccfeac"],
Cell[24084, 672, 249, 5, 23, "Print",ExpressionUUID->"b8a94f84-b580-4290-b903-940dbfceceef"],
Cell[24336, 679, 375, 9, 23, "Print",ExpressionUUID->"4a9b6dac-7f5c-4dce-b175-911f4900fae9"],
Cell[24714, 690, 240, 5, 23, "Print",ExpressionUUID->"127f2f58-365f-4403-9993-3df489f1ee4b"],
Cell[24957, 697, 272, 5, 23, "Print",ExpressionUUID->"5d34b01f-181d-46ae-92e8-5d0fa232d1ce"],
Cell[25232, 704, 266, 5, 23, "Print",ExpressionUUID->"e2daf5cf-aea5-45b9-b1c9-31c4ed93d6e8"],
Cell[25501, 711, 277, 6, 23, "Print",ExpressionUUID->"09eddbca-756a-4a13-9314-d2d3d1dcd686"],
Cell[25781, 719, 229, 5, 23, "Print",ExpressionUUID->"cf791800-5d9b-4c9f-bd68-a522b6302f33"],
Cell[26013, 726, 258, 5, 23, "Print",ExpressionUUID->"34f2e4c4-853b-4637-9a3b-03ec098e2710"],
Cell[26274, 733, 262, 5, 23, "Print",ExpressionUUID->"e0baa54d-4c9b-4d92-8341-4f0fcb2986b3"],
Cell[26539, 740, 260, 5, 23, "Print",ExpressionUUID->"29c7535b-2803-4537-9f2e-812f78627cd2"],
Cell[26802, 747, 442, 10, 41, "Print",ExpressionUUID->"8164a508-e34f-4b7f-aa15-1cf004aafd6b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27293, 763, 523, 7, 29, "Input",ExpressionUUID->"3983cf50-bf60-485f-8860-de91e9bf0df4"],
Cell[CellGroupData[{
Cell[27841, 774, 308, 6, 23, "Print",ExpressionUUID->"1b048953-c3a1-4ef6-ada2-a95d69248ba1"],
Cell[28152, 782, 304, 6, 23, "Print",ExpressionUUID->"8a397ca9-1211-479b-82c4-6214edf734f2"],
Cell[28459, 790, 501, 13, 23, "Print",ExpressionUUID->"4c6586f6-776b-4fe7-b0b5-7962003bfa8c"],
Cell[28963, 805, 254, 5, 23, "Print",ExpressionUUID->"4f77dac6-be3c-4253-8071-337392b20a97"],
Cell[29220, 812, 247, 5, 23, "Print",ExpressionUUID->"b72db86a-4ad6-432e-8116-6d742fad1d6b"],
Cell[29470, 819, 367, 9, 23, "Print",ExpressionUUID->"7cd5b8bf-fa8b-4540-814b-19a2e0fa25d2"],
Cell[29840, 830, 257, 5, 23, "Print",ExpressionUUID->"cd24665a-7667-4833-b0aa-ef9e5e5017f5"]
}, Open  ]],
Cell[30112, 838, 216, 4, 33, "Output",ExpressionUUID->"3c95fc71-f282-46fb-ba8b-3fe505c02775"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30365, 847, 1456, 20, 29, "Input",ExpressionUUID->"3b58d9f5-310b-4525-aa2a-0add26b681e8"],
Cell[CellGroupData[{
Cell[31846, 871, 473, 12, 23, "Print",ExpressionUUID->"695d3809-3f40-4ac5-9654-5d3a3ad88547"],
Cell[32322, 885, 228, 4, 23, "Print",ExpressionUUID->"db52213e-a76b-4fb6-808f-17a0218f669b"],
Cell[32553, 891, 261, 5, 23, "Print",ExpressionUUID->"2975b9a8-584b-46d9-a5cb-685f9127bbad"],
Cell[32817, 898, 759, 17, 23, "Print",ExpressionUUID->"f9329390-badf-494b-9287-1a13de83c5ac"],
Cell[33579, 917, 341, 8, 23, "Print",ExpressionUUID->"f0366643-edfd-4036-8cdd-25da6d0c9e5c"]
}, Open  ]],
Cell[33935, 928, 2153, 67, 42, "Output",ExpressionUUID->"ede3c523-bfc4-4197-bad8-28ab1a1d1eb1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36125, 1000, 2468, 34, 29, "Input",ExpressionUUID->"5a085b42-0388-4478-80d7-91d3b3e023b0"],
Cell[CellGroupData[{
Cell[38618, 1038, 280, 6, 23, "Print",ExpressionUUID->"a1ec18ce-5f65-4d9c-8434-70e5c6f88243"],
Cell[38901, 1046, 503, 13, 23, "Print",ExpressionUUID->"6d7a1b9a-4a8d-457a-9561-57be985af25a"],
Cell[39407, 1061, 258, 5, 23, "Print",ExpressionUUID->"ff8367e3-e8f1-43da-a2cb-1dddc0e4a357"],
Cell[39668, 1068, 291, 6, 23, "Print",ExpressionUUID->"9b3b4e39-f502-4d3d-b896-22da3f59b5e3"],
Cell[39962, 1076, 787, 18, 23, "Print",ExpressionUUID->"899d037a-29da-4c45-8dfd-2173726eb21c"],
Cell[40752, 1096, 371, 9, 23, "Print",ExpressionUUID->"cd3930aa-8922-4c69-8f55-3a5f4d71db5e"],
Cell[41126, 1107, 617, 13, 23, "Print",ExpressionUUID->"dda49f57-5f09-41e5-b015-5e891de7823e"],
Cell[41746, 1122, 272, 5, 23, "Print",ExpressionUUID->"f25a55b5-b3e0-4595-910e-5fad723ab43f"],
Cell[42021, 1129, 541, 14, 23, "Print",ExpressionUUID->"5d50d798-559f-4613-8a0b-598c511130fe"],
Cell[42565, 1145, 524, 13, 23, "Print",ExpressionUUID->"4fb6a253-6cba-4d07-b7b9-fca57cd85a94"],
Cell[43092, 1160, 471, 10, 23, "Print",ExpressionUUID->"a992012d-ea90-4b03-a6a8-dda2d0cd8576"],
Cell[43566, 1172, 459, 10, 23, "Print",ExpressionUUID->"2e981d5d-6e8f-4a19-82ea-ce12d4317cc4"],
Cell[44028, 1184, 255, 5, 23, "Print",ExpressionUUID->"c329f7bc-4d79-48be-8993-e4f97654d141"],
Cell[44286, 1191, 281, 6, 23, "Print",ExpressionUUID->"5e2f3191-f7fb-4a7c-abff-e7cdd1fd17ce"],
Cell[44570, 1199, 470, 10, 23, "Print",ExpressionUUID->"a91f64f1-384a-482e-ad13-dbd7599b069d"],
Cell[45043, 1211, 646, 14, 23, "Print",ExpressionUUID->"f14dd732-41f2-495b-b5b9-4b8f7ea8f1eb"],
Cell[45692, 1227, 251, 5, 23, "Print",ExpressionUUID->"582d0f54-e343-4fe6-8cad-f70718c5e099"],
Cell[45946, 1234, 236, 5, 23, "Print",ExpressionUUID->"bc92615a-c7d1-4f11-81be-607b5a1d3c14"]
}, Open  ]]
}, Open  ]]
}
]
*)

