(* ****************************************************************** *)
(* *****                                                        ***** *)
(* *****  FeynRules model file: Simplified s-channel DM models  ***** *)
(* *****  Author: A. Martini, K. Mawatari                       ***** *)
(* *****          J. Wang, C.Zhang                              ***** *)
(* *****                                                        ***** *)
(* ****************************************************************** *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "DMsimp_s_spin0";

M$Information = {
 Authors      -> {"A. Martini, K. Mawatari, J. Wang, C. Zhang"}, 
 Institutions -> {"Universite catholique de Louvain, Vrije Universiteit Brussel, Johnnas Gutenberg University of Mainz, Brookhaven National Laboratory"},
 Emails       -> {"kentarou.mawatari@vub.ac.be","cenzhang@bnl.gov"},
 URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/DMsimp/",  
 References   -> {"O. Mattelaer et al., arXiv:1508.00564",
                  "M. Backovic et al., arXiv:1508.05327",
                  "M. Neubert et al., arXiv:1508.xxxxx"},
 Version      -> "1.0",
 Date         -> "2015.08.24"
};

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 2015.08.24 v1.0 - release version. *) 


(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderLimit = {
 {DMS, 2}
};

M$InteractionOrderHierarchy = {
 {QCD, 1}, {DMS, 2}, {QED, 2}
};


(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {

S[7] == { ClassName -> Xr,
	  SelfConjugate -> True,
	  Mass -> {MXr, 10.},
          Width -> 0,
          PDG -> 5000001,
          TeX -> Subscript[X,r],
          FullName -> "Real scalar DM" },

S[8] == { ClassName -> Xc,
  	  SelfConjugate -> False,
  	  Mass -> {MXc, 10.},
  	  Width -> 0,
          PDG -> 51,
          TeX -> Subscript[X,c],
          FullName -> "Complex scalar DM" },

F[7] == { ClassName -> Xd,
          SelfConjugate -> False,
	  Mass -> {MXd, 10.},
          Width -> 0,
          PDG -> 52,
          TeX -> Subscript[X,d],
          FullName -> "Dirac DM" },

S[9] == { ClassName -> Y0,
	  SelfConjugate -> True,
	  Mass -> {MY0, 1000.},
          Width -> {WY0, 10.},
          PDG -> 54,
          TeX -> Subscript[Y,0],
          FullName -> "Scalar mediator" }

};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)  
M$Parameters = {

 gSXr == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,SXr],
      Description -> "Xr-Y0 scalar coupling",
      Value -> 0. },     

 gSXc == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,SXc],
      Description -> "Xc-Y0 scalar coupling",
      Value -> 0. },     

 gSXd == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,SXd],
      Description -> "Xd-Y0 scalar coupling",
      Value -> 1. },     	  

 gPXd == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,PXd],
      Description -> "Xd-Y0 pseudoscalar coupling",
      Value -> 0. },     	  

 gSd11 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sd11],
      Description -> "d-Y0 scalar coupling",
      Value -> 1. },     

 gSu11 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Su11],
      Description -> "u-Y0 scalar coupling",
      Value -> 1. },     

 gSd22 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sd22],
      Description -> "s-Y0 scalar coupling",
      Value -> 1. },

 gSu22 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Su22],
      Description -> "c-Y0 scalar coupling",
      Value -> 1. },

 gSd33 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sd33],
      Description -> "b-Y0 scalar coupling",
      Value -> 1. },     

 gSu33 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Su33],
      Description -> "t-Y0 scalar coupling",
      Value -> 1. },     

 gPd11 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pd11],
      Description -> "d-Y0 pseudoscalar coupling",
      Value -> 0. },     

 gPu11 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pu11],
      Description -> "u-Y0 pseudoscalar coupling",
      Value -> 0. },     

 gPd22 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pd22],
      Description -> "s-Y0 pseudoscalar coupling",
      Value -> 0. },

 gPu22 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pu22],
      Description -> "c-Y0 pseudoscalar coupling",
      Value -> 0. },

 gPd33 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pd33],
      Description -> "b-Y0 pseudoscalar coupling",
      Value -> 0. },     

 gPu33 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pu33],
      Description -> "t-Y0 pseudoscalar coupling",
      Value -> 0. },     

 Lambda == { 
      ParameterType -> External,
      BlockName -> DMINPUTS, 
      TeX -> \[CapitalLambda],
      Description -> "cutoff scale",
      Value -> 10000. }, 

 gSg == { 
      ParameterType -> External,
      BlockName -> DMINPUTS, 
      InteractionOrder -> {DMS, 1},
      TeX -> Subscript[g,Sg],
      Description -> "g-Y0 scalar coupling",
      Value -> 0. },     

 gPg == { 
      ParameterType -> External,
      BlockName -> DMINPUTS, 
      InteractionOrder -> {DMS, 1},
      TeX -> Subscript[g,Pg],
      Description -> "g-Y0 pseudoscalar coupling",
      Value -> 0. }

};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

L0X := 1/2 MXr gSXr Xr Xr Y0 +
       MXc gSXc Xcbar Xc Y0 + 
       Xdbar.(gSXd + I gPXd Ga[5]).Xd Y0;

L0SM := 1/Sqrt[2] *
        ( ydo dbar.(gSd11 + I gPd11 Ga[5]).d Y0 +
          yup ubar.(gSu11 + I gPu11 Ga[5]).u Y0 +
          ys  sbar.(gSd22 + I gPd22 Ga[5]).s Y0 +
          yc  cbar.(gSu22 + I gPu22 Ga[5]).c Y0 +
          yb  bbar.(gSd33 + I gPd33 Ga[5]).b Y0 +
          yt  tbar.(gSu33 + I gPu33 Ga[5]).t Y0  );

L0SMg := 1/Lambda FS[G,mu,nu,a] (gSg FS[G,mu,nu,a] + 
                                 gPg Dual[FS][G,mu,nu,a]) Y0;

L0DM := L0X + L0SM;
