(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    340304,       7059]
NotebookOptionsPosition[    317848,       6472]
NotebookOutlinePosition[    318185,       6487]
CellTagsIndexPosition[    318142,       6484]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6035389591727333`*^9, 3.6035389606320753`*^9}, {
  3.608281672604871*^9, 3.608281673651908*^9}, {3.6097575541555*^9, 
  3.609757557300255*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Documents/feynrules-current_3_7\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.60353897829296*^9, 3.603539043421093*^9}, {
   3.633332218679607*^9, 3.6333322194542303`*^9}, 3.633333796845446*^9, {
   3.64301873415166*^9, 3.64301873665499*^9}, {3.6452720966860647`*^9, 
   3.645272098076991*^9}, {3.647076372652458*^9, 3.647076373114575*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.603539048879374*^9, 3.603539054382785*^9}, {
  3.630748915770712*^9, 3.630748916976617*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.6494051884010763`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.7\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 July 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.7", " (" "27 July 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188445945*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188447673*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188449136*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.6494051884506083`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188452148*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188453771*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.6494051884553413`*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188457313*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.64940518845918*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9, 3.649405188460844*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/DMsimp\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.603539061006528*^9, 3.603539075359961*^9}, {
   3.606550370901471*^9, 3.606550372067235*^9}, {3.608280713549712*^9, 
   3.608280720038208*^9}, {3.608280848612903*^9, 3.608280850051903*^9}, {
   3.610078232055901*^9, 3.610078244162396*^9}, {3.611032810906569*^9, 
   3.611032811729677*^9}, 3.611046032505571*^9, {3.611046080564261*^9, 
   3.6110460835240393`*^9}, {3.616920451742062*^9, 3.616920454335582*^9}, {
   3.61692081007111*^9, 3.616920811789462*^9}, {3.6169220902135057`*^9, 
   3.6169220916785192`*^9}, {3.627800218613393*^9, 3.6278002208210363`*^9}, {
   3.630748932272941*^9, 3.630748937906595*^9}, {3.633332239193083*^9, 
   3.6333322403879013`*^9}, 3.633333794100926*^9, {3.633759468942481*^9, 
   3.6337594703175983`*^9}, {3.635681641356083*^9, 3.6356816446148367`*^9}, {
   3.6376402973444223`*^9, 3.6376402986547117`*^9}, {3.639376919579711*^9, 
   3.639376921244483*^9}, {3.6405100299897413`*^9, 3.640510032443145*^9}, {
   3.643018741816877*^9, 3.643018742543559*^9}, 3.643024926442786*^9, {
   3.645273275267683*^9, 3.645273276634437*^9}, {3.645274930954957*^9, 
   3.645274932634717*^9}, {3.645770163878159*^9, 3.6457701691664543`*^9}, {
   3.645780013280984*^9, 3.645780013490704*^9}, {3.646026237633871*^9, 
   3.6460262398106728`*^9}, {3.6473477666176853`*^9, 3.647347767847106*^9}, {
   3.649402992381681*^9, 3.6494029933443527`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.603538963565145*^9, 3.603538971919922*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM.fr\>\"", ",", "\"\<dm_s_spin0.fr\>\"", ",", 
   "\"\<dm_s_spin0_ew.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.633332249125042*^9, 3.633332249491701*^9}, {
   3.6337594763689528`*^9, 3.6337594776507893`*^9}, {3.6356816576884117`*^9, 
   3.6356816603749027`*^9}, {3.637640302808282*^9, 3.6376403082726*^9}, {
   3.637640716438528*^9, 3.6376407440268297`*^9}, 3.643024914860723*^9, {
   3.645273293611383*^9, 3.6452732956188726`*^9}, {3.645770176958198*^9, 
   3.645770177262162*^9}, {3.646026243920371*^9, 3.6460262460509453`*^9}, {
   3.647347782049244*^9, 3.64734778358805*^9}, {3.64940300547442*^9, 
   3.649403021810585*^9}, {3.6494051044305058`*^9, 3.649405106795322*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195055838*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.64940519509337*^9}],

Cell[BoxData["\<\"A. Martini, K. Mawatari, J. Wang, C. Zhang\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195095366*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195097041*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195098624*^9}],

Cell[BoxData["\<\"O. Mattelaer et al., arXiv:1508.00564\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195100688*^9}],

Cell[BoxData["\<\"M. Backovic et al., arXiv:1508.05327\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195102693*^9}],

Cell[BoxData["\<\"M. Neubert et al., arXiv:1508.xxxxx\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195104388*^9}],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/DMsimp/\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195106065*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.6494051951076937`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195109859*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195111539*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195261332*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.6494051953061943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"DMsimp_s_spin0\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "DMsimp_s_spin0", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9, 3.649405195362912*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.639376820290628*^9, 3.6393768234379387`*^9}, {
  3.6393770865564947`*^9, 3.6393770912761908`*^9}, {3.6393771858866796`*^9, 
  3.6393771863740797`*^9}, {3.639377466478868*^9, 3.639377471110105*^9}, {
  3.6393796364789057`*^9, 3.639379637142768*^9}, {3.639989012839026*^9, 
  3.639989036648665*^9}, {3.641539947651075*^9, 3.641539950365509*^9}, {
  3.641789785973187*^9, 3.641789792194556*^9}, {3.643025183012186*^9, 
  3.643025185439151*^9}, {3.645274945395602*^9, 3.645274957019786*^9}, {
  3.6457800188411694`*^9, 3.645780019775859*^9}, {3.646377072375288*^9, 
  3.646377083707752*^9}, {3.646465411317153*^9, 3.646465413430913*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.646733879107862*^9, 3.646733965179865*^9, 
  3.647076468461007*^9, 3.647347867464292*^9, 3.649403286040627*^9, 
  3.649404346434187*^9, 3.649405199454411*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless_5f.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless_5f.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{3.646733879107862*^9, 3.646733965179865*^9, 
  3.647076468461007*^9, 3.647347867464292*^9, 3.649403286040627*^9, 
  3.649404346434187*^9, 3.649405199612493*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.646733879107862*^9, 3.646733965179865*^9, 
  3.647076468461007*^9, 3.647347867464292*^9, 3.649403286040627*^9, 
  3.649404346434187*^9, 3.6494051997356853`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<DiagonalCKM.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], "]"}],
   "*)"}]], "Input",
 CellChangeTimes->{{3.6463770912666693`*^9, 3.646377094581213*^9}, {
  3.646465405450945*^9, 3.646465408665985*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{234., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Loading restrictions from ", "DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.633429802306655*^9, 3.633429905609647*^9, 3.633759825766581*^9, 
   3.633761301178506*^9, 3.633767062560195*^9, 3.63568273224512*^9, 
   3.635682967881454*^9, 3.635760185978702*^9, 3.637640793234333*^9, 
   3.6376409663453207`*^9, 3.6376414136719303`*^9, 3.63764154491444*^9, 
   3.637642217600418*^9, 3.63764258028148*^9, 3.637642660905436*^9, 
   3.637648137063446*^9, 3.6393770036335373`*^9, 3.639377101485468*^9, 
   3.6393772091113167`*^9, 3.639377330579913*^9, 3.6393774205071917`*^9, 
   3.6393775444189453`*^9, 3.639377598580368*^9, 3.6393796522052507`*^9, 
   3.639379737341523*^9, 3.639388647257901*^9, 3.639989041644158*^9, 
   3.640510201117528*^9, 3.641476035981634*^9, 3.641539952215021*^9, 
   3.641634873333626*^9, 3.641727111641016*^9, 3.641789794796475*^9, 
   3.643025228084968*^9, 3.645272125469777*^9, 3.645273303628559*^9, {
   3.6452749506689787`*^9, 3.645274959391213*^9}, 3.645770348976141*^9, 
   3.645780133863399*^9, 3.6457804245924997`*^9, 3.6460263615142183`*^9, 
   3.6463709387164497`*^9, 3.646371746535939*^9, 3.6463770982378063`*^9, 
   3.646388607680099*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless_5f.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{234., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless_5f.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.633429802306655*^9, 3.633429905609647*^9, 3.633759825766581*^9, 
   3.633761301178506*^9, 3.633767062560195*^9, 3.63568273224512*^9, 
   3.635682967881454*^9, 3.635760185978702*^9, 3.637640793234333*^9, 
   3.6376409663453207`*^9, 3.6376414136719303`*^9, 3.63764154491444*^9, 
   3.637642217600418*^9, 3.63764258028148*^9, 3.637642660905436*^9, 
   3.637648137063446*^9, 3.6393770036335373`*^9, 3.639377101485468*^9, 
   3.6393772091113167`*^9, 3.639377330579913*^9, 3.6393774205071917`*^9, 
   3.6393775444189453`*^9, 3.639377598580368*^9, 3.6393796522052507`*^9, 
   3.639379737341523*^9, 3.639388647257901*^9, 3.639989041644158*^9, 
   3.640510201117528*^9, 3.641476035981634*^9, 3.641539952215021*^9, 
   3.641634873333626*^9, 3.641727111641016*^9, 3.641789794796475*^9, 
   3.643025228084968*^9, 3.645272125469777*^9, 3.645273303628559*^9, {
   3.6452749506689787`*^9, 3.645274959391213*^9}, 3.645770348976141*^9, 
   3.645780133863399*^9, 3.6457804245924997`*^9, 3.6460263615142183`*^9, 
   3.6463709387164497`*^9, 3.646371746535939*^9, 3.6463770982378063`*^9, 
   3.64638860782644*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.633429802306655*^9, 3.633429905609647*^9, 3.633759825766581*^9, 
   3.633761301178506*^9, 3.633767062560195*^9, 3.63568273224512*^9, 
   3.635682967881454*^9, 3.635760185978702*^9, 3.637640793234333*^9, 
   3.6376409663453207`*^9, 3.6376414136719303`*^9, 3.63764154491444*^9, 
   3.637642217600418*^9, 3.63764258028148*^9, 3.637642660905436*^9, 
   3.637648137063446*^9, 3.6393770036335373`*^9, 3.639377101485468*^9, 
   3.6393772091113167`*^9, 3.639377330579913*^9, 3.6393774205071917`*^9, 
   3.6393775444189453`*^9, 3.639377598580368*^9, 3.6393796522052507`*^9, 
   3.639379737341523*^9, 3.639388647257901*^9, 3.639989041644158*^9, 
   3.640510201117528*^9, 3.641476035981634*^9, 3.641539952215021*^9, 
   3.641634873333626*^9, 3.641727111641016*^9, 3.641789794796475*^9, 
   3.643025228084968*^9, 3.645272125469777*^9, 3.645273303628559*^9, {
   3.6452749506689787`*^9, 3.645274959391213*^9}, 3.645770348976141*^9, 
   3.645780133863399*^9, 3.6457804245924997`*^9, 3.6460263615142183`*^9, 
   3.6463709387164497`*^9, 3.646371746535939*^9, 3.6463770982378063`*^9, 
   3.64638860794532*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckHermiticity", "[", 
   RowBox[{"LSM", "+", "L0DM", "+", "L0SMEW"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.633332290865224*^9, 3.633332305905663*^9}, 
   3.63333373270155*^9, 3.6337594836385403`*^9, {3.6337598304792633`*^9, 
   3.633759842414878*^9}, {3.635681667322399*^9, 3.63568169987755*^9}, {
   3.637640325295994*^9, 3.637640326653831*^9}, {3.6494030879543467`*^9, 
   3.649403102697242*^9}, {3.649405111126108*^9, 3.649405113793882*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405206717332*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405206719323*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405227202507*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405227205475*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.64940522720875*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405228176402*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405228230291*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405228232519*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9, 3.649405228234296*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LSM", "+", "L0DM", "+", "L0SMEW"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.603539435628551*^9, 3.603539443511031*^9}, {
   3.633332257675256*^9, 3.633332273874855*^9}, 3.633332330927515*^9, {
   3.633759485057345*^9, 3.6337594896329927`*^9}, {3.633759845728799*^9, 
   3.633759845998361*^9}, {3.635681693519002*^9, 3.635681708124132*^9}, 
   3.637640353419092*^9, 3.649403113712747*^9, {3.6494051166588993`*^9, 
   3.649405119212523*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9, 3.6494052344440317`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9, 3.6494052344460897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9, 3.649405234448659*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9, 3.6494052451342983`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "147", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "147", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  147, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 147, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9, 3.649405245261861*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"142", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[142, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9, 3.649405254601104*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Lren", "=", 
    RowBox[{"OnShellRenormalization", "[", 
     RowBox[{
      RowBox[{"LSM", "+", "LDM"}], ",", 
      RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
      RowBox[{"FlavorMixing", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.639377293725038*^9, 3.639377294339272*^9}, {
  3.639377426660799*^9, 3.63937742737294*^9}, {3.639377575388748*^9, 
  3.639377575885442*^9}, {3.639377666979536*^9, 3.639377667838319*^9}, {
  3.639379689397005*^9, 3.6393796898866987`*^9}, {3.63938867958291*^9, 
  3.639388680272472*^9}, {3.64673380677352*^9, 3.646733809952742*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Lren", "=", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "L0DM", "+", "L0SMEW"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.646733829286021*^9, 3.646733829286853*^9}, {
   3.6467339400725517`*^9, 3.646733941680039*^9}, {3.647076393112405*^9, 
   3.647076398191709*^9}, 3.649403119421309*^9, {3.649405122823948*^9, 
   3.6494051250418653`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Extracting the mass and kinetic terms to simplify \
them\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.649405270585149*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.649405278101851*^9}],

Cell[BoxData["\<\"renormalizing the fields\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.6494052950997267`*^9}],

Cell[BoxData["\<\"No mixing allowed for the renormalization\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.649405295215575*^9}],

Cell[BoxData["\<\"renormalizing the parameters\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.649405295257756*^9}],

Cell[BoxData["\<\"renormalizing the masses\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.649405295259654*^9}],

Cell[BoxData["\<\"renormalizing the other external parameters\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.6494052952612877`*^9}],

Cell[BoxData["\<\"Internal parameter renormalization\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.6494052952628937`*^9}],

Cell[BoxData["\<\"renormalizing the Lagrangian\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.649405309211465*^9}],

Cell[BoxData["\<\"with the parameters\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.64940530925939*^9}],

Cell[BoxData["\<\"with the fields\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9, 3.6494053110845633`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", "[", "\"\<~/Documents/FeynArts-3.8/Models\>\"", "]"}], 
   ";"}], " "}]], "Input",
 CellChangeTimes->{3.6393806207387753`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"Lren", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<DMsimp_s_spin0\>\""}], ",", 
   RowBox[{"GenericFile", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6333334931038446`*^9, 3.6333335002871113`*^9}, {
   3.633429938271714*^9, 3.633429940559534*^9}, {3.633759562734586*^9, 
   3.633759563558978*^9}, {3.635681724626162*^9, 3.635681727084104*^9}, {
   3.6376404072686653`*^9, 3.637640408501841*^9}, {3.639376868393108*^9, 
   3.639376873532495*^9}, {3.639376939852498*^9, 3.63937694097348*^9}, {
   3.6405100428214617`*^9, 3.640510047037116*^9}, {3.640510118853291*^9, 
   3.6405101199564657`*^9}, {3.64301875554954*^9, 3.6430187563700323`*^9}, 
   3.643024935629327*^9, {3.645273450557111*^9, 3.64527345176429*^9}, {
   3.645275847284135*^9, 3.6452758487344007`*^9}, 3.6457702275909433`*^9, {
   3.645780047080944*^9, 3.645780047281754*^9}, {3.646026256330978*^9, 
   3.646026258353125*^9}, {3.646388651789977*^9, 3.646388653583241*^9}, {
   3.646733795890051*^9, 3.646733799012479*^9}, {3.647347792529991*^9, 
   3.647347793758451*^9}, {3.6494031342347517`*^9, 3.649403136315456*^9}, {
   3.649404423143777*^9, 3.649404424415291*^9}, {3.649405128114296*^9, 
   3.649405128761013*^9}, {3.649405520153398*^9, 3.649405522145337*^9}, {
   3.650089446983081*^9, 3.650089447423953*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to FeynArts - - -\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4A009FHXiAaAKA0maU=
  "]],

Cell[BoxData["\<\"      C. Degrande C. Duhr, 2013\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0j+QTLxANAJ3cmUU=
  "]],

Cell[BoxData["\<\"      Counterterms: B. Fuks, 2012\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0ZI0nXiAaAKB9mZs=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0kvkTLxANAJ1emTk=
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0G/VIbxANAKABmWk=
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0jm2kN4gGAJqbmL8=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0R1CkN4gGAJwOmPA=
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0jOIPXxANAJ0bmTQ=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Class members in the Lagrangian! Not supported by \
FeynArts.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0+eF/viAaAKKFmfc=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"201", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[201, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0DweDH4gGAJghmFQ=
  "]],

Cell[BoxData["\<\"Redefining classes in such a way that each particle is in a \
separate FeynArts class.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4C0mgyDH4gGAJd9mEI=
  "]],

Cell[BoxData["\<\"See NewFeynArtsClasses[] for more information on the new \
classes\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0E30GPxANAJ3ymRM=
  "]],

Cell[BoxData["\<\"Restarting Feynman rule calculation, setting FlavorExpand \
-> True.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0ATsGPxANAJ07mP4=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0F18GPxANAJ9EmUE=
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG0C0er4fiAYAniSZNA==
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0NvN8PxANAJ9UmVw=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0F9d8PxANAKGmmag=
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D05FqNQBANAJ6LmTs=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "220", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "220", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  220, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 220, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0cgP9QBANAJ06mQk=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"201", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[201, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0k4nawSAaAKG7maU=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
   "\[InvisibleSpace]", "\<\"DMsimp_spin0\"\>"}],
  SequenceForm["Writing FeynArts model file into directory ", "DMsimp_spin0"],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D00etyoSAaAKJpmcE=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts generic file on \"\>", 
   "\[InvisibleSpace]", "\<\"DMsimp_spin0.gen\"\>", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Writing FeynArts generic file on ", "DMsimp_spin0.gen", "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAOIpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQfQ8yY2GG4D0ujCFUBANAJ42mSs=
  "]]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Documents/FeynArts-3.8\>\"", "]"}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", " ", "FeynArts`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494522189*^9, 
   3.649405748787827*^9}],

Cell[BoxData["\<\"FeynArts 3.8\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494522189*^9, 
   3.649405748801323*^9}],

Cell[BoxData["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494522189*^9, 
   3.6494057488032703`*^9}],

Cell[BoxData["\<\"last revised 9 Jul 13\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494522189*^9, 
   3.649405748805111*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/Documents/feynrules-current_3_7\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.64302329717109*^9, 3.643023299501276*^9}, {
  3.6452723585550957`*^9, 3.645272359939103*^9}, {3.647076405736209*^9, 
  3.64707640635962*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", " ", "NLOCT`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - NLOCT - \"\>"], "Print",
 CellChangeTimes->{3.633334012398602*^9, 3.63334823479993*^9, 
  3.633430070827776*^9, 3.6337600047552557`*^9, 3.6337614288449593`*^9, 
  3.63376716963179*^9, 3.635683144036674*^9, 3.635760344048397*^9, 
  3.6376417854673986`*^9, 3.6376427809103813`*^9, 3.637648364508534*^9, 
  3.639388890816511*^9, 3.639989191172407*^9, 3.6405105028721447`*^9, 
  3.6414761840245857`*^9, 3.641540165251926*^9, 3.641635290546917*^9, 
  3.64172733228785*^9, 3.641790212336192*^9, 3.643025460613501*^9, 
  3.645272365875441*^9, 3.645273553311666*^9, 3.645274081217651*^9, 
  3.6452759224520473`*^9, 3.645770733219626*^9, 3.645780591417716*^9, 
  3.646026588840769*^9, 3.646371094455577*^9, 3.646372321274672*^9, 
  3.6463773477242813`*^9, 3.64638871796944*^9, 3.646734124503805*^9, 
  3.647076600246109*^9, 3.6473479946640787`*^9, 3.649403470879184*^9, 
  3.6494044980102777`*^9, 3.649405752171749*^9}],

Cell[BoxData["\<\"Version: 1.02\"\>"], "Print",
 CellChangeTimes->{3.633334012398602*^9, 3.63334823479993*^9, 
  3.633430070827776*^9, 3.6337600047552557`*^9, 3.6337614288449593`*^9, 
  3.63376716963179*^9, 3.635683144036674*^9, 3.635760344048397*^9, 
  3.6376417854673986`*^9, 3.6376427809103813`*^9, 3.637648364508534*^9, 
  3.639388890816511*^9, 3.639989191172407*^9, 3.6405105028721447`*^9, 
  3.6414761840245857`*^9, 3.641540165251926*^9, 3.641635290546917*^9, 
  3.64172733228785*^9, 3.641790212336192*^9, 3.643025460613501*^9, 
  3.645272365875441*^9, 3.645273553311666*^9, 3.645274081217651*^9, 
  3.6452759224520473`*^9, 3.645770733219626*^9, 3.645780591417716*^9, 
  3.646026588840769*^9, 3.646371094455577*^9, 3.646372321274672*^9, 
  3.6463773477242813`*^9, 3.64638871796944*^9, 3.646734124503805*^9, 
  3.647076600246109*^9, 3.6473479946640787`*^9, 3.649403470879184*^9, 
  3.6494044980102777`*^9, 3.64940575219746*^9}],

Cell[BoxData["\<\"Authors: C. Degrande\"\>"], "Print",
 CellChangeTimes->{3.633334012398602*^9, 3.63334823479993*^9, 
  3.633430070827776*^9, 3.6337600047552557`*^9, 3.6337614288449593`*^9, 
  3.63376716963179*^9, 3.635683144036674*^9, 3.635760344048397*^9, 
  3.6376417854673986`*^9, 3.6376427809103813`*^9, 3.637648364508534*^9, 
  3.639388890816511*^9, 3.639989191172407*^9, 3.6405105028721447`*^9, 
  3.6414761840245857`*^9, 3.641540165251926*^9, 3.641635290546917*^9, 
  3.64172733228785*^9, 3.641790212336192*^9, 3.643025460613501*^9, 
  3.645272365875441*^9, 3.645273553311666*^9, 3.645274081217651*^9, 
  3.6452759224520473`*^9, 3.645770733219626*^9, 3.645780591417716*^9, 
  3.646026588840769*^9, 3.646371094455577*^9, 3.646372321274672*^9, 
  3.6463773477242813`*^9, 3.64638871796944*^9, 3.646734124503805*^9, 
  3.647076600246109*^9, 3.6473479946640787`*^9, 3.649403470879184*^9, 
  3.6494044980102777`*^9, 3.649405752199304*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<~/Documents/feynrules-current_3_7/Models/DMsimp\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6333335430865088`*^9, 3.6333335552625504`*^9}, {
   3.633759553050228*^9, 3.633759553878661*^9}, {3.635681734336973*^9, 
   3.635681736612557*^9}, {3.637640417227786*^9, 3.6376404184754333`*^9}, {
   3.63937694796106*^9, 3.6393769493287563`*^9}, {3.6405100825800657`*^9, 
   3.640510083170496*^9}, 3.64051048875382*^9, {3.643018762649206*^9, 
   3.643018771597096*^9}, 3.643024946820489*^9, {3.645272373051367*^9, 
   3.645272374670525*^9}, {3.645274084493257*^9, 3.645274085716125*^9}, {
   3.645275926207169*^9, 3.645275927770879*^9}, 3.645770250485813*^9, 
   3.645770738860055*^9, {3.645780051087365*^9, 3.645780051727775*^9}, {
   3.646026265671403*^9, 3.6460262676920023`*^9}, {3.647076420208658*^9, 
   3.647076420403612*^9}, {3.647347800062046*^9, 3.647347801503477*^9}, {
   3.6494031514580183`*^9, 3.649403153218494*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{
   "\"\<DMsimp_s_spin0/DMsimp_s_spin0\>\"", ",", 
    "\"\<DMsimp_s_spin0/DMsimp_s_spin0\>\"", ",", 
    RowBox[{"Output", "->", "\"\<DMsimp_s_spin0\>\""}], ",", 
    RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"KeptIndices", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
      "}"}]}], ",", 
    RowBox[{"ComplexMass", "\[Rule]", "False"}], ",", 
    RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}], "//", "Timing",
   " "}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBmIQPYMtewWH0GvHXRNMV4Fo80cy6/mBtEqcHpjOWe+0
7AaQlnu0ZTmI5spYZNks9trxiDqHDYiWMzo9x17qtaPdu/0LQPSiH+51/bKv
HV+ZXKoH0VIPZreD6AuxP8C0ocS7CzvkXzu+UO6+DKK37FS0v6f42lH/QgqY
dp/YrMutBKRPHgTTXHrbH2oC6eWs58C0tRvj4UaV1446QtFgetVu9eMtQDro
0/UTIHqR4aobIHqO6w0wvXSy8u5zGq8dd3CU7QHR9ww6Hp8H0uxvLj4B0bXl
PxwPar52tDpzxQlEW2jt5ToGpNl45nCD6MzV35zttF47Kh2udAXRTt3snc+A
dLF3ezeInrFC8sV07deORaxdYNqkoL37sM5rx5b1k3tAdOvPJKX1Bq8d6+pP
K4Poh++cToNorr0WZ0F0yKQrkhuA9Kt9+VIg2uDZ13QQHdDDnwOi+25Mtv1n
CAzvuPn2IBoA/xHTBA==
  "]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805860054*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058058755713`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
   "\[InvisibleSpace]", "\<\"generic\"\>", 
   "\[InvisibleSpace]", "\<\" model file \"\>", 
   "\[InvisibleSpace]", \
"\<\"/home/amartini/Documents/FeynArts-3.8/Models/DMsimp_spin0/DMsimp_spin0.\
gen\"\>"}],
  SequenceForm[
  "", "loading ", "generic", " model file ", 
   "/home/amartini/Documents/FeynArts-3.8/Models/DMsimp_spin0/DMsimp_spin0.\
gen"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805877552*^9}}],

Cell[BoxData["\<\"> $GenericMixing is OFF\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058058788958`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"DMsimp_spin0/DMsimp_spin0\"\>", "}"}], 
   "\[InvisibleSpace]", "\<\" initialized\"\>"}],
  SequenceForm[
  "generic model ", {"DMsimp_spin0/DMsimp_spin0"}, " initialized"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805880295*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805881549*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
   "\[InvisibleSpace]", "\<\"classes\"\>", 
   "\[InvisibleSpace]", "\<\" model file \"\>", 
   "\[InvisibleSpace]", \
"\<\"/home/amartini/Documents/FeynArts-3.8/Models/DMsimp_spin0/DMsimp_spin0.\
mod\"\>"}],
  SequenceForm[
  "", "loading ", "classes", " model file ", 
   "/home/amartini/Documents/FeynArts-3.8/Models/DMsimp_spin0/DMsimp_spin0.\
mod"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805882975*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
   "\[InvisibleSpace]", "28", "\[InvisibleSpace]", "\<\" classes\"\>"}],
  SequenceForm[
  "> ", 49, " particles (incl. antiparticles) in ", 28, " classes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058058861933`*^9}}],

Cell[BoxData["\<\"> $CounterTerms are ON\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805935193*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "165", 
   "\[InvisibleSpace]", "\<\" vertices\"\>"}],
  SequenceForm["> ", 165, " vertices"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058059366913`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\" counter terms of order 1\"\>"}],
  SequenceForm["> ", 43, " counter terms of order 1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805980753*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"DMsimp_spin0/DMsimp_spin0\"\>", "}"}], 
   "\[InvisibleSpace]", "\<\" initialized\"\>"}],
  SequenceForm[
  "classes model ", {"DMsimp_spin0/DMsimp_spin0"}, " initialized"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805982658*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805984128*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405805985547*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 23 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "4 Generic, 23 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806026885*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 23 Classes insertions\"\>"}],
  SequenceForm["in total: ", "4 Generic, 23 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806028625*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058060300703`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806031448*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806032816*^9}}],

Cell[BoxData["\<\"Writing amplitude finished after 0.145255\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058060342007`*^9}}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 0.145365\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806035502*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806036845*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058060383673`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806039805*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806041189*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580604255*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806043867*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806045209*^9}}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 0.147336\"\>"], \
"Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806046542*^9}}],

Cell[BoxData["\<\"SU3 algebra finished after 0.147639\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806047831*^9}}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
0.147686\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806049094*^9}}],

Cell[BoxData["\<\"Vertices {S} finished after 0.147723\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806050398*^9}}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {F, F} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806051757*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058060530653`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058060544024`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580605581*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 122 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 122 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806204153*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 122 Classes insertions\"\>"}],
  SequenceForm["in total: ", "2 Generic, 122 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058062064543`*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806250424*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806252212*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806296671*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806298544*^9}}],

Cell[BoxData["\<\"Writing amplitude finished after 0.415737\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580630002*^9}}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 0.648883\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058064971333`*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806546154*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806547662*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806592548*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806594475*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806595842*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580659717*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806598547*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806599872*^9}}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 0.745787\"\>"], \
"Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405806601158*^9}}],

Cell[BoxData["\<\"SU3 algebra finished after 1.446246\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807294504*^9}}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
1.758012\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580760639*^9}}],

Cell[BoxData["\<\"Vertices {F, F} finished after 1.758225\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580760883*^9}}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807611161*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058076133833`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058076154337`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 26 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 26 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580766846*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"5 Generic, 96 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "5 Generic, 96 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580778785*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"7 Generic, 122 Classes insertions\"\>"}],
  SequenceForm["in total: ", "7 Generic, 122 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807789825*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807832429*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807834303*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807835807*^9}}],

Cell[BoxData["\<\"Writing amplitude finished after 1.963580\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807837422*^9}}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 1.963682\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807839377*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807840732*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807842071*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807843555*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058078449383`*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807846311*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807847746*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807849111*^9}}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 1.966563\"\>"], \
"Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058078504343`*^9}}],

Cell[BoxData["\<\"SU3 algebra finished after 1.966786\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807851739*^9}}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
1.966827\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807853188*^9}}],

Cell[BoxData["\<\"Vertices {S, S} finished after 1.966909\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058078550653`*^9}}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807856564*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058078580112`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058078593693`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 23 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 23 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405807860786*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"5 Generic, 134 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "5 Generic, 134 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580803043*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"7 Generic, 157 Classes insertions\"\>"}],
  SequenceForm["in total: ", "7 Generic, 157 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.64940580803205*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058080754213`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.6494058080773087`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405808078949*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 32 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "3 Generic, 32 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405808122883*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 33 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "4 Generic, 33 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405808124918*^9}}],

Cell[BoxData["\<\"Writing amplitude finished after 2.270125\"\>"], "Print",
 CellChangeTimes->{
  3.64673416601022*^9, 3.647076613520582*^9, 3.6473480021180143`*^9, 
   3.649403484993147*^9, 3.649404553243725*^9, {3.649405778728518*^9, 
   3.649405808126446*^9}}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 4.471344\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058103196993`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405810403686*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058104060087`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405810407509*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405810409054*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058104105787`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405810412121*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405810413741*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058104154663`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 4.571833\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405810460185*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 5.467940\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405811316156*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
5.884859\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058117332783`*^9}],

Cell[BoxData["\<\"Vertices {V, V} finished after 5.885033\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405811735784*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {F, F, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405811738328*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058117405157`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058117426567`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 424 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "6 Generic, 424 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815570842*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815572509*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815574078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815575678*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 424 Classes insertions\"\>"}],
  SequenceForm["in total: ", "6 Generic, 424 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815577117*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815724011*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815725607*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 10 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 10 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815769101*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 10 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 10 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815770816*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 9.902013\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815772378*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 9.948107\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815816642*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815860565*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815862278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 10 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 10 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058158638268`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 10 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 10 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940581586525*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058158665648`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815867972*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 10 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 10 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815869385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 10 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 10 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405815870841*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 10.015572\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058158729067`*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 10.344026\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405816192423*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
10.494648\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405816343109*^9}],

Cell[BoxData["\<\"Vertices {F, F, S} finished after 10.494847\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058163450212`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {F, F, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405816347012*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405816348524*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405816350093*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 680 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "6 Generic, 680 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940582115829*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405821161181*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405821162945*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940582116453*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 680 Classes insertions\"\>"}],
  SequenceForm["in total: ", "6 Generic, 680 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405821166037*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405821409068*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058214109*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 138 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "3 Generic, 138 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058216622057`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 138 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "3 Generic, 138 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058216647053`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 15.832685\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405821716909*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 16.407480\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058222560253`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940582255023*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822551949*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 56 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 56 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822598007*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 56 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 56 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822599605*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822600992*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822602502*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 56 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 56 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822646574*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 56 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 56 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822649126*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 16.888221\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405822736725*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 18.921821\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405824770541*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
19.607233\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058254557333`*^9}],

Cell[BoxData["\<\"Vertices {F, F, V} finished after 19.607817\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405825457341*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405825458996*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405825460368*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405825461852*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"7 Generic, 871 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "7 Generic, 871 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058269877787`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 81 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "3 Generic, 81 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058271429*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 81 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "3 Generic, 81 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058272989063`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 81 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "3 Generic, 81 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405827456032*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"16 Generic, 1114 Classes insertions\"\>"}],
  SequenceForm["in total: ", "16 Generic, 1114 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405827498651*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405827781767*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405827783853*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 291 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "3 Generic, 291 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058282601223`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405828303135*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405828305512*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405828307178*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 294 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "6 Generic, 294 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494058283087177`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 22.454756\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649405828310162*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 573.318859\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406379167557*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406379298964*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406379301756*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406379304266*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063793068933`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063793091917`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406379311634*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406379314115*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063793165693`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 573.485866\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063793621073`*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 580.668924\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406386517579*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
581.427638\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406387276335*^9}],

Cell[BoxData["\<\"Vertices {V, V, V} finished after 581.428062\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406387278319*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406387280045*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406387281515*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063872830973`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 404 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 404 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063884095907`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 48 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "3 Generic, 48 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940638852544*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 48 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "3 Generic, 48 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406388640065*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 67 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "3 Generic, 67 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063887903767`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"19 Generic, 567 Classes insertions\"\>"}],
  SequenceForm["in total: ", "19 Generic, 567 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940638879219*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063889423847`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406388944129*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 38 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 38 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389013341*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 38 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 38 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940638901504*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 583.170508\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389056918*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 583.332143\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389180706*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940638922173*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892239647`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389225587*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940638922711*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389228861*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892304153`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892319317`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 583.346631\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389233433*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 583.402607\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389277017*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
583.419153\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892790127`*^9}],

Cell[BoxData["\<\"Vertices {V, V, S} finished after 583.419329\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892805567`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892822237`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063892836523`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406389285198*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 546 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 546 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406390440607*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 76 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "3 Generic, 76 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063906062117`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 118 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "3 Generic, 118 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494063907993517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 118 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "3 Generic, 118 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406390987465*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"19 Generic, 858 Classes insertions\"\>"}],
  SequenceForm["in total: ", "19 Generic, 858 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406390990368*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406391195076*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406391197027*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 22 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 22 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406391240294*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 22 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 22 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406391242138*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 585.394413\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406391243682*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 600.014675\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405863235*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405864897*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405866569*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940640586827*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405869988*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405871729*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405873596*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405875135*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 600.017955\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405876607*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 600.018199\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405878127*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
600.018243\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405879589*^9}],

Cell[BoxData["\<\"Vertices {V, S, S} finished after 600.018362\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405881054*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {S, S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405882615*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405884131*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406405885682*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 800 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 800 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406407467458*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 110 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "3 Generic, 110 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064076445837`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 110 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "3 Generic, 110 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406407824378*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 110 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "3 Generic, 110 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408000523*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"19 Generic, 1130 Classes insertions\"\>"}],
  SequenceForm["in total: ", "19 Generic, 1130 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408044642*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408292816*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064082949667`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408296741*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 602.444940\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408298319*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 602.445050\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408299843*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408301263*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408302848*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064083047447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408306988*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408308543*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408310131*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408311721*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 602.448131\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940640831326*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 602.448363\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064083147573`*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
602.448405\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408316245*^9}],

Cell[BoxData["\<\"Vertices {S, S, S} finished after 602.448511\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064083177433`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, V, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408319303*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064083613033`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" field point(s) (incl. charge-conjugate \
ones)\"\>"}],
  SequenceForm[
  "Excluding ", 15, " field point(s) (incl. charge-conjugate ones)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408363482*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408365024*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406408366672*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 440 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 440 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406409106793*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 440 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 440 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406409888006*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 440 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "2 Generic, 440 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406410661374*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 440 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 440 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406411443473*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 440 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 5, ": ", "2 Generic, 440 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406412249041*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 440 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 6, ": ", "2 Generic, 440 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406413058114*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 3109 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 7, ": ", "4 Generic, 3109 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406420789752*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 3109 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 8, ": ", "4 Generic, 3109 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406428514216*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 3109 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 9, ": ", "4 Generic, 3109 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406437168095*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 314 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 10, ": ", "3 Generic, 314 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406437736053*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 314 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 11, ": ", "3 Generic, 314 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940643830973*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 314 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 12, ": ", "3 Generic, 314 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064388927*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064388947563`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" field point(s)\"\>"}],
  SequenceForm["Restoring ", 15, " field point(s)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406438896544*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"33 Generic, 12909 Classes insertions\"\>"}],
  SequenceForm["in total: ", "33 Generic, 12909 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940643895789*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940644367557*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064436777353`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406444607041*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406444647966*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406444650675*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406444652607*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 5, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406444654598*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 6, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406444656646*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 1383 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 7, ": ", "3 Generic, 1383 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406447214037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 1383 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 8, ": ", "3 Generic, 1383 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406449802979*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 1383 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 9, ": ", "3 Generic, 1383 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406452365553*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 10, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064524117603`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 11, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406452414173*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 12, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649406452416119*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"18 Generic, 4158 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "18 Generic, 4158 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064524177647`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 646.878262\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494064527270517`*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 1211.411309\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407017259931*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070177302303`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407017732359*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070177346287`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940701773636*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407017738826*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070177408037`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940701774267*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070177443733`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 1211.898438\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070177468433`*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 1245.671102\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407051520233*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after 1249.112503\"\
\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070549611053`*^9}],

Cell[BoxData["\<\"Vertices {V, V, V, V} finished after 1249.112789\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407054962912*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407054964604*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407055007063*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" field point(s) (incl. charge-conjugate \
ones)\"\>"}],
  SequenceForm[
  "Excluding ", 15, " field point(s) (incl. charge-conjugate ones)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407055009019*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940705501066*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407055012298*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 346 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 346 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407055771063*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 624 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 624 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407056981649*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 624 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "2 Generic, 624 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407058189868*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 624 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 624 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407059395691*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 624 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 5, ": ", "2 Generic, 624 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407060600855*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 723 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 6, ": ", "2 Generic, 723 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407061892707*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 1280 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 7, ": ", "4 Generic, 1280 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070665873833`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 1280 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 8, ": ", "4 Generic, 1280 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407071369179*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 1222 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 9, ": ", "4 Generic, 1222 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070751723547`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 276 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 10, ": ", "3 Generic, 276 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407075762672*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 381 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 11, ": ", "3 Generic, 381 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407076324428*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 381 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 12, ": ", "3 Generic, 381 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407076928926*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407076931191*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" field point(s)\"\>"}],
  SequenceForm["Restoring ", 15, " field point(s)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407076933095*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"33 Generic, 8385 Classes insertions\"\>"}],
  SequenceForm["in total: ", "33 Generic, 8385 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407076981553*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407079597714*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407079600119*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 134 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 134 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407079927128*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 134 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 134 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070801679363`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 134 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 134 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080410297*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 402 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "3 Generic, 402 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080412819*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 1274.626823\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080475449*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 1274.901050\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080749728*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080791703*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080794332*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080796838*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080799039*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.64940708080066*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080802429*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080804534*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 1274.926135\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080806308*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 1275.012012\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.6494070808606367`*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after 1275.030925\"\
\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080901919*^9}],

Cell[BoxData["\<\"Vertices {V, V, S, S} finished after 1275.031144\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080904262*^9}],

Cell[BoxData["\<\"before merge 1275.038052 temp=58.630977\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080906102*^9}],

Cell[BoxData["\<\"merging done 1275.064065\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407080947302*^9}],

Cell[BoxData["\<\"Writing R2 and UV counterterms from \
DMsimp_spin0/DMsimp_spin0 and DMsimp_spin0/DMsimp_spin0 in DMsimp_spin0.nlo\"\
\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407081009088*^9}],

Cell[BoxData["\<\"done\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9, 
  3.649405778728518*^9, 3.649407081054008*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1281.63944599999990714422892779111862182617`9.128365778839777", ",", 
   "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.646734471449627*^9, 3.6470768947501574`*^9, 
  3.647348337525042*^9, 3.64940386211159*^9, 3.649404920430368*^9, 
  3.649405778838717*^9, 3.64940708109133*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.645276376306346*^9, 3.6452763777860003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Documents/feynrules-current_3_7\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.633334333718008*^9, {3.643018789753442*^9, 3.643018791330467*^9}, {
   3.645272799947063*^9, 3.645272801466074*^9}, {3.647076435500992*^9, 
   3.6470764362644157`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.64940739906894*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.7\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 July 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.7", " (" "27 July 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.649407399094679*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.649407399096837*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.6494073990988207`*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.6494073991004667`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.6494073991021767`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.649407399103785*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.649407399106081*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.649407399107726*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.64940739910935*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9, 3.6494073991110363`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/DMsimp\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.633333653355482*^9, 3.633333654140135*^9}, {
   3.633759508925624*^9, 3.633759509782259*^9}, {3.6356817782298527`*^9, 
   3.63568178057517*^9}, {3.637643151097705*^9, 3.637643157090357*^9}, {
   3.639376969362584*^9, 3.639376970805305*^9}, {3.640510133439883*^9, 
   3.640510134052121*^9}, {3.64301879488282*^9, 3.6430187955340557`*^9}, 
   3.6430249807051477`*^9, {3.645273962622952*^9, 3.6452739639072227`*^9}, {
   3.645276394612421*^9, 3.645276395972137*^9}, 3.6457702767154827`*^9, {
   3.6457800697087383`*^9, 3.645780069903144*^9}, {3.646026301430621*^9, 
   3.646026303553194*^9}, {3.64734782249478*^9, 3.6473478235665007`*^9}, {
   3.6494031754789267`*^9, 3.649403176983906*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM.fr\>\"", ",", "\"\<dm_s_spin0.fr\>\"", ",", " ", 
   "\"\<dm_s_spin0_ew.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.6333336630998907`*^9, 3.633333666934019*^9}, {
   3.6337595144873743`*^9, 3.633759515254868*^9}, {3.635681785377611*^9, 
   3.635681787678496*^9}, {3.6376404775561666`*^9, 3.637640487932433*^9}, {
   3.63764316147395*^9, 3.637643161943272*^9}, 3.6430249837647533`*^9, {
   3.645273967364667*^9, 3.645273969067214*^9}, {3.6452764011648684`*^9, 
   3.645276411381513*^9}, {3.645770280750688*^9, 3.645770280968597*^9}, {
   3.646026307411837*^9, 3.64602630943712*^9}, {3.647347826971569*^9, 
   3.6473478280586557`*^9}, {3.6494031824564037`*^9, 3.649403201047883*^9}, {
   3.649405151954632*^9, 3.6494051543484592`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074042540817`*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074042846107`*^9}],

Cell[BoxData["\<\"A. Martini, K. Mawatari, J. Wang, C. Zhang\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404286735*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074042886333`*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074042905397`*^9}],

Cell[BoxData["\<\"O. Mattelaer et al., arXiv:1508.00564\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074042926903`*^9}],

Cell[BoxData["\<\"M. Backovic et al., arXiv:1508.05327\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404294465*^9}],

Cell[BoxData["\<\"M. Neubert et al., arXiv:1508.xxxxx\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404296132*^9}],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/DMsimp/\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.64940740429781*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074042995453`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404301153*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404302813*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.6494074044359503`*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404480213*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"DMsimp_s_spin0\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "DMsimp_s_spin0", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9, 3.649407404525065*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.639989591485811*^9, 3.639989593069509*^9}, {
  3.64154097216433*^9, 3.641540974684147*^9}, {3.6417909255941687`*^9, 
  3.6417909297310133`*^9}, {3.643025203788245*^9, 3.643025206111291*^9}, {
  3.645276440101756*^9, 3.645276449127439*^9}, {3.645780074961405*^9, 
  3.645780076352491*^9}, {3.6463776813917847`*^9, 3.646377688991543*^9}, {
  3.646465430675503*^9, 3.6464654368223667`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6334306848130302`*^9, 3.633760429152564*^9, 3.633761916024652*^9, 
   3.633768120147912*^9, 3.6356836192767067`*^9, 3.63568369175706*^9, 
   3.6356839326067247`*^9, 3.635683989102797*^9, 3.635760791879394*^9, 
   3.6376431668304768`*^9, 3.637647380992176*^9, 3.637648756419928*^9, 
   3.639389312685671*^9, 3.639989602876381*^9, 3.6405108810467577`*^9, 
   3.640511031933874*^9, 3.64147666589777*^9, 3.641540977305107*^9, 
   3.641635769894772*^9, 3.641727918705084*^9, 3.641790931402239*^9, 
   3.643025920128963*^9, 3.645272819582477*^9, 3.645273976685206*^9, 
   3.6452744918051853`*^9, {3.6452764455565166`*^9, 3.645276449911216*^9}, 
   3.645771197671864*^9, 3.64578124125686*^9, 3.646027089730276*^9, 
   3.6463715521531687`*^9, 3.646373048024355*^9, 3.6463776916950293`*^9, 
   3.646390137024032*^9, {3.6467345152009907`*^9, 3.646734535311812*^9}, 
   3.6470769522530413`*^9, 3.647348361642148*^9, 3.649404158128687*^9, 
   3.649404964394639*^9, 3.649407407206975*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless_5f.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless_5f.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6334306848130302`*^9, 3.633760429152564*^9, 3.633761916024652*^9, 
   3.633768120147912*^9, 3.6356836192767067`*^9, 3.63568369175706*^9, 
   3.6356839326067247`*^9, 3.635683989102797*^9, 3.635760791879394*^9, 
   3.6376431668304768`*^9, 3.637647380992176*^9, 3.637648756419928*^9, 
   3.639389312685671*^9, 3.639989602876381*^9, 3.6405108810467577`*^9, 
   3.640511031933874*^9, 3.64147666589777*^9, 3.641540977305107*^9, 
   3.641635769894772*^9, 3.641727918705084*^9, 3.641790931402239*^9, 
   3.643025920128963*^9, 3.645272819582477*^9, 3.645273976685206*^9, 
   3.6452744918051853`*^9, {3.6452764455565166`*^9, 3.645276449911216*^9}, 
   3.645771197671864*^9, 3.64578124125686*^9, 3.646027089730276*^9, 
   3.6463715521531687`*^9, 3.646373048024355*^9, 3.6463776916950293`*^9, 
   3.646390137024032*^9, {3.6467345152009907`*^9, 3.646734535311812*^9}, 
   3.6470769522530413`*^9, 3.647348361642148*^9, 3.649404158128687*^9, 
   3.649404964394639*^9, 3.649407407364414*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.6334306848130302`*^9, 3.633760429152564*^9, 3.633761916024652*^9, 
   3.633768120147912*^9, 3.6356836192767067`*^9, 3.63568369175706*^9, 
   3.6356839326067247`*^9, 3.635683989102797*^9, 3.635760791879394*^9, 
   3.6376431668304768`*^9, 3.637647380992176*^9, 3.637648756419928*^9, 
   3.639389312685671*^9, 3.639989602876381*^9, 3.6405108810467577`*^9, 
   3.640511031933874*^9, 3.64147666589777*^9, 3.641540977305107*^9, 
   3.641635769894772*^9, 3.641727918705084*^9, 3.641790931402239*^9, 
   3.643025920128963*^9, 3.645272819582477*^9, 3.645273976685206*^9, 
   3.6452744918051853`*^9, {3.6452764455565166`*^9, 3.645276449911216*^9}, 
   3.645771197671864*^9, 3.64578124125686*^9, 3.646027089730276*^9, 
   3.6463715521531687`*^9, 3.646373048024355*^9, 3.6463776916950293`*^9, 
   3.646390137024032*^9, {3.6467345152009907`*^9, 3.646734535311812*^9}, 
   3.6470769522530413`*^9, 3.647348361642148*^9, 3.649404158128687*^9, 
   3.649404964394639*^9, 3.649407407478094*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Get", "[", "\"\<DMsimp_s_spin0.nlo\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.633333679844839*^9, 3.633333682243373*^9}, {
   3.633759573989903*^9, 3.633759574813645*^9}, {3.635681792889392*^9, 
   3.635681794928862*^9}, {3.6376404988908873`*^9, 3.637640502843729*^9}, {
   3.6393769763154087`*^9, 3.6393769775307503`*^9}, {3.640510140072566*^9, 
   3.640510141779975*^9}, {3.643024989253413*^9, 3.6430249909315453`*^9}, {
   3.643025070685824*^9, 3.643025074221505*^9}, {3.6452739791542587`*^9, 
   3.64527398039443*^9}, {3.645276453474934*^9, 3.645276454803453*^9}, 
   3.645770286391513*^9, {3.6457800800957413`*^9, 3.645780080471368*^9}, {
   3.646026321042013*^9, 3.646026322988809*^9}, {3.647347834625543*^9, 
   3.647347835975219*^9}, {3.649403214712672*^9, 3.649403216153846*^9}, {
   3.649404967303237*^9, 3.649404968446651*^9}, {3.6494051586377497`*^9, 
   3.649405158827737*^9}, {3.649408257531732*^9, 3.649408257993623*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "L0DM", "+", "L0SMEW"}], ",", 
   RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
   RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<DMsimp_s_spin0\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.603600645725746*^9, 3.6036006566228743`*^9}, {
   3.606550334098661*^9, 3.60655033664305*^9}, {3.608451188889968*^9, 
   3.608451204251935*^9}, 3.60845124249209*^9, {3.633332357749588*^9, 
   3.633332371706971*^9}, {3.633333594923254*^9, 3.6333336099891357`*^9}, {
   3.633333692998436*^9, 3.633333708244873*^9}, {3.633759523248143*^9, 
   3.63375952406321*^9}, 3.6337595816874228`*^9, {3.633759861480113*^9, 
   3.633759861782745*^9}, {3.635681799753024*^9, 3.635681812948553*^9}, {
   3.637640540300961*^9, 3.6376405694259853`*^9}, {3.637640663087901*^9, 
   3.637640663759862*^9}, {3.637647387697893*^9, 3.637647389712125*^9}, {
   3.637648387110936*^9, 3.637648387849903*^9}, {3.639389319458922*^9, 
   3.639389319865039*^9}, {3.64051094238649*^9, 3.640510950609267*^9}, {
   3.6430250002334414`*^9, 3.643025002692279*^9}, {3.643025047978877*^9, 
   3.643025060082522*^9}, {3.6452745024778748`*^9, 3.6452745079012833`*^9}, {
   3.645276460101131*^9, 3.645276462419408*^9}, 3.645770304766233*^9, {
   3.64578008286651*^9, 3.6457800832087*^9}, {3.646026325649763*^9, 
   3.646026327751546*^9}, {3.647347838972896*^9, 3.6473478401093903`*^9}, {
   3.64940322069949*^9, 3.6494032361730423`*^9}, {3.649405161701861*^9, 
   3.6494051712548447`*^9}, {3.650089489692153*^9, 3.6500894903785*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzUMhhMKXJQWqIwK1tuLeOJlpYVTZO+tmoqLVubtZaJ
o7SWaY2Z0whXMxh1USsHjKUFV2YLWiFUVpogpRb4f0scs1yjjZ7Xi7Pfxbk4
25FU1pZpF7BYrN2YLvkZa9kIA1mW7roj6E+n8s/EKAP5vOl4fIyBkj2O08px
Bu6fn7tCDXftsFGT9RLfvFMZFVVoaKAvSi01lz/Qoh3aSvkJ9JcnkdaJvuVc
FFB5AraU2tjpGO35zkCRKjdGvfP1sLcXPXnj3MvGCAPpTw1pl1Gp8+8qanXe
WaAeT/p2UuvENS3UuweNFdfQ6/pJvSuOPWOZo7qyoMmNzkYNwQ0pBFzt5pxv
HAIFym4F9dOb5tfZCwncXsZvlaHj7NCXBnSbU+cWLSGwnR/gpfIIPFyh5i9C
T4V9iaXocPSjoBAtFtuEI6j1Zl2AKlQIhoOo/l5T1lUhgfWZdgW1Tegpp7ZO
WoYeoUUbRb+VIgIvIstTVGj0qMpGNXpMHUYxgcH3vh7XSgKL980UPM/EXW7h
lnn9/cVU/bTK2y4hYPNHFHa0I7Wqfgw15LEvcKUEvAH1Zhna1sCB5tUEkjrN
scG1BPYf+rfOj+51S7IDqK4m/Kw/B38pnTW/Qi/t0jwukhGo/swP/UA1H0ym
CNqyRh2cQmtL2DMxdChhzejKJeCTPyndmkegcCL2bgDl9t6y2vIJNITSU+1o
pO/AJgf6H53pPAU=
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmjWMhhMKXJYWCIwK1tsLeOJlhYVpcn62KqptKw2ay1T
Rmkt05ozhxGsZjrqolYOGMsKrswWtEKorDRBSy3w/5Y4Z7lGGz2vF2e/i3Nx
tiMpqyo2zGOxWDsxNsVpe/EgA9LO9upD6E+3+s/YEAN5vMnp6WEGina5TqlH
Gbh3bvYydcS2zUFN1kgCc05klJajkd6nMaq2o+S+ATUbyhTH0F++RFob+pZz
QUDlCdhZ1Lo211DXdwYKNLlx6u2vB/3d6PHrZ1/WRRlIf9KcdgnNcv9dQa2Q
nwHq0WRgO7VaXNlIvbPfUnoVvWYaN3mmsWc6Z6keKdR70ZlYc3hdCgFPa0fO
Nw6BfHW7kvrpTcPr7PkEbi3hN8nQUXbkixHd4q71ihYR2MoP8bg8Ag+W6fgL
0BMjgcRidCD2UaBCC8UO4SBqv1EdogqVgoEwarpbL70iJLA206mktgh9JdSm
8c7+h2jBetFvtYjAi+jSFA0aO6xxUC0+q9kiJtD3PtDlWU5g4Z6p/OeZuJuq
2jRnsKeQaprU+FslBBzBqNKJmrnlNcNos5x9PjWLgD+k2yhDW4wcaFhJIFmr
P9K3msC+A//WBNHdXkl2CK2tHHnWk4O/aGc6XqEXd+gfFcgIVHzmR36g+g9W
axRtXKULT6BVReypONqfsGfYcgkEFI+1m+UEVGPxd71oavdNuyOPgDGSznWi
ewUnN7jQ/5VDOuE=
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBizmjUMhhMKXJQWKIwK1tsLeKJlhaVTdP1sVXzo2W12ccy
YZTWMq0xcxjBagajLmrl0LGs4MpsQSuUykoTpNQC/2+JY5ZrttHzenH2uzgX
ZzuS8priqnksFmsnxqY45SweYkDmaK89iP50a/6MDTOQx5tMJEYYKNzVdVIz
ysC9czOXqRHbNhc1WScJzDmRUVqBhnufxqg6e8n9KtRcVa44iv7yzaa1oW9T
LwioPAFbSq1v6xru+M6AWpsTp97+esDfjR67fvZlfZSB9CemtEuo1P13BbUy
9zRQjyQD26m14uom6p19ltKr6DXjuNGTwJ5xzFA9MmjwotMxU2hdCgFPqz37
WyqBfE27kvrpTePrrPkEbi3hN8vRUXb4iwHd4tZ7RYsIbOUHeRwegQfLivgL
0OORwOxidDD2UaBCC8Qu4RDqvFEbpAqVgsEQarzbILsiJLA2s1NJbRH6SqjN
446Bh6h6vei3RkTgRXRpihaNHdK6qBaf1WwRE+h7H+jwLCewcM9U/vNM3OWq
Ns3Z31NANU5q/a0SAq7+qLITNXMq6kZQUy77PFdKwB8s2ihHWwyp0LiSQFJf
drhvNYG9+/+t6Ud3eyVZQVRfHXnWk42/6Kbtr9CLO8oeqeUEKj/zwz/Qsg9W
axRtWlUUmkBrCtlTcXRg1plhyyEQUDzWbc4loBqLv+tFud03na48AoZwOqcT
PSM7saEL/Q+WuzsS
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmjUMhhMKXJYWCIwK1tsLeKJlpaVTZP1sVVTaVlt1lom
jtJapjVHDiNdTXHURa0cMpYVXJktbIVQWWmClFrg/y1xzHKNNnpeL85+F+fi
bEdaVlVsWMBisXZj2pVn7MUjDMi6OqoPoz9d2j8Towzk8qfj8TEGCvY4T2vH
Gbh3fu4KNdy+w0FN1kh9806ll5ajof6nUWqhreS+AbUYypTH0V/eRGor+pZz
UUjlC9mZ1LpW52j3dwY0upwY9c7XQwO96Ikb517WRRhIe9KcehnNdP1dRa1Q
nAXqsaRvJ7VaUtlIvXvAWnoNvW6aNLnj2DNdc1S3DOo96Gy0ObghhYC7xZb9
jUMgT9uhon560/A6ayGB28sETXJ0nB36Uotucxk94iUEtgsCfC6fwIMVRYJF
6MmwL7EUHY5+FKrRfIlDNILab1YHqCKVcDiImjrrZVdFBNZn9KioZpG3hNo0
2TX0ENVsFP/Wigm8iCxP0aHRIzoH1epts1glBAbf+7rdKwks3jeT9zwDd3nq
LfP6+/KppmndQIuUgMMfUfWgFm55zRjarGBf4GUSGAgUbZaj5loONKwmkDTq
jw6uJbD/4L91fnSvR5oVQI2V4Wd92fhL4aztFXppl/6RRk6g4rMg9APVf2hr
i6CNa4qCU2hVAXsmhg4l7OntOQR8yseFWxUE1BOxd/0or/eW3ZFLoDaUxu1B
zapTm5zof5faOzc=
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBXAbshYrso0NXS2ZNcuPDSuDQbT2tEhr1UJT+qJCXWQEFtFy
Y6VFpoWYaGujsI3VRWGyDclqg8CMtqjpKivNzZVam/+3nAxLYoE9rxeH38W5
OHAkFTUlugUpKSm7MFbZaUfJMANSe4f+EPqzW/VnfISBAt5UIjHKQPFu9ynV
GAP3zs1epkas253UuVpJYN7JjLJKNNz3JEbV2Erv69A2XYXsOPrLl0xrR9+y
LwioPAEri1rX7h7p+s6AUp0Xp97+etDfg564fvZlXZSB9MfNaZfQrO6/q6hV
+WeAemwusIOqF1c3Uu/sN5ddRa+ZJkyeBPaMfZbqkUK9F52JNYc2pBLwtNpy
vrEJFKo65NRPbxpeZy8kcGsZvykXHWOFvxjRrd0Gr2gJgW38II/DI/BghZa/
CD0ZCSSXokOxjwIFWiR2CodRxw19kCqUC4ZCqOluvfSKkMD6TJec2iL0lVKb
JuyDD1HlRtFvlYjAi+jyVDUaO6J2Us0+S5tZTKD/faDLs5LA4r3Thc8ycZer
2DzvQG8R1TSl9rdKCDgHonIX2saprB1Fm/NZ57lZBPxB7aZctMXIhobVBOYM
5Uf71xLYd+DfugF0j1eSHUQN1ZGnvTn4i2bG9gq9uLO8U5lLoOozP/wDLf9g
sUTRxjXa0CRaU8yajqODSUeGNY9AQPZIsyWfgGI8/q4P5fbcdDgLCBjD6RwX
2nn4ucKN/geb+zvW
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "147", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "147", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  147, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 147, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmjUMhhMKXNQWiIwK9vYWsQTLS0zmibrY6um0rK1WWuR
OEprmdaYOYxgNYNRF7VywFxWeGW2oBVCZaUJWmqB/7fEMcs12ux5vTj7XZyL
sx1xVV25flFaWtoejF1+2lU+zECus9NwGP3Zrf4zMcJAIW86mRxloKTMe0o9
zsC9c3OXqWP2nW7qfL04uOBUVmU1Gu1/GqeWOiru61GLvkp+HP3lT2V0oG/Z
FwRUnoAloTZ2eEe6vjOg0hQkqLe/Hgr0oCeun33ZGGMg84k54xIq6f67hloj
OwPUY/PBXVRDdm0L9c4Ba+VV9Jpp0uRLYs8456i+XGjqRWfj5simdAK+dkf+
NzaBInWngvrpTfPrvMUEbq3gt0rRcVb0SwO6vdvYK1pGYAc/zOPwCDxYpeUv
QU+OBVPL0aH4R4ESLc52C4dR1w1DmCpUCIYiqOluU+4VIYGNOR4FtU3or6C2
TjoHH6KqzaLfahGBF7GV6Ro0fkTjplr9Nos1m8DA+2CXbzWBpftmip7n4C5X
uXXBUF8x1TStCbSLCbhDMYUHtXCq60dRs4x1nishEAhrt0jRtgY2NK8lMG/U
HR1YT2D/wX8bQujeXnFeGDXWjj3ry8dfSmcdr9CLu3WPVFICNZ/50R+o7oPN
FkNb1mkjU2hdCWsmgQ6mXFn2AgJB+ePSbTICyonEu36U23PT5S4k0BDN5HhQ
j6tP6UX/A54fPCQ=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"142", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[142, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmjUMhhMKXJQWqIwK9toLeKJlpaVTZP1sVXzo2Vrs9Yy
ZZTWMq0xcxjJKsVRF7VywFhWcGW2oBVCZaUJUmKB/7fEOcs12uh5vTj7XZyL
sx1JRW1p9YKUlJTdGLP8tLV0hIGsnq66w+hPp/pPZJSBfN7UzMwYA0V7HKfU
4wzcOzd3mRo277BRk/US37yTGeWVaGjgaYxabCm7X40aqyvkx9FfnkRaB/qW
fUFA5QlYUmpjh2O09zsDKk1unHr76yFvH3ri+tmXjVEG0p8Y0i6hUuffVdSq
vDNAPZb07aTWiWtaqHcOmMqvotf0E3rXDPZMzxzVlQVNbnQ2ZghuSCXgarfk
fGMTKFB3Kaif3jS/zl5I4NYyfqsMHWeFvujQbc4Gt2gJge38AI/DI/BgRQl/
EXoy7EssRYdjHwVKtFBsE46g1ht1AapQIRgOovrupqwrQgLrM+0KapvQU0Zt
negZeoiqNop+q0UEXkSXp2rQ2BGNjWrydBpNYgKD7329rpUEFu+bLnieibtc
5ZZ5/f2FVP2UxtsuIWDzRxV21MiprB9DDXms81wpAW+gZLMMbdOxoXk1gWSD
9ujgWgL7D/5b50f3uiXZAbShJvysPwd/KZ61vEIv7tI+UskIVH3mh36g2g+d
nVG0ZU1JcBKtLWJNx9GhhDXDnEvAJ39cvDWPgDISfzeAcvtuWm35BHShdI4d
vauPbHKg/wGdRjwN
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "195"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 195],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzUMhhMKXJQWCIyK9tYLeOJlpYVTZP1sVVTadnarLVI
HKW1TGvMnGaymsKoi1o5YCwruDJb0Aqh0tIUKbXA/1vimOUabfa8Xpz9Ls7F
2Y6kvLpEv4jFYu3FWHLP2kuGGZDZOg1H0Z9u9Z+JEQbyeNOJxBgDRftcZ9Tj
DNy/MHeVGrHsclDnaySBBacyyirQcN+zGLXYWvpAj7bqy3NPor98ybQ29B3n
koDKE7Cl1Lo210j3dwYKNDlx6t2vR/w96Kmb51/VRRlIf2pOu4JK3X/XUCsV
54B6Yj6wm2oQVzVS7x1qL7uO3jBNmjwJ7BnbHNUjg3ovOhszj25KIeBpsWZ/
4xDIV3cqqZ/eNrzJWkzgzgp+kxwdZ4e/1KI73EavaBmBnfwQL5VH4OEqLX8J
ejoSSC5Hh2KDAhVaKHYIh1H7LUOIKlQKhkZRU1e97JqQwMZMp5LaLPSVUpsm
bQOP0ILNot9qEYGX0ZUpGjR2TOOgtvs6WtvFBPo/BLo9qwksPTCT/yITd7mq
bQsGewuppmmNv0VCwBGMKp1oa2pFzRhqVrAvcqUE/CHtVjnaXMuBhrUE5o26
4/3rCRw8/G9DEN3vlWSFUGNV5HlvNv5SPGt9jV7eo3tcICdQ+Zkf/oHqPnZ0
RNHGddrRKbS6iD0TRweS9gxLDoFA7pPi7QoCqon4+z6U23Pb7sgjUBtOT3VS
LYNbXOh/nKs7+g==
  "]],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmjUMhhMKXNQWCIwK9vYKuKJSouKpsn62KqptGxt1lqk
jtJapjVnDiNYzXDURa0cMBYVXJktbYVSWWmCllrg/y1xzHSNNnteL85+F+fi
bEdcWllkXJCSkrIHY1eccRYNMiBtbzMdQX95NTNjQwzk8SYTiWEGCvd6TmtG
Gbh/fvYKdcS+00WdqxIH553IKClDI13PYlSdo/iBEbUYSxUn0N/dybRW9B37
ooDKE7Ak1NpWz1DHDwbU2tw49c63wz0+9OSNc69qowykP21Ku4xKvH9XUcvl
Z4F6fC64i2rKrGig3j1oLbmGXjePm/0J7Jn2WapfCnUBdDrWFN6QSsDf4sj5
ziaQr2lTUj+/rX+TvZDA7WX8Rhk6yop8rUG3easDoiUEtvNDPA6PwMMVev4i
9NRIMLkUHYh9EqjQgkyXcBB13jSFqEKlYCCMmu/VSa8KCazPciupzcLuYmrj
eHv/I1S9UfRHIyLwMro8VYvGjmpdVGu3zWLNJND7IdjhX0lg8f6p/BdZuMtV
bZm3r7OAap7U9rSICbj6oko3auGUVQ2jTXLWBa6EQE9Iv0mGNtewoX41gblq
w7HetQQOHPq3rg/dFxBnh9DqipHnnTn4i27a8Rq9tNvwWC0jUP6FH/mJGj7a
bFG0YY0+PIFWFrKm4mh/0plhzyUQVDzRbZUTUI3F33ehXN8tpyuPQE0kneNG
Z3w7NnvQ/54HPAY=
  "]],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBizmzUMhhMKXJQWCoyK9vYKuKJlhYVpcn62KqptGxt1lom
jNJapjVmDiNcTWXURa0cOpcVXJktaIVQWWmClFrg/y1xzHKNNnpeL85+F+fi
bEdcXl2iX8BisXZj2vLPOEpGGJDa22uOoD97VX8mRhko4E7H42MMFO/pOa0a
Z+De+bkr1HDbDic1WSv2zTuVWVaBhgaeRqmaztL7etSiL88/gf7yJNJb0bep
F/lULp8toda19ox2fWdAqc6LUe98PeztQ0/eOPeyLsJAxhNz+mVU0vt3FbVS
dhaox5O+ndQaUVUj9e5Ba9k19Lpp0uSKY8/Y56guKdS70dmoObghhYCrpTPn
WyqBQlW7nPrpTcPr7IUEbi/jNeWi4+zQFyO6rdfgFi4hsJ0X4KZxCTxYoeUt
Qk+FfYml6HD0I1+BFomcghHUcbMmQBXI+cNB1NRRL70qILA+q1tObRZ4SqlN
k/ahh6hyo/C3SkjgRWR5ihqNHlU7qVaPzWIVERh87+tyrSSweN9M4fMs3OUo
tszr7y+imqbV3hYxAac/Iu9GLWkVtWOoWca+wJEQ8Aa0m3LRZmMqNKwmkDTo
jg2uJXDg0L91fnSvW5wdQA1V4Wf9OfiLZrbzFXppl+6RMpdA5Wde6Aeq+2Cz
RdDGNdrgFFpdzJ6JoUMJR2ZbHgFf/mPNVhkBxUTs3QDK6bvlcBYQMIYy0rpR
s2X/5h70P5oDO4Q=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "56"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 56],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzWMhhMKXJQWiIwK9vYKuKJlpYVTZP1sVVTadnarLVI
GaW1TGvMHEaymsGoi1o5YC4ruDJb0AqlstIEKbXA/1vinOUabfS8Xpz9Ls7F
2Y64srZMv4DFYu3G2OSnnWXDDOQ6Og2H0Z/d6j/jIwwUcqdmZkYZKNnjOaUe
Y+DeubnL1Khth4uaqhMH553MrqhCI31P49RSe/l9PWrRV8qPo7/8ycx29C3n
Ap/K5bMl1IZ2z0jXdwZUmoIE9fbXQ4Ee9MT1sy8bYgxkPTFnXkIl3X9XUatl
Z4B6LBXcSTWIapqpdw5YK66i10wTJu8M9oxjjurNhUYfOhs3hzekEfC22fO/
cQgUqTsV1E9vml7nLSRwaxmvRYqOsSNfjOi27nqfcAmB7bwQN51L4MEKLW8R
ejIaTC5Fh+If+Uq0WOQSDKPOG4YQVaDgD4VR093G3CsCAutz3Apqq8BfTm2Z
cAw+RFUbhb/VQgIvYsvTNGj8iMZFtfo7LFYRgf73wS7vSgKL900XPc/B3Qzl
lnkHeouppilNoE1MwDUQU7hRS3pV3ShqlrHPZ0gIBELaTVK01ciBptUEUvW6
o/1rCew/+G/dALrXJ84LofU10We9+fhL6az9FXpxl+6RSkqg+jMv8gPVfejo
iKHNa7ThSbS2hD2dQAeTzmxbAYGg/HHpVhkB5XjiXR+a0XPT6SokYIxkpbtR
m6Nsswf9D5rLO58=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "5.91873299999999957776708470191806554794`6.792828662232371", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Squared matrix elent compute in ", 
   5.91873299999999957776708470191806554794`6.792828662232371, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBXAbsowV2caGWku2muWcw8pgEK49LdKyWmiOPqBCXWQEFtFy
Y6VFpsUw0WyrsI0VVJRsQ7LarszIRU1XWWlurtTa/L+lY1gSC9bzenH4XZyL
A0dUWVumW5CSkrITY80/6SgbYUBi79QfRH92q/5MjDJQwJ2Ox8cYKNnlPqEa
Z+DumbmL1LB1m5OarBP5553KrKhCQ31Po9RSW/k9Hdqmq8w/iv7qT6S3o2/Z
5/hULp8lpta3u0e7vjOgVOfNUG99PeDrQY9dPf2yPsJAxhNz+gVU3P13FbVa
dgqoR5L+7VS9sKaJentfR8Vl9Ipp0uSJY8/Y56geCTR40dmoObghlYCn1Zb7
jU2gUNUpp3560/g6ZyGBG8t4zVJ0nBX6YkS3dBu8WUsIbOUFuGlcAg9WaHiL
0ONhf2IpOhz9yFegxUKnYAR1XNMHqAI5fziImu40SC4JCKzPdsmpLYL+cmrz
pH3oIarcmPVblUXgRWR5qhqNHlI7qR39lrYOIYGB9/4uz0oCi/fECp9n4y5H
UTTvYG8x1TSt9rWKCDgHI3IX2pZWVTeGmmWssxwxAV9As0mKthjZ0LiaQNKg
PTywlsDe/f/WDaK7vaKcAGqoCT/rzcVfSmdtr9DzO7SPlFIC1Z95oR+o9oPF
EkGb1miCU2htCSs2gw4lHJnWPAL+/Melm2UEFBMz7/pQTs91h7OAgDGUkeZC
YzfvF7nR/59dPEY=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.01361799999999999989663823640739792609`4.1547132431219485", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Decay widths computed in ", 
   0.01361799999999999989663823640739792609`4.1547132431219485, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBfA1xBYrso0NXS2ZNcs5h5WBENqeFmlpGZqjD6hQFxmBRWRu
rLTItBgm2toozLG6MEq2MVq1XZnRjJpbZaW5uVJr8/+Wk2FJLFjP68Xhd3Eu
DhxJTUOlZgmLxSrHmPPOWCvHGJBaehqPoD+dyj9T4wzk82bj8QkGSvc6Tisn
Gbh/fuEKNWzeZaMmmyS+RWcyqmvR0ODTKLWst+qBBu3S1OSdQH95E2nd6NvU
iwIqT8DOojZ3O8b7vzNQrMqNUe98PTzkQk/eOPeyOcJA+hND2mU0y/l3HbVO
fhaox5O+3dRGcX0b9e5BY/U19Lp+Wu+OY89YFqhuKbR40PmoIbglhYC7szfn
WyqBAmWPgvrpTevr7KUEbq/it8vQSXboiw7d4dR6RCsI7OQHeBwegb41Ffxl
6KmwL7ESHY1+FBSiJWKbcAy13mwMUIUKwWgQ1d9rkV4VEticaVdQO4TeKmr7
tGXkIVq8VfRbKSLwIrI6RYVGj6psVKPX1GUUExh+7+t3ryWwfP9cwfNM3OUW
Fi3qHyih6mdVQ50SAjZ/RGFHuzi1TROoQc6+wM0iMBSo2CZDO3Sp0LqeQFKr
Pja8kcCBQ/82+dF9Hkl2ANXWh58N5OAvZfO9r9BLe9SPimUE6j7zQz9Q9QeT
KYK2bagIzqANpey5GDqSsGaYcwn48h6XbZcTKJyKvRtEua5bVls+AV0onWNH
y119RQ70P5sOO8A=
  "]],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBXAbshYrso0NXZlspeWcw8pgEK49LdIyW2iOPqBCnWQEFtFy
stIi02KYzJajsI3VhVGyDclquwgzclFzq6w0nSu1Nv9vORmWxAJ7Xi8Ov4tz
ceCIK2pLdUuSkpL2Yqy5px2lIwxk2jv1R9CfPao/k6MM5PFm4vFxBopK3KdU
EwzcOzd/mRq27nJSF+rE/kWn08or0VD/kyi12FZ2X4eadRW51eivgURKO/qW
fUFA5QlYEmpDu3u0+zsDSnVOjHr762FfL3ri+tmXDREGUh+bUi6hkp6/66hV
sjNAPb7g303Vp9c0U+8ctJRfRa8Zp4yeOPaMfZ7qyYRGLzoXNY1tSSbgabNl
f2MTyFd1yqmf3jS9zlpK4NYqfosUnWCFvtSjO3oMXtEKAjv5QR6HR6BrjYa/
DD0Z9idWosPRjwIFWpjuFI6gjhv6IFUoFwyPoca7jZlXhAQ2Z7jk1FbhQBm1
Zco+9ABVbhX9VokIvIisTlaj0aNqJ9Uy0GG2pBMYfO/v9qwlsHz/bP6zDNzl
KgoWDfQVUo0zal+bmIAzEJG7UDOnsm4cNclY57kSAr6gZpsUba1nQ9N6AgsG
7bHBjQQOHPq3KYDu84qzgqihJvy0Lxt/KZ6zvUIv7tE+VEoJVH3mh36g2g8d
HRG0eYNmbBqtLWLNxtChhCPNmkPAn/uoeLuMgGIy9q4f5fbedDjzCNSHUjku
tPp5V4Eb/Q+cHTvj
  "]],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmzUMhhMKXJQWiIwK9vcGsQTLS0zmibrY6vmR8vWZq1F
wiitZVpj5jSC1UxHXdTKAWNRwZXZAlcolZUmSKkF/t8SxyzXbLPn9eLsd3Eu
znbElXVlNUtSUlL2YmzyM/ayEQayuzv1R9CfbvWfiVEG8rnTyeQYA8WlrtPq
cQbun5+7Qo3adjmoC/Xi4KJTmRVVaKTvWZxa0lX+oAZtr6mUn0B/+efTO9C3
7It8KpfPklAbOlyjPd8ZUGnyEtQ7Xw8HPOjJG+deNcQYyHhqTr+MStx/11Gr
ZWeBenwhuJuqF9U2U+8etFRcQ6+bJk3eJPZM9xzVmw2NPnQ2bg5vSSXgbevK
/cYmUKDuVFA/vWnqz1lK4PYqXosUHWdFvhjRHW6DT7iCwE5eiJvGJfBwjZa3
DD0VDc6vRIfjH/mFaJHIIRhB7Tf1IapAwR8Oo6Z7jdlXBQQ2ZzkV1FaBv5za
Mtk99AhVbRX+VgsJvIytTtWg8aMaB9Xit7ZbRAQG3gd7vGsJLN8/U/AiC3c5
hcpFB3uLqKZpTaBNTMAxGFM40fa0qvox1CxjXeBICARC2m1StNXIhqb1BBYM
umMDGwkcOPRv0yC6zyfOCaGG2ujz3lz8pWS26zV6aY/usUpKoPozL/ID1X2w
WmNo8wZteAqtK2bNJNCheXumLY9AUP6kZLuMQOFE4l0fyvHcsjvyCRgjGWlO
1KPsV7rQ/5vVO9I=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzUMhhMLXJQWKIwK9vcmsQTLS0rmibrY6um0rLVrLVI
GaW1TGvMHEa6msqoi1o5YCwrvDJb0AqhssIELbXA/1vimOUabfS8Xpz9Ls7F
2Y64srZMt4jFYu3GdMrP2MpGGJBau/SH0Z8u1Z/JUQbyeTPx+BgDJXucp1QT
DNw7P3+FOt65w05N1ol9C05nVFSh4cGnUWppT/l9HWrWVcqPo788ibR29C3n
ooDKE7Al1IZ252jvdwaU6twY9c7XQ94+9MSNcy8bIgykPzGlXUYlrr9rqNV5
Z4F6LOnbSdWLapqpdw9YKq6h141TRncce8Y6T3VLobEfnYuaQptSCLjbenK+
cQgUqLoU1E9vml5nLyZwewW/RYZOsMNfDOg2V31/5jIC2/kBXiqPwINVGv4S
9OS4L7EcDUY/CgrRYpFdOILabuoDVKFCEAyhxu5G6VUhgY1ZDgW1Vegpp7ZM
WYcfosrNmb9VmQReRFamqNHoEbWdavF0mC0iAkPvfb3u1QSW7psteJ6Fu9zC
ogX9A8VU44za2yYmYPdHFA7UnFpVN4aa8tgXuBIC3oBmiwxtNXCgaS2BZL32
6NB6AvsP/tvgR/f2i7MDaH3N+LOBHPyldK7nFXppl/aRUkag+jM//APVfujo
iKDN6zShabS2hD0bQ4cTtozOXAI++ePSrXkECidj7wZRbt8tmz2fgCGcnupA
7aeDRU70P51HPAo=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "191", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 191, " ."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBizmzUMhhMSXJQWCIwK9vcWsQTLS0qmibrY6um0rK1WWuR
MkprmdaYOYxwNcNRF7VyyFhWcGW2oBVCZaUJUmqB/7fEMcs12+x5vTj7XZyL
sx1xZW2ZYRGLxdqN6VCcdpYNMyDt6jQeRn961H/GRxgo5E6lUqMMlO5xn1KP
MXDv3Oxlaqxjh4s6XycOLjiZXVGFRvufJqhaR/l9A2o1VCqOo7/8c5nt6Nv0
C3wql8+WUBva3SPd3xlQaQqS1NtfDwV60RPXz75siDOQ9cSSeQmVeP6uplbL
zwD12HxwJ9Uoqmmm3jlgq7iKXjNPmL0p7JmuWapXCo0+dCZhiWxMI+Btc+R/
SydQpO5UUj+9aXqdt5jArRW8Fhk6xo5+MaHbPPU+4TIC23lhbgaXwIMcHW8J
ejIWnFuODiU+8ovREpFLMIw6bxjDVIGSPxRBzXcbpVcEBDbk9iiprQJ/ObVl
omvwIaraJPytFhJ4EV+ZpkETRzQuqs1vt9pEBAbeB7u9qwgs3Tdd9DwXdznF
WxYM9ZVQzVOaQJuYgCsUV/ag1oyqulHUImef50gIBMK6zTK01ZQOTWsIzNfr
jw6sI7D/4L/1IXSvT5wXRutrYs/68vEX7YzjFXpxl/6RSkag+jMv+gPVf7Db
42jzWl1kEq0tZU8n0cE5Z3ZHAYGg4rF2q5xA8XjyXT/K6b3pdBUSMEWzMnpQ
W45V5Ub/A5ihO1o=
  "]],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzWMhhMKXJQWiIyK9vYWsQTLS0rmybrY6vmR8vWZq1F
wijtw7TGzGmEqxmMuqiVA8YygyuzBa0QKitNkFIL/L8mjlmu0WbP68XZ7+Jc
nO2IK+vKahaxWKw9mM78M7ayYQayrV3aI+iUS/VnfISBAu50IjHKQPFe52nV
GAMPzs9doUY6d9qp8/Vi/4KTmRVVaLj/eYxaYil/WIO211Tmn0B/eZPpHeg7
zkU+lctnS6gNHc6R7h8MKNV5cerdb4d9PejJm+deNUQZyHhmTL+MSlx/11Cr
ZWeBenzev4uqFdU2U+8dNFVcR28YJgzuBPaMdY7qzoZGDzobM4Y2pRBwt1ly
v3MIFKq65NTPb5ve5CwmcGcFr0WKjrHDX/XodpfOI1xGYAcvyE3lEni0qpS3
BD0V8SeXo0OxT3wFWiSyC4ZR2y1tkCqQ84dCqOF+Y/Y1AYGNWQ45tVXgLae2
TFgHH6PKzcLfKiGBl9GVKWo0dlRtp5q85naTiMDAB3+3ezWBpftnCl9k4W6a
YuuCgb4iqmFa7WsTE7AHonIH2p5aVT+KGmXsC2kSAr5g6RYp2qrnQNNaAvM6
zbGB9QQOHPq3IYDu84hzgqiuNtLbl4u/lMxaXqOXdmueKKUEqr/wwj9RzUez
OYo2rysNTaJ1xeyZODqYtGV25hHw5z8t2SYjoBiPv+9H03pu2+wFBPThjFQH
OnW1V+lE/wOfDjw+
  "]],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmjUMhhMLXJQWH4xK9vcWsQTLS0yGibrY6um0rK1WWuZ
MEprmdaYOYxkNZNRF7V0wFhWeGW6oBVKZaUJUmqB/7fEMcs12uh5vTj7XZyL
sx1xZa1GtyQlJWUfxlpw1q4ZY0Bq66w7iv50K/5MjTNQyJuNxycYKC1znVFM
MvDgwsJVati620FN1ov9i85kVFShoYFnUaqqq/yhDjXrKgtOor+8ibR29C37
koDKE7Ak1IZ213jPdwbkyrwY9e7XI75e9NTN84MNEQbSn5rSrqAS99911Or8
c0A9kfTvodaJapqp9w5ZKq6jN4zTRk8ce8a2QPVIobEPnY+agltSCXjaunK+
sQkUKTpl1E9vml5nLyVwZxW/JRedZIW+GNCdbn1f5goCu/gBHodH4NEaNX8Z
ejrsT6xER6MfBcVoicghHEPtt+oCVKFMMBpEjfcbpdeEBDZnOWXUVqG3nNoy
bRt5jMq3Zv5WZBJ4GVmdqkSjx5QOqsXbYbaICAy99/d41hJYfmCu6EUW7nKL
ty863F9CNc4qfW1iAo7hiMyJmjlV9ROoKZ91kSsh4Auot+WirQY2NK0nkNRr
jw9tJHDw8L9Nw+j+PnF2ANXXhJ/35+AvqvmuV+jlvdon8lwC1Z/5oR+o9kNH
RwRt3qAOzqC1pay5GDqSsGdY8wj4C7pVO/IJFE/F3g2g3N7bdkchAUMoneNE
uzWDchf6H5v/O9k=
  "]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{927, 1028},
WindowMargins->{{-6, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 218, 4, 32, "Input"],
Cell[778, 26, 452, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[1255, 39, 169, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[1449, 46, 2060, 29, 23, "Print"],
Cell[3512, 77, 2329, 36, 23, "Print"],
Cell[5844, 115, 2110, 30, 23, "Print"],
Cell[7957, 147, 2044, 29, 23, "Print"],
Cell[10004, 178, 2057, 29, 23, "Print"],
Cell[12064, 209, 2107, 30, 23, "Print"],
Cell[14174, 241, 2107, 30, 23, "Print"],
Cell[16284, 273, 2046, 29, 23, "Print"],
Cell[18333, 304, 2074, 29, 23, "Print"],
Cell[20410, 335, 2043, 29, 23, "Print"],
Cell[22456, 366, 2111, 30, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[24594, 400, 1526, 23, 32, "Input"],
Cell[26123, 425, 92, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[26240, 430, 745, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[27010, 446, 2909, 41, 23, "Print"],
Cell[29922, 489, 2926, 41, 23, "Print"],
Cell[32851, 532, 2929, 41, 23, "Print"],
Cell[35783, 575, 3033, 45, 23, "Print"],
Cell[38819, 622, 2898, 41, 23, "Print"],
Cell[41720, 665, 2924, 41, 23, "Print"],
Cell[44647, 708, 2923, 41, 23, "Print"],
Cell[47573, 751, 2922, 41, 23, "Print"],
Cell[50498, 794, 2931, 41, 23, "Print"],
Cell[53432, 837, 2937, 42, 23, "Print"],
Cell[56372, 881, 2887, 41, 23, "Print"],
Cell[59262, 924, 2917, 41, 23, "Print"],
Cell[62182, 967, 2920, 41, 23, "Print"],
Cell[65105, 1010, 2920, 41, 23, "Print"],
Cell[68028, 1053, 3099, 46, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71176, 1105, 790, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[71991, 1121, 697, 13, 23, "Print"],
Cell[72691, 1136, 707, 13, 23, "Print"],
Cell[73401, 1151, 236, 3, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73686, 1160, 281, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[73992, 1170, 1644, 27, 23, "Print"],
Cell[75639, 1199, 1645, 27, 23, "Print"],
Cell[77287, 1228, 1171, 17, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78507, 1251, 491, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[79023, 1263, 883, 12, 23, "Print"],
Cell[79909, 1277, 879, 12, 23, "Print"],
Cell[80791, 1291, 1074, 19, 23, "Print"],
Cell[81868, 1312, 829, 11, 23, "Print"],
Cell[82700, 1325, 1010, 16, 23, "Print"],
Cell[83713, 1343, 862, 12, 23, "Print"],
Cell[84578, 1357, 820, 11, 23, "Print"],
Cell[85401, 1370, 942, 15, 23, "Print"],
Cell[86346, 1387, 830, 11, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87225, 1404, 513, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[87763, 1417, 1683, 28, 23, "Print"],
Cell[89449, 1447, 1438, 20, 23, "Print"],
Cell[90890, 1469, 1618, 25, 23, "Print"],
Cell[92511, 1496, 1471, 21, 23, "Print"],
Cell[93985, 1519, 1954, 32, 23, "Print"],
Cell[95942, 1553, 1553, 24, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[97522, 1581, 660, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[98207, 1599, 533, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[98765, 1615, 797, 11, 23, "Print"],
Cell[99565, 1628, 992, 16, 23, "Print"],
Cell[100560, 1646, 767, 10, 23, "Print"],
Cell[101330, 1658, 782, 10, 23, "Print"],
Cell[102115, 1670, 769, 10, 23, "Print"],
Cell[102887, 1682, 765, 10, 23, "Print"],
Cell[103655, 1694, 786, 10, 23, "Print"],
Cell[104444, 1706, 777, 10, 23, "Print"],
Cell[105224, 1718, 769, 10, 23, "Print"],
Cell[105996, 1730, 759, 10, 23, "Print"],
Cell[106758, 1742, 758, 10, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[107543, 1756, 192, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[107760, 1766, 1358, 20, 32, "Input"],
Cell[CellGroupData[{
Cell[109143, 1790, 544, 9, 23, "Print"],
Cell[109690, 1801, 531, 9, 23, "Print"],
Cell[110224, 1812, 533, 9, 23, "Print"],
Cell[110760, 1823, 678, 14, 23, "Print"],
Cell[111441, 1839, 780, 17, 23, "Print"],
Cell[112224, 1858, 527, 9, 23, "Print"],
Cell[112754, 1869, 709, 14, 23, "Print"],
Cell[113466, 1885, 560, 10, 23, "Print"],
Cell[114029, 1897, 808, 18, 23, "Print"],
Cell[114840, 1917, 644, 13, 23, "Print"],
Cell[115487, 1932, 586, 10, 23, "Print"],
Cell[116076, 1944, 566, 10, 23, "Print"],
Cell[116645, 1956, 568, 10, 23, "Print"],
Cell[117216, 1968, 678, 14, 23, "Print"],
Cell[117897, 1984, 780, 17, 23, "Print"],
Cell[118680, 2003, 527, 9, 23, "Print"],
Cell[119210, 2014, 709, 14, 23, "Print"],
Cell[119922, 2030, 560, 10, 23, "Print"],
Cell[120485, 2042, 1045, 21, 23, "Print"],
Cell[121533, 2065, 644, 13, 23, "Print"],
Cell[122180, 2080, 727, 15, 23, "Print"],
Cell[122910, 2097, 755, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[123692, 2116, 52, 1, 32, "Input"],
Cell[123747, 2119, 117, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[123889, 2126, 58, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[123972, 2131, 1009, 15, 23, "Print"],
Cell[124984, 2148, 1021, 15, 23, "Print"],
Cell[126008, 2165, 1056, 15, 23, "Print"],
Cell[127067, 2182, 1030, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[128124, 2201, 293, 7, 32, "Input"],
Cell[CellGroupData[{
Cell[128442, 2212, 55, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[128522, 2217, 931, 13, 23, "Print"],
Cell[129456, 2232, 932, 13, 23, "Print"],
Cell[130391, 2247, 940, 13, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[131358, 2264, 1001, 17, 32, "Input"],
Cell[CellGroupData[{
Cell[132384, 2285, 1459, 35, 99, "Input"],
Cell[CellGroupData[{
Cell[133868, 2324, 464, 11, 23, "Print"],
Cell[134335, 2337, 224, 4, 23, "Print"],
Cell[134562, 2343, 670, 16, 43, "Print"],
Cell[135235, 2361, 247, 4, 23, "Print"],
Cell[135485, 2367, 504, 11, 23, "Print"],
Cell[135992, 2380, 222, 4, 23, "Print"],
Cell[136217, 2386, 670, 16, 43, "Print"],
Cell[136890, 2404, 536, 11, 23, "Print"],
Cell[137429, 2417, 244, 4, 23, "Print"],
Cell[137676, 2423, 393, 9, 23, "Print"],
Cell[138072, 2434, 421, 9, 23, "Print"],
Cell[138496, 2445, 504, 11, 23, "Print"],
Cell[139003, 2458, 222, 4, 23, "Print"],
Cell[139228, 2464, 455, 10, 23, "Print"],
Cell[139686, 2476, 488, 10, 23, "Print"],
Cell[140177, 2488, 420, 9, 23, "Print"],
Cell[140600, 2499, 224, 4, 23, "Print"],
Cell[140827, 2505, 478, 11, 23, "Print"],
Cell[141308, 2518, 418, 9, 23, "Print"],
Cell[141729, 2529, 265, 4, 23, "Print"],
Cell[141997, 2535, 294, 5, 23, "Print"],
Cell[142294, 2542, 222, 4, 23, "Print"],
Cell[142519, 2548, 457, 10, 23, "Print"],
Cell[142979, 2560, 486, 10, 23, "Print"],
Cell[143468, 2572, 418, 9, 23, "Print"],
Cell[143889, 2583, 221, 4, 23, "Print"],
Cell[144113, 2589, 478, 11, 23, "Print"],
Cell[144594, 2602, 418, 9, 23, "Print"],
Cell[145015, 2613, 271, 5, 23, "Print"],
Cell[145289, 2620, 257, 4, 23, "Print"],
Cell[145549, 2626, 278, 5, 23, "Print"],
Cell[145830, 2633, 258, 4, 23, "Print"],
Cell[146091, 2639, 467, 11, 23, "Print"],
Cell[146561, 2652, 224, 4, 23, "Print"],
Cell[146788, 2658, 457, 10, 23, "Print"],
Cell[147248, 2670, 485, 10, 23, "Print"],
Cell[147736, 2682, 490, 10, 23, "Print"],
Cell[148229, 2694, 424, 9, 23, "Print"],
Cell[148656, 2705, 222, 4, 23, "Print"],
Cell[148881, 2711, 478, 11, 23, "Print"],
Cell[149362, 2724, 488, 10, 23, "Print"],
Cell[149853, 2736, 420, 9, 23, "Print"],
Cell[150276, 2747, 262, 4, 23, "Print"],
Cell[150541, 2753, 296, 5, 23, "Print"],
Cell[150840, 2760, 222, 4, 23, "Print"],
Cell[151065, 2766, 455, 10, 23, "Print"],
Cell[151523, 2778, 488, 10, 23, "Print"],
Cell[152014, 2790, 420, 9, 23, "Print"],
Cell[152437, 2801, 222, 4, 23, "Print"],
Cell[152662, 2807, 477, 11, 23, "Print"],
Cell[153142, 2820, 488, 10, 23, "Print"],
Cell[153633, 2832, 420, 9, 23, "Print"],
Cell[154056, 2843, 271, 5, 23, "Print"],
Cell[154330, 2850, 257, 4, 23, "Print"],
Cell[154590, 2856, 277, 5, 23, "Print"],
Cell[154870, 2863, 260, 4, 23, "Print"],
Cell[155133, 2869, 467, 11, 23, "Print"],
Cell[155603, 2882, 224, 4, 23, "Print"],
Cell[155830, 2888, 457, 10, 23, "Print"],
Cell[156290, 2900, 487, 10, 23, "Print"],
Cell[156780, 2912, 487, 10, 23, "Print"],
Cell[157270, 2924, 422, 9, 23, "Print"],
Cell[157695, 2935, 222, 4, 23, "Print"],
Cell[157920, 2941, 478, 11, 23, "Print"],
Cell[158401, 2954, 418, 9, 23, "Print"],
Cell[158822, 2965, 263, 4, 23, "Print"],
Cell[159088, 2971, 294, 5, 23, "Print"],
Cell[159385, 2978, 222, 4, 23, "Print"],
Cell[159610, 2984, 455, 10, 23, "Print"],
Cell[160068, 2996, 486, 10, 23, "Print"],
Cell[160557, 3008, 420, 9, 23, "Print"],
Cell[160980, 3019, 222, 4, 23, "Print"],
Cell[161205, 3025, 478, 11, 23, "Print"],
Cell[161686, 3038, 418, 9, 23, "Print"],
Cell[162107, 3049, 273, 5, 23, "Print"],
Cell[162383, 3056, 257, 4, 23, "Print"],
Cell[162643, 3062, 278, 5, 23, "Print"],
Cell[162924, 3069, 263, 4, 23, "Print"],
Cell[163190, 3075, 467, 11, 23, "Print"],
Cell[163660, 3088, 224, 4, 23, "Print"],
Cell[163887, 3094, 457, 10, 23, "Print"],
Cell[164347, 3106, 488, 10, 23, "Print"],
Cell[164838, 3118, 489, 10, 23, "Print"],
Cell[165330, 3130, 421, 9, 23, "Print"],
Cell[165754, 3141, 224, 4, 23, "Print"],
Cell[165981, 3147, 480, 11, 23, "Print"],
Cell[166464, 3160, 486, 10, 23, "Print"],
Cell[166953, 3172, 488, 10, 23, "Print"],
Cell[167444, 3184, 420, 9, 23, "Print"],
Cell[167867, 3195, 263, 4, 23, "Print"],
Cell[168133, 3201, 289, 4, 23, "Print"],
Cell[168425, 3207, 215, 3, 23, "Print"],
Cell[168643, 3212, 450, 9, 23, "Print"],
Cell[169096, 3223, 479, 9, 23, "Print"],
Cell[169578, 3234, 411, 8, 23, "Print"],
Cell[169992, 3244, 217, 3, 23, "Print"],
Cell[170212, 3249, 471, 10, 23, "Print"],
Cell[170686, 3261, 479, 9, 23, "Print"],
Cell[171168, 3272, 413, 8, 23, "Print"],
Cell[171584, 3282, 264, 4, 23, "Print"],
Cell[171851, 3288, 250, 3, 23, "Print"],
Cell[172104, 3293, 273, 4, 23, "Print"],
Cell[172380, 3299, 254, 3, 23, "Print"],
Cell[172637, 3304, 463, 10, 23, "Print"],
Cell[173103, 3316, 217, 3, 23, "Print"],
Cell[173323, 3321, 450, 9, 23, "Print"],
Cell[173776, 3332, 483, 9, 23, "Print"],
Cell[174262, 3343, 479, 9, 23, "Print"],
Cell[174744, 3354, 479, 9, 23, "Print"],
Cell[175226, 3365, 479, 9, 23, "Print"],
Cell[175708, 3376, 415, 8, 23, "Print"],
Cell[176126, 3386, 215, 3, 23, "Print"],
Cell[176344, 3391, 471, 10, 23, "Print"],
Cell[176818, 3403, 481, 9, 23, "Print"],
Cell[177302, 3414, 413, 8, 23, "Print"],
Cell[177718, 3424, 256, 3, 23, "Print"],
Cell[177977, 3429, 287, 4, 23, "Print"],
Cell[178267, 3435, 215, 3, 23, "Print"],
Cell[178485, 3440, 448, 9, 23, "Print"],
Cell[178936, 3451, 483, 9, 23, "Print"],
Cell[179422, 3462, 412, 8, 23, "Print"],
Cell[179837, 3472, 217, 3, 23, "Print"],
Cell[180057, 3477, 471, 10, 23, "Print"],
Cell[180531, 3489, 481, 9, 23, "Print"],
Cell[181015, 3500, 413, 8, 23, "Print"],
Cell[181431, 3510, 267, 4, 23, "Print"],
Cell[181701, 3516, 251, 3, 23, "Print"],
Cell[181955, 3521, 272, 4, 23, "Print"],
Cell[182230, 3527, 260, 3, 23, "Print"],
Cell[182493, 3532, 463, 10, 23, "Print"],
Cell[182959, 3544, 215, 3, 23, "Print"],
Cell[183177, 3549, 448, 9, 23, "Print"],
Cell[183628, 3560, 482, 9, 23, "Print"],
Cell[184113, 3571, 479, 9, 23, "Print"],
Cell[184595, 3582, 479, 9, 23, "Print"],
Cell[185077, 3593, 478, 9, 23, "Print"],
Cell[185558, 3604, 415, 8, 23, "Print"],
Cell[185976, 3614, 215, 3, 23, "Print"],
Cell[186194, 3619, 469, 10, 23, "Print"],
Cell[186666, 3631, 485, 9, 23, "Print"],
Cell[187154, 3642, 417, 8, 23, "Print"],
Cell[187574, 3652, 257, 3, 23, "Print"],
Cell[187834, 3657, 290, 4, 23, "Print"],
Cell[188127, 3663, 214, 3, 23, "Print"],
Cell[188344, 3668, 448, 9, 23, "Print"],
Cell[188795, 3679, 481, 9, 23, "Print"],
Cell[189279, 3690, 413, 8, 23, "Print"],
Cell[189695, 3700, 215, 3, 23, "Print"],
Cell[189913, 3705, 471, 10, 23, "Print"],
Cell[190387, 3717, 481, 9, 23, "Print"],
Cell[190871, 3728, 413, 8, 23, "Print"],
Cell[191287, 3738, 265, 4, 23, "Print"],
Cell[191555, 3744, 251, 3, 23, "Print"],
Cell[191809, 3749, 274, 4, 23, "Print"],
Cell[192086, 3755, 258, 3, 23, "Print"],
Cell[192347, 3760, 463, 10, 23, "Print"],
Cell[192813, 3772, 215, 3, 23, "Print"],
Cell[193031, 3777, 448, 9, 23, "Print"],
Cell[193482, 3788, 485, 9, 23, "Print"],
Cell[193970, 3799, 479, 9, 23, "Print"],
Cell[194452, 3810, 483, 9, 23, "Print"],
Cell[194938, 3821, 481, 9, 23, "Print"],
Cell[195422, 3832, 419, 8, 23, "Print"],
Cell[195844, 3842, 215, 3, 23, "Print"],
Cell[196062, 3847, 471, 10, 23, "Print"],
Cell[196536, 3859, 485, 9, 23, "Print"],
Cell[197024, 3870, 479, 9, 23, "Print"],
Cell[197506, 3881, 479, 9, 23, "Print"],
Cell[197988, 3892, 479, 9, 23, "Print"],
Cell[198470, 3903, 417, 8, 23, "Print"],
Cell[198890, 3913, 257, 3, 23, "Print"],
Cell[199150, 3918, 289, 4, 23, "Print"],
Cell[199442, 3924, 215, 3, 23, "Print"],
Cell[199660, 3929, 448, 9, 23, "Print"],
Cell[200111, 3940, 479, 9, 23, "Print"],
Cell[200593, 3951, 413, 8, 23, "Print"],
Cell[201009, 3961, 217, 3, 23, "Print"],
Cell[201229, 3966, 471, 10, 23, "Print"],
Cell[201703, 3978, 479, 9, 23, "Print"],
Cell[202185, 3989, 413, 8, 23, "Print"],
Cell[202601, 3999, 268, 4, 23, "Print"],
Cell[202872, 4005, 252, 3, 23, "Print"],
Cell[203127, 4010, 273, 4, 23, "Print"],
Cell[203403, 4016, 259, 3, 23, "Print"],
Cell[203665, 4021, 463, 10, 23, "Print"],
Cell[204131, 4033, 215, 3, 23, "Print"],
Cell[204349, 4038, 450, 9, 23, "Print"],
Cell[204802, 4049, 487, 9, 23, "Print"],
Cell[205292, 4060, 480, 9, 23, "Print"],
Cell[205775, 4071, 481, 9, 23, "Print"],
Cell[206259, 4082, 483, 9, 23, "Print"],
Cell[206745, 4093, 416, 8, 23, "Print"],
Cell[207164, 4103, 217, 3, 23, "Print"],
Cell[207384, 4108, 471, 10, 23, "Print"],
Cell[207858, 4120, 481, 9, 23, "Print"],
Cell[208342, 4131, 412, 8, 23, "Print"],
Cell[208757, 4141, 258, 3, 23, "Print"],
Cell[209018, 4146, 289, 4, 23, "Print"],
Cell[209310, 4152, 214, 3, 23, "Print"],
Cell[209527, 4157, 450, 9, 23, "Print"],
Cell[209980, 4168, 479, 9, 23, "Print"],
Cell[210462, 4179, 410, 8, 23, "Print"],
Cell[210875, 4189, 215, 3, 23, "Print"],
Cell[211093, 4194, 473, 10, 23, "Print"],
Cell[211569, 4206, 413, 8, 23, "Print"],
Cell[211985, 4216, 266, 4, 23, "Print"],
Cell[212254, 4222, 252, 3, 23, "Print"],
Cell[212509, 4227, 275, 4, 23, "Print"],
Cell[212787, 4233, 261, 3, 23, "Print"],
Cell[213051, 4238, 465, 10, 23, "Print"],
Cell[213519, 4250, 217, 3, 23, "Print"],
Cell[213739, 4255, 448, 9, 23, "Print"],
Cell[214190, 4266, 485, 9, 23, "Print"],
Cell[214678, 4277, 483, 9, 23, "Print"],
Cell[215164, 4288, 485, 9, 23, "Print"],
Cell[215652, 4299, 483, 9, 23, "Print"],
Cell[216138, 4310, 417, 8, 23, "Print"],
Cell[216558, 4320, 215, 3, 23, "Print"],
Cell[216776, 4325, 471, 10, 23, "Print"],
Cell[217250, 4337, 481, 9, 23, "Print"],
Cell[217734, 4348, 413, 8, 23, "Print"],
Cell[218150, 4358, 258, 3, 23, "Print"],
Cell[218411, 4363, 289, 4, 23, "Print"],
Cell[218703, 4369, 215, 3, 23, "Print"],
Cell[218921, 4374, 448, 9, 23, "Print"],
Cell[219372, 4385, 478, 9, 23, "Print"],
Cell[219853, 4396, 411, 8, 23, "Print"],
Cell[220267, 4406, 215, 3, 23, "Print"],
Cell[220485, 4411, 471, 10, 23, "Print"],
Cell[220959, 4423, 411, 8, 23, "Print"],
Cell[221373, 4433, 266, 4, 23, "Print"],
Cell[221642, 4439, 252, 3, 23, "Print"],
Cell[221897, 4444, 273, 4, 23, "Print"],
Cell[222173, 4450, 259, 3, 23, "Print"],
Cell[222435, 4455, 463, 10, 23, "Print"],
Cell[222901, 4467, 215, 3, 23, "Print"],
Cell[223119, 4472, 448, 9, 23, "Print"],
Cell[223570, 4483, 485, 9, 23, "Print"],
Cell[224058, 4494, 485, 9, 23, "Print"],
Cell[224546, 4505, 483, 9, 23, "Print"],
Cell[225032, 4516, 483, 9, 23, "Print"],
Cell[225518, 4527, 419, 8, 23, "Print"],
Cell[225940, 4537, 215, 3, 23, "Print"],
Cell[226158, 4542, 473, 10, 23, "Print"],
Cell[226634, 4554, 411, 8, 23, "Print"],
Cell[227048, 4564, 258, 3, 23, "Print"],
Cell[227309, 4569, 289, 4, 23, "Print"],
Cell[227601, 4575, 215, 3, 23, "Print"],
Cell[227819, 4580, 448, 9, 23, "Print"],
Cell[228270, 4591, 481, 9, 23, "Print"],
Cell[228754, 4602, 411, 8, 23, "Print"],
Cell[229168, 4612, 215, 3, 23, "Print"],
Cell[229386, 4617, 471, 10, 23, "Print"],
Cell[229860, 4629, 411, 8, 23, "Print"],
Cell[230274, 4639, 265, 4, 23, "Print"],
Cell[230542, 4645, 254, 3, 23, "Print"],
Cell[230799, 4650, 273, 4, 23, "Print"],
Cell[231075, 4656, 261, 3, 23, "Print"],
Cell[231339, 4661, 466, 10, 23, "Print"],
Cell[231808, 4673, 217, 3, 23, "Print"],
Cell[232028, 4678, 475, 10, 23, "Print"],
Cell[232506, 4690, 215, 3, 23, "Print"],
Cell[232724, 4695, 448, 9, 23, "Print"],
Cell[233175, 4706, 483, 9, 23, "Print"],
Cell[233661, 4717, 483, 9, 23, "Print"],
Cell[234147, 4728, 483, 9, 23, "Print"],
Cell[234633, 4739, 483, 9, 23, "Print"],
Cell[235119, 4750, 483, 9, 23, "Print"],
Cell[235605, 4761, 483, 9, 23, "Print"],
Cell[236091, 4772, 485, 9, 23, "Print"],
Cell[236579, 4783, 485, 9, 23, "Print"],
Cell[237067, 4794, 485, 9, 23, "Print"],
Cell[237555, 4805, 485, 9, 23, "Print"],
Cell[238043, 4816, 484, 9, 23, "Print"],
Cell[238530, 4827, 483, 9, 23, "Print"],
Cell[239016, 4838, 217, 3, 23, "Print"],
Cell[239236, 4843, 410, 8, 23, "Print"],
Cell[239649, 4853, 420, 8, 23, "Print"],
Cell[240072, 4863, 214, 3, 23, "Print"],
Cell[240289, 4868, 473, 10, 23, "Print"],
Cell[240765, 4880, 479, 9, 23, "Print"],
Cell[241247, 4891, 479, 9, 23, "Print"],
Cell[241729, 4902, 479, 9, 23, "Print"],
Cell[242211, 4913, 479, 9, 23, "Print"],
Cell[242693, 4924, 479, 9, 23, "Print"],
Cell[243175, 4935, 479, 9, 23, "Print"],
Cell[243657, 4946, 485, 9, 23, "Print"],
Cell[244145, 4957, 485, 9, 23, "Print"],
Cell[244633, 4968, 485, 9, 23, "Print"],
Cell[245121, 4979, 483, 9, 23, "Print"],
Cell[245607, 4990, 481, 9, 23, "Print"],
Cell[246091, 5001, 481, 9, 23, "Print"],
Cell[246575, 5012, 421, 8, 23, "Print"],
Cell[246999, 5022, 260, 3, 23, "Print"],
Cell[247262, 5027, 290, 4, 23, "Print"],
Cell[247555, 5033, 217, 3, 23, "Print"],
Cell[247775, 5038, 448, 9, 23, "Print"],
Cell[248226, 5049, 481, 9, 23, "Print"],
Cell[248710, 5060, 410, 8, 23, "Print"],
Cell[249123, 5070, 215, 3, 23, "Print"],
Cell[249341, 5075, 473, 10, 23, "Print"],
Cell[249817, 5087, 478, 9, 23, "Print"],
Cell[250298, 5098, 413, 8, 23, "Print"],
Cell[250714, 5108, 269, 4, 23, "Print"],
Cell[250986, 5114, 253, 3, 23, "Print"],
Cell[251242, 5119, 276, 4, 23, "Print"],
Cell[251521, 5125, 265, 4, 23, "Print"],
Cell[251789, 5131, 466, 10, 23, "Print"],
Cell[252258, 5143, 215, 3, 23, "Print"],
Cell[252476, 5148, 475, 10, 23, "Print"],
Cell[252954, 5160, 214, 3, 23, "Print"],
Cell[253171, 5165, 448, 9, 23, "Print"],
Cell[253622, 5176, 483, 9, 23, "Print"],
Cell[254108, 5187, 483, 9, 23, "Print"],
Cell[254594, 5198, 483, 9, 23, "Print"],
Cell[255080, 5209, 483, 9, 23, "Print"],
Cell[255566, 5220, 483, 9, 23, "Print"],
Cell[256052, 5231, 483, 9, 23, "Print"],
Cell[256538, 5242, 487, 9, 23, "Print"],
Cell[257028, 5253, 485, 9, 23, "Print"],
Cell[257516, 5264, 487, 9, 23, "Print"],
Cell[258006, 5275, 485, 9, 23, "Print"],
Cell[258494, 5286, 485, 9, 23, "Print"],
Cell[258982, 5297, 485, 9, 23, "Print"],
Cell[259470, 5308, 215, 3, 23, "Print"],
Cell[259688, 5313, 410, 8, 23, "Print"],
Cell[260101, 5323, 419, 8, 23, "Print"],
Cell[260523, 5333, 215, 3, 23, "Print"],
Cell[260741, 5338, 471, 10, 23, "Print"],
Cell[261215, 5350, 483, 9, 23, "Print"],
Cell[261701, 5361, 485, 9, 23, "Print"],
Cell[262189, 5372, 483, 9, 23, "Print"],
Cell[262675, 5383, 415, 8, 23, "Print"],
Cell[263093, 5393, 259, 3, 23, "Print"],
Cell[263355, 5398, 290, 4, 23, "Print"],
Cell[263648, 5404, 215, 3, 23, "Print"],
Cell[263866, 5409, 448, 9, 23, "Print"],
Cell[264317, 5420, 479, 9, 23, "Print"],
Cell[264799, 5431, 411, 8, 23, "Print"],
Cell[265213, 5441, 214, 3, 23, "Print"],
Cell[265430, 5446, 471, 10, 23, "Print"],
Cell[265904, 5458, 411, 8, 23, "Print"],
Cell[266318, 5468, 267, 4, 23, "Print"],
Cell[266588, 5474, 255, 3, 23, "Print"],
Cell[266846, 5479, 274, 4, 23, "Print"],
Cell[267123, 5485, 265, 4, 23, "Print"],
Cell[267391, 5491, 254, 3, 23, "Print"],
Cell[267648, 5496, 239, 3, 23, "Print"],
Cell[267890, 5501, 330, 5, 43, "Print"],
Cell[268223, 5508, 219, 3, 23, "Print"]
}, Open  ]],
Cell[268457, 5514, 323, 7, 32, "Output"]
}, Open  ]],
Cell[268795, 5524, 120, 2, 32, "Input"],
Cell[268918, 5528, 360, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[269303, 5541, 54, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[269382, 5546, 1106, 16, 23, "Print"],
Cell[270491, 5564, 1378, 23, 23, "Print"],
Cell[271872, 5589, 1159, 17, 23, "Print"],
Cell[273034, 5608, 1095, 16, 23, "Print"],
Cell[274132, 5626, 1106, 16, 23, "Print"],
Cell[275241, 5644, 1158, 17, 23, "Print"],
Cell[276402, 5663, 1156, 17, 23, "Print"],
Cell[277561, 5682, 1093, 16, 23, "Print"],
Cell[278657, 5700, 1123, 16, 23, "Print"],
Cell[279783, 5718, 1092, 16, 23, "Print"],
Cell[280878, 5736, 1162, 17, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[282067, 5757, 856, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[282948, 5775, 802, 13, 32, "Input"],
Cell[CellGroupData[{
Cell[283775, 5792, 441, 6, 23, "Print"],
Cell[284219, 5800, 459, 6, 23, "Print"],
Cell[284681, 5808, 459, 6, 23, "Print"],
Cell[285143, 5816, 565, 10, 23, "Print"],
Cell[285711, 5828, 430, 6, 23, "Print"],
Cell[286144, 5836, 456, 6, 23, "Print"],
Cell[286603, 5844, 453, 6, 23, "Print"],
Cell[287059, 5852, 452, 6, 23, "Print"],
Cell[287514, 5860, 460, 6, 23, "Print"],
Cell[287977, 5868, 467, 7, 23, "Print"],
Cell[288447, 5877, 417, 6, 23, "Print"],
Cell[288867, 5885, 447, 6, 23, "Print"],
Cell[289317, 5893, 452, 6, 23, "Print"],
Cell[289772, 5901, 448, 6, 23, "Print"],
Cell[290223, 5909, 629, 11, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[290901, 5926, 544, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[291470, 5939, 1517, 25, 23, "Print"],
Cell[292990, 5966, 1527, 25, 23, "Print"],
Cell[294520, 5993, 1054, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[295601, 6012, 962, 13, 32, "Input"],
Cell[CellGroupData[{
Cell[296588, 6029, 1622, 25, 55, "Input"],
Cell[CellGroupData[{
Cell[298235, 6058, 875, 16, 23, "Print"],
Cell[299113, 6076, 1098, 23, 23, "Print"],
Cell[300214, 6101, 853, 15, 23, "Print"],
Cell[301070, 6118, 1035, 20, 23, "Print"],
Cell[302108, 6140, 886, 16, 23, "Print"],
Cell[302997, 6158, 1371, 27, 23, "Print"],
Cell[304371, 6187, 970, 19, 23, "Print"],
Cell[305344, 6208, 1324, 26, 23, "Print"],
Cell[306671, 6236, 867, 15, 23, "Print"],
Cell[307541, 6253, 1134, 24, 23, "Print"],
Cell[308678, 6279, 1088, 23, 23, "Print"],
Cell[309769, 6304, 1176, 23, 23, "Print"],
Cell[310948, 6329, 1164, 23, 23, "Print"],
Cell[312115, 6354, 850, 15, 23, "Print"],
Cell[312968, 6371, 874, 16, 23, "Print"],
Cell[313845, 6389, 1065, 20, 23, "Print"],
Cell[314913, 6411, 1224, 23, 23, "Print"],
Cell[316140, 6436, 846, 15, 23, "Print"],
Cell[316989, 6453, 831, 15, 23, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
