(* **************************************************************************** *)
(* *****                                                        	  ***** *)
(* *****  FeynRules model file: Simplified DM models                      ***** *)
(* *****                        with an s-channel spin-2 mediator         ***** *)
(* *****  Author: G. Das, C. Degrande, V. Hirschi, F. Maltoni and H. Shao ***** *)
(* *****          K. Mawatari                                             ***** *)
(* *****          		                                          ***** *)
(* **************************************************************************** *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "DMsimp_s_spin2";

M$Information = {
 Authors      -> {"G. Das, C. Degrande, V. Hirschi, F. Maltoni, H. Shao, K. Mawatari"}, 
 Institutions -> {"Saha Institute of Nuclear Physics, Durham University, Universite catholique de Louvain, CERN, LPSC Grenoble"},
 Emails       -> {"celine.degrande@durham.ac.uk","goutam.das@saha.ac.in", "kentarou.mawatari@lpsc.in2p3.fr"},
 URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/DMsimp/",  
 References   -> {"G. Das et al., arXiv:1605.09359","S. Kraml et al., arXiv:1701.07008"},
 Version      -> "1.1",
 Date         -> "01.02.2017"
};

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 01.06.2016 v1.0 - release version. *)
(* 01.02.2017 v1.1 - added Xc and Xv. *)


(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderLimit = {
 {DMT, 2}
};

M$InteractionOrderHierarchy = {
 {QCD, 1}, {DMT, 2}, {QED, 2}
};


(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {

S[7] == { ClassName -> Xr,
     	  SelfConjugate -> True,
	  Mass -> {MXr, 10.},
	  Width -> 0,
	  PDG -> 5000511,
	  Tex -> Subscript[X,r],
	  FullName -> "Real scalar DM" },

F[7] == { ClassName -> Xd,
          SelfConjugate -> False,
	  Mass -> {MXd, 10.},
          Width -> 0,
          PDG -> 5000521,
          TeX -> Subscript[X,d],
          FullName -> "Dirac DM" },

V[7] == { ClassName -> Xv,
     	  SelfConjugate -> True,
	  Mass -> {MXv, 10.},
	  Width -> 0,
	  PDG -> 5000531,
	  Tex -> Subscript[X,v],
	  FullNme -> "Vector DM" },

T[1] == { ClassName -> Y2,
	  SelfConjugate -> True,
	  Symmetric -> True,
	  Mass -> {MY2, 1000.},
          Width -> {WY2, 10.},
          PDG -> 5000002,
          TeX -> Subscript[Y,2],
          FullName -> "Spin-2 mediator" }

};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)  
M$Parameters = {

 Lambda == { ParameterType -> External,
             BlockName -> DMINPUTS,
	     TeX -> \[CapitalLambda],
	     Description -> "cut-off scale",
	     Value -> 1000.0},

 gTg == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,g],
      Description -> "g-Y2  coupling",
      Value -> 1. }, 

 gTw == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,W],
      Description -> "W-Y2  coupling",
      Value -> 1. }, 

 gTb == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,B],
      Description -> "B-Y2  coupling",
      Value -> 1. }, 

 gTq == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,q],
      Description -> "q-Y2  coupling",
      Value -> 1. }, 

 gTq3 == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,q3],
      Description -> "t-Y2  coupling",
      Value -> 1. }, 

 gTl == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,l],
      Description -> "l-Y2  coupling",
      Value -> 1. }, 
      
 gTh == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,h],
      Description -> "h-Y2  coupling",
      Value -> 1. }, 
      
 gTXr == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,Xr],
      Description -> "Xr-Y2  coupling",
      Value -> 0. },

 gTXd == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,Xd],
      Description -> "Xd-Y2  coupling",
      Value -> 1. },

 gTXv == { 
      ParameterType -> External,
      InteractionOrder -> {DMT, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[gT,Xv],
      Description -> "Xv-Y2  coupling",
      Value -> 0. }

};

(****************************************** Spin-2 ***************************************)

(*** Defining the cov derivatives ***)

covdelE[field_, mu_] :=
  Module[{j, a},  del[field, mu]
                 + I ee/cw 2 B[mu]/2 ProjP.field + I ee/cw B[mu]/2 ProjM.field + I ee/sw/2 ProjM.field Wi[mu,3]];

covdelN[field_, mu_] :=
  Module[{j, a}, del[field, mu] + I ee/cw B[mu]/2 ProjM.field - I ee/sw/2 ProjM.field Wi[mu,3]];

(*** Defining the energy-momentum tensor T[mu,nu] ***)

(* Fermions *)

TFf[mu_, nu_, ff_] :=   QLbar[ss, ii, ff, cc].Ga[mu, ss, ss1].DC[QL[ss1, ii, ff, cc], nu] -    DC[QLbar[ss, ii, ff, cc], mu].Ga[nu, ss, ss1].QL[ss1, ii, ff, cc] + 
                                  uRbar[ss, ff, cc].Ga[mu, ss, ss1].DC[uR[ss1, ff, cc], nu] - DC[uRbar[ss, ff, cc], mu].Ga[nu, ss, ss1].uR[ss1, ff, cc] + 
                                 dRbar[ss, ff, cc].Ga[mu, ss, ss1].DC[dR[ss1, ff, cc], nu] - DC[dRbar[ss, ff, cc], mu].Ga[nu, ss, ss1].dR[ss1, ff, cc];


TFhb[mu_, nu_] :=   QLbar[ss, 2, 3, cc].Ga[mu, ss, ss1].DC[QL[ss1, 2, 3, cc], nu] - 
   DC[QLbar[ss, 2, 3, cc], mu].Ga[nu, ss, ss1].QL[ss1, 2, 3, cc] + 
   dRbar[ss, 3, cc].Ga[mu, ss, ss1].DC[dR[ss1, 3, cc], nu] - 
   DC[dRbar[ss, 3, cc], mu].Ga[nu, ss, ss1].dR[ss1, 3, cc];

TFht[mu_, nu_] :=   QLbar[ss, 1, 3, cc].Ga[mu, ss, ss1].DC[QL[ss1, 1, 3, cc], nu] - 
   DC[QLbar[ss, 1, 3, cc], mu].Ga[nu, ss, ss1].QL[ss1, 1, 3, cc] + 
   uRbar[ss, 3, cc].Ga[mu, ss, ss1].DC[uR[ss1, 3, cc], nu] - 
   DC[uRbar[ss, 3, cc], mu].Ga[nu, ss, ss1].uR[ss1, 3, cc];

TFlq[mu_, nu_] := -ME[mu, nu] I/2 TFf[al, al, 1] + I/4 ( TFf[mu, nu, 1] + TFf[nu, mu, 1]) - ME[mu, nu] I/2 TFf[al, al, 2] + I/4 ( TFf[mu, nu, 2] + TFf[nu, mu, 2])-ME[mu, nu] I/2 TFhb[al, al] + I/4 ( TFhb[mu, nu] + TFhb[nu, mu]);

TFt[mu_, nu_] := -ME[mu, nu] I/2 TFht[al, al] + I/4 ( TFht[mu, nu] + TFht[nu, mu]);

feynmangaugerules =  If[Not[FeynmanGauge], {G0 | GP | GPbar -> 0}, {}]; 
yuk =  ExpandIndices[-yd[ff2, 3] CKM[3, ff2] QLbar[sp, ii, 3, cc].dR[sp, 3, cc] Phi[ii] - yu[3, 3] QLbar[sp, ii, 3, cc].uR[sp, 3, cc] Phibar[jj] Eps[ii, jj], FlavorExpand -> SU2D];
yuk = yuk /. {CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};

TYt[mu_, nu_] := -ME[mu, nu] (yuk + HC[yuk] /. feynmangaugerules)

TFlep[mu_, nu_] :=   LLbar[ss, ii, ff].Ga[mu, ss, ss1].DC[LL[ss1, ii, ff], nu] -    DC[LLbar[ss, ii, ff], mu].Ga[nu, ss, ss1].LL[ss1, ii, ff] + 
                                  lRbar[ss, ff].Ga[mu, ss, ss1].DC[lR[ss1, ff], nu] - DC[lRbar[ss, ff], mu].Ga[nu, ss, ss1].lR[ss1, ff] ;

TFl[mu_, nu_] := -ME[mu, nu] I/2 TFlep[al, al] + I/4 ( TFlep[mu, nu] + TFlep[nu, mu]);

TYl[mu_,nu_] := -ME[mu,nu] ( - MTA tabar.ta );

(* Higgs *)

Tscalar[mu_, nu_] := (2 DC[Phibar[ii], mu] DC[Phi[ii], nu]) - ME[mu, nu] (DC[Phibar[ii], rho] DC[Phi[ii], rho] + muH^2 Phibar[ii] Phi[ii] - lam Phibar[ii] Phi[ii] Phibar[jj] Phi[jj])

(* Gauge bosons *)

TGg[mu_,nu_] := -ME[mu,nu] (-1/4 FS[G,rho,sig,a] FS[G,rho,sig,a]) - FS[G,mu,rho,a] FS[G,nu,rho,a];
(*new lag for he weak sector before EWSB*)
(*Careful to check the gauge fixing term coefficient*)
TGB[mu_,nu_] := -ME[mu,nu](-1/4 FS[B,rho,sig]FS[B,rho,sig])-FS[B,mu,rho]FS[B,nu,rho];
TGW[mu_,nu_] := -ME[mu,nu](-1/4 FS[Wi,rho,sig,ii]FS[Wi,rho,sig,ii])-FS[Wi,mu,rho,ii]FS[Wi,nu,rho,ii];


(* Gauge fixing term is here because Madgraph takes the Feynman gauge for massless gauge boson propagators *)
(* and unitary gauge for massive gauge boson propagators. *)

TGFg[mu_,nu_]:= -ME[mu,nu].( del[del[G[sig, a1], sig], rho].G[rho, a1] +
                             1/2 del[G[rho, a1], rho].del[G[sig, a1], sig] ) +
                 del[del[G[rho, a1], rho], mu].G[nu, a1] + del[del[G[rho, a1], rho], nu].G[mu, a1];

TGFa[mu_,nu_]:= -ME[mu,nu].( del[del[A[sig], sig], rho].A[rho] +
                             1/2 del[A[rho], rho].del[A[sig], sig] ) +
                 del[del[A[rho], rho], mu].A[nu] + del[del[A[rho], rho], nu].A[mu];

(** Ghost **)

(*TGhost[mu_,nu_] := ( -ME[mu,nu].(DC[ghGbar,rho] DC[ghG,rho]) +
                       DC[ghGbar,mu] DC[ghG,nu] + DC[ghGbar,nu] DC[ghG,mu] ); *)

LQCDGhs = -ghGbar[ii].del[DC[ghG[ii], mu], mu];
TGhost[mu_,nu_] := -ME[mu,nu](ExpandIndices[ LQCDGhs , FlavorExpand->SU2W]) + ( del[ghGbar[a], mu].(del[ghG[a], nu] - gs f[a,b,c] G[nu,c] ghG[b] ) +   del[ghGbar[a], nu].(del[ghG[a], mu] - gs f[a,b,c] G[mu,c] ghG[b] )     ); 


(*** Writing the lagrangian ***)

L2f := -1/Lambda (gTq  TFlq[mu, nu] + gTq3 (TFt[mu, nu] + TYt[mu, nu]) +    gTl (TFl[mu, nu] + TYl[mu, nu])) Y2[mu, nu]
L2v := -1/Lambda ExpandIndices[ ( gTg (TGg[mu,nu]+TGFg[mu,nu]) + gTw TGW[mu,nu] + gTb TGB[mu,nu] + (gTb cw^2 + gTw sw^2) TGFa[mu,nu]) Y2[mu,nu],FlavorExpand->True];
L2gh := -1/Lambda (gTg TGhost[mu,nu]              ) Y2[mu,nu];
L2H  := -1/Lambda ExpandIndices[(gTh Tscalar[mu,nu]              )Y2[mu,nu],FlavorExpand->True] /. feynmangaugerules;

(*** Writing the lagrangian ***)

L2SM := L2f + L2v + L2gh + L2H;


(**** DM sector ***)
(* Real Scalars: r *)
TSrX[mu_,nu_] := -1/2 ME[mu,nu] (del[Xr, rho] del[Xr, rho] - MXr MXr Xr Xr ) + 
                  del[Xr, mu] del[Xr, nu]; 

L2rX := -1/Lambda ( gTXr TSrX[mu,nu] Y2[mu,nu] );

(* Fermions: q *)
TFqX[mu_,nu_] := -ME[mu,nu] I Xdbar.(Ga[rho].del[Xd, rho]) +
                  1/2 ME[mu,nu] del[I Xdbar.Ga[rho].Xd, rho] +
                  I/2  Xdbar.Ga[mu].del[Xd, nu] - 1/4 I del[Xdbar.Ga[nu].Xd, mu] + 
                  I/2  Xdbar.Ga[nu].del[Xd, mu] - 1/4 I del[Xdbar.Ga[mu].Xd, nu];
TYqX[mu_,nu_] := -ME[mu,nu] ( - MXd Xdbar.Xd );

L2fX := -1/Lambda ( gTXd (TFqX[mu,nu] + TYqX[mu,nu]) ) Y2[mu,nu];  

(* Vectors: v *)
TVvX[mu_,nu_] := -ME[mu,nu] ( -1/4 FS[Xv,sig,rho] FS[Xv,sig,rho] + 
                              +1/2 MXv MXv Xv[rho] Xv[rho] ) +              
                  FS[Xv,mu,rho] FS[Xv,rho,nu] +
	          MXv MXv Xv[mu] Xv[nu];

L2vX := -1/Lambda ( gTXv TVvX[mu,nu] Y2[mu,nu] );
	       

L2DM := L2rX + L2fX + L2vX + L2SM;
