(* ****************************************************************** *)
(* *****                                                        ***** *)
(* *****  FeynRules model file: Simplified s-channel DM models  ***** *)
(* *****  Author: A. Martini, K. Mawatari                       ***** *)
(* *****          J. Wang, C.Zhang                              ***** *)
(* *****                                                        ***** *)
(* ****************************************************************** *)

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 2015.08.24 v1.0 - release version. *)


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)  
M$Parameters = {

(* EW couplings with the spin-0 mediator *)
 gSh1 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sh1],
      Description -> "h-Y0 scalar coupling 1",
      Value -> 1. },     

 gSh2 == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sh2],
      Description -> "h-Y0 scalar coupling 2",
      Value -> 0. },     

 gSb == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sb],
      Description -> "B-Y0 scalar coupling",
      Value -> 1. },     

 gPb == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pb],
      Description -> "B-Y0 pseudoscalar coupling",
      Value -> 0. },     

 gSw == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Sw],
      Description -> "W-Y0 scalar coupling",
      Value -> 0. },     

 gPw == { 
      ParameterType -> External,
      InteractionOrder -> {DMS, 1},
      BlockName -> DMINPUTS,
      TeX -> Subscript[g,Pw],
      Description -> "W-Y0 pseudoscalar coupling",
      Value -> 0. }

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

L0SMEW := Module[{ii,jj}, ExpandIndices[
	gSh1/Lambda * DC[Phibar[ii],mu] DC[Phi[ii],mu] Y0 +
	gSh2/Lambda * MH^2 * (Phibar[jj] Phi[jj] - vev^2 / 2) Y0,
        FlavorExpand->{SU2D,SU2W}]] +
	Module[{mu,nu}, ExpandIndices[
	1/Lambda * FS[B,mu,nu] (gSb FS[B,mu,nu] + 
                                 gPb Dual[FS][B,mu,nu]) Y0,
        FlavorExpand->{SU2D,SU2W}]] +
	Module[{mu,nu,ii}, ExpandIndices[
	1/Lambda * FS[Wi,mu,nu,ii] (gSw FS[Wi,mu,nu,ii] + 
                                 gPw Dual[FS][Wi,mu,nu,ii]) Y0,
        FlavorExpand->{SU2D,SU2W}]] ;

