(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    319721,       6599]
NotebookOptionsPosition[    297333,       6012]
NotebookOutlinePosition[    297670,       6027]
CellTagsIndexPosition[    297627,       6024]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6035389591727333`*^9, 3.6035389606320753`*^9}, {
  3.608281672604871*^9, 3.608281673651908*^9}, {3.6097575541555*^9, 
  3.609757557300255*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Documents/feynrules-current_3_7\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.60353897829296*^9, 3.603539043421093*^9}, {
   3.633332218679607*^9, 3.6333322194542303`*^9}, 3.633333796845446*^9, {
   3.64301873415166*^9, 3.64301873665499*^9}, {3.6452720966860647`*^9, 
   3.645272098076991*^9}, {3.647076372652458*^9, 3.647076373114575*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.603539048879374*^9, 3.603539054382785*^9}, {
  3.630748915770712*^9, 3.630748916976617*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335728375*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.7\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 July 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.7", " (" "27 July 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335769599*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.6494043357711353`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.64940433577249*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335773806*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335775343*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.6494043357768087`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.6494043357782507`*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.6494043357795773`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335780909*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.6110361274817457`*^9, 3.611036216598939*^9, 3.6110367049806023`*^9, 
   3.611045876569394*^9, 3.611046056835099*^9, 3.61104651117745*^9, 
   3.616920484813521*^9, 3.616921485363764*^9, 3.616922083363084*^9, 
   3.6169222498253803`*^9, 3.61692247671194*^9, 3.6169225850237217`*^9, 
   3.626081965782981*^9, 3.627485432509675*^9, 3.62762805295048*^9, 
   3.6276356752872562`*^9, 3.627800213057104*^9, 3.6307489184278393`*^9, 
   3.63333222790595*^9, 3.6333337902040663`*^9, 3.633347976246666*^9, 
   3.6334297893921328`*^9, 3.633759461568802*^9, 3.633759633282177*^9, 
   3.633759726730798*^9, {3.633759792106916*^9, 3.633759815923191*^9}, 
   3.633761293839384*^9, 3.6337670547127237`*^9, 3.635682215184022*^9, 
   3.635682934883945*^9, 3.635760127197874*^9, 3.635760175783587*^9, 
   3.6376406863896637`*^9, 3.637640726419091*^9, 3.637640758629774*^9, 
   3.637640958230589*^9, 3.637641405244493*^9, 3.637641495220693*^9, 
   3.637642208784834*^9, 3.637642569793989*^9, 3.6376426520030203`*^9, 
   3.637648124759632*^9, 3.639376994064643*^9, 3.639377077882502*^9, 
   3.639377201190076*^9, 3.639377317501244*^9, 3.639377410990694*^9, 
   3.639377513942395*^9, 3.639377585687583*^9, 3.639379644215146*^9, 
   3.639379726261013*^9, 3.639388637108721*^9, 3.639388668138874*^9, 
   3.639988974910592*^9, 3.640510185967122*^9, 3.641476026156052*^9, 
   3.641539935478367*^9, 3.6416348653469257`*^9, 3.641727097245332*^9, 
   3.64178949804799*^9, 3.641789770803505*^9, 3.6430232558014317`*^9, {
   3.6430251332931433`*^9, 3.643025158675023*^9}, 3.643025218786581*^9, 
   3.645272106771387*^9, 3.645273267771743*^9, 3.6452749191028843`*^9, 
   3.645770337337294*^9, 3.645780123516604*^9, 3.645780416101548*^9, 
   3.64602634578681*^9, 3.6463709293456306`*^9, 3.646371738253957*^9, 
   3.646377062533774*^9, 3.646388598051454*^9, 3.646733866316379*^9, 
   3.646733955464802*^9, 3.647076458494377*^9, 3.647347856687975*^9, 
   3.649403273138598*^9, 3.649404335782366*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/DMsimp\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.603539061006528*^9, 3.603539075359961*^9}, {
   3.606550370901471*^9, 3.606550372067235*^9}, {3.608280713549712*^9, 
   3.608280720038208*^9}, {3.608280848612903*^9, 3.608280850051903*^9}, {
   3.610078232055901*^9, 3.610078244162396*^9}, {3.611032810906569*^9, 
   3.611032811729677*^9}, 3.611046032505571*^9, {3.611046080564261*^9, 
   3.6110460835240393`*^9}, {3.616920451742062*^9, 3.616920454335582*^9}, {
   3.61692081007111*^9, 3.616920811789462*^9}, {3.6169220902135057`*^9, 
   3.6169220916785192`*^9}, {3.627800218613393*^9, 3.6278002208210363`*^9}, {
   3.630748932272941*^9, 3.630748937906595*^9}, {3.633332239193083*^9, 
   3.6333322403879013`*^9}, 3.633333794100926*^9, {3.633759468942481*^9, 
   3.6337594703175983`*^9}, {3.635681641356083*^9, 3.6356816446148367`*^9}, {
   3.6376402973444223`*^9, 3.6376402986547117`*^9}, {3.639376919579711*^9, 
   3.639376921244483*^9}, {3.6405100299897413`*^9, 3.640510032443145*^9}, {
   3.643018741816877*^9, 3.643018742543559*^9}, 3.643024926442786*^9, {
   3.645273275267683*^9, 3.645273276634437*^9}, {3.645274930954957*^9, 
   3.645274932634717*^9}, {3.645770163878159*^9, 3.6457701691664543`*^9}, {
   3.645780013280984*^9, 3.645780013490704*^9}, {3.646026237633871*^9, 
   3.6460262398106728`*^9}, {3.6473477666176853`*^9, 3.647347767847106*^9}, {
   3.649402992381681*^9, 3.6494029933443527`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.603538963565145*^9, 3.603538971919922*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM.fr\>\"", ",", "\"\<dm_s_spin1.fr\>\"", ",", 
   "\"\<dm_s_spin1_ew.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.633332249125042*^9, 3.633332249491701*^9}, {
   3.6337594763689528`*^9, 3.6337594776507893`*^9}, {3.6356816576884117`*^9, 
   3.6356816603749027`*^9}, {3.637640302808282*^9, 3.6376403082726*^9}, {
   3.637640716438528*^9, 3.6376407440268297`*^9}, 3.643024914860723*^9, {
   3.645273293611383*^9, 3.6452732956188726`*^9}, {3.645770176958198*^9, 
   3.645770177262162*^9}, {3.646026243920371*^9, 3.6460262460509453`*^9}, {
   3.647347782049244*^9, 3.64734778358805*^9}, {3.64940300547442*^9, 
   3.649403021810585*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342789527*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.6494043428245564`*^9}],

Cell[BoxData["\<\"A. Martini, K. Mawatari, J. Wang, C. Zhang\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342826166*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342827634*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342828978*^9}],

Cell[BoxData["\<\"O. Mattelaer et al., arXiv:1508.00564\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.6494043428304*^9}],

Cell[BoxData["\<\"M. Backovic et al., arXiv:1508.05327\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342831807*^9}],

Cell[BoxData["\<\"M. Neubert et al., arXiv:1508.xxxxx\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342833261*^9}],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/DMsimp/\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.6494043428349543`*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.6494043428367662`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342838277*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342839663*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404342974708*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.649404343020705*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"DMsimp_s_spin1\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "DMsimp_s_spin1", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539276229219*^9, 3.6035428651813183`*^9, 3.603599911499213*^9, 
   3.603601342445846*^9, 3.6036187190236464`*^9, 3.6049467561305513`*^9, 
   3.6065503769323997`*^9, 3.608280856221733*^9, 3.608281631553297*^9, 
   3.608281690134647*^9, 3.6082817251443768`*^9, 3.608282107510787*^9, 
   3.6082824242562103`*^9, 3.608352909441928*^9, 3.6083540622806997`*^9, 
   3.6083541434032393`*^9, 3.6083543240677567`*^9, 3.608354614648614*^9, 
   3.608358025933999*^9, 3.608358128623258*^9, 3.608359221131486*^9, 
   3.6084510618171864`*^9, 3.609235764148369*^9, 3.609236227349654*^9, 
   3.609757586028043*^9, 3.610078214393291*^9, 3.610078266654603*^9, 
   3.610078858102491*^9, 3.610079022297451*^9, 3.61007906477439*^9, 
   3.610097055075354*^9, 3.6110328165448027`*^9, 3.6110328622220716`*^9, 
   3.611033051920595*^9, 3.611035756190256*^9, 3.611035887624475*^9, 
   3.611036013590836*^9, 3.611036133470861*^9, 3.611036222009946*^9, 
   3.6110367119538603`*^9, 3.6110458837561626`*^9, 3.611046087381626*^9, 
   3.611046516578813*^9, 3.616920494644947*^9, 3.616921490449946*^9, 
   3.61692209555116*^9, {3.616922235727729*^9, 3.6169222557918653`*^9}, 
   3.61692248266975*^9, 3.616922590363521*^9, 3.6260819710519257`*^9, 
   3.6274854451468067`*^9, 3.627628058682411*^9, 3.627635682746304*^9, 
   3.6278002260992823`*^9, 3.630748955872439*^9, 3.633332251206326*^9, 
   3.633333805271109*^9, 3.6333479837150583`*^9, 3.633429797615189*^9, 
   3.6337596440210867`*^9, 3.633759736316864*^9, {3.633759800942401*^9, 
   3.633759821611841*^9}, 3.633761298716833*^9, 3.633767060283568*^9, 
   3.6356822233246393`*^9, 3.635682940927937*^9, 3.635760132371312*^9, 
   3.635760181490759*^9, {3.63764070672262*^9, 3.637640731407392*^9}, 
   3.637640785936223*^9, 3.637640963641189*^9, 3.6376414110670567`*^9, 
   3.637641502585011*^9, 3.637642214642048*^9, 3.637642577024967*^9, 
   3.63764265841442*^9, 3.6376481321319447`*^9, 3.6393770012564774`*^9, 
   3.639377083908358*^9, 3.639377206661962*^9, 3.639377325698201*^9, 
   3.639377417358796*^9, 3.6393775234213247`*^9, 3.639377592106596*^9, 
   3.639379649440363*^9, 3.639379734329454*^9, 3.639388644217759*^9, 
   3.639388674403668*^9, 3.639988980372665*^9, 3.640510194707777*^9, 
   3.6414760321905518`*^9, 3.64153994214283*^9, 3.6416348706083508`*^9, 
   3.641727103360285*^9, 3.641789503957403*^9, 3.641789776141971*^9, 
   3.643025165611589*^9, 3.643025225125194*^9, 3.645272117924819*^9, 
   3.645273299742169*^9, 3.645274940197342*^9, 3.645770345152109*^9, 
   3.6457801294682627`*^9, 3.64578042170009*^9, 3.646026354595029*^9, 
   3.646370936028935*^9, 3.646371743777197*^9, 3.646377068395289*^9, 
   3.64638860403161*^9, 3.646733874256979*^9, 3.6467339613477383`*^9, 
   3.647076465387384*^9, 3.647347864730913*^9, 3.649403280131568*^9, 
   3.6494043430815783`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.639376820290628*^9, 3.6393768234379387`*^9}, {
  3.6393770865564947`*^9, 3.6393770912761908`*^9}, {3.6393771858866796`*^9, 
  3.6393771863740797`*^9}, {3.639377466478868*^9, 3.639377471110105*^9}, {
  3.6393796364789057`*^9, 3.639379637142768*^9}, {3.639989012839026*^9, 
  3.639989036648665*^9}, {3.641539947651075*^9, 3.641539950365509*^9}, {
  3.641789785973187*^9, 3.641789792194556*^9}, {3.643025183012186*^9, 
  3.643025185439151*^9}, {3.645274945395602*^9, 3.645274957019786*^9}, {
  3.6457800188411694`*^9, 3.645780019775859*^9}, {3.646377072375288*^9, 
  3.646377083707752*^9}, {3.646465411317153*^9, 3.646465413430913*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.646733879107862*^9, 3.646733965179865*^9, 
  3.647076468461007*^9, 3.647347867464292*^9, 3.649403286040627*^9, 
  3.649404346434187*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless_5f.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless_5f.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{3.646733879107862*^9, 3.646733965179865*^9, 
  3.647076468461007*^9, 3.647347867464292*^9, 3.649403286040627*^9, 
  3.649404346584817*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.646733879107862*^9, 3.646733965179865*^9, 
  3.647076468461007*^9, 3.647347867464292*^9, 3.649403286040627*^9, 
  3.649404346701417*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"LoadRestriction", "[", 
   RowBox[{"\"\<DiagonalCKM.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], "]"}],
   "*)"}]], "Input",
 CellChangeTimes->{{3.6463770912666693`*^9, 3.646377094581213*^9}, {
  3.646465405450945*^9, 3.646465408665985*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{234., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Loading restrictions from ", "DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.633429802306655*^9, 3.633429905609647*^9, 3.633759825766581*^9, 
   3.633761301178506*^9, 3.633767062560195*^9, 3.63568273224512*^9, 
   3.635682967881454*^9, 3.635760185978702*^9, 3.637640793234333*^9, 
   3.6376409663453207`*^9, 3.6376414136719303`*^9, 3.63764154491444*^9, 
   3.637642217600418*^9, 3.63764258028148*^9, 3.637642660905436*^9, 
   3.637648137063446*^9, 3.6393770036335373`*^9, 3.639377101485468*^9, 
   3.6393772091113167`*^9, 3.639377330579913*^9, 3.6393774205071917`*^9, 
   3.6393775444189453`*^9, 3.639377598580368*^9, 3.6393796522052507`*^9, 
   3.639379737341523*^9, 3.639388647257901*^9, 3.639989041644158*^9, 
   3.640510201117528*^9, 3.641476035981634*^9, 3.641539952215021*^9, 
   3.641634873333626*^9, 3.641727111641016*^9, 3.641789794796475*^9, 
   3.643025228084968*^9, 3.645272125469777*^9, 3.645273303628559*^9, {
   3.6452749506689787`*^9, 3.645274959391213*^9}, 3.645770348976141*^9, 
   3.645780133863399*^9, 3.6457804245924997`*^9, 3.6460263615142183`*^9, 
   3.6463709387164497`*^9, 3.646371746535939*^9, 3.6463770982378063`*^9, 
   3.646388607680099*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless_5f.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{234., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless_5f.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.633429802306655*^9, 3.633429905609647*^9, 3.633759825766581*^9, 
   3.633761301178506*^9, 3.633767062560195*^9, 3.63568273224512*^9, 
   3.635682967881454*^9, 3.635760185978702*^9, 3.637640793234333*^9, 
   3.6376409663453207`*^9, 3.6376414136719303`*^9, 3.63764154491444*^9, 
   3.637642217600418*^9, 3.63764258028148*^9, 3.637642660905436*^9, 
   3.637648137063446*^9, 3.6393770036335373`*^9, 3.639377101485468*^9, 
   3.6393772091113167`*^9, 3.639377330579913*^9, 3.6393774205071917`*^9, 
   3.6393775444189453`*^9, 3.639377598580368*^9, 3.6393796522052507`*^9, 
   3.639379737341523*^9, 3.639388647257901*^9, 3.639989041644158*^9, 
   3.640510201117528*^9, 3.641476035981634*^9, 3.641539952215021*^9, 
   3.641634873333626*^9, 3.641727111641016*^9, 3.641789794796475*^9, 
   3.643025228084968*^9, 3.645272125469777*^9, 3.645273303628559*^9, {
   3.6452749506689787`*^9, 3.645274959391213*^9}, 3.645770348976141*^9, 
   3.645780133863399*^9, 3.6457804245924997`*^9, 3.6460263615142183`*^9, 
   3.6463709387164497`*^9, 3.646371746535939*^9, 3.6463770982378063`*^9, 
   3.64638860782644*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.633429802306655*^9, 3.633429905609647*^9, 3.633759825766581*^9, 
   3.633761301178506*^9, 3.633767062560195*^9, 3.63568273224512*^9, 
   3.635682967881454*^9, 3.635760185978702*^9, 3.637640793234333*^9, 
   3.6376409663453207`*^9, 3.6376414136719303`*^9, 3.63764154491444*^9, 
   3.637642217600418*^9, 3.63764258028148*^9, 3.637642660905436*^9, 
   3.637648137063446*^9, 3.6393770036335373`*^9, 3.639377101485468*^9, 
   3.6393772091113167`*^9, 3.639377330579913*^9, 3.6393774205071917`*^9, 
   3.6393775444189453`*^9, 3.639377598580368*^9, 3.6393796522052507`*^9, 
   3.639379737341523*^9, 3.639388647257901*^9, 3.639989041644158*^9, 
   3.640510201117528*^9, 3.641476035981634*^9, 3.641539952215021*^9, 
   3.641634873333626*^9, 3.641727111641016*^9, 3.641789794796475*^9, 
   3.643025228084968*^9, 3.645272125469777*^9, 3.645273303628559*^9, {
   3.6452749506689787`*^9, 3.645274959391213*^9}, 3.645770348976141*^9, 
   3.645780133863399*^9, 3.6457804245924997`*^9, 3.6460263615142183`*^9, 
   3.6463709387164497`*^9, 3.646371746535939*^9, 3.6463770982378063`*^9, 
   3.64638860794532*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckHermiticity", "[", 
   RowBox[{"LSM", "+", "L1DM", "+", "L1SMEW"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.633332290865224*^9, 3.633332305905663*^9}, 
   3.63333373270155*^9, 3.6337594836385403`*^9, {3.6337598304792633`*^9, 
   3.633759842414878*^9}, {3.635681667322399*^9, 3.63568169987755*^9}, {
   3.637640325295994*^9, 3.637640326653831*^9}, {3.6494030879543467`*^9, 
   3.649403102697242*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353312338*^9}],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404353313555*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.6494043645299463`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.6494043645635242`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.6494043645651207`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404365456595*^9}],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404365495038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.6494043654964247`*^9}],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.633332308739032*^9, 3.63333380901442*^9, 
  3.633347988065689*^9, 3.6337598744753237`*^9, 3.63376130433986*^9, 
  3.635682737560614*^9, 3.635682971522418*^9, 3.6357601897569227`*^9, 
  3.637640797079672*^9, 3.6376409701272078`*^9, 3.6376415490168123`*^9, 
  3.637642221307509*^9, 3.637648140805072*^9, 3.639377007793378*^9, 
  3.639377106318482*^9, 3.640510205979582*^9, 3.643025233462542*^9, 
  3.6452721299027557`*^9, 3.645273306904765*^9, 3.645274963609025*^9, 
  3.6457703530356617`*^9, 3.645780138474923*^9, 3.646026367370565*^9, 
  3.646370944015682*^9, 3.6463717494932547`*^9, 3.6467338848898067`*^9, 
  3.646733969408041*^9, 3.647076472955679*^9, 3.647347871963839*^9, 
  3.649403291499647*^9, 3.649404365497686*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LSM", "+", "L1DM", "+", "L1SMEW"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.603539435628551*^9, 3.603539443511031*^9}, {
   3.633332257675256*^9, 3.633332273874855*^9}, 3.633332330927515*^9, {
   3.633759485057345*^9, 3.6337594896329927`*^9}, {3.633759845728799*^9, 
   3.633759845998361*^9}, {3.635681693519002*^9, 3.635681708124132*^9}, 
   3.637640353419092*^9, 3.649403113712747*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307509602*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307534171*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403307536469*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403312922605*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "119", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{201., {2., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "119", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  119, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 119, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403312977442*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"114", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[114, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.603539445189519*^9, 3.603542874036621*^9, 3.603599924678094*^9, 
   3.603601350674114*^9, 3.604946764412753*^9, 3.6065503893794193`*^9, 
   3.608281576010133*^9, 3.608281915221355*^9, 3.608282113894981*^9, 
   3.6082824343299837`*^9, {3.6082826108416033`*^9, 3.6082826382983027`*^9}, 
   3.608282706384251*^9, 3.6083534340971737`*^9, 3.6083546211097918`*^9, 
   3.6083581397389507`*^9, 3.6083592300796347`*^9, 3.608451157968486*^9, 
   3.608451329297677*^9, 3.609236387487259*^9, 3.609757624723915*^9, 
   3.610078304599987*^9, 3.610078910000843*^9, 3.610079078750251*^9, 
   3.610097065065124*^9, 3.6100971489601507`*^9, {3.610097187768207*^9, 
   3.61009720841532*^9}, 3.611033106407926*^9, 3.6110357697809153`*^9, 
   3.6110358967154217`*^9, 3.6110360250818863`*^9, 3.611036159530105*^9, 
   3.611036228135294*^9, 3.611036722103962*^9, 3.6110465423941793`*^9, 
   3.62608199560072*^9, 3.6274854776686583`*^9, 3.627628080607481*^9, 
   3.6276357595056877`*^9, 3.6278002589171057`*^9, {3.6333322543816843`*^9, 
   3.6333322783738317`*^9}, 3.633332333800562*^9, 3.6333338281586237`*^9, 
   3.6333480066889687`*^9, 3.635682757363223*^9, 3.6356829870207*^9, 
   3.645272148521742*^9, 3.6452733633168697`*^9, 3.6452750043196363`*^9, 
   3.645770427852042*^9, 3.645780170482917*^9, 3.6460263819960527`*^9, 
   3.649403316739642*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Lren", "=", 
    RowBox[{"OnShellRenormalization", "[", 
     RowBox[{
      RowBox[{"LSM", "+", "LDM"}], ",", 
      RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
      RowBox[{"FlavorMixing", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.639377293725038*^9, 3.639377294339272*^9}, {
  3.639377426660799*^9, 3.63937742737294*^9}, {3.639377575388748*^9, 
  3.639377575885442*^9}, {3.639377666979536*^9, 3.639377667838319*^9}, {
  3.639379689397005*^9, 3.6393796898866987`*^9}, {3.63938867958291*^9, 
  3.639388680272472*^9}, {3.64673380677352*^9, 3.646733809952742*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Lren", "=", 
   RowBox[{"OnShellRenormalization", "[", 
    RowBox[{
     RowBox[{"LSM", "+", "L1DM", "+", "L1SMEW"}], ",", 
     RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
     RowBox[{"FlavorMixing", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.646733829286021*^9, 3.646733829286853*^9}, {
   3.6467339400725517`*^9, 3.646733941680039*^9}, {3.647076393112405*^9, 
   3.647076398191709*^9}, 3.649403119421309*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Extracting the mass and kinetic terms to simplify \
them\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043736046743`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.649404377752858*^9}],

Cell[BoxData["\<\"renormalizing the fields\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043878335037`*^9}],

Cell[BoxData["\<\"No mixing allowed for the renormalization\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.649404387951726*^9}],

Cell[BoxData["\<\"renormalizing the parameters\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.649404387994981*^9}],

Cell[BoxData["\<\"renormalizing the masses\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043879971952`*^9}],

Cell[BoxData["\<\"renormalizing the other external parameters\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.6494043879987*^9}],

Cell[BoxData["\<\"Internal parameter renormalization\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.649404388000049*^9}],

Cell[BoxData["\<\"renormalizing the Lagrangian\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.649404408618609*^9}],

Cell[BoxData["\<\"with the parameters\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.649404408657929*^9}],

Cell[BoxData["\<\"with the fields\"\>"], "Print",
 CellChangeTimes->{3.6393797451686087`*^9, 3.639388656970622*^9, 
  3.6393886895686502`*^9, 3.639989052082037*^9, 3.6405102358000793`*^9, 
  3.6414760466539183`*^9, 3.641539965513507*^9, 3.641634883223867*^9, 
  3.6417271222307262`*^9, 3.6417898055676622`*^9, 3.643025271259474*^9, 
  3.645272184616929*^9, 3.645273388409584*^9, 3.645275809764739*^9, 
  3.6457704453515463`*^9, 3.645780191266561*^9, 3.6457804335225677`*^9, 
  3.646026407845578*^9, 3.646370973435533*^9, 3.646371770694023*^9, 
  3.646377110494865*^9, 3.646388619329558*^9, 3.646733906197085*^9, 
  3.6467339893986197`*^9, 3.6470764908395452`*^9, 3.647347894759062*^9, 
  3.649403329101622*^9, 3.64940440968515*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", "[", "\"\<~/Documents/FeynArts-3.8/Models\>\"", "]"}], 
   ";"}], " "}]], "Input",
 CellChangeTimes->{3.6393806207387753`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"Lren", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<DMsimp_s_spin1\>\""}], ",", 
   RowBox[{"GenericFile", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6333334931038446`*^9, 3.6333335002871113`*^9}, {
   3.633429938271714*^9, 3.633429940559534*^9}, {3.633759562734586*^9, 
   3.633759563558978*^9}, {3.635681724626162*^9, 3.635681727084104*^9}, {
   3.6376404072686653`*^9, 3.637640408501841*^9}, {3.639376868393108*^9, 
   3.639376873532495*^9}, {3.639376939852498*^9, 3.63937694097348*^9}, {
   3.6405100428214617`*^9, 3.640510047037116*^9}, {3.640510118853291*^9, 
   3.6405101199564657`*^9}, {3.64301875554954*^9, 3.6430187563700323`*^9}, 
   3.643024935629327*^9, {3.645273450557111*^9, 3.64527345176429*^9}, {
   3.645275847284135*^9, 3.6452758487344007`*^9}, 3.6457702275909433`*^9, {
   3.645780047080944*^9, 3.645780047281754*^9}, {3.646026256330978*^9, 
   3.646026258353125*^9}, {3.646388651789977*^9, 3.646388653583241*^9}, {
   3.646733795890051*^9, 3.646733799012479*^9}, {3.647347792529991*^9, 
   3.647347793758451*^9}, {3.6494031342347517`*^9, 3.649403136315456*^9}, {
   3.649404423143777*^9, 3.649404424415291*^9}, {3.6500895827438307`*^9, 
   3.650089583117058*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - - - FeynRules interface to FeynArts - - -\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtePJ3fUHQTQAPlSR/w==
  "]],

Cell[BoxData["\<\"      C. Degrande C. Duhr, 2013\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtWNDb8NBEA0AOtCRiQ==
  "]],

Cell[BoxData["\<\"      Counterterms: B. Fuks, 2012\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN4A6N5ZDQdBNAA8C5Gy
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Creating output directory: \"\>", 
   "\[InvisibleSpace]", "\<\"DMsimp_spin1\"\>"}],
  SequenceForm["Creating output directory: ", "DMsimp_spin1"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN4A6I9lDQdBNAA+r5II
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtaPCpoaDIBoAONORTg==
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtWN3MOshEA0ANrWQ4A==
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN4AKJ/IeghEAwA2H5DP
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtWNhEeshEA0ANr6Q5Q==
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtaNpLv8REA0ANQGQsA==
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Class members in the Lagrangian! Not supported by \
FeynArts.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtSPHP+EjIBoAN6iRGA==
  "]],

Cell[BoxData["\<\"1 vertex obtained.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gteOTLNEjIBoAOoiRYg==
  "]],

Cell[BoxData["\<\"Redefining classes in such a way that each particle is in a \
separate FeynArts class.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gteOxStEjIBoAOgGRUw==
  "]],

Cell[BoxData["\<\"See NewFeynArtsClasses[] for more information on the new \
classes\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtWNRq+gREA0AN7WRCw==
  "]],

Cell[BoxData["\<\"Restarting Feynman rule calculation, setting FlavorExpand \
-> True.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtaPUJNEjIBoANVCQwA==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating Feynman rules for \"\>", 
   "\[InvisibleSpace]", "\<\"L1\"\>"}],
  SequenceForm["Calculating Feynman rules for ", "L1"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN4AaM580SMgGgA3i5EJ
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rules calculation for L1.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtWOT7MQjIBoAOEWRLw==
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtaOM1sQjIBoANXCQ1g==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gtSOX5cQjIBoANUmQ0w==
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN4AKC679RiIBgA3P5EY
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "193", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "193", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  193, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 193, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN4A6C/9XcdANAA8G5G3
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"174", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[174, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gteOEE7InQDQAOr6ReA==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Writing FeynArts model file into directory \"\>", 
   "\[InvisibleSpace]", "\<\"DMsimp_spin1\"\>"}],
  SequenceForm["Writing FeynArts model file into directory ", "DMsimp_spin1"],
  
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQA+IpTfVXOIReO/pXnDvAD6RLdXz3mgPp03tNbt4A0o4y
DN03gfQqucTIO0C6r0zgWLPYa8ddAtb3QLSLUdHklUC6pV/WwkHqteNZ+Vdt
IFoiZv9uEP2sXTTHGUj/e7qnBEQbzlDynSr72nFOfFz+LrnXjimxPG93yL92
PHGuv2GC4mvH8zeW7F4PpA+oTpK+B6SfSy2V51Z67eiXv/y6JpA2eXnxR4vK
a8cQEzHxcxqvHYPLz60F0acuW9w8D6T52CRTDmq+dsyZ6m53DEiHnboVZaf1
2vG2aMn0Z0Car4nJ9DmQnqJzdupLIB08RdbsPZDOEX57Y7r2a0dXz38i9jqv
HbdY/Jt1GEjr7V7isN7gteO+Q5UnQDQAPiyR/A==
  "]]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Documents/FeynArts-3.8\>\"", "]"}], 
  ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", " ", "FeynArts`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494522189*^9}],

Cell[BoxData["\<\"FeynArts 3.8\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.64940449454208*^9}],

Cell[BoxData["\<\"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494543632*^9}],

Cell[BoxData["\<\"last revised 9 Jul 13\"\>"], "Print",
 CellChangeTimes->{
  3.6333340062742558`*^9, 3.633348229208444*^9, 3.633430065155362*^9, 
   3.633760001669025*^9, {3.633761419825535*^9, 3.633761425885021*^9}, 
   3.633767166566884*^9, 3.635683139828644*^9, 3.635760340532014*^9, 
   3.637641781424296*^9, 3.637642777828939*^9, 3.637648360547853*^9, 
   3.63938888484129*^9, 3.6399891883206367`*^9, 3.6405105000307283`*^9, 
   3.6414761804555807`*^9, 3.64154016168857*^9, 3.641635285717799*^9, 
   3.641727329735632*^9, 3.641790209539661*^9, 3.6430254539917393`*^9, 
   3.64527235156678*^9, {3.6452735456903152`*^9, 3.645273547429137*^9}, 
   3.645274078357388*^9, 3.645275918468567*^9, 3.645770729621505*^9, 
   3.6457805883271008`*^9, 3.6460265810439*^9, 3.646371089894401*^9, 
   3.6463723181263227`*^9, 3.6463773435981283`*^9, 3.646388714466091*^9, 
   3.646734121004572*^9, {3.647076590445853*^9, 3.6470765971626987`*^9}, 
   3.647347991398026*^9, 3.64940346604403*^9, 3.649404494545072*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/Documents/feynrules-current_3_7\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.64302329717109*^9, 3.643023299501276*^9}, {
  3.6452723585550957`*^9, 3.645272359939103*^9}, {3.647076405736209*^9, 
  3.64707640635962*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", " ", "NLOCT`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - NLOCT - \"\>"], "Print",
 CellChangeTimes->{3.633334012398602*^9, 3.63334823479993*^9, 
  3.633430070827776*^9, 3.6337600047552557`*^9, 3.6337614288449593`*^9, 
  3.63376716963179*^9, 3.635683144036674*^9, 3.635760344048397*^9, 
  3.6376417854673986`*^9, 3.6376427809103813`*^9, 3.637648364508534*^9, 
  3.639388890816511*^9, 3.639989191172407*^9, 3.6405105028721447`*^9, 
  3.6414761840245857`*^9, 3.641540165251926*^9, 3.641635290546917*^9, 
  3.64172733228785*^9, 3.641790212336192*^9, 3.643025460613501*^9, 
  3.645272365875441*^9, 3.645273553311666*^9, 3.645274081217651*^9, 
  3.6452759224520473`*^9, 3.645770733219626*^9, 3.645780591417716*^9, 
  3.646026588840769*^9, 3.646371094455577*^9, 3.646372321274672*^9, 
  3.6463773477242813`*^9, 3.64638871796944*^9, 3.646734124503805*^9, 
  3.647076600246109*^9, 3.6473479946640787`*^9, 3.649403470879184*^9, 
  3.6494044980102777`*^9}],

Cell[BoxData["\<\"Version: 1.02\"\>"], "Print",
 CellChangeTimes->{3.633334012398602*^9, 3.63334823479993*^9, 
  3.633430070827776*^9, 3.6337600047552557`*^9, 3.6337614288449593`*^9, 
  3.63376716963179*^9, 3.635683144036674*^9, 3.635760344048397*^9, 
  3.6376417854673986`*^9, 3.6376427809103813`*^9, 3.637648364508534*^9, 
  3.639388890816511*^9, 3.639989191172407*^9, 3.6405105028721447`*^9, 
  3.6414761840245857`*^9, 3.641540165251926*^9, 3.641635290546917*^9, 
  3.64172733228785*^9, 3.641790212336192*^9, 3.643025460613501*^9, 
  3.645272365875441*^9, 3.645273553311666*^9, 3.645274081217651*^9, 
  3.6452759224520473`*^9, 3.645770733219626*^9, 3.645780591417716*^9, 
  3.646026588840769*^9, 3.646371094455577*^9, 3.646372321274672*^9, 
  3.6463773477242813`*^9, 3.64638871796944*^9, 3.646734124503805*^9, 
  3.647076600246109*^9, 3.6473479946640787`*^9, 3.649403470879184*^9, 
  3.649404498026012*^9}],

Cell[BoxData["\<\"Authors: C. Degrande\"\>"], "Print",
 CellChangeTimes->{3.633334012398602*^9, 3.63334823479993*^9, 
  3.633430070827776*^9, 3.6337600047552557`*^9, 3.6337614288449593`*^9, 
  3.63376716963179*^9, 3.635683144036674*^9, 3.635760344048397*^9, 
  3.6376417854673986`*^9, 3.6376427809103813`*^9, 3.637648364508534*^9, 
  3.639388890816511*^9, 3.639989191172407*^9, 3.6405105028721447`*^9, 
  3.6414761840245857`*^9, 3.641540165251926*^9, 3.641635290546917*^9, 
  3.64172733228785*^9, 3.641790212336192*^9, 3.643025460613501*^9, 
  3.645272365875441*^9, 3.645273553311666*^9, 3.645274081217651*^9, 
  3.6452759224520473`*^9, 3.645770733219626*^9, 3.645780591417716*^9, 
  3.646026588840769*^9, 3.646371094455577*^9, 3.646372321274672*^9, 
  3.6463773477242813`*^9, 3.64638871796944*^9, 3.646734124503805*^9, 
  3.647076600246109*^9, 3.6473479946640787`*^9, 3.649403470879184*^9, 
  3.6494044980276537`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<~/Documents/feynrules-current_3_7/Models/DMsimp\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6333335430865088`*^9, 3.6333335552625504`*^9}, {
   3.633759553050228*^9, 3.633759553878661*^9}, {3.635681734336973*^9, 
   3.635681736612557*^9}, {3.637640417227786*^9, 3.6376404184754333`*^9}, {
   3.63937694796106*^9, 3.6393769493287563`*^9}, {3.6405100825800657`*^9, 
   3.640510083170496*^9}, 3.64051048875382*^9, {3.643018762649206*^9, 
   3.643018771597096*^9}, 3.643024946820489*^9, {3.645272373051367*^9, 
   3.645272374670525*^9}, {3.645274084493257*^9, 3.645274085716125*^9}, {
   3.645275926207169*^9, 3.645275927770879*^9}, 3.645770250485813*^9, 
   3.645770738860055*^9, {3.645780051087365*^9, 3.645780051727775*^9}, {
   3.646026265671403*^9, 3.6460262676920023`*^9}, {3.647076420208658*^9, 
   3.647076420403612*^9}, {3.647347800062046*^9, 3.647347801503477*^9}, {
   3.6494031514580183`*^9, 3.649403153218494*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteCT", "[", 
   RowBox[{
   "\"\<DMsimp_s_spin1/DMsimp_s_spin1\>\"", ",", "\"\<Lorentz\>\"", ",", 
    RowBox[{"Output", "->", "\"\<DMsimp_s_spin1\>\""}], ",", 
    RowBox[{"LabelInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"QCDOnly", "\[Rule]", "True"}], ",", 
    RowBox[{"KeptIndices", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"ZeroMom", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"aS", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"F", "[", "7", "]"}], ",", 
          RowBox[{"V", "[", "4", "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"F", "[", "7", "]"}]}]}], "}"}], ",", "0"}], "}"}], 
      "}"}]}], ",", 
    RowBox[{"ComplexMass", "\[Rule]", "False"}], ",", 
    RowBox[{"Exclude4ScalarsCT", "\[Rule]", "True"}]}], "]"}], "//", "Timing",
   " "}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQPYMtewWH0GvHXRNMV4Fo80cy6/mBtEqcHpjOWe+0
7AaQlnu0ZTmI5spYZNks9trxiDqHDYiWMzo9x17qtaPdu/0LQPSiH+51/bKv
HV+ZXKoH0VIPZreD6AuxP8C0ocS7CzvkXzu+UO6+DKK37FS0v6f42lH/QgqY
dp/YrMutBKRPHgTTXHrbH2oC6eWs58C0tRvj4UaV1446QtFgetVu9eMtQDro
0/UTIHqR4aobIHqO6w0wvXSy8u5zGq8dd3CU7QHR9ww6Hp8H0uxvLj4B0bXl
PxwPar52tDpzxQlEW2jt5ToGpNl45nCD6MzV35zttF47Kh2udAXRTt3snc+A
dLF3ezeInrFC8sV07deORaxdYNqkoL37sM5rx5b1k3tAdOvPJKX1Bq8d6+pP
K4Poh++cToNorr0WZ0F0yvSffv8Mge6vswoA0QCkOcJr
  "]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553243725*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045532451973`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
   "\[InvisibleSpace]", "\<\"generic\"\>", 
   "\[InvisibleSpace]", "\<\" model file \"\>", 
   "\[InvisibleSpace]", \
"\<\"/home/amartini/Documents/FeynArts-3.8/Models/Lorentz.gen\"\>"}],
  SequenceForm[
  "", "loading ", "generic", " model file ", 
   "/home/amartini/Documents/FeynArts-3.8/Models/Lorentz.gen"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553246505*^9}],

Cell[BoxData["\<\"> $GenericMixing is OFF\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553247777*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"generic model \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"Lorentz\"\>", "}"}], 
   "\[InvisibleSpace]", "\<\" initialized\"\>"}],
  SequenceForm["generic model ", {"Lorentz"}, " initialized"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553296049*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553298263*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\"\>", "\[InvisibleSpace]", "\<\"loading \"\>", 
   "\[InvisibleSpace]", "\<\"classes\"\>", 
   "\[InvisibleSpace]", "\<\" model file \"\>", 
   "\[InvisibleSpace]", \
"\<\"/home/amartini/Documents/FeynArts-3.8/Models/DMsimp_spin1/DMsimp_spin1.\
mod\"\>"}],
  SequenceForm[
  "", "loading ", "classes", " model file ", 
   "/home/amartini/Documents/FeynArts-3.8/Models/DMsimp_spin1/DMsimp_spin1.\
mod"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455329978*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" particles (incl. antiparticles) in \"\>", 
   "\[InvisibleSpace]", "28", "\[InvisibleSpace]", "\<\" classes\"\>"}],
  SequenceForm[
  "> ", 49, " particles (incl. antiparticles) in ", 28, " classes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553301166*^9}],

Cell[BoxData["\<\"> $CounterTerms are ON\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455334265*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "142", 
   "\[InvisibleSpace]", "\<\" vertices\"\>"}],
  SequenceForm["> ", 142, " vertices"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553344858*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> \"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\" counter terms of order 1\"\>"}],
  SequenceForm["> ", 48, " counter terms of order 1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045533464317`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"classes model \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "\<\"DMsimp_spin1/DMsimp_spin1\"\>", "}"}], 
   "\[InvisibleSpace]", "\<\" initialized\"\>"}],
  SequenceForm[
  "classes model ", {"DMsimp_spin1/DMsimp_spin1"}, " initialized"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455334781*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045533490353`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553350387*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 14 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "4 Generic, 14 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553390518*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 14 Classes insertions\"\>"}],
  SequenceForm["in total: ", "4 Generic, 14 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045533928347`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045533942327`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455339559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045533969383`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 0.122847\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553398198*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 0.122948\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553399487*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553400692*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553402022*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553403363*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045534046593`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045534058437`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553407221*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553408806*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 0.124861\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553410363*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 0.125172\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553411642*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
0.125217\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553412924*^9}],

Cell[BoxData["\<\"Vertices {S} finished after 0.125256\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553414236*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {F, F} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553415558*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045534168587`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553418173*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553419495*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 132 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 132 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553595544*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 132 Classes insertions\"\>"}],
  SequenceForm["in total: ", "2 Generic, 132 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553597793*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553644034*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553645858*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553688085*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455369004*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 0.430705\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455369156*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 0.647784\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553881002*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553929707*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045539311943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553973392*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045539751587`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045539766903`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553978033*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455397937*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553980667*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 0.735632\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404553981926*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 1.475086\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045547083607`*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
1.784426\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045550178213`*^9}],

Cell[BoxData["\<\"Vertices {F, F} finished after 1.784606\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045550197277`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555021202*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555022649*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555024004*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 22 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 22 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555065374*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"5 Generic, 64 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "5 Generic, 64 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455515385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"7 Generic, 86 Classes insertions\"\>"}],
  SequenceForm["in total: ", "7 Generic, 86 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555155428*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555195294*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555197115*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045551987467`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 1.938979\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555200151*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 1.939079\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555201481*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555202806*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555204183*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455520577*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555207265*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045552086067`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455520994*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045552112913`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 1.941966\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555212596*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 1.942187\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045552139883`*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
1.942227\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555215266*^9}],

Cell[BoxData["\<\"Vertices {S, S} finished after 1.942305\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045552165422`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455521791*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555219211*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555220517*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 31 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 31 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045552219*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"5 Generic, 203 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "5 Generic, 203 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555476789*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"7 Generic, 234 Classes insertions\"\>"}],
  SequenceForm["in total: ", "7 Generic, 234 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555478739*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455553301*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555534536*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555574951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 44 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "3 Generic, 44 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555618717*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 45 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "4 Generic, 45 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045556212797`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 2.364240\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404555623518*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 3.059524\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556292832*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556351969*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556353561*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556355248*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940455635669*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556358218*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556359747*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556361322*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045563630857`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 3.133733\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404556404069*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 3.850974\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404557084209*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
4.250908\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404557484192*^9}],

Cell[BoxData["\<\"Vertices {V, V} finished after 4.251051\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404557485977*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {F, F, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404557487528*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404557488975*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045574903393`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 468 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "6 Generic, 468 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561284169*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561315208*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561316847*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561318756*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 468 Classes insertions\"\>"}],
  SequenceForm["in total: ", "6 Generic, 468 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045613203287`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561398218*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045613998117`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 8 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 8 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561441625*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 8 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 8 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561443529*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 8.186835\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561445065*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 8.227004\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561487011*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561488821*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561490615*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 8 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 8 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561492158*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 8 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 8 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561493588*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561494931*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561496471*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 8 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 8 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561498082*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 8 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 8 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561499814*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 8.277468\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561541314*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 8.486049\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561719503*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
8.577247\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561810687*^9}],

Cell[BoxData["\<\"Vertices {F, F, S} finished after 8.577424\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561812234*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {F, F, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561813795*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404561815138*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045618165817`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 916 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "6 Generic, 916 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568036396*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568074679*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940456807705*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045680787086`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 916 Classes insertions\"\>"}],
  SequenceForm["in total: ", "6 Generic, 916 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568080164*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045683709707`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568372891*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 160 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "3 Generic, 160 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568648533*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 160 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "3 Generic, 160 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568650158*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 15.431086\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568688504*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 15.709282\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404568942801*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404569190112*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045691917353`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 68 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 68 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045692295227`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 68 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 68 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404569231703*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404569233157*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404569234769*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 68 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 68 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045692822857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 68 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 68 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404569283842*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 16.158923\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404569392414*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 18.520586\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940457175406*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
19.375806\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045726093473`*^9}],

Cell[BoxData["\<\"Vertices {F, F, V} finished after 19.376426\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404572611164*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404572612823*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404572614271*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404572615786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 1861 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 1861 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404575658085*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 83 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 83 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404575913735*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 83 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "2 Generic, 83 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045760944147`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 83 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 83 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404576292109*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"16 Generic, 2110 Classes insertions\"\>"}],
  SequenceForm["in total: ", "16 Generic, 2110 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045763414288`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404576958024*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940457695991*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 507 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "3 Generic, 507 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940457787913*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404577923938*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404577925827*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404577927701*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"6 Generic, 510 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "6 Generic, 510 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494045779292793`*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 24.722895\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404577973978*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 156.943737\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710177348*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710235854*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710237863*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710239539*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047102410994`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047102426662`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710244255*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047102460213`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710248122*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 157.026868\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404710291153*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 159.852123\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404713085641*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
160.478395\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404713712138*^9}],

Cell[BoxData["\<\"Vertices {V, V, V} finished after 160.478998\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047137146797`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404713717102*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404713719264*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404713721765*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 729 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 729 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047154818163`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 89 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 89 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404715590074*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 89 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 89 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404715694914*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 56 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 56 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047158256817`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"14 Generic, 963 Classes insertions\"\>"}],
  SequenceForm["in total: ", "14 Generic, 963 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047158745813`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716107876*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047161104183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 36 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 36 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940471619405*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 36 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 36 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716195929*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 162.966929\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047162378817`*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 163.127803\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940471636134*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047164049273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047164067163`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047164090776`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716410781*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047164123287`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716413888*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716415412*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 163.133938\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047164169483`*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 163.153896\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047164187*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
163.161853\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716421035*^9}],

Cell[BoxData["\<\"Vertices {V, V, S} finished after 163.162031\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716423502*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716425412*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716427001*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404716428589*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 588 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 588 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047176593103`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 48 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 48 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940471778406*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 86 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 86 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404717887373*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 86 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "1 Generic, 86 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404717995791*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"14 Generic, 808 Classes insertions\"\>"}],
  SequenceForm["in total: ", "14 Generic, 808 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404717998502*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047182150297`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404718216735*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940471826581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 12 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 12 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404718267797*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 165.009942\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404718269371*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 179.757436\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047329912043`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404732993681*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047329962893`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404732998763*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047330011787`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733003743*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940473300618*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733008988*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 179.762084\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047330110483`*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 179.762433\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733012513*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
179.762507\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733014002*^9}],

Cell[BoxData["\<\"Vertices {V, S, S} finished after 179.762694\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733015902*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {S, S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733017509*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733018936*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404733020524*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"10 Generic, 520 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "10 Generic, 520 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734114705*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 54 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 54 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734231189*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 54 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "2 Generic, 54 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047343438683`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 54 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 54 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940473445857*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"16 Generic, 682 Classes insertions\"\>"}],
  SequenceForm["in total: ", "16 Generic, 682 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734460507*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734640451*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047346422663`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734643897*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 181.407720\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734645455*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 181.407832\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734647394*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047346489363`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734651039*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047346531057`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940473465633*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734658499*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734660386*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734661998*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 181.410899\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734663588*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 181.411151\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734665051*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
181.411197\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734666535*^9}],

Cell[BoxData["\<\"Vertices {S, S, S} finished after 181.411314\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734668009*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, V, V} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047346695757`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734711883*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" field point(s) (incl. charge-conjugate \
ones)\"\>"}],
  SequenceForm[
  "Excluding ", 14, " field point(s) (incl. charge-conjugate ones)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047347137012`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734715169*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404734716786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 677 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 677 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404736005454*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 677 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 677 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047373467283`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 677 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "2 Generic, 677 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404738672555*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 677 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 677 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404740021267*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 677 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 5, ": ", "2 Generic, 677 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494047413529053`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 677 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 6, ": ", "2 Generic, 677 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404742676086*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 6263 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 7, ": ", "4 Generic, 6263 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404758544491*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 6263 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 8, ": ", "4 Generic, 6263 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404774367918*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 6263 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 9, ": ", "4 Generic, 6263 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404792137575*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 409 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 10, ": ", "2 Generic, 409 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404792958478*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 409 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 11, ": ", "2 Generic, 409 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404793779251*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 409 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 12, ": ", "2 Generic, 409 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404794598016*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404794599712*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" field point(s)\"\>"}],
  SequenceForm["Restoring ", 14, " field point(s)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404794601461*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"30 Generic, 24078 Classes insertions\"\>"}],
  SequenceForm["in total: ", "30 Generic, 24078 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404794711789*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404804616252*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404804618697*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048066366053`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404806688724*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404806691845*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404806694996*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 5, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404806697603*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 6, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940480669925*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 2943 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 7, ": ", "3 Generic, 2943 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404812480259*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 2943 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 8, ": ", "3 Generic, 2943 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404818175743*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 2943 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 9, ": ", "3 Generic, 2943 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404823940118*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 10, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048239916897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 11, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404823994047*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 12, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404823996084*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"18 Generic, 8838 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "18 Generic, 8838 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404824039693*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 271.447066\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404824680655*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 283.372856\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404836606719*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048374022093`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404837404664*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404837406901*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes insertions\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048374101543`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940483741393*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048374175262`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404837420114*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 1 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "1 Generic, 1 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048374228983`*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 284.189236\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404837424752*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 336.755848\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404889989447*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
341.434091\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048946677637`*^9}],

Cell[BoxData["\<\"Vertices {V, V, V, V} finished after 341.434402\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048946696377`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing CT for the {V, V, S, S} vertices.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[0, 0, 1],
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404894671412*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404894714813*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Excluding \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" field point(s) (incl. charge-conjugate \
ones)\"\>"}],
  SequenceForm[
  "Excluding ", 14, " field point(s) (incl. charge-conjugate ones)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404894716823*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404894718912*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404894721065*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 360 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "2 Generic, 360 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404895557143*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 564 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "2 Generic, 564 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048967403812`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 564 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "2 Generic, 564 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494048979354973`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 564 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 4, ": ", "2 Generic, 564 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404899180235*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 564 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 5, ": ", "2 Generic, 564 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404900358073*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 564 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 6, ": ", "2 Generic, 564 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049017700253`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 1098 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 7, ": ", "4 Generic, 1098 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404906635358*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 1098 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 8, ": ", "4 Generic, 1098 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049115199337`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"4 Generic, 968 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 9, ": ", "4 Generic, 968 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049152736263`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"2 Generic, 232 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 10, ": ", "2 Generic, 232 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404915793064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 354 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 11, ": ", "1 Generic, 354 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049162039843`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 354 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 12, ": ", "1 Generic, 354 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404916608665*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404916611044*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Restoring \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" field point(s)\"\>"}],
  SequenceForm["Restoring ", 14, " field point(s)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404916613372*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"28 Generic, 7284 Classes insertions\"\>"}],
  SequenceForm["in total: ", "28 Generic, 7284 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049166602182`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049191728363`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404919175247*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 100 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "1 Generic, 100 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404919425619*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 100 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 2, ": ", "1 Generic, 100 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404919611506*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"1 Generic, 100 Classes amplitudes\"\>"}],
  SequenceForm["> Top. ", 3, ": ", "1 Generic, 100 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404919816181*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"3 Generic, 300 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "3 Generic, 300 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404919818019*^9}],

Cell[BoxData["\<\"Writing amplitude finished after 366.666482\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049199003363`*^9}],

Cell[BoxData["\<\"Writing the R2 and UV parts at the class level finished \
after 366.890183\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049201239777`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940492016367*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"inserting at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm["inserting at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920165999*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"> Top. \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920167856*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes insertions\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes insertions"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940492016957*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920171206*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"creating amplitudes at level(s) \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"Generic", ",", "Classes"}], "}"}]}],
  SequenceForm[
  "creating amplitudes at level(s) ", {Generic, FeynArts`Classes}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920173149*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"in total: \"\>", 
   "\[InvisibleSpace]", "\<\"0 Generic, 0 Classes amplitudes\"\>"}],
  SequenceForm["in total: ", "0 Generic, 0 Classes amplitudes"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920175251*^9}],

Cell[BoxData["\<\"Writing the symbolic CT finished after 366.905177\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920176873*^9}],

Cell[BoxData["\<\"SU3 algebra finished after 366.950863\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920216515*^9}],

Cell[BoxData["\<\"Simplification of the vertices finished after \
366.958674\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049202190723`*^9}],

Cell[BoxData["\<\"Vertices {V, V, S, S} finished after 366.958896\"\>"], \
"Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.64940492022095*^9}],

Cell[BoxData["\<\"before merge 366.965908 temp=62.257851\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049202227716`*^9}],

Cell[BoxData["\<\"merging done 366.996872\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920263136*^9}],

Cell[BoxData["\<\"Writing R2 and UV counterterms from \
DMsimp_spin1/DMsimp_spin1 and Lorentz in DMsimp_spin1.nlo\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.6494049203342333`*^9}],

Cell[BoxData["\<\"done\"\>"], "Print",
 CellChangeTimes->{3.64673416601022*^9, 3.647076613520582*^9, 
  3.6473480021180143`*^9, 3.649403484993147*^9, 3.649404920385399*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "369.25389999999998735802364535629749298096`8.587925004235947", ",", 
   "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.646734471449627*^9, 3.6470768947501574`*^9, 
  3.647348337525042*^9, 3.64940386211159*^9, 3.649404920430368*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.645276376306346*^9, 3.6452763777860003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<~/Documents/feynrules-current_3_7\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.633334333718008*^9, {3.643018789753442*^9, 3.643018791330467*^9}, {
   3.645272799947063*^9, 3.645272801466074*^9}, {3.647076435500992*^9, 
   3.6470764362644157`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953644567*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.7\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 July 2015\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.7", " (" "27 July 2015", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953669344*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953671152*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.6494049536731453`*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953675169*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.64940495367737*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.6494049536790323`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953680554*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953682172*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.6494049536836653`*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.63333440695919*^9, 3.633348560486579*^9, 3.633430677253861*^9, 
   3.633760418806879*^9, 3.63376190797229*^9, 3.633768111788323*^9, 
   3.635683611528593*^9, 3.6356836827698507`*^9, 3.635683881621481*^9, 
   3.635683982036408*^9, 3.635760784410219*^9, 3.637643143830041*^9, 
   3.637647371947709*^9, 3.637648748372431*^9, 3.639389302649088*^9, 
   3.639989579315937*^9, 3.640510872486952*^9, 3.6405110246358852`*^9, 
   3.641476655652068*^9, 3.641540959401083*^9, 3.641635756491544*^9, 
   3.64172791075239*^9, 3.641790915266135*^9, 3.643025908027935*^9, 
   3.645272805937785*^9, 3.645273958562047*^9, 3.645274476314858*^9, 
   3.645276384688925*^9, 3.645276428285972*^9, {3.645771178582847*^9, 
   3.645771189688349*^9}, 3.6457812303151407`*^9, 3.646027078285276*^9, 
   3.6463715419184523`*^9, 3.646373035858588*^9, 3.6463776699247293`*^9, 
   3.646390127999592*^9, {3.646734483394376*^9, 3.646734527476392*^9}, 
   3.647076944542347*^9, 3.647348353200954*^9, 3.649404147951804*^9, 
   3.649404953685349*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/DMsimp\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.633333653355482*^9, 3.633333654140135*^9}, {
   3.633759508925624*^9, 3.633759509782259*^9}, {3.6356817782298527`*^9, 
   3.63568178057517*^9}, {3.637643151097705*^9, 3.637643157090357*^9}, {
   3.639376969362584*^9, 3.639376970805305*^9}, {3.640510133439883*^9, 
   3.640510134052121*^9}, {3.64301879488282*^9, 3.6430187955340557`*^9}, 
   3.6430249807051477`*^9, {3.645273962622952*^9, 3.6452739639072227`*^9}, {
   3.645276394612421*^9, 3.645276395972137*^9}, 3.6457702767154827`*^9, {
   3.6457800697087383`*^9, 3.645780069903144*^9}, {3.646026301430621*^9, 
   3.646026303553194*^9}, {3.64734782249478*^9, 3.6473478235665007`*^9}, {
   3.6494031754789267`*^9, 3.649403176983906*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{
  "\"\<SM.fr\>\"", ",", "\"\<dm_s_spin1.fr\>\"", ",", " ", 
   "\"\<dm_s_spin1_ew.fr\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.6333336630998907`*^9, 3.633333666934019*^9}, {
   3.6337595144873743`*^9, 3.633759515254868*^9}, {3.635681785377611*^9, 
   3.635681787678496*^9}, {3.6376404775561666`*^9, 3.637640487932433*^9}, {
   3.63764316147395*^9, 3.637643161943272*^9}, 3.6430249837647533`*^9, {
   3.645273967364667*^9, 3.645273969067214*^9}, {3.6452764011648684`*^9, 
   3.645276411381513*^9}, {3.645770280750688*^9, 3.645770280968597*^9}, {
   3.646026307411837*^9, 3.64602630943712*^9}, {3.647347826971569*^9, 
   3.6473478280586557`*^9}, {3.6494031824564037`*^9, 3.649403201047883*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960075787*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960107028*^9}],

Cell[BoxData["\<\"A. Martini, K. Mawatari, J. Wang, C. Zhang\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960108989*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960110921*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.6494049601125183`*^9}],

Cell[BoxData["\<\"O. Mattelaer et al., arXiv:1508.00564\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960114118*^9}],

Cell[BoxData["\<\"M. Backovic et al., arXiv:1508.05327\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960115747*^9}],

Cell[BoxData["\<\"M. Neubert et al., arXiv:1508.xxxxx\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.6494049601175137`*^9}],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/DMsimp/\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960119751*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960122568*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960124247*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.6494049601259212`*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.6494049602679358`*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.649404960319577*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"DMsimp_s_spin1\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "DMsimp_s_spin1", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6452764346338987`*^9, 3.645771194596031*^9, 3.6457812380315657`*^9, 
   3.6460270859885817`*^9, 3.646371548105691*^9, 3.6463730452682457`*^9, 
   3.646377677162462*^9, 3.6463901333396072`*^9, {3.646734490207191*^9, 
   3.646734532719462*^9}, 3.6470769500669947`*^9, 3.647348359189395*^9, 
   3.649404155388818*^9, 3.6494049603732243`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless_5f.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.639989591485811*^9, 3.639989593069509*^9}, {
  3.64154097216433*^9, 3.641540974684147*^9}, {3.6417909255941687`*^9, 
  3.6417909297310133`*^9}, {3.643025203788245*^9, 3.643025206111291*^9}, {
  3.645276440101756*^9, 3.645276449127439*^9}, {3.645780074961405*^9, 
  3.645780076352491*^9}, {3.6463776813917847`*^9, 3.646377688991543*^9}, {
  3.646465430675503*^9, 3.6464654368223667`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6334306848130302`*^9, 3.633760429152564*^9, 3.633761916024652*^9, 
   3.633768120147912*^9, 3.6356836192767067`*^9, 3.63568369175706*^9, 
   3.6356839326067247`*^9, 3.635683989102797*^9, 3.635760791879394*^9, 
   3.6376431668304768`*^9, 3.637647380992176*^9, 3.637648756419928*^9, 
   3.639389312685671*^9, 3.639989602876381*^9, 3.6405108810467577`*^9, 
   3.640511031933874*^9, 3.64147666589777*^9, 3.641540977305107*^9, 
   3.641635769894772*^9, 3.641727918705084*^9, 3.641790931402239*^9, 
   3.643025920128963*^9, 3.645272819582477*^9, 3.645273976685206*^9, 
   3.6452744918051853`*^9, {3.6452764455565166`*^9, 3.645276449911216*^9}, 
   3.645771197671864*^9, 3.64578124125686*^9, 3.646027089730276*^9, 
   3.6463715521531687`*^9, 3.646373048024355*^9, 3.6463776916950293`*^9, 
   3.646390137024032*^9, {3.6467345152009907`*^9, 3.646734535311812*^9}, 
   3.6470769522530413`*^9, 3.647348361642148*^9, 3.649404158128687*^9, 
   3.649404964394639*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless_5f.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "21"}],
  SequenceForm["Loading restrictions from ", "Massless_5f.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 21],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6334306848130302`*^9, 3.633760429152564*^9, 3.633761916024652*^9, 
   3.633768120147912*^9, 3.6356836192767067`*^9, 3.63568369175706*^9, 
   3.6356839326067247`*^9, 3.635683989102797*^9, 3.635760791879394*^9, 
   3.6376431668304768`*^9, 3.637647380992176*^9, 3.637648756419928*^9, 
   3.639389312685671*^9, 3.639989602876381*^9, 3.6405108810467577`*^9, 
   3.640511031933874*^9, 3.64147666589777*^9, 3.641540977305107*^9, 
   3.641635769894772*^9, 3.641727918705084*^9, 3.641790931402239*^9, 
   3.643025920128963*^9, 3.645272819582477*^9, 3.645273976685206*^9, 
   3.6452744918051853`*^9, {3.6452764455565166`*^9, 3.645276449911216*^9}, 
   3.645771197671864*^9, 3.64578124125686*^9, 3.646027089730276*^9, 
   3.6463715521531687`*^9, 3.646373048024355*^9, 3.6463776916950293`*^9, 
   3.646390137024032*^9, {3.6467345152009907`*^9, 3.646734535311812*^9}, 
   3.6470769522530413`*^9, 3.647348361642148*^9, 3.649404158128687*^9, 
   3.649404964545706*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{
  3.6334306848130302`*^9, 3.633760429152564*^9, 3.633761916024652*^9, 
   3.633768120147912*^9, 3.6356836192767067`*^9, 3.63568369175706*^9, 
   3.6356839326067247`*^9, 3.635683989102797*^9, 3.635760791879394*^9, 
   3.6376431668304768`*^9, 3.637647380992176*^9, 3.637648756419928*^9, 
   3.639389312685671*^9, 3.639989602876381*^9, 3.6405108810467577`*^9, 
   3.640511031933874*^9, 3.64147666589777*^9, 3.641540977305107*^9, 
   3.641635769894772*^9, 3.641727918705084*^9, 3.641790931402239*^9, 
   3.643025920128963*^9, 3.645272819582477*^9, 3.645273976685206*^9, 
   3.6452744918051853`*^9, {3.6452764455565166`*^9, 3.645276449911216*^9}, 
   3.645771197671864*^9, 3.64578124125686*^9, 3.646027089730276*^9, 
   3.6463715521531687`*^9, 3.646373048024355*^9, 3.6463776916950293`*^9, 
   3.646390137024032*^9, {3.6467345152009907`*^9, 3.646734535311812*^9}, 
   3.6470769522530413`*^9, 3.647348361642148*^9, 3.649404158128687*^9, 
   3.649404964656404*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Get", "[", "\"\<DMsimp_s_spin1.nlo\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.633333679844839*^9, 3.633333682243373*^9}, {
   3.633759573989903*^9, 3.633759574813645*^9}, {3.635681792889392*^9, 
   3.635681794928862*^9}, {3.6376404988908873`*^9, 3.637640502843729*^9}, {
   3.6393769763154087`*^9, 3.6393769775307503`*^9}, {3.640510140072566*^9, 
   3.640510141779975*^9}, {3.643024989253413*^9, 3.6430249909315453`*^9}, {
   3.643025070685824*^9, 3.643025074221505*^9}, {3.6452739791542587`*^9, 
   3.64527398039443*^9}, {3.645276453474934*^9, 3.645276454803453*^9}, 
   3.645770286391513*^9, {3.6457800800957413`*^9, 3.645780080471368*^9}, {
   3.646026321042013*^9, 3.646026322988809*^9}, {3.647347834625543*^9, 
   3.647347835975219*^9}, {3.649403214712672*^9, 3.649403216153846*^9}, {
   3.649404967303237*^9, 3.649404968446651*^9}, {3.6494082744264297`*^9, 
   3.649408274795074*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "L1DM", "+", "L1SMEW"}], ",", 
   RowBox[{"UVCounterterms", "\[Rule]", "UV$vertlist"}], ",", 
   RowBox[{"R2Vertices", "\[Rule]", "R2$vertlist"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<DMsimp_s_spin1\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.603600645725746*^9, 3.6036006566228743`*^9}, {
   3.606550334098661*^9, 3.60655033664305*^9}, {3.608451188889968*^9, 
   3.608451204251935*^9}, 3.60845124249209*^9, {3.633332357749588*^9, 
   3.633332371706971*^9}, {3.633333594923254*^9, 3.6333336099891357`*^9}, {
   3.633333692998436*^9, 3.633333708244873*^9}, {3.633759523248143*^9, 
   3.63375952406321*^9}, 3.6337595816874228`*^9, {3.633759861480113*^9, 
   3.633759861782745*^9}, {3.635681799753024*^9, 3.635681812948553*^9}, {
   3.637640540300961*^9, 3.6376405694259853`*^9}, {3.637640663087901*^9, 
   3.637640663759862*^9}, {3.637647387697893*^9, 3.637647389712125*^9}, {
   3.637648387110936*^9, 3.637648387849903*^9}, {3.639389319458922*^9, 
   3.639389319865039*^9}, {3.64051094238649*^9, 3.640510950609267*^9}, {
   3.6430250002334414`*^9, 3.643025002692279*^9}, {3.643025047978877*^9, 
   3.643025060082522*^9}, {3.6452745024778748`*^9, 3.6452745079012833`*^9}, {
   3.645276460101131*^9, 3.645276462419408*^9}, 3.645770304766233*^9, {
   3.64578008286651*^9, 3.6457800832087*^9}, {3.646026325649763*^9, 
   3.646026327751546*^9}, {3.647347838972896*^9, 3.6473478401093903`*^9}, {
   3.64940322069949*^9, 3.6494032361730423`*^9}, {3.650089615748787*^9, 
   3.650089616233056*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmjUMhhMKXJQWCIwK9vcWsQTLS1WNk3Wx1ZNpWVrs9Yi
cZTWMq0xcxjBaiajLmrlwLGs4MpsQSuEykoTtNQC/2+JY5ZrttHzenH2uzgX
ZzuSqrpyw6KMjAwdxqE87SofZkDm7DQeRn96NX8mRhgo5E2nUqMMlO7pOaUZ
Z+DeubnL1DHHTjc1XS8JLTiVU1mNxvqfJqi6ror7BtRqqFIeR38F5rM60Lfs
CwIqT8CSUhs7eka6vzOg1hYkqbe/Hgr2oieun33ZGGcg+4kl6xIq9f5dQ61R
nAHqsXRoF9Uorm2h3jlgq7yKXjNPmn0p7BnnHNUngyY/OpuwRDdlEvC1d+V/
YxMo0nSqqJ/eNL/OW0zg1gp+qxwdZ8W+NKDbvSa/aBmBHfwIj8Mj8GBVGX8J
enIsNL8cHUp8FBSjJWK3cBh13TBGqEKVYCiKmu82ya4ICWzM9aiobcJABbV1
0jn4EFVvFv3WiAi8iK/M1KKJI1o31RawW21iAgPvQ92+1QSW7pspep6Lu9zi
rQuG+0qo5mltsF1CwB2OqzyolVNdP4paFKzzXCmBYKRsixxta2BD81oCaZP+
6MB6AvsP/tsQRvf6JXkR1FQ79qwvH3/RzXa9Qi/u1j9SywnUfObHfqD6D3Z7
HG1ZVxadQutKWTNJdHDeleMoIBBSPtZtUxAonki+60e5vTdd7kICDbFsjgf9
D8hON8s=
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0FtM0mEYBnBijmjUMhgsKXJQWqIwK9vYWsQbLS1WNE3XYR3moWVrs8My
cZTWMq0xcxjBagqjLmrlwLGs8MpsYSuEykoTpNQC/1+JY5ZrtNH7efHsd/Fc
PNsjLa8prlrAYrF0GJvitLN4hIEsR0ftIfSnR/NnYpSBfP50IjHGQNHu7lOa
cQbunZ+7Qo3YdrioqTqpf96pjNIKNNz/NEbV2UvuV6HmqnLFcfSXL5nejr7l
XBRS+UK2jNrQ3j3a9Z0BtTY3Tr3z9eBAD3rixrmXDVEGlj8xpV9GZZ6/q6mV
eWeAeizl30mtlVQ3U+/ut5ReQ68bJ43eBPaMY47qzYLGXnQ2ZgptTCPgbbPn
fOMQKNB0KKmf3jS9zl5I4PYyQYscHWeHv9Sj2zyGXvESAtsFQT6XT+DBSr1g
EXoy4k8uRYdjH4UqtFDiEo2gzpu1QapIKRwOocbOxqyrIgIbMt1KaqvIV0Jt
mXQMPUTVm8S/NWICL6Ir0rRo7IjWRbX4rGaLhMDge3+XdxWBxXtnCp5n4i5P
tWXeQF8h1TitHWiTEnAFoko3auZW1I2hpjz2BZ6MwEBQv1mOttZzoGkNgZSh
7OjgOgL7DvxbH0D39Eqzg6ihOvKsLwd/0c3aX6GXdpU9UssJVH4WhH+gZR+s
1ijavFYfmkJritgzcXQo6cyw5RLwKx7rtuYRUE3E3/WjvJ5bTlc+gbOHpVw3
+h/ExDdM
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmjUMhgsLXJQWCowK9vYWsQTLS1WNE3Wx1ZNpaVrs9Yi
cZTWMq05cxjBagajLmrlwLms8MpsQSuEykpTpNQC/2+JY5ZrtNHzenH2uzgX
ZzuSitpS4yIWi6XDOBSn3aUjDMhcnaYj6M8ezZ/JUQYK+TPJ5DgDJXu7T2km
GLh3bv4yNerY5aGm6yTBBaezyivRyMDTOFXnLLtvRK3GCsUJ9Jc/ldmBvuVc
EFL5QraU2tDRPdr1nQG1tiBBvf31cKAXPXn97MuGGAMrn7RmXkKlPX/XUqvk
Z4B6PB3cTTWJq5updw7ayq+i1yxTFl8Se8Y1T/XJoLEPnYu3jm3OIOBrd+Z9
4xAo0nQqqZ/eNL3OXUzg1gpBSz46wY58qUd39Jj7spcR2CkI87l8Ag9W6wVL
0JpoMLUcHY5/FKrQYrFHNIK6b5jCVJFSODyGWu42yq6ICGzK8SqpbSJ/GbVl
yjX0EFVvyf6tySbwIrYqQ4vGj2o9VJvfbrWJCQy+D3b51hBYun+26HkO7vJU
2xYM9RdTLTPaQLuEgCcUU3pRK7eybhxtlbPP86QEAmH91ny0rZ4DTesIpM2G
Y4MbCBw49G9jCN3XJ8kNo+bq6LP+PPxFN+d8hV7cY3ikzidQ9VkQ+YEaPtjt
MbR5vX5sGq0tYc8m0KGUO8tRQCCoeKzbLiegmky8G0B5vTfdnkICshoJ14v+
B8K3Nww=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmjWMhgsKXNQWCIwK9vYWsYTLS2WNk3Wx1ZNpWVrM9ci
cZTWMq0xcxrBaiajLmrlwLGs4MpsQSuEysoPlFIL/L8ljlmu0UbP68XZ7+Jc
nO2IK2vL9EtYLJYWY1OcdZSNMCC1dxmOoj/d6j9TYwzk82YTiQkGivf3nlFP
MnD//MIVasS2x0lN1YsDi85kVlSh4wPPYlRtd/kDPdqhr1ScRH/5khmd6DvO
RQGVJ2BLqI2dvWM93xko1OTFqXe+HvH3oadunHvVGGVg9VNzxmVU4v67nlot
rwPqiVRgL9WQVdNCvXvIUnENvW6aNnkS2DP2BapHCk1edD5mDm9NI+Bp7879
xiFQoO5SUj+/bX6Ts5TA7VX8Vhk6yR4fbUB3uY1e0QoCu/khHpdH4OHaUv4y
9HQkkFyJDsc+CVRoUZZTOII6bhpCVKFSMBxGTfeapFeFBLZku5TUNqGvnNo6
bR96hBZuE/1Wiwi8jK5J06CxYxon1eKzdliyCAx+CPR41hFYfmCu4EU27qar
diwa7C+immY1/nYxAWcwqnShHdyq+gnULGdfSJcQ8IdKt8vQtgYONG8gkDLq
jg9uInDw8L/NQbTEK84JocaayPP+XPxFO9/9Gr20T/e4UEag+gt//Aeq+2i1
RtGWjaXhGbS2mD0XR4eSjkxbHoGA4ol2p5yAair+fgBN77vlcOYTGK0Tc13o
f8iQN8g=
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmj0YTBYUuTAsPyAWdnG1iKeaGkxo2myPrZqKi1bm7UW
qaO0lmmNmcMIVjMddVErB45lBVdmC1qhVFYaIKUW+H9LnLNcs42e14uz38W5
ONuRVtSUGhexWCwdxqE47SwdYUDe1WE6jP70aP6Mhxko4E/NzIwyUFzSc0oz
xsC9c3OXqTHHLhc1VSsNLjiZUV6JRvufJqi6zrL7RtRqrFAcR3/559Pb0bec
C0IqX8iWURvae8Ld3xlQa/OS1NtfDwV60RPXz75siDOw6okl/RIq8/zNolbl
nwHqsVRwN9UkqW6m3jlgK7+KXjNPmL0z2DNdc1SvHBp96GzCEtmcRsDb1pnz
jUOgUNOhpH560/Q6ezGBWysFLbnoGDv6pR7d4anziZcR2CkI8bl8Ag/W6AVL
0JOx4PwKdDjxUahCiyQu0QjqvGEKUUVK4XAENd9tlF8REdiU6VZSW0X+MmrL
RNfQQ1S9RfxbIybwIr46TYsmjmhdVJvfbrVJCAy8D3Z71xJYum+68Hkm7vJU
2xYc7Cuimqe0gTYpAddgXOlGrdzK2lHUks8+z5MRCIT0W3PR1noONK0jkKoz
HB3YQGD/wX8bB9G9Pml2CK2rjj3ry8FfdLOdr9CLewyP1LkEqj4Loj9Qwwe7
PY42r9dHJtGaYvZ0Eh2ad2Y48ggEFY912/MJqMaT7/pRXu9Np6uAwPKsMNeN
/gfEajdo
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "119", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "119", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  119, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 119, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmjUMhgsLXJQWKIwK9vYWsYTLS1WNE3Wx1ZNpWVrs9Yi
cZTWMq0xc5jhaiajLmrlwLGs4MpsQSuEykoTpJQC/2+JMcs12uh5vTj7XZyL
sx1xVV25fkFGRoYG0yU/ZS8fZUBq6zYcQn+4VH8mxxgo4k0nk+MMlO3uO6ma
YODu2blL1EjXDgc1XS/2zzuVXVmNhgefxKmanop7etSir5IfQ396U1kd6Bv2
eQGVJ2BJqI0dfWO93xgoURckqLe+HPT1o8evnXnRGGNg+WNz1kVU4vq7mlpT
eBqoR9P+nVSDqLaFent/Z+UV9KopanInsWdsc1S3FJo86GzcHNqYScDd3pP/
lU2gWNWtoH583fwqbyGBm8v4rTJ0ghX+3IBucxk9OUsIbOcHeRwegfsrtfxF
6ImIP7UUHYl/ECjRUpFDOIrarxuCVKFCMBJCTXeapJeFBDbkOhXUNqG3gtoa
tQ0/QEs25fxW5RB4HluRqUbjh9UOaqfXaukUERh65+91ryKweO9M8bNc3OUq
t8wbGCilmqbVvnYxAUcgpnCiFk51/ThqLmSd40oI+ILazTK0rYENzWsIpI26
I0PrCOw78G99AN3jEecFUWNt5OlAPv6ime15iV7YpXtYIiNQ84kf/o7q3lut
MbRlrTY0hdaVsWYS6HDKnt1VQMAvf6TZWkhAOZl4O4hy+2/YHUUEfkVDHCf6
H9DPOQ0=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"114", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[114, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBfA1ZCkrso2NXC3ZaqZzDiuDQbT2tEhr5EJz9AEZ6iIjsIjM
yUqLTIthoq2NxByri6JkE8lqXpnRFjW3ykrTuVJr8/+Wk2FJLFjP68Xhd3Eu
DhxJRU2JcRmLxdJh7HlnnCVjDMgcXbVH0Z99mj/T4wzk8+bi8UkGivb3ntZM
MXDv/OIVati+x0VN1kn8S85mlFWioaGnUaquu/S+EW03VuSdQH95E+kd6FvO
RQGVJ2BLqQ0dveM93xlQa3Nj1Dtfj/j60ZM3zr1siDCw5okl/TIq7fu7gVql
OAvU40n/XmqtuLqZ2nnIWnYNvW6eMXvi2DOORapHBo0D6ELUMrE1hYCnrTvn
G4dAgaZLSf30pul11nICt1fzW+ToFDv0pR7d1WcaEK0ksJsf5KXyCDxYp+en
oafC/sQqdDT6UaBCC8Uu4RjqvFkbpAqVgtEJ1Hy3UXZVSGBLpltJbRV6S6kt
M46Rh6h6m+i3RkTgRWRtihaNHtO6qFavrd0qJjD83t/jWU9gxYH5gueZuMtV
7VgyMFhINc9pfW0SAq5AROlG21Mr6yZRi4J9gSsl4Avqt8vR1noONG0kkDQZ
yoezCRw8/G9zAC0ekGQFUVN1+NlgDv6iW+h+hV7aZ3iklhOo+swP/UANH2y2
CNq8ST8xi9YUsedj6EjCmWHPJeDPe6zbqSCgmo69G0K5/becrnwC2Z3laW70
P8WfN38=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "167"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 4, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 167],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEUBnBijkxrGQyWFDkoLBGYlW1sLeJES4sVTZP1sWVTadnarLVI
HKW1TGvMnEawmsGoi1o5cCwruDJb0gqhstIULbXA/1vqmOUabXReL85+F8/F
8+yIK2pKjItYLJYOz6E47S4ZYkDq6jAdQX/6NH8mhhko4E4nEqMMFO/tOqUZ
Z+DeufnL1DHHLg81VSsOLTiVXVaJRnufxqk6Z+l9I9pmrFAcR3/1JbPa0bec
C3wql8+WUOvbu4Y7vzOg1ubPUG9/PRzsRk9cP/uyPsbAyifWrEuoxPd3LbVK
fgaox1Kh3VSTqLqJeuegrewqes0yafEnMGdc81S/FBoC6FzcOrI5jYC/1Zn3
jUOgUNOhpH560/g6dzGBWyt4zTJ0nB39Uofu8JkDwmUEdvIi3HQugQer9bwl
6MmxUHI5Ohj/yFehRSKPYAh13zBFqAIlf3AEtdxtkF4RENiU41VSWwR9pdTm
SdfAQ1S9RfhbIyTwIrYqTYvGj2o9VFufvc0mItD/PtTpX0Ng6f7Zwuc52Jup
2rZguKeIapnWBlvFBDzhmNKLtqVX1o6iVjn7fKaEQDCi3ypDW+o40LiOQMps
KO/fQODAoX8bw+i+gDg3gpqrx5715OFfdHPOV+jFPYZHahmBqs+86A/U8MFu
j6FN6/UjU2hNMXt2Bh1IurMd+QRCise67XICqomZd71oZvdNt6cA92WUZ3jR
/8RNN0M=
  "]],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBfA1ZBkrso2NXC3ZapZzDiuDQbT2tEhrpKE5+oAKdZERWETL
yUqLTI1hMjOlMMcKKko2GVltV2a0Rc2tstLcXKm1+X/LybAkFqzn9eLwuzgX
B46koqbUsIjFYukwXXmn7aWjDMhs3cbD6E+X5s/kGAP5vJlEYpyBor19pzQT
DNw9N3+ZGuna5aCmaiX+BaczyyvR8ODTGFXXU3bPgFoNFXnH0V/eZEY7+pZz
QUDlCdhSan1731jvdwbU2tw49dbXQ75+9MS1sy/rowysfGLJuIRKXX/XUqsU
Z4B6LOXfTTWKq5uotw90lF9FW8xTZncCe8Y2T3XLoMGDzsUsoc1pBNxtPTnf
OAQKNN1K6qc3ja+zFxO4uYLfLEcn2OEvdegOl8kjWkZgJz/IS+cReLC6hL8E
PRnxJ5ejI7GPAhVaKHYIR1H7dWOQKlQKRkKo+U6D7IqQwKYsp5LaKvSWUZun
bMMPUfUW0W+NiMCL6Ko0LRo7onVQO7yd1g4xgaH3/l73GgJL980WPM/CXa5q
24KBgUKqeUbra5MQcASiSidqTa+sHUctCvZ5rpSAL1iyVY621nGgcR2BlEl/
dGgDgf0H/20MoMUeSXYQNVVHng3k4C+6uZ5X6MU9+kdqOYGqz/zwD1T/obMz
ijatLwlNozVF7Nk4Opy0Z3blEvDnPdZtVxBQTcbfDaLc/ht2Rz6BlvsprhP9
D8zFOI4=
  "]],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmxYGQyWlDkoLBGYlW1sLeOJlhYzmibrY6um0rK1WWuR
OEprmdYYOY1gNYNRF7Vy4FhWcGW2oBVCZaUpUmqB/7fUMcs12+h5vTj7XZyL
sx1RVV25flFaWpoGY5efdpUPMSBxdhoOoz+9qj/jwwwUcqeSyVEGSsu6T6nG
GLh3bu4yNWbf5aam6kWhBSezK6vRaN/TBFXjqLivR9v1VfLj6K/AfFYH+pZ9
gU/l8lliamNH93DXdwaK1QXT1NtfDwV70BPXz75sjDOw8ok56xIq9v5dS62R
nQHqsVRoN9WQU9tCvXPAWnkVvWaaMPmS2DPOOapPAk1+dDZhHtmcTsDX5sj/
xiZQpOpUUD+9aX6dt5jArRW8Vik6xop+aUB3eI1+4VICO3kRbgaXwIPVWt4S
9GQsNL8cHUx85CvRkhy3YAh13TBEqAIFf3AENd1tklwRENiU61FQLYJABbV1
wjnwEC3eIvytEhJ4EV+VrkYTR9RuqjVga7fmEOh/H+ryrSGQuW+m6Hku7nKU
2xYM95ZQTVPqYJuIgDscV3jQ9ozq+lHULGOd54gJBCParVLU0sCG5nUEUkbd
0f4NBPYf/LcxjO71i/IiqLE29qw3H3/RzDpeoRf36B4VSwnUfOZFf6C6DzZb
HG1Zrx2ZROtKWTPT6MC8K9teQCAkf6zZLiOgHJ9+14dyem663IUEqizLMj3o
f8U9N14=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{16., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "55"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 55],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBfA1ZBkztI2NXC3ZSsu5DSuDQbT2tEhrpKE5+oAKdZERWERL
ZaVFpsUwma2NwpTVRVGyychqg8CMtj7mVllpbq7U2vy/5UQsiQX2vF4cfhfn
4sCRVNSUGhaxWCwdxq446SgdZiC7q8N4EP3p1vwZH2Egnzc1MzPKQNHunhOa
MQbunJm7SI3adzip87WSwIKTmeWVaKT/cZyq6yy7a0AthgrFUfSXL5nRjr7l
nBNQeQK2lNrQ3jPS/Z0BtTYvQb359YC/Fz129fSLhhgDyx+ZMy6gUvff1dQq
+SmgHpkP7KQaxdXN1Fv7rOWX0SumCZNnBnuma47qyYZGLzobN4c3phDwtHXm
fuMQKNB0KKmf3jS9yllM4MYyfosMHWNHvtSj29x1XtFSAtv5IV4qj8C9lSX8
JejxaCCZjg7FPwpUaKHYKRxGHdeMIapQKRgKo6bbjdmXhAQ2ZLmU1Fahr4za
MtE1eB9VbxL91ogIPI+tSNGi8UNaJ9Xqs1msYgID7wPdnlUE0vZMFzzNwl2u
asuCwb5CqmlK62+TEHAGY0oXakmtrB1FzXL2Wa6UgD9UslmGttZzoGkNgfk6
/eGBdQT27v+3PogWeyU5IbSuOvqkLxd/0c12vkTP79I/UMsIVH3mR36g+g82
WwxtXlsSnkRritjTCXQw6ci05xEIKB7qtsoJqMYT7/pRbu91hzOfwOtn6Wku
9D/J0zf3
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "2.30641499999999988190779731667134910822`6.383537367146441", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Squared matrix elent compute in ", 
   2.30641499999999988190779731667134910822`6.383537367146441, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzaMhgsLXJQUCIwK9vYWsQTLS2WNk3Wx1bNj5atzVqL
xFFay7TGzGEEqxmMuqiVQ8fSgiuzBa0QKitN0FIL/L8ljlmu2UbP68XZ7+Jc
nO2IKuvKapawWCwdxq444yobYUDi7DQcQX96NH8mRxko4M4kk2MMFO/rOa2Z
YOD++fkr1HH7bjc1VS8KLjqdXVGFRgf64lSdo/xBDWqpqVScQH/5F7I60Lec
i3wql88WUxs7eka7vjOg1uYnqHe+Hg70oidvnHvZGGNg1VNz1mVU7Pm7jlot
PwvU46ngHqpBWNtCvXvQWnENvW6aMnmT2DPOeapXAk0+dC5ujmxJI+Btd+R9
4xAo1HQqqZ/eNL+WLiVweyWvVYZOsKNfGtCdHqMvZzmBXbwwN51L4OGaUt4y
9NR4cGEFOhz/yFehRUK3YAR13TSEqQIlfziCmu41Sa4KCGzO7VZS2wT+cmrr
lHPoEaremvNbk0PgRWx1mhaNH9W6qVa/zWIVEhh8H+zyriWQuX+28Hku7mao
ti8a6i+imma0gXYRAXcopuxGLelV9WOoWc6+kCEmEAiXbpOhbQ0caF5PIGXU
HxvcSODAoX+bQmiJTyQNo8ba8Wf9efiLbs7xCr20V/9YLSNQ/ZkX/YHqP9hs
MbRlQ2lkGq0rZs8m0KEFV7Y9n0BQ8US3Q05ANZl4N4Bm9N5yuQsISE19md3o
f8bVN7k=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.01883500000000000104694031222152261762`4.295565537818911", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Decay widths computed in ", 
   0.01883500000000000104694031222152261762`4.295565537818911, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBjjmzYMhiUlDkoLFGYlW1sLeOJlhYrmibrY6um0rK1WWuR
OEprmdaYOYxgNZNRF7Vy4FhmcGW2sBVCZaUBUmqB/7fEMcs12+h5vTj7XZyL
sx1RVV25blFaWpoaY5OdcZSPMiCxd+qPoD/dyj8TIQaKuNPJ5BgDZXt7TivH
Gbh/fu4KNWrb5aSm6kX+BaeyK6vRyMCzOFXdVfFAh5p1VbIT6C/ffFYH+pZ9
kU/l8lliamNHT6j7OwMlqoIE9c7Xw4O96Mkb5142xhhY+dSUdRkVu/+updYU
ngXq8ZR/N1WfU9tCvXvQUnkNvW6cNHqS2DP2OapHAk1edDZuCm9OJ+Bp78r/
xiZQrOyUUz+9aX6dt5jA7eW8Vik6zop8aUB3uA1e4VICO3lBbgaXwMPVGt4S
9FTUP78MHYl/5CvQ0hynYBR13NQHqQI5fySMGu81Sa4KCGzKdcmpbQJfBbV1
0j78CC3ZIvytFBJ4EVuVrkLjR1VOqsVnNVtyCAy993d71hDI3D9T/DwXdzmK
bQsG+kupxmnVYLuIgDMQk7tQc0Z1/RhqKmRd4IgJDAY1W6VoWwMbmtcRSBm0
x4Y2EDhw6N/GALrPK8oLoobaaF9/Pv6inu16hV7ao31cIiVQ85kX+YFqP1it
MbRlvSY8hdaVsWYS6PC8I9tWQMAve6LeXkhAMZF4N4Byem85nEUEQiv6Ml3o
f8nAOAo=
  "]],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEUBnBijmzYMhgsKXJQUCIwK9vcWsSJlhZLmibrY6um0rK1WWuR
OkprmdaYOcxkNYNRF7Vy4FhmcGW2oBVCZaWJUmqB/7fUMcs12+i8Xpz9Lp6L
59mRlFeXmJawWCw9nl11xlUyzIDM2Wk+gv70av9MjDCQx5tOJscYKNrXfVo7
zsD98/NXqDH7bjc1VSMJLTqVVVaBjvY/S1D1jtIHJtRmKledQH8FFjLb0Lec
iwIqT8CWUuvbuke6vjOg0eXOUO98PRzsQU/eOPeyPs7AqqfWzMuo1Pt3HbVS
eRaox1OhPVSzuKqJevdge9k19Lpl0uJLYs4456k+GTT40bmENboljYCv1ZHz
jUMgX9uppn560/havpTA7ZX8ZgU6zh79Uofu9Nb6RcsJ7OJHeOk8Ag/XGPjL
0FOx0MIKdCjxUVCAFordwmHUddMcoQrVgqEoarnXILsqJLA526OmtggDpdTm
SefgI1SzVfRbKyLwIr46TYcmjurc1PZAh61dTGDgfajLt5ZAxv7Z/OfZ2Mst
2L5ouK+QapnWBVslBNzhuNqD2tIrasZQq5J9gSslEIwYtinQljoONK4nkKo1
HhvYSODAoX+bwmixXyKPoLVVsd6+HPyLfs7xCr201/hYoyBQ+Zk/+gM1fujo
iKNNGwzRKbS6iD07gw4uuLLsuQRCqif6HUoCBRMz7/pRbs8tlzsP98t7Mzzo
f8nBOAw=
  "]],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzYMhgsKXJQWKIwK9vYWsQTLS1WNE3Wx1bNj5atzVpF
4iitZVpj5jCC1QxGXdTKgWNZwZXZ0lYIlZUmaKkF/t8SxyzXbNHzenH2uzgX
ZzuS8pqSqgUsFkuHcShOukuGGJC52o0H0R8+ze/xYQYKeFPJ5AgDxbs6T2jG
GLh7dvYSddSx3UNN1UqC805mlVWg0Z4ncarOWXqvCrVWlSuOoj975zLb0Dec
8wIqT8CWUuvbOoc7vjGg1uYlqLe+HOjrQo9dO/2iPsbAsseWzIuo1PdnFbUy
/xRQj6SCO6hGcXUT9fY+W9kV9Kp5wuxPYs+4Zql+GTQE0Jm4JbIhjYC/1Zn7
lUOgUNOupH583fgqZyGBm0v5zXJ0jB39XIdu9ZkCosUEtvHDvHQegfsr9PxF
6PHR4NwSdDD+QaBCi8Qe4RDqvm4MU4VKwWAENd9pkF0WElif7VVSW4S9pdTm
CdfAA1S9UfRLIyLwPLY8TYvGD2k9VFuv3WoTE+h/F+zwrySQsWe68Fk27nJV
m+cNdRdRzVPavlYJAU8opvSi1vSK2hHUks8+x5US6AvrN8nRljoONK4mkDIZ
DvevJbB3/991IXR3QJITRk3Vo0+7c/EX3YzzJXphp+GhWk6g8hM/+h01vLfb
Y2jTGn1kEq0pZk8n0IE5d5Yjj0BQ8Ui3JZ+Aajzxtgfldt1wewoInPkXzvCi
/wHNaTii
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEYBXBijmzaMhgsKXJQWCowK9vYWsQTLS1WNk3Wx1ZNpUVrs9Yi
cRTWMq0xcxjhaoajLmrl0Lms4MpsQSuEykoTpNQC/2+JY5ZrtNHzenH2uzgX
Zzvi6roK/SIWi6XFdMhPuypGGZB2dRoPoz/71H8mxxgo5s4kk+MMlO3pPaWe
YODeufnL1GjHTjc1XS8OLDidW1WDRgafxqlaZ+V9PWrTV8uPo798qZx29C3n
Ap/K5bMlVEt771j3dwZUmqIE9fbXQ/5+9MT1sy8tMQZWPLHmXEIlfX/XUGtl
Z4B6LB3YRTWKDM3UOwfsVVfRa+YpsyeJPdM1T/VIodGLzsWt4U0ZBDxtzoJv
HAIl6k4F9dObptf5iwncWs5rKUQn2JEvDej2PpNXuJTADl6Im8kl8GBVOW8J
ejIaSC1DR+If+Uq0VOQWjKKuG8YQVaDgj4RR891G6RUBgY15PQpqq8BXSW2Z
6hp+iKo2C3+rhQRexFZmaND4EY2bavc5bHYRgaH3gW7PagLZ+2ZLnufhbpZy
64LBgVKqeUbjbxMTcAdjih7UlllTP45aZezzWRIC/lD5lkK0tYEDTWsJpE26
o0PrCew/+G9DEN3rFeeHUJMh+mygAH/RzjlfoRd36x6pCgnUfuZFfqC6Dw5H
DG1eVx6eRuvK2LMJdDjlyu0oIhCQP9ZukxFQTibeDaJZ/Tdd7mICFsNEdg/6
H8oaOCo=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{24., {0., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "163", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 163, " ."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBfA1ZBkm2cZGrpbMmuXchpWCEK09LdIatdAcfUCFusgILKLl
ZKVFpsUw0daGYRuri6JkyshquzKjLWpulZXm5kqtzf9bToYlscCe14vD7+Jc
HDjiqrpy/RIWi6XB2ORnnOWjDEgc3YYj6E+36s/kGAOF3JlkcpyBsr19p1UT
DNw7P3+FGrXtclEX6sWBRaezK6vRyODTOFVjr7ivRzv0VfIT6C9fKqsTfcu5
yKdy+excamNn31jPdwaU6oIEtevrYX8/evLGuZeNMQZWPTFnXUZz3X/XUWtk
Z4F6fCGwm2oQ1bZQ7xy0VF5Dr5umTJ4k9oxjnuqRQJMXnYubw1vSCHja7fnf
OASKVN0K6qc3za/zlhK4vZLXKkUn2JEvDegOt9ErzCSwkxfipnMJPFij5S1D
T0UDqRXoSPwjvwQtFbkEo6jzpiFEFSj4I2HUdLdJclVAYHNOr4LaJvBVUFun
HMMPUWWx8LdKSOBFbHWaGo0fVbuoFp+1wyIiMPQ+0ONZS2D5/tmi5zm4m1Gy
bdHgQCnVNKP2t4sJuIIxRS/akV5dP46aZewLGbkE/CHtVina1sCB5vUEFoy6
Y0MbCRw49G9TEN3nFeeFUGNt9NlAPv6imbO/Qi/t0T1SSgnUfOZFfqC6D1Zr
DG3ZoA1Po3Vl7NkEOpxyZtsKCATkjzXbZQRKJhPvBtGM/ltOVyGBrmJbZi/6
H8fPN8g=
  "]],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1I02EYBXAbsowl2cZGWku2muXchpXBIFp7WqQ1aqE5+oAKdaERWETL
yUqLTIthMluTwjZWF0XJJiOreRFmtEXNrbLSnK7U2vy/5UQsiQXreb04/C7O
xYEjqqgtNSxKS0vTYjrkp1ylwwxInJ3Gw+hPr/rPxAgDhdzp2dkxBkr2dJ9U
jzNw9+z8JWq0Y6ebmqoTBRecyi6vREf7n8SpWkfZPQNqNVTIj6O//MmsdvQt
+zyfyuWzxNSG9u6Rru8MqDQFCeqtr4cCPWj1tTMvG2IMrHhsybqIir1/11Cr
ZKeBeiwV3EU1CmuaqbcP2MqvoFfNk2bfLPaMc57qk0BjLzoXt0Q2pRPwtTny
v7EJFKk7FdRPb5pe5y0mcHM5r0WKjrNGv9Sj272m3pxMAjt4YW4Gl8D9VTre
EvRENJhchg7FP/KVaLHQLRhGXdeNYapAwR+KoOY7jZLLAgIbcz0KaqvAX0Zt
mXQOPkBVm3N+q3MIvIitTNeg8SMaN9Xmt1ttQgID74NdvtUElu6bKXqWi7sc
5dYFQ33FVPO0JtAmIuAOxRQe1JpRWTeGWmSscxwxgUBYt0WKttazoWktgZRJ
f3RgPYH9B/9tCKF7e0V5YdRUE33al4+/aOccr9ALu/UPVVICVZ95oz9Q/Qe7
PYY2r9NFptDaEtZMAh1MurI7CggE5Y+022QElBOJd/0op+eGy11IoFrzPNOD
/gfHizfL
  "]],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwd0F1M0mEUBnBijmzkMhgsKXJYWiIwK9vcWsaJlhYrmqbrY6um0rLarLVI
HKW1TGvMHEaymsGoi1o5cCwruDJb0AyhstIEKbXA/1vimOUabXReL85+F8/F
8+xIquvLtYtYLJYazyI/Yy8fZSDX1q07jP50Kf9MjjFQyJtJJMYZKNvTe1o5
wcD98/NXqBHLTgc11SDxLzidVVmDhgeexahqa8UDLWrSVsuPo7+8ycxO9C3n
ooDKE7BzqE2dvWM93xkoURXEqXe+HvL1oSdunHvVFGVgxVNj5mU0x/V3DbVW
dhaox1L+XVSduK6VeveAufIaet0wZXAnMGds81R3LjR70LmYMbQpjYC7w5r/
jUOgSNmtoH4abHmTt5jA7eX8Nik6wQ5/aUS3u/QeUQaBHfwgL51H4OEqDX8J
ejLiTy5DR2IfBcVoqdghHEXtN3VBqlAhGAmhhnvNuVeFBDZmOxXUdqG3gto2
ZRt+hJZsFv1Wigi8jK5MU6GxIyoH1eztMpnFBIbe+3vcqwks3Tdb9CIbe7nF
WxcM9JdSDTMqX4eEgCMQVThRU3pNwzhqlLEvcHMI+IKaLVK0vZEDLWsJpPRV
R4fWE9h/8N+GALrXI8kLovq6yPP+fPyLes76Gr20u+pxiZRA7Wd++Ada9aGr
K4q2rtOEptH6MvZsHB1O2rMsBQT88ifqbTICxZPxdwMot++W3VGIe04NZjjR
/8o7OCk=
  "]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{927, 1028},
WindowMargins->{{-6, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Linux x86 (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 218, 4, 32, "Input"],
Cell[778, 26, 452, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[1255, 39, 169, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[1449, 46, 2036, 29, 23, "Print"],
Cell[3488, 77, 2307, 36, 23, "Print"],
Cell[5798, 115, 2090, 30, 23, "Print"],
Cell[7891, 147, 2021, 29, 23, "Print"],
Cell[9915, 178, 2033, 29, 23, "Print"],
Cell[11951, 209, 2085, 30, 23, "Print"],
Cell[14039, 241, 2087, 30, 23, "Print"],
Cell[16129, 273, 2024, 29, 23, "Print"],
Cell[18156, 304, 2054, 29, 23, "Print"],
Cell[20213, 335, 2022, 29, 23, "Print"],
Cell[22238, 366, 2089, 30, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[24354, 400, 1526, 23, 32, "Input"],
Cell[25883, 425, 92, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[26000, 430, 697, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[26722, 446, 2887, 41, 23, "Print"],
Cell[29612, 489, 2907, 41, 23, "Print"],
Cell[32522, 532, 2907, 41, 23, "Print"],
Cell[35432, 575, 3011, 45, 23, "Print"],
Cell[38446, 622, 2876, 41, 23, "Print"],
Cell[41325, 665, 2900, 41, 23, "Print"],
Cell[44228, 708, 2901, 41, 23, "Print"],
Cell[47132, 751, 2900, 41, 23, "Print"],
Cell[50035, 794, 2911, 41, 23, "Print"],
Cell[52949, 837, 2915, 42, 23, "Print"],
Cell[55867, 881, 2865, 41, 23, "Print"],
Cell[58735, 924, 2895, 41, 23, "Print"],
Cell[61633, 967, 2898, 41, 23, "Print"],
Cell[64534, 1010, 2896, 41, 23, "Print"],
Cell[67433, 1053, 3079, 46, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70561, 1105, 790, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[71376, 1121, 675, 13, 23, "Print"],
Cell[72054, 1136, 685, 13, 23, "Print"],
Cell[72742, 1151, 212, 3, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73003, 1160, 281, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[73309, 1170, 1644, 27, 23, "Print"],
Cell[74956, 1199, 1645, 27, 23, "Print"],
Cell[76604, 1228, 1171, 17, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77824, 1251, 445, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[78294, 1263, 861, 12, 23, "Print"],
Cell[79158, 1277, 857, 12, 23, "Print"],
Cell[80018, 1291, 1054, 19, 23, "Print"],
Cell[81075, 1312, 809, 11, 23, "Print"],
Cell[81887, 1325, 991, 16, 23, "Print"],
Cell[82881, 1343, 840, 12, 23, "Print"],
Cell[83724, 1357, 798, 11, 23, "Print"],
Cell[84525, 1370, 922, 15, 23, "Print"],
Cell[85450, 1387, 808, 11, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86307, 1404, 461, 8, 32, "Input"],
Cell[CellGroupData[{
Cell[86793, 1416, 1659, 28, 23, "Print"],
Cell[88455, 1446, 1414, 20, 23, "Print"],
Cell[89872, 1468, 1596, 25, 23, "Print"],
Cell[91471, 1495, 1447, 21, 23, "Print"],
Cell[92921, 1518, 1933, 32, 43, "Print"],
Cell[94857, 1552, 1531, 24, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[96415, 1580, 660, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[97100, 1598, 481, 11, 32, "Input"],
Cell[CellGroupData[{
Cell[97606, 1613, 775, 11, 23, "Print"],
Cell[98384, 1626, 968, 16, 23, "Print"],
Cell[99355, 1644, 743, 10, 23, "Print"],
Cell[100101, 1656, 758, 10, 23, "Print"],
Cell[100862, 1668, 745, 10, 23, "Print"],
Cell[101610, 1680, 743, 10, 23, "Print"],
Cell[102356, 1692, 758, 10, 23, "Print"],
Cell[103117, 1704, 751, 10, 23, "Print"],
Cell[103871, 1716, 745, 10, 23, "Print"],
Cell[104619, 1728, 736, 10, 23, "Print"],
Cell[105358, 1740, 731, 10, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[106116, 1754, 192, 6, 32, "Input"],
Cell[CellGroupData[{
Cell[106333, 1764, 1265, 19, 32, "Input"],
Cell[CellGroupData[{
Cell[107623, 1787, 528, 9, 23, "Print"],
Cell[108154, 1798, 515, 9, 23, "Print"],
Cell[108672, 1809, 513, 9, 23, "Print"],
Cell[109188, 1820, 672, 14, 23, "Print"],
Cell[109863, 1836, 662, 14, 23, "Print"],
Cell[110528, 1852, 764, 17, 23, "Print"],
Cell[111295, 1871, 507, 9, 23, "Print"],
Cell[111805, 1882, 693, 14, 23, "Print"],
Cell[112501, 1898, 544, 10, 23, "Print"],
Cell[113048, 1910, 792, 18, 23, "Print"],
Cell[113843, 1930, 502, 9, 23, "Print"],
Cell[114348, 1941, 570, 10, 23, "Print"],
Cell[114921, 1953, 550, 10, 23, "Print"],
Cell[115474, 1965, 552, 10, 23, "Print"],
Cell[116029, 1977, 658, 14, 23, "Print"],
Cell[116690, 1993, 764, 17, 23, "Print"],
Cell[117457, 2012, 511, 9, 23, "Print"],
Cell[117971, 2023, 693, 14, 23, "Print"],
Cell[118667, 2039, 540, 10, 23, "Print"],
Cell[119210, 2051, 1025, 21, 23, "Print"],
Cell[120238, 2074, 628, 13, 23, "Print"],
Cell[120869, 2089, 711, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[121607, 2108, 52, 1, 32, "Input"],
Cell[121662, 2111, 117, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[121804, 2118, 58, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[121887, 2123, 983, 14, 23, "Print"],
Cell[122873, 2139, 994, 14, 23, "Print"],
Cell[123870, 2155, 1028, 14, 23, "Print"],
Cell[124901, 2171, 1004, 14, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[125932, 2189, 293, 7, 32, "Input"],
Cell[CellGroupData[{
Cell[126250, 2200, 55, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[126330, 2205, 909, 13, 23, "Print"],
Cell[127242, 2220, 909, 13, 23, "Print"],
Cell[128154, 2235, 918, 13, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[129099, 2252, 1001, 17, 32, "Input"],
Cell[CellGroupData[{
Cell[130125, 2273, 1395, 33, 99, "Input"],
Cell[CellGroupData[{
Cell[131545, 2310, 410, 9, 23, "Print"],
Cell[131958, 2321, 170, 2, 23, "Print"],
Cell[132131, 2325, 576, 12, 23, "Print"],
Cell[132710, 2339, 191, 2, 23, "Print"],
Cell[132904, 2343, 411, 8, 23, "Print"],
Cell[133318, 2353, 168, 2, 23, "Print"],
Cell[133489, 2357, 615, 14, 43, "Print"],
Cell[134107, 2373, 480, 9, 23, "Print"],
Cell[134590, 2384, 189, 2, 23, "Print"],
Cell[134782, 2388, 337, 7, 23, "Print"],
Cell[135122, 2397, 369, 7, 23, "Print"],
Cell[135494, 2406, 449, 9, 23, "Print"],
Cell[135946, 2417, 170, 2, 23, "Print"],
Cell[136119, 2421, 401, 8, 23, "Print"],
Cell[136523, 2431, 434, 8, 23, "Print"],
Cell[136960, 2441, 368, 7, 23, "Print"],
Cell[137331, 2450, 170, 2, 23, "Print"],
Cell[137504, 2454, 423, 9, 23, "Print"],
Cell[137930, 2465, 366, 7, 23, "Print"],
Cell[138299, 2474, 209, 2, 23, "Print"],
Cell[138511, 2478, 240, 3, 23, "Print"],
Cell[138754, 2483, 168, 2, 23, "Print"],
Cell[138925, 2487, 401, 8, 23, "Print"],
Cell[139329, 2497, 432, 8, 23, "Print"],
Cell[139764, 2507, 366, 7, 23, "Print"],
Cell[140133, 2516, 170, 2, 23, "Print"],
Cell[140306, 2520, 424, 9, 23, "Print"],
Cell[140733, 2531, 364, 7, 23, "Print"],
Cell[141100, 2540, 217, 3, 23, "Print"],
Cell[141320, 2545, 203, 2, 23, "Print"],
Cell[141526, 2549, 224, 3, 23, "Print"],
Cell[141753, 2554, 204, 2, 23, "Print"],
Cell[141960, 2558, 413, 9, 23, "Print"],
Cell[142376, 2569, 170, 2, 23, "Print"],
Cell[142549, 2573, 401, 8, 23, "Print"],
Cell[142953, 2583, 432, 8, 23, "Print"],
Cell[143388, 2593, 436, 8, 23, "Print"],
Cell[143827, 2603, 368, 7, 23, "Print"],
Cell[144198, 2612, 168, 2, 23, "Print"],
Cell[144369, 2616, 424, 9, 23, "Print"],
Cell[144796, 2627, 434, 8, 23, "Print"],
Cell[145233, 2637, 365, 7, 23, "Print"],
Cell[145601, 2646, 208, 2, 23, "Print"],
Cell[145812, 2650, 240, 3, 23, "Print"],
Cell[146055, 2655, 168, 2, 23, "Print"],
Cell[146226, 2659, 403, 8, 23, "Print"],
Cell[146632, 2669, 434, 8, 23, "Print"],
Cell[147069, 2679, 368, 7, 23, "Print"],
Cell[147440, 2688, 170, 2, 23, "Print"],
Cell[147613, 2692, 424, 9, 23, "Print"],
Cell[148040, 2703, 433, 8, 23, "Print"],
Cell[148476, 2713, 366, 7, 23, "Print"],
Cell[148845, 2722, 217, 3, 23, "Print"],
Cell[149065, 2727, 205, 2, 23, "Print"],
Cell[149273, 2731, 226, 3, 23, "Print"],
Cell[149502, 2736, 209, 2, 23, "Print"],
Cell[149714, 2740, 413, 9, 23, "Print"],
Cell[150130, 2751, 168, 2, 23, "Print"],
Cell[150301, 2755, 401, 8, 23, "Print"],
Cell[150705, 2765, 434, 8, 23, "Print"],
Cell[151142, 2775, 433, 8, 23, "Print"],
Cell[151578, 2785, 366, 7, 23, "Print"],
Cell[151947, 2794, 168, 2, 23, "Print"],
Cell[152118, 2798, 424, 9, 23, "Print"],
Cell[152545, 2809, 366, 7, 23, "Print"],
Cell[152914, 2818, 209, 2, 23, "Print"],
Cell[153126, 2822, 240, 3, 23, "Print"],
Cell[153369, 2827, 168, 2, 23, "Print"],
Cell[153540, 2831, 401, 8, 23, "Print"],
Cell[153944, 2841, 431, 8, 23, "Print"],
Cell[154378, 2851, 364, 7, 23, "Print"],
Cell[154745, 2860, 170, 2, 23, "Print"],
Cell[154918, 2864, 423, 9, 23, "Print"],
Cell[155344, 2875, 366, 7, 23, "Print"],
Cell[155713, 2884, 217, 3, 23, "Print"],
Cell[155933, 2889, 205, 2, 23, "Print"],
Cell[156141, 2893, 224, 3, 23, "Print"],
Cell[156368, 2898, 209, 2, 23, "Print"],
Cell[156580, 2902, 412, 9, 23, "Print"],
Cell[156995, 2913, 168, 2, 23, "Print"],
Cell[157166, 2917, 401, 8, 23, "Print"],
Cell[157570, 2927, 432, 8, 23, "Print"],
Cell[158005, 2937, 436, 8, 23, "Print"],
Cell[158444, 2947, 368, 7, 23, "Print"],
Cell[158815, 2956, 167, 2, 23, "Print"],
Cell[158985, 2960, 424, 9, 23, "Print"],
Cell[159412, 2971, 432, 8, 23, "Print"],
Cell[159847, 2981, 434, 8, 23, "Print"],
Cell[160284, 2991, 368, 7, 23, "Print"],
Cell[160655, 3000, 209, 2, 23, "Print"],
Cell[160867, 3004, 240, 3, 23, "Print"],
Cell[161110, 3009, 168, 2, 23, "Print"],
Cell[161281, 3013, 401, 8, 23, "Print"],
Cell[161685, 3023, 432, 8, 23, "Print"],
Cell[162120, 3033, 363, 7, 23, "Print"],
Cell[162486, 3042, 168, 2, 23, "Print"],
Cell[162657, 3046, 424, 9, 23, "Print"],
Cell[163084, 3057, 432, 8, 23, "Print"],
Cell[163519, 3067, 366, 7, 23, "Print"],
Cell[163888, 3076, 217, 3, 23, "Print"],
Cell[164108, 3081, 203, 2, 23, "Print"],
Cell[164314, 3085, 224, 3, 23, "Print"],
Cell[164541, 3090, 207, 2, 23, "Print"],
Cell[164751, 3094, 416, 9, 23, "Print"],
Cell[165170, 3105, 168, 2, 23, "Print"],
Cell[165341, 3109, 403, 8, 23, "Print"],
Cell[165747, 3119, 436, 8, 23, "Print"],
Cell[166186, 3129, 432, 8, 23, "Print"],
Cell[166621, 3139, 432, 8, 23, "Print"],
Cell[167056, 3149, 432, 8, 23, "Print"],
Cell[167491, 3159, 370, 7, 23, "Print"],
Cell[167864, 3168, 168, 2, 23, "Print"],
Cell[168035, 3172, 426, 9, 23, "Print"],
Cell[168464, 3183, 432, 8, 23, "Print"],
Cell[168899, 3193, 364, 7, 23, "Print"],
Cell[169266, 3202, 209, 2, 23, "Print"],
Cell[169478, 3206, 240, 3, 23, "Print"],
Cell[169721, 3211, 168, 2, 23, "Print"],
Cell[169892, 3215, 401, 8, 23, "Print"],
Cell[170296, 3225, 432, 8, 23, "Print"],
Cell[170731, 3235, 364, 7, 23, "Print"],
Cell[171098, 3244, 168, 2, 23, "Print"],
Cell[171269, 3248, 424, 9, 23, "Print"],
Cell[171696, 3259, 432, 8, 23, "Print"],
Cell[172131, 3269, 364, 7, 23, "Print"],
Cell[172498, 3278, 217, 3, 23, "Print"],
Cell[172718, 3283, 203, 2, 23, "Print"],
Cell[172924, 3287, 224, 3, 23, "Print"],
Cell[173151, 3292, 210, 2, 23, "Print"],
Cell[173364, 3296, 416, 9, 23, "Print"],
Cell[173783, 3307, 168, 2, 23, "Print"],
Cell[173954, 3311, 403, 8, 23, "Print"],
Cell[174360, 3321, 436, 8, 23, "Print"],
Cell[174799, 3331, 432, 8, 23, "Print"],
Cell[175234, 3341, 431, 8, 23, "Print"],
Cell[175668, 3351, 434, 8, 23, "Print"],
Cell[176105, 3361, 368, 7, 23, "Print"],
Cell[176476, 3370, 170, 2, 23, "Print"],
Cell[176649, 3374, 424, 9, 23, "Print"],
Cell[177076, 3385, 436, 8, 23, "Print"],
Cell[177515, 3395, 368, 7, 23, "Print"],
Cell[177886, 3404, 210, 2, 23, "Print"],
Cell[178099, 3408, 241, 3, 23, "Print"],
Cell[178343, 3413, 168, 2, 23, "Print"],
Cell[178514, 3417, 403, 8, 23, "Print"],
Cell[178920, 3427, 436, 8, 23, "Print"],
Cell[179359, 3437, 366, 7, 23, "Print"],
Cell[179728, 3446, 168, 2, 23, "Print"],
Cell[179899, 3450, 424, 9, 23, "Print"],
Cell[180326, 3461, 436, 8, 23, "Print"],
Cell[180765, 3471, 366, 7, 23, "Print"],
Cell[181134, 3480, 218, 3, 23, "Print"],
Cell[181355, 3485, 203, 2, 23, "Print"],
Cell[181561, 3489, 227, 3, 23, "Print"],
Cell[181791, 3494, 211, 2, 23, "Print"],
Cell[182005, 3498, 416, 9, 23, "Print"],
Cell[182424, 3509, 168, 2, 23, "Print"],
Cell[182595, 3513, 401, 8, 23, "Print"],
Cell[182999, 3523, 440, 8, 23, "Print"],
Cell[183442, 3533, 434, 8, 23, "Print"],
Cell[183879, 3543, 436, 8, 23, "Print"],
Cell[184318, 3553, 434, 8, 23, "Print"],
Cell[184755, 3563, 374, 7, 23, "Print"],
Cell[185132, 3572, 168, 2, 23, "Print"],
Cell[185303, 3576, 423, 9, 23, "Print"],
Cell[185729, 3587, 435, 8, 23, "Print"],
Cell[186167, 3597, 432, 8, 23, "Print"],
Cell[186602, 3607, 432, 8, 23, "Print"],
Cell[187037, 3617, 432, 8, 23, "Print"],
Cell[187472, 3627, 370, 7, 23, "Print"],
Cell[187845, 3636, 210, 2, 23, "Print"],
Cell[188058, 3640, 242, 3, 23, "Print"],
Cell[188303, 3645, 168, 2, 23, "Print"],
Cell[188474, 3649, 401, 8, 23, "Print"],
Cell[188878, 3659, 432, 8, 23, "Print"],
Cell[189313, 3669, 366, 7, 23, "Print"],
Cell[189682, 3678, 170, 2, 23, "Print"],
Cell[189855, 3682, 424, 9, 23, "Print"],
Cell[190282, 3693, 434, 8, 23, "Print"],
Cell[190719, 3703, 364, 7, 23, "Print"],
Cell[191086, 3712, 219, 3, 23, "Print"],
Cell[191308, 3717, 205, 2, 23, "Print"],
Cell[191516, 3721, 226, 3, 23, "Print"],
Cell[191745, 3726, 214, 2, 23, "Print"],
Cell[191962, 3730, 416, 9, 23, "Print"],
Cell[192381, 3741, 168, 2, 23, "Print"],
Cell[192552, 3745, 401, 8, 23, "Print"],
Cell[192956, 3755, 440, 8, 23, "Print"],
Cell[193399, 3765, 434, 8, 23, "Print"],
Cell[193836, 3775, 434, 8, 23, "Print"],
Cell[194273, 3785, 436, 8, 23, "Print"],
Cell[194712, 3795, 372, 7, 23, "Print"],
Cell[195087, 3804, 168, 2, 23, "Print"],
Cell[195258, 3808, 426, 9, 23, "Print"],
Cell[195687, 3819, 433, 8, 23, "Print"],
Cell[196123, 3829, 366, 7, 23, "Print"],
Cell[196492, 3838, 213, 2, 23, "Print"],
Cell[196708, 3842, 241, 3, 23, "Print"],
Cell[196952, 3847, 170, 2, 23, "Print"],
Cell[197125, 3851, 403, 8, 23, "Print"],
Cell[197531, 3861, 434, 8, 23, "Print"],
Cell[197968, 3871, 364, 7, 23, "Print"],
Cell[198335, 3880, 170, 2, 23, "Print"],
Cell[198508, 3884, 424, 9, 23, "Print"],
Cell[198935, 3895, 364, 7, 23, "Print"],
Cell[199302, 3904, 221, 3, 23, "Print"],
Cell[199526, 3909, 203, 2, 23, "Print"],
Cell[199732, 3913, 226, 3, 23, "Print"],
Cell[199961, 3918, 212, 2, 23, "Print"],
Cell[200176, 3922, 416, 9, 23, "Print"],
Cell[200595, 3933, 168, 2, 23, "Print"],
Cell[200766, 3937, 401, 8, 23, "Print"],
Cell[201170, 3947, 440, 8, 23, "Print"],
Cell[201613, 3957, 433, 8, 23, "Print"],
Cell[202049, 3967, 434, 8, 23, "Print"],
Cell[202486, 3977, 434, 8, 23, "Print"],
Cell[202923, 3987, 370, 7, 23, "Print"],
Cell[203296, 3996, 170, 2, 23, "Print"],
Cell[203469, 4000, 424, 9, 23, "Print"],
Cell[203896, 4011, 433, 8, 23, "Print"],
Cell[204332, 4021, 366, 7, 23, "Print"],
Cell[204701, 4030, 211, 2, 23, "Print"],
Cell[204915, 4034, 244, 3, 23, "Print"],
Cell[205162, 4039, 168, 2, 23, "Print"],
Cell[205333, 4043, 403, 8, 23, "Print"],
Cell[205739, 4053, 432, 8, 23, "Print"],
Cell[206174, 4063, 366, 7, 23, "Print"],
Cell[206543, 4072, 168, 2, 23, "Print"],
Cell[206714, 4076, 423, 9, 23, "Print"],
Cell[207140, 4087, 364, 7, 23, "Print"],
Cell[207507, 4096, 221, 3, 23, "Print"],
Cell[207731, 4101, 205, 2, 23, "Print"],
Cell[207939, 4105, 226, 3, 23, "Print"],
Cell[208168, 4110, 212, 2, 23, "Print"],
Cell[208383, 4114, 416, 9, 23, "Print"],
Cell[208802, 4125, 168, 2, 23, "Print"],
Cell[208973, 4129, 401, 8, 23, "Print"],
Cell[209377, 4139, 438, 8, 23, "Print"],
Cell[209818, 4149, 434, 8, 23, "Print"],
Cell[210255, 4159, 436, 8, 23, "Print"],
Cell[210694, 4169, 433, 8, 23, "Print"],
Cell[211130, 4179, 370, 7, 23, "Print"],
Cell[211503, 4188, 168, 2, 23, "Print"],
Cell[211674, 4192, 426, 9, 23, "Print"],
Cell[212103, 4203, 364, 7, 23, "Print"],
Cell[212470, 4212, 211, 2, 23, "Print"],
Cell[212684, 4216, 242, 3, 23, "Print"],
Cell[212929, 4221, 170, 2, 23, "Print"],
Cell[213102, 4225, 401, 8, 23, "Print"],
Cell[213506, 4235, 434, 8, 23, "Print"],
Cell[213943, 4245, 363, 7, 23, "Print"],
Cell[214309, 4254, 168, 2, 23, "Print"],
Cell[214480, 4258, 424, 9, 23, "Print"],
Cell[214907, 4269, 364, 7, 23, "Print"],
Cell[215274, 4278, 219, 3, 23, "Print"],
Cell[215496, 4283, 205, 2, 23, "Print"],
Cell[215704, 4287, 226, 3, 23, "Print"],
Cell[215933, 4292, 212, 2, 23, "Print"],
Cell[216148, 4296, 421, 9, 23, "Print"],
Cell[216572, 4307, 168, 2, 23, "Print"],
Cell[216743, 4311, 430, 9, 23, "Print"],
Cell[217176, 4322, 168, 2, 23, "Print"],
Cell[217347, 4326, 401, 8, 23, "Print"],
Cell[217751, 4336, 436, 8, 23, "Print"],
Cell[218190, 4346, 438, 8, 23, "Print"],
Cell[218631, 4356, 436, 8, 23, "Print"],
Cell[219070, 4366, 436, 8, 23, "Print"],
Cell[219509, 4376, 438, 8, 23, "Print"],
Cell[219950, 4386, 436, 8, 23, "Print"],
Cell[220389, 4396, 438, 8, 23, "Print"],
Cell[220830, 4406, 438, 8, 23, "Print"],
Cell[221271, 4416, 438, 8, 23, "Print"],
Cell[221712, 4426, 438, 8, 23, "Print"],
Cell[222153, 4436, 438, 8, 23, "Print"],
Cell[222594, 4446, 438, 8, 23, "Print"],
Cell[223035, 4456, 168, 2, 23, "Print"],
Cell[223206, 4460, 363, 7, 23, "Print"],
Cell[223572, 4469, 374, 7, 23, "Print"],
Cell[223949, 4478, 168, 2, 23, "Print"],
Cell[224120, 4482, 424, 9, 23, "Print"],
Cell[224547, 4493, 434, 8, 23, "Print"],
Cell[224984, 4503, 432, 8, 23, "Print"],
Cell[225419, 4513, 432, 8, 23, "Print"],
Cell[225854, 4523, 432, 8, 23, "Print"],
Cell[226289, 4533, 432, 8, 23, "Print"],
Cell[226724, 4543, 431, 8, 23, "Print"],
Cell[227158, 4553, 438, 8, 23, "Print"],
Cell[227599, 4563, 438, 8, 23, "Print"],
Cell[228040, 4573, 438, 8, 23, "Print"],
Cell[228481, 4583, 436, 8, 23, "Print"],
Cell[228920, 4593, 434, 8, 23, "Print"],
Cell[229357, 4603, 434, 8, 23, "Print"],
Cell[229794, 4613, 372, 7, 23, "Print"],
Cell[230169, 4622, 211, 2, 23, "Print"],
Cell[230383, 4626, 242, 3, 23, "Print"],
Cell[230628, 4631, 170, 2, 23, "Print"],
Cell[230801, 4635, 401, 8, 23, "Print"],
Cell[231205, 4645, 432, 8, 23, "Print"],
Cell[231640, 4655, 366, 7, 23, "Print"],
Cell[232009, 4664, 167, 2, 23, "Print"],
Cell[232179, 4668, 426, 9, 23, "Print"],
Cell[232608, 4679, 432, 8, 23, "Print"],
Cell[233043, 4689, 366, 7, 23, "Print"],
Cell[233412, 4698, 219, 3, 23, "Print"],
Cell[233634, 4703, 205, 2, 23, "Print"],
Cell[233842, 4707, 228, 3, 23, "Print"],
Cell[234073, 4712, 219, 3, 23, "Print"],
Cell[234295, 4717, 419, 9, 23, "Print"],
Cell[234717, 4728, 168, 2, 23, "Print"],
Cell[234888, 4732, 428, 9, 23, "Print"],
Cell[235319, 4743, 168, 2, 23, "Print"],
Cell[235490, 4747, 401, 8, 23, "Print"],
Cell[235894, 4757, 436, 8, 23, "Print"],
Cell[236333, 4767, 438, 8, 23, "Print"],
Cell[236774, 4777, 438, 8, 23, "Print"],
Cell[237215, 4787, 436, 8, 23, "Print"],
Cell[237654, 4797, 436, 8, 23, "Print"],
Cell[238093, 4807, 438, 8, 23, "Print"],
Cell[238534, 4817, 438, 8, 23, "Print"],
Cell[238975, 4827, 440, 8, 23, "Print"],
Cell[239418, 4837, 438, 8, 23, "Print"],
Cell[239859, 4847, 438, 8, 23, "Print"],
Cell[240300, 4857, 440, 8, 23, "Print"],
Cell[240743, 4867, 438, 8, 23, "Print"],
Cell[241184, 4877, 168, 2, 23, "Print"],
Cell[241355, 4881, 363, 7, 23, "Print"],
Cell[241721, 4890, 374, 7, 23, "Print"],
Cell[242098, 4899, 170, 2, 23, "Print"],
Cell[242271, 4903, 424, 9, 23, "Print"],
Cell[242698, 4914, 436, 8, 23, "Print"],
Cell[243137, 4924, 436, 8, 23, "Print"],
Cell[243576, 4934, 436, 8, 23, "Print"],
Cell[244015, 4944, 368, 7, 23, "Print"],
Cell[244386, 4953, 213, 2, 23, "Print"],
Cell[244602, 4957, 244, 3, 23, "Print"],
Cell[244849, 4962, 167, 2, 23, "Print"],
Cell[245019, 4966, 401, 8, 23, "Print"],
Cell[245423, 4976, 432, 8, 23, "Print"],
Cell[245858, 4986, 363, 7, 23, "Print"],
Cell[246224, 4995, 168, 2, 23, "Print"],
Cell[246395, 4999, 424, 9, 23, "Print"],
Cell[246822, 5010, 364, 7, 23, "Print"],
Cell[247189, 5019, 219, 3, 23, "Print"],
Cell[247411, 5024, 205, 2, 23, "Print"],
Cell[247619, 5028, 228, 3, 23, "Print"],
Cell[247850, 5033, 216, 3, 23, "Print"],
Cell[248069, 5038, 208, 2, 23, "Print"],
Cell[248280, 5042, 191, 2, 23, "Print"],
Cell[248474, 5046, 265, 3, 23, "Print"],
Cell[248742, 5051, 172, 2, 23, "Print"]
}, Open  ]],
Cell[248929, 5056, 276, 6, 32, "Output"]
}, Open  ]],
Cell[249220, 5065, 120, 2, 32, "Input"],
Cell[249343, 5069, 360, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[249728, 5082, 54, 1, 32, "Input"],
Cell[CellGroupData[{
Cell[249807, 5087, 1085, 16, 23, "Print"],
Cell[250895, 5105, 1356, 23, 23, "Print"],
Cell[252254, 5130, 1137, 17, 23, "Print"],
Cell[253394, 5149, 1073, 16, 23, "Print"],
Cell[254470, 5167, 1082, 16, 23, "Print"],
Cell[255555, 5185, 1133, 17, 23, "Print"],
Cell[256691, 5204, 1136, 17, 23, "Print"],
Cell[257830, 5223, 1071, 16, 23, "Print"],
Cell[258904, 5241, 1101, 16, 23, "Print"],
Cell[260008, 5259, 1073, 16, 23, "Print"],
Cell[261084, 5277, 1138, 17, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[262249, 5298, 856, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[263130, 5316, 750, 12, 32, "Input"],
Cell[CellGroupData[{
Cell[263905, 5332, 417, 6, 23, "Print"],
Cell[264325, 5340, 435, 6, 23, "Print"],
Cell[264763, 5348, 437, 6, 23, "Print"],
Cell[265203, 5356, 541, 10, 23, "Print"],
Cell[265747, 5368, 408, 6, 23, "Print"],
Cell[266158, 5376, 432, 6, 23, "Print"],
Cell[266593, 5384, 431, 6, 23, "Print"],
Cell[267027, 5392, 432, 6, 23, "Print"],
Cell[267462, 5400, 439, 6, 23, "Print"],
Cell[267904, 5408, 443, 7, 23, "Print"],
Cell[268350, 5417, 395, 6, 23, "Print"],
Cell[268748, 5425, 427, 6, 23, "Print"],
Cell[269178, 5433, 430, 6, 23, "Print"],
Cell[269611, 5441, 426, 6, 23, "Print"],
Cell[270040, 5449, 609, 11, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[270698, 5466, 544, 9, 32, "Input"],
Cell[CellGroupData[{
Cell[271267, 5479, 1495, 25, 23, "Print"],
Cell[272765, 5506, 1505, 25, 23, "Print"],
Cell[274273, 5533, 1032, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[275332, 5552, 916, 13, 32, "Input"],
Cell[CellGroupData[{
Cell[276273, 5569, 1576, 25, 55, "Input"],
Cell[CellGroupData[{
Cell[277874, 5598, 867, 16, 23, "Print"],
Cell[278744, 5616, 1090, 23, 23, "Print"],
Cell[279837, 5641, 845, 15, 23, "Print"],
Cell[280685, 5658, 1027, 20, 23, "Print"],
Cell[281715, 5680, 878, 16, 23, "Print"],
Cell[282596, 5698, 1363, 27, 23, "Print"],
Cell[283962, 5727, 962, 19, 23, "Print"],
Cell[284927, 5748, 1316, 26, 23, "Print"],
Cell[286246, 5776, 859, 15, 23, "Print"],
Cell[287108, 5793, 1126, 24, 23, "Print"],
Cell[288237, 5819, 1080, 23, 23, "Print"],
Cell[289320, 5844, 1168, 23, 23, "Print"],
Cell[290491, 5869, 1154, 23, 23, "Print"],
Cell[291648, 5894, 842, 15, 23, "Print"],
Cell[292493, 5911, 866, 16, 23, "Print"],
Cell[293362, 5929, 1057, 20, 23, "Print"],
Cell[294422, 5951, 1216, 23, 23, "Print"],
Cell[295641, 5976, 838, 15, 23, "Print"],
Cell[296482, 5993, 823, 15, 23, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
