(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    119691,       2189]
NotebookOptionsPosition[    115667,       2069]
NotebookOutlinePosition[    116022,       2085]
CellTagsIndexPosition[    115979,       2082]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6035389591727333`*^9, 3.6035389606320753`*^9}, {
  3.608281672604871*^9, 3.608281673651908*^9}, {3.6097575541555*^9, 
  3.609757557300255*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<~/feynrules-current\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.60353897829296*^9, 3.603539043421093*^9}, {
   3.633332218679607*^9, 3.6333322194542303`*^9}, 3.633333796845446*^9, {
   3.64301873415166*^9, 3.64301873665499*^9}, {3.6452720966860647`*^9, 
   3.645272098076991*^9}, {3.647076372652458*^9, 3.647076373114575*^9}, {
   3.718297838936696*^9, 3.718297843413649*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input",
 CellChangeTimes->{{3.603539048879374*^9, 3.603539054382785*^9}, {
  3.630748915770712*^9, 3.630748916976617*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.741598299337282*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.29\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"06 July 2017\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.29", " (" "06 July 2017", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.7415982993426323`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.7415982993502607`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.741598299357568*^9}],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.7415982993647423`*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.741598299371942*^9}],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.7415982993789673`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.741598299386077*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.741598299393362*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.74159829940031*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.729951950059991*^9, 3.729952278436795*^9, 3.729952325646605*^9, 
   3.72995260987576*^9, 3.729952962922834*^9, 3.729953084846094*^9, 
   3.730121265324163*^9, 3.7301213008935623`*^9, 3.730121667652791*^9, 
   3.730122193991741*^9, 3.73012233797051*^9, 3.7301224425800657`*^9, 
   3.7301225351158953`*^9, 3.730122751581316*^9, 3.730122795023859*^9, 
   3.730122869523324*^9, 3.730122990871256*^9, 3.73012311180118*^9, 
   3.730123186195875*^9, 3.730123480036356*^9, 3.730123582961767*^9, 
   3.7301236354759502`*^9, 3.730123691684342*^9, 3.7301237572459927`*^9, 
   3.730123834154978*^9, 3.730123957972454*^9, 3.7301244582743177`*^9, 
   3.73012452852756*^9, 3.730124750050458*^9, 3.730124829726712*^9, 
   3.730125292963676*^9, 3.7304353514790983`*^9, 3.730435722759234*^9, 
   3.730436135716392*^9, 3.730436221821114*^9, 3.730436297193357*^9, 
   3.73051769224257*^9, 3.730518012101918*^9, 3.7305194437498198`*^9, 
   3.7305195324404917`*^9, 3.730519897145948*^9, 3.730520010186061*^9, 
   3.7305208130841017`*^9, 3.7305231386201067`*^9, 3.73052322320433*^9, 
   3.7305233048270807`*^9, 3.730689829515807*^9, 3.7306902083261414`*^9, 
   3.73069041187989*^9, 3.7306904804994164`*^9, 3.7324234168417*^9, 
   3.732423685721868*^9, 3.7324238093392887`*^9, 3.732423847667292*^9, 
   3.7324239451706553`*^9, 3.7324240096017523`*^9, 3.732424058395377*^9, 
   3.7324241534049797`*^9, 3.7324242014378977`*^9, 3.732424259500163*^9, 
   3.732424311384761*^9, 3.7324243528013563`*^9, 3.732424439789448*^9, 
   3.732424492049941*^9, 3.73242456498462*^9, 3.732424765912302*^9, 
   3.732424796891325*^9, 3.732424846187379*^9, 3.732424881052598*^9, 
   3.732424935419279*^9, 3.73242497678479*^9, 3.732425069832994*^9, 
   3.733496693330534*^9, 3.733496870772231*^9, 3.734665299667211*^9, 
   3.735135853349392*^9, 3.7355365324829206`*^9, 3.735536608121174*^9, 
   3.735536699574275*^9, 3.735536810147746*^9, 3.735537309313246*^9, 
   3.73553736160332*^9, 3.7355374491527777`*^9, 3.735537498725417*^9, 
   3.735537560947548*^9, 3.735537608647689*^9, 3.735538110962996*^9, 
   3.7356242081989737`*^9, 3.735624300250996*^9, 3.735625632598453*^9, {
   3.73562574070181*^9, 3.735625768295258*^9}, 3.7415982994077168`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<~/feynrules-current/Models/DMEFT\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.603539061006528*^9, 3.603539075359961*^9}, {
   3.606550370901471*^9, 3.606550372067235*^9}, {3.608280713549712*^9, 
   3.608280720038208*^9}, {3.608280848612903*^9, 3.608280850051903*^9}, {
   3.610078232055901*^9, 3.610078244162396*^9}, {3.611032810906569*^9, 
   3.611032811729677*^9}, 3.611046032505571*^9, {3.611046080564261*^9, 
   3.6110460835240393`*^9}, {3.616920451742062*^9, 3.616920454335582*^9}, {
   3.61692081007111*^9, 3.616920811789462*^9}, {3.6169220902135057`*^9, 
   3.6169220916785192`*^9}, {3.627800218613393*^9, 3.6278002208210363`*^9}, {
   3.630748932272941*^9, 3.630748937906595*^9}, {3.633332239193083*^9, 
   3.6333322403879013`*^9}, 3.633333794100926*^9, {3.633759468942481*^9, 
   3.6337594703175983`*^9}, {3.635681641356083*^9, 3.6356816446148367`*^9}, {
   3.6376402973444223`*^9, 3.6376402986547117`*^9}, {3.639376919579711*^9, 
   3.639376921244483*^9}, {3.6405100299897413`*^9, 3.640510032443145*^9}, {
   3.643018741816877*^9, 3.643018742543559*^9}, 3.643024926442786*^9, {
   3.645273275267683*^9, 3.645273276634437*^9}, {3.645274930954957*^9, 
   3.645274932634717*^9}, {3.645770163878159*^9, 3.6457701691664543`*^9}, {
   3.645780013280984*^9, 3.645780013490704*^9}, {3.646026237633871*^9, 
   3.6460262398106728`*^9}, {3.6473477666176853`*^9, 3.647347767847106*^9}, {
   3.649402992381681*^9, 3.6494029933443527`*^9}, {3.7208839504802723`*^9, 
   3.720883952750535*^9}, 3.7209726087032843`*^9, {3.720972841081983*^9, 
   3.720972843383486*^9}, {3.7282297462215233`*^9, 3.728229747414996*^9}, {
   3.728235358429948*^9, 3.72823535984517*^9}, {3.7283615139164047`*^9, 
   3.728361517222829*^9}, {3.7283964257842216`*^9, 3.728396462455468*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM.fr\>\"", ",", "\"\<dm_eff_fermionic_2607.fr\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.633332249125042*^9, 3.633332249491701*^9}, {
   3.6337594763689528`*^9, 3.6337594776507893`*^9}, {3.6356816576884117`*^9, 
   3.6356816603749027`*^9}, {3.637640302808282*^9, 3.6376403082726*^9}, {
   3.637640716438528*^9, 3.6376407440268297`*^9}, 3.643024914860723*^9, {
   3.645273293611383*^9, 3.6452732956188726`*^9}, {3.645770176958198*^9, 
   3.645770177262162*^9}, {3.646026243920371*^9, 3.6460262460509453`*^9}, {
   3.647347782049244*^9, 3.64734778358805*^9}, {3.64940300547442*^9, 
   3.649403021810585*^9}, {3.6494051044305058`*^9, 3.649405106795322*^9}, {
   3.718297862947487*^9, 3.718297864414042*^9}, 3.718610286242124*^9, 
   3.718639940424657*^9, 3.720971921190851*^9, 3.720972617467078*^9, {
   3.721033821529249*^9, 3.721033832534338*^9}, {3.728229753309307*^9, 
   3.7282297645106993`*^9}, {3.72823124633844*^9, 3.728231277647326*^9}, {
   3.7282327094395103`*^9, 3.7282327116437263`*^9}, {3.728235363321434*^9, 
   3.728235364529028*^9}, 3.728396469271502*^9, {3.728627800585423*^9, 
   3.7286278041896467`*^9}, {3.728707007620411*^9, 3.728707008049713*^9}, {
   3.728707930989977*^9, 3.7287079317743177`*^9}, {3.729861104288949*^9, 
   3.7298611053190823`*^9}, {3.7298622684737253`*^9, 3.729862268904685*^9}, {
   3.7298701440583572`*^9, 3.729870146870408*^9}, {3.729878167809733*^9, 
   3.72987816818195*^9}, {3.729952969769082*^9, 3.729952970892894*^9}, {
   3.732423427795182*^9, 3.7324234341126013`*^9}, {3.732423556498592*^9, 
   3.7324235575488777`*^9}, {3.7324238153086452`*^9, 
   3.7324238209939327`*^9}, {3.733496702842581*^9, 3.733496702921619*^9}, {
   3.734665271556487*^9, 3.734665271772637*^9}, {3.7351358631775*^9, 
   3.7351358643629208`*^9}, {3.735625744942032*^9, 3.735625748305006*^9}, {
   3.74159817823461*^9, 3.741598183121932*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598309893854*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598309983955*^9}],

Cell[BoxData["\<\"A. E. Kuday F. Ozok, U. Saka\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598309989725*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.7415983099959993`*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.7415983100018797`*^9}],

Cell[BoxData["\<\"H. Zhang et al., arXiv:0912.4511v2\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.7415983100080013`*^9}],

Cell[BoxData["\<\"A. E. Kuday et al., arXiv:xxxx.xxxxx\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310012514*^9}],

Cell[BoxData["\<\"http://feynrules.irmp.ucl.ac.be/wiki/DMEFT/\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310017728*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310024576*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310028442*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310032399*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310235841*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310370413*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", 
   "\[InvisibleSpace]", "\<\"dm_eff_fermionic.fr\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "dm_eff_fermionic.fr", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.730436306076969*^9, 3.730517699738442*^9, 3.730518019579569*^9, 
   3.730519452637352*^9, 3.730519541091278*^9, 3.730520019714632*^9, 
   3.730520819361746*^9, 3.730523149741639*^9, 3.7305232310280533`*^9, 
   3.730523311731505*^9, 3.730689843610221*^9, 3.730690215520656*^9, 
   3.73069049239051*^9, 3.7324234371874237`*^9, 3.7324235855642233`*^9, 
   3.7324236938051987`*^9, {3.73242383228432*^9, 3.7324238560055113`*^9}, 
   3.732423956667605*^9, 3.732424016691312*^9, 3.7324240690155907`*^9, 
   3.7324241627204523`*^9, 3.7324242090836287`*^9, 3.732424267942244*^9, 
   3.7324243197092257`*^9, 3.7324243617336063`*^9, 3.732424447299817*^9, 
   3.732424500738596*^9, 3.7324245731545*^9, {3.732424776902442*^9, 
   3.7324248043817997`*^9}, 3.732424854174376*^9, 3.732424889190639*^9, 
   3.732424943336567*^9, 3.732424984310522*^9, 3.732425077378647*^9, 
   3.733496705111567*^9, 3.733496877906804*^9, 3.7346653063841753`*^9, 
   3.735135867587088*^9, 3.735536541103793*^9, 3.7355366157179956`*^9, 
   3.735536709180131*^9, 3.735536818425852*^9, 3.735537317175906*^9, 
   3.735537369279141*^9, 3.7355374572606792`*^9, 3.735537507643551*^9, 
   3.73553756790606*^9, 3.7355376163157797`*^9, 3.735538118894309*^9, 
   3.735624216298419*^9, 3.735624307430436*^9, 3.735625639646138*^9, {
   3.735625760628145*^9, 3.735625775529852*^9}, 3.741598310507739*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.639376820290628*^9, 3.6393768234379387`*^9}, {
  3.6393770865564947`*^9, 3.6393770912761908`*^9}, {3.6393771858866796`*^9, 
  3.6393771863740797`*^9}, {3.639377466478868*^9, 3.639377471110105*^9}, {
  3.6393796364789057`*^9, 3.639379637142768*^9}, {3.639989012839026*^9, 
  3.639989036648665*^9}, {3.641539947651075*^9, 3.641539950365509*^9}, {
  3.641789785973187*^9, 3.641789792194556*^9}, {3.643025183012186*^9, 
  3.643025185439151*^9}, {3.645274945395602*^9, 3.645274957019786*^9}, {
  3.6457800188411694`*^9, 3.645780019775859*^9}, {3.646377072375288*^9, 
  3.646377083707752*^9}, {3.646465411317153*^9, 3.646465413430913*^9}, {
  3.71861042935843*^9, 3.7186104299245663`*^9}, {3.721033818472142*^9, 
  3.7210338297522297`*^9}, {3.729864994961899*^9, 3.729865010596696*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Cabibbo.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["Loading restrictions from ", "Cabibbo.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{{3.728375496883532*^9, 3.72837551887713*^9}, 
   3.728396533254278*^9, 3.728399313083158*^9, 3.7283995975547256`*^9, 
   3.728399714715887*^9, 3.728400002130684*^9, 3.7286277888662443`*^9, 
   3.728627832586611*^9, 3.728705050557781*^9, 3.728705265158523*^9, 
   3.728706252849289*^9, 3.728707046487464*^9, 3.728707945110511*^9, 
   3.729861261025509*^9, 3.729861309445516*^9, 3.72986149925107*^9, 
   3.7298616503398438`*^9, 3.7298618130612583`*^9, 3.729862063677786*^9, 
   3.7298622815650377`*^9, 3.729862345261285*^9, 3.7298624404668007`*^9, 
   3.7298624900310097`*^9, 3.729862708379385*^9, 3.72986288968617*^9, 
   3.729863813763076*^9, 3.729863978518983*^9, 3.729864519890483*^9, 
   3.729864818662677*^9, {3.729864998980846*^9, 3.729865025838106*^9}, 
   3.7298651173627787`*^9, 3.729865240324095*^9, 3.7298654098034277`*^9, 
   3.7298654688059483`*^9, 3.729865670532834*^9, 3.729866362458041*^9, 
   3.729866455904552*^9, 3.7298665852832613`*^9, 3.729866729250293*^9, 
   3.7298668247877607`*^9, 3.729866894637246*^9, 3.7298688829229317`*^9, 
   3.729868986894759*^9, 3.729869092175262*^9, 3.7298691416411753`*^9, 
   3.729869350595932*^9, 3.729869468896679*^9, 3.7298698332788153`*^9, 
   3.729869937061274*^9, 3.729870070665999*^9, 3.729870151726583*^9, 
   3.729870219767988*^9, 3.729870403325255*^9, 3.729875756256075*^9, 
   3.729875966278767*^9, 3.7298760405464697`*^9, 3.72987613504071*^9, 
   3.729876387581377*^9, 3.729876467800847*^9, 3.729876573963682*^9, 
   3.729876700855055*^9, 3.729877007546611*^9, 3.729877173832335*^9, 
   3.7298775305983973`*^9, 3.7298782870584993`*^9, 3.729878392472478*^9, 
   3.729878501191098*^9, 3.7298787185165854`*^9, 3.729878803692607*^9, 
   3.729908240179924*^9, 3.729909455770431*^9, 3.729951703730692*^9, 
   3.7299518019555063`*^9, 3.729951962204784*^9, 3.729952290327548*^9, 
   3.729952338179461*^9, 3.729952621370555*^9, 3.729952975870016*^9, 
   3.729953122382971*^9, 3.730121309010099*^9, 3.730121678069911*^9, 
   3.73012220528373*^9, 3.730122348366508*^9, 3.730122454600917*^9, 
   3.730122547285653*^9, 3.730123001826736*^9, 3.730124469340516*^9, 
   3.730435751102736*^9, 3.7304361473635187`*^9, 3.730436232225215*^9, 
   3.730436310433288*^9, 3.730517702740624*^9, 3.730518024026568*^9, 
   3.730519456564851*^9, 3.730519544602075*^9, 3.7305200232621183`*^9, 
   3.730520845986899*^9, 3.7305231538531647`*^9, 3.730523233815296*^9, 
   3.730523315449236*^9, 3.7306898473434057`*^9, 3.730690219328947*^9, 
   3.730690438088409*^9, 3.730690496448803*^9, 3.732425130348133*^9, 
   3.733496711173266*^9, 3.733496881547503*^9, 3.734665312127419*^9, 
   3.735135873486875*^9, 3.7355367166916313`*^9, 3.735536823073392*^9, 
   3.735537321027617*^9, 3.735537372746114*^9, 3.735537460692404*^9, 
   3.735537511685985*^9, 3.7355375718302917`*^9, 3.735537621530583*^9, 
   3.735538123023221*^9, 3.735624220176672*^9, 3.7356243110687847`*^9, 
   3.735625643297282*^9, 3.735625780484221*^9, 3.741598313715774*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{{3.728375496883532*^9, 3.72837551887713*^9}, 
   3.728396533254278*^9, 3.728399313083158*^9, 3.7283995975547256`*^9, 
   3.728399714715887*^9, 3.728400002130684*^9, 3.7286277888662443`*^9, 
   3.728627832586611*^9, 3.728705050557781*^9, 3.728705265158523*^9, 
   3.728706252849289*^9, 3.728707046487464*^9, 3.728707945110511*^9, 
   3.729861261025509*^9, 3.729861309445516*^9, 3.72986149925107*^9, 
   3.7298616503398438`*^9, 3.7298618130612583`*^9, 3.729862063677786*^9, 
   3.7298622815650377`*^9, 3.729862345261285*^9, 3.7298624404668007`*^9, 
   3.7298624900310097`*^9, 3.729862708379385*^9, 3.72986288968617*^9, 
   3.729863813763076*^9, 3.729863978518983*^9, 3.729864519890483*^9, 
   3.729864818662677*^9, {3.729864998980846*^9, 3.729865025838106*^9}, 
   3.7298651173627787`*^9, 3.729865240324095*^9, 3.7298654098034277`*^9, 
   3.7298654688059483`*^9, 3.729865670532834*^9, 3.729866362458041*^9, 
   3.729866455904552*^9, 3.7298665852832613`*^9, 3.729866729250293*^9, 
   3.7298668247877607`*^9, 3.729866894637246*^9, 3.7298688829229317`*^9, 
   3.729868986894759*^9, 3.729869092175262*^9, 3.7298691416411753`*^9, 
   3.729869350595932*^9, 3.729869468896679*^9, 3.7298698332788153`*^9, 
   3.729869937061274*^9, 3.729870070665999*^9, 3.729870151726583*^9, 
   3.729870219767988*^9, 3.729870403325255*^9, 3.729875756256075*^9, 
   3.729875966278767*^9, 3.7298760405464697`*^9, 3.72987613504071*^9, 
   3.729876387581377*^9, 3.729876467800847*^9, 3.729876573963682*^9, 
   3.729876700855055*^9, 3.729877007546611*^9, 3.729877173832335*^9, 
   3.7298775305983973`*^9, 3.7298782870584993`*^9, 3.729878392472478*^9, 
   3.729878501191098*^9, 3.7298787185165854`*^9, 3.729878803692607*^9, 
   3.729908240179924*^9, 3.729909455770431*^9, 3.729951703730692*^9, 
   3.7299518019555063`*^9, 3.729951962204784*^9, 3.729952290327548*^9, 
   3.729952338179461*^9, 3.729952621370555*^9, 3.729952975870016*^9, 
   3.729953122382971*^9, 3.730121309010099*^9, 3.730121678069911*^9, 
   3.73012220528373*^9, 3.730122348366508*^9, 3.730122454600917*^9, 
   3.730122547285653*^9, 3.730123001826736*^9, 3.730124469340516*^9, 
   3.730435751102736*^9, 3.7304361473635187`*^9, 3.730436232225215*^9, 
   3.730436310433288*^9, 3.730517702740624*^9, 3.730518024026568*^9, 
   3.730519456564851*^9, 3.730519544602075*^9, 3.7305200232621183`*^9, 
   3.730520845986899*^9, 3.7305231538531647`*^9, 3.730523233815296*^9, 
   3.730523315449236*^9, 3.7306898473434057`*^9, 3.730690219328947*^9, 
   3.730690438088409*^9, 3.730690496448803*^9, 3.732425130348133*^9, 
   3.733496711173266*^9, 3.733496881547503*^9, 3.734665312127419*^9, 
   3.735135873486875*^9, 3.7355367166916313`*^9, 3.735536823073392*^9, 
   3.735537321027617*^9, 3.735537372746114*^9, 3.735537460692404*^9, 
   3.735537511685985*^9, 3.7355375718302917`*^9, 3.735537621530583*^9, 
   3.735538123023221*^9, 3.735624220176672*^9, 3.7356243110687847`*^9, 
   3.735625643297282*^9, 3.735625780484221*^9, 3.741598313911148*^9}],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{{3.728375496883532*^9, 3.72837551887713*^9}, 
   3.728396533254278*^9, 3.728399313083158*^9, 3.7283995975547256`*^9, 
   3.728399714715887*^9, 3.728400002130684*^9, 3.7286277888662443`*^9, 
   3.728627832586611*^9, 3.728705050557781*^9, 3.728705265158523*^9, 
   3.728706252849289*^9, 3.728707046487464*^9, 3.728707945110511*^9, 
   3.729861261025509*^9, 3.729861309445516*^9, 3.72986149925107*^9, 
   3.7298616503398438`*^9, 3.7298618130612583`*^9, 3.729862063677786*^9, 
   3.7298622815650377`*^9, 3.729862345261285*^9, 3.7298624404668007`*^9, 
   3.7298624900310097`*^9, 3.729862708379385*^9, 3.72986288968617*^9, 
   3.729863813763076*^9, 3.729863978518983*^9, 3.729864519890483*^9, 
   3.729864818662677*^9, {3.729864998980846*^9, 3.729865025838106*^9}, 
   3.7298651173627787`*^9, 3.729865240324095*^9, 3.7298654098034277`*^9, 
   3.7298654688059483`*^9, 3.729865670532834*^9, 3.729866362458041*^9, 
   3.729866455904552*^9, 3.7298665852832613`*^9, 3.729866729250293*^9, 
   3.7298668247877607`*^9, 3.729866894637246*^9, 3.7298688829229317`*^9, 
   3.729868986894759*^9, 3.729869092175262*^9, 3.7298691416411753`*^9, 
   3.729869350595932*^9, 3.729869468896679*^9, 3.7298698332788153`*^9, 
   3.729869937061274*^9, 3.729870070665999*^9, 3.729870151726583*^9, 
   3.729870219767988*^9, 3.729870403325255*^9, 3.729875756256075*^9, 
   3.729875966278767*^9, 3.7298760405464697`*^9, 3.72987613504071*^9, 
   3.729876387581377*^9, 3.729876467800847*^9, 3.729876573963682*^9, 
   3.729876700855055*^9, 3.729877007546611*^9, 3.729877173832335*^9, 
   3.7298775305983973`*^9, 3.7298782870584993`*^9, 3.729878392472478*^9, 
   3.729878501191098*^9, 3.7298787185165854`*^9, 3.729878803692607*^9, 
   3.729908240179924*^9, 3.729909455770431*^9, 3.729951703730692*^9, 
   3.7299518019555063`*^9, 3.729951962204784*^9, 3.729952290327548*^9, 
   3.729952338179461*^9, 3.729952621370555*^9, 3.729952975870016*^9, 
   3.729953122382971*^9, 3.730121309010099*^9, 3.730121678069911*^9, 
   3.73012220528373*^9, 3.730122348366508*^9, 3.730122454600917*^9, 
   3.730122547285653*^9, 3.730123001826736*^9, 3.730124469340516*^9, 
   3.730435751102736*^9, 3.7304361473635187`*^9, 3.730436232225215*^9, 
   3.730436310433288*^9, 3.730517702740624*^9, 3.730518024026568*^9, 
   3.730519456564851*^9, 3.730519544602075*^9, 3.7305200232621183`*^9, 
   3.730520845986899*^9, 3.7305231538531647`*^9, 3.730523233815296*^9, 
   3.730523315449236*^9, 3.7306898473434057`*^9, 3.730690219328947*^9, 
   3.730690438088409*^9, 3.730690496448803*^9, 3.732425130348133*^9, 
   3.733496711173266*^9, 3.733496881547503*^9, 3.734665312127419*^9, 
   3.735135873486875*^9, 3.7355367166916313`*^9, 3.735536823073392*^9, 
   3.735537321027617*^9, 3.735537372746114*^9, 3.735537460692404*^9, 
   3.735537511685985*^9, 3.7355375718302917`*^9, 3.735537621530583*^9, 
   3.735538123023221*^9, 3.735624220176672*^9, 3.7356243110687847`*^9, 
   3.735625643297282*^9, 3.735625780484221*^9, 3.741598314070277*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckHermiticity", "[", "LEffFDM", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.633332290865224*^9, 3.633332305905663*^9}, 
   3.63333373270155*^9, 3.6337594836385403`*^9, {3.6337598304792633`*^9, 
   3.633759842414878*^9}, {3.635681667322399*^9, 3.63568169987755*^9}, {
   3.637640325295994*^9, 3.637640326653831*^9}, {3.6494030879543467`*^9, 
   3.649403102697242*^9}, {3.649405111126108*^9, 3.649405113793882*^9}, 
   3.7186104374846487`*^9, 3.720973325877075*^9, 3.730123605497851*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvH1onktTYWiLoX0Mp1jqcvYanm5zdhN1wuO0ZQr0XWSuFLa
rV2iY1fIECqlvFxeRns5JLXQyigbdaIuayjqqiG/54/nPv8+/3y9RamCBBsK
hSIje8UtNPGbzCxzWaVXHDEmQp0VT4y6plNA+UUfPaQrJNN1xD+Cz07wV978
5z+JyYLuT3BtUVX8ELFpr70axjnb04eJo4KbgsUtZha17UQMHGjkHoTWltA8
KKUfK4FRllcPYOB3ajvMvvuvC8Za+H3QnuI5CHkDUuoS4uiYhyf8YCsvhuyK
gApY160bgAxlsNNSovfVkGWwtPPaShhWOxEBwyudY6Eopm4XbOttz4R6lV8b
PCfVGuELlc0gXGH74y8UrveY7kc8blTSYOjPoBnLiJIp/vPgufsZi2G644UA
+G6WjgOvGwqEMJFGz4Wbnbachj75Xy5DPrflJhxKS7sHOyTRzfChbLc4kLht
rDoHMlTLZbDscJcc7mpNug/nbtuugdU0VSvkiupNcKa23zaIOMh/NBdWeW2M
hBH+mnLIdA26A0ct2Sp4ZFzdCeNqZL2w6dJ7djjRb8TfCEsjf2VtJU6+9pTC
cmpzGaxRuzfCDT3pOvgpofE7dHP94S4g6tLlQdAl6wz3OpEWG3IchtkWN8A+
L9ob2FmrMMK6HE4/FDKKbG4Q1eLfDpCtZc+GHs0mL7ifmk6HgcE9ITD3pH4H
FMy4kAQpjl9T4dTydRmwaCcrGx5ld0vhxxv+pfDsas57yOhN7IabCzhWyByN
nlKBf4usTMh8YjGs0ZlZYo0dlUl0SNM5w4mokAUwWqjpSiBSUrR2YqKbe0M9
fC331cJ/Q0orzA3LEu0j3kpZmJdInMyknIKKD54l8J1M0a8k3il66/qY2CpJ
Xg2fP+tdNe0N6XU49ZCL3szS6jUSuHPP+Zn8DjPrQKGybeVb0hMjO2eMGJ7x
pwA+vbepBJrC8g1wEWWWCc6L/9YHj0TGWeBBX+NvyJsTbIVbOupDx4nql/0R
PgYz60oAjw9F419GIMdx3MGXmDR5myftMbP+Ax/gXJk=
  "]],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvGVNJTS6EVRRyG9TOfYqsvYanm5zdilq4VjlHKIrlOJK8Vu
7YiOXSFDJe9dusKwl0NS620lykadqMtaSemaefs9fzz3+ff557tInCpMtKFQ
KDKyFt4Zo6DBxDaV3vIREeMi1dkJxOhynQLKr/jqIV0hmaUj/hZ+dobj+fNf
fSceEPZ+gmsLbyeMERv22qmhyMWO/oM4KbwjXNJkYlPbT8bBoXreYWhtCsuH
UvrxYhhtbnkEg0aoHTDn4d8eGG8WDEA7ivcw5A9JqUuJk1Ne3vCDrbwIcioD
K2FVr24IMpQhzsuIi24wl8OS7vJVMPzBr0gYccslHorjqnbB9v6OLKhX+bfD
i1KtAb5W2QzDlbajf2DMeq9Z/sQTBiUNhn0PdlhOlEwP8IAX6zKWwHSny4Hw
3WwdF1Z0FcTAZBo9D2523nIO+p7+cg0KeE134FhaWg3slMQ2wsey3UlBxG1T
d3MhQ7VCBkuP9sjhruaUOui+bbsG3qWpmiFPXGuEjtpB22DisOCJO7ztszEK
RgZoyiDLNbgaTppzVDDTou6Gonuyfthw9T0nguj/M8AAS6LGs7cS/7V6S2EZ
tbEU3lN71sMNfek6+CmxfgS6uY56Com6dHkwnJd9nldBpMUzT8Bw26LncMCH
1ga7HygMsCqXOwhjGIU2N4nqpAl7yNFy5kCvRqMP3E9Np8OgkD4mzDul3wGF
DpdTIMXpayqcUbYuAxbuZOfAY5xeKfx4M6AEXgjlvoeM/uReuLmAa4Wsydjp
lfi32MqCrGfmrjU6EztJM43KItqn6Vzgr2jmAhgbo+lJJFIOaqclEd08n9fC
VrmfFv4dU1phXni2eB/x/sGF+cnEf1mUs1DxwbsYvpMpBpXE6sK3rk+JzZID
ofDVy/7VM9tIrz9Sj8zTm9havUYCd+655CjoNLEPnVG2r3pLemLk5E4RIzJ+
F8AXNZuKoTH8dBdcTJlthB4J3wZgZpTIDA/7GSYgf26IFW7prA2zENVvBiN9
u0zs64F8ARRbvvyEXCeLvR9R4VbNl/aZ2P8BGy9b5g==
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvH1olEpTYWijkJ6mc5lqcvYanm5Zdmlq4XLKHESXSdJV4rd
2jEcu0KG0Avq6AqjvRySWtQkyqY6UZc19HrV8vJ7/nju8+/zz3epMI2fZEGh
UCRkb7lnDbxGI8tYUu4pIMaFq7ITiJG3tXIou+alg3S5yFZLnOF/dYSjBYte
/SYe4vd0ww3SioRhYuM+axUUOFnTR4gT/Er+8mYji9p2Kg4ONnCPQHNzSAEU
008WwUjT28fQ/yf1Pcx99LcLxpt4/dCa4jEEowbF1BXEiUl3D/jZUnYRssv8
ymB1j3YQMhSBjiuJS28Fr4LFnbeDYGjVdDgMK3eKh8K46kTY1vc+C+qUPm3w
slijh6+VFkNwjeWvPzBmk7utDzFHr6DBkN8BdquIolm+C+HluszlMMPhqh/8
OFfLgXc6CmNgCo2eD7c5Rp+HXme+3YA8bnMlHE5Pr4Htotgm+ESyJ9mfuGPy
Xh5kKFdLYMmxLhlMbDlQBxfs2KmG92jKFsgV1hqgvWbAMoA4xHu6AFZ4bomA
4b7qUsh0CXgIJ0y5Snh8StUJBfclfbDx+id2GNFn3FcPiyNGs7cT/73zEMNS
alMJvK9ya4CbezO0sDup4Sd0dfnlxidqM2QB0Dn7AvcOkRYfnANDLS/Ww35P
WivsrJLrYXUeZwDGMKQWd4mq5DEbyNaw50H3JoMnPEjNoEP/wN5gmH9atwvy
7a4egBSH72lwdunGTCjdzcqFJ9g9Yvjlrm8xvLSO8wky+lJ64LZCjhkyJ2Jn
leHfMjMTMp+bOtZrjaxktRWVSbRJ1zrB6cjgxTA2Rt2VRKSkaqySia5u9bXw
ncxbA/8OK8wwPzRbuJ/4IHVJQQrxXxblHJR/9iiCHyXyAQXxofSDyzNii+jQ
OvjqZd/aOa2k15G0o846I0ujU4vg7r1X7HntRtbhs4q2oA+kJ0Zu3iQxLHOm
EL6o2VoEDaFnOuAyylwDXJjwox8ejxCY4BFv/RiMmh9ohtHttSFTRNWbgXCv
DiPrpl8UDwqnvo1DjsOUjTdRwB2PEvcaWf8BHCdcHQ==
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvH1ohGVRqSoU6HX6RxLXcZWy8stY1ddL7iMElei64S4UuzW
LuG0K2QIlVKXrjDay1FS620SZaNOqcsahbpqkd/zx3Off59/vqsFyfw4EwqF
IiZr4+bqeE16lr6o1DmaGBmkSI8hhtxXS6HklqsG0qVCSzVxlv/VBv7OXtEw
Rkzk932BW/PKYsaJTYfNFTDa1pz+izjJf8Rf06JnUTsvRMKRRu4JaGzxz4Yi
+rkCGGJoewq9f1DfwYwn/3phlIE3BM0pTqMwdEREXUucnHJ0gp9MJdcgu8Sr
BFb1qUcgQ+Zrs464+p6fByzsub8RBlTOBMHAUtsoKIisioWdA+/OQI3cvRPm
i1Ra+EZuMgo3mP78C8O2O1q6E89rZTToP+az0IMonOdpD/Pr0tbAVOubXvCD
lZoDH3TnhMEEGj0L7rbZcwW6Xhq8A3nclkdwPCWlBnYJI5rhM/HBeG9i+FR5
JmTI14th0aleCYxtPVoHl4fvU8JymrwVcgW1OrhINWzqQxzlPV8Oy5x3BsMg
T2UxZNr5VMNJQ4Ycnp5W9MDoCvEAbLr9kR1IdJ/w1MLC4N/pe4lz7U4iWExt
LoIVCodGuKM/VQ2/xDX+gMvsfjrwiepUiQ9cmn6V+4BIi/I7DwNMr9XDIWda
B+yplGphVSZnGIYx8kweEhXxfywgW8VeDB2bdc7wGDWVDr19+/1g1kXNfshf
ePMopFh/S4bzi7elwbwDrAx4lt0ngp8fehbC65s5HyFjIKEP7s7hGCFzMmJe
Cf65GJmQ+dLQvUWtZ8UrzahMokWK2hbOhPithBFhyt44IiVJZRZPXOZQXwvb
JW4q+G9cZoRZAemCI8THSauyE4hzZyiXofSTUwH8IJYOy4jVee/tXhBbhYmb
YcPrgU0LOkivv5JPLtXoWSqNUggPHLqxiNelZx3PlXVufE96YmRkThED02Zz
4KuaXQVQF3CpG7pQrHTQPub7EDwdHG2AJ9y0f2DoEl8j3NNV6z9NVLwdDnLt
1rPueoXyoGB6cAJyrKct3IjVuROhon496z8gl1yz
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvH1onktTYWiLoXeNp1jqcvYanm51bKbrhe6jCauRNcJ40qx
Wzui066QoRJ56XCFYS9HSS1sJcpGnVGXNeSlK/P2e/547vPv88/XX5QryHSg
UChysme8Y2Z+m5Vtrb7sl0pMjtFI0ohxtXolVJwNMEKGUjpVT/wteO8Gv5fM
bflKzBb0v4Oryq6kjRLbtjlrYKq7M+MbcUzQIFjYYWVTDYeT4XArbze0d0SW
QBnjYCWMsz27A8M+U7tg4a2/fTDFxh+EzhTfERg/LKMuIo6N+/jCN46Kcsip
D62Hjf36YchUhbstJvpfjAiGVb21y2DUjV8xMPqyewoUJTdmQIOlaz80qoMM
sEKmM8EnaocRuNTxyx8oXOMzNYh4yKSiwciv9GnBROmkkDmworlgIcx3PRMK
X83Qc2FdT6kQZtEYxTDBLfEEDDj64Tzk8zoa4Ghe3m3YLU1qh3flW8RhxI3j
V4sgU71EDqv39ilgRueOZjh74yYtvEpTd0KeqMkMp+uGHOnEEf692fCK37pY
GBOirYEsT/pNOGYrVMN9E5pemHpNboFt515zoolBP0NMsCr2u2QD8d9zXxms
obZXw2sa71a4diBfD99ltn6GXp5fvAVEfb6CDj0kJ3l1RFpKxCEY5Vj+EA76
0V7A3htKE2ws4g5BIbPM4RJRI/7hAjk6zkzo0272gzup+QwYFj4QAYuPGDdD
wbQzOyDF9WMunFyzugCWpbML4QFOvwy+vRRSBU+t4L6GTEtWP0wo5dohayxp
Uj3+LbCzIOuBrWel3soWa52oLKJLnt4d/oqLmAeThNq+TCIlR+ckJnp5P2yC
zxWBOvh3VGWHxVES0Xbi9Zz5JVnEf/spx6HyjW8lfCVXDqmIN8teet4ndkqz
V8CWx5blU16QXr/l7vEwWtk6o1YK07eens7vtrJ3HVMZlr0kPTELi8aJ0QW/
S+Gj2+sroTnqaA9cQJlhhnPSPg3CfbGpNrg70PQDxs8Kt8PE7qbICaLm6VBM
QI+VfSE0ng9FEx9+Qq7rhEsgsSXDKUE2YGX/BxpcW6o=
  "]],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvH1oiFKo6SoSyG9TOdY6jK2Wl5uteyq6wWX0ZS36DohXSl2
a5fotCtkSCVSF5eXYS9HSa236UXZqFPqsoa8dGXE7/njuc+/zz9fN0EKP9GM
QqFIyNq4+Xpek4FlKL3tGkeMCVZmxBNDb2lkUHrVXQvpMtFcDfEP/6Mt/JG7
pOEb8RB/4APcVFAVP0Fs2mephHF2lvTvxEn+Hf6KFgOL2nkmBo41co9CU0tA
LhTTTxfDUGPbI+jzhfoGZt2f6YexRt4ItKS4jMOwMTF1JXFyytkFvjOXFkJ2
pXclrB3QjEGG3M92FdHtpv9qWNJ3ax0MrPkdDINu28VCQUxtAuwcenMSahWe
nbBIrNbBVwqzcbjW/OtfGLnFea4nMVMnp8GAb77Wq4miWV6OsOhh+gqYZnPF
G/bO13BgeU9eJEyi0XNguG3EBeh+bvg65HFb7sCJ1NQHsEsU3QwfS/YIfYhR
U3ezIUOxRgJLj/dLYUJr8kO4OGqnCt6lKVohV1Cvh/PUo+a+xHHek8WwynVb
CAz2UpVBpr1vHZw0ZingiWllH4yrlgzBpmtv2UFEz19eOlgS8iNjB/Ffu4sY
llGbS2G10qkRbh1M08APiY1foIP9Vyc+UZMm9YWLMi5yy4m0WP9MGGhe+ByO
uNI6YF+NTAdrszmjMJJRYFZBVAp/WkG2mr0AOjfrXeEBahod+vgN+sOcs9pd
kG99JRlSbD6lwNllm9NhwW5WFjzFHhDD9xVeJfDSBs5byBhKGoDheRwTZE5G
z6rEv+UmJmQ+M/Zs1BhYQpUFlUm0StXYwd+h/kthdKSqP5FIOay2EBIdnJ7X
w3aphxrOTMhNMCcwQ7CfeO/wstwk4r+TlPNQ9s6lGPZKZKNyYl1Bt/1TYqvo
0AbY8HJo/ZwO0uv3lGOLtAaWWqsSwd17L8/jdRlYR/Llneu6SU+MrOwpYlD6
nzz44sH2YqgPPNcDl1Pm66Fj/OcReCIkzgiPeuh+wrCFfiYY0VUfME1Uvh4N
du8xsG54h/GgYHr4F+TYTFt5EA9eswgXDxpY/wEZP1uO
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwV030wE3AAxvF5Xa9kpReK81J5Xa7TxGm1Mb3cWO3kvFSnFakjci6VHFG7
2ZVy2ZG0SqUiTh3Vqr1ckZjK8m4LF3GaVRSH6eX3/PHc59/nn6+TIJkfZ0Kh
UMRk77kXdbxGPUtfet8xmhgZpMiIIYbcUUuh5LqLBtKlwgVq4hz/izX8lbuq
/icxkd/fB7fmP4gZJzYeNlfAaBtz+gRxiv+Qv7ZZz6K2nouEow3cFGhs9s+F
IvrZIhhieP8Uen2nfoJZj//2wCgDbxiaUxzGYOioiLqOODVt7wB7TSUFkF3u
WQ6r+9WjkCHzsV5PdLrt5w6Lu+/4woCq2SAYeN8mCgoiq2Nh6+Cn01Ajd2uF
hSKVFr6Vm4zBjaY//sDw7fYL3IiZWhkN+v/0XuhOFFp4rISFdelrYZpViSfs
XKzmwLsdeeEwgUbPgWHWuy9DlwtDNyGP2/wQjqemPoFtwogm+Ex8MN6LuHe6
Ihsy5BvEsPRkjwTGthytgyv27lPCCpq8BXIFtTq4SDVi6k0c4z1fAR847gyG
QR7KMsi09a6BU4YsOTw1o+iG0ZXiQdh4o4sdSHSb9NDC4uBfGXuI/z44iGAZ
takUVirsGuCOgTQ17Itr+A6X2/6w4xPVaRJvuCzjCvcukRbllwkDTAtewWFH
2kfYXSXVwupszggMZ+Sb3CMq4n9bQraKvQTaN+kc4TFqGh16+Qz4wZzzmv2Q
v7DkKKRYfU2G88q2pcP8A6wseIbdL4Kf73kUw6ubOV2QMZjQD8PyOEbInIqw
KMc/ZyMTMl8aOrao9ax4pRmVSbRMVdvA2RC/1TAiXNkTR6QkqcziicvtXtXC
DxJXFfw7LjPCnIAMwRHio6Q1uQnEf6cpl6C016EIdoqlIzJiTX677QtiizBx
M6x/M7hp/kfS60TyiWUaPUulUQrhgUPXFvHa9KzjF2Wtvu2kJ0ZW9jQxMH0u
D75+sqsI6gIudEBnymIdXBnzbRieCo42wBRX7W8YutTHCHe31frPEBXvRoJc
OvSsW56hPCiYGZqEHKsZS1ciU2sWJhrQs/4DGYlbnw==
  "]],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwV031QC3AAxvH1OpTS6EVRp0Kv0zmWuoytlpdbLbt0vdAxSjmUrpPElWK3
dkTHriRD6FUdLi/DXo6SWqVJKRt1Sl3WKKUr8/Z7/nju8+/zz3eFII2fZEKh
UMRkHdxzOl6LnqUvr3KLJ8aGKnISiOG31FIoueqhgXSpcIGa+Jv/2RZOFSxt
miAe4g98gpuKqhMmiS37zRUw3s6c/oM4w6/hr2zTs6hdp2PhWDM3HRrbggqg
iH6yBIYbOh5Bv2/UtzD3/t9+GGfgjUBzius4jBgTUVcRZ2ZdXOEHU0kxZFf6
VsKGAfUYZMgCbFcTV9wM9IalfbfWweD6X6EwpMouDgpiG/bArqG32VAj9+qC
l0UqLXwlNxmHa02//4HRW1wWeBFPaWU0GDThb+VNFFr4OMHLD7NWwkybMl/Y
u1DNgbd7CqNhCo2eDyNtoy5Aj7PD1yGP21YDJzMyHsBuYUwrfCzem+xH3Dlb
mwcZ8jViWH6sXwL3tKc+hI47dylhLU3eDrmCRh20Vo2a+hPHeU8cYbXbtjAY
6qOsgEx7/3twxpArh8fnFH0wvk48BFuuvWeHEL1++mhhadhUzg7iv05XEayg
tpbDOoVzM9w6mKmGn5Kav0EH++/OfKI6U+IPl+Rc5N4m0uICT8Fg0+LncMSN
9gb21Uu1sCGPMwqjGUUmd4iK5GlLyFaxF0GXVp0bPEjNpEO/gMFAmH9Gsxvy
rcpSIcXmSxqcV7E5CxYlsnLhCfaACH6841MKL23gvIeMoZQBGFnIMULmTIxF
Jf65G5mQ+czQs1GtZyUrzahMomWG2g7+Cg9cBmOilf1JRMphlVky0cH5eSPs
lHiq4N9JmRHmB+cIDhDvHl5ekEL8l005D6UfXEtgr1g6KiPeK3pn/5TYLjy0
ATa9HFo//w3p9Ufa0SUaPUulUQph4r4r1rxuPevIOVnXunekJ0Zu3iwxJOt3
IXzxYHsJ1AWf7YHulIU66JTwdQQeD4s3wHRP7TSMWBxghFHdjUFzRMXr0VCP
Hj3rhm8EDwrmhn9Cjs2cpSdxxME8UjSoZ/0HGWxbgw==
  "]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LSM", "+", "LEffFDM"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.603539435628551*^9, 3.603539443511031*^9}, {
   3.633332257675256*^9, 3.633332273874855*^9}, 3.633332330927515*^9, {
   3.633759485057345*^9, 3.6337594896329927`*^9}, {3.633759845728799*^9, 
   3.633759845998361*^9}, {3.635681693519002*^9, 3.635681708124132*^9}, 
   3.637640353419092*^9, 3.649403113712747*^9, {3.6494051166588993`*^9, 
   3.649405119212523*^9}, 3.718610450824383*^9, 3.720973334313877*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{
  3.720977416100871*^9, 3.721035067154976*^9, 3.721101742667479*^9, 
   3.721404169198628*^9, 3.721450688857436*^9, 3.723280179995021*^9, 
   3.723280760261292*^9, 3.726242262895215*^9, 3.7262425336930923`*^9, 
   3.726242838797464*^9, 3.726243513229642*^9, 3.726243808219833*^9, 
   3.726244110956771*^9, 3.726244821808632*^9, 3.7274065029491177`*^9, 
   3.728233021202914*^9, 3.72823428132407*^9, 3.728235418715507*^9, 
   3.728306476026841*^9, 3.728307173105641*^9, 3.72831124493682*^9, 
   3.728311397975603*^9, 3.728362122831985*^9, 3.728363875935769*^9, 
   3.728375545177993*^9, 3.728396566179488*^9, 3.7283993470605707`*^9, 
   3.728399627284782*^9, 3.728399729907917*^9, {3.728400031636848*^9, 
   3.728400057935452*^9}, 3.728627857596401*^9, 3.728705077474483*^9, 
   3.728705290856675*^9, 3.728706398558255*^9, 3.7287070821626263`*^9, 
   3.728707214883053*^9, 3.7287079726421432`*^9, 3.7298615330836563`*^9, 
   3.729865145095428*^9, 3.7298702477458353`*^9, 3.729870432571031*^9, 
   3.7298761825670443`*^9, 3.729876415817247*^9, 3.729877203846703*^9, 
   3.729877575644223*^9, 3.729908305904049*^9, 3.729909494904448*^9, 
   3.729951736335334*^9, 3.729952002289941*^9, 3.7299523728822327`*^9, 
   3.730124242341495*^9, 3.7301246011180563`*^9, 3.730124774542385*^9, 
   3.7301253235400047`*^9, {3.7304363311440783`*^9, 3.730436353027918*^9}, 
   3.730517717018818*^9, 3.730518053117877*^9, 3.730519560957429*^9, 
   3.730520036731188*^9, 3.730520090517762*^9, 3.73052085888549*^9, 
   3.730523167206098*^9, 3.7305232464174223`*^9, 3.730523326502534*^9, 
   3.7306898594917297`*^9, 3.7306902291430607`*^9, 3.730690506436764*^9, 
   3.7324251469738894`*^9, 3.7334967234025908`*^9, 3.733496893471472*^9, 
   3.734665324729237*^9, 3.7351359025877323`*^9, 3.7355367545774717`*^9, 
   3.735536837697131*^9, 3.735538135127639*^9, 3.735624347488254*^9, 
   3.735625654318467*^9, 3.735625790782716*^9, 3.741598326406013*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{
  3.720977416100871*^9, 3.721035067154976*^9, 3.721101742667479*^9, 
   3.721404169198628*^9, 3.721450688857436*^9, 3.723280179995021*^9, 
   3.723280760261292*^9, 3.726242262895215*^9, 3.7262425336930923`*^9, 
   3.726242838797464*^9, 3.726243513229642*^9, 3.726243808219833*^9, 
   3.726244110956771*^9, 3.726244821808632*^9, 3.7274065029491177`*^9, 
   3.728233021202914*^9, 3.72823428132407*^9, 3.728235418715507*^9, 
   3.728306476026841*^9, 3.728307173105641*^9, 3.72831124493682*^9, 
   3.728311397975603*^9, 3.728362122831985*^9, 3.728363875935769*^9, 
   3.728375545177993*^9, 3.728396566179488*^9, 3.7283993470605707`*^9, 
   3.728399627284782*^9, 3.728399729907917*^9, {3.728400031636848*^9, 
   3.728400057935452*^9}, 3.728627857596401*^9, 3.728705077474483*^9, 
   3.728705290856675*^9, 3.728706398558255*^9, 3.7287070821626263`*^9, 
   3.728707214883053*^9, 3.7287079726421432`*^9, 3.7298615330836563`*^9, 
   3.729865145095428*^9, 3.7298702477458353`*^9, 3.729870432571031*^9, 
   3.7298761825670443`*^9, 3.729876415817247*^9, 3.729877203846703*^9, 
   3.729877575644223*^9, 3.729908305904049*^9, 3.729909494904448*^9, 
   3.729951736335334*^9, 3.729952002289941*^9, 3.7299523728822327`*^9, 
   3.730124242341495*^9, 3.7301246011180563`*^9, 3.730124774542385*^9, 
   3.7301253235400047`*^9, {3.7304363311440783`*^9, 3.730436353027918*^9}, 
   3.730517717018818*^9, 3.730518053117877*^9, 3.730519560957429*^9, 
   3.730520036731188*^9, 3.730520090517762*^9, 3.73052085888549*^9, 
   3.730523167206098*^9, 3.7305232464174223`*^9, 3.730523326502534*^9, 
   3.7306898594917297`*^9, 3.7306902291430607`*^9, 3.730690506436764*^9, 
   3.7324251469738894`*^9, 3.7334967234025908`*^9, 3.733496893471472*^9, 
   3.734665324729237*^9, 3.7351359025877323`*^9, 3.7355367545774717`*^9, 
   3.735536837697131*^9, 3.735538135127639*^9, 3.735624347488254*^9, 
   3.735625654318467*^9, 3.735625790782716*^9, 3.7415983264085827`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.720977416100871*^9, 3.721035067154976*^9, 3.721101742667479*^9, 
   3.721404169198628*^9, 3.721450688857436*^9, 3.723280179995021*^9, 
   3.723280760261292*^9, 3.726242262895215*^9, 3.7262425336930923`*^9, 
   3.726242838797464*^9, 3.726243513229642*^9, 3.726243808219833*^9, 
   3.726244110956771*^9, 3.726244821808632*^9, 3.7274065029491177`*^9, 
   3.728233021202914*^9, 3.72823428132407*^9, 3.728235418715507*^9, 
   3.728306476026841*^9, 3.728307173105641*^9, 3.72831124493682*^9, 
   3.728311397975603*^9, 3.728362122831985*^9, 3.728363875935769*^9, 
   3.728375545177993*^9, 3.728396566179488*^9, 3.7283993470605707`*^9, 
   3.728399627284782*^9, 3.728399729907917*^9, {3.728400031636848*^9, 
   3.728400057935452*^9}, 3.728627857596401*^9, 3.728705077474483*^9, 
   3.728705290856675*^9, 3.728706398558255*^9, 3.7287070821626263`*^9, 
   3.728707214883053*^9, 3.7287079726421432`*^9, 3.7298615330836563`*^9, 
   3.729865145095428*^9, 3.7298702477458353`*^9, 3.729870432571031*^9, 
   3.7298761825670443`*^9, 3.729876415817247*^9, 3.729877203846703*^9, 
   3.729877575644223*^9, 3.729908305904049*^9, 3.729909494904448*^9, 
   3.729951736335334*^9, 3.729952002289941*^9, 3.7299523728822327`*^9, 
   3.730124242341495*^9, 3.7301246011180563`*^9, 3.730124774542385*^9, 
   3.7301253235400047`*^9, {3.7304363311440783`*^9, 3.730436353027918*^9}, 
   3.730517717018818*^9, 3.730518053117877*^9, 3.730519560957429*^9, 
   3.730520036731188*^9, 3.730520090517762*^9, 3.73052085888549*^9, 
   3.730523167206098*^9, 3.7305232464174223`*^9, 3.730523326502534*^9, 
   3.7306898594917297`*^9, 3.7306902291430607`*^9, 3.730690506436764*^9, 
   3.7324251469738894`*^9, 3.7334967234025908`*^9, 3.733496893471472*^9, 
   3.734665324729237*^9, 3.7351359025877323`*^9, 3.7355367545774717`*^9, 
   3.735536837697131*^9, 3.735538135127639*^9, 3.735624347488254*^9, 
   3.735625654318467*^9, 3.735625790782716*^9, 3.741598326412381*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{
  3.720977416100871*^9, 3.721035067154976*^9, 3.721101742667479*^9, 
   3.721404169198628*^9, 3.721450688857436*^9, 3.723280179995021*^9, 
   3.723280760261292*^9, 3.726242262895215*^9, 3.7262425336930923`*^9, 
   3.726242838797464*^9, 3.726243513229642*^9, 3.726243808219833*^9, 
   3.726244110956771*^9, 3.726244821808632*^9, 3.7274065029491177`*^9, 
   3.728233021202914*^9, 3.72823428132407*^9, 3.728235418715507*^9, 
   3.728306476026841*^9, 3.728307173105641*^9, 3.72831124493682*^9, 
   3.728311397975603*^9, 3.728362122831985*^9, 3.728363875935769*^9, 
   3.728375545177993*^9, 3.728396566179488*^9, 3.7283993470605707`*^9, 
   3.728399627284782*^9, 3.728399729907917*^9, {3.728400031636848*^9, 
   3.728400057935452*^9}, 3.728627857596401*^9, 3.728705077474483*^9, 
   3.728705290856675*^9, 3.728706398558255*^9, 3.7287070821626263`*^9, 
   3.728707214883053*^9, 3.7287079726421432`*^9, 3.7298615330836563`*^9, 
   3.729865145095428*^9, 3.7298702477458353`*^9, 3.729870432571031*^9, 
   3.7298761825670443`*^9, 3.729876415817247*^9, 3.729877203846703*^9, 
   3.729877575644223*^9, 3.729908305904049*^9, 3.729909494904448*^9, 
   3.729951736335334*^9, 3.729952002289941*^9, 3.7299523728822327`*^9, 
   3.730124242341495*^9, 3.7301246011180563`*^9, 3.730124774542385*^9, 
   3.7301253235400047`*^9, {3.7304363311440783`*^9, 3.730436353027918*^9}, 
   3.730517717018818*^9, 3.730518053117877*^9, 3.730519560957429*^9, 
   3.730520036731188*^9, 3.730520090517762*^9, 3.73052085888549*^9, 
   3.730523167206098*^9, 3.7305232464174223`*^9, 3.730523326502534*^9, 
   3.7306898594917297`*^9, 3.7306902291430607`*^9, 3.730690506436764*^9, 
   3.7324251469738894`*^9, 3.7334967234025908`*^9, 3.733496893471472*^9, 
   3.734665324729237*^9, 3.7351359025877323`*^9, 3.7355367545774717`*^9, 
   3.735536837697131*^9, 3.735538135127639*^9, 3.735624347488254*^9, 
   3.735625654318467*^9, 3.735625790782716*^9, 3.741598332975634*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "47", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "47", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  47, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 47, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.720977416100871*^9, 3.721035067154976*^9, 3.721101742667479*^9, 
   3.721404169198628*^9, 3.721450688857436*^9, 3.723280179995021*^9, 
   3.723280760261292*^9, 3.726242262895215*^9, 3.7262425336930923`*^9, 
   3.726242838797464*^9, 3.726243513229642*^9, 3.726243808219833*^9, 
   3.726244110956771*^9, 3.726244821808632*^9, 3.7274065029491177`*^9, 
   3.728233021202914*^9, 3.72823428132407*^9, 3.728235418715507*^9, 
   3.728306476026841*^9, 3.728307173105641*^9, 3.72831124493682*^9, 
   3.728311397975603*^9, 3.728362122831985*^9, 3.728363875935769*^9, 
   3.728375545177993*^9, 3.728396566179488*^9, 3.7283993470605707`*^9, 
   3.728399627284782*^9, 3.728399729907917*^9, {3.728400031636848*^9, 
   3.728400057935452*^9}, 3.728627857596401*^9, 3.728705077474483*^9, 
   3.728705290856675*^9, 3.728706398558255*^9, 3.7287070821626263`*^9, 
   3.728707214883053*^9, 3.7287079726421432`*^9, 3.7298615330836563`*^9, 
   3.729865145095428*^9, 3.7298702477458353`*^9, 3.729870432571031*^9, 
   3.7298761825670443`*^9, 3.729876415817247*^9, 3.729877203846703*^9, 
   3.729877575644223*^9, 3.729908305904049*^9, 3.729909494904448*^9, 
   3.729951736335334*^9, 3.729952002289941*^9, 3.7299523728822327`*^9, 
   3.730124242341495*^9, 3.7301246011180563`*^9, 3.730124774542385*^9, 
   3.7301253235400047`*^9, {3.7304363311440783`*^9, 3.730436353027918*^9}, 
   3.730517717018818*^9, 3.730518053117877*^9, 3.730519560957429*^9, 
   3.730520036731188*^9, 3.730520090517762*^9, 3.73052085888549*^9, 
   3.730523167206098*^9, 3.7305232464174223`*^9, 3.730523326502534*^9, 
   3.7306898594917297`*^9, 3.7306902291430607`*^9, 3.730690506436764*^9, 
   3.7324251469738894`*^9, 3.7334967234025908`*^9, 3.733496893471472*^9, 
   3.734665324729237*^9, 3.7351359025877323`*^9, 3.7355367545774717`*^9, 
   3.735536837697131*^9, 3.735538135127639*^9, 3.735624347488254*^9, 
   3.735625654318467*^9, 3.735625790782716*^9, 3.741598333085328*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"37", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[37, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.720977416100871*^9, 3.721035067154976*^9, 3.721101742667479*^9, 
   3.721404169198628*^9, 3.721450688857436*^9, 3.723280179995021*^9, 
   3.723280760261292*^9, 3.726242262895215*^9, 3.7262425336930923`*^9, 
   3.726242838797464*^9, 3.726243513229642*^9, 3.726243808219833*^9, 
   3.726244110956771*^9, 3.726244821808632*^9, 3.7274065029491177`*^9, 
   3.728233021202914*^9, 3.72823428132407*^9, 3.728235418715507*^9, 
   3.728306476026841*^9, 3.728307173105641*^9, 3.72831124493682*^9, 
   3.728311397975603*^9, 3.728362122831985*^9, 3.728363875935769*^9, 
   3.728375545177993*^9, 3.728396566179488*^9, 3.7283993470605707`*^9, 
   3.728399627284782*^9, 3.728399729907917*^9, {3.728400031636848*^9, 
   3.728400057935452*^9}, 3.728627857596401*^9, 3.728705077474483*^9, 
   3.728705290856675*^9, 3.728706398558255*^9, 3.7287070821626263`*^9, 
   3.728707214883053*^9, 3.7287079726421432`*^9, 3.7298615330836563`*^9, 
   3.729865145095428*^9, 3.7298702477458353`*^9, 3.729870432571031*^9, 
   3.7298761825670443`*^9, 3.729876415817247*^9, 3.729877203846703*^9, 
   3.729877575644223*^9, 3.729908305904049*^9, 3.729909494904448*^9, 
   3.729951736335334*^9, 3.729952002289941*^9, 3.7299523728822327`*^9, 
   3.730124242341495*^9, 3.7301246011180563`*^9, 3.730124774542385*^9, 
   3.7301253235400047`*^9, {3.7304363311440783`*^9, 3.730436353027918*^9}, 
   3.730517717018818*^9, 3.730518053117877*^9, 3.730519560957429*^9, 
   3.730520036731188*^9, 3.730520090517762*^9, 3.73052085888549*^9, 
   3.730523167206098*^9, 3.7305232464174223`*^9, 3.730523326502534*^9, 
   3.7306898594917297`*^9, 3.7306902291430607`*^9, 3.730690506436764*^9, 
   3.7324251469738894`*^9, 3.7334967234025908`*^9, 3.733496893471472*^9, 
   3.734665324729237*^9, 3.7351359025877323`*^9, 3.7355367545774717`*^9, 
   3.735536837697131*^9, 3.735538135127639*^9, 3.735624347488254*^9, 
   3.735625654318467*^9, 3.735625790782716*^9, 3.741598338004138*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LEffFDM"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<dm_eff_fermionic_2607\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.603600645725746*^9, 3.6036006566228743`*^9}, {
   3.606550334098661*^9, 3.60655033664305*^9}, {3.608451188889968*^9, 
   3.608451204251935*^9}, 3.60845124249209*^9, {3.633332357749588*^9, 
   3.633332371706971*^9}, {3.633333594923254*^9, 3.6333336099891357`*^9}, {
   3.633333692998436*^9, 3.633333708244873*^9}, {3.633759523248143*^9, 
   3.63375952406321*^9}, 3.6337595816874228`*^9, {3.633759861480113*^9, 
   3.633759861782745*^9}, {3.635681799753024*^9, 3.635681812948553*^9}, {
   3.637640540300961*^9, 3.6376405694259853`*^9}, {3.637640663087901*^9, 
   3.637640663759862*^9}, {3.637647387697893*^9, 3.637647389712125*^9}, {
   3.637648387110936*^9, 3.637648387849903*^9}, {3.639389319458922*^9, 
   3.639389319865039*^9}, {3.64051094238649*^9, 3.640510950609267*^9}, {
   3.6430250002334414`*^9, 3.643025002692279*^9}, {3.643025047978877*^9, 
   3.643025060082522*^9}, {3.6452745024778748`*^9, 3.6452745079012833`*^9}, {
   3.645276460101131*^9, 3.645276462419408*^9}, 3.645770304766233*^9, {
   3.64578008286651*^9, 3.6457800832087*^9}, {3.646026325649763*^9, 
   3.646026327751546*^9}, {3.647347838972896*^9, 3.6473478401093903`*^9}, {
   3.64940322069949*^9, 3.6494032361730423`*^9}, {3.649405161701861*^9, 
   3.6494051712548447`*^9}, {3.650089489692153*^9, 3.6500894903785*^9}, {
   3.720978044470365*^9, 3.7209780578344297`*^9}, {3.723280302696563*^9, 
   3.7232803038230352`*^9}, {3.7282330407464542`*^9, 3.728233041400764*^9}, 
   3.72839656645964*^9, {3.728627810269557*^9, 3.728627810957498*^9}, {
   3.728707013121993*^9, 3.7287070139854517`*^9}, {3.728708015727203*^9, 
   3.728708016587886*^9}, {3.7298615451454477`*^9, 3.729861545718453*^9}, {
   3.729878171493979*^9, 3.729878171909658*^9}, {3.732425157813808*^9, 
   3.732425158748254*^9}, {3.733496728437648*^9, 3.733496729465488*^9}, {
   3.734665266954382*^9, 3.7346652671404867`*^9}, {3.7355336924548197`*^9, 
   3.735533693094076*^9}, {3.735625793149774*^9, 3.7356257957115717`*^9}, {
   3.7415981918176727`*^9, 3.741598194457128*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/Epbe2CaSY57GLNQjGHZE6tHlxsIeZY5JAMLZEyotTbklNi
5RQWaRtZLkSpiZqk6TVMm2aaQtHqKSGKovz/F78+V7++ktaeSm0Ih8NRwAaF
k2NyJyXPlZlMOmhma+dQm69QpAZ9jfN1aJ+z5LkcZPdOZfVgVWkS0wBu63vN
qPFOvoPGR+v8aLFk1fUG/m42B9HVTl73Ozh4t+VBg5eKzA9QNdyVjYa67vUy
lhKvNycvEQwGdPvJYMTX8QW60fViSgFjScCOOqxScSpYEacuQS2FltICULjn
fkQfT54YDZg+e7WOnn+xbnRxuu3QCoaXrQTR/u7oog3sCYaSlOeUTK0MB7Tg
ssPEbQeLp0ZY1JyWzesAuR5fG7o/oB7tBM8CuzNozoRpCa1W9VM7qCRhMQeg
QS7OR6Ocf7n8K0pemAy96JqSzybDBCo+sgnKPZRcNnKfsrzwG3cX/IAtkQs1
0htKmNu1bzTL6OcngK8NUs34AyX/rKfywA==
  "]],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YhuSwC81yiBmJOaQeXFhozKnIsQ1Jk7KJUm8SJqGc
wpo0hywXsloRNUnT6zRtGmuKlbV6bpAVRfn/L359rn59Ezv7FaogDoeTBxvm
T0+KbZS8KbIZCWhkGxZRk6skSga6WpYa0UFbxZscZM0XoiawtjKFaQb3NQNG
dN4tPkATYnqf0LJEw/U7+Lvb5kcNPSHqD3DYvedA/bd52Z9g+WhfLhp8/awR
sZQ4ndKCZNDv6bWkghGBsxt0p8+nTwfjiOcItW4LBRlgdbysAt0q2aosAvlm
+yv6eu5lakDJwt0mehVg7ejKrPJkGwyvWvejWnVM6Q72eCMpxVeUzKyPelTg
mlXP7QLLZsZZ1JiZG9INch0uJWoZkk30gJeewzlUqtOvonXlWnoEFpOw2GNw
TCwoRKNtf/mhd5T4mCxN1D0lX61jOlRwauLJHZTctnC9OU74TdmLfsD2yOV6
4QMlzOPGN5oz/xSaBKZ1ZNZMvVDyD6b58g4=
  "]],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/Epbe2CiWk57EIIxYZkTqkHF1smNqeiIc0hiZRNlHqTMC1W
TmGRNmS5EKWImqTpNTZtGmsKZa2eG0RRlP//4tfn6tc3qb1f3RHG4XBksOHo
6UmJg5JXdS6TDVrYhnnU5isTKkCfZqERHXRUvlaD7MFFahNYq0xnmsFd3YAF
Nfkle2iiqOcBrUhac76Bv9utIXStm9f3Dg77dzxo6EaW+wHKR3vz0XDnoy6V
pcTrLShKA0OBnsMMMOrr7Brd6g2aM8F4EjhC7ZvJ4iywJkFRiVrLrMoSMPrA
/Yw+n78wKjB7zrWBXn2xbnRpRnuyCUZWrYZQfZ+ofAt7gpH00itKjKujgQ5w
xW7mdoIVxnEWtUjzeV0g1+PToodDiolu8DKwP4sWGMzLaJ1cT4/AUhIRdwyO
ScTFaKzjr5DvoiTI5OiEt5R8towZUPGpTVDtoeRGw33J88Jvyl3yA7bFLNYn
31HC3K9/o3mmB34KqJ2UqqaeKPkHqdPybg==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 4, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YHJLDLtYIxYzkuFYPLqzRnBUNyWFpkbKJWr0tOSWU
U2NNmkOWC1GKKJKmF9u0abamTFmr5wZZUZT//+LX5+rXV9A1WN8TxuFwimCj
sTOTIislb/X5jBg0s81LqMVdHi8D3crlFnTYKn9TgOzRdXor2FCdybSB+5oh
M7rgFR2gqYn9HrRSYLp7B393O4KoSRUx8AGOevecaNBWlP8JVunUhWj43bMm
naXE5SouzQCDvv7jLDAmdHmP7qgDxmwwmfhO0IttIT8HrE2RydGt8q1qCRh7
5PCj/qtXpg4UL9o30dsQ60BX57rPtsHomvUgqh1IrNjBHm8sU3pLyey6ztcD
rl0Yub1g5ew4i5pzCyP6QK7T3Y0ej8gmVOCN73AeLZ42GtDGKi09AaUkKukU
1Iv4ZWiC9a8k0k5JgMnTxD9Q8tWun0b55xaewkmJTcl9LXDBb8oh+QE741aa
hI+UME8b32jBgicyDRQZcuumXij5B6ih8ko=
  "]],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpbblgmlMOuxBCMaxlTq0edmEhNqeiIc2hpUkZUepNckoo
p7BIO4hciFJEkTS9m9naNFtTKFo9N4iiKP//xa/P1a9vcnuvqiOEw+FIYUOC
6QmRlZIXlZjJBY1swyK66y2NVoBe9VIj2m+teKkG2cOrtCawtjKDaQb39H1G
dN4v2keT4rQ+VJ68YX8Df7dbg+hGN0/3Dg75d9xo0CEVf4DlIz35aKj9QZ/G
UuLxFBSlg8GA9igTjPy6uEEtPa+GLDCBBI7Rc3OKMBusSVRUoKZSU2UJKDh0
PqFPl8+MEsxduN1CbV+sE12Z1ZyawYiq9SA6oIsrs2CPP5whs1Eysz4S6ADX
zg3cTlA+M8aixpx8XhfIdXs16NGgYrwbvA4czKEFU4ZVtK58gB6DMhIefwKO
ioTFaIz1rzDslpJXJk8f7aLks2V0ChWe7fKr3ZQ41NxniQd+k86SH7Atark+
5Y4S5n7zG5XM+8JSwdgHl3LykZJ/rYnzGA==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "47", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{14., {0., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "47", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  47, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 47, "."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YHFoOu9AsFDNLNofUgwvLNOZUNCSHpTUpI0q9SU6J
lbMt0pjIhSg1USRNr8OmTTNNsaLVc4OsKMr/f/Hrc/Xrm9zarW4P4XA4MthA
9OSY2E7Jq1rKSEALWzeH7niKYxWgRzNfj/bay19VIHtwIWoAq5VpTCO4a+ix
oMZH8R6axO/yoqXJq9fv4O9WcwBd1YbpP8CBx20XGriVST/BsiFdLhp6/WQQ
sZS43fL8VDDg6zpMB6OCZzeoVfdmzgATiM+Gnm4KBZlgZaKiHN0o3lAWgtEH
zhf05dzPVIGSWcc6ehVknejidNvxJhhZYQqgfXp+iRV7vMG0oitKpkxDvnZw
5dTM7QBLp0ZY1JKVG9YJcl2eNvSwXzGqBS99+zOofMK8jNaU9VEbWEQi4o/A
YbGgAI2z/+WFOyh5Y7INsXeUfDUNT6CCkx2eykXJrYbrz3HDb9xZ+AO2xCzU
Cu8pYR7WvtEcozc8BVzSuarGnyn5B66O8ys=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"37", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[37, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6MZloOuxALxRxac1rqwYVljBmKHJJTEimbptSb5JRY
OYVFmkPkQlariZqk6cVMm2aaYkWr5wZZUZT//+LX5+rXN7GtX90RwuFwcmF6
/vSExE7JqzqHyQJNbN0Cuu8pFihAT9NiPTpoL39Vgaz5QtwA1ihTmUbwQDtg
Qg2PkkM0QdjjRUsT16/fwd/dlgC63h3W9wHqH/dcaMCRm/MJlo30ytDQ6yet
mKXE7c4rSAEDvh5LGhgVPLtBd3rfjOlgHPFZUdt2kigDrIpXlKNbxVtKOcg3
O1/Ql3M/Uw1mzd9uoldB1okuz7afbIO8irUAqusTluxgL3I4teiKkpm1EV8H
uGozcjvB0pkxFjVlysK6QK7L045ahhTj3eCl72gOzZsyrqCaMh21gkUkIvYY
HJWICtEY+19++C0lb0y2VnBHyVfz6BQqOt2PVLkocTRx/VI3/Cad8h+wNXqp
NumeEuZh4xuVGrzhyaCGV6mefKbkH6bD8gU=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "37"}],
  SequenceForm["Flavor expansion of the vertices: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 37],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YmOSwCyEUc2jNHFo9uNgajTkVOaQNSUMZTa3eJKfE
yimsSXPIciFqNVEkTa9h2jQ0xYpWzw2iKOT/v/j1ufr1TWztVmmCOBxOHkwf
OTEqdFDyrMplskELWzuLWr3FfDnobZyrQ/scimclyO6dptSDVWVpTAO4reu1
oMZ74Q6aENN5h5Ymmp2v4M9mcwA1d4Ro30D9/ZYbDVzm5b6DMkOXGA12PuhS
WEo8HklBKhjwddrSwYjP4wt0o+vFlAHGEZ8dPVpPEmSCFfFyBbpWvFZWBEbu
uZ7QpxM/Uwlmz1ytouefrAtdmFIfrIPh5csBtF8bU7KBPd5gmvScksllg08D
Lh2ZuG1g6eQwi1qyxCHtINftVaO2AflIB3jm251GJeOmRbRa1k/toJSExe6D
Q0JBIRrt+M0PvaLkhcnR8a8p+WgaGkcFh1ae0k3JZSPXL/LAb8xV9A22RM3X
JN1QwtyufKEi411oMmj+61GNPVLyD7Bv82E=
  "]],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpbblwaCY57EIIxRxazCH1sAvLNOZU5JDmkNakjCj1Jjm1
UE6ZNWkOkQtRaqImaXo3M20aa4rV1uq5QRRF+f8vfn2ufn1TugaU3WEcDqcI
NsqfmxZZKQkoC5g80MQ2LaMHngqBDPS0rTSjQ9bqgAJkT67TW8B6eSbTCh5q
B03oold0hCbH9z+h0hSj/Q383esIocY+nuYdHPXuu9CQo6jgA6waVxei4fZn
bTpLidstKckAQ77+0yww5uvyFt1VBw3ZYCLxmVHLTqowB6xNklWj2xXb8jKQ
f+J8RV+v/EwdmLd0t4XavlgnujavOt8Bo2o2QuiwJr5yF3vRY5nlNkp0G+O+
blBvMXB7QKlukkVNuYW8XpDr8qjQ0xHZVB944zteQCWzhnW0oWqYmsFyEplw
Bk6IhKVonPWvOOKOkiCTrxXcU/LZPjGLCi8OohUuShxtXL/YDb8ZZ9kP2Bm7
2pj6QAnzuPmNihefItJAr55VzrxQ8g+xr/OT
  "]],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cckgOuxAyxbDkuFYPu7BGY05FDslYS6SMptTbklML
5RRbk+aQ5UJWiiiSpnfDtGloyla0em5MVhTl/7/49bn69U3vHlQowzgcTglM
Gzc7JbBR8qYQMgWgmW1eQi2eygQp6GlfbkGHbbI3Ochar7JawYYaPtMG7muG
zOjCs+AATUtSP6GSdJPjA/zd7QygJlXEQBDUPu+50MBtifATrB7vL0bDHS+a
LJYSt7u0PBsMeNVHOWBs6OIG3el/N+aCKcR7jJ5vZ/DywLpUqQzdqtyqEYFx
VqcP9V36mXqwYPFuE7WHWCe6Otdzug1G1xoC6MhAUtUO9mLG+GI7JXrDuFcJ
rp8bub2gRD/Boub84og+kOvy9KBHo9JJFXjtPZxHS2eMa2hj9Qg9BsUkKvkE
1Al4FWii7a8s8o6Sd6ZQk3BPyVeHbgblnVli5C5Kbtu5/iI3/Kadoh+wK36l
KeOBEuZx4xstWniKzASDn3bF9Csl/7TV9AM=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "45"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 45],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YhuSwi4VMMYe0ObV6ZhcWwpyKhmQsiZTRlHqT2CSU
U2xNGhO5kNWKKJKmd8O0aaYpFK2eG0RRlP//4tfn6tdX2NGv0oRxOBwpTM+f
mhQ7KXlR5TO5oJVtXEB3/PI4JehXLzahg86Kl2qQtZ+nN4N1lSKmBdzVDVjR
uXvxHpqS0BNAFUKL+w383WoLoRZtRN87qL/f9qKhK2n+B1g+2itBw90PunSW
Ep+vsDgDDAV7HJlgzNfpJWrrfTVngUkkeICebKYKssGaZGUFuiHfqCwF+XbP
E/p09szUgrnz1+uo64v1oMsznUebYHSVKYQO9SWU2bDHGxHJXJRMm0aDGnD1
xMztAhXT4yxqzZFEdINcr78TdQwrJ7TgRXB/Fi00mlfQ+vIhegDKSFTiITgm
FpSg8c6/oshrSl6ZPF3cDSWfrWNGVHC8w6v2UnKl5j4X+OBn8JT+gO2xSw2p
t5Qwd2vfaMFcIDINHJm8VBkeKfkHrjzzIw==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "3.283096999999998`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Squared matrix elent compute in ", 3.283096999999998, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YHJLDLoRQDEtzbPWwiy0T5hQaklNrkbKJUm8So4Vy
CkOaEbmQ1YookqZ3bNOmmaZQ0+q5QRRF+f8vfn2ufn2T2vsUnUEcDicfNhQ5
NSGwUuJXCJkc0MjWz6N7ntJoGehRLjSgA9ZyfyXImi9Tm8AaeTrTDO5r+o3o
7IPgAE2MVXlRSdL69Rv4u9MaQNd7QnrfwaGHXRcasOcLP0DpiFqEBl8/alJZ
StzugqI0MOBTWTLAiK/zG3Rb/WrIBOOJ7wg9MyXzs8CqBFk5ulW6JS8BI83O
Z/T54oWpBnPmHJuo7Yt1okvTHScmMLxiNYBqe2PLtrHHG04X2yjRr474OsGV
MwO3C5Tox1jUmC0K6Qa5Lk8HahmUjfeAV77DGbRg0rCM1kq19AgUk7C4Y3BU
wC9GY6x/haEOSl6ZXE30LSWfLaOTKP90j1fposSu5L7kueGnc5b8gG1Ri3XJ
d5Qw9xvfaN6sNzQFXOM31uieKPkHqbvyaQ==
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.024399000000002502`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Decay widths computed in ", 0.024399000000002502`, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cGloOuxAyxRzS5rDUMy6skcMcanJITkmTMppSb5JT
Qo6xRdpGlgtRq4kiaXqxTZtmawo1rZ4bRFGU///i1+fq1ze5vb+2M4TD4Uhg
Wt7MpMhGSaA2j8kBDWzDMmr2yGLloKd5pREdtCkCVSB7dJmmApUVQqYJ3NcM
GNAFn+gATeL3etGy5M2bN/B3tzWIbvaEqd9BrW/PhQbtkrwPsHy0T4yG3jxq
0lhK3O6ConQw6O+1ZIDRX+e36E7fqz4TTCB+K3pmShFkgdWJcgVqlBkrpCDv
yPmMPl+8MDVgzpJjG73+Yp3o2lzHiQmMrNQF0SE1v3QHe1EjwpJrSmZ1o/5O
cONMz+0Cy2bHWdSQLQ7rBrkuTwdqGZZP9IBX/sN5tGBav47WlQ9RK1hCIuKP
wTGRoBiNs/0VhjsoeWVyNbF3lHy2jE2jglNzVJWLEnsz9yXfDb8pp/QHbItZ
rU+5p4R52PpG8xe84amgeFGlnHqi5B+pvPJ4
  "]],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cckgOuxDLFDNam1Orh11sIYc5FDkkhyWRsolSb0tO
LVZOYSZtI8uFKEUUSdOLbdo0NGWKVs8NsqIo///Fr8/Vr29qe39NZwiHw5HC
hmOmJ4R2Sl5r8hgRaGbr51GbtyROCXqbFxrQQXvZayXI7l/wG0FVuYBpAnc0
A2bU8CjcRVMSeh5Qearp+h383WoNoCZ1WN8HOPy47UYDDmneJ6gY7ZWgoddP
Gj5LiceTX5gBBnw9B5lgdPDsBt3sfTNmgUnEd4ieWtN42WBVsrIMtZRYyovB
mH2XH/WfvzDVoGjOuYFeBVkXujTTcWwFIytWA6i2L6F0E3tRIwLZFSX61VFf
J7hyauR2gXL9GIuacyRh3SDX7e1AD4aU42rw0rc3i+ZPGZfRWoWWHoIyEpF4
BOqEvCI03v5XEO6k5I3J1cTdUvLVoptCeSe2qEo3JY5m7ovYA79JV/EP2Ba7
WJd2Rwlzv/6Nig0P4emgaK1RNflMyT+p2fJ9
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4ccmg57ELIiBmtGZZ62IW1yZnCkJySJmU0pd6WnFoo
p7BIGyIXolYTNUnTi5k2DU2xslbPDaIoyv9/8etz9eub1NZX1RHE4XDyYLqo
qXGhnZLXqlxGBJrYunl011McowA96oV6dMCufC0H2cPz1AawWiVgGsE9bb8J
nX0U7qOJvJ4HVJ60dvUG/m63BNC17hDNO6h73HGhAUde7gdYOtIrQYOvnrSp
LCVut7QgDQx4eyzpYOTX6TW61es3ZoLxxGtFbZvJ/CywIkGhRM3FZpUMjDp0
vqAvZz6mEhTN3Wygl1+sE12abj/eBMPLVgPooIZXsoW9iGFB0SUlhtURbwe4
YjNyO0G5YZRFTdmSkC6Q6/K0o5YhxVg3eOE9mEGlk8ZltKZ0kFrBIhIWdwTq
hfxCNNb+lx96Q4mfydHG3FLy2ayfRPknuxHlLkocaq5P7IbfhFP2A7ZGL9Ym
31HC3K9/o+LZh9AUkJPRVD3xTMk/pUDx3A==
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTbtwyCE57EIsFHNozlIPu7DQ2BwKQxqWRMqIUm+SU4uV
U1ikDVkuRK0mapKmd8y0aWgKtbV6bpAVRfn/L359rn59kzoHZF1BHA6nADYa
OTcttFLileUy2aCebVxCje7yaAnoViw3oUPWKq8UZI8vBc2gvDqNaQEP1IN6
VPskPEQTY3sfUXHS5vU7+LvX7kc3VSH9H+Do074T9dsLcj/ByvG+fDT4+lkt
YClxuQqLU0G/p9eUDkYEzm/Q3T6fLgOMJx4zatlJ5meCtQmSKtRQbqguBSOP
Ha/o68UbUwdmL95uo7YA60BX55WnO2BYzYYfHe6PrdjFXvhYWpmNEs3GuKcL
XLfouN2gWDPJovqs/JAekOt0K1HTiGRKBV55jhbQwlndGlpfOUzNYBkJjTsB
J4T8EjTG+lfEu6XEx+Soo+8o+WqbmEX5Z8ZwqZMSu4L7JnLBb8ZR+gN2RK00
JN9TwjxsfaMi7SMvBRTntcpnXij5B6et8is=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog3EcxvEpbblwaEgOuxDLFDPSHFv9cbFlcphDYUhOSaSMKPUmYRIr
p7BIYyIXolYTRdL0OmzaNNOUraa3/jeIoii/38XT5+rpm9jaV9UexOPxcmDD
wulJqY2SQFUWIwNNbO0CuucuilKBbu1iHTpgKw2Ug+zRpbge1KglTAO4r+s3
oYYn6QGaENPtQUsS12/ewN+dZg5d7xL0voPDT7tOlLvLyfoAlaM9cjT45lkn
ZilxuXLzU0DO221JBSO+zm9Rc8+rMQ2MI14reradJEoHK+JVpehW0Za6EBQe
OXyo78LPVIKyefsmev3FOtDl2baTbTCsbI1DB3tjis3YCx+RKK4pmVkb9baD
q2dGfgdYMjPOoqYMuaAT5DvdbahlSDXRBV55D+fQXL1xBa1WDlIrqCChscfg
mFRUgEbb/vJC7JS8Mpm6qHtKPpvG9KjodC+83EnJnZbvz3bBb8pR+AO2RC7V
JD1QwjxufKPZBk9IMqhQNGqmXij5B6e88i4=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTbtwaKblsAshU8ys5Zx6RrFGzpRz2pBEyohSb5JTC+UU
W6Q5RC5ErSZqkqZ3DtOm2ZqyFa2eG0RRlP//4tfn6tc3vr2vShPE4XCyYMP8
mUmJlZKXKhkjBY1s3SK671IIlKCreakeHbCqXspB9vgyqQGsLhUzjeCBtt+I
znskh2icsNuNFsWvX7+Bv7utAXS9K6T3HRz27DnQwG2W7AMsGe3JRIOvn7RJ
LCVOZ3ZuMhjwdptSwIiv8xt0p+fVkArGEK8ZtWwniNLAililCt1SbJXmg/xj
uw/1XfiZSlC6cLeJ2r5YO7oyqz7dBsPK9AF0sFdYuIO98BFxgY0SnX7UqwHX
LAZuB1ikG2dRY3pmSCfIdbjUqGlIOdEFXnmP5tDsacMqWlMySM1gAQmNPgHH
JKI8NMr6l8O7o+SVydAK7in5bBmbRkVn++HlDkpum7l+uRN+U/b8H7Atcrk2
4YES5nHjG5XPu3mJoLC4qXrqmZJ/psPyEA==
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsow2EYBvApTbtwaEgOuxAyxbDWzCH1jYstkzOFIW1ImpQRpf5JTi2U
U2yRNkQuZKWIImn6G6ZNY02ZslbfDbKiKO978fTruXh6ktt7q7UhHA4nDzLE
n54Q2Sh5qxYzOaCZrV9Ad93yGCXoVi82oP22srcKkLVepjWCNSoh0wTu6fvM
6JxHtI8mxXU/oaXJa/Z38He7NYCudYXpPsAhz44TDdzmiT9BxUiPFA21P+vT
WEpcLllBOhjwdh9mgFHB8xt0q8dvygQTiPcIPdtMEWSBlYnKMtQit6iKQL7V
4UN9F69MFZgzf7eBXgdZB7o8oznZBCPKjQF0QBdXsoV/kcPC4mtKDMYRrxZc
PTNxO8BSwxiLmrOlYZ0g1+nWoIeDyvEu8Mp7MIvKpkwraK1igB6BxSQ8/hgc
FQkK0VjbXz7vjhI/k6uPuafkq2V0ChWc7kZWOCm5VXNfJS7YTTqKfsC26KW6
lAdKmMf1b1Qy98RLxV7ZXDP5Qsk/qkrygg==
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YhuSwCyFTzCFtTqmHXWyhYQ45S4akSRlNqTfJqYUc
wyLNJsuFqNVETdL0Gps2DU2haPXcIIqi/P8Xvz5Xv77xbb2VqgAOhyOBaflT
4yI7JS+VWUwGaGBrFlCztyhCDnqbFmvRfnvJiwJkD86S6kFlqZBpAHc1fQZ0
9l60h8ZFdd+h0vh1xxv4u93iR9e7gtTvoPZ+x436ryRZH6BsuEeMBjoeNEks
JR5PTl4y6Pd1W1LAsK+TS9TU86pPBWOIz4rajAmCNLA8Vl6CbhVtlRaA/APX
E/p0+sxUgBnzzk304ot1ocvT7UdGMLRszY8OqKOKTdjjDQkLLyjRrQ37VOCq
Tc/tAKW6URY1pIuDOkGu29uOWgblY13guW9/Bs2Z1K+gVbIBagULSUj0ITgi
EuSjkfa/3GAnJa9MpibimpLP5pFJVHBs5inclFw1cZ+zPfCbcBX8gK3hS9UJ
N5QwtxvfaPbsXXAiOFfXqJx4pOQfqxnynQ==
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpbblwiGk57EIjU8xozTH1sAsLOVM0JIelRcqIUm8SmxbK
KbZIs4lciFpN1CRNr5lp09AUylo9N4iiKP//xa/P1a9vSudAXXcYh8PJg43G
zkxLnJS81uUyUtDMNi2iu/5SvhL0q5aa0SFnxWs1yB6ep7WA9ZViphXc0w6a
0fkHyT6aLOi7RxUp66438He7PYSuq3n97+Dow44XDbnzcj/A8nGNHA13PWrT
WEp8vvzCdDAU6LNlgDFfp1eoVRM0ZYKJJGBHHRaRMAusSVJWoFulW5XFYOyh
5xl9PnthakHpwvUmevnFetCV2a5jCxhVZQyhw/2CMiv2osfEJZeUGIzjgW5w
zWHi9oAKwySLmrPlvF6Q6/V3obYR5ZQavAgczKH5etMq2lA+TO1gCYlMOAIn
JMIiNN75VxBxTUmQydHybyj5bJvQo8KT3ehqLyVuFfdF5oOfzlP8A3bELTeK
bilh7ja+Udn8fUQquHShqtc9UfIPrkDzEA==
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cGpLDLhYLxYy0OSz14GJrhM2haEgbkkgZUas3ySmx
cgqLNIcsF6IUUSRNr8PGpqEpW02rxwWyoij//8Wvz9Wvr6C5S6UL4nA4Ulg/
b3xEZKXEp8pmxKCZrZlBLa6iaAXo0szWoj1Wpa8cZPfOhXWgujSVqQe39d1m
1Pgk2kETY9sf0RLB8tU7+LvZ6EeX20I6P8D+py0H6r+RZn+CckOHBA2+etYL
WUqcztz8FNDvbt9PAyMDp9foRserKR2MJ+4D9GQ9iZ8BViQolOha0VqpDOTt
2T2o58zLVILiadsqehlg7ej8pPZoHQwvW/KjvZ2xxRvYixhILbykZGLJ4NaB
iycmbgtYMjHEouZMSUgryHW4tOh+n2K4Dbxw706huWOmBbRK3ksPwEISFncI
Dor4BWiM9S8v1EbJK5Olj76l5KthcAzlH1siyh2U3Gi43hwn/Ebtsh+wKWqu
OumeEuZh5RvNMT6GJoNvdxr16Asl/7E+83E=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cYloOuxAyxYzWnJZ6cGGZhjkUDckpLVI2UepNckoo
p9iaNCPjQpSaKJKm12naNGOKlbV6bpAVRfn/L359rn59E1t6qtqCOBxODmwg
anJMZKPkrSqbEYMmtnYetbiKeHLQpV6oQ/tsZW9KkN0/T6kHVQoh0wDuaHtN
6OyjaBdN4He50ZJE49U7+LvZ5EeNnSHdH+DA45YD9d/kZH+CpUMaKRp89axN
YSlxOnPzU0G/p+sgDYwMnF6jGxqfIR2MIx4remJOEmSAFfHyMnS9aF0hA6P2
7a/o65mXqQTFc7dr6GWAtaNL061HZjC8XO9Hdd384g3sRQwKCy8pmdIPedrA
lRMDtx0smRphUVOmNKQD5DpcrehBv3y0E7zw7M2guROGZbS6VEetYCEJiz0E
h0WCAjTG9pcXekuJj8nS8u4o+WocnkAFx5YIpYOSGzXXK3HCb9wu+wGboxdr
ku4pYR5Wv1HJrDs0Gdx+UqvGXyj5B6918zk=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTbtwiGk57EIIxRxajmv14MIyzVnRkBzWWqRsmlq9SU4J
5bCwJm2IXIhSRJE0vcamTTNNIdbquUFWFOX/v/j1ufr1Teroq+0K4XA4BTB9
9OSYyEbJW20ekwNa2MZ5dNtTypeBHuVCEzpgq3xTgOz+RWozWCdPZ1rAHW2/
BZ19EO2iiQK1Fy1PMtvfwd/NtgBqVoX1foD6hy0XGrgpyPsEKwyafDTU/qhN
ZSlxuwuL08CAT32QAUYFz67RDY3flAnGE98herqeLMwCqxNklai11CqXgNH7
zmf0+fyFqQFz5hxr6FWQdaLG6c7jdTCiaiWA6noFZRvYixxKl15RMrVi8HWB
y6cmbjdYPjXCopbs/LAekOvydKIHg7JRFXjp25tBCydMS2h9hY4eglISHncE
DouEJWis7a+I56DEz+Rq+beUfLUOT6DCk+1IhYuSGyX3ReyG37hT8gO2xyw2
JN9RwtyvfqPiWS8vBTS+KuvGnyj5B68U8y4=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTbtwyKHlsIs1C8UcWo5LPbiwkDNFQ3JqiZQRtXqT2CRW
TmGRZmS5ELWaqEmaXmPTprGmULR6UiMrivL/X/z6XP36CjsH67pDOBxOHmws
emZaYqPktS6HyQINbNMiavKUxMpBj2KpGR22VbxWg+zRhbgFrK9MZVrBfdWQ
AdV5JQdoEl/5gJYJN+wB8He33Y9u9IUNfIBj3j0X6r/Jy/kEy9X9uWio/VEl
Zilxu/MLU0C/T2lOA6OCZ9foTv+bPh1MID4LajWKBBlgTaK8At0u2a6UgdFH
zmf0+fyFqQWzFhxb6FWQdaIrc10nRjCiat2PjgzwS3ewFzmeWnxFyey62tcN
rln13B6wbHaSRQ2ZuWG9INfl6ULNo/KpPvDSdziP5mv1q2hD+Qi1gMUkPP4Y
nJAIitA4218Bz0HJG5Otir2l5KttQosKTk2R1S5KbhTcF6kbfhqn7AfsiFlu
FN1RwtxvfqNS3QMvGQy8K+o1T5T8A7Ib85A=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Multi-Fermion operators are not yet fully \
supported!\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YhpbDLoRQzKzlnHrYxdYIm0PRkOaQRMqIUm+SUwvl
FBZpNpELWa2ImtD0zmHaNDSFmlbPDTJRlP//4tfn6tc3oblb1RLE4XByYAP8
yTGRnRKfSsKIQSNbM4due4qjFKBHM1+L9tqVvnKQtZwl14Hq0lSmHtzR9RjR
mQfRLhov6LhHZQmrF2/g72ajH11tD+l6Bwcetlyo/ypH8gHKhzqz0eCLR10y
S4nbnZufAvq9HdY0MCJwfImaO18N6WAs8e6jNlOiMAOsiFMo0Y3ijdJCkG9x
PqPPJy9MJSievV5HHQHWiS5OaQ9NYHjZih/t6xKUmLHHG0wtclCiXxnytoDL
NgO3FZTpR1jUmJkd0gZyXR4tau1XjLaD5969aTR3wrCEVsn76D5YRMJiDsBh
kbAAjbb/5YVeU/LKZOmibij5bBieQIVH27xyFyVXGu6L1A2/cWfhD9gUuVCd
eEsJc7f2jUpn7kOTwNMvjXr8iZJ/sPrzbQ==
  "]],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4ccshxF0IoZpZsDqkHF5bJmSImGUualE1T05vklFg5
hUWaQ5YLWa2IIml6xzZtmmnK1LR6bhBFUf7/i1+fq1/flK6BenkQh8MRwTRR
M5N8CyX+eiEjAA1s8yJqdJfFSEB3+1ILOmSp8teArOkqvRVskGYybeCBatCA
6h75h2hyXJ8HrUjZuHkDf/dkAXRDEaJ8BzWP+040YBMJP8BKbX8BGnzzpEpn
KXG5xEUZYMDbZ84CI78ubtHd/ld9NphIvMfo+U4qLwesTZJUodtl29ISMMrk
8KG+yxemDhQs2LdQ6xfrQFfmuk93wPDq9QCqVsaV72IvYiSz1ErJ7LrWKwfX
zvXcHrBidpxFDbkFIb0g1+nuRs3DkgkFeO09mkfF0/pVtLFSTY/BUhKWcAKO
8XnFaKzlrzDUTskrk6eKuaPks2NsGuWdGSNqnJTY2rkv+S74TTlKfsDO6OWm
1HtKmIfNbzRf5wlNA0fjZQ1Tz5T8A6jE8ks=
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 4, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS6YHJLDLjRCMYe0ObV6cGFtcphDkUNySiJlE6XeJEZC
jmGRtpHlQlariSJpejc2bZppitW0em6QFUX5/y9+fa5+fVM6h+q6Qzgcjhg2
Fj03I7RQ4q/LZ3JBLdu4ihrcZbFS0N261oSOWGT+apA1Xqc1gwp5BtMCHimH
tejSk/AYTY7v96AVKTu2d/D3oD2A7vSFDX6AY0+HTjRwJ87/BCsnBkRoqO1Z
mcZS4nIVFqeDAW+/KROMCl7eovsDb5osMJF4zeiFXsDPBmuSpDJUV6aTl4LR
Rscr+nrlY2rB3BX7HmoNsg50Y6HrTA9GVm0HUNVgfPk+9njjGRIrJfPbE95u
cOtCw+0BK+anWFSbIwrrBblOdxdqGpVO94E33pNFtHBWs4nWV6qoGZSQiIRT
cFLIL0HjLH9F4XZK3pg8Zew9JV9tk7Mo/9zAq3ZSctfK9RW44Kd2lP6AHTHr
DYIHSpjH3W+0YMkTngouC9oV6hdK/gGpsfJq
  "]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{14., {1., 8.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "75", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 75, " ."],
  Editable->False]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cGpLDLoRQzGg5LvXMLrZGY05FQ3JYa5GyaWr1Jjnl
VE6xRdpG5EKUIoqk6TVMm8aaMkWr5wZRFOX/v/j1ufr1TWnrUXWEcDicQpiR
Nz4icFDyospnhKCVrZ9Dt7ySWDnoVc83oH0OxYsSZPfO0xvBmopMpgnc1vda
0RmfYAdNjtc+oNKUFecb+LvREkRXNGHd76DRt+lGg9eF+R+gzKQrQEOdj/p0
lhKPp6gkAwz6tftZYPTX6RW6rnu1ZIOJxH+AnthT+TlgVZJcgdoktgoxyNtz
BdDA2TNTDQpnb9bQyy/WhS5OtR/ZwchKcxA1dMeXr2MvaiCz7JKSCbPJ3wEu
n1i4naB0YohFrbkFYV0g1+1tR/f75cMa8MK/O40WjVmW0FqZgR6AZSQi4RAc
FPBL0TjHX3H4DSWvTJ4+9paSz+bBMZR/vBWldFNyreY+izzwG3WJf8DWmIW6
1DtKmPvVb1Q08xCeBn5MGmpGnyj5B7Ah80s=
  "]],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cmmk57EKzUMwh2RxSD7uwRs4UOaQ5JE3Kpq1WbxKj
hXIKi7QhciGrFVEkTa/TtGloCrW1em6QFaH8/xe/Ple/vkkd/TWdIRwORwrT
8SbGJA5KfDU5TBZoYRtm0W1PCV8BelrmGtFBh9JXCbK2M3ETWFueyjSDO5oB
Czr9KNlFEwW9D6g8aeXyDfzdbAugKz1h6ndQ97jlQgPX0pwPsMzQl4eGXj5p
xCwlbresIAUMeHvtaWB08OQK3ejzm9PBeOLdR4/XRcIMsCpBoUStJdbyIpBn
c76gL6evTDWYNXOzhl4EWSe6MKk6XAcjK5YDqFYtKN3AXpQ+tfiCEtOywdsJ
Lh2buV2g3DTCopbMvLBukOvyqFD7kGK0Bzz37k2hsnHzIlpXpqX7YDGJiDsA
hyXCQjTW8ZcffkOJn8nW8G8p+WwdHkeFR9tRlS5Krlu4r7lu+BmdRd9ge8x8
veiOEuZ+9QvNnX4ITwZ/ePpa4zMl/60k8t0=
  "]],

Cell[BoxData[
 StyleBox["\<\"Warning: Non positive interaction order QED.\\n                \
This might reduce the efficiency of certain matrix element generators.\\n     \
           See logfile for more details.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0, 0],
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog2Ecx/EpTS4cYpLD1EKmmEMyp1YPLiwTNocih+SwtCZlRK3elhgJ
5RQWaUzkQpSaqEmaXrNNm2aaQk2r5wZZUZT//+LX5+rXV9A1IO8J4XA4Ytho
zPSkyEqJX57P5IJGtmkR3feU86Sgp22pGR2yVvtrQfb4Kr0FVMiETCt4oBk0
ovOPokM0Ob7fi1YKNmzv4O9uRwDdUIapP8DRxz0XGrCL8z/BKq2qEA21PWnS
WUrc7qKSDDDg6z/JBKODF7eoSfVmyAITic+MWnZS+dlgXZK0Gt0u35aVgTHH
zhf05fKVqQdzFxxb6E2QdaIrs91nO2BkzXoAHVbHV5iwFzUmlNxQMrOu9fWA
axYDtxesnBlnUWNOYVgfyHV5utGTEemEErz2Hc2hRVOGVbShapiaQQmJSDgF
dSJ+KRpn/SsOd1DyxuRpeHeUfLXrplD++X5UrYsSexv3tcANP72z7AfsjF1u
TL2nhHnY/EYL5r3haWDKkVahf6bkH6qu8qM=
  "]],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->CompressedData["
1:eJwVzVsog3EcxvEpbblwyKHlsAshFMOSzSH1x4U1cqbIITksrUkZUeptCdNC
OcWGNIfIhaxWE0XS9I5t2jTTFGp663+DKIry+108fa6evomd/bXdQTweTwob
iZyeFNsoCdRKmGzQxDYuoPvekmg56G1dbEIHbYpAFciaL1OawbqKNKYFPNAM
mNC5B/EhmiDs86FlievXb+DvbjuHrisF6ndw5GHPjXIOqeQDLB9T5aHB14+a
FJYSj0dWkApy/j5LOhjxdX6D7qhejRlgHPFb0bPtJFEmWB0vV6BbJVsVRWCk
2fWMPl+8MDVg9rxzE7V/sS50eabrZBsMqzRw6JBaWLqDvfDRtGI7JXrDmL8b
XD0z8nvAMv04i5qy8gS9IN/t7UItw/IJJXjlP5pFZTrjClpfPkStYDEJjT0G
tWJRIRpj+8sPcVLyyuRoom8p+WzT6lDR6X54lZsSRyv/JdcDvylX0Q/YEbXU
kHRHCXO/8Y3mzvlCkkHtGlM39UTJP61N8vU=
  "]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{927, 1028},
WindowMargins->{{80, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 218, 4, 27, "Input"],
Cell[778, 26, 484, 9, 27, "Input"],
Cell[CellGroupData[{
Cell[1287, 39, 169, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[1481, 46, 2273, 32, 20, "Print"],
Cell[3757, 80, 2548, 39, 20, "Print"],
Cell[6308, 121, 2327, 33, 20, "Print"],
Cell[8638, 156, 2259, 32, 20, "Print"],
Cell[10900, 190, 2272, 32, 20, "Print"],
Cell[13175, 224, 2322, 33, 20, "Print"],
Cell[15500, 259, 2324, 33, 20, "Print"],
Cell[17827, 294, 2259, 32, 20, "Print"],
Cell[20089, 328, 2289, 32, 20, "Print"],
Cell[22381, 362, 2258, 32, 20, "Print"],
Cell[24642, 396, 2328, 33, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[26997, 433, 1832, 27, 27, "Input"],
Cell[CellGroupData[{
Cell[28854, 464, 1930, 28, 27, "Input"],
Cell[CellGroupData[{
Cell[30809, 496, 1436, 20, 20, "Print"],
Cell[32248, 518, 1454, 20, 20, "Print"],
Cell[33705, 540, 1442, 20, 20, "Print"],
Cell[35150, 562, 1562, 24, 20, "Print"],
Cell[36715, 588, 1427, 20, 20, "Print"],
Cell[38145, 610, 1450, 20, 20, "Print"],
Cell[39598, 632, 1450, 20, 20, "Print"],
Cell[41051, 654, 1457, 20, 20, "Print"],
Cell[42511, 676, 1462, 21, 20, "Print"],
Cell[43976, 699, 1414, 20, 20, "Print"],
Cell[45393, 721, 1444, 20, 20, "Print"],
Cell[46840, 743, 1447, 20, 20, "Print"],
Cell[48290, 765, 1445, 20, 20, "Print"],
Cell[49738, 787, 1640, 26, 36, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51427, 819, 934, 14, 27, "Input"],
Cell[CellGroupData[{
Cell[52386, 837, 3504, 52, 20, "Print"],
Cell[55893, 891, 3508, 52, 20, "Print"],
Cell[59404, 945, 3041, 42, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62494, 993, 525, 8, 27, "Input"],
Cell[CellGroupData[{
Cell[63044, 1005, 1240, 21, 20, "Print"],
Cell[64287, 1028, 1236, 21, 20, "Print"],
Cell[65526, 1051, 1431, 28, 20, "Print"],
Cell[66960, 1081, 1182, 20, 20, "Print"],
Cell[68145, 1103, 1219, 21, 20, "Print"],
Cell[69367, 1126, 1177, 20, 20, "Print"],
Cell[70547, 1148, 1299, 24, 20, "Print"],
Cell[71849, 1174, 1187, 20, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73085, 1200, 545, 9, 27, "Input"],
Cell[CellGroupData[{
Cell[73655, 1213, 2254, 36, 20, "Print"],
Cell[75912, 1251, 2011, 28, 20, "Print"],
Cell[77926, 1281, 2191, 33, 20, "Print"],
Cell[80120, 1316, 2042, 29, 20, "Print"],
Cell[82165, 1347, 2523, 40, 20, "Print"],
Cell[84691, 1389, 2124, 32, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86864, 1427, 2219, 33, 27, "Input"],
Cell[CellGroupData[{
Cell[89108, 1464, 651, 12, 20, "Print"],
Cell[89762, 1478, 874, 19, 20, "Print"],
Cell[90639, 1499, 629, 11, 20, "Print"],
Cell[91271, 1512, 811, 16, 20, "Print"],
Cell[92085, 1530, 662, 12, 20, "Print"],
Cell[92750, 1544, 1143, 23, 20, "Print"],
Cell[93896, 1569, 744, 15, 20, "Print"],
Cell[94643, 1586, 973, 19, 20, "Print"],
Cell[95619, 1607, 643, 11, 20, "Print"],
Cell[96265, 1620, 910, 20, 20, "Print"],
Cell[97178, 1642, 864, 19, 20, "Print"],
Cell[98045, 1663, 863, 17, 20, "Print"],
Cell[98911, 1682, 856, 17, 20, "Print"],
Cell[99770, 1701, 626, 11, 20, "Print"],
Cell[100399, 1714, 873, 19, 20, "Print"],
Cell[101275, 1735, 873, 19, 20, "Print"],
Cell[102151, 1756, 873, 19, 20, "Print"],
Cell[103027, 1777, 873, 19, 20, "Print"],
Cell[103903, 1798, 873, 19, 20, "Print"],
Cell[104779, 1819, 873, 19, 20, "Print"],
Cell[105655, 1840, 873, 19, 20, "Print"],
Cell[106531, 1861, 873, 19, 20, "Print"],
Cell[107407, 1882, 873, 19, 20, "Print"],
Cell[108283, 1903, 873, 19, 20, "Print"],
Cell[109159, 1924, 873, 19, 20, "Print"],
Cell[110035, 1945, 873, 19, 20, "Print"],
Cell[110911, 1966, 650, 12, 20, "Print"],
Cell[111564, 1980, 841, 16, 20, "Print"],
Cell[112408, 1998, 998, 19, 20, "Print"],
Cell[113409, 2019, 622, 11, 20, "Print"],
Cell[114034, 2032, 995, 20, 51, "Print"],
Cell[115032, 2054, 607, 11, 20, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
