(* ****************************************************************** *)
(* *****                                                        ***** *)
(* *****  FeynRules model file: Effective Fermionic DM Model    ***** *)
(* *****  Author: A. E. Kuday, F. Ozok, U. Saka                 ***** *)
(* *****                                                        ***** *)
(* *****                                                        ***** *)
(* ****************************************************************** *)


(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "dm_eff_fermionic.fr";

M$Information = {
Authors      -> {"A. E. Kuday F. Ozok, U. Saka"},
Institutions -> {"Mimar Sinan Fine Arts University, Istanbul University"},
Emails       -> {"aelciboga@gmail.com"},
URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/DMEFT/",
References   -> {"H. Zhang et al., arXiv:0912.4511v2",
                "A. E. Kuday et al.},
Version      -> "1.0",
Date         -> "2018.07.26"
};

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 2018.xx.xx v1.0 - release version. *)

(***** Setting for interaction order (as e.g. used by MadGraph 5)  ******)

M$InteractionOrderLimit = {
{DMEFT, 2}
};

M$InteractionOrderHierarchy = {
{DMEFT, 1}
};


(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)

M$ClassesDescription = {

F[21] == {
ClassName        -> Xf,
SelfConjugate    -> False,
Mass             -> {MXf, 70},
Width            -> {MXf, 0},
PropagatorLabel  -> "Xf",
ParticleName     -> "Xf",
FullName         -> "Xf"}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* External parameters *)

Lambda  == {
ParameterType -> External,
ParameterName -> Lambda,
Value -> 2000,
TeX -> \[CapitalLambda],
Description -> "Scale of the new physics"
},

AlphauX == {
ParameterType -> External,
InteractionOrder -> {DMEFT, 1},
BlockName -> DMINPUTS,
TeX -> Subscript[Alpha,uX],
Description -> "Alpha-uX coupling"
},

AlphadX == {
ParameterType -> External,
InteractionOrder -> {DMEFT, 1},
BlockName -> DMINPUTS,
TeX -> Subscript[Alpha,dX],
Description -> "Alpha-dX coupling"
},

AlphaeX == {
ParameterType -> External,
InteractionOrder -> {DMEFT, 1},
BlockName -> DMINPUTS,
TeX -> Subscript[Alpha,eX],
Description -> "Alpha-eX coupling"
},

AlphaqX == {
ParameterType -> External,
InteractionOrder -> {DMEFT, 1},
BlockName -> DMINPUTS,
TeX -> Subscript[Alpha,qX],
Description -> "Alpha-qX coupling"
},

AlphalX == {
ParameterType -> External,
InteractionOrder -> {DMEFT, 1},
BlockName -> DMINPUTS,
TeX -> Subscript[Alpha,lX],
Description -> "Alpha-lX coupling"
},

AlphaPhiX == {
ParameterType -> External,
InteractionOrder -> {DMEFT, 1},
BlockName -> DMINPUTS,
TeX -> Subscript[Alpha,PhiX],
Description -> "Alpha-PhiX coupling"
},

(* Internal parameters *)

guR == {
ParameterType -> Internal,
InteractionOrder -> {DMEFT, 1},
TeX -> Subscript[g,uR],
Value -> AlphauX/2,
Description -> "Xf-uR coupling"},

gdR == {
ParameterType -> Internal,
InteractionOrder -> {DMEFT, 1},
TeX -> Subscript[g,dR],
Value -> AlphadX/2,
Description -> "Xf-dR coupling"},


geR == {
ParameterType -> Internal,
InteractionOrder -> {DMEFT, 1},
TeX -> Subscript[g,eR],
Value -> AlphaeX/2,
Description -> "Xf-eR coupling"},


gQl == {
ParameterType -> Internal,
InteractionOrder -> {DMEFT, 1},
TeX -> Subscript[g,QL],
Value -> -AlphaqX/2,
Description -> "Xf-Ql coupling"},

gLl == {
ParameterType -> Internal,
InteractionOrder -> {DMEFT, 1},
TeX -> Subscript[g,Ll],
Value -> -AlphalX/2,
Description -> "Xf-Ll coupling"}
};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LEff4f :=( AlphauX/4 Block[{sp1,sp2,sp3,sp4,mu,ff,cc}, (uRbar[sp1,ff,cc].uR[sp2,ff,cc] Ga[mu,sp1,sp2]) Xfbar[sp3].Xf[sp4] Ga[mu,sp3,sp4]] +
AlphadX/4  Block[{sp1,sp2,sp3,sp4,mu,ff,cc}, (dRbar[sp1,ff,cc].dR[sp2,ff,cc] Ga[mu,sp1,sp2]) Xfbar[sp3].Xf[sp4] Ga[mu,sp3,sp4]] +
AlphaeX/4  Block[{sp1,sp2,sp3,sp4,mu,ff}, (eRbar[sp1].eR[sp2] Ga[mu,sp1,sp2]) Xfbar[sp3].Xf[sp4] Ga[mu,sp3,sp4]] +
Block[{sp1,sp3,ii,ff,cc}, ExpandIndices[-AlphaqX/2 QLbar[sp1,ii,ff,cc].Xf[sp1] Xfbar[sp3].QL[sp3,ii,ff,cc] , FlavorExpand->{SU2D}];] +
Block[{sp1,sp3,ii,ff}, ExpandIndices[-AlphalX/2 LLbar[sp1,ii,ff].Xf[sp1] Xfbar[sp3].LL[sp3,ii,ff], FlavorExpand->{SU2D,SU2W}]] ) / Lambda^2;


LEffXfPhi := Block[{ii}, ExpandIndices[
I/Lambda^2 AlphaPhiX*(Phibar[ii] DC[Phi[ii],mu] - DC[Phibar[ii],mu] Phi[ii]) (Xfbar.Ga[mu].Xf),
FlavorExpand->{SU2D,SU2W}]];

LEffFDM :=  LEff4f + LEffXfPhi ;
