(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55795,       1206]
NotebookOptionsPosition[     48595,       1046]
NotebookOutlinePosition[     48990,       1063]
CellTagsIndexPosition[     48947,       1060]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", 
   "\"\</Users/miksi/AppData/Roaming/Mathematica/Applications/feynrules-\
current\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/SM\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.7699296857950644`*^9, 3.7699297151216035`*^9}, {
  3.770018677814289*^9, 3.770018683516034*^9}, {3.7700188623105717`*^9, 
  3.770018876381921*^9}},ExpressionUUID->"0708a221-1e85-4914-afcc-\
0affdce87cfe"],

Cell[BoxData["\<\"C:\\\\Users\\\\miksi\\\\AppData\\\\Roaming\\\\Mathematica\\\
\\Applications\\\\feynrules-current\"\>"], "Output",
 CellChangeTimes->{
  3.770018884618884*^9, 3.770026366290766*^9, 3.7700287207027664`*^9, 
   3.7700318797155466`*^9, {3.770032088753557*^9, 3.7700321405882206`*^9}, 
   3.7700322130020423`*^9, 3.7700338985417213`*^9, 3.7700349092303057`*^9, 
   3.770035774463673*^9, 3.77004599543388*^9, 3.7700492085244484`*^9, 
   3.770050202229926*^9, 3.770050489826527*^9, 3.7700505460397234`*^9, 
   3.770050932569648*^9, {3.7700509999504623`*^9, 3.7700510231042695`*^9}, {
   3.770963419780664*^9, 3.7709634469725323`*^9}, {3.7716584358604617`*^9, 
   3.7716584474280634`*^9}, 
   3.771659067508607*^9},ExpressionUUID->"2584ad75-06bf-4691-b51e-\
1e6145c4c1db"],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675463657`*^9},ExpressionUUID->"fbb2b292-6508-4b62-a62f-\
7849e472af4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"2.3.34\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"22 May 2019\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "2.3.34", " (" "22 May 2019", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675463657`*^9},ExpressionUUID->"b1c445e5-76bc-44c3-a9a8-\
c53ef3e0b398"],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675463657`*^9},ExpressionUUID->"abd080cc-78f1-4323-9885-\
3cd53809e107"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.771659067561984*^9},ExpressionUUID->"e6976d9c-7595-4662-a518-\
ff63617d3e89"],

Cell[BoxData["\<\"Please cite:\"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675677357`*^9},ExpressionUUID->"ecc02e49-3c43-4649-9b7f-\
7d1edb300262"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.185:2250-2300,2014 \
(arXiv:1310.1921);\"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675677357`*^9},ExpressionUUID->"c0b12cd2-290e-4015-a85b-\
d7d05706126d"],

Cell[BoxData["\<\"    - Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675677357`*^9},ExpressionUUID->"475c5d4b-f8ab-4a19-b5e2-\
e0362a422827"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675677357`*^9},ExpressionUUID->"5d9bd842-40de-439c-a3fd-\
d07a1f27eb27"],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.7716590675677357`*^9},ExpressionUUID->"e0a95798-9b3f-4f46-a5df-\
afae4905a0e2"],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.771659067583359*^9},ExpressionUUID->"5cac65c4-c76a-4765-af9d-\
949300ab637b"],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.7700188846498003`*^9, 3.7700263662977495`*^9, 3.770028720707753*^9, 
   3.770031879724521*^9, {3.770032088814395*^9, 3.770032140643078*^9}, 
   3.770032213009056*^9, 3.7700338985546937`*^9, 3.770034909239296*^9, 
   3.7700357744716625`*^9, 3.770045995439863*^9, 3.77004920857232*^9, 
   3.770050202282785*^9, 3.770050489830517*^9, 3.7700505460796175`*^9, 
   3.7700509326005745`*^9, {3.7700509999544525`*^9, 3.770051023111249*^9}, {
   3.770963419801607*^9, 3.7709634469805126`*^9}, {3.7716584359364696`*^9, 
   3.771658447472066*^9}, 
   3.771659067583359*^9},ExpressionUUID->"4816d7d1-74ba-4154-824b-\
33bd2fbc4a88"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chern-Simons Lagrangian", "Section",
 CellChangeTimes->{{3.770018943147238*^9, 3.7700189488479867`*^9}, {
  3.7709633802581882`*^9, 3.7709633806382055`*^9}, {3.771660160478606*^9, 
  3.771660160748828*^9}},ExpressionUUID->"8b2944ed-22b5-4602-a003-\
2dadb1cf0b3d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM.fr\>\"", ",", "\"\<Chern-Simons-Portal.fr\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Massless.rst\>\"", ",", "\"\<DiagonalCKM.rst\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"LCS", ":=", 
  RowBox[{
   RowBox[{"cW", " ", 
    RowBox[{"Eps", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], "]"}], 
    
    RowBox[{"W", "[", "\[Mu]", "]"}], " ", 
    RowBox[{"xb", "[", "\[Nu]", "]"}], 
    RowBox[{"del", "[", 
     RowBox[{
      RowBox[{"HC", "[", 
       RowBox[{"W", "[", "\[Alpha]", "]"}], "]"}], ",", "\[Beta]"}], "]"}]}], 
   "+", 
   RowBox[{"cW", " ", 
    RowBox[{"Eps", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], "]"}], 
    
    RowBox[{"HC", "[", 
     RowBox[{"W", "[", "\[Mu]", "]"}], "]"}], " ", 
    RowBox[{"xb", "[", "\[Nu]", "]"}], 
    RowBox[{"del", "[", 
     RowBox[{
      RowBox[{"W", "[", "\[Alpha]", "]"}], ",", "\[Beta]"}], "]"}]}], "+", 
   RowBox[{"cZ", " ", 
    RowBox[{"Eps", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], "]"}], 
    
    RowBox[{"Z", "[", "\[Mu]", "]"}], " ", 
    RowBox[{"xb", "[", "\[Nu]", "]"}], 
    RowBox[{"del", "[", 
     RowBox[{
      RowBox[{"Z", "[", "\[Alpha]", "]"}], ",", "\[Beta]"}], "]"}]}], "+", 
   RowBox[{"cZgamma", " ", 
    RowBox[{"Eps", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], "]"}], 
    
    RowBox[{"Z", "[", "\[Mu]", "]"}], " ", 
    RowBox[{"xb", "[", "\[Nu]", "]"}], 
    RowBox[{"del", "[", 
     RowBox[{
      RowBox[{"Z", "[", "\[Alpha]", "]"}], ",", "\[Beta]"}], "]"}]}], "+", 
   RowBox[{"Cmu", " ", 
    RowBox[{"xb", "[", "\[Nu]", "]"}], 
    RowBox[{"mubar", ".", 
     RowBox[{"Ga", "[", "\[Nu]", "]"}], ".", 
     RowBox[{"Ga", "[", "5", "]"}], ".", "mu"}]}], "+", 
   RowBox[{
    FractionBox[
     SuperscriptBox["Mxb", "2"], "2"], 
    RowBox[{"xb", "[", "\[Nu]", "]"}], 
    RowBox[{"xb", "[", "\[Nu]", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"del", "[", 
       RowBox[{
        RowBox[{"xb", "[", "\[Mu]", "]"}], ",", "\[Nu]"}], "]"}], "-", 
      RowBox[{"del", "[", 
       RowBox[{
        RowBox[{"xb", "[", "\[Nu]", "]"}], ",", "\[Mu]"}], "]"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"del", "[", 
       RowBox[{
        RowBox[{"xb", "[", "\[Mu]", "]"}], ",", "\[Nu]"}], "]"}], "-", 
      RowBox[{"del", "[", 
       RowBox[{
        RowBox[{"xb", "[", "\[Nu]", "]"}], ",", "\[Mu]"}], "]"}]}], 
     ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"CheckHermiticity", "[", "LCS", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FeynmanGauge", "\[Rule]", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", "+", "LCS"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FeynmanRules", "[", "LCS", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CheckMassSpectrum", "[", "LCS", "]"}]}], "Input",
 CellChangeTimes->{{3.7700189562442236`*^9, 3.7700191587633967`*^9}, {
  3.770019247701813*^9, 3.7700193086497188`*^9}, {3.7700193567779555`*^9, 
  3.770019394678585*^9}, {3.770020411712239*^9, 3.77002042281653*^9}, {
  3.770020549244278*^9, 3.770020552564395*^9}, {3.770020609944874*^9, 
  3.770020617893608*^9}, {3.7700207091119576`*^9, 3.7700208667985945`*^9}, {
  3.7700213240982018`*^9, 3.7700213566351824`*^9}, {3.77002140374516*^9, 
  3.7700214779929557`*^9}, {3.7700216056020727`*^9, 3.7700216517685575`*^9}, {
  3.770050483069606*^9, 3.7700504845586214`*^9}, {3.7709633478498116`*^9, 
  3.770963362999318*^9}, {3.771658539438449*^9, 3.7716585448172464`*^9}, {
  3.7716585865161314`*^9, 
  3.7716586059277987`*^9}},ExpressionUUID->"900d4461-aeba-47bc-8179-\
81878652e795"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659071600277*^9},ExpressionUUID->"1d6fc101-fb15-4463-b37a-\
916e2517a433"],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590716362786`*^9},ExpressionUUID->"3e165d0c-4210-4060-afaa-\
0edb4381bf37"],

Cell[BoxData["\<\"M.Ovchynnikov\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659071640274*^9},ExpressionUUID->"9b60cd0e-adb7-437d-8a62-\
b88afd43f10a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0\"\>"}],
  SequenceForm["Model Version: ", "1.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659071644276*^9},ExpressionUUID->"bbae8cd4-92fc-497b-8654-\
ab2ea17fa74b"],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590716482787`*^9},ExpressionUUID->"7108e137-3426-4e3c-b8c9-\
9cd03a5da0a4"],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590716562967`*^9},ExpressionUUID->"5d90bb4f-c4c3-48e2-b3fd-\
7c3eb66846e3"],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590716602755`*^9},ExpressionUUID->"882f7885-0842-46c5-9ad5-\
5deb7ddda685"],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659071792019*^9},ExpressionUUID->"07ae89bb-6288-4cd5-aba6-\
f3fecfae20d7"],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590717960157`*^9},ExpressionUUID->"ae3d7c99-9d23-47fb-95cf-\
914510f3b122"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"ChernSimons\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "ChernSimons", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659071900015*^9},ExpressionUUID->"f594271d-f11d-4078-8323-\
087810f853c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"Massless.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{10., {0., 12.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "18"}],
  SequenceForm["Loading restrictions from ", "Massless.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 18],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659072841994*^9},ExpressionUUID->"23f840b4-1fac-49d7-902a-\
de61c1fe5bae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loading restrictions from \"\>", 
   "\[InvisibleSpace]", "\<\"DiagonalCKM.rst\"\>", 
   "\[InvisibleSpace]", "\<\" : \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`FR$restrictionCounter, StandardForm],
    ImageSizeCache->{10., {0., 12.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["Loading restrictions from ", "DiagonalCKM.rst", " : ", 
   Dynamic[PRIVATE`FR$restrictionCounter], " / ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590730281677`*^9},ExpressionUUID->"babc7bb3-8a84-4ecb-a061-\
32b66cce0eca"],

Cell[BoxData["\<\"Restrictions loaded.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590731561704`*^9},ExpressionUUID->"67aa327e-1799-4879-b2cb-\
07003dcc3658"],

Cell[BoxData["\<\"Checking for hermiticity by calculating the Feynman rules \
contained in L-HC[L].\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659073196169*^9},ExpressionUUID->"1a6335fb-3326-4b68-a7e1-\
d1c7a24dba72"],

Cell[BoxData["\<\"If the lagrangian is hermitian, then the number of vertices \
should be zero.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659073204173*^9},ExpressionUUID->"c6adb990-5f52-4ffa-b96c-\
fe67a27c0651"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590735241704`*^9},ExpressionUUID->"63cf4728-d6fa-44cf-9cbe-\
e9e289be8458"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590735281687`*^9},ExpressionUUID->"11cbe5f2-952d-4ade-a132-\
71db5214f9ad"],

Cell[BoxData["\<\"No vertices found.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590735321712`*^9},ExpressionUUID->"acaab19b-eafe-40dd-81e2-\
354003693d40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[0, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590735401692`*^9},ExpressionUUID->"ba35ddb3-2d7a-4db3-994d-\
f42f49201704"],

Cell[BoxData["\<\"The lagrangian is hermitian.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590735441685`*^9},ExpressionUUID->"0b93fd14-080f-430c-b70d-\
fb0271972095"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.771658987677289*^9, 
  3.771659073548171*^9},ExpressionUUID->"b896ecd7-5873-4fdc-98ea-\
2443412e2b2b"],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659076296605*^9},ExpressionUUID->"d8eb7552-1fe8-424b-9fd4-\
92181578a500"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590766674204`*^9},ExpressionUUID->"2b7d686d-88cc-4c4f-a362-\
792d5be7ec7a"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659076669442*^9},ExpressionUUID->"bb1038a7-14a7-4708-b066-\
24b9dbcb38cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590766795483`*^9},ExpressionUUID->"1b1e6491-0e8b-4c07-b337-\
61bee43fd3f0"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590857077036`*^9},ExpressionUUID->"71efb46d-0ca1-4729-896c-\
b6eec9d71cb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "101", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been \
found -> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{10., {0., 12.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "101", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  101, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 101, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659085801607*^9},ExpressionUUID->"36d5d78b-1444-415e-b73e-\
e9a8fbc60454"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"96", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[96, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590914926147`*^9},ExpressionUUID->"e7595139-4e1e-46fb-aa71-\
7a380fa7fd92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{20., {0., 12.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "96"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 96],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716590950037527`*^9},ExpressionUUID->"f6b736b6-4348-4a9e-99d8-\
d5c429a08c06"],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591009803276`*^9},ExpressionUUID->"06d5d6ff-da08-4fd0-9652-\
4f1f96b9ef8a"],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591010283084`*^9},ExpressionUUID->"0f5a82ed-e028-453f-82ad-\
b00ab757e1b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{20., {0., 12.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "43"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 43],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591010718985`*^9},ExpressionUUID->"2fe75a04-7a61-476b-b361-\
42f329f0a19b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "2.21875`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 2.21875, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.77165911251306*^9},ExpressionUUID->"cce4b2a1-cbb4-4639-8e0e-211b868445b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", 
   "0.015625`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.015625, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591125530577`*^9},ExpressionUUID->"8d31a23f-6be0-45c4-b5ab-\
932f117fa391"],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591125634604`*^9},ExpressionUUID->"ace19c51-aa18-44d2-9966-\
e0e662dd2361"],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659112701269*^9},ExpressionUUID->"da24c3fd-4359-4c59-aca7-\
834c6e9fa023"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591127372704`*^9},ExpressionUUID->"fb3cf851-00fb-4bbf-9a20-\
d9d8f71de672"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{30., {0., 12.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "122", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 122, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659114801661*^9},ExpressionUUID->"2c126e44-5b10-471a-ae7e-\
bd4c251dafbb"],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659114948775*^9},ExpressionUUID->"dff2f723-4f9a-4d4c-ac9c-\
61cf03c66c1e"],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591152495604`*^9},ExpressionUUID->"3c1e0bea-2f75-493e-ae4f-\
aaa025ce6b40"],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591152575617`*^9},ExpressionUUID->"11e8e8e7-3852-4fa2-96a6-\
fba49a3b5fef"],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.77165911526156*^9},ExpressionUUID->"6aaeee7e-f6f6-4ccb-883f-bd8cd41622c0"],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659115413562*^9},ExpressionUUID->"b732fd47-918a-40c8-85dd-\
bfe85508b742"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{10., {0., 12.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  3, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 3, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591154215603`*^9},ExpressionUUID->"deec0945-3fbf-4c87-823a-\
f89ecce2ccfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[3, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659115569034*^9},ExpressionUUID->"cd88433b-9c5b-454f-b473-\
5c97f05a5a4c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"W", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["W", "\[Dagger]"], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"xb", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "cW"}], " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"]}], "+", 
      RowBox[{"cW", " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xb", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Z", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "cZ"}], " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], "-", 
      RowBox[{"cZgamma", " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], "+", 
      RowBox[{"cZ", " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}], "+", 
      RowBox[{"cZgamma", " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         OverscriptBox["mu", "\<\"-\"\>"], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"mu", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"xb", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"\[ImaginaryI]", " ", "Cmu", " ", 
      SubscriptBox[
       RowBox[{
        TemplateBox[{"\[Gamma]",SubscriptBox["\"\[Mu]\"", "3"]},
         "Superscript"], ".", 
        TemplateBox[{"\[Gamma]","5"},
         "Superscript"]}], 
       RowBox[{
        SubscriptBox["\<\"s\"\>", "1"], ",", 
        SubscriptBox["\<\"s\"\>", "2"]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.771658987677289*^9, 
  3.771659115581035*^9},ExpressionUUID->"699a56d5-5009-4353-9332-\
4e50d024f36f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "2", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659115717035*^9},ExpressionUUID->"17f9ab24-e34d-43d4-9bff-\
3d495d7eccf6"],

Cell[BoxData["\<\"All mass terms are diagonal.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659115717035*^9},ExpressionUUID->"9f6517e6-241f-40e4-a8e4-\
3fdb18484161"],

Cell[BoxData["\<\"Getting mass spectrum.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.7716591158570366`*^9},ExpressionUUID->"df2ea49e-9d88-41b7-a89d-\
61afbffd5131"],

Cell[BoxData["\<\"Checking for less then 0.1% agreement with model file \
values.\"\>"], "Print",
 CellChangeTimes->{3.7700216522841816`*^9, 3.770026399829214*^9, 
  3.7700287621778016`*^9, 3.770031899874612*^9, 3.7700322352874136`*^9, 
  3.7700339211592064`*^9, 3.7700349207445*^9, 3.7700357877112317`*^9, 
  3.770046004513585*^9, 3.770049223728769*^9, 3.770050221265997*^9, 
  3.77005055587042*^9, 3.770051053461372*^9, 3.771658985795362*^9, 
  3.771659115865037*^9},ExpressionUUID->"a2ae73b0-ca49-45ae-919c-\
6d24d9883195"]
}, Open  ]],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Particle\"\>", "\<\"Analytic value\"\>", "\<\"Numerical value\"\>", \
"\<\"Model-file value\"\>"},
    {"xb", 
     SqrtBox[
      SuperscriptBox["Mxb", "2"]], "1.`", "1.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.771658987677289*^9, 
  3.7716591158690357`*^9},ExpressionUUID->"7942bc2c-61fb-4553-87ca-\
2fc151605884"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1500, 917},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
ShowSelection->True,
Magnification:>1.6 Inherited,
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (March 13, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 761, 16, 109, "Input", "ExpressionUUID" -> \
"0708a221-1e85-4914-afcc-0affdce87cfe"],
Cell[1331, 40, 782, 12, 48, "Output", "ExpressionUUID" -> \
"2584ad75-06bf-4691-b51e-1e6145c4c1db"],
Cell[CellGroupData[{
Cell[2138, 56, 694, 11, 34, "Print", "ExpressionUUID" -> \
"fbb2b292-6508-4b62-a62f-7849e472af4b"],
Cell[2835, 69, 965, 18, 34, "Print", "ExpressionUUID" -> \
"b1c445e5-76bc-44c3-a9a8-c53ef3e0b398"],
Cell[3803, 89, 746, 12, 34, "Print", "ExpressionUUID" -> \
"abd080cc-78f1-4323-9885-3cd53809e107"],
Cell[4552, 103, 678, 11, 34, "Print", "ExpressionUUID" -> \
"e6976d9c-7595-4662-a518-ff63617d3e89"],
Cell[5233, 116, 691, 11, 34, "Print", "ExpressionUUID" -> \
"ecc02e49-3c43-4649-9b7f-7d1edb300262"],
Cell[5927, 129, 743, 12, 34, "Print", "ExpressionUUID" -> \
"c0b12cd2-290e-4015-a85b-d7d05706126d"],
Cell[6673, 143, 743, 12, 34, "Print", "ExpressionUUID" -> \
"475c5d4b-f8ab-4a19-b5e2-e0362a422827"],
Cell[7419, 157, 680, 11, 34, "Print", "ExpressionUUID" -> \
"5d9bd842-40de-439c-a3fd-d07a1f27eb27"],
Cell[8102, 170, 710, 11, 34, "Print", "ExpressionUUID" -> \
"e0a95798-9b3f-4f46-a5df-afae4905a0e2"],
Cell[8815, 183, 678, 11, 34, "Print", "ExpressionUUID" -> \
"5cac65c4-c76a-4765-af9d-949300ab637b"],
Cell[9496, 196, 745, 12, 34, "Print", "ExpressionUUID" -> \
"4816d7d1-74ba-4154-824b-33bd2fbc4a88"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10290, 214, 269, 4, 113, "Section", "ExpressionUUID" -> \
"8b2944ed-22b5-4602-a003-2dadb1cf0b3d"],
Cell[CellGroupData[{
Cell[10584, 222, 3851, 97, 435, "Input", "ExpressionUUID" -> \
"900d4461-aeba-47bc-8179-81878652e795"],
Cell[CellGroupData[{
Cell[14460, 323, 485, 7, 34, "Print", "ExpressionUUID" -> \
"1d6fc101-fb15-4463-b37a-916e2517a433"],
Cell[14948, 332, 505, 7, 34, "Print", "ExpressionUUID" -> \
"3e165d0c-4210-4060-afaa-0edb4381bf37"],
Cell[15456, 341, 476, 7, 34, "Print", "ExpressionUUID" -> \
"9b60cd0e-adb7-437d-8a62-b88afd43f10a"],
Cell[15935, 350, 609, 11, 34, "Print", "ExpressionUUID" -> \
"bbae8cd4-92fc-497b-8654-ab2ea17fa74b"],
Cell[16547, 363, 513, 8, 34, "Print", "ExpressionUUID" -> \
"7108e137-3426-4e3c-b8c9-9cd03a5da0a4"],
Cell[17063, 373, 465, 7, 34, "Print", "ExpressionUUID" -> \
"5d90bb4f-c4c3-48e2-b3fd-7c3eb66846e3"],
Cell[17531, 382, 495, 7, 34, "Print", "ExpressionUUID" -> \
"882f7885-0842-46c5-9ad5-5deb7ddda685"],
Cell[18029, 391, 496, 7, 34, "Print", "ExpressionUUID" -> \
"07ae89bb-6288-4cd5-aba6-f3fecfae20d7"],
Cell[18528, 400, 496, 7, 34, "Print", "ExpressionUUID" -> \
"ae3d7c99-9d23-47fb-95cf-914510f3b122"],
Cell[19027, 409, 669, 12, 63, "Print", "ExpressionUUID" -> \
"f594271d-f11d-4078-8323-087810f853c5"],
Cell[19699, 423, 951, 17, 34, "Print", "ExpressionUUID" -> \
"23f840b4-1fac-49d7-902a-de61c1fe5bae"],
Cell[20653, 442, 957, 17, 34, "Print", "ExpressionUUID" -> \
"babc7bb3-8a84-4ecb-a061-32b66cce0eca"],
Cell[21613, 461, 485, 7, 34, "Print", "ExpressionUUID" -> \
"67aa327e-1799-4879-b2cb-07003dcc3658"],
Cell[22101, 470, 544, 8, 34, "Print", "ExpressionUUID" -> \
"1a6335fb-3326-4b68-a7e1-d1c7a24dba72"],
Cell[22648, 480, 540, 8, 34, "Print", "ExpressionUUID" -> \
"c6adb990-5f52-4ffa-b96c-fe67a27c0651"],
Cell[23191, 490, 737, 15, 34, "Print", "ExpressionUUID" -> \
"63cf4728-d6fa-44cf-9cbe-e9e289be8458"],
Cell[23931, 507, 492, 7, 34, "Print", "ExpressionUUID" -> \
"11cbe5f2-952d-4ade-a132-71db5214f9ad"],
Cell[24426, 516, 483, 7, 34, "Print", "ExpressionUUID" -> \
"acaab19b-eafe-40dd-81e2-354003693d40"],
Cell[24912, 525, 605, 11, 34, "Print", "ExpressionUUID" -> \
"ba35ddb3-2d7a-4db3-994d-f42f49201704"],
Cell[25520, 538, 493, 7, 34, "Print", "ExpressionUUID" -> \
"0b93fd14-080f-430c-b70d-fb0271972095"]
}, Open  ]],
Cell[26028, 548, 169, 4, 48, "Output", "ExpressionUUID" -> \
"b896ecd7-5873-4fdc-98ea-2443412e2b2b"],
Cell[CellGroupData[{
Cell[26222, 556, 512, 8, 34, "Print", "ExpressionUUID" -> \
"d8eb7552-1fe8-424b-9fd4-92181578a500"],
Cell[26737, 566, 737, 15, 34, "Print", "ExpressionUUID" -> \
"2b7d686d-88cc-4c4f-a362-792d5be7ec7a"],
Cell[27477, 583, 490, 7, 34, "Print", "ExpressionUUID" -> \
"bb1038a7-14a7-4708-b066-24b9dbcb38cd"],
Cell[27970, 592, 674, 12, 34, "Print", "ExpressionUUID" -> \
"1b1e6491-0e8b-4c07-b337-61bee43fd3f0"],
Cell[28647, 606, 525, 8, 34, "Print", "ExpressionUUID" -> \
"71efb46d-0ca1-4729-896c-b6eec9d71cb4"],
Cell[29175, 616, 1009, 19, 34, "Print", "ExpressionUUID" -> \
"36d5d78b-1444-415e-b73e-e9a8fbc60454"],
Cell[30187, 637, 607, 11, 34, "Print", "ExpressionUUID" -> \
"e7595139-4e1e-46fb-aa71-7a380fa7fd92"],
Cell[30797, 650, 962, 18, 34, "Print", "ExpressionUUID" -> \
"f6b736b6-4348-4a9e-99d8-d5c429a08c06"],
Cell[31762, 670, 506, 7, 34, "Print", "ExpressionUUID" -> \
"06d5d6ff-da08-4fd0-9652-4f1f96b9ef8a"],
Cell[32271, 679, 773, 16, 34, "Print", "ExpressionUUID" -> \
"0f5a82ed-e028-453f-82ad-b00ab757e1b7"],
Cell[33047, 697, 728, 15, 34, "Print", "ExpressionUUID" -> \
"2fe75a04-7a61-476b-b361-42f329f0a19b"],
Cell[33778, 714, 698, 11, 34, "Print", "ExpressionUUID" -> \
"cce4b2a1-cbb4-4639-8e0e-211b868445b4"],
Cell[34479, 727, 691, 12, 34, "Print", "ExpressionUUID" -> \
"8d31a23f-6be0-45c4-b5ab-932f117fa391"],
Cell[35173, 741, 489, 7, 34, "Print", "ExpressionUUID" -> \
"ace19c51-aa18-44d2-9966-e0e662dd2361"],
Cell[35665, 750, 511, 8, 34, "Print", "ExpressionUUID" -> \
"da24c3fd-4359-4c59-aca7-834c6e9fa023"],
Cell[36179, 760, 704, 12, 34, "Print", "ExpressionUUID" -> \
"fb3cf851-00fb-4bbf-9a20-d9d8f71de672"],
Cell[36886, 774, 862, 15, 34, "Print", "ExpressionUUID" -> \
"2c126e44-5b10-471a-ae7e-bd4c251dafbb"],
Cell[37751, 791, 483, 7, 34, "Print", "ExpressionUUID" -> \
"dff2f723-4f9a-4d4c-ac9c-61cf03c66c1e"],
Cell[38237, 800, 470, 7, 34, "Print", "ExpressionUUID" -> \
"3c1e0bea-2f75-493e-ae4f-aaa025ce6b40"],
Cell[38710, 809, 737, 15, 34, "Print", "ExpressionUUID" -> \
"11e8e8e7-3852-4fa2-96a6-fba49a3b5fef"],
Cell[39450, 826, 487, 6, 34, "Print", "ExpressionUUID" -> \
"6aaeee7e-f6f6-4ccb-883f-bd8cd41622c0"],
Cell[39940, 834, 523, 8, 34, "Print", "ExpressionUUID" -> \
"b732fd47-918a-40c8-85dd-bfe85508b742"],
Cell[40466, 844, 1003, 19, 34, "Print", "ExpressionUUID" -> \
"deec0945-3fbf-4c87-823a-f89ecce2ccfe"],
Cell[41472, 865, 603, 11, 34, "Print", "ExpressionUUID" -> \
"cd88433b-9c5b-454f-b473-5c97f05a5a4c"]
}, Open  ]],
Cell[42090, 879, 3397, 93, 137, "Output", "ExpressionUUID" -> \
"699a56d5-5009-4353-9332-4e50d024f36f"],
Cell[CellGroupData[{
Cell[45512, 976, 714, 13, 34, "Print", "ExpressionUUID" -> \
"17f9ab24-e34d-43d4-9bff-3d495d7eccf6"],
Cell[46229, 991, 491, 7, 34, "Print", "ExpressionUUID" -> \
"9f6517e6-241f-40e4-a8e4-3fdb18484161"],
Cell[46723, 1000, 487, 7, 34, "Print", "ExpressionUUID" -> \
"df2ea49e-9d88-41b7-a89d-61afbffd5131"],
Cell[47213, 1009, 526, 8, 34, "Print", "ExpressionUUID" -> \
"a2ae73b0-ca49-45ae-919c-6d24d9883195"]
}, Open  ]],
Cell[47754, 1020, 813, 22, 102, "Output", "ExpressionUUID" -> \
"7942bc2c-61fb-4553-87ca-2fc151605884"]
}, Open  ]]
}, Open  ]]
}
]
*)

